(function (win) {
    var path = require("path");
    var fs = require("fs");
    var http = require("http");
    var exec = require("child_process").exec;
    var schedule = require("node-schedule");
    var url = require("url");
    var Curl = require("node-libcurl").Curl;

    var _basePath = path.dirname(process.execPath);
    var aucPath = path.join(_basePath, "upgrade/auc.ini");
    var wgetPath = path.join(_basePath, "tools/wget.exe");

    var downloading = false;

    var parseINIString = function (data) {
        var regex = {
            section: /^\s*\[\s*([^\]]*)\s*\]\s*$/,
            param: /^\s*([\w\.\-\_]+)\s*=\s*(.*?)\s*$/,
            comment: /^\s*;.*$/
        };
        var value = {};
        var lines = data.split(/\r\n|\r|\n/);
        var section = null;
        lines.forEach(function (line) {
            if (regex.comment.test(line)) {
                return;
            } else if (regex.param.test(line)) {
                var match = line.match(regex.param);
                if (section) {
                    value[section][match[1]] = match[2];
                } else {
                    value[match[1]] = match[2];
                }
            } else if (regex.section.test(line)) {
                var match = line.match(regex.section);
                value[match[1]] = {};
                section = match[1];
            } else if (line.length == 0 && section) {
                // section = null;
            };
        });
        return value;
    };

    var versionUpdata = function () {
        fs.readFile(aucPath, function (err, data) {
            var iniContent = parseINIString(data.toString());
            var remote = iniContent.Local.ServerUrl + "?ver=" + iniContent.Product.Version + "&pro=" + iniContent.Product.Name + "&multi=true";
            console.log(iniContent, remote);
            //
            var curl = new Curl();
            curl.setOpt('URL', remote);
            curl.setOpt(Curl.option.FOLLOWLOCATION, 1);
            curl.perform();
            curl.on('end', function (statusCode, body, headers) {
                try {
                    var upgradeInfos = JSON.parse(body);
                    upgradeInfos.sort(function (a, b) {
                        return a.ver < b.ver;
                    })
                    console.log(upgradeInfos);
                    if (upgradeInfos.length > 0) {
                        var newVersion = upgradeInfos[0];
                        var md5 = newVersion.md5;
                        var size = newVersion.size;
                        // var pkg = path.join(process.env.TEMP,md5 + ".exe") ;
                        // 王哒哒修改
                        var pkgName = (md5 || Date.now()) + ".exe";
                        var pkg = path.join(_basePath, pkgName);
                        var pkgRelativePath = pkgName;
                        //
                        var sectionOption = {
                            url: newVersion.pkg,
                            file: pkg,
                            timeout: 15,
                            connect_timeout: 5
                        };
                        //
                        var flag = path.join(_basePath, "setup.flag");
                        if (fs.existsSync(flag)) {
                            fs.unlinkSync(flag);
                        }
                        var isPkgExist = fs.existsSync(pkg);
                        if (downloading && !isPkgExist) {
                            downloading = false;
                        }
                        //
                        if (isPkgExist) {
                            fs.stat(pkg, function (err, stats) {
                                if (!err) {
                                    if (stats.size < (parseInt(size) * 1024)) {
                                        //
                                        if (!downloading) {
                                            downloading = true;
                                            //
                                            var section = new win.global_DownloadSection(sectionOption);
                                            section.resume({
                                                sectionOption: sectionOption,
                                                hasDownload: stats.size
                                            }).then(function () {
                                                console.log("download success");
                                                downloading = false;
                                                fs.writeFile(flag, pkgRelativePath);
                                                section.close();
                                            }, function (err) {
                                                console.log(err);
                                                downloading = false;
                                                section.close();
                                            }, function (progress) {
                                                //pass
                                            });
                                        }
                                    } else {
                                        downloading = false;
                                        fs.writeFile(flag, pkgRelativePath);
                                    }
                                } else {
                                    //
                                    downloading = true;
                                    //
                                    fs.unlinkSync(sectionOption.file);
                                    var section = new win.global_DownloadSection(sectionOption);
                                    section.download().then(function () {
                                        console.log("download success");
                                        downloading = false;
                                        fs.writeFile(flag, pkgRelativePath);
                                        section.close();
                                    }, function (err) {
                                        console.log(err);
                                        downloading = false;
                                        section.close();
                                    }, function (progress) {
                                        //pass
                                    });
                                }
                            })
                        } else {
                            downloading = true;
                            //
                            var section = new win.global_DownloadSection(sectionOption);
                            section.download().then(function () {
                                console.log("download success");
                                downloading = false;
                                fs.writeFile(flag, pkgRelativePath);
                                section.close();
                            }, function (err) {
                                console.log(err);
                                downloading = false;
                                section.close();
                            }, function (progress) {
                                //pass
                            });
                        }
                    } else {
                        downloading = false;
                        //
                        if (fs.existsSync(flag)) {
                            fs.unlinkSync(flag);
                        }
                    }
                } catch (e) {
                    console.log(e);
                    downloading = false;
                }
            });

            curl.on('error', function (err, curlErrCode) {
                this.close();
                console.log(err, curlErrCode);
            });
        });
    };

    versionUpdata();
    //
    var rule = new schedule.RecurrenceRule();

    rule.minute = new schedule.Range(0, 59, 5);

    var j = schedule.scheduleJob(rule, function () {
        //
        console.log("schedule check version update：" + new Date(Date.now()));
        //
        versionUpdata();
    });

})(window);