/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/19 11:55
 * description :
 */
;
(function (win) {

    var Curl = require("node-libcurl").Curl;
    var fs = require('fs');
    var crypto = require('crypto');

    var CurlTransfer = function () {
        var curl = new Curl();
        var useragent = "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36";

        this.getMD5 = function (filepath) {
            //读取一个Buffer
            var buffer = fs.readFileSync(filepath);
            var fsHash = crypto.createHash('md5');

            fsHash.update(buffer);
            var md5 = fsHash.digest('hex');
            return md5;
        };

        this.getDownloadFileLength = function (url, callback) {
            curl.setOpt('URL', url);
            curl.setOpt(Curl.option.HEADER, 1);
            curl.setOpt(Curl.option.NOBODY, 1);
            curl.perform();
            curl.on('end', function (statusCode, body, headers) {
                callback.apply(this, [this.getInfo("CONTENT_LENGTH_DOWNLOAD")])
                this.close();
            });

            curl.on('error', function (err, curlErrCode) {
                callback.apply(this, [-1]);
                this.close();
            });
        };

        this.chunkDownload = function (option) {
            if (!(typeof(option.url) === "undefined" || typeof(option.file) === "undefined")) {
                this.getDownloadFileLength(option.url, function (length) {
                    console.log(length);
                    if (typeof option.chunk == "undefined") {
                        option.chunk = length;
                    }
                    var count = Math.floor((length + option.chunk - 1) / option.chunk);
                    var ranges = [];
                    var current = 0;
                    for (var i = 0; i < count; i++) {
                        var chunkLenth = 0;
                        var left = length - option.chunk - current;
                        if (left > 0) {
                            chunkLenth = option.chunk
                        }
                        else {
                            chunkLenth = length - current;
                        }
                        var startPos = current == 0 ? current : current + 1;
                        var endPos = current + chunkLenth;
                        ranges.push(startPos + "-" + endPos);
                        current += chunkLenth;
                    }
                    ranges.forEach(function (range, idx) {
                        (function () {
                            var chunkCurl = new Curl();
                            var chunkFile = option.file + "." + idx;
                            chunkCurl.setOpt('URL', option.url);
                            chunkCurl.setOpt(Curl.option.RANGE, range);
                            // This is the same than the data event, however,
                            // keep in mind that here the return value is considered.
                            chunkCurl.setOpt(Curl.option.WRITEFUNCTION, function (data) {
                                fs.appendFileSync(chunkFile, data);
                                return data.length;
                            });
                            chunkCurl.on('end', function () {
                                chunkCurl.close.bind(chunkCurl);
                            });
                            chunkCurl.on('error', function (err) {
                                chunkCurl.close.bind(chunkCurl);
                            });
                            chunkCurl.perform();
                        })(range, idx);
                    })
                })
            }
        };

        this.download = function (option) {
            if (!(typeof(option.url) === "undefined" || typeof(option.file) === "undefined")) {
                curl.setOpt('URL', option.url);
                curl.setOpt(Curl.option.NOPROGRESS, false);
                curl.enable(Curl.feature.NO_STORAGE);
                if (option.range) {
                    curl.setOpt(Curl.option.RANGE, option.range);
                }
                curl.setProgressCallback(function (dltotal, dlnow/*, ultotal, ulnow*/) {
                    if (dltotal === 0) {
                        return 0;
                    }
                    if (typeof(option.processCallback) != "undefined") {
                        option.processCallback.apply(this, [dltotal, dlnow]);
                    }
                    return 0;
                });
                // This is the same than the data event, however,
                // keep in mind that here the return value is considered.
                curl.setOpt(Curl.option.WRITEFUNCTION, function (chunk) {
                    fs.appendFileSync(option.file, chunk);
                    return chunk.length;
                });
                curl.on('end', function () {
                    curl.close.bind(curl);
                    if (typeof(option.onend) != "undefined") {
                        option.onend.apply(this, []);
                    }
                });
                curl.on('error', function (err) {
                    curl.close.bind(curl);
                    if (typeof(option.onerror) != "undefined") {
                        option.onerror.apply(this, [err]);
                    }
                });
                curl.perform();
            }
        };

        this.upload = function (option) {
            if (!(typeof(option.url) === "undefined" || typeof(option.data) === "undefined")) {
                curl.setOpt(Curl.option.URL, option.url);
                curl.setOpt(Curl.option.HTTPPOST, option.data);
                curl.setOpt(Curl.option.VERBOSE, true);
                curl.setOpt(Curl.option.NOPROGRESS, !option.showProcess);
                curl.setProgressCallback(function (dltotal, dlnow, ultotal, ulnow) {
                    if (ultotal === 0) {
                        return 0;
                    }
                    if (typeof(option.processCallback) != "undefined") {
                        option.processCallback.apply(this, [ultotal, ulnow,option.id]);
                    }
                    return 0;
                });
                curl.perform();

                curl.on('end', function (statusCode, body) {
                    console.log(body);
                    this.close();
                    if (typeof(option.onend) != "undefined") {
                        option.onend.apply(this, [statusCode, body]);
                    }
                });

                curl.on('error', function (err) {
                    this.close();
                    if (typeof(option.onerror) != "undefined") {
                        option.onerror.apply(this, [err]);
                    }
                });
                return true;
            }
            else {
                return false;
            }
        };
    };
    win.global_CurlTransfer = CurlTransfer;
})(window);