/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/9 9:19
 * description :
 */

;

(function (win) {
    var _DB = {};
    win._DB = _DB;
    var DB_arr = {};
    var BP = APP_CONFIG.BASE_PATH + '/user/';
    var _sqlite3 = require('sqlite3').verbose();
    var MenuBP = APP_CONFIG.BASE_PATH+'/ppticws/';

    _DB.addMenu = function (data) {
        var db = _DB.getDataBase(data.userName);
        var sql = "insert into menu values('" +
            data.id + "','" +
            data.unit1 + "','" +
            data.unit2 + "','" +
            data.unit3 + "','" +
            data.unit4 + "','" +
            data.name.replace(/\'/g,"\'\'") + "','" +
            data.code + "')";
        db.exec(sql, function (err, rows) {
            if (err) {
                console.log(err);
            }
        });
    };

    _DB.getDataBase = function (user) {
        if (DB_arr[user]) {
            return DB_arr[user];
        } else {
            var path = BP + user + '/resource.db';
            return DB_arr[user] = new _sqlite3.Database(path);
        }
    };

    _DB.existMeunBook = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "select code from menu where code='" + data.bookCode + "'";
        db.all(sql, function (e, rows) {
            if (e) {
                console.log(e);
            } else {
                if (rows.length) def.resolve();
                else def.reject();
            }
        });
        return def.promise();

    };

    _DB.getAllMenuBookCode = function (userName) {
        var def = $.Deferred();
        var db = _DB.getDataBase(userName);
        var sql = "select distinct code from menu";
        db.all(sql, function (e, rows) {
            if (e) {
                def.reject(e);
            } else {
                var arr = [];
                for(var i=0,len = rows.length;i<len;i++){
                    arr.push(rows[i].code);
                }
                def.resolve(arr);
            }
        });
        return def.promise();
    };

    _DB.getAllBookMenuInfo = function (uid) {
        var def = $.Deferred();
        var path = MenuBP+uid+'/book.db';
        _COMMON.existFile(path).done(function () {
            var db = new _sqlite3.Database(path);
            var sql = "select * from books";
            db.all(sql, function (e, rows) {
                db.close();
                if (e) def.reject(e);
                else def.resolve(rows);
            });
        }).fail(function () {
            def.reject();
        });
        return def.promise();
    };

    _DB.deleteMenuBook = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "delete from menu where code='" + data.bookCode + "'";
        db.exec(sql, function (e) {
            if (!e) def.resolve();
            else def.reject();
        });
        return def.promise();
    };

    _DB.getParentName = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName),
            sql='',
            parentDir = false;

        if(data.parentDir && data.parentDir != ''){
            sql=  "select fileName from prefile where uuid='"+data.parentDir+"'" ;
            parentDir = true;

        }else {
            sql = "select name from menu where code='" + data.bookCode
                + "' and unit1='" + data.unit1
                + "' and unit2='" + data.unit2
                + "' and unit3='" + data.unit3
                + "' and unit4='" + data.unit4 + "'";
        }
        db.all(sql, function (e, rows) {
            if (e) def.resolve("unknow");
            else {
                if (rows.length) def.resolve(parentDir?rows[0].fileName:rows[0].name);
                else def.resolve("unknow");

            }
        });
        return def.promise();
    };

    _DB.getMenuByUnit = function (data) {
        var db = _DB.getDataBase(data.userName);
        var def = $.Deferred();
        var sql = "select name from menu where code='" + data.bookCode
            + "' and unit1='" + data.unit1
            + "' and unit2='" + data.unit2
            + "' and unit3='" + data.unit3
            + "' and unit4='" + data.unit4 + "'";
        db.all(sql,function (e,rows) {
           if(e) def.reject(e);
           else {
               if(rows.length) {
                   data.name = rows[0].name;
                   def.resolve();
               }
               else def.reject('can\'t find this unit');
           }
        });
        return def.promise();
    };

    _DB.getPreNames = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName),sql;
        if(data.parentDir && data.parentDir != ''){
             sql = "select fileName from prefile where parentDir='" +data.parentDir+
                "' and isDir="+data.isDir+" and mime='" + data.mime + "'";
        }else if(data.isDir) {
            sql = "select fileName from prefile where bookCode='" + data.bookCode
                + "' and unit1='" + data.unit1
                + "' and unit2='" + data.unit2
                + "' and unit3='" + data.unit3
                + "' and unit4='" + data.unit4 + "' and isDir="+data.isDir+"";
        }else {
             sql = "select fileName from prefile where bookCode='" + data.bookCode
                + "' and unit1='" + data.unit1
                + "' and unit2='" + data.unit2
                + "' and unit3='" + data.unit3
                + "' and unit4='" + data.unit4 + "' and isDir="+data.isDir+" and mime='" + data.mime + "'";
        }

        db.all(sql, function (e, rows) {
            if (e) def.resolve([]);
            else {
                var arr = [];
                for (var i = 0, len = rows.length; i < len; i++) {
                    arr.push(rows[i].fileName);
                }
                def.resolve(arr);
            }
        });
        return def.promise();
    };

    _DB.adapterPre = function (data) {
        return {
            uuid:data.uuid,
            fileName:data.fileName,
            unit1:data.unit1||'',
            unit2:data.unit2||'',
            unit3:data.unit3||'',
            unit4:data.unit4||'',
            parentDir:data.parentDir||'',
            isDir:data.isDir||0,
            md5:data.md5||'',
            mime:data.mime?data.mime.toLowerCase():'',
            resId:data.resId||'',
            createTime:data.createTime||(new Date()).Format('yyyy-MM-dd hh:mm:ss'),
            modifyTime:data.modifyTime||(new Date()).Format('yyyy-MM-dd hh:mm:ss'),
            source:data.source||'',
            type:data.type||'',
            size:data.size||'0',
            bookCode:data.bookCode,
            parentName:data.parentName
        };
    };
    _DB.insertPreDb = function (orgData, cb) {
        var data = _DB.adapterPre(orgData);
        var db = _DB.getDataBase(orgData.userName);        
        var sql = "insert into prefile values('" +
            data.uuid + "','" +
            data.fileName.replace(/\'/g,"\'\'") + "','" +
            data.unit1 + "','" +
            data.unit2 + "','" +
            data.unit3 + "','" +
            data.unit4 + "','" +
            data.parentDir + "'," +
            data.isDir + ",'" +
            data.md5 + "','" +
            data.mime + "','" +
            data.resId + "','" +
            data.createTime + "','" +
            data.modifyTime + "','" +
            data.source.replace(/\'/g,"\'\'") + "','" +
            data.type.replace(/\'/g,"\'\'") + "','" +
            data.size + "','" +
            data.bookCode + "','" +
            data.parentName.replace(/\'/g,"\'\'") + "')";
        db.exec(sql, function (e) {
            if (e) cb && cb({code: -1, error: e});
            else cb && cb({code: 1, data: data});
        });
    };
    _DB.searchPreIndex = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql;
        if(data.unit1==''&&!data.unit1&&data.searchAll){
            sql = "select * from prefile where bookCode='" +  data.bookCode +
                "' and (parentDir = 'undefined' or parentDir = '' or parentDir = null) order by modifyTime desc" ;
        }else {
            sql = "select * from prefile where bookCode='" +
                data.bookCode + "' and unit1='" +
                data.unit1 + "' and unit2='" +
                data.unit2 + "' and unit3='" +
                data.unit3 + "' and unit4='" +
                data.unit4 + "' and (parentDir = 'undefined' or parentDir = '' or parentDir = null) order by modifyTime desc" ;
        }
        db.all(sql,function (e,rows) {
           if(e) def.reject(e);
           else def.resolve(rows);
        });

        return def.promise();
    };
    _DB.searchPreDir = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "select * from prefile where parentDir='" +
            data.uuid + "' and isDir=0 order by modifyTime desc" ;
        db.all(sql,function (e,rows) {
            if(e) def.reject(e);
            else def.resolve(rows);
        });

        return def.promise();
    };

    _DB.searchPreAll = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var search = data.search;
        var sql = '';
        var index = search.lastIndexOf('.');
        if(index>0&&search.length>index+1) {
            sql = "select * from prefile where (fileName like '%"+search.substr(0,index)+"%' " +
                "and mime like '%"+search.substr(index+1)+"%') and bookCode='"+data.bookCode +"'";
        }else if(search.length==index+1){
          sql = "select * from prefile where fileName like '%"+search.substr(0,index)+"%' and bookCode='"+data.bookCode +"'";
        }else if(index==0){
         sql = "select * from prefile  where mime like '%"+search.substr(index+1)+"%' and bookCode='"+data.bookCode +"'";
        }
        else sql = "select * from prefile where (fileName like '%"+search+"%' " +
                "or mime like '%"+search+"%') and bookCode='"+data.bookCode +"'";
        db.all(sql,function (e,rows) {
            if(e) def.reject(e);
            else def.resolve(rows);
        });

        return def.promise();
    };
    _DB.searchPreByUuids = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "select * from prefile where uuid in("+_DB.inLink(data.list)+")" ;
        db.all(sql,function (e,rows) {
            if(e) def.resolve([]);
            else def.resolve(rows);
        });
        return def.promise();
    };
    _DB.inLink = function (arr) {
        var str = '';
        if(arr.length == 1) str = "\'"+arr[0]+"\'";
        else if(arr.length>1){
            str = "\'"+arr[0]+"\'";
            for(var i=1,len = arr.length;i<len;i++){
                str = str + ",\'"+arr[i]+"\'";
            }
        }
        return str;
    };
    _DB.deletePreDBArr = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var dirUuid = [];
        var sql = "select uuid from prefile where isDir=0 and parentDir in("+_DB.inLink(data.listDir)+")";
        db.all(sql,function (e,rows) {
            //先找到在文件夹内的文件uuid
            if(e) def.reject();
            else {
                for(var i = 0,len = rows.length;i<len;i++) dirUuid.push(rows[i].uuid);
                var arr = data.list.concat(data.listDir,dirUuid);
                _DB.upPrePMTime(data.userName,data.list[0]).done(function () {
                    sql = "delete from prefile where uuid in("+_DB.inLink(arr)+")";
                        db.exec(sql,function (e) {
                            //删除所有的数据库信息
                            if(e) def.reject();
                            else {
                                //删除所有的文件信息
                                _FILE.deleteFolderBat(data.userName,data.bookCode,data.list.concat(dirUuid));
                                def.resolve();
                            }
                        });
                });


            }
        });
        return def.promise();
    };
    _DB.renamePreDir = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName),newName='',sql='';

        var check = {
            userName:data.userName,
            bookCode:data.bookCode,
            unit1:data.unit1,
            unit2:data.unit2,
            unit3:data.unit3,
            unit4:data.unit4,
            isDir:1
        };
        _DB.getPreNames(check).done(function (names) {
            if($.inArray(data.newName,names)>=0){
                    def.reject('名称已存在');
            }else {
                sql = "update prefile set fileName ='"+data.newName.replace(/\'/g,"\'\'") + "' where uuid='"+data.uuid+"'";
                db.exec(sql,function (e) {
                    if(e) def.reject(e);
                    else {
                        sql = "update prefile set parentName ='"+data.newName.replace(/\'/g,"\'\'") + "' where parentDir='"+data.uuid+"'";
                        db.exec(sql,function (e) {
                            def.resolve();
                        })
                    }
                });
            }


        });
        return def.promise();
    };
    _DB.movePreSingleFile = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var uuidData = {userName: data.userName, list: [data.uuid]};
        var dstData = {
            userName: data.userName,
            bookCode: data.bookCode,
            unit1: data.unit1,
            unit2: data.unit2,
            unit3: data.unit3,
            unit4: data.unit4
        };
        $.when(_DB.searchPreByUuids(uuidData), _DB.getParentName(dstData)).done(function (detail, parentName) {
            if (detail.length < 1) {
                def.reject();
                return;
            }
            var preData = {
                userName: data.userName,
                bookCode: data.bookCode,
                unit1: data.unit1,
                unit2: data.unit2,
                unit3: data.unit3,
                unit4: data.unit4,
                mime:detail[0].mime,
                isDir:0
            };
            _DB.getPreNames(preData).done(function (names) {
                var newName = _FILE.checkName(detail[0].fileName, names);
                var sql = "update prefile set unit1='" + data.unit1 +
                    "',unit2='" + data.unit2 + "',unit3='" + data.unit3 + "',unit4='" + data.unit4 +
                    "',parentDir='',fileName='" + newName.replace(/\'/g,"\'\'") + "',parentName='" + parentName.replace(/\'/g,"\'\'") +
                    "' where uuid='" + data.uuid + "'";
                db.exec(sql,function (e) {
                    if(e) def.reject(e);
                    else def.resolve();
                })

            }).fail(function (e) {
                def.reject(e);
            })
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    };
    _DB.movePreSingleDir=function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var uuidData = {userName: data.userName, list: [(data.uuid)]};
        var dstData = {
            userName: data.userName,
            bookCode: data.bookCode,
            unit1: data.unit1,
            unit2: data.unit2,
            unit3: data.unit3,
            unit4: data.unit4
        };
        $.when(_DB.searchPreByUuids(uuidData), _DB.getParentName(dstData)).done(function (detail, parentName) {
            if (detail.length < 1) {
                def.reject();
                return;
            }
            var preData = {
                userName: data.userName,
                bookCode: data.bookCode,
                unit1: data.unit1,
                unit2: data.unit2,
                unit3: data.unit3,
                unit4: data.unit4,
                mime:detail[0].mime,
                isDir:1
            };
            _DB.getPreNames(preData).done(function (names) {
                var newName = _FILE.checkName(detail[0].fileName, names);
                var sql = "update prefile set unit1='" + data.unit1 +
                    "',unit2='" + data.unit2 + "',unit3='" + data.unit3 + "',unit4='" + data.unit4 +
                    "',parentDir='',fileName='" + newName.replace(/\'/g,"\'\'") + "',parentName='" + parentName.replace(/\'/g,"\'\'") +
                    "',modifyTime='"+(new Date()).Format('yyyy-MM-dd hh:mm:ss')+"' where uuid='" + data.uuid + "'";
                db.exec(sql,function (e) {
                    if(e) def.reject(e);
                    else {
                        var sql = "update prefile set unit1='" + data.unit1 +
                            "',unit2='" + data.unit2 + "',unit3='" + data.unit3 + "',unit4='" + data.unit4 +
                            "',parentName='" + newName.replace(/\'/g,"\'\'") +
                            "',modifyTime='"+(new Date()).Format('yyyy-MM-dd hh:mm:ss')+"' where parentDir='" + data.uuid + "'";
                        db.exec(sql,function (e) {
                            if(e) def.reject(e);
                            else def.resolve();
                        })
                    }
                })

            }).fail(function (e) {
                def.reject(e);
            })
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    };
    _DB.adapterTP = function (data) {
        return {
            uuid:data.uuid,
            fileName:data.fileName,
            title:data.title||'',
            bookCode:data.bookCode,
            unit1:data.unit1||'',
            unit2:data.unit2||'',
            unit3:data.unit3||'',
            unit4:data.unit4||'',
            sort:data.sort||'',
            pageCode:data.pageCode||'',
            pageIndex:data.pageIndex||'',
            position:typeof data.position == 'string'?data.position:JSON.stringify(data.position)||'',
            creator:data.creator||'',
            uploader:data.uploader||'',
            description:data.description||'',
            extension:data.extension?data.extension.toLowerCase():'',
            widgetId:data.widgetId||'',
            widgetType:data.widgetType||'',
            createTime:data.createTime||(new Date()).Format('yyyy-MM-dd hh:mm:ss'),
            modifyTime:data.modifyTime||(new Date()).Format('yyyy-MM-dd hh:mm:ss'),
            resId:data.resId||'',
            fid:data.fid||'',
            source:data.source||'',
            md5:data.md5||'',
            resFrom:data.resFrom||'',
            reserve1:data.reserve1||'',
            reserve2:data.reserve2||'',
            reserve3:data.reserve3||''
        };
    };
    _DB.insertTPFile = function (orgData,cb) {
        var data = _DB.adapterTP(orgData);
        var db = _DB.getDataBase(orgData.userName);
        var sql = "insert into tp values('" +
            data.uuid + "','" +
            data.fileName.replace(/\'/g,"\'\'") + "','" +
            data.title.replace(/\'/g,"\'\'") + "','" +
            data.bookCode + "','" +
            data.unit1 + "','" +
            data.unit2 + "','" +
            data.unit3 + "','" +
            data.unit4 + "','" +
            data.sort + "','" +
            data.pageCode + "','" +
            data.pageIndex + "','" +
            data.position.replace(/\'/g,"\'\'") + "','" +
            data.creator + "','" +
            data.uploader + "','" +
            data.description.replace(/\'/g,"\'\'") + "','" +
            data.extension + "','" +
            data.widgetId + "','" +
            data.widgetType.replace(/\'/g,"\'\'") + "','" +
            data.createTime + "','" +
            data.modifyTime + "','" +
            data.resId + "','" +
            data.fid + "','" +
            data.source.replace(/\'/g,"\'\'") + "','" +
            data.md5 + "','" +
            data.resFrom.replace(/\'/g,"\'\'") + "','" +
            data.reserve1.replace(/\'/g,"\'\'") + "','" +
            data.reserve2 + "','" +
            data.reserve3 + "')";
        db.exec(sql, function (e) {
            if (e) cb && cb({code: -1, error: e});
            else cb && cb({code: 1, data: data});
        });
    };
    _DB.getMTBKNames = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName), sql;
        sql = "select fileName from tp where bookCode='" + data.bookCode
            + "' and unit1='" + data.unit1
            + "' and unit2='" + data.unit2
            + "' and unit3='" + data.unit3
            + "' and unit4='" + data.unit4 + "' and extension='"  + data.extension + "'";
        db.all(sql, function (e, rows) {
            if (e) def.resolve([]);
            else {
                var arr = [];
                for (var i = 0, len = rows.length; i < len; i++) {
                    arr.push(rows[i].fileName);
                }
                def.resolve(arr);
            }
        });
        return def.promise();
    };
    _DB.updateTPPSingle = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "update tp set unit1='" +
            data.unit1 + "',unit2='" +
            data.unit2 + "',unit3='" +
            data.unit3 + "',unit4='" +
            data.unit4 + "',pageCode='" +
            data.pageCode + "',pageIndex='" +
            data.pageIndex + "',widgetId='" +
            data.widgetId + "',widgetType='" +
            data.widgetType.replace(/\'/g,"\'\'") + "',resId='" +
            data.resId + "',sort='" +
            data.sort + "',reserve1='"+
            data.reserve1.replace(/\'/g,"\'\'") + "',position='"+
            data.position.replace(/\'/g,"\'\'")+"' where uuid='"+data.uuid + "'";
        db.exec(sql,function (e) {
           if(e) def.reject(e);
           else def.resolve();
        });
        return def.promise();
    };
    _DB.updateTPESingle = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "update tp set title='" +
            data.title.replace(/\'/g,"\'\'") + "',description='" + data.description.replace(/\'/g,"\'\'")
            +"' where uuid='"+data.uuid + "'";
        db.exec(sql,function (e) {
            if(e) def.reject(e);
            else def.resolve();
        });
        return def.promise();
    };
    _DB.updateTPERSingle = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "update tp set title='" +
            data.title.replace(/\'/g,"\'\'") + "',description='" + data.description.replace(/\'/g,"\'\'")
            +"',resId='"+data.resId +"',resFrom='"+data.resFrom +"' where uuid='"+data.uuid + "'";
        db.exec(sql,function (e) {
            if(e) def.reject(e);
            else def.resolve();
        });
        return def.promise();
    };
    _DB.getMaxTPSort = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "select max(sort) as maxSort from tp where extension<>'mtbk' and sort<>'' and unit1='"+data.unit1+
                "' and unit2='"+data.unit2 +"' and unit3='"+data.unit3 + "' and unit4='"+data.unit4+
                "' and bookCode='"+data.bookCode+"'";
        db.all(sql,function (e,rows) {
            if(e) def.reject(e);
            else {
                if(rows[0].maxSort) def.resolve(rows[0].maxSort+1);
                else def.resolve(1);
            }
        });
        return def.promise();
    };
    _DB.getTPNames = function (userName,bookCode,pageIndex,extension) {
        var def = $.Deferred();
        var db = _DB.getDataBase(userName);
        var sql = "select fileName from tp where extension=='"+extension+"' and pageIndex='" +pageIndex+
            "' and bookCode='"+bookCode+"'";
        db.all(sql,function (e,rows) {
            if (e) def.resolve([]);
            else {
                var arr = [];
                for (var i = 0, len = rows.length; i < len; i++) {
                    arr.push(rows[i].fileName);
                }
                def.resolve(arr);
            }
        });
    };
    _DB.deleteTPbyUUid = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "delete from tp where uuid='" + data.uuid + "'";
        db.exec(sql,function (e) {
            if(e) def.reject(e);
            else {
                _FILE.deleteFolder(data.userName,data.bookCode,data.uuid);
                //在这里直接返回时把删除的动作交给后台，此时数据库已经删除，就认为文件也已经删除成功了
                def.resolve();
            }

        });
        return def.promise();
    };
    _DB.getTPByUnit = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var symbol = data.mtbk?"==":"<>";
        var sql = "select * from tp where bookCode='" + data.bookCode +
                    "' and unit1='" + data.unit1 +
                    "' and unit2='" + data.unit2 +
                    "' and unit3='" + data.unit3 +
                    "' and unit4='" + data.unit4 +
                    "' and extension"+symbol+"'mtbk'";
        db.all(sql,function (e,rows) {
            if(e) def.reject(e);
            else def.resolve(rows);
        });
        return def.promise();
    };

    _DB.getTPByPageIndex = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var symbol = "<>";//这里默认不查询mtbk文件
        var sql = "select * from tp where bookCode='" + data.bookCode +
            "' and pageIndex in(" + _DB.inLink(data.pageIndex) +
            ") and extension"+symbol+"'mtbk'";
        db.all(sql,function (e,rows) {
            if(e) def.reject(e);
            else def.resolve(rows);
        });
        return def.promise();
    };

    _DB.deleteTPDBByPageIndex = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var symbol = "<>";//这里默认不查询mtbk文件
        var sql = "delete from tp where bookCode='" + data.bookCode +
            "' and pageIndex in(" + _DB.inLink(data.pageIndex) +
            ") and extension"+symbol+"'mtbk'";
        db.exec(sql,function (e) {
            if(e) def.reject(e);
            else def.resolve();
        });
        return def.promise();
    };

    _DB.getTPByBookCode = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var symbol = data.mtbk?"==":"<>";
        var sql = "select * from tp where bookCode='" + data.bookCode +
            "' and extension"+symbol+"'mtbk'";
        db.all(sql,function (e,rows) {
            if(e) def.reject(e);
            else def.resolve(rows);
        });
        return def.promise();
    };

    _DB.deleteTPDBByBookCode = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var symbol = data.mtbk?"==":"<>";
        var sql = "delete from tp where bookCode='" + data.bookCode +
            "' and extension"+symbol+"'mtbk'";
        db.exec(sql,function (e) {
            if(e) def.reject(e);
            else def.resolve();
        });
        return def.promise();
    };

    _DB.renamePreDBFileName = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "update prefile set fileName='"+data.fileName.replace(/\'/g,'\'\'')+"' where uuid='"+data.uuid+"'";
        db.exec(sql,function (e) {
           if(e) def.reject(e);
            else def.resolve();
        });
        return def.promise();
    };

    _DB.upPreMTime = function (userName,uuid) {
        var def = $.Deferred();
        var db = _DB.getDataBase(userName);
        var sql = "update prefile set modifyTime='"+(new Date()).Format('yyyy-MM-dd hh:mm:ss')+"' where uuid='"+uuid+"'";
        db.exec(sql,function (e) {
            def.resolve();
        });
        return def.promise();
    };

    _DB.upPrePMTime = function (userName,uuid) {
        var def = $.Deferred();
        if(uuid&&uuid!=''){
            var db = _DB.getDataBase(userName);
            var sql = "select parentDir from prefile where uuid='"+uuid+"'";
            db.all(sql,function (e,rows) {
                def.resolve();

                    if(!e&&rows[0].parentDir&&rows[0].parentDir!=''){
                        _DB.upPreMTime(userName,rows[0].parentDir);
                    }

            });
        }else {
            setTimeout(function () {
                def.resolve();
            },0);
        }
        return def.promise();
    };

    //更新数据库MD5
    /*  @param {
    *           userName;
    *           uuid:
    *           md5:
    *           modifyTime:
    *           siez:
    *           }
    **/
    _DB.upPreMd5 = function (param) {
        var def = $.Deferred();
        if(!param||typeof param!='object'){
            def.reject('请传入有效的参数');
        }else{
            var md5 =param.md5||"";
            var modifyTime = param.modifyTime||"";
            var size = param.size||"";
            var userName = param.userName||"";
            var uuid = param.uuid||"";
            if(!md5||!modifyTime||!size||!userName||!uuid){
                def.reject('缺少参数');
            }else{
                var db = _DB.getDataBase(userName);
                var sql = "update prefile set " +
                    "md5='"+md5+
                    "', modifyTime='"+(new Date(modifyTime)).Format('yyyy-MM-dd hh:mm:ss')+
                    "', size='"+size+
                    "' where uuid ='"+uuid+"'";
                db.exec(sql,function (e) {
                    def.resolve();
                });
            }
        }
        return def.promise();
    };
    _DB.updateTPMd5 = function (data) {
        var def = $.Deferred();
        var db = _DB.getDataBase(data.userName);
        var sql = "update tp set md5='" + data.md5 +
            "',modifyTime='"+(new Date()).Format('yyyy-MM-dd hh:mm:ss')+"' where uuid='"+data.uuid+"'";
        db.exec(sql,function (e) {
            if(e) def.reject(e);
            else def.resolve();
        });
        return def.promise();
    }

})(window);