/**
 * Created by njfu
 * createTime  : 2017/2/13
 * description :授课包文件导包为mtbk
 *
 */
;
(function(win){
    var _ExportMtbk = {};
    var BP = APP_CONFIG.BASE_PATH + '/user/';
    var _fs = require('fs');
    var _mkdirp = require('mkdirp');
    var _path = require('path');
    var _addon = require('Iflybook_modules/syscmd');
    win._ExportMtbk = _ExportMtbk;
    /**
    *授课文件导出为mtbk
    *@param(dbfiles) 数据库查询需要导出的数据
    *@param(bookCode)
    *@param(loginName)
    *@param(fileName)
    */
    _ExportMtbk.initExport = function(loginName,bookCode,dbfiles,fileName){
        var defer = $.Deferred(); 
        var returnpath;
        if(dbfiles.length == 0){
            defer.resolve("null")
        }else{
            // var basePath = process.env.TEMP + "\\mtbk_" + Date.now();
            var basePath =_path.join(process.env.TEMP,"mtbk_" + Date.now());
            var argsJson = {
                exportpos: basePath,
                name: fileName,
                rootdir: basePath,
                bookcode: bookCode,
                folders: []
            };
            var pagesResult = _ExportMtbk.getResByPages(dbfiles);
            argsJson.folders = pagesResult.pages;
            var resByPages = pagesResult.list;
            var savexmlfuns = [];
            for(var i =0;i<resByPages.length;i++){
                var pageIndex = resByPages[i][0] && resByPages[i][0].pageIndex;
                var xaml = _ExportMtbk.toPageXml(resByPages[i],pageIndex,loginName);
                // var xmlpath = argsJson.rootdir+ "\\" + bookCode +"\\"+pageIndex+"\\"+pageIndex+".xaml";
                var xmlpath = _path.join(argsJson.rootdir,bookCode,pageIndex,pageIndex+".xaml");
                savexmlfuns.push(saveFile(xaml,xmlpath));
            }
            $.when.apply({},savexmlfuns).done(function(){
                for(var j = 0;j<dbfiles.length;j++){
                    (function(j){
                        $(document).queue("copyPagesFile",function(){
                            // var dst = argsJson.rootdir + "\\" + bookCode + "\\" + dbfiles[j].pageIndex + "\\" + dbfiles[j].fileName+"."+dbfiles[j].extension;
                            var dst = _path.join(argsJson.rootdir,bookCode,dbfiles[j].pageIndex,dbfiles[j].fileName+"."+dbfiles[j].extension);
                            // var src = _path.join(BP, loginName + '/books/' + dbfiles[j].bookCode + '/' + dbfiles[j].uuid + '/' + dbfiles[j].fileName + '.' + dbfiles[j].extension) || "";
                            var src = _path.join(BP,loginName,"books",dbfiles[j].bookCode,dbfiles[j].uuid,dbfiles[j].fileName + '.' + dbfiles[j].extension) || "";
                            _fs.exists(src,function(e){
                                if(e){
                                    copyFileByStream(src,dst).done(function(result){
                                        if($(document).queue("copyPagesFile").length == 0){
                                            argsJson.exportpos = argsJson.exportpos.replace(/\\/g, "/");
                                            argsJson.rootdir = argsJson.rootdir.replace(/\\/g, "/");
                                            resExport(JSON.stringify(argsJson)).done(function (ret) {
                                                if(ret && ret == "true"){
                                                    // returnpath = basePath.replace(/\\/g, "/") + "/" + argsJson.name + ".mtbk";
                                                    returnpath = _path.join(basePath,argsJson.name+".mtbk");
                                                    defer.resolve(returnpath);
                                                }else{
                                                    defer.reject("false");
                                                }
                                            });
                                        }else{
                                            $(document).dequeue("copyPagesFile");
                                        }
                                    }).fail(function(e){
                                        defer.reject("false");
                                    });
                                }else{
                                    console.log("资源不存在："+src);
                                    if($(document).queue("copyPagesFile").length == 0){
                                        argsJson.exportpos = argsJson.exportpos.replace(/\\/g, "/");
                                        argsJson.rootdir = argsJson.rootdir.replace(/\\/g, "/");
                                        resExport(JSON.stringify(argsJson)).done(function (ret) {
                                            if(ret && ret == "true"){
                                                // returnpath = basePath.replace(/\\/g, "/") + "/" + argsJson.name + ".mtbk";
                                                returnpath = _path.join(basePath,argsJson.name+".mtbk");
                                                defer.resolve(returnpath);
                                            }else{
                                                defer.reject("false");
                                            }
                                        });
                                    }else{
                                        $(document).dequeue("copyPagesFile");
                                    }
                                    // defer.reject("false");
                                }
                            })
                        });
                    })(j);
                }
                $(document).dequeue("copyPagesFile");
            }).fail(function(e){
                defer.reject(e);
            });
        }
        return defer.promise();
    }
    //数组资源按页分组
    _ExportMtbk.getResByPages = function(dbfiles){
        var pages = [];
        var pagesResList = [];
        for(var i =0;i<dbfiles.length;i++){
            var pageIndex = dbfiles[i].pageIndex;
            var flag = pages.filter(function(el){
                return el == pageIndex;
            });
            if(flag.length == 0){
                pages.push(dbfiles[i].pageIndex);
                var reses = dbfiles.filter(function(el){
                    return el.pageIndex == pageIndex;
                });
                if(reses.length>0){
                    pagesResList.push(reses);
                } 
            }
        }
        var result ={
            pages:pages,
            list:pagesResList
        }
        return result;
    }
    _ExportMtbk.toPageXml = function(files,pageIndex,loginName) {
        var hotSpotXaml = "";
        if (hotSpotXaml !== "") hotSpotXaml = "\n<eb:hotspot>" + hotSpotXaml + "\n</eb:hotspot>";
        var widgetsXaml = "";
        $.each(files, function (i, e) {
            widgetsXaml += _ExportMtbk.dbFileToXml(e,e.widgetType,loginName);
        });
        if (widgetsXaml !== "") widgetsXaml = "\n<eb:absolutelayout>" + widgetsXaml + "\n</eb:absolutelayout>"
        var xml = "<eb:page background=\"" + pageIndex + ".jpg\" xmlns:eb=\"EBookLib\">" + hotSpotXaml + widgetsXaml + "\n</eb:page>";
        return xml;
    };
    _ExportMtbk.dbFileToXml = function(file,widgetType,loginName){
        var xmltype;
        var xmlres;
        xmlres = _ExportMtbk.dbFormatWidget(file,loginName);
        switch(xmlres.WidgetType){
            case 'img':
                xmltype = "img";
                break;
            case 'gallery':
                xmltype = "file";
                break;
            case 'choice':
                xmltype = "file";
                break;
            case 'flash':
                xmltype = "flash";
                break;
            case 'video':
                xmltype = "video";
                break;
            case 'audio':
                xmltype = "audio";
                break;
            case 'exercise':
                xmltype = "file";
                break;
            case 'evaluate':
                xmltype = "file";
                break;
            case 'onlineRes':
                xmltype = "file";
                break;
            case 'proc3rd':
                xmltype = "file";
                break;
            case 'note':
                xmltype = "note";
                break;
            case 'icw':
                xmltype = "icw";
                break;
            case 'imgPaint':
                xmltype = "imgPaint";
                break;
            case 'fadeCurtain':
                xmltype = "fadeCurtain";
                break;
            case 'vote':
                xmltype = "vote";
                break;
            case 'interactiveCard':
                xmltype = "file";
                break;
            default :
                xmltype = "file";
                break
        };
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<'+xmltype+' src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}"  title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />';
        widgetContent = widgetContent.replace("{0}",xmlres.File);
        widgetContent = widgetContent.replace("{1}",xmlres.Title);
        widgetContent = widgetContent.replace("{2}",(xmlres.showTitleFlag === undefined) ? true : xmlres.showTitleFlag);
        widgetContent = widgetContent.replace("{3}",(xmlres.showIconFlag === undefined) ? true : xmlres.showIconFlag);
        widgetContent = widgetContent.replace("{4}",xmlres.layout.src);
        widgetContent = widgetContent.replace("{5}",xmlres.layout.style);
        widgetContent = widgetContent.replace("{6}",xmlres.description);
        widgetContent = widgetContent.replace("{7}",xmlres.userName);
        widgetContent = widgetContent.replace("{8}",xmlres.uploadTime);
        widgetContent = widgetContent.replace("{9}",xmlres.score);
        widgetContent = widgetContent.replace("{10}",xmlres.userAddressInfo);
        widgetContent = widgetContent.replace("{11}",xmlres.resourceId);
        widgetContent = widgetContent.replace("{12}",xmlres.timestamp);
            // .format(xmlres.File, xmlres.Title ,
            //     (xmlres.showTitleFlag === undefined) ? true : xmlres.showTitleFlag ,
            //     (xmlres.showIconFlag === undefined) ? true : xmlres.showIconFlag,
            //     xmlres.layout.src, xmlres.layout.style,xmlres.description,xmlres.userName,xmlres.uploadTime,xmlres.score,xmlres.userAddressInfo,xmlres.resourceId,xmlres.timestamp);

        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';
         var bound = xmlres.bound || (xmlres.Left+";"+xmlres.Top+";"+xmlres.PlayAreaWidth+";"+xmlres.PlayAreaHeight);
            xmlResult += '{0} id="{1}" bound="{2}" editable="{3}" style="{4}" '
                // .format(xmlres.WidgetType, xmlres.Id,bound, xmlres.IsEditing,xmlres.style.toString());
        xmlResult = xmlResult.replace("{0}",xmlres.WidgetType);
        xmlResult = xmlResult.replace("{1}",xmlres.Id);    
        xmlResult = xmlResult.replace("{2}",bound);    
        xmlResult = xmlResult.replace("{3}",xmlres.IsEditing);    
        xmlResult = xmlResult.replace("{4}",xmlres.style.toString());
        if(xmlres.type && xmlres.WidgetType == "interactiveCard"){
           xmlResult += 'type="' + xmlres.type + '"';
        }
        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>";
        xmlResult = xmlResult.replace("{0}",xmlres.WidgetType);
        return xmlResult;
    }
    _ExportMtbk.dbFormatWidget = function(file,loginName){
        var wtp = parseWidgetTypeField(file.widgetType);
        var p = {
            File:file.fileName + "." +file.extension,
            Title:file.fileName,
            showTitleFlag:false,
            showIconFlag:false,
            layout:{
                src:"",
                style:""
            },
            description:file.description || "",
            userName:file.creator || "",
            uploadTime:file.uploadTime || "",
            score:"0",
            userAddressInfo:"",
            resourceId:file.resId || "",
            timestamp:"",
            WidgetType:wtp.widgetType || "",
            Id:file.widgetId || "",
            bound:file.position || "0;120;0;0" ,
            IsEditing:false,
            realPath: _path.join(APP_CONFIG.BASE_PATH, 'user/' + loginName + '/books/' + file.bookCode + '/' + file.uuid + '/' + file.fileName + '.' + file.extension) || "",
            style:""
        }
        if(wtp.widgetType == "interactiveCard" && wtp.secondWidgetType){
            p.type =  wtp.secondWidgetType;
        }
        return p;
    }
    /**
     * 保存文件 (异步方法!!!)
     * @param {string} content 文件文本类容
     * @param {string} filePath 文件路径
     */
    function saveFile(content, filePath) {
        var def = $.Deferred();
        var ct = content || "";
        var filePath = filePath.replace(/\//g,'\\');
        var pathDir = filePath.substr(0,filePath.lastIndexOf('\\'));
            _mkdirp(pathDir,function(err){
                if(err){
                    console.Error(err);
                    def.reject(err);
                }else{
                    _fs.writeFile(filePath, ct,function(err){
                        if(err){
                            console.Error(err);
                            def.reject(err);
                        }else{
                            console.log("Write file:" + filePath);
                            def.resolve();
                        }
                    });
                }
            });
            
        
        return def.promise();
    }
    /**
     * 拷贝文件(以二进制流的形式)
     * @param {string} src 文件文本类容
     * @param {string} des 文件路径
     */
    function copyFileByStream(src,des){
        var def = $.Deferred();
        src = src.replace(/\\/g,"/");
        des = des.replace(/\\/g,"/");
        var fileReadStream = _fs.createReadStream(src);
        var fileWriteStream = _fs.createWriteStream(des);
        fileReadStream.pipe(fileWriteStream);
        fileWriteStream.on('error', function () {
            def.reject(false);
        });
        fileWriteStream.on('close', function () {
            def.resolve(true);
        });
        return def.promise();
    }
    /**
     * 调用客户端命令
     * @param {string} cmdRegion 模块名称
     * @param {string} cmdName 命令名
     * @param {string} cmdArgs 多个参数，参数间使用|分隔
     * @param {string=} cmdType 命令类别    0(执行完了可以立即销毁),1,2(内部有多线程,不能立即销毁)
     * @returns {string}
     */

     function callClient(region,cmdName,cmdArg,cmdType,callback){
        var pathtest = /\:/;
        var jsonobj = {};
        if(region == "syscmd"){
            //这段是为了处理发音卡片调用本地音频播放时传入相对地址
            if(cmdName == "sndplay"){
                if(!pathtest.test(cmdArg)){
                    cmdArg =  Config.binPathNoFile + cmdArg;
                }
            }
        }

        if (callback) {
            var wrapper = function (name, args) {
                callback(args);
            };
            _addon.ExecuteCmdAsync(region,cmdName,cmdArg,cmdType,wrapper);
        }
        else{
            return _addon.ExecuteCmdSync(region,cmdName,cmdArg,cmdType);
        }
    }
    /**
     * 导出资源
     * @param value
     * @returns {*}
     */
    function resExport(value) {
        var defer = $.Deferred();
        callClient('syscmd', 'resexport', value, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 解析数据库widgetType字段
     * @param str 普通字符串或者json字符串
     * @returns {{widgetType: string, secondWidgetType: string}}
     */
    function parseWidgetTypeField(str) {
        var result = {
            widgetType: '',
            secondWidgetType: ''
        };
        // 识别为字符串
        if((typeof str === 'string') && str.length > 0){
            var _widgetType;
            var _secondWidgetType;
            try{
                var multipleType = JSON.parse(str);
                _widgetType = multipleType.widgetType || '';
                _secondWidgetType = multipleType.secondWidgetType || '';
            }catch(e){
                _widgetType = str;
            }
            result.widgetType = _widgetType;
            result.secondWidgetType = _secondWidgetType;
        }
        // 识别为对象
        if((typeof str === 'object') && c.hasOwnProperty('widgetType')){
            result.widgetType = str.widgetType;
            result.secondWidgetType = str.secondWidgetType;
        }
        return result;
    };
})(window);


