/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/10 14:41
 * description :
 */
;
(function (win) {
    var _MENU = {};
    win._MENU = _MENU;
    var MenuBP = APP_CONFIG.BASE_PATH+'/ppticws/';
    function MenuNode() {
        this.name = "";
        this.Unit1 = "";
        this.Unit2 = "";
        this.Unit3 = "";
        this.Unit4 = "";
        this.children = "";
    }


    function transform(config) {
        _COMMON.readFile(config.path).done(function (ret) {
            var menu = JSON.parse(ret);
            var tree = zTreeJson(menu.data, config.bookName);
            addDBReal(config,tree);
        });
    }

    function addDBReal(config,obj) {
        _DB.addMenu({
            unit1:obj.Unit1||'',
            unit2:obj.Unit2||'',
            unit3:obj.Unit3||'',
            unit4:obj.Unit4||'',
            code:config.bookCode,
            name:obj.name,
            userName:config.userName,
            id:_COMMON.guid()
        });
        if(obj.children&&obj.children!=''){
            for(var i=0,list = obj.children,len = obj.children.length;i<len;i++){
                addDBReal(config,list[i]);
            }
        }
    }
    function zTreeJson(Unit1s, thisName) {
        var list = turnMenuNode(Unit1s);
        var rootJson = new MenuNode();
        rootJson.children = list;
        rootJson.name = thisName;
        return rootJson;

    }

    function turnMenuNode(Unit1s) {
        var obj = null;
        var list = [];
        var Units = Unit1s;
        for (var i = 0, len = Units.length; i < len; i++) {
            obj = new MenuNode();
            obj.name = Units[i].name;
            obj.Unit1 = Units[i].code;
            obj.Unit2 = "";
            obj.Unit3 = "";
            obj.Unit4 = "";
            if (Units[i].courses.length > 0) {
                obj.children = Unit2(Units[i].courses, obj.Unit1);
            }
            list.push(obj);
        }
        return list;
    }

    function Unit2(Unit2s, unit1code) {
        var obj = null;
        var list = [];
        var Units = Unit2s;
        for (var i = 0, len = Units.length; i < len; i++) {
            obj = new MenuNode();
            obj.name = Units[i].name;
            obj.Unit1 = unit1code;
            obj.Unit2 = Units[i].code;
            obj.Unit3 = "";
            obj.Unit4 = "";
            if (Units[i].courses.length > 0) {
                obj.children = Unit3(Units[i].courses, unit1code, obj.Unit2);
            }
            list.push(obj);
        }
        return list;
    }

    function Unit3(Unit3s, unit1code, unit2code) {
        var obj = null;
        var list = [];
        var Units = Unit3s;
        for (var i = 0, len = Units.length; i < len; i++) {
            obj = new MenuNode();
            obj.name = Units[i].name;
            obj.Unit1 = unit1code;
            obj.Unit2 = unit2code;
            obj.Unit3 = Units[i].code;
            obj.Unit4 = "";
            if (Units[i].courses.length > 0) {
                obj.children = Unit4(Units[i].courses, unit1code, unit2code, obj.Unit3);
            }
            list.push(obj);
        }
        return list;
    }

    function Unit4(Unit3s, unit1code, unit2code, unit3code) {
        var obj = null;
        var list = [];
        var Units = Unit3s;
        for (var i = 0, len = Units.length; i < len; i++) {
            obj = new MenuNode();
            obj.name = Units[i].name;
            obj.Unit1 = unit1code;
            obj.Unit2 = unit2code;
            obj.Unit3 = unit3code;
            obj.Unit4 = Units[i].code;
            list.push(obj);
        }
        return list;
    }


    _MENU.add = function (config) {

        _DB.existMeunBook(config).done(function () {

            config.update && _DB.deleteMenuBook(config).done(function () {
               transform(config);
            });
        }).fail(function () {
            transform(config);
        });


    };

    _MENU.getRouter = function (cnf) {
        var def = $.Deferred();
        var arr = [],i=4,flag=true;
        do{
            arr.push({
                userName:cnf.userName,
                bookCode:cnf.bookCode,
                unit1:cnf.unit1,
                unit2:cnf.unit2,
                unit3:cnf.unit3,
                unit4:cnf.unit4
            });
            for(;i>0;i--){
                if(cnf['unit'+i]!='') {
                    cnf['unit'+i] ='';
                    break;
                }
            }
            if(i==0) flag=false;
        }while (flag);
        arr.reverse();
        global_queue(arr,_DB.getMenuByUnit).done(function () {
            def.resolve(arr);
        }).fail(function (e) {
            def.reject(e);
        });
        return def.promise();
    };

    _MENU.initAllBookMenu  = function (config) {
        $.when(_DB.getAllBookMenuInfo(config.uid),_DB.getAllMenuBookCode(config.userName)).done(function (bookInfos,bookCodes) {
          for(var i in bookInfos) {
              if($.inArray(bookInfos[i].bookCode,bookCodes)<0){
                  transform({
                        userName:config.userName,
                        bookCode:bookInfos[i].bookCode,
                        bookName:bookInfos[i].title,
                        path:MenuBP+config.uid+'/book/'+bookInfos[i].bookCode+'/'+bookInfos[i].bookCode+'.menu'
                  });
              }
          }
        })
    } ;
    
})(window);