/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/9/7 10:05
 * description : 此文件用来处理课堂笔记的上传工作
 */
;
(function (win, global, $) {
    var DatabasePath = APP_CONFIG.BASE_PATH + '/DAT/voterNote.db';
    var BaseDir = APP_CONFIG.BASE_PATH + '/DAT/voterNote/';
    var Sqlite3 = require('sqlite3').verbose();
    var database = new Sqlite3.Database(DatabasePath);
    var uploding = false; //表明是否在上传
    var baseUrlUp = Base_Cfg.J0_BASE+'/api4/jxt/dtb/note.json';
    var baseUrlSig = Base_Cfg.J0_BASE+'/api4/j0/getMd5Signature';
    /**
     * 增加记录到数据库
     * @param o
     * @returns {*} $.promise
     * @private
     */
    function _addNote(o) {
        var def = $.Deferred();
        var sql = 'insert into note values("' +
            o.id + '","' +
            o.subject + '","' +
            o.classId + '","' +
            o.userId + '","' +
            o.createTime + '","' +
            o.noteId + '","' +
            '","' +
             '","' +
             '"' +
            ')';
        database.exec(sql,function (err) {
            if(err) def.reject(err);
            else def.resolve();
        });
        return def.promise();
    }

    /**
     * 删除记录
     * @param id
     * @returns {*} $.promise
     * @private
     */
    function _deleteNote(id) {
        var def = $.Deferred();
        var sql = 'delete from note where id="'+id +'"';
        database.exec(sql,function (err) {
            if(err) def.reject(err);
            else def.resolve();
        });
        return def.promise();
    }

    /**
     * 获取记录
     * @returns {*} $.promise
     * @private
     */
    function _getNotes() {
        var def = $.Deferred();
        var sql = 'select * from note';
        database.all(sql,function (err,rows) {
            if(err) def.reject(err);
            else def.resolve(rows);
        });
        return def.promise();
    }
    
    function startUploadDb() {
        if(uploding) return;
        uploding = true;
        _getNotes().done(function (rows) {
            win.global_queue(rows,_upload).done(function () {
                uploding = false;
            }).fail(function () {
                uploding = false;
            });
        }).fail(function () {
            uploding = false;
        })
    }

    function _upload(item,unfinished) {
        var def = $.Deferred();
        _getSig(item.userId).done(function (ret) {
            var token = ret;
            var param={
                uuid:item.userId,
                authToken:token,
                userId : item.userId,
                classId : item.classId,
                noteId:item.noteId,
                finished:unfinished?0:1,
                subject : item.subject,
                time 	: item.createTime
            };
            var filepath = unfinished?item.filepath:BaseDir+item.id+'.zip';
            global.global_upload(baseUrlUp,'file',filepath,param).done(function (result) {
                var result = JSON.parse(result);
                if (result && result.status == 200&&!unfinished) {
                    _deleteNote(item.id).done(function () {
                        win._COMMON.deleteFile(filepath);
                        def.resolve();
                    }).fail(function (err) {
                        def.resolve();
                    });
                }else {
                    def.resolve();
                }
            }).fail(function () {
                def.resolve();
            })
        }).fail(function (err) {
            def.resolve();
        });
        return def.promise();
    }

    /**
     * 获取认证标识
     * @param uuid
     * @returns {*}
     * @private
     */
    function _getSig(uuid) {
        var def = $.Deferred();
        $.ajax({
            url: baseUrlSig,
            data: 'uuid=' + uuid,
            beforeSend: function(xhr) {
                xhr.setRequestHeader("Accept", "application/json");
                xhr.setRequestHeader("Content-Type", "application/json");
            },
            success: function(ret) {
                if (ret && ret.status == 200) {
                    def.resolve(ret.data);
                } else {
                    def.reject(ret);
                }
            },
            error: function(e) {
                def.reject(e);
            }
        });
        return def.promise();
    }
    
    function receiveMessage(data) {
        var item = {
            id:win._COMMON.guid(),
            subject:data.subject,
            classId:data.classId,
            noteId:data.noteId,
            userId:data.userId,
            createTime:(new Date()).Format('yyyy-MM-dd hh:mm:ss')
        };
        if(data.finished){
            win._COMMON.copyFile(data.path,BaseDir+item.id+".zip").done(function () {
                _addNote(item).done(function () {
                    startUploadDb();
                }).fail(function () {
                    win._COMMON.deleteFile(BaseDir+item.id+".zip");
                })
            }).fail(function () {
                //todo:nothing util now
            })
        }else {
            item.filepath = data.path;
            _upload(item,true);
        }
    }
    win.noteServer = {
        receiveMessage:receiveMessage,
        startUploadDb:startUploadDb
    }
})(window, global, jQuery);