/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/5 11:24
 * description :
 */
;
(function (win) {
    function _NOTIFUN() {
    }
    win._NOTI = new _NOTIFUN();
    var _gui = require('nw.gui');
    var _win = _gui.Window.get();
    _NOTIFUN.prototype.reg = function (message) {
        var _self = this;
        switch (message.method){
            case 'stopDownload':_self.stopDownload(message);break;
            case 'download':_self.download(message);break;
            case 'addMenu':_self.addMenu(message);break;
            case 'upload':_self.upload(message);break;
            case 'debug':_self.debug();break;
            case 'initAllBookMenu':_self.initAllBookMenu(message);break;
            case 'easyCurlDownload':_self.easyCurlDownload(message);break;
            case 'stopEasyCurlDownload':_self.stopEasyCurlDownload(message);break;
            case 'cancelEasyCurlDownload':_self.stopEasyCurlDownload(message);break;
            default:_self.test(message);
        }
    };
    _NOTIFUN.prototype.debug = function () {
        _win.showDevTools();
    };
    _NOTIFUN.prototype.test = function (message) {
        console.log('please use right method,server get a default notification');
    };
    /**
     * 取消下载
     * @param message = {
     *      method:'stopDownload',
     *      data:{
     *          downloadId:''取消下载的Id
     *      }
     * }
     */
    _NOTIFUN.prototype.stopDownload = function (message) {
        try{
            var id = message.data.downloadId;
            win.global_downloadArr[id]&&win.global_downloadArr[id].section.close();
            win.global_downloadArr[id]&&win.global_downloadArr[id].section.clearCache();
            _COMMON.removeArr(win.global_downloadArr,id);
        }catch (e){
            console.log(e);
        }
    };
    /**
     * 下载文件
     * @param message = {
     *      method:'download',
     *      data:{
     *          file:'d:/demo/example.ppt',
     *          url:'http://www.demo.com/file/some.ppt',
     *          _from:'clientA' 自己客户端的名字
     *          copy:{ //无须拷贝的时候不传此字段
     *              src:'path/to/file',
     *              dst:[
     *                  'path/to/file1',
     *                  'path/to/file2'
     *                  ...
     *              ]
     *          }
     *       *  error: //此字段不可使用 用于失败时通知错误
     *       *  process://此字段不可使用 用于通知进度 -1 代表失败  100 代表完成
     *       *  downloadId://此字段不可使用 用于通知时取消下载的标识
     *      },
     *      extension:{} //内容自定义字段（extension名称不可变）  进度返回时会原样返回
     * }
     */
    _NOTIFUN.prototype.download = function (message) {
        win.global_download(message);
    };
    /**
     * 增加目录索引信息
     * @param message = {
     *      method:'addMenu',
     *      data:{
     *          userName:'',
     *          bookCode:'',
     *          bookName:'',
     *          update:true or false 是否更新,
     *          path:'',目录文件的路径
     *      }
     * }
     */
    _NOTIFUN.prototype.addMenu = function (message) {
        _MENU.add(message.data);
    };
    /**
     * 上传文件
     * @param message = {
     *      method:'upload',
     *      data:{
     *          file:'d:/demo/example.ppt',
     *          access_token:'',
     *          openId:''
     *          _from:'clientA' 自己客户端的名字
     *          showProcess:true or false 是否返回除-1 和100 之外的进度, 默认为false
     *       *  error: //此字段不可使用 用于失败时通知错误
     *       *  process://此字段不可使用 用于通知进度 -1 代表失败  100 代表完成
     *       * contextId://此字段不可使用 用于标识上传完成的通知字段
     *       * platForm://此字段不可使用 用于标识上传到了什么地方
     *      },
     *      extension:{} //内容自定义字段（extension名称不可变）  进度返回时会原样返回
     * }
     */
    _NOTIFUN.prototype.upload = function (message) {
         win.global_upload(message);
    };

    /**
     * 初始化所有未同步到新备课本的目录信息
     * notice:此功能是为了同步老版本的书本信息在新的备课本下无法使用的问题
     * @param message = {
     *      method:'initAllBookMenu',
     *      data:{
     *          userName:'',
     *          uid:'',
     *      }
     * }
     */
    _NOTIFUN.prototype.initAllBookMenu = function (message) {
        _MENU.initAllBookMenu(message.data);
    };

    /**
     * 下载文件（带续传特性）
     * @param message = {
     *      method: 'easyCurlDownload',
     *      data: {
     *          id: '',
     *          _from: '',
     *          action: "easyCurlDownload",
     *          url: '',
     *          file: '',
     *          copy: {
     *            src:''
     *            dist: {}
     *           }
     *      },
     *      [ //可选参数
     *      easycurl: {
     *          reDownload: true/false, //是否强制重新下载
     *          retry: 5,
     *          connect_timeout: 5
     *      }
     *      ]
     * }
     */
    _NOTIFUN.prototype.easyCurlDownload = function (message) {
        win.global_easyCurl.download(message);
    };

    /**
     * 取消下载（和easyCurlDownload方法配合使用）
     * @param message = {
     *      method: 'stopEasyCurlDownload',
     *      data: {
     *          downloadId:''取消下载的Id
     *          _from: '',
     *          action: "stopEasyCurlDownload",
     *      }
     * }
     */
    _NOTIFUN.prototype.stopEasyCurlDownload = function (message) {
        win.global_easyCurl.close(message);
    };
})(window);

