/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/9 13:47
 * description :
 */
;
window.global_downloadArr = [];


(function (win) {

    function download(config) {

        var id = _COMMON.guid(10);
        config.data.downloadId = id;
        config._to = config.data._from;
        delete config.data['_from'];
        config._from = 'server';
        config.method = 'download';

        // 针对中文url进行编码
        config.data.url = _COMMON.cn_encodeuri(config.data.url);

        var url = config.data.url||"";
        win.global_getDownloadFileLength(url).then(function(total){

            var option = {
                url: config.data.url,
                file: config.data.file,
                threads: parseInt(total/1024/1024/50)+1 //这里20M为一个分片, 改为50M
            };
            var section = new win.global_ThreadsDownload(option);
            win.global_downloadArr[id] = {
                section: section,
                info: null
            };

            section.download().then(function () {
                var copyObj = config.data.copy;
                if(copyObj){
                    var cArr = [];
                    for(var k in copyObj.dst){
                        cArr.push({
                            src:copyObj.src,
                            dst:copyObj.dst[k]
                        })
                    }

                    global_queue(cArr,defCopy).done(function () {
                        config.data.process = 100;
                        win.hproseSend(config);
                        _COMMON.removeArr(win.global_downloadArr,id);
                    }).fail(function (e) {
                        config.data.process = -1;
                        config.data.error = e;
                        win.hproseSend(config);
                    });

                    function defCopy(cnf) {
                        var def = $.Deferred();
                        _COMMON.copyFile(cnf.src,cnf.dst).done(function () {
                            def.resolve();
                        }).fail(function (e) {
                            def.reject('copy file fail');
                        });
                        return def.promise();
                    }
                }else {
                    config.data.process = 100;
                    win.hproseSend(config);
                    _COMMON.removeArr(win.global_downloadArr,id);
                }

            }, function (err) {
                config.data.process = -1;
                config.data.error = err;
                win.hproseSend(config);
                _COMMON.removeArr(win.global_downloadArr,id);
                section.clearCache();
            }, function (process) {
                if(win.global_downloadArr[id]){
                    config.data.process = Math.floor(process.now / process.total * 100);
                  // console.log('%c 发送进度:'+ config.data.process +(new Date()).toString(),'color:green;');
                   (config.data.process<100)&&win.hproseSend(config);
                }


            });
        }).fail(function(err){
            config.data.process = -1;
            config.data.error = err;
            win.hproseSend(config);
        });


    }

    function stopDownload(id) {
        if(win.global_downloadArr[id]){
            win.global_downloadArr[id].section.close();
            _COMMON.removeArr(win.global_downloadArr,id);
        }
    }

    function upload(obj,cb) {
        var config = obj.data;
        obj._to = obj.data._from;
        delete obj.data['_from'];
        obj._from = 'server';
        obj.method = 'upload';
        var timer = 0;
        var allUploadHandle = [];
        var unUploadNum =0;
        var haveUpload = [];
        var totalSize = 0;
        var tempDir;
        var totalProcess = 0;
        var errFlag =false;
        _FILE.depart(config).done(function (deRet) {
            config.chunks = deRet.number;
            unUploadNum = deRet.number;
            totalSize = deRet.size;
            tempDir = deRet.dir;
            global_request.getPrepare(config).done(function (ret) {
                for(var k=0;k<deRet.number;k++){
                    var option = {
                        url:ret[k].host,
                        processCallback:process,
                        onend:onend,
                        onerror:onerror,
                        data:[{
                            name:"appKey",
                            contents:ret[k].appKey
                        },{
                            name:"token",
                            contents:ret[k].token
                        },{
                            name:"contextId",
                            contents:config.contextId
                        },{
                            name:"expires",
                            contents:ret[k].expires
                        },{
                            name:"file",
                            file: deRet.arr[k].dst
                        }],
                        id:k,
                        showProcess:config.showProcess
                    };
                    var trans = new global_CurlTransfer();
                    allUploadHandle[k] = trans.upload(option);
                    haveUpload[k]=0;
                }

            }).fail(function (e) {
                onerror(e);
            });
        }).fail(function (e) {
            onerror(e);
        });


        function process(total,now,id) {
            haveUpload[id]=now;
            var sum = 0;
            for(var j in haveUpload){
                sum +=haveUpload[j];
            }
            totalProcess = parseFloat(sum/totalSize*100).toFixed(2);
            if(timer==0){
                timer = setInterval(function () {
                    config.process = totalProcess;
                    config.process<100&&!errFlag&&hproseSend(obj);
                },500);

            }
        }

        function onerror(err) {
            clearInterval(timer);
            clearAllUpload(allUploadHandle,tempDir);
            config.process = -1;
            config.error = err;
            if(!errFlag) {
                if(cb) cb(obj);
                else hproseSend(obj);

            }
            errFlag = true;


        }

        function onend() {
            unUploadNum--;
            if(unUploadNum==0){
                global_request.upcomplete(config).done(function () {
                    clearInterval(timer);
                    config.process = 100;
                    if(cb) cb(obj);
                    else hproseSend(obj);
                    _COMMON.deleteDir(tempDir);
                }).fail(function (e) {
                    onerror(e);
                })
            }

        }
    }

    function clearAllUpload(arr,tempDir) {
        // for(var i in arr){
        //     arr[i].close();
        // }
        tempDir&&tempDir!=''&&_COMMON.deleteDir(tempDir);
    }

    /**
     * 文件下载（支持文件续传）
     * notice: 1.未下载完成文件的文件名有'.tmp'后缀，下载完成后会自动重命名
     */
    var easyCurl = {
        tasks: {},
        const_connect_timeout: 5,
        const_reconnect_interval: 500,
        const_section_reconnect_interval: 15,
        const_retry: 5,
        const_progress_notify: 1000,
        /**
         * 新增一个下载任务
         */
        addTask:function(id,obj){
            var _this = this;
            _this.tasks[id] = obj;
            return _this.tasks[id];
        },
        /**
         * 移除一个下载任务,会调用任务的close()方法来终止下载
         */
        removeTask:function(id){
            var _this = this;
            if(id == 0){
                for(var id in _this.tasks){
                    _this.tasks[id].close();
                }
                _this.tasks = {};
            }else{
                if(_this.findTask(id)){
                    _this.tasks[id].close();
                }
                delete _this.tasks[id];
            }
        },
        /**
         * 根据id查找下载任务
         */
        findTask:function(id){
            var _this = this;
            var task = _this.tasks[id];
            if(task){
                return task;
            }else{
                return false;
            }
        },
        /**
         * 文件下载
         * @param config
         * {
         *      method: 'easyCurlDownload',
         *      data: {
         *          id: '',
         *          _from: '',
         *          action: "easyCurlDownload",
         *          url: '',
         *          file: '',
         *          copy: {
         *            src:''
         *            dist: {}
         *           }
         *      },
         *      [ //可选参数
         *      easycurl: {
         *          reDownload: true/false, //是否强制重新下载
         *          retry: 5,
         *          connect_timeout: 5
         *      }
         *      ]
         *  }
         */
        download:function(config){
            var _this = this;
            var fs = require("fs");

            config._to = config.data._from;
            delete config.data['_from'];
            config._from = 'server';
            config.method = 'easyCurlDownload';

            var id = config.data.id;
            config.data.downloadId = id;
            // 自定义配置项
            var easycurl_config = config.easycurl || {};
            var reDownload = easycurl_config.reDownload;

            // 针对中文url进行编码
            config.data.url = _COMMON.cn_encodeuri(config.data.url);
            var url = config.data.url;
            var file = config.data.file;
            var sectionOption = {
                url: url,
                file: file + '.tmp',
                retry: config.retry ? easycurl_config.retry : _this.const_retry,
                timeout: _this.const_section_reconnect_interval,
                connect_timeout: easycurl_config.connect_timeout ? easycurl_config.connect_timeout : _this.const_connect_timeout
            };
            // 创建目录
            _this.makeFolder(file).done(function(){
                // 强制重新下载
                if(reDownload){
                    if(fs.existsSync(file)){
                        fs.unlinkSync(file);
                    }
                    if(fs.existsSync(sectionOption.file)){
                        fs.unlinkSync(sectionOption.file);
                    }
                    _this.sectionDownload(sectionOption,config);
                }else{
                    if(fs.existsSync(sectionOption.file)){
                        if(fs.existsSync(file)){
                            fs.unlinkSync(file);
                        }
                        // 续传
                        _COMMON.fileStat(sectionOption.file).done(function(pro){
                            var size = pro.size;
                            sectionOption.hasDownload = size;
                            _this.resumeDownload(sectionOption,config);
                        }).fail(function(e){
                            // 读取文件信息失败，重新下载
                            console.log(e);
                            fs.unlinkSync(sectionOption.file);
                            _this.sectionDownload(sectionOption,config);
                        });
                    }else{
                        // tmp文件不存在，重新下载
                        // 删除目标文件
                        if(fs.existsSync(file)){
                            fs.unlinkSync(file);
                        }
                        // 删除tmp文件
                        if(fs.existsSync(sectionOption.file)){
                            fs.unlinkSync(sectionOption.file);
                        }
                        _this.sectionDownload(sectionOption,config);
                    }
                }
            }).fail(function(err){
                config.data.process = -1;
                config.data.error = err;
                win.hproseSend(config);
                if(_this.findTask(id)){
                    _this.removeTask(id);
                }
                console.error(err);
            });
        },
        /**
         * 文件下载-流程分支1:重新下载
         * @param sectionOption
         * @param config 用户传入的数据
         */
        sectionDownload:function(sectionOption,config){
            var _this = this;
            var fs = require("fs");
            var id = config.data.downloadId;
            var total;
            var section = new win.global_DownloadSection(sectionOption);
            if(_this.findTask(id)){
                _this.removeTask(id);
            }
            _this.addTask(id,section);
            section.__timestamp = 0;
            section.download().then(function(){
                // 这里判断文件大小一致保证文件完整，写文件完成时触发这里
                if(section.hasDownload == section.total){
                    console.log('写文件完成，校验数据大小一致，待重命名');
                    _COMMON.renameFile(section.sectionOption.file,config.data.file).done(function(){
                        //拷贝
                        var copyObj = config.data.copy;
                        if(copyObj){
                            var cArr = [];
                            for(var k in copyObj.dst){
                                cArr.push({
                                    src:copyObj.src,
                                    dst:copyObj.dst[k]
                                })
                            }
                            global_queue(cArr,defCopy).done(function () {
                                console.log('拷贝文件成功');
                                console.log(copyObj);
                                config.data.process = 100;
                                win.hproseSend(config);
                                if(_this.findTask(id)){
                                    _this.removeTask(id);
                                }
                            }).fail(function (err) {
                                config.data.process = -1;
                                config.data.error = err;
                                win.hproseSend(config);
                                if(_this.findTask(id)){
                                    _this.removeTask(id);
                                }
                                // 再次确认删除目标文件
                                for(var k in copyObj.dst){
                                    if(fs.existsSync(copyObj.dst[k])){
                                        fs.unlinkSync(copyObj.dst[k]);
                                    }
                                }
                                console.error(err);
                                console.log('拷贝文件失败%s',err);
                            });

                            function defCopy(cnf) {
                                var def = $.Deferred();
                                _COMMON.copyFile(cnf.src,cnf.dst).done(function () {
                                    def.resolve();
                                }).fail(function (e) {
                                    def.reject('copy file fail');
                                });
                                return def.promise();
                            }
                        }else {
                            config.data.process = 100;
                            win.hproseSend(config);
                            if(_this.findTask(id)){
                                _this.removeTask(id);
                            }
                            console.log('重命名成功');
                        }
                    }).fail(function(err){
                        config.data.process = -1;
                        config.data.error = err;
                        win.hproseSend(config);
                        if(_this.findTask(id)){
                            _this.removeTask(id);
                        }
                        // 再次确认删除目标文件
                        if(fs.existsSync(config.data.file)){
                            fs.unlinkSync(config.data.file);
                        }
                        console.error(err);
                        console.log('重命名失败');
                    });
                }else{
                    if(section.hasDownload > section.total){
                        // 下载tmp文件大小超过远程文件大小，判定为异常
                        // 异常，删除tmp文件
                        if(fs.existsSync(sectionOption.file)){
                            fs.unlinkSync(sectionOption.file);
                        }
                        config.data.process = -1;
                        config.data.error = '校验数据大小失败';
                        win.hproseSend(config);
                        console.log('下载的tmp文件大小超过远程文件大小,下载失败');
                    }else{
                        // 下载未完成，可能是暂停下载，终止下载等场景，暂不发消息
                        config.data.process = -1;
                        config.data.error = '校验数据大小失败';
                        // win.hproseSend(config);
                        console.log('写文件完成，校验数据大小失败');
                    }
                }
            },function(err){
                /**
                 * 下载失败
                 * 常见错误：err.code = 7 "Couldn't connect to server"
                 */
                config.data.process = -1;
                config.data.error = err;
                win.hproseSend(config);
                if(_this.findTask(id)){
                    _this.removeTask(id);
                }
                console.error(err);
            },function(progress){
                if(Date.now() - section.__timestamp > _this.const_progress_notify) {
                    if(config.data.process != 100) {
                        config.data.process = Math.floor(progress.now / progress.total * 100);
                        win.hproseSend(config);
                    }
                    section.__timestamp = Date.now();
                }
            }).fail(function (err) {
                config.data.process = -1;
                config.data.error = err;
                win.hproseSend(config);
                if(_this.findTask(id)){
                    _this.removeTask(id);
                }
                console.error(err);
            });
        },
        /**
         * 文件下载-流程分支2:文件续传
         * @param sectionOption
         * @param config
         */
        resumeDownload:function(sectionOption,config){
            var _this = this;
            var fs = require("fs");
            var id = config.data.downloadId;
            var total;
            var section = new win.global_DownloadSection(sectionOption);
            if(_this.findTask(id)){
                _this.removeTask(id);
            }
            _this.addTask(id,section);
            section.__timestamp = 0;
            section.getTotal().then(function(all){
                total = all;
                section.total = all;
            }).then(function(){
                // 比较tmp文件和远程文件大小
                if(sectionOption.hasDownload == section.total){
                    console.log('校验数据大小一致，不需要下载，直接重命名');
                    // 重命名
                    _COMMON.renameFile(section.sectionOption.file,config.data.file).done(function(){
                        config.data.process = 100;
                        win.hproseSend(config);
                        if(_this.findTask(id)){
                            _this.removeTask(id);
                        }
                        console.log('重命名成功');
                    }).fail(function(err){
                        config.data.process = -1;
                        config.data.error = err;
                        win.hproseSend(config);
                        if(_this.findTask(id)){
                            _this.removeTask(id);
                        }
                        // 再次确认删除目标文件
                        if(fs.existsSync(config.data.file)){
                            fs.unlinkSync(config.data.file);
                        }
                        // 续传时出现重命名失败，判定异常，删除tmp文件
                        if(fs.existsSync(sectionOption.file)){
                            fs.unlinkSync(sectionOption.file);
                        }
                        console.error(err);
                        console.log('重命名失败');
                    });
                }else{
                    if(sectionOption.hasDownload < section.total){
                        // 下载续传
                        section.resume({
                            hasDownload: sectionOption.hasDownload,
                            sectionOption: sectionOption
                        }).then(function(){
                            // 这里判断文件大小一致保证文件完整，写文件完成时触发这里
                            if(section.total == section.hasDownload){
                                console.log('写文件完成，校验数据大小一致，待重命名-resume');
                                _COMMON.renameFile(section.sectionOption.file,config.data.file).done(function(){
                                    config.data.process = 100;
                                    win.hproseSend(config);
                                    if(_this.findTask(id)){
                                        _this.removeTask(id);
                                    }
                                    console.log('重命名成功');
                                }).fail(function(err){
                                    config.data.process = -1;
                                    config.data.error = err;
                                    win.hproseSend(config);
                                    if(_this.findTask(id)){
                                        _this.removeTask(id);
                                    }
                                    // 再次确认删除目标文件
                                    if(fs.existsSync(config.data.file)){
                                        fs.unlinkSync(config.data.file);
                                    }
                                    console.error(err);
                                    console.log('重命名失败');
                                });
                            }else{
                                if(section.hasDownload > section.total){
                                    // 下载tmp文件大小超过远程文件大小，判定为异常
                                    config.data.process = -1;
                                    config.data.error = '校验数据大小失败';
                                    win.hproseSend(config);
                                    // 异常，删除tmp文件
                                    if(fs.existsSync(sectionOption.file)){
                                        fs.unlinkSync(sectionOption.file);
                                    }
                                    console.log('写文件完成，校验数据大小失败');
                                }else{
                                    // 下载未完成，可能是暂停下载，终止下载等场景，暂不发消息
                                    config.data.process = -1;
                                    config.data.error = '校验数据大小失败';
                                    // win.hproseSend(config);
                                    console.log('写文件完成，校验数据大小失败，-resume');
                                }
                            }
                        },function(err){
                            /**
                             * 下载失败
                             * 常见错误：err.code = 7 "Couldn't connect to server"
                             */
                            config.data.process = -1;
                            config.data.error = err;
                            win.hproseSend(config);
                            if(_this.findTask(id)){
                                _this.removeTask(id);
                            }
                            console.error(err);
                        },function(progress){
                            if(Date.now() - section.__timestamp > _this.const_progress_notify) {
                                if(config.data.process != 100) {
                                    config.data.process = Math.floor(progress.now / progress.total * 100);
                                    win.hproseSend(config);
                                }
                                section.__timestamp = Date.now();
                            }
                        }).fail(function (err) {
                            config.data.process = -1;
                            config.data.error = err;
                            win.hproseSend(config);
                            if(_this.findTask(id)){
                                _this.removeTask(id);
                            }
                            console.error(err);
                        });
                    }else{
                        // 下载的tmp文件大小超过远程文件大小，判定为异常
                        // 删除tmp文件
                        if(fs.existsSync(sectionOption.file)){
                            fs.unlinkSync(sectionOption.file);
                        }
                        // 重新下载
                        if(sectionOption.hasDownload){
                            delete sectionOption.hasDownload;
                        }
                        _this.sectionDownload(sectionOption,config);
                        console.log('下载的tmp文件大小超过远程文件大小,续传失败，启动重新下载');
                    }
                }
            }).fail(function(err){
                config.data.process = -1;
                config.data.error = err;
                win.hproseSend(config);
                if(_this.findTask(id)){
                    _this.removeTask(id);
                }
                console.error(err);
            });
        },
        /**
         * 取消下载
         * note:取消下载后，写文件流会终止并触发download()流程success回调,
         *  在success回调里会通过校验文件大小来抛出下载失败
         * @param message
         */
        close:function(message){
            var _this = this;
            var config = message;
            config._to = config.data._from;
            delete config.data['_from'];
            config._from = 'server';
            config.method = 'stopEasyCurlDownload';

            var id = config.data.downloadId;
            var task = this.findTask(id);
            if(task){
                // 终止状态 1 or 0
                config.data.status = 1;
                win.hproseSend(config);
                if(_this.findTask(id)){
                    _this.removeTask(id);
                }
            }else{
                // 终止状态 1 or 0
                // 即使下载任务不存在，仍返回1，确保页面正常显示
                config.data.status = 1;
                win.hproseSend(config);
            }
        },
        /**
         * 根据文件全路径（包括文件名称）创建文件所在目录
         * @param path
         * @returns {*}
         */
        makeFolder:function(path){
            var def = $.Deferred();
            var _path = require('path');
            var mkdirp = require('mkdirp');
            var folderName = _path.dirname(path);
            _COMMON.existFile(folderName).done(function(){
                console.log('文件目录存在');
                def.resolve();
            }).fail(function(e){
                console.log('文件目录不存在');
                mkdirp(folderName,function(err){
                    if(err){
                        console.error(err);
                        def.reject(err);
                    }else{
                        console.log('文件目录已创建');
                        def.resolve();
                    }
                });
            });
            return def.promise();
        }
    };

    win.global_upload = upload;
    win.global_stopDownload = stopDownload;
    win.global_download = download;
    win.global_easyCurl = easyCurl;
})(window);


