local luaModule = require("luaModule")

--[[

	{"MsgBox",MsgBox},

	{"IsFileExist",IsFileExist},

	{"GetCurrentDir",GetCurrentDir},

	{"RegCreate",RegCreate},

	{"RegRead",RegRead},

	{"RegWrite",RegWrite},



#define REG_SZ                      ( 1 )   // Unicode nul terminated string

#define REG_EXPAND_SZ               ( 2 )   // Unicode nul terminated string

                                            // (with environment variable references)

#define REG_BINARY                  ( 3 )   // Free form binary (not support yet)

#define REG_DWORD                   ( 4 )   // 32-bit number

]]

local RegType = {

	REG_SZ = 1,

	REG_EXPAND_SZ = 2,

	REG_DWORD = 4

}

local SW_MODE = {
	SW_SHOW = 5,
	SW_HIDE = 0
}

local currentDir = luaModule.GetCurrentDir()

local initializeLock = currentDir.."\\Initialize.lock"
local serviceFlag = currentDir.."\\TaServiceRunning.flag"

os.remove(currentDir.."\\ifbExiting.flag")
os.remove(currentDir.."\\ifbrun.flag")

if luaModule.IsFileExist(currentDir.."\\setup.flag") == 0 then
	local file = io.open(currentDir.."\\setup.flag","r")
	local updateExe = file:read("*a")
	file:close()
	os.remove(currentDir.."\\setup.flag")
	luaModule.RunExe(updateExe,SW_MODE.SW_SHOW)
end

if luaModule.IsFileExist(currentDir.."\\user\\user.db") ~= 0 then
	sourcefile = io.open(currentDir.."\\user\\user.default.db", "rb")
	destinationfile = io.open(currentDir.."\\user\\user.db", "wb")
	destinationfile:write(sourcefile:read("*all"))
	sourcefile:close()
	destinationfile:close()
end

if luaModule.IsFileExist(initializeLock) == 0 then

	-- luaModule.MsgBox("¼ì²âµ½ÄúÎªÊ×´ÎÔËÐÐ£¬¼´½«ÎªÄú³õÊ¼»¯Ïà¹Ø»·¾³")

	local err_read,isNetFramwork4Install = luaModule.RegRead("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Full","Install",RegType.REG_DWORD)

	if isNetFramwork4Install ~= 1 then

		luaModule.RunExe(".\\setup\\dotNetFx40_Full_x86_x64.exe",SW_MODE.SW_SHOW)

	end

	-- luaModule.RegCreate("HKEY_CURRENT_USER\\SOFTWARE","iflytek")

	-- luaModule.RegCreate("HKEY_CURRENT_USER\\SOFTWARE\\iflytek","TPlatform")

	-- luaModule.RegWrite("HKEY_CURRENT_USER\\SOFTWARE\\iflytek\\TPlatform","installPath",RegType.REG_SZ,currentDir)

	-- luaModule.RegWrite("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run","hproseServer",RegType.REG_SZ,"\""..currentDir.."\\nw.exe\" \""..currentDir.."\\hprose_server\"")

	-- luaModule.RegWrite("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run","TAHotInit",RegType.REG_SZ,"\""..currentDir.."\\nw.exe\" \""..currentDir.."\\hotInit\"")

	luaModule.RegDeleteVal("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run","hproseServer")
	
	luaModule.RegDeleteVal("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run","TAHotInit")

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes",".sco")

	luaModule.RegWrite("HKEY_CURRENT_USER\\Software\\Classes\\.sco","",RegType.REG_SZ,"sco.file")

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes","sco.file")

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes\\sco.file","DefaultIcon")

	luaModule.RegWrite("HKEY_CURRENT_USER\\Software\\Classes\\sco.file\\DefaultIcon","",RegType.REG_SZ,currentDir.."\\tools\\card_tool\\sco.ico")

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes\\sco.file","shell")

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes\\sco.file\\shell","open")

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes\\sco.file\\shell\\open","command")

	luaModule.RegWrite("HKEY_CURRENT_USER\\Software\\Classes\\sco.file\\shell\\open\\command","",RegType.REG_SZ,'"'..currentDir..'\\tools\\card_tool\\nw.exe" "%1"')

-- Add Url Protocol : xfurl

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes","xfurl")

	luaModule.RegWrite("HKEY_CURRENT_USER\\Software\\Classes\\xfurl","",RegType.REG_SZ,"IflytekProtocol")

	luaModule.RegWrite("HKEY_CURRENT_USER\\Software\\Classes\\xfurl","URL Protocol",RegType.REG_SZ,'"'..currentDir..'\\TPlatform.exe"')

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes\\xfurl","shell")

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes\\xfurl\\shell","open")

	luaModule.RegCreate("HKEY_CURRENT_USER\\Software\\Classes\\xfurl\\shell\\open","command")

	luaModule.RegWrite("HKEY_CURRENT_USER\\Software\\Classes\\xfurl\\shell\\open\\command","",RegType.REG_SZ,'"'..currentDir..'\\TPlatform.exe" "%1"')

	luaModule.RunExe(".\\env.bat",SW_MODE.SW_HIDE);
	-- schtasks /Create /TN HPROSE_SERVER /TR \"D:\Repo\Git\TA\nw.exe\"  /SC ONLOGON /RL HIGHEST
	luaModule.luaShellExecuteEx("schtasks",'/Create /TN HPROSE_SERVER /TR "'..currentDir..'\\EduTasks.exe'..'"  /SC ONLOGON /RL HIGHEST /F',SW_MODE.SW_HIDE);
	
	os.remove(".\\Initialize.lock")

end

-- luaModule.luaShellExecuteEx(".\\tools\\TAmcServer.exe","");
luaModule.luaShellExecuteEx(currentDir.."\\nw.exe",'"'..currentDir..'\\hprose_server"',SW_MODE.SW_SHOW);
luaModule.luaShellExecuteEx(".\\tools\\TAdum.exe","",SW_MODE.SW_SHOW);
-- luaModule.luaShellExecuteEx(".\\plugins\\63\\iFlySlide.exe","",SW_MODE.SW_SHOW);
luaModule.luaShellExecuteEx(".\\nw.exe",".\\main "..g_autoLoginCmd,SW_MODE.SW_SHOW);