/**
 * Created by pengfu on 15-4-8.
 */

var preview =(function($,win){

    function getType(url,attachType){
        var type = url.split(".");
        var length = type.length;
        type = type[length-1];
        var types = ["jpg","png","gif","jpeg","bmp","mp3","wma","wav","ogg",
            "ape","mid","midi","avi","flv","wmv","3gp","mpg","rmvb","rm","asf",
            "mp4","swf","doc","docx","txt","pdf","xlsx","xls","ppt","pptx"];
        var flag = false;
        for(var i in types){
            if(types[i] == type){
                flag = true;
            }
        }
        if(!flag){
            if(attachType == 3){
                type = 'stroke';//自己定义
            }
        }
        return type;

    }


    return {
        DIVSelctor:"previewResDiv",
        IDSelector:"previewResLi",
        $previewDiv:null,
        $preview:null,
        isInit:false,
        previewObj :{},
        //仅仅几种类型资源有多预览图
        previewUrls: [],
        currIndex : 0,

        $nextBtn :$("#nextBtn"),
        $preBtn: $("#preBtn"),
        $ListsBtn : $("#ListsBtn"),
        $downloadBtn : $("#downloadBtn"),
        $closeBtn: $("#closeBtn_pre"),

        $zoomOutBtn : $("#zoomOutBtn"),
        $zoomInBtn : $("#zoomInBtn"),
        $magicLable: $("#magicLable"),

        /**
         * 以下为缩放需求添加
         */
        mousePoint : {    //鼠标位置
            x: 0,
            y: 0
        },
        offset : {       //translate偏移计算
            x: 0,
            y: 0,
            baseX: 0,
            baseY: 0
        },
        enableMove:false,
        hasMove: false,
        rate : 1,

        init:function(IdSelector){
            var _self = this;
            if(this.isInit){
                return;
            }
            this.isInit = true;

            if("undefined" != typeof IdSelector){
                this.IDSelector = IdSelector;
            }

            this.$previewDiv = $("#" + this.DIVSelctor);
            this.$preview = $("#"+ this.IDSelector);

            //为window绑定mouseup事件
            $(win).mouseup(function(e){
                _self.enableMove = false;
                if (_self.hasMove) {
                    _self.offset.baseX += _self.offset.x;
                    _self.offset.baseY += _self.offset.y;

                    _self.hasMove = false;
                }

            })

            //为window绑定滚轮事件
            $(win).on('mousewheel',function(e){
//                alert('mousewheel')
                var delta = e.originalEvent.wheelDelta;
                if(delta > 0){
                    //up,放大
                    _self.enableMove = false;
                    _self.rate += 0.1;
                    _self.$preview.find('img').css({
                        '-webkit-transform': 'translate(' + _self.offset.baseX + "px," + _self.offset.baseY + "px" + ') scale(' + _self.rate + ')'
                    });

                }else if(delta < 0){
                    //down，缩小
                    if (_self.rate >= 1.1) {
                        _self.rate -= 0.1;
                        if (_self.rate == 1) {
                            _self.offset.baseX = 0;
                            _self.offset.baseY = 0;

                        }
                        _self.$preview.find('img').css({
                            '-webkit-transform': 'translate(' + _self.offset.baseX + "px," + _self.offset.baseY + "px" + ') scale(' + _self.rate + ')'
                        });
                    }

                }

            })

            this.$closeBtn.click(function(e){

                var audio = _self.$preview.find('audio')[0];
                audio && audio.pause();
                _self._clearData();
                _self.$previewDiv.hide();

            })

            //下一张
            this.$nextBtn.click(function(){
                _self._clearData();
                if(_self.currIndex >=0 && _self.currIndex < _self.previewUrls.length - 1){
                    _self.currIndex ++;
                    _self.previewImg(_self.previewUrls[_self.currIndex],true);
                }
            })

            //上一张
            this.$preBtn.click(function(){
                _self._clearData();
                if(_self.currIndex > 0 && _self.currIndex <= _self.previewUrls.length - 1){
                    _self.currIndex --;
                    _self.previewImg(_self.previewUrls[_self.currIndex],true);
                }
            })

            //放大--zoomout本义是缩小，这里弄反了
            this.$zoomOutBtn.click(function(){
//                alert('zoomout')
                _self.enableMove = false;
                _self.rate += 0.1;
                _self.$preview.find('img').css({
                    '-webkit-transform': 'translate(' + _self.offset.baseX + "px," + _self.offset.baseY + "px" + ') scale(' + _self.rate + ')'
                });

            })

            //缩小
            this.$zoomInBtn.click(function(){
//                alert('zoomin')
                _self.enableMove = false;
                if (_self.rate >= 1.1) {
                    _self.rate -= 0.1;
                    if (_self.rate == 1) {
                        _self.offset.baseX = 0;
                        _self.offset.baseY = 0;

                    }
                    _self.$preview.find('img').css({
                        '-webkit-transform': 'translate(' + _self.offset.baseX + "px," + _self.offset.baseY + "px" + ') scale(' + _self.rate + ')'
                    });
                }

            })


//            this.IDSelector

            //下载
            this.$downloadBtn.click(function(){
                var file = _self.previewObj.downloadUrl;
                var name = _self.previewObj.attachName;
                var opt_params = {};
                opt_params.nwsaveas = name;
                //.doc
                opt_params.accept = file.substring(file.lastIndexOf('.'),file.length);
                shellcmd.saveFileDialog(opt_params).done(function(ret){
//                    console.error(ret)
                    //ret 为保存文件名
                    //TODO:判断文件存在不存在
                    var obj = {"type":"logic",
                        "action":"ta_download",
                        "from":"ta",
                        "to":"ta_dum",
                        "id":0,
                        "data":{"id":"abcdee","file":ret,"url":file}
                    }

                    socket.send(obj);

                });
            })

        },

        /**
         * 复位相关数据
         * @private
         */
        _clearData : function (){
            var _self = this;
            _self.mousePoint = {    //鼠标位置
                x: 0,
                y: 0
            };

            _self.offset = {       //translate偏移计算
                x: 0,
                y: 0,
                baseX: 0,
                baseY: 0
            };

            _self.rate = 1;
        },

        /**
         * @public
         * @param obj
         */
        previewSingle :function (obj){
            var _self = this;
            _self.previewObj = obj;
            _self.previewUrls = [];
            _self.currIndex = 0;
            _self.init();
            //很搓，第三个参数完全为判断该资源可能是什么类型
            _self.preview(obj.attachType,obj.previewUrl,obj.downloadUrl);

        },

        preview:function(attachType,url,downloadUrl){
            if(url == "" || url == null){
                pageMyInteract.showDialog("文件不存在" + face.ng);
                return;
            }
            //这个地方处理下放大，缩小按钮显示，默认都隐藏
            this.$zoomOutBtn.css('display','inline-block');
            this.$zoomInBtn.css('display','inline-block');
            this.$magicLable.css('display','inline-block');
            this.$ListsBtn.css('display','inline-block');

            var type = getType(downloadUrl,attachType);
            switch(type){
                case "jpg":
                case "png":
                case "gif":
                case "jpeg":
                case "bmp":
                    this.previewImg(url,false);
                    break;
                case "mp3":
                case "wma":
                case "wav":
                case "ogg":
                case "ape":
                case "mid":
                case "midi":
                    this.previewAudio(url);
                    break;
                case "avi":
                case "flv":
                case "wmv":
                case "3gp":
                case "mpg":
                case "rmvb":
                case "rm":
                case "asf":
                case "mp4":
                    this.previewFlv(url);
                    break;
                case "swf":
                    this.previewFlash(url);
                    break;
                case "doc":
                case "docx":
                case "txt":
                case "xlsx":
                case "xls":
                case "ppt":
                case "pptx":
                case "pdf":
                    this.previewOffice(url);
                    break;
                case "stroke":
                    this.previewChineseStroke(downloadUrl);
                    break;
                default:
                    pageMyInteract.showDialog("暂不支持预览."+  type + "格式" + face.ng);
            }
        },

        // 预览图片文件
        previewImg: function(fileurl,flag) {
            var _self = this;

            //预览图片时，显示放大缩小按钮，供缩放用
            this.$ListsBtn.css('display','inline-block').css('left','327px');
            this.$zoomOutBtn.css('display','inline-block');
            this.$zoomInBtn.css('display','inline-block');
            this.$magicLable.css('display','inline-block');
            this.$downloadBtn.css('display','inline-block');

            this.$preview.html('');
            this.$preview.html("<img src='"
                + fileurl
                + "'></img>");
            if(!flag){
                this.$nextBtn.css('display','none');
                this.$preBtn.css('display','none');
            }else {
                this.$nextBtn.css('display','block');
                this.$preBtn.css('display','block');
            }

            this.$previewDiv.show();
//            this.$preview.mousedown(function(e){
//                alert('down')
//            })
            $('#'+preview.IDSelector).find("img").load(function(){
                var that = this;
                setPicStyle(this);
                $(this).bind('dragstart',function(){
                    return false;
                })
                    .mousedown(function(e){
//                    alert('pic down')
                    _self.enableMove = true;
                    _self.mousePoint.x = e.originalEvent.clientX;
                    _self.mousePoint.y = e.originalEvent.clientY;
                    console.log( _self.mousePoint.x)
                    console.log( _self.mousePoint.y)
                })
                    .mousemove(function(e){
//                        alert('move')
                        if(_self.enableMove){
                            _self.hasMove = true;
                            _self.offset.x = e.originalEvent.clientX - _self.mousePoint.x;
                            _self.offset.y = e.originalEvent.clientY - _self.mousePoint.y;
                            var offsetX = _self.offset.x + _self.offset.baseX;
                            var offsetY = _self.offset.y + _self.offset.baseY;
                            $(that).css({
                                '-webkit-transform':
                                    'translate(' + offsetX + "px," + offsetY + "px" + ') scale(' + _self.rate + ')'
                            })
                        }
                    })
                    .mouseup(function(e){
                        _self.enableMove = false;
                        if (_self.hasMove) {
                            _self.offset.baseX += _self.offset.x;
                            _self.offset.baseY += _self.offset.y;

                            _self.hasMove = false;
                        }
                    })

            });

            function setPicStyle(that){
                $(that).css("max-width", "100%");
                $(that).css("max-height", "100%");
                var naturalWidth = $(that)[0].naturalWidth;
                var naturalHeight = $(that)[0].naturalHeight;
                var nowWidth = $(that).width();
                var nowHeight = $(that).height();
                if(naturalWidth <= 700 && naturalHeight <= 456){
                    $(that).css("margin-left",(700-naturalWidth)/2);
                    $(that).css("margin-top",(456-naturalHeight)/2);
                }else if(naturalWidth <= 700 && naturalHeight > 456){
                    $(that).css("margin-left",(700-nowWidth)/2);
                    $(that).css("margin-top",0);
                }else if(naturalWidth > 700 && naturalHeight <= 456){
                    $(that).css("margin-left",0);
                    $(that).css("margin-top",(456-nowHeight)/2);
                }else {
                    $(that).css("margin-left",(700-nowWidth)/2 > 0 ? (700-nowWidth)/2 : 0);
                    $(that).css("margin-top",(456-nowHeight)/2 > 0 ? (456-nowHeight)/2 : 0);
                }
            }
        },

        // 预览音频
        previewAudio:function(fileurl) {

            this.$ListsBtn.css('display','inline-block').css('left','404px');
            this.$zoomOutBtn.css('display','none');
            this.$zoomInBtn.css('display','none');
            this.$magicLable.css('display','none');
            this.$downloadBtn.css('display','inline-block');
            this.$preview.html('');

            this.$preview.html("<audio src='"
                + fileurl
                + "' controls='control' autoplay='autoplay'></audio>");
            this.$preview.find('audio').css('width','425px').css('margin-left','136px').css('height','270px');
            this.$nextBtn.css('display','none');
            this.$preBtn.css('display','none');
            this.$previewDiv.show();

        },

        // 预览FLV视频文件
        previewFlv:function(fileurl) {
            var _self = this;
            this.$ListsBtn.css('display','inline-block').css('left','404px');
            this.$zoomOutBtn.css('display','none');
            this.$zoomInBtn.css('display','none');
            this.$magicLable.css('display','none');
            this.$downloadBtn.css('display','inline-block');
            this.$preview.html('');
            this.$nextBtn.css('display','none');
            this.$preBtn.css('display','none');
            this.$previewDiv.show();
            $.getScript("../main/assets/js/thirdparty/flowplayer/flowplayer-3.2.11.min.js",function(){
                $f(preview.IDSelector, "../main/assets/js/thirdparty/flowplayer/flowplayer-3.2.16.swf", {
                    clip: {	url: fileurl, scaling: "fit"},
                    plugins: {
                        controls: {
                            autoHide: false,
                            url: "../main/assets/js/thirdparty/flowplayer/flowplayer.controls-3.2.15.swf"
                        }
                    },
                    onLoad:function(){
                        _self.$preview.find('object').css("height", "491px");
                        _self.$preview.find('object').css("width", "710px");
                    }
                });
            });
        },

        // 预览office文件
        previewOffice:function (url) {
//            pageMyInteract.showDialog("暂不支持预览office文件" + face.ng);

            //url为json字符串
            var obj = null;
            this.previewUrls = [];
            try{
                obj = JSON.parse(url);
            }catch (e){
                pageMyInteract.showDialog("暂不能预览该资源" + face.ng);
            }

            if(obj.status == 1){
                //转多预览图成功
                var viewObj = JSON.parse(obj.result);
                for(var i in viewObj){
                    this.previewUrls.push(viewObj[i]);
                }
                if(this.previewUrls.length > 1){
                    this.previewImg(this.previewUrls[0],true);
                }else if(this.previewUrls.length == 1 ){
                    this.previewImg(this.previewUrls[0],false);
                }else {
                    pageMyInteract.showDialog("暂不能预览该资源" + face.ng);
                }


            }else if(obj.status == 2){
                //转失败
                pageMyInteract.showDialog("暂不能预览该资源" + face.ng);
            }else if(obj.status == 3){
                //正在转
                pageMyInteract.showDialog("预览正在加载中，请稍后刷新重试" + face.ng);
            }

        },

        // 预览flash动画
        previewFlash:function (url) {

            this.$preview.html('');
            this.$preview.html("<embed src='"
                + url
                + "' autostart='true' play='true' wmode='transparent'></embed>");
            this.$preview.find('embed').css('width','680px').css('height','489px');
            this.$nextBtn.css('display','none');
            this.$preBtn.css('display','none');
            this.$previewDiv.show();
        },

        //预览中文汉字笔顺
        previewChineseStroke:function(url){
            this.$downloadBtn.css('display','none');
            this.$preview.html('');
            this.$preview.html("<iframe src='"
                + url
                + "' style= 'height:300px;'></iframe>");
            this.$preview.find('iframe')
                .css('margin-left','199px').css('margin-top','108px')
                .css('border','none').load(function(){
                    $(this).css('height','309px');

                });
            this.$ListsBtn.css('display','none');
            this.$nextBtn.css('display','none');
            this.$preBtn.css('display','none');
            this.$previewDiv.show();
        }

    };

})(jQuery,window);

