;(function (w) {
    if (typeof w.NC == "undefined") {
        var ObjProto = Object.prototype,toString = ObjProto.toString;
        function getFinalObject(name,host){
            var i, ni, nis = name.split("."), ns = host;
            for (i = 0; i < nis.length; i = i + 1) {
                ni = nis[i];
                ns[ni] = ns[ni] || {};
                ns = ns[nis[i]];
            }
            return ns;
        }
        var NC = function () {
            /**
             * 创建名字空间方法
             * @param name 名字空间
             * @returns {{}}
             */
            this.namespace = function (name) {
                var i, ni, nis = name.split("."), ns = w;
                for (i = 0; i < nis.length; i = i + 1) {
                    ni = nis[i];
                    ns[ni] = ns[ni] || {};
                    ns = ns[nis[i]];
                }
                return ns;
            };
            /**
             * 扩展对象属性
             * @param target 待扩展的源对象
             * @param source 扩展对象
             * @param override 是否覆盖
             * @returns {*}
             */
            this.mix = function (target, source, override) {
                if (!source || !target)
                    return target;
                var i, p, l;

                for (p in source) {
                    if (!(p in target)) {
                        target[p] = source[p];
                    } else {
                        if (override) {
                            target[p] = source[p];
                        }
                    }
                }
                return target;
            }

            /**
             * 改变func函数的作用域scope，即this的指向
             * @param func 待执行方法
             * @param self this指向
             */
            this.delegate = function (func, self) {
                var context = self || window;
                if (arguments.length > 2) {
                    var args = Array.prototype.slice.call(arguments, 2);
                    return function () {
                        var newArgs = Array.prototype.concat.apply(args, arguments);
                        return func.apply(context, newArgs);
                    };
                }
                else {
                    return function () {
                        return func.apply(context, arguments);
                    };
                }
            };

            /**
             * 注册模块方法
             * @param name 模块名
             * @param dependencies 依赖模块
             * @param fn 模块方法体
             * @returns {*}
             */
            this.add = function (name, dependencies, fn) {
                var self = this;
                if (arguments.length == 2 && this.isFunction(dependencies)) {
                    fn = dependencies;
                    dependencies = null;
                }
                //self.namespace(name);
                // override mode
                var obj=getFinalObject(name,self);
                obj = {
                    name:name,
                    fn:fn
                };
                if (dependencies && this.isArray(dependencies)) {
                    this.forEach(dependencies, function (index, i) {
                        if (!getFinalObject(index,self)) {
                            throw  new Error('依赖项未加载');
                        }
                    });
                }
                if (dependencies && typeof (dependencies) == 'string') {
                    if (!getFinalObject(dependencies,self)) {
                        throw new Error('依赖项未加载');
                    }
                }
                fn(self);
                return self;
            }
        };
        w.NC = new NC();
        w.NC.mix(w.NC, {
            Config:{
                debug:true,
                version:'0.5.7'
            },
            mods:{},
            Env:{
                guid:1000
            },
            /**
             * 全局不重复ID
             * @param pre 前缀
             * @returns {string}
             */
            guid:function (pre) {
                var id = this.Env.guid++ + '';
                return pre ? pre + id : id;
            },
            /**
             * 随机数
             * @param min 最小值
             * @param max 最大值
             * @returns {number}
             */
            random:function (min, max) {
                return Math.floor(Math.random() * (max - min + 1) + min);
            },
            /**
             * 当前时间戳
             * @returns {number}
             */
            now:function () {
                return +new Date();
            },
            /**
             * 生成类
             * @param source 基类结构体名称
             * @param proto 扩展属性
             * @returns {Function}
             */
            oop:function (source, proto) {
                if (arguments.length == 1) {
                    proto = source;
                    source = function () {                   }
                }
                function Class() {
                    if (typeof this.init === 'function') {
                        this.init.apply(this, arguments);
                    }
                }

                Class.prototype = new source();
                this.mix(Class.prototype, proto,true);
                Class.constructor = Class;
                return Class;
            },
            /**
             * 对象的循环遍历
             * @param obj 对象引用
             * @param callback
             */
            each:function (obj, callback) {
                for (var x in obj) {
                    if (obj.hasOwnProperty(x)) callback(obj[x], x);
                }
            },
            /**
             * 对数组的每个元素调用定义的回调函数并返回包含结果的数组
             * @param obj 对象引用
             * @param callback
             */
            map:function (obj, callback) {
                for (var x in obj) {
                    obj[x] = callback(obj[x], x);
                }
                return obj;
            },
            /**
             * 数组的循环遍历
             * @param arr 数组引用
             * @param callback
             * @param 起始位置
             */
            forEach:function (arr, callback, start) {
                var cancelled;
                if (arr) {
                    arr = arr instanceof Array ||
                        (typeof(arr.length) === 'number' && (typeof(arr.callee) === "function" || (arr.item && typeof(arr.nodeType) === "undefined") && !arr.addEventListener && !arr.attachEvent)) ? arr : [arr];
                    for (var i = start || 0, l = arr.length; i < l; i++) {
                        if (callback(arr[i], i)) {
                            cancelled = true;
                            break;
                        }
                    }
                }
                return !cancelled;
            },
            /**
             * 切片方法扩展，用以处理HTMLCollection
             * @returns {Function}
             */
            slice:function () {
                var item = arguments[0] || [], method = Array.prototype.slice;
                if (!(item instanceof Object)) {
                    var i = item.length, ret = [];
                    while (i--) {
                        ret[i] = item[i]
                    }
                    item = ret;
                }
                return method.apply(item, method.call(arguments, 1));
            }
        });
    }
    w.NC.forEach(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp',"Array","Boolean"], function (name) {
        w.NC['is' + name] = function (obj) {
            return toString.call(obj) == '[object ' + name + ']';
        };
    });
    return w.NC;


})(window)

if (window.NC) {
    NC.add('browser', function(S){
        var  ua = navigator.userAgent;
        var os = S.os = {}, browser = S.browser = {},
            webkit = ua.match(/WebKit\/([\d.]+)/),
            android = ua.match(/(Android)\s+([\d.]+)/),
            ipad = ua.match(/(iPad).*OS\s([\d_]+)/),
            iphone = !ipad && ua.match(/(iPhone\sOS)\s([\d_]+)/),
            webos = ua.match(/(webOS|hpwOS)[\s\/]([\d.]+)/),
            touchpad = webos && ua.match(/TouchPad/),
            kindle = ua.match(/Kindle\/([\d.]+)/),
            silk = ua.match(/Silk\/([\d._]+)/),
            blackberry = ua.match(/(BlackBerry).*Version\/([\d.]+)/),
            bb10 = ua.match(/(BB10).*Version\/([\d.]+)/),
            rimtabletos = ua.match(/(RIM\sTablet\sOS)\s([\d.]+)/),
            playbook = ua.match(/PlayBook/),
            chrome = ua.match(/Chrome\/([\d.]+)/) || ua.match(/CriOS\/([\d.]+)/),
            firefox = ua.match(/Firefox\/([\d.]+)/);

        // Todo: clean this up with a better OS/browser seperation:
        // - discern (more) between multiple browsers on android
        // - decide if kindle fire in silk mode is android or not
        // - Firefox on Android doesn't specify the Android version
        // - possibly devide in os, device and browser hashes

        if (browser.webkit = !!webkit) browser.version = webkit[1]

        if (android) os.android = true, os.version = android[2]
        if (iphone) os.ios = os.iphone = true, os.version = iphone[2].replace(/_/g, '.')
        if (ipad) os.ios = os.ipad = true, os.version = ipad[2].replace(/_/g, '.')
        if (webos) os.webos = true, os.version = webos[2]
        if (touchpad) os.touchpad = true
        if (blackberry) os.blackberry = true, os.version = blackberry[2]
        if (bb10) os.bb10 = true, os.version = bb10[2]
        if (rimtabletos) os.rimtabletos = true, os.version = rimtabletos[2]
        if (playbook) browser.playbook = true
        if (kindle) os.kindle = true, os.version = kindle[1]
        if (silk) browser.silk = true, browser.version = silk[1]
        if (!silk && os.android && ua.match(/Kindle Fire/)) browser.silk = true
        if (chrome) browser.chrome = true, browser.version = chrome[1]
        if (firefox) browser.firefox = true, browser.version = firefox[1]

        os.tablet = !!(ipad || playbook || (android && !ua.match(/Mobile/)) || (firefox && ua.match(/Tablet/)))
        os.phone  = !!(!os.tablet && (android || iphone || webos || blackberry || bb10 ||
            (chrome && ua.match(/Android/)) || (chrome && ua.match(/CriOS\/([\d.]+)/)) || (firefox && ua.match(/Mobile/))));

        browser.vendor=webkit?'webkit':firefox? 'moz':'';
        browser.hasTouch="ontouchstart" in window?true:false;
        S.requestAnimationFrame = (function() {
            return window.requestAnimationFrame
                || window.webkitRequestAnimationFrame
                || window.mozRequestAnimationFrame
                || window.oRequestAnimationFrame
                || window.msRequestAnimationFrame
                || function(callback) { return setTimeout(callback, 50); }
        })();
        S.cancelRequestAnimationFrame = (function () {
            return window.cancelRequestAnimationFrame
                || window.webkitCancelAnimationFrame
                || window.webkitCancelRequestAnimationFrame
                || window.mozCancelRequestAnimationFrame
                || window.oCancelRequestAnimationFrame
                || window.msCancelRequestAnimationFrame
                || clearTimeout
        })();
    })
}

NC.add('Pages.SwitchBehavior', function (S) {
    var SwitchStyleEnum = {
        'NONE': 'None',
        'SLIDE': 'Slide'
    };

    S.Pages.SwitchStyleEnum = SwitchStyleEnum;
    S.Pages.SwitchBehavior = Behavior;
    function Behavior(current, target,style,callback) {
        SwitchAction[style]&&SwitchAction[style](current,target,callback);
    }
    function normalizeEvent(name) { return S.browser.vendor ? S.browser.vendor + name : name.toLowerCase() }


    var SwitchAction = {
        'None': function (current, target, callback) {
            current && (current.getPageDom().style.display = 'none');
            target.getPageDom().style.display = 'block';
            callback && callback(current,target);
        },
        'Slide': function (current, target, callback) {
            'use strict';
            var targetDom = target.getPageDom(), currDom;
            var startLeft,startTop;
            var wrappedCallback,fired;
            if(current){
                currDom = current.getPageDom();
                startLeft=window.getComputedStyle(currDom,null).left;
                startTop=window.getComputedStyle(currDom,null).top;
                currDom.style['left'] = 0;
                currDom.style['top'] = 0;
                targetDom.style['left'] = window.getComputedStyle(currDom,null).width;
                targetDom.style['top'] = 0;
                targetDom.style['display']='block';
                currDom.style[S.browser.vendor + 'Transform']='translate3d(-100%,0,0)';
                currDom.style[S.browser.vendor + 'Transition']='all 0.4s';
                targetDom.style[S.browser.vendor + 'Transform']='translate3d(-100%,0,0)';
                targetDom.style[S.browser.vendor + 'Transition']='all 0.4s';
                wrappedCallback = function(event){
                    if (typeof event !== 'undefined') {
                        if (event.target !== event.currentTarget) return // makes sure the event didn't bubble from "below"
                        event.target.removeEventListener(normalizeEvent('TransitionEnd'), wrappedCallback)
                    } else
                        this.removeEventListener(normalizeEvent('TransitionEnd'), wrappedCallback) // triggered by setTimeout

                    fired = true
                    callback && callback.call(currDom,current,target);
                }

                currDom.addEventListener(normalizeEvent('TransitionEnd'), wrappedCallback)
                    setTimeout(function(){
                        if (fired) return
                        wrappedCallback.call(currDom)
                    }, 400+ 25);

            }else{
                targetDom.style['display']='block';
                targetDom.style['left'] = 0;
                targetDom.style['top'] = 0;
                callback&&callback(current,target);
            }
        }
    };

    function _switchBehavior(current, target, style) {
        switch (style) {
            /*
             case _SwitchStyleEnum.CUBE:
             var targetDom=target.getPageDom(),currDom=current.getPageDom();
             targetDom.style['display']='block';
             targetDom.style['opacity']='1';
             targetDom.style[S.browser.vendor + 'Transform'] = 'rotate(-90deg)';
             setTimeout(function(){
             targetDom.style[S.browser.vendor + 'TransitionProperty'] = '-' + S.browser.vendor.toLowerCase() + '-transform opacity';
             targetDom.style[S.browser.vendor + 'TransitionDuration'] = '0.5s';
             targetDom.style[S.browser.vendor + 'TransformOrigin'] = '100% 100%';
             targetDom.style[S.browser.vendor + 'TransitionTimingFunction'] = 'cubic-bezier(0.33,0.66,0.66,1)';
             targetDom.style[S.browser.vendor + 'Transform'] = 'rotate(0deg)';
             },100);

             currDom.style[S.browser.vendor + 'TransitionProperty'] = '-' + S.browser.vendor.toLowerCase() + '-transform opacity';
             currDom.style[S.browser.vendor + 'TransitionDuration'] = '0.5s';
             currDom.style['opacity'] = '0';
             currDom.style[S.browser.vendor + 'TransformOrigin'] = '100% 100%';
             currDom.style[S.browser.vendor + 'TransitionTimingFunction'] = 'cubic-bezier(0.33,0.66,0.66,1)';
             currDom.style[S.browser.vendor + 'Transform'] = 'rotate(90deg)';
             break;
             case _SwitchStyleEnum.SLIDE:
             var targetDom=target.getPageDom(),currDom=current.getPageDom();
             targetDom.style['display']='block';
             targetDom.style[S.browser.vendor + 'Transform'] = 'translate(480px,0)';
             setTimeout(function(){
             targetDom.style[S.browser.vendor + 'TransitionProperty'] = '-' + S.browser.vendor.toLowerCase() + '-transform opacity';
             targetDom.style[S.browser.vendor + 'TransitionDuration'] = '0.5s';
             targetDom.style[S.browser.vendor + 'TransformOrigin'] = '0 0';
             targetDom.style[S.browser.vendor + 'TransitionTimingFunction'] = 'cubic-bezier(0.33,0.66,0.66,1)';
             targetDom.style[S.browser.vendor + 'Transform'] = 'translate(0px,0)';
             },100);

             currDom.style[S.browser.vendor + 'TransitionProperty'] = '-' + S.browser.vendor.toLowerCase() + '-transform';
             currDom.style[S.browser.vendor + 'TransitionDuration'] = '0.5s';
             currDom.style[S.browser.vendor + 'TransformOrigin'] = '0 0';
             currDom.style[S.browser.vendor + 'TransitionTimingFunction'] = 'cubic-bezier(0.33,0.66,0.66,1)';
             currDom.style[S.browser.vendor + 'Transform'] = 'translate(-480px,0)';

             break;
             */
            case SwitchStyleEnum.NONE:
                current && (current.getPageDom().style.display = 'none');
                target.getPageDom().style.display = 'block';
                break;
            default:
                break;
        }

    }
});

NC.add('Pages', 'Pages.SwitchBehavior', function (S) {
    var pageList = [],
        pageRun = {},
        currentPage;
    var switchStyle = S.Pages.SwitchStyleEnum;
    var option = {
        switchStyle: switchStyle.NONE,
        defaultPage: 'index'
    };
    var namedParam = /:([\w\d]+):/g;
    var splatParam = /\*([\w\d]+)/g;
    var escapeRegExp = /[-[\]{}()+?.,\\^$|#\s]/g;

    S.Pages = S.mix(S.Pages, {
        /**
         * 将路由名转换成可匹配当前hash的正则表达式
         * @param route
         * @returns {RegExp}
         * @private
         */
        _routeToRegExp: function (route) {
            route = route.replace(escapeRegExp, "\\$&").replace(namedParam, "([^\/]*)").replace(splatParam, "(.*?)");
            return new RegExp('^' + route + '$');
        },
        /**
         * 利用路由名和它匹配的url片段，返回提取的参数数组
         * @param route
         * @param fragment
         * @returns {Array}
         * @private
         */
        _extractParams: function (route, fragment) {
            return route.exec(fragment).slice(1);
        },
        init: function (opt) {
            var that = this;
            this.opt = S.mix(option, opt, true);

            if (this.opt.hash) {
                for (var i = 0; i < this.opt.hash.length; i++) {
                    if (this.opt.hash[i].url) {
                        var page = this._getPageByName(this.opt.hash[i].name);
                        if (page) {
                            S.mix(page, {
                                partten: that._routeToRegExp(this.opt.hash[i].url),
                                url: this.opt.hash[i].url,
                                name: this.opt.hash[i].name
                            });
                        }
                    }
                }
            }
            if (this.opt.navigator == 'hash') {
                window.addEventListener('hashchange', function () {
                    that._hashChanged();
                });
                this._hashChanged();
            }
        },
        _hashChanged: function () {
            //在这里要处理一下网页是hash还是url的queryString
            var _hash = location.hash.substr(1);
            //如果hash值为空
            if (!_hash) {
                if (this.opt.defaultPage && this._getPageByName(this.opt.defaultPage)) {
                    //首次打开网页会自动跳到#/default，可能会产生白屏，所以直接内部切换，不用hash
                    this._goPage(this.opt.defaultPage);
                } else {
                    throw new Error('无默认页');
                }
            } else {
                for (var i = 0; i < pageList.length; i++) {
                    var _regex = new RegExp(pageList[i].partten);
                    var _result = _regex.exec(_hash), paramsObj = {}, param;
                    if (_result) {
                        var _params = _result.slice(1);
                        //将取到的数据与送入的形参配对生成新的对象，用以传入pageLoad事件
                        while (param = namedParam.exec(pageList[i].url)) {
                            var _value = _params.shift();
                            if (!_value.length) {
                                throw new Error('实参与形参不匹配');
                            }
                            paramsObj[param[1]] = _value;
                        }
                        this.go(pageList[i].name, paramsObj);
                        break;
                    }
                    if (i == (pageList.length - 1)) {
                        throw new Error('匹配形参的页面无法找到');
                    }
                    continue;
                }
            }
        },
        _resetPage: function () {

        },
        _getPageByName: function (pageName) {
            for (var i = 0; i < pageList.length; i++) {
                if (pageList[i].name == pageName) {
                    return pageList[i];
                }
            }
            return null;
        },
        go: function (pageName, opt) {
            var partten = this._getPageByName(pageName), param;
            if (!partten) {
                return;
            }
            //参数检查
            while (param = namedParam.exec(partten.url)) {
                var _value = param[1];
                if (!opt || !opt[_value]) {
                    throw new Error('实参与形参不匹配');
                }
            }

            if (this.opt.navigator == 'hash') {
                var _tempUrl = partten.url;
                //如果传入强制更新
                if (NC.isBoolean(opt) === true) {
                    partten.inited=false;
                } else {
                    NC.each(opt, function (value, key) {
                        _tempUrl = _tempUrl.replace(':' + key + ':', value);
                    });
                }
                var host = window.location.host;
                if ((('#' + _tempUrl) == window.location.hash) || (window.location.hash == '' && pageName === this.opt.defaultPage)) {
                    this._goPage(pageName, opt);
                } else {
                    window.location.hash = _tempUrl;
                    console.log(_tempUrl);
                }
            } else {
                this._goPage(pageName, opt);
            }
        },
        _goPage: function (pageName, opt) {
            var _currPage = currentPage ? this._getPageByName(currentPage) : null,
                _targetPage = this._getPageByName(pageName);
            if (!_targetPage) {
                throw new Error('没有对应页面');
            }
            //执行切换效果
            S.Pages.SwitchBehavior(_currPage, _targetPage, this.opt.switchStyle, function (a, b) {
                a && a.destroy();
                if (
                    (
                        (opt === true) || (!b.inited || b.refreshAlways)
                        ) && b.pageLoad) {
                    b.pageLoad.call(b, opt);
                    b.inited = true;
                }
            });

            currentPage = pageName;
        },

        /**
         * 注册页页到总控
         * @param pageObj 页面对象
         * @param opt
         * @returns {boolean}
         */
        register: function (pageObj, opt) {
            if (this._getPageByName(pageObj.name)) {
                throw '页面名称已存在';
                return false;
            }
            pageList.push(pageObj);
            if (pageObj) {
                pageObj._init && (pageObj._init.call(pageObj, opt));
            }
            /*&& !this.opt.hash*/
            if (this.opt && this.opt.defaultPage == pageObj.name) {
                this._goPage(this.opt.defaultPage, {});
            }
        },
        /**
         * 从总控中删除该页面
         * @param pageName 页面名称
         */
        unRegister: function (pageName) {
            for (var i = 0; i < pageList.length; i++) {
                if (pageList[i].name == pageName) {
                    pageList.splice(i, 1);
                }
            }
        }
    });
});
NC.add('Page', 'Pages', function (S) {
    function Page(opt) {
        if (!opt.name) {
            throw "页面文件必须定义名称";
        }
        this.refreshAlways = true;
        NC.mix(this, opt, true);
    }

    Page.prototype.getPageDom = function () {
        return document.getElementById(this.name + '_page');
    }

    Page.prototype._init = function (opt) {
        this.init && this.init(opt);
    }

    Page.prototype.destroy = function () {
    }
    Page.prototype.pageLoad = function (opt) {
    }
    S.Page = Page;
});
NC.add('Storage', function(S) {
    function setCookie(name, value, expires, domain, path, secure) {
        if (null == expires || 0 >= expires) var n = 300;
        var r = new Date;
        r.setTime(r.getTime() + expires * 24 * 60 * 60 * 1e3);
        var text=name + "=" + escape(value) + ";" + "expires=" + r.toGMTString();
        if (domain) {
            text += '; domain=' + domain;
        }
        if (path) {
            text += '; path=' + path;
        }
        if (secure) {
            text += '; secure';
        }
        document.cookie = text;
    }
    function getCookie(e) {
        var t = document.cookie.match(new RegExp("(^| )" + e + "=([^;]+?)(;|$)"));
        return t != null ? unescape(t[2]) : null
    }
    function supports_local_storage() {
        return "localStorage" in window && window["localStorage"] != null
    }
    function setStoreItem(e, t,s) {
        try {
            if(s < 0){
                window.localStorage.removeItem(e);
            }else{
                window.localStorage.setItem(e, t)
            }
        } catch(n) {
            return
        }
    }
    function getStoreItem(e) {
        var t;
        try {
            t = window.localStorage.getItem(e)
        } catch(n) {
            t = "disable"
        } finally {
            return t
        }
    }
    function getStatic(e) {
        return supports_local_storage() ? getStoreItem(e) : getCookie(e)
    }
    function setStatic(t, i, s,d,p,se) {
        supports_local_storage() ? setStoreItem(t, i,s) : setCookie(t, i, s,d,p,se);
    }
    S.Storage = {
        getValue: getStatic,
        setValue: setStatic,
        getCookie: getCookie,
        setCookie: setCookie
    }
});

NC.add('LazyLoader', function(S) {
	var lazyImgs = [],
		threshold, dataSrc, src, placeholder = '',
		that;
	var MANUAL = 'manual',
		NONE = null,
		DATASRC = 'data-src',
		SRC = 'src',
		SELECTOR = 'img[data-src]';

	function inScreenView(obj) {
		try {
			var _objBottom, _rect, _height, _objTop, f;
			typeof obj == "string" ? _rect = document.getElementById(obj).getBoundingClientRect() : _rect = obj.getBoundingClientRect();
			_height = window.innerHeight;
			_objTop = _rect.top, _objBottom = _rect.bottom;
			return _objTop<_height;
			//return _objTop <= 0 && _objBottom >= _height ? true : (_objBottom >= 0 && _objBottom <= _height) ? true : (_objTop >= 0 && _objTop <= _height) ? true : false;
		} catch (err) {
			return console.error("try.catch:" + err.toString());
		}
	}
	function LazyLoader(opt) {
		that = this;
		NC.event.on(window, 'scroll', function(){that.doScroll.call(that);});
		NC.event.on(window, 'resize', function(){that.doScroll.call(that);});
	}
	function _setAttri (obj) {
        obj.onload=function(evt){
            this.removeAttribute(DATASRC);
            this.removeAttribute('ori-src');
        }
        obj.onerror=function(evt){
            this.setAttribute(SRC,this.getAttribute('ori-src'));
            this.removeAttribute('ori-src');
            this.removeAttribute(DATASRC);
        }
    }
	LazyLoader.prototype._excutor = function(){
		var imgs = document.querySelectorAll(SELECTOR);
		for (var i = 0; i < imgs.length; i++) {
			img = imgs[i];
			dataSrc = img.getAttribute(DATASRC);
			src = img.getAttribute(SRC);
			if (dataSrc && inScreenView(img) ) {
				img.setAttribute('ori-src', src);
				img.setAttribute(SRC, dataSrc);
                _setAttri(img);
			}
		}
		var that=this;
		this._getExtraImages();
		if (this.images.length == 0) {
			NC.event.off(window, 'scroll', function(){that.doScroll.call(that);});
			NC.event.off(window, 'resize', function(){that.doScroll.call(that);});
		}
		this.timer=null;
	}

	LazyLoader.prototype._getExtraImages=function() {
		var unFlagImg = [];
		var imgs = document.querySelectorAll(SELECTOR);
		for (var i = 0; i < imgs.length; i++) {
			var img = imgs[i];
			src = img.getAttribute(SRC);
			dataSrc = img.getAttribute(DATASRC);
			if (dataSrc && !src) {
				unFlagImg.push(img);
			}
		}
		this.images = unFlagImg;
	}

	LazyLoader.prototype.doScroll=function(){
		if(this.timer){
			clearTimeout(this.timer);
			this.timer=null;
		}
		var that=this;
		this.timer=setTimeout(function(){
			that._excutor.call(that);
		}, 200);
	}

	S.LazyLoader = LazyLoader;
});
/**
 * DOM结构
 * 外围容器->滚动容器->N滚动条目
 */
NC.add('Slide', function(S) {
	/**
	 * 浏览器判断,如果是PC使用mouse机制
	 */
	var RESIZE_EV = 'onorientationchange' in window ? 'orientationchange' : 'resize',
		START_EV = S.browser.hasTouch ? 'touchstart' : 'mousedown',
		MOVE_EV = S.browser.hasTouch ? 'touchmove' : 'mousemove',
		END_EV = S.browser.hasTouch ? 'touchend' : 'mouseup',
		CANCEL_EV = S.browser.hasTouch ? 'touchcancel' : 'mouseup';

	function Slide(opt) {
		opt.interval = opt.interval || 3000;
		this.options = opt;
		this.init();
	}
	Slide.prototype = {
		init: function() {
			var self = this;
			NC.mix(this.options, {
				lazy: true,
				width: 304,
				height: 86,
                hand:false,
				snap:'li',
				index: 0,
				auto: false
			});
			var opt = this.options;
			var pos, oriLeft;

            /**
             * 跟随鼠标的移动
             * @param evt
             * @returns {boolean}
             */
			function move(evt) {
                evt.preventDefault();
                //鼠标位置
				var position = fixed(evt);
				if (self.act) {
					if (opt.onBeforeScrollMove){
						if(opt.onBeforeScrollMove.call(self, evt)===false){
							return;
						}
					} 
					if (self.thisInterval) {
						self.clear();
					}
                    //滚动容器的宽度
					var boxWidth = opt.width * (opt.scrollMode=='scroll'?self.lengths():self.lengths()-1);

                    //鼠标水平方向移动量
					var _hDistance = pos[0] - position[0];
                    //初始的left偏移 减本次移动
					var _newPosition = oriLeft - _hDistance;

                    //左右边界
					var _rangeLeft,_rangeRight;
					if(opt.scrollMode=='scroll'){
						_rangeLeft=0;
						_rangeRight=-1 * Math.abs(boxWidth-opt.container.offsetWidth);
					}else{
						_rangeLeft=0;
						_rangeRight=(-1 * boxWidth);
					}
					if(opt.scrollMode=='scroll' && boxWidth<=opt.container.offsetWidth){
						return false;
					}
					//移动超出边界，按正负方向
					// distance<0 向右移动

                    //如果已抵达边界，则单独处理
					if ((_hDistance >= 0 && _newPosition <=_rangeRight)|| (_hDistance <= 0 && _newPosition > _rangeLeft)) {
						//console.log('distance'+distance);
						if(_hDistance>0){
							self.scrollBox.style.left = _rangeRight + 'px';
                            if(opt.scrollMode!='scroll'){
                                self._next();
                                oriLeft = false;
                                self.act = false;
                            }
						}else{
							self.scrollBox.style.left = _rangeLeft + 'px';
						}
						return false;
					}

					self.scrollBox.style.left = _newPosition + 'px';
					//console.log('distance'+self.scrollBox.style.left);
					//fix bug:如果是水平方向的滑动，阻止默认事件，防止一些浏览器跳到上一页或下一页
					if ((pos[0] - position[0]) > (pos[1] - position[1])) {
						evt.preventDefault();
					}
				}

			}

			function touchstart(evt) {
                evt.preventDefault();
				if (opt.onBeforeScrollStart) opt.onBeforeScrollStart.call(self, evt);
				//最后一个也可以滑动
				//|| (self.options.index + 1) == self.lengths()
				if (self.lengths()==0 ) {
					return;
				}
				self.act = true;
				oriLeft = self.scrollBox.offsetLeft;
				pos = fixed(evt);
				//evt.preventDefault();
			}

			function fixed(evt) {
				var b = new Array;
				return b[0] = evt.changedTouches ? evt.changedTouches[0].clientX : evt.clientX, b[1] = evt.changedTouches ? evt.changedTouches[0].clientY : evt.clientY, b
			}

			function touchend(evt) {
				var testRange = ((self.options.index + 1) == self.lengths());
				if(!self.act){
					return;
				}
				var position = fixed(evt),
					distance = pos[0] - position[0];
				if(self.options.scrollMode!='scroll'){
					if (distance > 0) {
						if (distance > 10) {
							self._next();
						}
					} else {
						if (self.options.index != 0) {
							if (-distance > 10) {
								self._prev();
							}
						}
					}
				}
				oriLeft = false;
				self.act = false;
			}
            if(this.options.hand){
                this.options.container.addEventListener(MOVE_EV, move);
                this.options.container.addEventListener(START_EV, touchstart);
                this.options.container.addEventListener(END_EV, touchend);
            }

			//this.options.container.addEventListener(END_EV, touchend);
			/*window.addEventListener('resize', function(){
				self.refresh();
			});*/
			this.reset();
			return this;
		},
		_lazyLoader: function(idx) {
			if (!this.options.lazy) {
				return;
			}
			var img, dataSrc, DATASRC = 's-data-src',
				SRC = 'src',
				SELECTOR = 'img[s-data-src]';
			
			var thisLi;
			if(typeof idx=='number'){
				thisLi=(this.items())[idx];
			}
			else{
				thisLi=this.scrollBox;
			}
			if(!thisLi)return;
			var thisImgs = thisLi.querySelectorAll(SELECTOR);
			for (var i = thisImgs.length - 1; i >= 0; i--) {
				img = thisImgs[i];
				dataSrc = img.getAttribute(DATASRC);
				src = img.getAttribute(SRC);
				if (dataSrc && (dataSrc != src)) {
					img.setAttribute(SRC, dataSrc);
					img.removeAttribute(DATASRC);
				}
			};
		},
		refresh: function() {
			this.reset();
			if(this.lengths()>0){
				this._lazyLoader(0);
				this.scrollToPage(1);
			}
			//this.reset();
		},
		destroy: function() {
			var self = this;
			self.options.container.parentNode.removeChild(self.options.container);
		},
		clear: function() {
			clearInterval(this.thisInterval);
			this.thisInterval = null;
		},
		reset: function() {
			var self = this;
			var opt = self.options;

			self.scrollBox = opt.container.querySelector(opt.snap);
			if(!self.scrollBox)return;
			self.scrollBox=self.scrollBox.parentNode;
			self.scrollBox.style.width = ((this.lengths() * opt.width) || opt.width) + 'px';
			self.scrollBox.style.position = 'absolute';
			//self.scrollBox.style.top = '0';
			self.act = false;
			if (self.options.auto) {
				if (this.thisInterval) {
					self.clear();
				}
				self.thisInterval = setInterval(function() {
					self._next();
				}, self.options.interval);
			}
			if (this.lengths()) {
				opt.scrollMode=='scroll'?this._lazyLoader():this._lazyLoader(0);
			}
		},
		scrollToPage: function(idx) {
			//because the timer is not define in this env,so if the touch behavior is working ,return the timer event outside
			if (this.act) {
				return false;
			}
			//the special case for iScroll interface
			if (idx === 0) {
				idx = this.lengths();
			}
			idx--;
			//if(this.options.index>idx)return;
			if (this.options.index > idx) {
				this._prev(idx - this.options.index);
			} else if(this.options.index < idx){
				this._next(idx - this.options.index);
			}
		},
		items: function() {
			return this.options.container.querySelectorAll(this.options.snap);
		},
		lengths: function() {
			return this.items().length;
		},
		_next: function(rate) {
			rate = typeof rate == 'undefined' ? 1 : rate;
			if ((this.options.index + 1) >= this.lengths()) {
				this._prev(-1 * this.options.index);

				return;
			}
			this.options.index = this.options.index + rate;
			this._move(rate);
		},
		_prev: function(rate) {
			rate = typeof rate == 'undefined' ? -1 : rate;
			this.options.index = this.options.index + rate;
			this.options.index = this.options.index >= 0 ? this.options.index : 0;

			this._move(rate);
		},
		_move: function(rate) {
			var that = this;
            //目标偏移
			var targetLeft = this.options.index * this.options.width;
            //当前偏移
			var oriLeft = parseInt(this.scrollBox.offsetLeft);
			this._lazyLoader(that.options.index);
			var timerScroll;

			function scroll() {
                //如果滚动未结束
				if (targetLeft - Math.abs(oriLeft) !== 0) {
                    //如果滚动差值已经很小了，则计为已滚动完成
					if (Math.abs(targetLeft - Math.abs(oriLeft)) < 1) {
						oriLeft = -targetLeft;
						that.scrollBox.style.left = oriLeft + 'px';
						that.options.onScrollEnd && that.options.onScrollEnd.call(that, that.options.index);
						if (!that.thisInterval) that.reset();
						return;
					} else {
						var distance = targetLeft + oriLeft;
						oriLeft += (distance / 3) * -1;
					}
					that.scrollBox.style.left = oriLeft + 'px';
					timerScroll = setTimeout(scroll, 30);
				} else {
					that.options.onScrollEnd && that.options.onScrollEnd.call(that, that.options.index);
					if (!that.thisInterval) that.reset();
					if (timerScroll) clearTimeout(timerScroll);
				}
			}
			scroll();
		}
	};

	S.Slide = Slide;
});