/**
 *
 * User: chengyang@iflytek.com
 * Date: 15-6-8 上午9:38
 * Version: 1.0
 */

var bookRegion = (function () {

//var fs = require('fs');
    var sqlite3 = require('sqlite3').verbose();
    var bookRegionDom;
    var userinfo;
    var recentBook;
    var defaultBook;
    var hasDefaultBook = false;
    var defaultTileLength = 18;

    var reg = /^[0-9]*$/;
    var lastIndex = 1;


    var recentbookPath = APP_CONFIG.BASE_PATH + "/plugins/62/bin/";
    var template = fs.readFileSync(APP_CONFIG.TA_PATH + "/assets/template/classteach/bookregion.html", encoding = 'utf8');

    function init(dom,book){
        bookRegionDom = $(dom);
        defaultBook = book;
    }

    function setRecentBook(user){
        userinfo = user;
        var dbpath = recentbookPath + "users/" + userinfo.loginName + "/userdb.db";
        if (!fs.existsSync(dbpath)) {
            recentBook = {booklist:[]};
            resetDom();
            return;
        }
        var db = new sqlite3.Database(dbpath);
        db.all("SELECT * FROM books", function (err, rows) {
            recentBook = {booklist:[]};
            if (!err) {
                for (var i = 0, len = rows.length; i < len; i++) {
                    var bookObj = rows[i];
                    var bLast = true;
                    bookObj.lasttime = bookObj.lastUsedTime || bookObj.downloadDate;
                    if(bookObj.thumbnail){
                        bookObj.thumbnail = recentbookPath + bookObj.thumbnail;
                    }else{
                        bookObj.thumbnail = APP_CONFIG.BASE_PATH + '/main/assets/images/book_img.png';
                    }
                    for (var j = 0, len2 = recentBook.booklist.length; j < len2; j++) {
                        if (bookObj.lasttime > recentBook.booklist[j].lasttime) {
                            recentBook.booklist.splice(j, 0, bookObj);
                            recentBook.booklist.splice(5, 1);
                            bLast = false;
                            break;
                        }
                    }
                    if (bLast && 5 > recentBook.booklist.length) recentBook.booklist.push(bookObj);
                }
            }

            //发送课本列表到iflyslide
            feedBookList(user).done(function(ret){
                var result = ret;
                // TODO(xinfang3): 2016-09-6 9:26:58,生成booklist和lastbook成功.
                //发送socket... || NOTE:action 定义为 feed_booklist
                var json={
                    from:"ta",
                    to:"all",
                    action:"feed_booklist",
                    data:result
                };
                socket.send(json);
                console.log(result);
            }).fail(function(e){
                console.log("feedBookList（发送消息到iflySlide）生成booklist失败");
                console.log(e);
            });
            resetDom();
        });
    }

    function getRecentBookList(user){
        if(!recentBook){
            userinfo = user;
            var dbpath = recentbookPath + "users/" + userinfo.loginName + "/userdb.db";
            if (!fs.existsSync(dbpath)) {
                recentBook = {booklist:[]};
                console.log("数据库不存在！");
            }else{
                var db = new sqlite3.Database(dbpath);
                db.all("SELECT * FROM books", function (err, rows) {
                    recentBook = {booklist:[]};
                    if (!err) {
                        for (var i = 0, len = rows.length; i < len; i++) {
                            var bookObj = rows[i];
                            var bLast = true;
                            bookObj.lasttime = bookObj.lastUsedTime || bookObj.downloadDate;
                            if(bookObj.thumbnail){
                                bookObj.thumbnail = recentbookPath + bookObj.thumbnail;
                            }else{
                                bookObj.thumbnail = APP_CONFIG.BASE_PATH + '/main/assets/images/book_img.png';
                            }
                            for (var j = 0, len2 = recentBook.booklist.length; j < len2; j++) {
                                if (bookObj.lasttime > recentBook.booklist[j].lasttime) {
                                    recentBook.booklist.splice(j, 0, bookObj);
                                    recentBook.booklist.splice(5, 1);
                                    bLast = false;
                                    break;
                                }
                            }
                            if (bLast && 5 > recentBook.booklist.length) recentBook.booklist.push(bookObj);
                        }
                        resetDom();
                    }
                });
            }
        }else{
            resetDom();
        }
    }

    function resetDom(){
        var bookObj = {result:[]};
        var booklist = recentBook.booklist;
        hasDefaultBook = false;
        for(var i= 0,len = booklist.length; i < len; i++){
            var obj = {};
            var book = booklist[i];

            obj.thumbnail = book.thumbnail;
            obj.title = book.title;

            if(book.bookCode == defaultBook.bookCode){
                hasDefaultBook = true;
                obj.thumbnail = defaultBook.thumbnail;
            }

            var flag= false;//是否加省略号
            var titleLength = obj.title.length;
            if(titleLength >= defaultTileLength){
                obj.name = obj.title.substr(0,defaultTileLength-1);
                flag = true;
            }else{
                obj.name = obj.title;
            }

            //书本名称中数字的个数
            var num = obj.name.replace(/\D/g, '').length;
            //括号的个数
            var knum = obj.name.match(/[()]/g);
            //中文括号的个数
            var znum = obj.name.match(/[（）]/g);
            //英文的个数
            var engnum = obj.name.match(/[a-zA-Z]/g);

            if(knum){
                num += knum.length;
            }
            if(znum){
                num = parseInt((num - znum.length)/2);
            }
            if(engnum){
                num = num + parseInt(engnum.length/3);
            }

            if(num > 0){
                obj.name =  obj.name + obj.title.substr(defaultTileLength-1,num);
            }else{
                obj.name = obj.name.substr(0,obj.name.length + num);
            }

            if(flag && obj.name.length < defaultTileLength){
                obj.name += "...";
            }
            //pdf书本，添加属性pdfName
            if(obj.thumbnail.indexOf("slt_pdf.png")!=-1){
                obj.pdfName=obj.name;
            }else{
                obj.pdfName="";
            }
            bookObj.result.push(obj);
        }
        if(bookObj.result.length < 5 && !hasDefaultBook){
            bookObj.result.push(defaultBook);
            recentBook.booklist.push(defaultBook);
        }
        //备课、授课模块在渲染课本列表之前确定书本展示数量
        var recentBookDom;
        var selected_li = $("#head_control").find(".selected").attr("id");
        if(selected_li == "head_classprepare"){
            var viewlist = {result:[]};
            viewlist.result = bookObj.result.slice(0,3);
            recentBookDom = $(Mustache.render(template,viewlist));
        }else{
            var viewlist = {result:[]};
            viewlist.result = bookObj.result.slice(0,4);
            recentBookDom = $(Mustache.render(template,viewlist));
        }

        recentBookDom.find("p").each(function(index,ele){
            var dom = $(ele);
            var length = dom.text().length;
            if(length <= defaultTileLength/2){
                dom.css("line-height","32px");
            }
        });
        var bookListRegion = bookRegionDom.find('.ct-bookcaselist');
        bookListRegion.find('li[name=ta_ebook]').remove();
        $("#open_iflybook_store").remove();
        if(selected_li == "head_classprepare"){
            var li_add = '<li id="open_iflybook_store" class="add-keben"><a href="javascript:;"><div class="book-shadow"></div><div class="add-keben-ico">添加课本</div><div class="book-mc"></div></a></li>';
            bookListRegion.append(recentBookDom);
            bookListRegion.append(li_add);
            // var lis = bookListRegion.find('li[name=ta_ebook]');
            // lis[3] && $(lis[3]).addClass('max-list');
            // lis[4] && $(lis[4]).addClass('max-list').addClass('max-list02');
        }else if(selected_li == "head_classattend"){
            bookListRegion.append(recentBookDom);
            // var lis = bookListRegion.find('li[name=ta_ebook]');
            // lis[4] && $(lis[4]).addClass('max-list').addClass('max-list02');
        }
    }

    function getRecentBookCode(index){
        if(recentBook){
            return recentBook.booklist[index].bookCode;
        }else{
            return "13170425-022";
        }
    }

    function getRecentBook(index){
        if(recentBook){
            return recentBook.booklist[index];
        }else{
            return {
                bookCode: "13170425-022",
                lastPage:1
            }
        }

    }

    function feedBookList(user){
        var def = jQuery.Deferred();
        var user_id = user.id || "0";
        var user_loginName = user.loginName || "defaultuser";
        var result = {
            "booklist":{
                "total":0,
                "data":[]
            },
            "lastbook":{
                "code":"",
                "name":"",
                "metaInfo":
                {
                    "unit1":"",
                    "unit2":"",
                    "unit3":"",
                    "unit4":""
                }
            }
        };
        var pages = [];
        var total = 0;
        var bookAccessor = new KeJian.BookInfoAccessor(user_id, user_loginName);
        bookAccessor.getAllThumbnails().done(function (ret) {
            var books = ret || [];
            for(var i=0,count = books.length;i<count;i++){
                var item = books[i];
                var rs = {
                    "code":item.bookCode || "",
                    "name":item.title || "",
                    "metaInfo":{
                        "grade":item.grade || "",
                        "lastUsedTime":item.lastUsedTime || "",
                        "downloadDate":item.downloadDate || "",
                        "publisher":item.publisher || "",
                        "subject":item.subject || "",
                        "volumn":item.volumn || "",
                        "lastPage":item.lastPage || "",
                        "isNew":item.isNew || "",
                        "showOrder":item.showOrder || ""
                    }
                };
                total += 1;
                result.booklist.data.push(rs);
            }
            result.booklist.total = total;
            var lastBookInfo = books[0];
            result.lastbook.code = lastBookInfo.bookCode || "";
            result.lastbook.name = lastBookInfo.title || "";

            // 获取lastBook目录信息
            var param_book_unit = {
                "bookCode":result.lastbook.code
            };
            edcService.Instance().ersp_resource_metadata_book_unit_list(param_book_unit).done(function(ret){
                if(ret.code == 0){
                    var _remoteBookJson = ret.data.data;
                    pages = Unit1Pages(_remoteBookJson);
                    var pageInfo = pages.filter(function(el){
                        return el.pageIndex == lastBookInfo.lastPage;
                    });
                    if(pageInfo.length > 0){
                        result.lastbook.metaInfo.unit1 = pageInfo[0].unit1;
                        result.lastbook.metaInfo.unit2 = pageInfo[0].unit2;
                        result.lastbook.metaInfo.unit3 = pageInfo[0].unit3;
                        result.lastbook.metaInfo.unit4 = pageInfo[0].unit4;
                    }
                    def.resolve(result);
                }else{
                    console.log(ret);
                    def.reject(ret);
                }
            }).fail(function(e){
                console.log(e);
                def.reject(e);
            });
        }).fail(function(e){
            console.log(e);
        });
        return def.promise();
    }

    function newPage(code, index, unit1, unit2, unit3, unit4, unit1Name, unit2Name, unit3Name, unit4Name) {
        return {
            pageCode: code, /*实体书页码*/
            pageIndex: index, /*电子书页码*/
            unit1: unit1, /*第一级目录code*/
            unit2: unit2, /*第二级目录code*/
            unit3: unit3, /*第三级目录code*/
            unit4: unit4, /*第四级目录code*/
            unit1Name: unit1Name,
            unit2Name: unit2Name,
            unit3Name: unit3Name,
            unit4Name: unit4Name
        }
    }

    function Unit1Pages(Uint1, pagecode) {
        //初始化
        lastIndex = 1;
        var i, j, len, Unit1data, pages = [], pagedata;
        var lastPageCode = "", unitTemp = null;
        pagecode = "";
        for (i = 0, len = Uint1.length; i < len; i++) {
            Unit1data = Uint1[i];
            //有子级目录
            if (Unit1data.courses.length > 0) {
                //先把子级目录无关页扔出来

                for (j = 0; j < Unit1data.pages.length; j++) {
                    pagedata = Unit1data.pages[j];
                    //这一级第一页是上一同级最后一页
                    if (pagecode == pagedata.code) {
                        pages[pages.length - 1] = (newPage(pagedata.code, lastIndex - 1, Unit1data.code, "", "", "", Unit1data.name, "", "", ""));
                    }

                    if (pagedata.code != Unit1data.courses[0].pages[0].code) {
                        if (pagecode != pagedata.code) {
//                                    pages.push(newPage(pagedata.code, lastIndex, Unit1data.pages[j].code, "", "", "", Unit1data.name, "", "", ""));
                            pages.push(newPage(pagedata.code, lastIndex, Unit1data.code, "", "", "", Unit1data.name, "", "", ""));
                            lastIndex++;
                            pagecode = pagedata.code
                        }
                        else {
                            //同一级，无需处理
                        }
                    }
                    else {
                        break;
                    }
                }
                unitTemp = Unit2Pages(Unit1data.courses, Unit1data.code, Unit1data.name, pagecode, pages);
                pages = unitTemp.pages;
                pagecode = lastPageCode = unitTemp.lastPageCode;
                //再把在子级目录之后的无关页扔出来
                if (Unit1data.pages[Unit1data.pages.length - 1].code != lastPageCode) {
                    //存在无关页
                    for (; j < Unit1data.pages.length; j++) {
                        pagedata = Unit1data.pages[j];
                        if (pagedata.code == lastPageCode) {
                            break;
                        }
                    }
                    //无关页合并
                    for (j++; j < Unit1data.pages.length; j++) {
                        pagedata = Unit1data.pages[j];
                        if (pagecode != pagedata.code) {
                            pages.push(newPage(pagedata.code, lastIndex, Unit1data.pages[j].code, "", "", "", Unit1data.name, "", "", ""));
                            lastIndex++;
                            pagecode = pagedata.code;
                        }
                        else {
                            //同一级，无需处理
                        }
                    }
                    //异常兼容,防止数组越界
                    if(j - 1 > Unit1data.pages.length -1 ){
                        lastPageCode = Unit1data.pages[Unit1data.pages.length -1].code;
                    }else{
                        lastPageCode = Unit1data.pages[j - 1].code;
                    }

                }
            }
            else {
                //没有子级目录
                for (j = 0; j < Unit1data.pages.length; j++) {
                    pagedata = Unit1data.pages[j];
                    //这里只考虑了上一unit和当前uinit是同一页的情况，使用当前unit覆盖上一unit
                    //但是存在上一unit的页数，比当前unit还大的情况，如 音乐湘艺四年级上册(2014新编)
//                            if (pagecode != pagedata.code) {
//                                pages.push(newPage(pagedata.code, lastIndex, Unit1data.code, "", "", "", Unit1data.name, "", "", ""));
//                                lastIndex++;
//                                pagecode = pagedata.code;
//                            }

                    //如果是空，或者直接是目录(目录页码是字母)
                    if(pagecode == "" || !reg.test(pagecode)){
                        pages.push(newPage(pagedata.code, lastIndex, Unit1data.code, "", "", "", Unit1data.name, "", "", ""));
                        lastIndex++;
                        pagecode = pagedata.code;
                    }
                    else{
                        var pagecodeInt = parseInt(pagecode);
                        var pagedatacodeInt = parseInt(pagedata.code);

                        if(pagecodeInt < pagedatacodeInt){
                            pages.push(newPage(pagedata.code, lastIndex, Unit1data.code, "", "", "", Unit1data.name, "", "", ""));
                            lastIndex++;
                            pagecode = pagedata.code;
                        }else if(pagecodeInt == pagedatacodeInt){
                            pages[pages.length - 1] = (newPage(pagedata.code, lastIndex - 1, Unit1data.code, "", "", "", Unit1data.name, "", "", ""));
                        }else {
                            pages[pagedatacodeInt + adjustPage - 1] = (newPage(pagedata.code, pagedatacodeInt + adjustPage, Unit1data.code, "", "", "", Unit1data.name, "", "", ""));
                        }
                    }
                }
            }
        }
        return pages;
    }
    function Unit2Pages(Uint2, unit1code, unit1name, pagecode, pages2) {
        var i, j, len, Unit2data, pages = pages2.concat([]), pagedata;
        var lastPageCode = pagecode, unitTemp = null;
        for (i = 0, len = Uint2.length; i < len; i++) {
            Unit2data = Uint2[i];
            if (Unit2data.courses.length > 0) {
                //先把在子级目录之前的无关页扔出来,j的值保持不变
                for (j = 0; j < Unit2data.pages.length; j++) {
                    pagedata = Unit2data.pages[j];
                    //这一级第一页是上一同级最后一页
                    if (pagecode == pagedata.code) {
                        pages[pages.length - 1] = (newPage(pagedata.code, lastIndex - 1, unit1code, Unit2data.code, "", "", unit1name, Unit2data.name, "", ""));
                    }

                    if (pagedata.code != Unit2data.courses[0].pages[0].code) {
                        if (pagecode != pagedata.code) {
                            pages.push(newPage(pagedata.code, lastIndex, unit1code, Unit2data.code, "", "", unit1name, Unit2data.name, "", ""));
                            lastIndex++;
                            pagecode = pagedata.code;
                        }
                        else {
                            //同一级，不处理
                        }
                    }
                    else {
                        break;
                    }
                }
                unitTemp = Unit3Pages(Unit2data.courses, unit1code, Unit2data.code, unit1name, Unit2data.name, pagecode, pages);
                pages = unitTemp.pages;
                pagecode = lastPageCode = unitTemp.lastPageCode;
                //再把在子级目录之后的无关页扔出来
                if (Unit2data.pages[Unit2data.pages.length - 1].code != lastPageCode) {
                    //存在无关页
                    for (; j < Unit2data.pages.length; j++) {
                        pagedata = Unit2data.pages[j];
                        if (pagedata.code == lastPageCode) {
                            break;
                        }
                    }
                    //无关页合并
                    for (j++; j < Unit2data.pages.length; j++) {
                        pagedata = Unit2data.pages[j];
                        if (pagecode != pagedata.code) {
                            pages.push(newPage(pagedata.code, lastIndex, unit1code, Unit2data.code, "", "", unit1name, Unit2data.name, "", ""));
                            lastIndex++;
                            pagecode = pagedata.code;
                        }
                        else {
                            //同一级，无需处理
                        }
                    }
                    //异常兼容,防止数组越界
                    if(j - 1 > Unit2data.pages.length -1 ){
                        lastPageCode = Unit2data.pages[Unit2data.pages.length -1].code;
                    }else{
                        lastPageCode = Unit2data.pages[j - 1].code;
                    }
//                            lastPageCode = Unit2data.pages[j - 1].code;
                }
            }
            else {
                for (j = 0; j < Unit2data.pages.length; j++) {
                    pagedata = Unit2data.pages[j];

                    //如果是空，或者直接是目录
                    if(pagecode == "" || !reg.test(pagecode)){
                        pages.push(newPage(pagedata.code, lastIndex, unit1code, Unit2data.code, "", "", unit1name, Unit2data.name, "", ""));
                        lastIndex++;
                        pagecode = pagedata.code;
                    }
                    else{
                        var pagecodeInt = parseInt(pagecode);
                        var pagedatacodeInt = parseInt(pagedata.code);

                        if(pagecodeInt < pagedatacodeInt){
                            pages.push(newPage(pagedata.code, lastIndex, unit1code, Unit2data.code, "", "", unit1name, Unit2data.name, "", ""));
                            lastIndex++;
                            pagecode = pagedata.code;
                        }else if(pagecodeInt == pagedatacodeInt){
                            pages[pages.length - 1] = (newPage(pagedata.code, lastIndex - 1, unit1code, Unit2data.code, "", "", unit1name, Unit2data.name, "", ""));
                        }else {
                            pages[pagedatacodeInt + adjustPage - 1] = (newPage(pagedata.code, pagedatacodeInt + adjustPage, unit1code, Unit2data.code,  "", "",unit1name, Unit2data.name, "", ""));
                        }
                    }
                }
            }
            //如果存在页面在两个Unit之间
            if(i<len-1){
                var num = parseInt(pages[pages.length - 1].pageCode) + 1;
                if( num < Uint2[i+1].pages[0].code){
                    pages.push(newPage(num + "", lastIndex, unit1code, Unit2data.code, "", "", unit1name, Unit2data.name, "", ""));
                    lastIndex++;
                    pagecode = num;
                }
            }
        }
        lastPageCode = Uint2[i - 1].pages[Uint2[i - 1].pages.length - 1].code;
        return {
            pages: pages,
            lastPageCode: lastPageCode
        };
    }

    function Unit3Pages(Uint3, unit1code, unit2code, unit1name, unit2name, pagecode, pages2) {
        var i, j, len, Unit3data, pages = pages2.concat([]), pagedata;
        var lastPageCode = pagecode, unitTemp = null;
        for (i = 0, len = Uint3.length; i < len; i++) {
            Unit3data = Uint3[i];
            if (Unit3data.courses.length > 0) {
                //先把在子级目录之前的无关页扔出来,j的值保持不变
                for (j = 0; j < Unit3data.pages.length; j++) {
                    pagedata = Unit3data.pages[j];
                    //这一级第一页是上一同级最后一页
                    if (pagecode == pagedata.code) {
                        pages[pages.length - 1] = (newPage(pagedata.code, lastIndex - 1, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                    }
                    if (pagedata.code != Unit3data.courses[0].pages[0].code) {
                        if (pagecode != pagedata.code) {
                            pages.push(newPage(pagedata.code, lastIndex, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                            lastIndex++;
                            pagecode = pagedata.code;
                        }
                        else {
                            //同一级，无需处理
                        }
                    }
                    else {
                        break;
                    }
                }
                unitTemp = Unit4Pages(Unit3data.courses, unit1code, unit2code, Unit3data.code, unit1name, unit2name, Unit3data.name, pagecode, pages);
                pages = unitTemp.pages;
                pagecode = lastPageCode = unitTemp.lastPageCode;
                //再把在子级目录之后的无关页扔出来
                if (Unit3data.pages[Unit3data.pages.length - 1].code != lastPageCode) {
                    //存在无关页
                    for (; j < Unit3data.pages.length; j++) {
                        pagedata = Unit3data.pages[j];
                        if (pagedata.code == lastPageCode) {
                            break;
                        }
                    }
                    //无关页合并
                    for (j++; j < Unit3data.pages.length; j++) {
                        pagedata = Unit3data.pages[j];
                        if (pagecode != pagedata.code) {
                            pages.push(newPage(pagedata.code, lastIndex, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                            lastIndex++;
                            pagecode = pagedata.code;
                        }
                        else {
                            //同一级，无需处理
                        }
                    }
//                            lastPageCode = Unit3data.pages[j - 1].code;
                    //异常兼容,防止数组越界
                    if(j - 1 > Unit3data.pages.length -1 ){
                        lastPageCode = Unit3data.pages[Unit3data.pages.length -1].code;
                    }else{
                        lastPageCode = Unit3data.pages[j - 1].code;
                    }
                }
            }
            else {
                for (j = 0; j < Unit3data.pages.length; j++) {
                    pagedata = Unit3data.pages[j];

                    //如果是空，或者直接是目录
                    if(pagecode == "" || !reg.test(pagecode)){
                        pages.push(newPage(pagedata.code, lastIndex, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                        lastIndex++;
                        pagecode = pagedata.code;
                    }
                    else{
                        var pagecodeInt = parseInt(pagecode);
                        var pagedatacodeInt = parseInt(pagedata.code);

                        if(pagecodeInt < pagedatacodeInt){
                            pages.push(newPage(pagedata.code, lastIndex, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                            lastIndex++;
                            pagecode = pagedata.code;
                        }else if(pagecodeInt == pagedatacodeInt){
                            pages[pages.length - 1] = (newPage(pagedata.code, lastIndex - 1, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                        }else {
                            pages[pagedatacodeInt + adjustPage - 1] = (newPage(pagedata.code,pagedatacodeInt + adjustPage, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                        }
                    }
                }
                //如果存在页面在两个Unit之间
                if(i<len-1){
                    var num = parseInt(pages[pages.length - 1].pageCode) + 1;
                    if( num < Uint3[i+1].pages[0].code){
                        pages.push(newPage(num + "", lastIndex, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                        lastIndex++;
                        pagecode = num;
                    }
                }
            }
        }
        lastPageCode = Uint3[i - 1].pages[Uint3[i - 1].pages.length - 1].code;
        return {
            pages: pages,
            lastPageCode: lastPageCode
        };
    }

    function Unit4Pages(Uint4, unit1code, unit2code, unit3code, unit1name, unit2name, unit3name, pagecode, pages2) {
        var i, j, len, Unit4data, pages = pages2.concat([]), pagedata;
        var lastPageCode = pagecode;
        for (i = 0, len = Uint4.length; i < len; i++) {
            Unit4data = Uint4[i];
            for (j = 0; j < Unit4data.pages.length; j++) {
                pagedata = Unit4data.pages[j];

                //如果是空，或者直接是目录
                if(pagecode == "" || !reg.test(pagecode)){
                    pages.push(newPage(pagedata.code, lastIndex, unit1code, unit2code, Unit3data.code, "", unit1name, unit2name, Unit3data.name, ""));
                    lastIndex++;
                    pagecode = pagedata.code;
                }
                else{
                    var pagecodeInt = parseInt(pagecode);
                    var pagedatacodeInt = parseInt(pagedata.code);

                    if(pagecodeInt < pagedatacodeInt){
                        pages.push(newPage(pagedata.code, lastIndex, unit1code, unit2code, unit3code, Unit4data.code, unit1name, unit2name, unit3name, Unit4data.name));
                        lastIndex++;
                        pagecode = pagedata.code;
                    }else if(pagecodeInt == pagedatacodeInt){
                        pages[pages.length - 1] = (newPage(pagedata.code, lastIndex - 1, unit1code, unit2code, unit3code, Unit4data.code, unit1name, unit2name, unit3name, Unit4data.name));
                    }else {
                        pages[pagedatacodeInt + adjustPage - 1] = (newPage(pagedata.code, pagedatacodeInt + adjustPage, unit1code, unit2code, unit3code, Unit4data.code, unit1name, unit2name, unit3name, Unit4data.name));
                    }
                }
            }
        }
        lastPageCode = Uint4[i - 1].pages[j - 1].code;
        return  {
            pages: pages,
            lastPageCode: lastPageCode
        };
    }

    return {
        init:init,
        setRecentBook:setRecentBook,
        getRecentBookList:getRecentBookList,
        getRecentBookCode:getRecentBookCode,
        getRecentBook:getRecentBook,
        feedBookList:feedBookList
    };
})();
