/**
 *
 * User: fanxia@iflytek.com
 * Date: 15-6-8 上午11:25
 * Version: 1.0
 */

var prepareRegion = (function () {
    var exec = require('child_process').exec;
    var _dom;
    var _uid;
    var template;
    var default_icw = {
        filepath: APP_CONFIG.BASE_PATH + '/ppticws/演示课件.icw',
        title_sub: "演示课件",
        thumbnail: "../ppticws/yskj.png",
        title: "演示课件",
        type: 'icw', // 0 ppt, 1 icw
        ico: "assets/images/kejian_ico.png"
    };
    var default_ppt = {
        filepath: APP_CONFIG.BASE_PATH + '/ppticws/课件制作工具快速入门.icw',
        title_sub: "课件工具快速入门",
        thumbnail: "../ppticws/ksrm.png",
        title: "课件工具快速入门",
        type: 'icw', // 1 ppt, 2 icw
        ico: "assets/images/kejian_ico.png"
    };
    var recent_list;
    var dbaccessor;

    var init = function (dom) {
        _dom = $(dom);
        template = fs.readFileSync(APP_CONFIG.TA_PATH + "/assets/template/classteach/prepareregion.html", encoding = 'utf8');
        onLogin();
    };
    var ifs_siginal = function(data){
        var ppt_list = data.slides;
        var default_ippt = data.default_slides;
        var file_base_path = path.join(APP_CONFIG.BASE_PATH, "plugins/63/data/preparelesson/");
        if(ppt_list.length == 0){
            if(default_ippt.length>0){
                $.each(default_ippt,function(index,el){
                    var thumbnail = path.join(file_base_path,el.local_id,"cover2_0.jpg");
                    if(fs.existsSync(thumbnail)){
                        el.thumbnail = thumbnail + "?t=" + Date.parse(new Date());
                    }else {
                        el.thumbnail = 'assets/images/change_bg02.jpg';
                    }

                    if(el.title.length > 8){
                        el.title_sub = el.title.substr(0, 7) + "...";
                    }else{
                        el.title_sub = el.title;
                    }
                });
                recent_list = default_ippt;
            }
        }else{
            if(default_ippt.length > 0){
                ppt_list.push(default_ippt[0]);
            }
            $.each(ppt_list,function(index,el){
                var thumbnail = path.join(file_base_path,el.local_id,"cover2_0.jpg");
                el.thumbnail = thumbnail;
                if (fs.existsSync(thumbnail)){
                    el.thumbnail = el.thumbnail + "?t=" + Date.parse(new Date());
                }else{
                    el.thumbnail = 'assets/images/change_bg02.jpg';
                }
                if(el.title.length > 8){
                    el.title_sub = el.title.substr(0, 7) + "...";
                }else{
                    el.title_sub = el.title;
                }
            });
            recent_list = ppt_list;
        }
        updatePrepareRegion();
    };

    var updatePrepareRegion = function () {
        if(_dom){
            if(_dom.find('.J_show').is(":hidden")){
                _dom.find('.J_hidden').hide();
                _dom.find('.J_show').show();
            }else{
                _dom.find('.J_hidden').hide();
            }

            var listDom = _dom.find('.ct-bookcaselist2');
            listDom.find('.ta_ct_icw_ppt').remove();
            $("#ct_self_prepare").remove();

            var selected_li = $("#head_control").find(".selected").attr("id");
            if(selected_li == "head_classprepare"){
                if(recent_list.length > 3){
                    recent_list = recent_list.slice(0,3);
                }
                var newDomItems =  $(Mustache.render(template,{ppt_icw:recent_list}));
                var li_addppt = '<li id="ct_self_prepare"><a href="javascript:;"><div class="add-kejian-ico"></div><p style="line-height:32px;font-size:14px">添加课件</p><div class="kejian-mc"></div></a></li>';
                $(listDom).html("").append(newDomItems);
                listDom.append(li_addppt);
            }else if(selected_li == "head_classattend"){
                if(recent_list.length > 4){
                    recent_list = recent_list.slice(0,4);
                }
                var newDomItems =  $(Mustache.render(template,{ppt_icw:recent_list}));
                $(listDom).html("").append(newDomItems);
            }
        }else{
            return 0;
        }
    };
    var setDefaultPrepare = function () {
        recent_list = [default_icw,default_ppt];
        updatePrepareRegion();
    };

    var onLogin = function (uid) {
        if (uid && _uid != uid) {
            _uid = uid;
        }
        if(_uid) {
            dbaccessor = new J0KeJian.InfoAccess(_uid);
            var param = {};
            var selected_li = $("#head_control").find(".selected").attr("id");
            if (selected_li == "head_classprepare") {
                param.limit = 3;
            } else if (selected_li == "head_classattend") {
                param.limit = 4;
            }
            dbaccessor.indexHtmlInfo(param).done(function (ret) {
                $.each(ret, function (index, el) {
                    var timestamp = Date.parse(new Date());
                    var thumbnail = el.thumbnail + "?t=" + timestamp;
                    el.thumbnail = thumbnail;
                });
                recent_list = ret;
                if (5 > recent_list.length) {
                    recent_list.splice(recent_list.length, 0);
                    recent_list.splice(5, recent_list.length - 5);
                }
                updatePrepareRegion();
            }).fail(function (e) {
                if(_dom.find('.J_show').is(":hidden")){
                    _dom.find('.J_show').hide();
                    _dom.find('.J_hidden').show();
                }else{
                    _dom.find('.J_hidden').hide();
                }
                // TA 获取 iFlySlide 所有课件列表
                var json = {
                    type:"logic",
                    action:"slide_list",
                    from:"ta",
                    to:"all",
                    data:{}
                };
                socket.send(json);
            });
        }else{
            //未获取用户信息，不做处理
            if(_dom.find('.J_show').is(":hidden")){
                _dom.find('.J_show').hide();
                _dom.find('.J_hidden').show();
            }else{
                _dom.find('.J_hidden').hide();
            }
        }
    };

    var onClick = function (index,classStatus) {
        // if(!(fs.existsSync(bookLock)||fs.existsSync(slideLock))){
        //temp eshop监管 linwang5@iflytek.com
        var staticParams = {
            uid:userInfo.id,
            module:'04010',
            type:'trigger',
            havingClass:(window.location.hash.indexOf('classprepare')!=-1) ? 0:1
        };
        edcService.Instance().api_eshop_baseStatics(staticParams);

            console.log("ifs打开当前备课文件");
            var fileObj = recent_list[index];
            var fileId=fileObj.local_id||"";
            var json={
                type : "logic",
                action : "goto_ifyslide",
                from : "ta",
                to : "all",
                data : {
                    id : fileObj.local_id,
                    state:classStatus //0表示备课，1表示上课
                }
            };
            socket.send(json);
    };

    return {
        init: init,
        onLogin: onLogin,
        onClick: onClick,
        ifs_siginal :ifs_siginal
    }
})();