var pageMyApp = new NC.Page({
    name: 'myapp',
    //当前分类索引
    currentIdx: 0,
    init: function (opt) {
        var that = this;
        //跳转应用列表
        $(this.getPageDom()).on("click", "a[ms-action=golist]", function () {
            that.openAPPBox(that.currentIdx);
        });
        //切换管理模式
        $(this.getPageDom()).on("click", "a[ms-action=manage]", function () {
            if ($(this).attr('isManaged') == 'true') {
                if(that.setTab(false)==1){
                    $(".myapp_main").css("overflow", "visible");
                    that.setNormal(this);
                    that.dragSort(false);
                }
                //应用管理监管   ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta_app", module: "05", user_id :userInfo.id},null);
            } else {
                if(that.setTab(false)==1){
                    $(".myapp_main").css("overflow", "hidden");
                    that.setMovable(this);
                    that.dragSort(true);
                }
            }
        });
        //我的应用分页处理
        $(this.getPageDom()).on("click", "a[ms-action=app-cate]", function () {
            var cateId = $(this).attr('ms-cate-id');
            that.currentIdx = cateId;
            $("dl[ms-action=app-box]").hide();
            that.pages[cateId].show();
            $('a[ms-action=app-cate]').removeClass('selected');
            $(this).addClass('selected');
        });
        //添加新应用
        $(this.getPageDom()).on("click", 'dd[ms-controller="app-btn"][ms-action="add-new"]', function () {
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:userInfo.id,
                module:'04008',
                type:'trigger'
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            var cateId = $(this).attr('ms-cate-id');
            that.openAPPBox(cateId);
        });

        //打开网页应用
        $(this.getPageDom()).on("click", 'dd[item-type="webApp"]', function (evt) {
            var id = $(this).attr('content-id');
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid:userInfo.id,
                module:'04009',
                type:'trigger',
                appId:id
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);
            if(id)
            {
                switch (parseInt(id)){
                    case 1:
                        window.location.href = APP_CONFIG.APP_INFO_YUN.url;
                        break;
                    case 2:
                        go_eSchool();
                        break;
                    case 3:
                        window.location.href=APP_CONFIG.APP_INFO_ISAY.url;
                        break;
                    case 4:
                        go_yunres();
                        break;
                    case 6:
                        go_weiba();
                        break;
                    case 7:
                        var json ={
                            type:"logic",
                            action:"microcourse",
                            from:"ta",
                            to:"all",
                            data:{}
                        }
                        socket.send(json);
                        break;
                }
                //打开网页应用监管    ---pengchen3
                LogManager.statistics("trigger", {ta_app :"ta_app", module: "02"+id, user_id :userInfo.id},null);
            }
        });


        //点击应用含删除功能
        $(this.getPageDom()).on("click", 'dd[ms-controller="app-item"]', function (evt) {
            var id = $(this).attr('ms-app-id');
            if ($(evt.target).attr('ms-action') == "delete") {
                that.deleteApp(id);
            } else {

                if($(this).attr("class") && $(this).attr("class").indexOf("shake")!=-1) return;
                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:userInfo.id,
                    module:'04009',
                    type:'trigger',
                    appId:id
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
                var appManager = APPManager.getInstance();

                //百宝箱打开应用监管    ---pengchen3
                if(id != 63) {
                    LogManager.statistics("trigger", {ta_app :"ta_app", module: "04"+id, user_id :userInfo.id},null);
                }
                
                if(id==62){
                    if (APPManager.onlineFlag){
                        // 授权和解除授权弹窗
                        var tipDom = $($('#iflybook_tip').html());
                        var authDom = $($('#iflybook_auth').html());
                        var authStatus = $($('#iflybook_auth_status').html());
                        var authTemplate = fs.readFileSync(APP_CONFIG.BASE_PATH + "/main/assets/template/classteach/auth.html", encoding = 'utf8');
                        $("body").append(tipDom).append(authDom).append(authStatus);
                        tipDom.on("click", "#iflybook_cancel,#iflybook_confirm", function () {
                            tipDom.hide();
                            $("#mask_layer").hide();
                        });
                        authDom.on("click", "#iflybook_auth_cancel", function () {
                            authDom.hide();
                            $("#mask_layer").hide();
                        });
                        authDom.on("click", "#iflybook_auth_del", function () {
                            authDom.hide();
                            $.ajax({
                                url: APP_CONFIG.ESHOP + "/index.php?c=eshopService&a=getUserAuthInfoByLoginName&loginName=" + userInfo.loginName,
                                type: "GET",
                                timeout: 5000,
                                dataType:"json",
                                success:function(data){
                                    if(data && data.result && data.result.authInfo) {
                                        var result = data.result;
                                        var data = [];
                                        for (var i = 0, length = result.authInfo.length; i < length; i++) {
                                            var obj = result.authInfo[i];
                                            obj.authId = obj.id;
                                            obj.id = i + 1;
                                            obj.type = (obj.hdType == 0 ? "计算机" : "U盘");
                                            obj.date = obj.createTime;
                                            obj.mcCode = obj.mcName + "......" + obj.mcCode.slice(-11);

                                            data.push(obj);
                                        }
                                        var ifbAuth = {};
                                        ifbAuth.result = data;

                                        var dom = $(Mustache.render(authTemplate, ifbAuth));
                                        authStatus.find(".ifb_auth_info").remove();
                                        authStatus.find(".sq-table").append(dom);
                                        var authLeft = ($('body').width() - authStatus.width()) / 2 + 'px';
                                        authStatus.css('left', authLeft).show();
                                    }else{
                                        //接口返回数据异常
                                        $("#mask_layer").hide();
                                        pageMyApp.showAuthInfoError();
                                    }
                                },
                                error:function(){
                                    //接口返回数据异常
                                    $("#mask_layer").hide();
                                    pageMyApp.showAuthInfoError();
                                }
                            });
                        });
                        authStatus.on("click", "#iflybook_auth_status_cancel", function () {
                            authStatus.hide();
                            $("#mask_layer").hide();
                        });
                        authStatus.on("click", ".cz-btn", function () {
                            var _this = this;
                            var id = $(_this).parent().next().text();
                            $.ajax({
                                type: 'POST',
                                async: false,
                                dataType: 'json',
                                url:APP_CONFIG.ESHOP + '/index.php?c=personalCenter&a=doDeleteAuth',
                                data:{'id':id,'userAccount':userInfo.loginName},
                                success:function(ret){
                                    if(ret && ret.errorCode == 0){
                                        $(_this).parent().parent().remove();
                                        authStatus.find('.ifb_auth_info').each(function(index){
                                            $(this).find('td').first().text(index+1)
                                        });
                                        iflybookModule.checkBindInfo(userInfo.loginName);
                                    }
                                },
                                error:function(e){
                                    console.error(e);
                                }
                            });
                        });

                        var tipLeft = ($('body').width() - tipDom.width())/2+'px';
                        if(userInfo.loginName != "defaultuser"){
                            TA.UserService.getLocalUserAccount(function(ret){
                                var password = ret.password;
                                var user = {
                                    userInfo: userInfo
                                };
                                iflybookModule.beforeLogin(userInfo.loginName,password,user).done(function(u){
                                    var result = iflybookModule.getResult();
                                    var CloudResult = iflybookModule.CloudResult;
                                    if(result != CloudResult.alreadyBind && result != CloudResult.bindSuccess){
                                        iflybookModule.checkBindInfo(userInfo.loginName).done(function(ret){
                                            if(ret != CloudResult.alreadyBind && ret != CloudResult.bindSuccess){
                                                $("#mask_layer").show();
                                                switch (ret) {
                                                    case CloudResult.isDeleOrOutDate:
                                                    case CloudResult.isDele:
                                                    case CloudResult.isOutDate:
                                                        tipDom.show().css('left',tipLeft)
                                                            .find(".wxts-text").html("该用户被禁用或账户过期<span>请重新登陆</span>");
                                                        break;
                                                    case CloudResult.canNotBind:
                                                        var authLeft = ($('body').width()-authDom.width())/2+'px';
                                                        authDom.show().css('left',authLeft);
                                                        break;
                                                    case CloudResult.getBindMsgError:
                                                    case CloudResult.bindFail:
                                                        tipDom.show().css('left',tipLeft)
                                                            .find(".wxts-text").html("硬件绑定失败<span>请重新登陆</span>");
                                                        break;
                                                    default:
                                                        tipDom.show().css('left',tipLeft)
                                                            .find(".wxts-text").html("用户信息异常，错误码：<span>" + ret.toString() + "</span>");
                                                        break;
                                                }
                                            }else{
                                                appManager.runiFlybook({});
                                            }
                                        })
                                    } else {
                                        appManager.runiFlybook({});
                                    }
                                }).fail(function(errCode){
                                    switch(errCode){
                                        case iflybookModule.CloudResult.isDele:
                                            pageMyApp.showAuthInfoError('软件授权已过期，如需继续使用，请联系当地教育主管部门');
                                            break;
                                        case iflybookModule.CloudResult.isOutDate:
                                            pageMyApp.showAuthInfoError('您的账户已过期');
                                            break;
                                        case iflybookModule.CloudResult.webError:
                                            pageMyApp.showAuthInfoError('获取用户状态信息失败');
                                            break;
                                        default:
                                            //其他错误码
                                            pageMyApp.showAuthInfoError('系统异常，错误码：'+ errCode);
                                            break;
                                    }
                                });
                            });
                        } else {
                            appManager.runiFlybook({});
                        }
                    }else{
                        appManager.runiFlybook({});
                    }
                    return;
                }
                if(id==15){
                    appManager.runDTB();
                    return;
                }
                if(id==150){
                    appManager.runDTB_screen();
                    return;
                }
                if(id==91){
                    appManager.runcameraStand({});
                    return;
                }
                appManager.runApp({
                    id: id,
                    error: function (err) {
                        console.log(err);
                    }
                });
            }
        });

        $(this.getPageDom()).on("click", "a[ms-action=import_export]", function (evt) {
            $("#pop_exportOrimport").show();
            //导入导出监管    ---pengchen3
            LogManager.statistics("trigger", {ta_app :"ta_app", module: "06", user_id :userInfo.id},null);
        });

        //导出应用列表\导出管理选择
        $(document).on("click", "a[ms-item=pop_export]", function (evt) {
            $("a[ms-item=pop_export]").removeClass("select");
            $(this).addClass("select");
            $("#exportSelectList").hide();
            $("#exportHistoryList").hide();
            $("#"+$(this).attr("ms-action")).show();
        });
        //app导出
        $(document).on("click", "a[ms-action=btn_export]", function (evt) {
            $("#pop_exportOrimport").hide();
            $("a[ms-item=pop_export]").removeClass("select");
            $("a[ms-action=exportSelectList]").addClass("select");
            $("#exportHistoryList").hide();
            $("#exportSelectList").show();
            $("#pop_export_container").show();
            var date = (new Date()).toLocaleDateString();
            $("#export_date").html(date);
            syncLocalAppList({
                type:"read",
                success:function(localInfo){
                   if(!localInfo) return;
                   localInfo = JSON.parse(localInfo);
                    var index = 1;
                   $("#exportSelectList").find("ul").html("");
                   var appManager = APPManager.getInstance();
                   for(var i in localInfo){
                        if(localInfo[i].id!=62)
                        {
                            var select = "",size = "0M",icon = "";
                           // if(index==1) select="selected";
                            if(localInfo[i].size)
                                size=Number(localInfo[i].size/1000).toFixed(2)+"M";
                            else{
                                var filePath = APP_CONFIG.BASE_PATH + "/appdata.dat",appdata="";
                                try{
                                    appdata = JSON.parse(shellcmd.readFile(filePath));
                                    for(var j in appdata)
                                        for(var k in appdata[j].data)
                                            if(appdata[j].data[k].apm_id==localInfo[i].id)
                                            {
                                                size = Number(appdata[j].data[k].apm_zip_size/1000).toFixed(2)+"M";
                                                break;
                                            }
                                }
                                catch (e){
                                    console.error(e.message);
                                }
                            }
                            if(appManager.online==1)
                                icon = localInfo[i].icon;
                             else
                                icon = APP_CONFIG.BASE_PATH +"/plugins/" + localInfo[i].id + "/picture/48.png";
                    /*        var _li = ' <li class="fl" ms-item="exportSelectItem" >' +
                            'ms-content-id='+ localInfo[i].id+' ms-content-version='+localInfo[i].version+' ms-content-name='+localInfo[i].name+'>'+
                            '<div  class="clearfix">' +
                            '<label for="" class="fl"><input type="checkbox" class="gall_checkbox" ></label>' +
                            '<div class="gall_banner_box tool_banner_box fl ">' +
                            '<a href=""><img src="assets/images/show_ico.png"></a>' +
                            '</div>' +
                            '<div class="fl pop_list_infor">' +
                            '<h2>实物展台</h2>' +
                            '<p>大小：120M	</p>' +
                            '</div>' +
                            '</div>' +
                            '</li>';*/
                            var _li = '<li class="fl" ms-item="exportSelectItem" ' +
                                'ms-content-id='+ localInfo[i].id+' ms-content-version='+localInfo[i].version+' ms-content-name='+localInfo[i].name+'>'+
                                '<div  class="clearfix">'+
                                '<label ms-action="select_app" for="" class="fl"><input type="checkbox" class="gall_checkbox" ></label>' +
                                    '<div class="gall_banner_box tool_banner_box fl ">'+
                                        '<a href="javascript:;"><img style="width:48px;height: 48px;" src="'+icon+'"></a>'+
                                            /*'<b ms-action="select_app"></b>'+*/
                                        '</div>'+
                                        '<div class="fl pop_list_infor">'+
                                            '<h2>'+localInfo[i].name+'</h2>'+
                                            '<p>大小：'+size+'</p>'+
                                        '</div>'+
                                    '</div>'+
                                '</li>';
                            index++;
                            $("#exportSelectList").find("ul").append(_li);
                        }
                   }
                }
            });


        });
        //选择导出项
        $(document).on("click", "li[ms-item=exportSelectItem]", function (evt) {
            $("li[ms-item=exportSelectItem]").attr("ms-select","");
            //$("li[ms-item=exportSelectItem]").find("label[ms-action=select_app] input").removeClass("selected");
            $.each($("li[ms-item=exportSelectItem]").find("label[ms-action=select_app] input"),function(index,el){
                el.checked = false;
            });
            $(this).find("label[ms-action=select_app] input")[0].checked = true;
            $(this).attr("ms-select","select");
        });
        //确定导出按钮
        $(document).on("click", "a[ms-action=btn_ok_export]", function (evt) {
            var exportItem = $("li[ms-select=select]");
            if(exportItem.length==0) {$("#pop_export_container").hide(); return;}
            var exportAppInfo={
                id:exportItem.attr("ms-content-id"),
                version:exportItem.attr("ms-content-version"),
                name:exportItem.attr("ms-content-name"),
                icon:exportItem.find("img").attr("src")
            };
            var exportList = [];
            exportList.push(exportAppInfo);
            shellcmd.saveFileDialog({
                nwsaveas: exportAppInfo.id+"_"+exportAppInfo.version+"_"+exportAppInfo.name+".nw",
                accept: ".nw"
            }).done(function (filePath) {
               console.log(filePath);
               $("a[ms-action=exportSelectList]").removeClass("select");
               $("#exportSelectList").hide();
               $("a[ms-action=exportHistoryList]").addClass("select");
               $("#exportHistoryList").show();
               filePath = filePath.substr(0,filePath.lastIndexOf("\\"));
               console.log(filePath);
               that.exportApp(exportList,0,filePath);
            });

        });
        //app导入
        $(document).on("click", "a[ms-action=btn_import]", function (evt) {
            $("#pop_exportOrimport").hide();
            shellcmd.openFileDialog({accept: ".nw"}).done(function (ret) {
                if(!ret) return;
                console.log(ret);

                var importPathArr = ret.split(";");
                importPathArr.length>0 && that.importApp(importPathArr,0)
            });
        });
        //查看文件所在位置
        $(document).on("click","a[ms-action=exportAction]",function(){
            var success = $(this).parent().attr("success");
            var id = $(this).parent().attr("ms-history-id");
            var path = $(this).attr("ms-src");
            var exec = require('child_process').exec;
            var fs = require("fs");
            if(success==1){
                fs.exists(path, function (exist) {
                    if(exist){
                        var cmd = "explorer \/select,\"" + path+"\"";
                        exec(cmd, function (err, stdout, stderr) {
                            if (err) {
                                console.log(err.message);
                            }
                        });
                    }else{
                        dOpenLocalFailConfirm.show();
                    }

                });
            }else{
                var item = $(this).parent();
                item.attr("item-status","doing").attr("success",0);
                item.find("p[ms-status=doing]").html("正在导出");
                item.find("a[ms-action=exportAction]").hide();
                item.find("div[ms-show=pace]").show();
                that.exportShow(id,path,item);
            }

        });
        //导入弹出框关闭按钮
        $(document).on("click","#pop_import_close",function(){
           var doing  = $("#importHistoryList").find("p[ms-status=doing]");
            if(doing.length>0)
                dImportCloseConfirm.show();
            else{
                $("#pop_import_container").hide();
                $("#mask_layer").hide();
            }
        });

        //当有下载完成的消息传入
        taEmitter.on(TA_EVENT.DOWNLOAD_BEGIN, NC.delegate(this.onDownloadBegin, this));
        //当有下载完成的消息传入
        taEmitter.on(TA_EVENT.DOWNLOAD_SUCCESS, NC.delegate(this.onDownloadSuccess, this));
        //当有APP删除开始的消息传入
        taEmitter.on(TA_EVENT.DELETED_BEGIN, NC.delegate(this.onAppDeletedBegin, this));
        //当有APP删除完成的消息传入
        taEmitter.on(TA_EVENT.PLUGIN_DELETED, NC.delegate(this.onAppDeleted, this));
    },
    openAPPBox:function(cateId){
        var spawn = require('child_process').spawn;
        var nw = APP_CONFIG.BASE_PATH + "/nw.exe";
        /**
         * 这里判断百宝箱是否存在的原因是：已打开一个百宝箱进程，再次打开时NW返回的进程PID改变，
         * 事实上，PID并未改变，只是重启了一个进程发现单实例后自动退出，同时能监听到重启的进程的离开状态。
         * 如若node-webkit换版本，请注意修改此问题。
         * TODO:something;
         */
        if(TA.Stage.stages['appbox']){
            spawn(nw, [APP_CONFIG.BASE_PATH+'/appbox','e',TA_EVENT.ADDAPP_FROMCATE,cateId], {detached: true});
            return;
        }
        TA.Stage.stages['appbox']=spawn(nw, [APP_CONFIG.BASE_PATH+'/appbox','e',TA_EVENT.ADDAPP_FROMCATE,cateId], {detached: true}).on("error",function (err) {
            shellcmd.log('start app error' + err);
        }).on("exit", function () {
            TA.Stage.stages['appbox']=null;
        });
    },
    onAppDeletedBegin: function (id) {
        //当有消息传入，退出管理模式
        window.location.href = "#/myapp";
    },
    onAppDeleted: function (id) {
        if(this.localInfo && this.localInfo[id]){
            window.location.href = "#/myapp";
            this.setCurrentCategory(this.localInfo[id].category);
            //当有消息传入，退出管理模式
            //this.setNormal($("a[ms-action=manage]", this.getPageDom())[0]);
            this.pages.forEach(function (item, idx) {
                item.find('dd[ms-controller="app-item"][ms-app-id=' + id + ']').remove();
            });
            this.setTab(false);
            this.updateCheck();
            //发消息通知IFB某个APP已安装
            // socket&&socket.send({type:'logic',action:CMD.IFB_PLUGINS_BACK_DELETE,to:TA_APP.TA_APP_IB,data:{id:id}});
        }
    },
    onDownloadBegin: function (id) {
        //当有消息传入，退出管理模式
        // window.location.href = "#/myapp";
    },
    onDownloadSuccess: function (id) {
        //当有消息传入，退出管理模式
        this.setNormal($("a[ms-action=manage]",this.getPageDom())[0]);
        this.localInfo=TA.Utils.getLatestLocalInfo();
        //导入功能添加进来的应用

        if(this.localInfo)  this.createAppItem(this.localInfo[id],true);
        //发消息通知IFB某个APP已安装
        // socket&&socket.send({type:'logic',action:CMD.IFB_PLUGINS_BACK_DOWNLOAD,to:TA_APP.TA_APP_IB,data:{id:id}});
        window.location.href = "#/myapp";
    },
    importApp:function(importPathArr,index){
        var that = this;

        console.log("开始导入");
        var strFileName=importPathArr[index].substr(importPathArr[index].lastIndexOf("\\")+1,importPathArr[index].length).replace(".nw","");
        console.log(strFileName);
        var strArr = strFileName.split("_");
        if(strArr.length!=3){
            dWrongFormatConfirm.show();
            return;
        }
        var importAppInfo = {
            id:strArr[0]||"",
            version:strArr[1]||"",
            name:strArr[2]||""
        };
        var filePath = APP_CONFIG.BASE_PATH + "/appdata.dat",appdata="",flag=0;
        try{
            appdata = JSON.parse(shellcmd.readFile(filePath));
            for(var i in appdata)
                for(var j in appdata[i].data)
                    if(appdata[i].data[j].apm_id==importAppInfo.id && appdata[i].data[j].apm_chinese_name==importAppInfo.name)
                     flag=1;
            if(flag==0){
                dWrongFormatConfirm.show();
                return;
            }
        }
        catch (e){
            console.error(e.message);
        }
        syncLocalAppList({
            type:"read",
            success:function(localInfo){
                localInfo = JSON.parse(localInfo);
                console.log(localInfo);
                $("#mask_layer").show();
                if(localInfo[importAppInfo.id]) {
                    $("#import_exist_text").html("<span style='color: orangered'>"+localInfo[importAppInfo.id].name +"</span>已存在，继续导入会覆盖。是否继续？");
                    dImportConfirm.showModal();
                }else{
                      //正常导入
                      $("#importHistoryList").find("#import_showtext").html("应用正在导入，请不要关闭对话框");
                      $("#pop_import_container").show();
                      that.importSetData(importPathArr,importAppInfo,localInfo,index);
                }
                //覆盖导入
                $("#import_confirm_yes").unbind("click").on("click",function(){
                    dImportConfirm.close();
                    $("#importHistoryList").find("#import_showtext").html("应用正在导入，请不要关闭对话框");
                    $("#pop_import_container").show();

                    that.importSetData(importPathArr,importAppInfo,localInfo,index);
                });
            }
        });
    },
    importSetData:function(importPathArr,importAppInfo,localInfo,index){
        var that = this;
        var unzip = require('../node_modules/unzip');
        var plugins = APP_CONFIG.BASE_PATH + "/plugins/";
        var fs = require('fs');
        var appInfo={ id:importAppInfo.id,name:importAppInfo.name,version:importAppInfo.version,"icon": plugins + importAppInfo.id + "/picture/48.png" || ""};

        var _li ='<li class="clearfix" ms-history-id='+appInfo.id+'>'+
            '<div class="gall_banner_box tool_banner_box fl ">'+
            '<a href="javascript:;"><img style="width:48px;height: 48px;" src="'+appInfo.icon+'"></a>'+
            '<b class="selected"></b>'+
            '</div>'+
            '<div class="fl pop_list_infor">'+
            '<h2>'+appInfo.name+'</h2>'+
            '</div>'+
            '<div class="jd fl" ms-show="pace">'+
            '<div class="jd_con"></div>'+
            '</div>'+
            '<p class="fl" ms-status="doing" style="margin-left:30px;">正在导入</p>'+
//            '<a  class="fr" href="">取消</a>'+
            '</li>';
        $("#importHistoryList").find("ul").append(_li);

        var extract = null;
        //取消导入
        $("#import_close_confirm_yes").unbind("click").on("click",function(){
            extract && extract._parser.end();
            clearInterval(interval);
            $("#importHistoryList").find("li[ms-history-id="+appInfo.id+"]").find("div[ms-show=pace]").hide();
            $("#importHistoryList").find("li[ms-history-id="+appInfo.id+"]").find("p[ms-status=doing]").attr("ms-status","done").html("导入失败");
            dImportCloseConfirm.cancel();
            $("#pop_import_container").hide();
            $("#mask_layer").hide();
        });

        var _width = 0;
        var interval = setInterval(function(){
            if(_width<=90)_width = _width+10;
            else _width=10;
            $("#importHistoryList").find("li[ms-history-id="+appInfo.id+"]").find(".jd_con").css("width",_width+"%")
        },100);
        var appManager = APPManager.getInstance();
        appManager.removeApp({
            id:importAppInfo.id,
            success:function(){
               // taEmitter.emit(TA_EVENT.PLUGIN_DELETED+'.appbox', importAppInfo.id);
                console.log("正在导入");
            //    dImportConfirm.cancel();
                $("#mask_layer").show();
                extract = unzip.Extract({
                    path: plugins + importAppInfo.id,
                    verbose:true
                });
                fs.createReadStream(importPathArr[index]).pipe(extract);
                extract.on("error",function(){
                    $("#importHistoryList").find("li[ms-history-id="+appInfo.id+"]").find("div[ms-show=pace]").hide();
                    $("#importHistoryList").find("li[ms-history-id="+appInfo.id+"]").find("p[ms-status=doing]").attr("ms-status","done").html("导入失败");
                });
                extract.on("close", function () {
                    appManager.getAPPList({
                        success:function(remoteList){
                            for(var i=0;i<remoteList.length;i++){
                                if(remoteList[i].id==importAppInfo.id){
                                    appInfo = remoteList[i];
                                    appInfo.name=importAppInfo.name;
                                    appInfo.version=importAppInfo.version;
                                }
                            }
                            console.log(appInfo);
                            //分类
                            appInfo.category = that.currentIdx;
                            syncLocalAppList({
                                info: appInfo,
                                type: "write",
                                success: function () {
                                    //写入预装
                                    // var preInstallArr =[];
                                    // var filePath = APP_CONFIG.BASE_PATH + "/preInstall.dat";
                                    // try{
                                    //     preInstallArr = JSON.parse(shellcmd.readFile(filePath));
                                    //     if(preInstallArr.indexOf(appInfo.id)==-1) preInstallArr.push(parseInt(appInfo.id));
                                    //     console.log(preInstallArr)
                                    //     shellcmd.writeFile(filePath, JSON.stringify(preInstallArr));
                                    // }
                                    // catch (e){
                                    //     console.error(e.message);
                                    // }
                                    that.onDownloadSuccess(appInfo.id);
                                    taEmitter.emit(TA_EVENT.IMPORT_APP+'.appbox', appInfo.id);
                                    clearInterval(interval);
                                    $("#importHistoryList").find("li[ms-history-id="+appInfo.id+"]").find(".jd_con").css("width","100%");
                                    setTimeout(function(){
                                        $("#importHistoryList").find("li[ms-history-id="+appInfo.id+"]").find("div[ms-show=pace]").hide();
                                    },300);

                                    $("#importHistoryList").find("li[ms-history-id="+appInfo.id+"]").find("p[ms-status=doing]").attr("ms-status","done").html("导入成功");
                                    $("#importHistoryList").find("#import_showtext").html("应用已完成导入，开始使用吧~");
                                    $("#importHistoryList").find("#import_showflag").html("<span style='color: red'>5</span>秒后自动关闭").show();
                                    //时钟
                                    var Time = 5;
                                    var timeInterval =  setInterval(function(){
                                        Time--;
                                        $("#importHistoryList").find("#import_showflag").html("<span style='color: red'>"+Time+"</span>秒后自动关闭");
                                        if(Time==0){
                                            clearInterval(timeInterval);
                                            $("#importHistoryList").find("#import_showflag").hide();
                                            $("#pop_import_container").hide();
                                            $("#mask_layer").hide();
                                        }
                                    },1000);
                                    // dImportSuccessConfirm.show();
                                    console.log("导入成功");
                                    // index ++ ;
                                    //导入下一个应用
                                    //  importPathArr[index] && that.importApp(importPathArr, index);
                                }
                            });
                        }
                    });
                });
            },
            error:function(err){
                console.error(err.message);
            }
        })
    },
    exportApp:function(exportList, i, filePath){
        var that = this;
        var exportPath = filePath+ "\\" + exportList[i].id+"_"+exportList[i].version+"_"+exportList[i].name+".nw";
        var _li ='<li class="clearfix" ms-history-id='+exportList[i].id+' item-status="doing">'+
            '<div class="gall_banner_box tool_banner_box fl ">'+
            '<a href="javascript:;"><img style="width:48px;height: 48px;" src="'+exportList[i].icon+'"></a>'+
            '<b class="selected"></b>'+
            '</div>'+
            '<div class="fl pop_list_infor">'+
            '<h2>'+exportList[i].name+'</h2>'+
            '</div>'+
            '<div class="jd fl" ms-show="pace">'+
            '<div class="jd_con"></div>'+
            '</div>'+
            '<p class="fl" ms-status="doing">正在导出 </p>'+
             '<a ms-action="exportAction" ms-src="'+exportPath+'" style="display: none" class="fr" href="javascript:;">查看</a>'+
            '</li>';
        if($("#exportHistoryList").find("li[ms-history-id="+exportList[i].id+"][item-status=doing]").length!=0){
            $("#exportHistoryList").find("li[ms-history-id="+exportList[i].id+"][item-status=doing]")[0].scrollIntoView();
        }else{
            $("#exportHistoryList").find("ul").append(_li);
            $("#exportHistoryList").find("li[ms-history-id="+exportList[i].id+"][item-status=doing]")[0].scrollIntoView();
            var itemLi = $("#exportHistoryList").find("li[ms-history-id="+exportList[i].id+"][item-status=doing]");
            that.exportShow(exportList[i].id,exportPath,itemLi);
        }

    },
    exportShow:function (id,exportPath,itemLi){
        var fs = require('fs');
        var ziputil = window.require("../node_modules/ziputil/AddonZip");
        var _width = 0;
        var interval = setInterval(function(){
            if(_width<=90)_width = _width+10;
            else _width=10;
            itemLi.find(".jd_con").css("width",_width+"%");
        },100);
        ziputil.updateZipFile(APP_CONFIG.BASE_PATH + "\\plugins\\" + id, exportPath,function(e){
            var exportMessage = arguments[1];
            console.log(arguments);
            console.log(arguments[1]);
            var message="";
            fs.exists(exportPath, function (exist) {
                if(exportMessage==0 && exist )
                {
                    message= "导出成功";
                    itemLi.find("a[ms-action=exportAction]").html("查看").show();
                    itemLi.find(".jd_con").css("width","100%");
                    itemLi.attr("success",1);
                    dExportSuccessConfirm.show();
                }
                else
                {
                    message= "导出失败";
                    itemLi.attr("success",0);
                    itemLi.find("a[ms-action=exportAction]").html("重新导出").show();
                    /**
                     * 导出失败时弹出对话框
                     */
                    $("#pop_export_container").show().find('a[ms-action=exportHistoryList]').trigger('click');
                }

                clearInterval(interval);
                setTimeout(function(){
                    itemLi.find("div[ms-show=pace]").hide();
                },300);
                itemLi.find("p[ms-status=doing]").html(message);
                itemLi.attr("item-status","done");
            });
        });
          //多个导出
          //  i++;
          //  exportList[i] && that.exportApp(exportList, i, filePath);
    },
    deleteApp: function (id) {
        //卸载弹出框提示
        dUninstallConfirm.show();
        //确定卸载
        /**
         * 为了避免上次弹出的删除对话框，确定按钮会删除上次的不想删除的APP，（即一次点击删除多个），开始时先解绑。
         */
        $("#uninstall_confirm_ok").unbind('click');
        $("#uninstall_confirm_ok").one('click', function () {
            dUninstallConfirm.close();
            $("#mask_layer").hide();
            shellcmd.log('pageDetail' + id);
            APPManager.getInstance().removeApp({
                id: id,
                success: function () {
                    console.log("----------------------删除成功")
                    taEmitter.emit(TA_EVENT.PLUGIN_DELETED+'.appbox', id);
                    //删除APP日志
                    LogManager.statisticsMoudleTime(id.toString(),"deleteApp");
                },
                error: function (err) {
                    console.log(err);
                }
            });
        });
        //取消卸载
        $("#uninstall_confirm_cancel").click(function () {
            dUninstallConfirm.close();
            $("#mask_layer").hide();
        });
    },
    setMovable: function (switchBtn) {
        if (!switchBtn)return;
        var that = this;
        $(switchBtn).html("取消管理").attr('isManaged', true);
        that.pages && that.pages.forEach(function (item, idx) {
            var apps = item.find('dd[ms-controller="app-item"]');
            for(var i=0, len=apps.length; i<len; i++) {
                var app = $(apps[i]);
                if(APP_CONFIG.EXIST_APP.indexOf(parseInt(app.attr('ms-app-id'))) == -1) {
                    app.addClass('shake');
                    app.children('div').append('<b ms-controller="app-btn" ms-action="delete"></b>');
                }
            }
        });
    },
    setNormal: function (switchBtn) {
        var that = this;
        $(switchBtn).html("管理").attr('isManaged', false);
        that.pages && that.pages.forEach(function (item, idx) {
            item.find('dd[ms-controller="app-item"]').removeClass('shake');
            //[ms-controller="app-item"]
            item.find('dd[ms-controller="app-item"]>div b').remove();
        });
    },
    setCurrentCategory:function(idx){
        if(!idx)idx=0;;
        $('dl[ms-action=app-box][ms-screen-id]').hide();
        $('a[ms-action=app-cate]').removeClass('selected');
        this.pages[idx].show();
        $('a[ms-action=app-cate][ms-cate-id='+idx+']').addClass('selected');
    },
    pageLoad: function (opt) {
        $(".header_blcok").find(".max").show();
        console.log(opt);
        var that = this;
        if (!this.networkListener) {
            this.networkListener = NC.delegate(this.pageLoad, this);
            taEmitter.on(TA_EVENT.NETWORK_STATUS_CHANGED, this.networkListener);
        }
        that.getPageDom().innerHTML = $('#temp_myapp').html();
        that.pages = [];
        that.pages.push($('dl[ms-action=app-box][ms-screen-id="0"]'));
        that.pages.push($('dl[ms-action=app-box][ms-screen-id="1"]'));
        that.setCurrentCategory(0);

        var path = APP_CONFIG.BASE_PATH + "/user/" + userInfo.loginName + "/tabClassify.dat";
        fs.exists(path, function (exist) {
            if(exist){
                var tabs =  JSON.parse(shellcmd.readFile(path));
                that.tabsList = tabs;
            }else{
                that.tabsList=[
                    {"id":"0","name":"","content":[]},
                    {"id":"1","name":"","content":[]}
                ];
            }
            syncLocalAppList({
                info: "",
                ignoreIflybook: false,
                type: "read",
                success: function (localInfo) {
                    try {
                        localInfo = JSON.parse(localInfo);
                    } catch (ex) {
                        localInfo = {};
                    }
                    that.localInfo = localInfo;
                    that.creatList(localInfo);
                }
            });
        });
        that.updateCheck();
    },
    /**
     * 创建信息列表
     * @remoteAppInfo :远程app信息
     * @localAppInfo 本地已下载的app信息
     * @appList app列表容器
     */
    creatList: function (localAppInfoMap) {
        var that = this;
        var item = '';
//        var item = '<dd item-type="webApp" content-id="{yun_id}"><div><a style="cursor: pointer"><img src="{yun_img}"/></a></div><p>{yun_title}</p></dd>';
       // item += '<dd item-type="webApp" content-id="{eshool_id}"><div><a style="cursor: pointer"><img src="{eSchool_img}"/></a></div><p>{eSchool_title}</p></dd>';
        // item += '<dd item-type="webApp" content-id="{isay_id}"><div><a style="cursor: pointer"><img src="{isay_img}"/></a></div><p>{isay_title}</p></dd>';
        //item += '<dd item-type="webApp" content-id="{yunres_id}"><div><a style="cursor: pointer"><img src="{yunres_img}"/></a></div><p>{yunres_title}</p></dd>';
        item += '<dd item-type="webApp" content-id="{weike_id}"><div><a style="cursor: pointer"><img src="{weike_img}"/></a></div><p>{weike_title}</p></dd>';
//        item += '<dd item-type="webApp" content-id="{weiba_id}"><div><a style="cursor: pointer"><img src="{weiba_img}"/></a></div><p>{weiba_title}</p></dd>';
    //    item += '<dd><div><a href="javascript:;" id="singASong"><img src="./assets/images/aihou.jpg"/></a></div><p>我们都爱唱</p></dd>'
        var $item=$(item.replace('{yun_id}',APP_CONFIG.APP_INFO_YUN.id).replace('{yun_img}',APP_CONFIG.APP_INFO_YUN.img_url).replace('{yun_title}',APP_CONFIG.APP_INFO_YUN.title)
           // .replace('{eshool_id}',APP_CONFIG.APP_INFO_ESCHOOL.id).replace('{eSchool_img}',APP_CONFIG.APP_INFO_ESCHOOL.img_url).replace('{eSchool_title}',APP_CONFIG.APP_INFO_ESCHOOL.title)
            // .replace('{isay_id}',APP_CONFIG.APP_INFO_ISAY.id).replace('{isay_img}',APP_CONFIG.APP_INFO_ISAY.img_url).replace('{isay_title}',APP_CONFIG.APP_INFO_ISAY.title)
            //.replace('{yunres_id}',APP_CONFIG.APP_INFO_RESOURCE_CENTER.id).replace('{yunres_img}',APP_CONFIG.APP_INFO_RESOURCE_CENTER.img_url).replace('{yunres_title}',APP_CONFIG.APP_INFO_RESOURCE_CENTER.title)
            //.replace('{weiba_id}',APP_CONFIG.APP_INFO_WEIBA.id).replace('{weiba_img}',APP_CONFIG.APP_INFO_WEIBA.img_url).replace('{weiba_title}',APP_CONFIG.APP_INFO_WEIBA.title))
            .replace('{weike_id}',APP_CONFIG.APP_INFO_WEIKE.id).replace('{weike_img}',APP_CONFIG.APP_INFO_WEIKE.img_url).replace('{weike_title}',APP_CONFIG.APP_INFO_WEIKE.title));
        this.pages[0].append($item);

        var tabs = that.tabsList;
        var path = APP_CONFIG.BASE_PATH + "/user/" + userInfo.loginName + "/tabClassify.dat";
        fs.exists(path, function (exist) {
            if(exist){

                /**
                 * 解决已安装app不在“我的应用”显示的问题 ---偶现
                 * 原因分析：同时加载几个APP，可能由于调用createAppItem中执行setTab时候出错，某次setTab少执行
                 */
                for(var i in localAppInfoMap) {
                    if(that.tabsList[0].content.indexOf(i) == -1 && APP_CONFIG.INVISIBLE_APP.indexOf(parseInt(i)) == -1) {
                        that.tabsList[0].content.push(i);
                    }
                }

                for(var j in tabs)
                {
                    var content = tabs[j].content;
                    for(var i in content)
                    {
                        if(APP_CONFIG.INVISIBLE_APP.indexOf(parseInt(content[i])) == -1) {
                            var localAppInfo = localAppInfoMap[content[i]];
                            //新增异常处理，解决localAppInfoMap没有存储app信息导致程序终止后面的app页面中不显示
                            if(localAppInfo){
                                localAppInfo.category=tabs[j].id;
                                that.createAppItem(localAppInfo);
                            }
                        }
                    }
                }
            }else{
                for (var i in localAppInfoMap) {
                    if(APP_CONFIG.INVISIBLE_APP.indexOf(parseInt(i)) == -1) {
                        var localAppInfo = localAppInfoMap[i];
                        that.createAppItem(localAppInfo);
                    }
                }
            }
        });

        this.pages[0].append($('<dd ms-controller="app-btn" ms-action="add-new" ms-cate-id="0"><div><a href="javascript:;"><img src="assets/images/add_gallary.png"/></a></div></dd>'));
        this.pages[1].append($('<dd ms-controller="app-btn" ms-action="add-new" ms-cate-id="1"><div><a href="javascript:;"><img src="assets/images/add_gallary.png"/></a></div></dd>'));
        
        //应用初始化后加引导页面
        // checkFreshGuider("second");
    },
    /**
     * 构造单个app
     * @localAppInfo 本地已下载的app信息
     */
    createAppItem: function (localAppInfo,isShowContainer) {
        if(!localAppInfo)return;
        var that = this;
        var item = '<dd ms-controller="app-item" ms-app-id="{id}"><div><a href="javascript:;"><img src="{src}"/></a></div><p>{name}</p></dd>';
        var pngSrc = APP_CONFIG.BASE_PATH+"/plugins/"+localAppInfo.id+"/picture/48.png";
        var $item = $(item.replace('{id}', localAppInfo.id).replace('{src}', APPManager.onlineFlag?(localAppInfo.lowIcon||localAppInfo.icon):pngSrc).replace('{name}', localAppInfo.name));
        localAppInfo.category = localAppInfo.category || 0;
        if(typeof that.pages != "undefined") {
            var btnAdd = that.pages[localAppInfo.category].find('dd[ms-controller="app-btn"]');

            if (btnAdd.length) {
                if($("dd[ms-app-id='"+localAppInfo.id+"']").length==0)
                    $item.insertBefore(btnAdd);
            } else {
                    that.pages[localAppInfo.category].append($item);
            }
            if(isShowContainer){
                that.setCurrentCategory(localAppInfo.category);
               /*if( that.tabsList[localAppInfo.category].content.indexOf(localAppInfo.id)==-1)
                    that.tabsList[localAppInfo.category].content.push(localAppInfo.id);
                var path = APP_CONFIG.BASE_PATH + "/DAT/tabClassify.dat";
                shellcmd.writeFile(path,JSON.stringify(that.tabsList));*/
                that.setTab(false);
                that.updateCheck();
            }
        }
    },
    dragSort:function(isSortable){
        var that = this;
        for(var i in that.tabsList)
        {
            if(!isSortable)
            {
                $( "#sortable" +  that.tabsList[i].id ).sortable().sortable('destroy').disableSelection();
            }else{
                $( "#sortable"+ that.tabsList[i].id ).sortable({
                    items:"dd[ms-controller='app-item']",
                    containment: ".gallery02_content"
                }).disableSelection();
            }
        }
        if(!isSortable) return;
        var $tabs = $( "#container_tabs" ).tabs();
        var $tab_items = $( "#tab_con a", $tabs ).droppable({
            accept: ".connectedSortable dd",
            hoverClass: "selected",
            tolerance: "touch",
            out:function(event, ui){
                $("a[ms-action='app-cate']").removeClass("selected");
                $($("a[ms-action='app-cate']")[that.currentIdx]).addClass("selected");
            },
            drop: function( event, ui ) {
                var $item = $( this );
                var $list = $( $item.attr( "ms-href" ) )
                    .find( ".connectedSortable" );

                ui.draggable.hide( "slow", function() {
                    $tabs.tabs( "select", $tab_items.index( $item ) );
                    that.currentIdx = $tab_items.index( $item );
                    console.log(that.currentIdx)
                    $( this ).appendTo( $list).insertBefore($list.find("dd[ms-action='add-new']")).show( "slow" );
                    $("dl[ms-controller='container']").hide();
                    $tab_items.removeClass("selected");
                    $item.addClass("selected");
                    $list.show();
                });
            }
        });
    },
    setTab:function(isEdit){
        var that = this;
        if(!isEdit){
            //重置tabList
            var _tempArr=[];
            // var _tab = $("#container_tabs").find("a[ms-action=app-cate]");
            // for(var i=0; i<_tab.length;i++){
            //     var _tempobj = {};
            //     _tempobj.id=$(_tab[i]).attr("ms-cate-id");
            //     _tempobj.name=$(_tab[i]).find("label").text();
            //     _tempobj.content=[];
            //     var tabId =_tempobj.id;
            //     if($("#sortable"+tabId).find("dd[ms-controller='app-item']"))
            //         for(var j=0;j<$("#sortable"+tabId).find("dd[ms-controller='app-item']").length;j++)
            //         {
            //             var appId = $($("#sortable"+tabId).find("dd[ms-controller='app-item']")[j]).attr("ms-app-id");
            //             appId && _tempobj.content.push(appId);
            //             //同步修改localInfo的category
            //             that.localInfo[appId].category=i;
            //         }
            //     _tempArr.push(_tempobj);
            // }
            
        //app不分类时保存排序（临时做法）
            var _tempobj = {};
            _tempobj.content=[];
            _tempobj.id = 0;
            if($("#sortable0").find("dd[ms-controller='app-item']")) {
                for(var j=0;j<$("#sortable0").find("dd[ms-controller='app-item']").length;j++)
                {
                    var appId = $($("#sortable0").find("dd[ms-controller='app-item']")[j]).attr("ms-app-id");
                    appId && _tempobj.content.push(appId);
                    //同步修改localInfo的category
                    that.localInfo[appId].category=0;
                }
            }
            _tempArr.push(_tempobj);
            that.tabsList = _tempArr;
            var path = APP_CONFIG.BASE_PATH + "/user/" + userInfo.loginName + "/tabClassify.dat";
            shellcmd.writeFile(path,JSON.stringify(that.tabsList));
            return 1;
        }
    },
    updateCheck:function(){
        var that = this;
        syncLocalAppList({
            info: "",
            ignoreIflybook: false,
            type: "read",
            success: function (localInfo) {
                var appManager = APPManager.getInstance();
                appManager.getAPPList({
                    network: APPManager.onlineFlag,
                    success: function (remoteAppInfoList, online) {
                //        that.remoteAppInfoList = remoteAppInfoList;
                        var localAppInfoMap;
                        try {
                            localAppInfoMap = JSON.parse(localInfo);
                        } catch (e) {
                            console.log(e)
                        }
                //        remoteAppInfoList = that.sortCategory(remoteAppInfoList);
                        var updateNum = 0;
                        for(var i in remoteAppInfoList){
                            var item = remoteAppInfoList[i];
                            if(localAppInfoMap[item.id] && (localAppInfoMap[item.id].version < item.version)){
                                updateNum++;
                            }
                        }
                        $("b[item-name='update-warn']").text(updateNum);
                        if(updateNum==0) $("b[item-name='update-warn']").hide();
                        else{
                            $("b[item-name='update-warn']").show();
                        }
                    },
                    error: function () {
                    }
                });

            }
        });
    },
    showAuthInfoError : function(content){
        content = content || "获取账号授权信息失败，请重试";
        //接口返回数据异常
        $("#mask_layer").hide();
        //复用iflybook_exist模板
        var $ifbRunDialog = $("#iflybook_exist");
        $ifbRunDialog.find("p[name='content']").html("").html(content);
        //绑定事件
        $($ifbRunDialog).on("click","a[name='close']",function () {
            $($ifbRunDialog).hide();
        });
        $($ifbRunDialog).on("click","a[name='complete']",function () {
            $($ifbRunDialog).hide();
        });
        $($ifbRunDialog).on("click","a[name='cancel']",function () {
            $($ifbRunDialog).hide();
        });
        $ifbRunDialog.show();
        return 0;
    }
});
NC.Pages.register(pageMyApp);
function go_eSchool(){
//    if(onLoginFlag){
//        window.location.href  = APP_CONFIG.APP_INFO_ESCHOOL.url_on;
//    }else{
//        window.location.href = APP_CONFIG.APP_INFO_ESCHOOL.url_off;
//
//    }

    //该模块已屏蔽
    // var url = APP_CONFIG.YUN_ESCHOOL_LOGIN;
    // if(userInfo.loginName != "defaultuser"){
    //     DES.init(APP_CONFIG.DESKEY,userInfo.loginName + "=" + userInfo.password);
    //     var token = DES.Encrypt();
    //     url = url + "&token=" + token;
    // }
    // startWeb(url);
}


function go_yunres(){
/*   if(onLoginFlag){
       window.location.href = APP_CONFIG.APP_INFO_RESOURCE_CENTER.url_on;
   }else{
       window.location.href = APP_CONFIG.APP_INFO_RESOURCE_CENTER.url_off;

   }*/
    //打开畅言云链接（该模块已屏蔽）
    // var url = APP_CONFIG.YUN_RESOURCE_LOGIN;
    // if(userInfo.loginName != "defaultuser"){
    //     DES.init(APP_CONFIG.DESKEY,userInfo.loginName + "=" + userInfo.password);
    //     var token = DES.Encrypt();
    //     url = url + "&token=" + token;
    // }
    // startWeb(url);

/*    var exec = require('child_process').exec;
    var path = require('path');
    var sourceCenter;
    sourceCenter = '"'+process.execPath+'" "' + APP_CONFIG.BASE_PATH + '/plugins/94/main"';
    var uid = userInfo.id || "";
    sourceCenter=sourceCenter+" "+uid;
    var p = exec(sourceCenter,
        function (error, stdout, stderr) {
            console.log('stdout: ' + stdout);
            console.log('stderr: ' + stderr);
            if (error !== null) {
                console.log('exec error: ' + error);
            }
        });*/

}
function go_weiba(){
    if(onLoginFlag){
        window.location.href = APP_CONFIG.APP_INFO_WEIBA.url_on;
    }else{
        window.location.href = APP_CONFIG.APP_INFO_WEIBA.url_off;

    }
}