/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 15-6-7
 * Time: 下午4:32
 * To change this template use File | Settings | File Templates.
 */
//书本信息获取入口
KeJian.BookInfoAccessor = function(uid,userName){
    var _self = this;
    var uid = uid;
    var userName = userName;
    var fs = require('fs');
    var dbpath = APP_CONFIG.PREPARE_BOOKS_PATH + uid + "/book.db";
    var sqlite3 = require('sqlite3').verbose();

    _self.getAllBooksInfo = function () {
        var def = $.Deferred();
        var db = new sqlite3.Database(dbpath);
        db.all("SELECT * FROM books", function (err, rows) {
            db.close();
            if(err){
                def.reject(err);
            }else{
                def.resolve(rows);
            }
        });
        return def.promise();
    };

    _self.getAllThumbnails = function () {
        var def = $.Deferred();
        var tempDbPath = dbpath;
        //此处判断应该是没有用处了
        if (!fs.existsSync(tempDbPath)) {
            tempDbPath = APP_CONFIG.BOOKS_PATH + 'defaultuser' + "/userdb.db";
        }
        var db = new sqlite3.Database(tempDbPath);
        db.all("SELECT * FROM books", function (err, rows) {
            db.close();
            def.resolve(rows);
        });
        return def.promise();
    };
}

//书本目录信息获取入口
KeJian.BookMenuGettor = function(uid,userName){
    var _self = this;
    var uid = uid;
    var userName = userName;
    var userpath = APP_CONFIG.PREPARE_BOOKS_PATH + uid + "/book/" ;
    var preList = ["13170425-022"];
    var menusavePath = APP_CONFIG.PPTICWS_PATH + "menus/";

    //获取书本目录信息，
    _self.getMenuInfo = function(bookCode,bookName,callback){
        var menupath = "";
        var str = "";
        for(var i = 0,len= preList.length,flag=0;i<len;i++){
            if(bookCode == preList[i]){
                flag = 1;
                break;
            }
        }
        //目录文件地址
        menupath = userpath + bookCode + "/" + bookCode + ".menu";
        fs.exists(menupath, function(exists) {
            if (exists) {
                str = shellcmd.readFile(menupath);
                _self.formatMenu(str,bookCode,function(result){
                    callback&&callback(result);
                },bookName);
            } else {
                _self.getBookMeun(bookCode).done(function(result){
                    str = result.data;
                    str = JSON.stringify(str);
                    //保存到本地同步
                    var fs = require('fs');
                    fs.writeFile(menupath,str);
                    var menuParser = new KeJian.MenuFormat();
                    var menujson = menuParser.zTreeJson(menuJson.data, bookName,bookCode);
                    callback && callback(menujson);
                });
            }
        });


    };
    _self.formatMenu  = function(str,bookcode,callback,thisName){
        try {
            var menuJson = JSON.parse(str);
            var menuParser = new KeJian.MenuFormat();
            var menujson = menuParser.zTreeJson(menuJson.data, thisName,bookcode);
            callback && callback(menujson);
        }
        catch (e){
            console.log(e);
        }
    };

    _self.getMenu = function(bookcode){
        //先从接口获取最新的menu，然后调整，保存
        //如果离线从menu库获取调整好的menu
    };
    _self.getBookMeun = function(bookcode){
        var def = jQuery.Deferred();
        var param={
            bookCode:bookcode
        }
        edcService.Instance().ersp_resource_metadata_book_unit_list(param).done(function(result){
            def.resolve(result);
        }).fail(function (err) {
            def.reject(err);
        })
        return def.promise();
    };
    // todo 这个方法和下面一个重命名了,回头啥时候看到这个方法哪里用了记得改下
    _self.saveMenu = function(bookcode,menu){
        var savePath = menusavePath + bookcode + ".menunode";
        shellcmd.writeFile(savePath,JSON.stringify(menu));
    }
};

/**
 * 将cycore数据转为ztree数据
 *
 */
KeJian.MenuFormat = function(){
    var _self = this;
    function MenuNode(){
        this.name = "";
        this.Unit1 = "";
        this.Unit2 = "";
        this.Unit3 = "";
        this.Unit4 = "";
        this.children = "";
        this.open = "";
    }

    this.zTreeJson = function(Unit1s,thisName,bookCode){
        var list = _self.turnMenuNode(Unit1s)
        var rootJson = new MenuNode();
        rootJson.children = list;
        if(thisName){
            rootJson.name = thisName
        }
        if(bookCode){
            rootJson.bookcode=bookCode;
        }else{
            rootJson.bookcode="";
        }
        rootJson.open = true;
        return rootJson;
    };
    this.turnMenuNode = function (Unit1s){
        var obj = null;
        var list = [];
        var Units = Unit1s;
        for(var i = 0,len = Units.length;i<len;i++){
            obj = new MenuNode();
            obj.name = Units[i].name;
            obj.Unit1 = Units[i].code;
            //         obj.Unit1 = i ;
            obj.Unit2 = "";
            obj.Unit3 = "";
            obj.Unit4 = "";
            if(Units[i].courses.length > 0 ){
                obj.children = Unit2(Units[i].courses,obj.Unit1);
                obj.open = true;
            }
            list.push(obj);
        }
        return list;
    }

    function Unit2(Unit2s,unit1code){
        var obj = null;
        var list = [];
        var Units = Unit2s;
        for(var i = 0,len = Units.length;i<len;i++){
            obj = new MenuNode();
            obj.name = Units[i].name;
            obj.Unit1 = unit1code;
            obj.Unit2 = Units[i].code;
            //  obj.Unit2 = i ;
            obj.Unit3 = "";
            obj.Unit4 = "";
            if(Units[i].courses.length > 0 ){
                obj.children = Unit3(Units[i].courses,unit1code,obj.Unit2);
                obj.open = true;
            }
            list.push(obj);
        }
        return list;
    }

    function Unit3(Unit3s,unit1code,unit2code){
        var obj = null;
        var list = [];
        var Units = Unit3s;
        for(var i = 0,len = Units.length;i<len;i++){
            obj = new MenuNode();
            obj.name = Units[i].name;
            obj.Unit1 = unit1code;
            obj.Unit2 = unit2code;
            obj.Unit3 = Units[i].code;
            //           obj.Unit3 = i ;
            obj.Unit4 = "";
            if(Units[i].courses.length > 0 ){
                obj.children = Unit4(Units[i].courses,unit1code,unit2code,obj.Unit3);
                obj.open = true;
            }
            list.push(obj);
        }
        return list;
    }

    function Unit4(Unit3s,unit1code,unit2code,unit3code){
        var obj = null;
        var list = [];
        var Units = Unit3s;
        for(var i = 0,len = Units.length;i<len;i++){
            obj = new MenuNode();
            obj.name = Units[i].name;
            obj.Unit1 = unit1code;
            obj.Unit2 = unit2code;
            obj.Unit3 = unit3code;
            obj.Unit4 = Units[i].code;
            //           obj.Unit4 = i ;
            list.push(obj);
        }
        return list;
    }

}

/*
 * 添加书本
 * */
KeJian.Bookadd = function(uid,userName,bookInfo){
    var _self = this;
    var uid = uid;
    var userName = userName;
    var fs = require('fs');
    var userPath = APP_CONFIG.PREPARE_BOOKS_PATH + uid;
    var bookInfo=bookInfo;
    var bookCode = bookInfo.code;
    var url = null;
    if(bookInfo.covers){
        for(var k in bookInfo.covers){
            url = bookInfo.covers[k];
            break;
        }

    }

    // done返回缩略图地址
    _self.startDown = function(){
        var BookDB = new KeJian.BookInfoAccessor(uid,userName);
        var flag = true;
        var def = $.Deferred();
        BookDB.getAllBooksInfo().done(function(db){
            for(var i in db){
                if(db[i].bookCode == bookCode){
                    flag = false;
                    def.reject(true,'备课本已存在');
                    break;
                }
            }
            if(flag){
                // pageMyPrepare.setBeikeCenterPositionInner($('#maskCreatePrepareLoading').find('div'));
                // $('#maskCreatePrepareLoading').show();
                //如果不存在书本文件夹则创建一个
                var bookpath=userPath+'/book/'+bookCode;
                if(!fs.existsSync(bookpath)){
                    fs.mkdirSync(bookpath);
                }
                //下载分成两部分，一部分保存menu文件，一部分下载缩略图
                $.when(_self.getBookMeunSave(),_self.downloadImg(url)).done(function () {
                    var params = {};
                    params.id = shellcmd._getRandomString();
                    var thumbpath=userPath+'/book/'+bookCode +'/'+bookCode+'_Thumbnail.png';
                    params.bookInfo = bookInfo;
                    _self.addBookToDB(params).done(function () {
                        // $('#maskCreatePrepareLoading').hide();
                        def.resolve(thumbpath);
                        //监管
                        LogManager.statistics('trigger', {user_id: uid, module: '1', ta_app: 'beike'}, null);
                    }).fail(function () {
                        // $('#maskCreatePrepareLoading').hide();
                        def.reject(false,'创建失败');
                    });

                }).fail(function () {
                    // $('#maskCreatePrepareLoading').hide();//这个是正在创建的gif
                    def.reject(false,'创建失败');//这个返回之后会弹出创建失败弹框
                })
            }
        }).fail(function () {
            // $('#maskCreatePrepareLoading').hide();//这个是正在创建的gif
            def.reject(false,'创建失败');//这个返回之后会弹出创建失败弹框
        });
        return def.promise();
    }

    _self.deleteDir = function(path){
        //删除目录
        shellcmd._rmdirASync(path);
    }
    //请求接口获取书本目录信息并保存至本地
    _self.getBookMeunSave = function(){
        var def = jQuery.Deferred();
        var param={
            bookCode:bookCode
        }
        edcService.Instance().ersp_resource_metadata_book_unit_list(param).done(function (result) {
            if(result.code=='0'){
                var _result=result.data;
                var file =  userPath+'/book/'+bookCode +'/'+bookCode+'.menu';
                if(fs.existsSync(file)){
                    fs.writeFile(file,JSON.stringify(_result));
                }else{
                    fs.appendFile(file,JSON.stringify(_result),{encoding:'utf-8'});
                }
                //调用服务增加书本目录
                var _param={
                    method:'addMenu',
                    data:{
                        userName:pageMyPrepare.userInfo.loginName,
                        bookCode:bookCode,
                        bookName:bookInfo.name,
                        update:true,//true or false 是否更新,
                        path:file,//目录文件的路径
                    }
                }
                hproseClient.hproseNoti(_param);
                def.resolve();
            }else {
                def.reject();
            }
        }).fail(function (err) {
            def.reject(err);
        })

        return def.promise();
    };
    //todo 应该没啥用了，如果没出啥错，删掉吧
    // _self.saveMenu = function(result){
    //     var file =  userPath+'/book/'+bookCode +'/'+bookCode+'.menu';
    //     if(fs.existsSync(file)){
    //         fs.writeFile(file,JSON.stringify(result));
    //     }else{
    //         fs.appendFile(file,JSON.stringify(result),{encoding:'utf-8'});
    //     }
    // }
    //下载书本缩略图，若书本无缩略图，使用默认图片
    _self.downloadImg = function(url){
        var def= jQuery.Deferred();
        var params = {};
        params.url = url;
        params.id = shellcmd._getRandomString();
        params.file = userPath+'/book/'+bookCode +'/'+bookCode+'_Thumbnail.png';
        params.source = 'downloadBookImg';
        params.bookInfo = bookInfo;
        if(url){
            var http = require("http");
            http.get(url,function(res){
                var data = '';
                res.setEncoding("binary");
                res.on("data",function(chunk){
                    data += chunk;
                });
                res.on("end",function(){
                    fs.writeFile(params.file, data, "binary", function(err){
                        if(err){
                            def.reject();
                        }else{
                            def.resolve();
                        }
                    });
                })
            }).on('error', function(e) {
                def.reject();
            });
        }else{
            //拷贝图片
            shellcmd.copyFile(APP_CONFIG.PREPARE_BOOKS_PATH+'book.jpg',params.file).done(function(){
                def.resolve();
            }).fail(function(){
                def.reject();
            })
        }
        return def.promise();
    };
    //将书本信息写入数据库
    _self.addBookToDB = function (data) {
        var def = $.Deferred();
        var dbpath = APP_CONFIG.PREPARE_BOOKS_PATH + uid + "/book.db";
        var sqlite3 = require('sqlite3').verbose();
        var db = new sqlite3.Database(dbpath);
        var sql = "insert into books values('" +
            data.id + "','" + data.bookInfo.code + "','" + data.bookInfo.name + "','" +
            0 + "','" + 0 + "','" + 0 + "','" +
            0 + "','" + data.bookInfo.properties.publisher[0] + "','" + data.bookInfo.properties.grade[0] + "','" + data.bookInfo.properties.subject[0] + "','" +
            data.bookInfo.properties.volume[0] + "','0','0','0','0','0','0','0')";
        db.all(sql, function (err, rows) {
            db.close();
            if (err) {
                def.reject();
            } else {
                def.resolve();
            }
        });
        return def.promise();
    };

}

