/**
 * 这里封装数据库调用方法
 *
 */
//文件系统
APP_CONFIG.KeiJianType = {
    "PPT": "ppt",
    "PPTX" : "pptx",
    "ICW": "icw"
}

KeJian.KeJianItems = function () {
    var _self = this;

    _self.type = APP_CONFIG.KeiJianType.PPT;
    //云端id
    _self.fileid = "";
    //显示给用户看的名称
    _self.filename = "用户自定义名称";
    //文件夹时间戳
    _self.timestamp = "";
    //文件物理地址名称
    _self.filepath = "文件名";

    _self.unit1 = "";
    _self.unit2 = "";
    _self.unit3 = "";
    _self.unit4 = "";
    _self.bookcode = "";
    _self.usedtime = 0;
    _self.lasttime = "";
    _self.creator = "";
    _self.size = 0;

    _self.initInfo = function(type,fileid,filename,timestamp,filepath,unit1,unit2,unit3,unit4,bookcode,usedtime,lasttime,creator,size,fromIfb,secondType){
        _self.type = type;
        _self.fileid = fileid;
        _self.filename = filename;
        _self.timestamp = timestamp;
        _self.filepath = filepath;
        _self.unit1 = unit1;
        _self.unit2 = unit2;
        _self.unit3 = unit3;
        _self.unit4 = unit4;
        _self.bookcode = bookcode;
        _self.usedtime = usedtime;
        _self.lasttime = lasttime;
        _self.creator = creator;
        _self.size = size;
        _self.fromIfb=fromIfb;
        _self.secondType=secondType;
    }

};

KeJian.InfoAccess = function (uid) {
    var _self = this;
    var uid = uid;
    var dbpath = APP_CONFIG.PPTICWS_PATH + uid + "/file.db";
    var sqlite3 = require('sqlite3').verbose();

    _self.allInfo = [];

    _self.getAllInfo = function (keys , vals) {
        var def = $.Deferred();
        var db = new sqlite3.Database(dbpath);
        //
        db.all("PRAGMA table_info(ppticws)",function(err,rows){
            var creator=rows.filter(function(el){return el.name=="creator"});
            if(creator==""){
                db.run("ALTER TABLE  ppticws  ADD creator varchar(255) default "+pageMyPrepare.userInfo.userName);
            }
            var size=rows.filter(function(el){return el.name=="size"});
            if(size==""){
                db.run("ALTER TABLE  ppticws  ADD size int default 12222");
            }
        });
        // 从数据库中取得所有数据
        db.all("SELECT * FROM ppticws", function (err, rows) {
            var fs=require("fs");
            rows.forEach(function(el){
                try {
                 el.size=fs.statSync( APP_CONFIG.PPTICWS_PATH + uid + '/'+el.timestamp+'/'+el.filepath).size;
                }catch (e){
                    //文件不存异常处理
                }
            });
            for(var i=0;i<rows.length;i++){
                //新增fromIfb属性，防止出现不存在fromIfb属性的错误
                rows[i].fromIfb=false;
                if(rows[i].fromapp=="iflybook"){
                rows[i].fromIfb=true;
                }
            };
            db.close();
            // //从ifb数据库中读取数据，和ta数据库进行对比，如果是ifb中授课包资源，高亮显示
            // _self.getIfbAllInfo().done(function(ifbrows){
            //     console.log(ifbrows);
            //     for(var i=0;i<rows.length;i++){
            //         //新增fromIfb属性，防止出现不存在fromIfb属性的错误
            //         rows[i].fromIfb=false;
            //         for(var j=0;j<ifbrows.length;j++){
            //             //加上rows[i].timestamp==rows[i].fileid判断条件是因为。ifb保存过来的数据timestamp和fileid是一致的，ta中下载的
            //             //是不一致的
            //             if(rows[i].fileid==ifbrows[j].id&&rows[i].timestamp==rows[i].fileid){
            //                 rows[i].fromIfb=true;
            //             }
            //         };
            //     };
            //     _self.allInfo = _self.formatDBInfo(rows);
            //     // def.resolve(selectHelper(keys, vals));
            //     def.resolve();
            // });
            _self.allInfo = _self.formatDBInfo(rows);
            def.resolve();
        });

        return def.promise();
    };
    // //获取Ifb数据库中所有授课包资源信息
    // _self.getIfbAllInfo=function(){
    //     var def = $.Deferred();
    //     //iflybook资源数据库地址
    //     var ifbDbpath=APP_CONFIG.IFB_RESOURCE_PATH+pageMyPrepare.userInfo.loginName+"/userdb.db";
    //     var db = new sqlite3.Database(ifbDbpath);
    //     db.all("SELECT * FROM resources", function (err, rows) {
    //         def.resolve(rows);
    //     })
    //     return def.promise();
    // };


    // //获取ifb中互动卡片的id信息 读xml文件
    // //TODO
    // _self.getIfbActiveCardIds=function(){
    //     //interactiveCardIds存储互动卡片fileId
    //     var interactiveCardIds=[]
    //     var ifbXamlpath="D:/workspace/EPD_TA5.0(GIT)/TA/plugins/62/bin/users/User1471614971096/userbook/13170425-022/1/1.xaml";
    //     //读取xaml文件，得到一个string
    //     var str=shellcmd.readFile(ifbXamlpath);
    //     var pageXmlParser=new KeJian.pageXmlParser();
    //     var node=pageXmlParser.ToJSON(str);
    //     if(node.absolutelayout.interactiveCard){
    //         for(var i=0;i<node.absolutelayout.interactiveCard.length;i++){
    //             interactiveCardIds.push(node.absolutelayout.interactiveCard[i].file.resourceId)
    //         }
    //     }
    //     return interactiveCardIds;
    // }

    //添加
    _self.addInfo = function (item) {
        var def = $.Deferred();
        var db = new sqlite3.Database(dbpath);
        var title = _self.getName(item.filename,function(title){
            if(title !== item.filename){
                item.filename = title;
//                item.filepath = title+'.'+item.type;
                //文件改名字
            }
            var sql = "insert into ppticws values('"+
                item.filename.replace(/'/g,'\'\'') + "','" + item.unit1 + "','" + item.unit2 + "','" +
                item.unit3 + "','"+ item.unit4 + "','"+ item.timestamp + "','"+
                item.fileid + "','"+ item.type +"','"+  item.bookcode + "','0','0','0','0','"+
                item.filepath.replace(/'/g,'\'\'') +"','0','"+item.lasttime+ "','"+
                item.creator + "','"+ item.size +
                "')";

            db.exec(sql, function (err, rows) {
                _self.allInfo.push(item);
                db.close();
                def.resolve(_self.allInfo);
            });
        },item.type);


        return def.promise();
    };

    //这里把type写在最后一个参数主要是为了考虑兼容其他代码
    _self.getName = function(title,callback,type){
        _self.getAllInfo().done(function(){
            if(!_self.exist(title,type)){
                callback&&callback(title);
            }else{
                var i = 2;
                for(;_self.exist(title+'('+i+')',type);i++){

                }
                callback&&callback(title+'('+i+')');
            }
        }).fail(function(){
            callback&&callback(title);
        });

    };

    _self.exist = function(title,type){
            if(type){
                return  (JSON.stringify(_self.allInfo).indexOf(title+'.'+type)!=-1);
            }else{
                return  (JSON.stringify(_self.allInfo).indexOf(title)!=-1);
            }
    }

    //删除
    _self.deleteInfo = function (timestamp) {
        var def = $.Deferred();
        var db = new sqlite3.Database(dbpath);
        var sql = "delete from ppticws where timestamp='" + timestamp + "'";

        db.exec(sql, function (err, rows) {
            for(var i = 0,len = _self.allInfo.length ;i<len ;i++){
                if(_self.allInfo[i].timestamp == timestamp){
                    break;
                }
            }
            _self.allInfo.splice(i,1);
            db.close();
            def.resolve(_self.allInfo);
        });
        return def.promise();
    }

    //筛选
    _self.selectInfo = function (keys, vals) {
        var def = $.Deferred();
        if(_self.allInfo.length > 0 ){
            def.resolve(selectHelper(keys, vals));
        }
        else{
            _self.getAllInfo().done(function(){
                def.resolve(selectHelper(keys, vals));
            })
        }
        return def.promise();
    }

    function selectHelper(keys, vals){
        var i, j,len,lenj,flag,list=[];
        if (keys == undefined || vals == undefined){
            return _self.allInfo;
        }
        if(keys.length && vals.length && vals.length == keys.length ){
            for(i = 0,len = _self.allInfo.length;i<len;i++){
                flag = 0;
                for(j=0,lenj=vals.length;j<lenj;j++){
                    if(_self.allInfo[i][keys[j]] != vals[j] && vals[j] != ""){
                        flag = 1;
                        break;
                    }
                }
                if(!flag){
                    list.push($.extend({},_self.allInfo[i]));
                }
            }
            return list;
        }
        return _self.allInfo;
    }

    //修改
    _self.updateInfo = function(keys,vals,timestamp){
        var def = $.Deferred();
        if(keys.length && vals.length && vals.length == keys.length ){
            var sql = "update ppticws set ";
            for(var i= 0,len = keys.length;i<len;i++){
                sql += keys[i] + "='" + vals[i] + "',"
            }
            sql = sql.replace(/,$/," where timestamp='" + timestamp + "'");
            var db = new sqlite3.Database(dbpath);
            db.exec(sql, function (err, rows) {
                //改内存中数据
                for(var i = 0 ,len = _self.allInfo.length;i<len;i++ ){
                    if(_self.allInfo[i].timestamp == timestamp){
                        for(var j = 0,lenj = keys.length;j<lenj;j++){
                            _self.allInfo[i][keys[j]] = vals[j];
                        }
                    }
                }
                db.close();
                def.resolve(_self.allInfo);
            });
        }
        else{
            def.resolve(_self.allInfo);
        }
        return def.promise();
    }

    //数据库返回结果格式化
    _self.formatDBInfo = function (dbret) {
        var i = 0, len = dbret.length;
        var anslist = [], obj;
        for (; i < len; i++) {
            obj = new KeJian.KeJianItems();
            obj.initInfo(dbret[i].type,dbret[i].fileid,dbret[i].filename,dbret[i].timestamp,dbret[i].filepath,
                dbret[i].unit1,dbret[i].unit2,dbret[i].unit3,dbret[i].unit4,dbret[i].bookcode,
            dbret[i].usedtime,dbret[i].lasttime,dbret[i].creator,dbret[i].size,dbret[i].fromIfb,dbret[i].secondType)
            ;

            anslist.push(obj);
        }
        return anslist;
    }

    _self.indexHtmlInfo = function(){
        var def  = $.Deferred();
        var db = new sqlite3.Database(dbpath);
        db.all("SELECT * FROM ppticws ORDER BY lasttime DESC LIMIT 0,5", function (err, rows) {
            db.close();
            var recent_list = [];
            if (!err) {
                for (var index in rows) {
                    var item = rows[index];
                    var ppticw = {};
                    var fileparentpath = path.join(APP_CONFIG.BASE_PATH, "ppticws", uid, item.timestamp);
                    var filepath = path.join(fileparentpath, item.filepath);
                    var thumbnail = path.join(fileparentpath, "thumbnail.jpg");
                    if (!fs.existsSync(filepath)) continue; // 文件不存在
                    if (!fs.existsSync(thumbnail)) thumbnail = 'assets/images/change_bg02.jpg';
                    if ('ppt' == item.type || 'pptx' == item.type) ppticw.ico = "assets/images/ppt_ico.png";
                    else if ('icw' == item.type) ppticw.ico = "assets/images/kejian_ico.png";
                    else continue; // type 只支持ppt和icw
                    ppticw.file = filepath;
                    ppticw.type = item.type;
                    ppticw.thumbnail = thumbnail;
                    ppticw.title = item.filename || '';
                    if (ppticw.title.length > 8) ppticw.name = ppticw.title.substr(0, 7) + "...";
                    else ppticw.name = ppticw.title;
                    ppticw.timestamp = item.timestamp;
                    recent_list.push(ppticw);
                }
            }
            def.resolve(recent_list);
        });
        return def.promise();
    }

    _self.updateTime = function(timestamp,callback) {
        _self.updateInfo(["lasttime"] , [new Date().Format("yyyy-MM-dd hh:mm:ss")] , timestamp).done(function(){
            callback && callback();
        });
    }
};

/*
* 将xml文件转换为json对象，从ifb拷过来，部分逻辑会显得有些多余
* */
KeJian.pageXmlParser=function() {
    var _self=this;
        // if arrayMap, all node of xmlDocument will be put into an array
        // if not arrayMap, all single node of xmlDocument wil be treated as property
    _self.ToJSON = function (str, arrayMap) {
        str = _self.replaceSpecialString(str);
        var xmlDoc = null;
        var domParser = new DOMParser();
        xmlDoc = domParser.parseFromString(str, 'text/xml');

        if (xmlDoc.hasChildNodes()) {
            var node = _self.ParseNode(xmlDoc, arrayMap);
            //node["X-Parse-Engine"]="MX.Util.XML";
            //node["X-JSMX-Framework"]="Version 1.2";
            node = _self._parseXmalObj(node);
            return node;
        }
        return null;
    };

    _self.ParseNode = function (xmlNode, arrayMap) {
        var node =
        {
            //"$attribute":null,
            //"$count":0,
            //"$name":xmlNode.nodeName,
            //"$type":xmlNode.nodeType,
            //"$value":""
        };
        var _node = null;
        if (xmlNode.attributes)	// because xmlNode.hasAttributes() method just work in FF
        {
            for (var i = 0, n = xmlNode.attributes.length; i < n; ++i) {
                _node = xmlNode.attributes[i];
                node[_node.nodeName] = _node.nodeValue;	// or escape(_node.nodeValue)?
            }
        }
        if (xmlNode.hasChildNodes()) {
            //if(xmlNode.firstChild.nodeType==3)
            //{
            //	node["$value"] = xmlNode.firstChild.nodeValue.replace(/\n\r*/g, "").replace(/^\s+/, "").replace(/\s+$/, "");
            //}
            var name = "";
            var p = null;
            var count = 0;
            for (var i = 0, n = xmlNode.childNodes.length; i < n; ++i) {
                _node = xmlNode.childNodes[i];
                if (_node.nodeType == 3) continue;
                name = _node.nodeName;
                p = _self.ParseNode(_node, arrayMap);
                if (node[name] == null) {
                    //node["$count"]++;
                    if (!arrayMap) {
                        count = 0;
                        for (var c = 0, m = xmlNode.childNodes.length; c < m; ++c) {
                            if (xmlNode.childNodes[c].tagName == name)count++;
                            if (count == 2) break;
                        }
                        if (count == 1) {
                            node[name] = p;
                            continue;
                        }
                    }
                    node[name] = [];
                }
                node[name].push(p);
            }
        }
        return node;
    };


    _self._parseXmalObj=function(obj) {
        var xmalObj;
        for (var attr in obj) {
            xmalObj = obj[attr];
        }
        xmalObj = _self._replaceNameSpace(xmalObj);
        return xmalObj;
    }


    _self._replaceNameSpace =function(obj){
        var newObj = {};
        for (var attr in obj) {
            if (attr == "eb:HotspotControl.Audio") {
                newObj[attr] = obj[attr];
            } else {
                var newAttr = attr.replace("eb:", "");
                newObj[newAttr] = obj[attr];
            }

            if (typeof newObj[newAttr] == "object") {
                if (newObj[newAttr] instanceof Array) {
                    var arr = new Array();
                    for (var i = 0; i < newObj[newAttr].length; i++) {
                        arr[i] = _self._replaceNameSpace(newObj[newAttr][i]);
                    }
                    newObj[newAttr] = arr;
                } else {
                    newObj[newAttr] = _self._replaceNameSpace(newObj[newAttr]);
                }

            }
        }
        return newObj;
    }

    /**
     * 对xnl中的特殊字符转义
     * @param str
     * @returns {*}
     */
    _self.replaceSpecialString=function(str) {
        if (!str) return null;
        var replaceSrc = "&<>\'\"",
            replaceDst = ["&amp;", "&lt;", "&gt;", "&apos;", "&quot;"];

        var index = false, pos;
        for (var i = 0, len = str.length; i < len; ++i) {
            if (str[i] === '"') {
                index = !index;
                //转义双引号中的双引号
                if (!index && i + 1 < len && str[i + 1] !== ' ' && str[i + 1] !== '>' && str[i + 1] != '/')
                    index = true;
                else continue;
            }
            if (index) {
                if ((pos = replaceSrc.indexOf(str[i])) != -1)
                    str = str.substr(0, i) + replaceDst[pos] + str.substr(i + 1);
            }
        }
        return str;
    }
}


