var TA_EVENT = {
    REGISTER_SUCCESS: 'register-success',
    REGISTER_FAIL: 'register-fail',
    LOGIN_SUCCESS: 'login-success',
    LOGIN_FAIL: 'login-fail',
    DOWNLOAD_START: 'download-start',
    DOWNLOAD_PROGRESS: 'download-progress',
    DOWNLOAD_BEGIN:  'download-begin',
    DOWNLOAD_SUCCESS: 'download-success',
    DOWNLOAD_CANCEL: 'download-cancel',
    DOWNLOAD_FAIL: 'download-fail',
    APP_UPZIP: 'app-upzip',
    USERCENTER: 'usercenter',
    NETWORK_STATUS_CHANGED: 'network-status-changed',
    USER_STATUS_CHANGED: 'user-status-changed',
    FEEDBACK_SUCCESS: 'feedback_success',
    PLUGIN_DELETED: 'plugin-deleted',
    DELETED_BEGIN: 'deleted-begin',
    ADDAPP_FROMCATE: 'addapp-fromcage',
    APP_EXIT: 'app-exit',
    OPEN_DETAIL :'open-detail',
    IMPORT_APP:'import-app',
    UPDATE_SHOW:'update_show',
    APP_OPEN:'app-open',
    APPBOX_LOGIN_IN:'appbox_login_in',
    APPBOX_LOGIN_OUT:'appbox_login_out',
    RECENTUSE_CHANGE: 'recentuse_change'
};

function TA_EventEmitter() {
    this.callbacks = {};
};
TA_EventEmitter.prototype.removePrefix = function (event) {
    if (event.indexOf('.') == -1)return event;
    event = event.substr(0, event.indexOf('.'));
    return event;
}
TA_EventEmitter.prototype.on = function (event, fn) {
    event = this.removePrefix(event);
    (this.callbacks[event] = this.callbacks[event] || [])
        .push(fn);
    return this;
};
TA_EventEmitter.prototype.once = function (event, fn) {
    event = this.removePrefix(event);
    var self = this;

    function on() {
        self.off(event, on);
        fn.apply(this, arguments);
    }

    this.on(event, on);
    return this;
};
TA_EventEmitter.prototype.off = function (event, fn) {
    event = this.removePrefix(event);
    var callbacks = this.callbacks[event];
    if (!callbacks) return this;

    // remove all handlers
    if (1 == arguments.length) {
        delete this.callbacks[event];
        return this;
    }

    // remove specific handler
    var i = callbacks.indexOf(fn);
    callbacks.splice(i, 1);
    return this;
};
TA_EventEmitter.prototype.emit = function (event) {
    var args = [].slice.call(arguments, 1), module, isForce;
    var spawn = require('child_process').spawn;
    var nw = APP_CONFIG.BASE_PATH + "/nw.exe";
    if (event.indexOf('.') != -1) {
        module = event.substr(event.indexOf('.') + 1);
        if (module.indexOf(".") != -1) {
            isForce = module.substr(module.indexOf('.') + 1) == "true" ? true : false;
            module = module.substr(0, module.indexOf('.'));
        }
        isForce = module == 'global' ? true : isForce;
        module = module == 'global' ? 'main' : module;
        event = this.removePrefix(event);
        if ((TA.Stage.stages[module] || isForce) && APP_CONFIG.APPLICATION_NAME != module) {
            spawn(nw, [APP_CONFIG.BASE_PATH + '/' + module, 'emit', event, args]).on("error", function (err) {
            }).on("exit", function () {
            });
        }
    }

    var callbacks = this.callbacks[event];

    if (callbacks) {
        if (event == TA_EVENT.NETWORK_STATUS_CHANGED) {
            shellcmd.log('网络切换回调::回调个数-' + callbacks.length);
        }
        for (var i = 0, len = callbacks.length; i < len; ++i) {
            callbacks[i] && (callbacks[i].apply(this, args));
        }
    }

    return this;
};

var taEmitter = new TA_EventEmitter();
var net = require('net');
function NetWorkListener() {
    var that = this;
    NetWorkListener.online = null;
    NetWorkListener.failedCnt = 0;
    NetWorkListener.hasShowFailTips = false;

    that.run();
    setInterval(function () {
        that.run();
    }, 1000);
}

NetWorkListener.prototype.run = function () {
    var that = this;
    if(!window.hproseClient){
        var gui = require("nw.gui");
        var clientName = gui.App.manifest.name;
        window.hproseClientSub(clientName,function (message) {
        });
    }
    window.hproseClient.checkNetState(function(state){
        that.emit(state);
    },function(e){
        // 这是一个hproseClient异常处理
        that.emit(false);
        console.error(e);
    });

}
NetWorkListener.prototype.emit = function (isOK) {
    if (isOK) {
        if (NetWorkListener.online !== true) {
            NetWorkListener.online = true;
            taEmitter.emit(TA_EVENT.NETWORK_STATUS_CHANGED, true);
            return;
        }
    } else {
        if (NetWorkListener.online !== false) {
            NetWorkListener.online = false;
            taEmitter.emit(TA_EVENT.NETWORK_STATUS_CHANGED, false);
            return;
        }
    }
};

new NetWorkListener();
//
NC.namespace('TA.UserService');
TA.UserService = {
    loginFile: process.env.APPDATA + '\\iflytek\\security.cr',
    key: 'wyc4yrmK',
    _list: function (val) {
        if (!val)return false;
        if (val.indexOf('=') == -1) {
            return false
        }
        var userInfo = val.split('=');
        if (userInfo.length != 2) {
            userInfo[1] = val.substr(val.indexOf('=') + 1);
        }
        return {username: userInfo[0], password: userInfo[1]};
    },
    initListener: function () {
        var fs = require("fs");
        fs.watchFile(this.loginFile, function (curr, prev) {
            if (curr.size == 0) {
                taEmitter.emit(TA_EVENT.USER_STATUS_CHANGED, false);
            }
            if (curr.mtime !== prev.mtime) {
                taEmitter.emit(TA_EVENT.USER_STATUS_CHANGED, true);
            }
        });
    },
    isAutoLogin: function () {
        try {
            return NC.Storage.getValue("login_info");
        } catch (e) {
            return false;
        }
    },
    loginOut: function () {
        //是否自动登录
        NC.Storage.setValue("login_info", '', -1);
        var path = APP_CONFIG.BASE_PATH + "/uli.dat";
        _rmdirSync(path);
        _rmdirSync(this.loginFile);
        /*shellcmd.findProcess("iFlyBook.exe").done(function (num) {
         //进程未启动
         if (num < 1) {
         _rmdirSync(this.loginFile);
         } else {
         }
         });*/
    },
    /**
     * 从本地的uli.dat拉取用户信息
     * @param callback
     */
    getLocalUserAccount: function (callback) {
        var fs = require("fs"), that = this;
        fs.readFile(this.loginFile, function (error, loginInfo) {
            if (error) {
                callback && callback(null);
                return;
            }
            try {
                loginInfo = loginInfo.toString();
                DES.init(that.key, loginInfo);
                loginInfo = decodeURIComponent(DES.Encrypt("Decrypt"));
                //loginInfo=stringToHex(des(that.key, loginInfo, 0, 0));
                loginInfo = that._list(loginInfo);

                //自动登录读取cr文件，password结尾有空字符
                loginInfo.password = loginInfo.password.replace(/\0/g,"");

                callback && callback(loginInfo.username ? loginInfo : null);
            }
            catch (e) {
                console.log(e.message);
                callback && callback(null)
            }
        });
    },
    getUserInfo: function (callback) {
        var fs = require("fs");
        var loginPath = APP_CONFIG.BASE_PATH + "/uli.dat";
        fs.readFile(loginPath, function (error, user) {
            if(error){
                console.log(error);
                callback && callback(null);
            }else{
                try {
                    user = JSON.parse(user);
                    callback && callback(user.userName ? user : null);
                }
                catch (e) {
                    console.log(e.message);
                    callback && callback(null);
                }
            }
        });
    },
    setUserInfo: function (content, callback) {
        var path = APP_CONFIG.BASE_PATH + "/uli.dat";
        shellcmd.handleFile(path, content, {type: 'write', success: callback});
    },
    setLoginInfo: function (content, callback) {
        //如果是对象
        if (Object.prototype.toString.call(content) === '[object Object]') {
            content = content.username + '=' + content.password;
        } else {
            try {
                //如果是字符串，则已JSon序列化
                content = JSON.parse(content);
                content = content.username + '=' + content.password;
            } catch (e) {
                //如果已是拼接好的字符串
            }
        }
        DES.init(this.key, content);
        var val = DES.Encrypt();
        shellcmd.handleFile(this.loginFile, val, {type: 'write', success: callback});
    }
}
//TA.UserService.initListener();