﻿/**
 * 公共函数，包括文件读写等
 * Date: 2014/03/18
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module shellcmd
 */

var fs = window.require("fs");
var gui = window.require('nw.gui');
var win = gui.Window.get();
var cp = window.require("child_process");
var path = window.require("path");
var exec =cp.exec;
var shellcmd = {};

shellcmd.findProcess = function (exeName) {
    var def = $.Deferred();
    callClient('syscmd', 'findprocess', exeName, 0, function (num) {
        //console.log("! " + num);
        def.resolve(num);
    });
    return def.promise();
}
/**
 * 打开程序
 */
shellcmd.shellExecute = function (filePath) {
    var def = jQuery.Deferred();
    //adon.shellExecute(filePath);
    callClient('syscmd', 'simpleshellexecute', filePath, 1, function (startResult) {
        def.resolve(startResult > 33);
    });
    return def.promise();
}
/**
 * 读文件，同步
 * @param filePath
 * @returns {string}
 */
shellcmd.readFile = function (filePath) {
    if (!filePath)
        throw new Error("error arguement");
    try {
        return fs.readFileSync(filePath, encoding = 'utf8');
    } catch (err) {
        console.error(err.message);
        return "";
    }
}
/**
 * 写文件，同步
 * @param {!string} content 可选，如果为空则认为是写入空字符串
 * @param {!string} filePath 文件路径
 */
shellcmd.writeFile = function (filePath, content) {
    var path=require('path');
    var mkdirp=require('../node_modules/mkdirp');
    if (!filePath)
        throw new Error("error arguement");
    var ct = content || "";
    try {
        mkdirp.sync(path.dirname(filePath));
        fs.writeFileSync(filePath, ct);
    } catch (err) {
        console.error(err);
    }

}
/**
 * 拷贝文件
 * @param {!string} content 可选，如果为空则认为是写入空字符串
 * @param {!string} filePath 文件路径
 */
shellcmd.copyFile = function (src, des) {
    var defer = jQuery.Deferred();
    src = src.replace(/\\/g,"/");
    des = des.replace(/\\/g,"/");
    var fileReadStream = fs.createReadStream(src);
    var fileWriteStream = fs.createWriteStream(des);
    fileReadStream.pipe(fileWriteStream);
    fileWriteStream.on('error', function () {
        console.log('copy failed');
        defer.resolve(false);
    });
    fileWriteStream.on('close', function () {
        console.log('copy over');
        defer.resolve(true);
    });
    return defer.promise();
}
/**
 * 打开对话框
 * @param {object=}  opt_params  可选参数  eg: {accept: ".doc,.ppt"}
 */
shellcmd.openFileDialog = function (opt_params) {
    var defer = jQuery.Deferred();
    var fileDialog = jQuery('<input style="display:none;"  type="file"/>');

//    var fileDialog = jQuery('<input style="display:none;"  type="file" multiple/>');
//    if(arguments[1]&&arguments[1]==="save")  fileDialog = jQuery('<input style="display:none;"  type="file" />');
    //动态创建，不用依赖于界面
    if (fileDialog.length) {
        if (opt_params) {
            for (var attr in opt_params)
                fileDialog.attr(attr, opt_params[attr]);
        }
        fileDialog.one('change', function () {
            defer.resolve(fileDialog.val());
        });
        fileDialog.trigger('click');
        if (opt_params) {
            for (var attr in opt_params)
                fileDialog.removeAttr(attr);
        }
    }
    return defer.promise();
}
/**
 * 保存对话框
 * @param opt_params
 * @returns {*}
 */
shellcmd.saveFileDialog = function (opt_params) {
    opt_params = opt_params || {};
    if (!opt_params.nwsaveas)
        opt_params.nwsaveas = "";
    var defer = jQuery.Deferred();
    this.openFileDialog(opt_params,"save").done(function (ret) {
        console.log("save file: " + ret);
        defer.resolve(ret);
    });
    return defer.promise();
}
/**
 * 写入注册表
 * @param regPath {string} 要写入的注册表项路径，例如"HKEY_LOCAL_MACHINE\\SOFTWARE\\iflytek\\LPD /v installPath"
 * @param regValue {string} 写入的值，例如"E:\Project\EPD_EP1.0\Trunk\Development\Source\Client"
 */
shellcmd.writeREG = function (regPath, regValue) {
    regValue = regValue.replace(/ /g, "\" \"");
    var expression = "REG ADD " + regPath + " /t reg_sz /d " + regValue + " /f";
    cp.exec(expression, function (error, stdout, stderr) {
        if (error != null) {
            console.error('exec error:' + error);
        }
    });
}

/**
 * 检测是否联网
 * @return {string} "true"表示联网，"false"表示未联网
 */
shellcmd.checkOnLine = function () {
    var def = jQuery.Deferred();
    var exec = cp.exec, child;
	try{
		child = exec('ping -n 1 -w 200 book.changyan.com', {
            timeout: 0,
            maxBuffer: 200*1024,
            killSignal: 'SIGTERM'
        },function (error, stdout, stderr) {
            //shellcmd.log('网络判断::'+JSON.stringify(error))
			if (error !== null) {
				def.resolve(false);
			}
			else {
				def.resolve(true);
			}
		});
	}catch(ex){
		def.reject();
	}
    return def.promise();
}
/**
 * 操作本地文件
 * @param path
 * @param callback
 */
shellcmd.handleFile = function (path, content, callback) {
    'use strict'
    callback=callback||{};
    var success = callback.success;
    var fail = callback.fail;
    var type = callback.type;
    //写文件
    if (type == "write") {
            shellcmd.writeFile(path, content || '');
            success && success();
        //读文件
    } else {
        fs.exists(path, function (exist) {
            // 不存在
            if (exist) {
                var result = shellcmd.readFile(path);
                success && success(result);
            } else {
                fail && fail();
            }
        });
    }
}
shellcmd.log = function (msg) {
//    var fs = require("fs");
//    var path = require('path');
//    var indexPaths = path.resolve('../../').replace(/\\/g, '/');
    fs.appendFile(APP_CONFIG.BASE_PATH + "/log.txt", '\r\n ------' + new Date() + ':' + msg, function () {
    });
}



shellcmd.DOS_makeDir = function(path){
    var def = $.Deferred();
    exec('md  '+ '"'+path+'"' , function(err,out) {
        console.log(out); err && console.log(err);
        def.resolve();
    });
    return def.promise();
};

//同步版makeDir
shellcmd.makedirSync = function(path){
    fs.mkdirSync(path);
};

//文件夹或者文件是否存在
shellcmd.fileOrDirExist = function(path){
    var def = $.Deferred();
    fs.exists(path,function(exist){
        def.resolve(exist);
    });
    return def.promise();
}

shellcmd.minApp = function(){
    win.minimize();
}

shellcmd.closeApp = function(){
    win.close(true);
}

/**
 * 创建文件夹
 * @param dirpath
 * @param mode
 * @param callback
 */
shellcmd.mkdirs = function(dirpath, mode, callback) {
    fs.exists(dirpath, function(exists) {
        if(exists) {
            callback(dirpath);
        } else {
            //尝试创建父目录，然后再创建当前目录
            shellcmd.mkdirs(path.dirname(dirpath), mode, function(){
                fs.mkdir(dirpath, mode, callback);
            });
        }
    });
};

/**
 * @param srcPath  源文件夹路径 （注意： 路径格式必须为***\***\****）
 * @param zipPath  压缩文件路径 （注意： 路径格式必须为***\***\****）
 */
shellcmd.zip_addon = function(srcPath , zipPath ){
    var defer = $.Deferred();
    srcPath = srcPath.replace(/\//g,"\\");
    zipPath = zipPath.replace(/\//g,"\\");
    zipUtil.updateZipFile(srcPath , zipPath ,function(e){
        defer.resolve();
    });
    return defer.promise();
};

shellcmd.unzip_addon = function(srcPath , zipPath ){
    var defer = $.Deferred();
    zipUtil.unZipFile(srcPath , zipPath ,function(e){
        defer.resolve();
    });
    return defer.promise();
};

/**
 *
 * @param fileName 要删除的文件名 ， （注意： 文件名格式按照***\***\***）
 */
shellcmd.deleteFile = function(fileName){
    var defer = $.Deferred();
    fileName = fileName.replace(/\//g,"\\");
    exec('del  '+ '"'+fileName+'"' , function(err,out) {
        console.log(out); err && console.log(err);
        defer.resolve();
    });
    return defer.promise();
};

/**
 *
 * @param dir 要删除的目录 ， （注意： 目录格式按照***\***\***）
 */
shellcmd.deleteDir = function(dir){
    var defer = $.Deferred();
    dir = dir.replace(/\//g,"\\");
    exec('rd /s /q ' + '"' + dir + '"' , function(err,out){
        console.log(out); err && console.log(err);
        defer.resolve();
    });
    return defer.promise();
};

shellcmd.getPicSize = function(path) {
    var def = $.Deferred();
    var img = new Image();
    img.src = path;
    img.onload = function(){
        def.resolve(img.width + '|' + img.height);
    };
    return def.promise();
};

/**
 *
 * @param srcDir 源目录地址 目录格式为： *****\***\***
 * @param desDir 目的地址  目录格式为： *****\***\***
 * @returns {*}
 *
 */

shellcmd.copyDir = function(srcDir , desDir) {
    var def = $.Deferred();
    srcDir = srcDir.replace(/\//g,"\\");
    desDir = desDir.replace(/\//g,"\\");
    shellcmd.fileOrDirExist(srcDir).done(function(ret){
        if (!ret) {
            def.resolve();
        }
        else {
            exec('copy  ' + '"' + srcDir + '"  ' + '"' + desDir + '"' , function(err,out){
                console.log(out); err && console.log(err);
                def.resolve();
            });
        }
        return def.promise();
    });
    return def.promise();
};

shellcmd.rename = function(oldPath,newPath){
    var def = $.Deferred();

    fs.rename(oldPath, newPath, function(ret){
        def.resolve();
    });
    return def.promise();
}


shellcmd.openFileDialog_NW = function(opt_params, multi, onlyFolder) {
    var defer = jQuery.Deferred();
    var fileDialog = null;
    if (multi) {
        fileDialog = jQuery('<input style="display:none;"  type="file" multiple />');
    } else if (onlyFolder) {
        fileDialog = jQuery('<input style="display:none;"  type="file" nwdirectory/>');
    }
    else {
        fileDialog = jQuery('<input style="display:none;"  type="file"/>');
    }

    //动态创建，不用依赖于界面
    if (fileDialog.length) {
        if (opt_params) {
            for (var attr in opt_params)
                fileDialog.attr(attr, opt_params[attr]);
        }
        fileDialog.one('change', function () {
            defer.resolve(fileDialog.val());
        });
        fileDialog.trigger('click');
        if (opt_params) {
            for (var attr in opt_params)
                fileDialog.removeAttr(attr);
        }
    }
    return defer.promise();
};

shellcmd.readReg = function(regPath){
    var def = $.Deferred();
    String.prototype.each=function(i,fun){
        var index=0;
        var that=this;
        while(index<=that.length){
            (fun||function(){})(that.substr(index,i));
            index+=i;
        }
    }
    regPath = regPath.replace(/\//g,"\\");
    var regcmd = 'reg query ' + '"' +regPath + '"'+ ' /ve';
    var exec = require("child_process").exec;
    var iconv=require('iconv-lite');
    var cmdHandler = exec(regcmd, {
        encoding:'HEX',
        timeout: 0,
        maxBuffer: 200 * 1024,
        killSignal: 'SIGTERM'
    }, function (error ,stdout ,stderr) {
        if (error) {
            console.log('error registerWrite');
        }
        var arr=[];
        stdout.each(2,function(data){
            arr.push(parseInt(data,16));
        });
        stdout  = iconv.decode(new Buffer(arr), 'GBK');
        var exePath = stdout.split("REG_SZ");
        exePath = exePath[exePath.length -1];
        exePath = exePath.replace(/(^[\s\000]*)|([\s\000]*$)/g , "");
        def.resolve(exePath);

    });
    return def.promise();
}

shellcmd.playOrEditPPT = function(filePath , isPlay){
    var exec = require("child_process").exec;
    var PPTregPath = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\powerpnt.exe";
    shellcmd.readReg(PPTregPath).done(function(exePath){
        var cmd;
        if (fs.existsSync(exePath)) cmd = '"' + exePath + (isPlay == true ? '" /s "' : '" "')  +filePath + '"';
        else cmd = '"' + filePath + '"';
        cmd = cmd.replace(/\//g,"\\");
        cmd = cmd.replace(/\s\\s\s/ , ' /s ');
        exec(cmd);
    });
}
/**
 *
 * @param filePath
 * @param option 目前支持三种状态 'play' 'edit' 'new'
 */
shellcmd.playOrEditICW = function (filePath, option,coursewareData,newExtraData,callback) {
//    pageMyPrepare.showCommonTip('暂不支持ICW课件的预览和编辑，开发中，敬请期待',false);
//    return;
    var userInfo = pageMyPrepare.userInfo;
    if(!userInfo){
        //如果用户没有登录的话
        userInfo = {};
        userInfo.loginName = 'defaultuser';
    }
    var appInfoPath = APP_CONFIG.BASE_PATH+'/user/'+userInfo.loginName+'/appmanage.dat';
    fs.readFile(appInfoPath,{encoding:'utf-8'},function(err,data){
        if(!err){
            data = JSON.parse(data);
            if(data[63]){
                //TODO:这是一个老的放映和编辑方式，后面要改,见注释
                var cmd;
                if (option == 'play') {
                    var ziputil = require("ziputil/AddonZip");
					//var icwPath = filePath.replace(/\\/g,'/');
					//icwPath = icwPath.substr(0,icwPath.lastIndexOf('/'))+'/temp';
					var icwPath = APP_CONFIG.BASE_PATH + "/plugins/63/bin/main/tmp/" + shellcmd._getRandomString(10);
                    fs.mkdir(icwPath, function () {
                        ziputil.unZipFile(filePath, icwPath, function () {
                            var nwPath = APP_CONFIG.BASE_PATH + "/plugins/63/bin/nw.exe";
                            var playerPath = APP_CONFIG.BASE_PATH + "/plugins/63/bin/main/player";
                            cmd = '"' + nwPath + '" "' + playerPath + '" "false" "'+ icwPath +'" "true" "true"';
                            exec(cmd,function(){
                                callback ? callback() : "";
                            });
                        });
                    });
                } else {
                    var icwExePath = APP_CONFIG.BASE_PATH+'/plugins/63/iFlySlide.exe';
                    var jsonString = {};
                    //jsonString.loginName = userInfo.loginName;
                    jsonString.userId = userInfo.id;
                    jsonString.userName = userInfo.userName;
                    jsonString.schoolName = userInfo.userExt?userInfo.userExt.schoolName:userInfo.schoolName;
                    var curBookIndex = pageMyPrepare.curBookIndex;
                    var bookInfoDetail= pageMyPrepare.books[curBookIndex];
                    jsonString.saveToPath = filePath;
                    if(coursewareData){
                        jsonString.unit1 = (coursewareData.unit1 =="")?null:coursewareData.unit1;
                        jsonString.unit2 = (coursewareData.unit2 =="")?null:coursewareData.unit2;
                        jsonString.unit3 = (coursewareData.unit3 =="")?null:coursewareData.unit3;
                        jsonString.unit4 = (coursewareData.unit4 =="")?null:coursewareData.unit4;
                        jsonString.unitName = (coursewareData.name == "")?null:coursewareData.name;
                        for(var k in pageMyPrepare.books){
                            if(pageMyPrepare.books[k].bookCode==coursewareData.bookCode){
                                bookInfoDetail = pageMyPrepare.books[k];
                                break;
                            }
                        }
                    }else{
                        var bookInfo = pageMyPrepare.curBookMetaInfo;
                        jsonString.unit1 = (bookInfo.Unit1 =="")?null:bookInfo.Unit1;
                        jsonString.unit2 = (bookInfo.Unit2 =="")?null:bookInfo.Unit2;
                        jsonString.unit3 = (bookInfo.Unit3 =="")?null:bookInfo.Unit3;
                        jsonString.unit4 = (bookInfo.Unit4 =="")?null:bookInfo.Unit4;
                        jsonString.unitName = (bookInfo.Name == "")?null:bookInfo.Name;
                    }
                    if(newExtraData) jsonString.newExtraData = encodeURIComponent(JSON.stringify(newExtraData));

                    jsonString.className = bookInfoDetail.title;
                    jsonString.subject = bookInfoDetail.subject;
                    jsonString.grade = bookInfoDetail.grade;
                    jsonString.volumn = bookInfoDetail.volumn;
                    jsonString.bookCode = bookInfoDetail.bookCode;
                    //这里的token是为了课件制作工具使用 加在这里真是醉了  大家见谅  目前木有还的处理办法 谁让产品需求这么多耦合
                    DES.init(APP_CONFIG.DESKEY,userInfo.loginName + "=" +userInfo.password);
                    var token = DES.Encrypt();
                    jsonString.token = token;
                    jsonString.createClassURL = APP_CONFIG.YUN_CREATE_CLASS + '&token=' + token;
                    var jsonfile = APP_CONFIG.BASE_PATH +  '/plugins/63/prepareLesson.json';
                    shellcmd.writeFile(jsonfile, JSON.stringify(jsonString));

                    if (option == 'new') {
                        var nwPath = APP_CONFIG.BASE_PATH + "/plugins/63/bin/nw.exe";
                        var homePath = APP_CONFIG.BASE_PATH + "/plugins/63/bin/main/homepage";
                        cmd = '"' + nwPath + '" "' + homePath+'" "false" "'+filePath+'" "true" "false"';
                        exec(cmd,function(){
                            callback ? callback() : "";
                        });
                    } else {
                        //editor
						var nwPath = APP_CONFIG.BASE_PATH + "/plugins/63/bin/nw.exe";
                        var editorPath = APP_CONFIG.BASE_PATH + "/plugins/63/bin/main/editor";
						cmd = '"' + nwPath + '" "' + editorPath + '" "'  + 'false' + '" "' + filePath + '" "true" "false"';
                        exec(cmd, function(){
                            callback ? callback() : "";
                        });
                    }
                }
            }else{
                 if(APPManager.onlineFlag==1){
                     pageMyPrepare.showCommonTip('您当前未安装课件制作工具，无法编辑课件，请先下载后编辑',false,'去下载',function(){
                         if(APPManager.onlineFlag){
                             pageClassTeach.openDetail(63);
                         }else{
                             dNetworkPanel.show()
                         }
                     });

                 }else{
                     pageMyPrepare.showCommonTip('您当前未联网，请联网后下载课件制作工具',false);
                 }
            }
        }
    });
}

/**
 * created by linwang5@iflytek.com
 * 删除文件夹,文件夹内可包括有其他文件 异步
 * @param path 文件夹路径
 * @param success 回调 可选参数
 */
shellcmd._rmdirASync = function (path, success, error) {
    var tempLength;
    var thisFunction = arguments.callee;
    var path = path;
    if (fs.existsSync(path)) {
       var files = fs.readdirSync(path);
        tempLength = files.length;
        if (tempLength == 0) {
            try{
            fs.rmdirSync(path);
            success && success(path);
            }catch(e) {
                error && error(e);
            }
            return;
        }
        files.forEach(function (file) {
            var curPath = path + "/" + file;
            fs.stat(curPath, function (err, stats) {
                if (!err && stats.isDirectory()) {
                    thisFunction(curPath, function () {
                        console.log(files.length);
                        tempLength--;
                        if (tempLength == 0) {
                            try{
                            fs.rmdirSync(path);
                            success && success(path);
                            }catch(e) {
                                error && error(e);
                            }
                        }

                    });
                } else {
                    fs.unlink(curPath, function (e) {
                        if(e){
                            error && error(e);
                        } else {
                        tempLength--;
                        if (tempLength == 0) {
                                try {
                            fs.rmdirSync(path);
                            success && success(path);
                                } catch (e) {
                                    error && error(e);
                                }
                            }
                        }
                    });
                }
            });

        });

    } else {
        success && success(path);
    }
}
/**
 * 生成随机长度的字符串
 * @param len 生成的长度 可选 未传则生成32的
 * @private
 */
shellcmd._getRandomString = function(len){
    var len = len||32;
    var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
    var maxPos = $chars.length;
    var pwd = '';
    for (var i = 0; i < len; i++) {
        pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
    }
    return pwd.toLowerCase();
}

/*********************** add by chengyang *************************************/
/**
 * 环境检查
 * @returns {boolean}
 */
shellcmd.checkEnvironment = function() {
    var defer = $.Deferred();
    callClient('syscmd', 'getsn', '', 0, function (ret) {
        defer.resolve(ret != null);
    });
    return defer.promise();
};

shellcmd.checkRunningDiskSpace = function() {
    var def = $.Deferred();
    callClient('syscmd', 'getdiskfreespace', '', 0, function (freeSpace) {
        var temp = parseInt(freeSpace);
        def.resolve(temp);
    });
    return def.promise();
};

shellcmd.postHttpRequest = function(msg) {
    var defer = $.Deferred();
    msg["client_version"] = APP_CONFIG.VERSION;
    msg["product"] = APP_CONFIG.IFB_NAME;
    var param = {type: "POST", url: msg.url, data: msg};
        if (msg.timeout) {
            param.timeout = msg.timeout;
        }
        if (msg.dataType) {
            param.dataType = msg.dataType;
        }
    $.ajax({
        type: "POST",
        url: msg.url,
        data: $.param(msg),
        timeout: msg.timeout || 5000,
        success:function(data){
            defer.resolve(data);
        },
        error:function(){
            console.log("http post ajax failed");
            defer.resolve("");  //不能返回"failed",，因为调用这个方法的程序是基于""做异常处理的
        }
    });

    return defer.promise();
};


shellcmd.desEncrpty = function(content, key) {
    var defer = $.Deferred();
    var argsJson = '{"content":"' + content + '","key":"' + key + '"}';
    callClient('syscmd', 'desencode', argsJson, 0, function (ret) {
        defer.resolve(ret);
    });
    return defer.promise();
};



shellcmd.getFirstItemAsyn = function(dbPath, sql) {
    var defer = $.Deferred();
    callClient("syscmd", "connectdb", dbPath, 0, function (ret) {
        if (ret == 1) {
            callClient("syscmd", "opensqlandgetfirst", sql, 0, function (ret) {
                defer.resolve(ret);
            });
        } else {
            defer.resolve();
        }
    });
    return defer.promise();
};

/**
 * 写数据库
 * @param sql
 * @returns {boolean}
 */
shellcmd.executeDbAsyn = function(dbPath, sql) {
    var defer = $.Deferred();
    callClient("syscmd", "connectdb", dbPath, 0, function (ret) {
        if (ret == 1) {
            callClient("syscmd", "execsql", sql, 0, function (ret2) {
                defer.resolve(ret2 === 'true');
            });
        } else {
            defer.resolve(false);
        }
    });
    return defer.promise();
};


/**
 * 获取硬件号
 * @returns {string}
 */
shellcmd.getHardwareInfo = function(userAccount) {
    var defer = $.Deferred();
    callClient('syscmd', 'getsn', '', 0, function (ret) {
        var md5encode = hex_md5(ret + userAccount);
        defer.resolve(md5encode);
    });
    return defer.promise();
}

/**
 * 获取硬件类型
 * @returns {string}  0:计算机，1：平板
 */
shellcmd.getHardwareType = function() {
    var defer = $.Deferred();
    callClient('syscmd', 'checkhardware', '', 0, function (ret) {
        defer.resolve(ret);
    });
    return defer.promise();
}

/**
 * 获取硬件名称
 * @returns {string}
 */
shellcmd.getHardwareName = function() {
    var defer = $.Deferred();
    callClient('syscmd', 'getcomptname', '', 0, function (ret) {
        defer.resolve(ret);
    });
    return defer.promise();
}

/**
 * 保存文件 (同步方法!!!)
 * @param {string} content 文件文本类容
 * @param {string} filePath 文件路径
 */
shellcmd.saveFile = function(content, filePath) {
    var mkdirp=require('../node_modules/mkdirp');
    if (!filePath)
        throw new Error("error arguement");
    var ct = content || "";
    try {
        mkdirp.sync(path.dirname(filePath));
        fs.writeFileSync(filePath, ct);
    } catch (err) {
        console.error(err);
    }
}

shellcmd.shellexecutewithargs = function(srcpath, args1, args2) {
    var defer = $.Deferred();
    args2 = args2 == undefined ? "" : args2;
    console.log("args2:" + args2);
    if (args2 == "") {
        callClient('syscmd', 'shellexecutewithargs', trimPosix(srcpath) + "|" + args1, 0, function (ret) {
            defer.resolve(ret);
        });
    }
    else {
        callClient('syscmd', 'shellexecutewithargs', trimPosix(srcpath) + "|" + args1 + "|" + args2, 0, function (ret) {
            defer.resolve(ret);
        });
    }

    function trimPosix(path) {
        return path.replace(/\bfile:(\/+)/g, "");
    }

    return defer.promise();
};


shellcmd.isDirExist = function(dir) {
    var defer = $.Deferred();
    defer.resolve(fs.existsSync(dir));
    return defer.promise();
};

function createDir(dir, tryTimes) {
    var defer = $.Deferred();
    if (typeof tryTimes == "number") {
        console.log(tryTimes);
        if (tryTimes > 10) {
            defer.resolve(false);
            return defer.promise();
        }
    }
    callClient('syscmd', 'createdir', dir, 0, function (ret) {
        if (ret === "false" && typeof tryTimes == "number") createDir(dir, tryTimes + 1);
        else defer.resolve(ret === 'true');
    });
    return defer.promise();
}
shellcmd.createDir = createDir;

shellcmd.checkU = function (isU, name) {
    var def = $.Deferred();
    GetUpanList().done(function (list) {
        var i = 0, len = list.length;
        for (i = 0; i < len; i++) {
            if (isU == hex_md5(list[i][2] + name)) {
                def.resolve(list[i][0]);
            }
        }
        def.resolve("");
    });
    return def.promise();
}

function GetUpanList() {
    var def = $.Deferred();
    GetUpanInfo().done(function (ret) {
        var ans = ret.split("|");
        var len = ans.length, i = 0;
        for (i = 0; i < len; i++) {
            ans[i] = ans[i].split(":");
        }
        def.resolve(ans);
    });
    return def.promise();
}

function GetUpanInfo() {
    var def = $.Deferred();
    callClient('syscmd', 'getupaninfo', '', 0, function (ret) {
        def.resolve(ret);
    });
    return def.promise();
}

/**
 * 解密
 * @param content
 * @param key
 * @returns {*|string}
 */
shellcmd.desDecrpty = function(content, key) {
    var des = $.Deferred();
    var argsJson = '{"content":"' + content + '","key":"' + key + '"}';
    callClient('syscmd', 'desdecode', argsJson, 0, function (ret) {
        des.resolve(ret);
    });
    return des.promise();
}


shellcmd.checkLocalAuthorization = function(msg) {
    var defer = $.Deferred();
    callClient('syscmd', 'checkauthor', msg, 0, function (ret) {
        defer.resolve(ret);
    });
    return defer.promise();
};

/**
 * 读取书本许可证
 * @param msg
 */
shellcmd.getBookLicNode  = function(msg) {
    var des = $.Deferred();
    callClient('syscmd', 'getresliccontent', msg, 0, function (ret) {
        console.log('getresliccontent: ' + ret);
        des.resolve(ret);
    });
    return des.promise();
};

/**
 * 读取文件类容异步
 * @param {string} filePath  文件路径
 * @return {string}
 */
shellcmd.readFileAsync = function(filePath) {
    var def = $.Deferred();

    if (!filePath) throw new Error("error arguement");

    callClient('syscmd', 'readfile', filePath, 0, function (ret) {
        def.resolve(ret);
    });
    return def.promise();
};


/**
 * 判断文件是否存在
 * @param {string} filePath 文件路径
 * @returns {boolean}
 */
shellcmd.isFileExist = function(filePath) {
    var defer = $.Deferred();
    if (!filePath) return defer.resolve(false);

    fs.exists(filePath, function (exists) {
        defer.resolve(exists);
    });
    return defer.promise();
};

/**
 * 获取书本lic
 * @param url
 * @param bookId
 * @param userAccount
 * @param hdInfo
 * @param hdType
 * @returns {*}
 */
shellcmd.getBookLic = function(url, bookId, userAccount, hdInfo, hdType, savePath) {
    var defer = $.Deferred();
    var msgJson = {
        url: url,
        account: userAccount,
        resid: bookId,
        hardware: hdInfo,
        hdtype: hdType,
        savepath: savePath,
        version: APP_CONFIG.VERSION,
        product: APP_CONFIG.IFB_NAME
    };
    var msg = JSON.stringify(msgJson);
    callClient('syscmd', 'getbooklic', msg, 0, function (ret) {
        defer.resolve(ret);
    });
    return defer.promise();
}
/**
 * created by linwang5@iflytek.com 2016-10-25 11:37
 * @param content
 */
shellcmd.trayTips = function (content) {
    var json = {
        to: "all",
        action: "tray_tips",
        from: "ta",
        data: {
            title:" ",
            content: escape(content)
        }
    };
    socket&&socket.send(json);
};

shellcmd.appSetAlwaysTop = function (tepExe, tempPid, tempTitle) {
    var title = (tempTitle && tempTitle != '') ? tempTitle : null;
    if (!title) return;
    var pid = tempPid || 0;
    var exe = tepExe || '';
    exe = exe.split('/')[exe.split('/').length - 1];
    exe = (exe == '') ? null : exe.replace('.exe', '');
    var reiv = APP_CONFIG.BASE_PATH + '/reiv.exe ';
    var cmdLine = 'topmost|' + exe + '|' + pid + '|' + title;
    console.log(reiv + cmdLine);
    spawn(reiv, [cmdLine], {detached: true}).on('exit',function () {
        console.log(reiv + ' exit');
    }).on('error', function (err) {
            console.log(reiv + ' ' + err);
        });

}
