/**
 * websocket通讯模块，提供程序间通讯功能
 * Date: 2014/06/6
 * Author: luxing@iflytek.com
 * @version 1.0
 */
/**
 * @constructor
 */
var WebSocketMgr = {};

/**
 * 初始化
 */
WebSocketMgr.init = function() {
	WebSocketMgr.server = null;
	//初始化websocket
	if (!window.WebSocket) {
		console.error("This browser does not support WebSocket!");
		return;
	}
	//这里需要读取iFly_MsgCenter/port.dat，拿到json字符串
	var socketConf = shellcmd.readFile(APP_CONFIG.iFlyBook_PATH + '/Client/iflybook/bin/iFly_MsgCenter/port.dat');
	var portStr = socketConf ;
//    || '{"port":"32467"}'
	var portObj = JSON.parse(portStr);
	var port = portObj.port;
	var wsServer = "ws://localhost:" + port + "/ws";
	var ws = new WebSocket(wsServer);
	ws.onopen = function(e) {
		console.log("Connected to WebSocket server.");
	};
	ws.onclose = function(e) {
		console.log("Disconnected");
	};
	ws.onmessage = function(e) {
		console.log("RECEIVED: " + e.data);
		var msgStr = e.data;
		msg = JSON.parse(msgStr);
		if (msg.src === "iflybook" && msg.dst === "TPlatform" && msg.req === "maximize") {
			//这里要实现TPlatform的最大化和前置
			var gui = window.require('nw.gui');
			var win = gui.Window.get();
			win.show();
			//window.focus();
			//window.resizeTo(926,681);
			//win.maximize();
			win.setAlwaysOnTop(true);
			setTimeout(function() {
				win.setAlwaysOnTop(false);
			}, 100);
		}
	}
	ws.onerror = function(e) {
		console.log('Error occured: ' + e.data, e);
	};
	WebSocketMgr.server = ws;
	return ws;
};

/*
 返回已经初始化之后的server
 */
WebSocketMgr.getWebSocketServer = function() {
	return WebSocketMgr.server;
}