/***
 * 添加FLASH对本地的安全gotoLoginUrl权限，否则评测卡片无法使用
 * Author: jhwang
 * Date: 2014/7/17
 * @type {trust}
 *
 * @update:
 * yuwang 2014/08/21 修改trust方法，可动态传入需要设置的host。修复中文路径下策略文件重复写入的Bug。
 * yuwang 2015/03/11 修复路径中包含中文，trust文件写入后无法生效的问题
 */

module.exports = trust

var fs = require('fs');
var path = require('path');
var iconv = require('iconv-lite');

/**
 * Flash信任文件编码
 * @type {string}
 * @const
 */
var TRUST_FILE_ENCODING = 'gb2312';

/**
 * 同步创建文件夹
 * @param dirName
 */
function mkdirSync(dirName) {
    if (dirName.match(/\b[a-zA-Z]:\.$/)) {       //这是windows盘符
        return;
    }
    try {
        fs.mkdirSync(dirName);
    } catch (e) {
        if (e.code != 'EEXIST') console.log(e);
    }
}

/**
 * 同步创建带父目录文件夹
 * @param dirpath
 */
function mkdirpSync(dirpath) {
    var parts = dirpath.split(path.sep);
    for (var i = 1; i <= parts.length; i++) {
        mkdirSync(path.join.apply(null, parts.slice(0, i)));
    }
}

/**
 * 拷贝安全策略配置文件
 * @param host 域名
 */
function copySettings(host) {
    var appdata = process.env.APPDATA;
    var sysDir = appdata + '\\Macromedia\\Flash Player\\macromedia.com\\support\\flashplayer\\sys\\#' + host;
    mkdirpSync(sysDir);
    var targetFile = sysDir + '\\settings.sol';
    var sourceFile = __dirname + '\\' + host +'\\settings.sol';

    fs.exists(sourceFile, function(exists){
        if(exists){
            console.info('%ccopy settings file from:%s, to:%s','background:yellow', sourceFile, targetFile);
            fs.writeFileSync(targetFile, fs.readFileSync(sourceFile));
        }   else{
            console.error('can not find flash trust settings file:%s', sourceFile);
        }
    });
}

/**
 * 写flash信任位置文件
 */
function writeTrustFile() {
    try {
        var rootPath = path.resolve('../');
        console.info("writeTrustFile, rootPath:" + rootPath);
        var diskRoot = rootPath.match(/\w:\\/ig)[0]; // 找到当前软件所在磁盘根路径
        console.info("writeTrustFile, diskRoot:" + diskRoot);
        var str = '\r\n' + diskRoot;
        // windows这个文件是ansi编码的
        var buf = iconv.encode(str, TRUST_FILE_ENCODING);
        var appdata = process.env.APPDATA;

        var trustDir = appdata + '\\Macromedia\\Flash Player\\#Security\\FlashPlayerTrust';
        mkdirpSync(trustDir);
        var trustCfg = trustDir + '\\trust.cfg';

        console.log(trustCfg);

        fs.exists(trustCfg, function (exists) {
            if (exists) {
                var trustStr = iconv.decode(fs.readFileSync(trustCfg), TRUST_FILE_ENCODING);
                var trustLocArr = trustStr.split('\r\n');
                console.log('%cflash trust location: %o', 'background:yellow;', trustLocArr);
                for (var i = 0, len = trustLocArr.length; i < len; i++) {
                    // 已经添加过信任则返回
                    if (trustLocArr[i] == diskRoot) {
                        return;
                    }
                }

                fs.appendFile(trustCfg, buf, null);
            } else {
                fs.appendFile(trustCfg, buf, function (err) {
                    if (err) console.error(err);
                });
            }
        });
    } catch (e) {
        console.error('writeTrustFile exception, %o', e);
    }
}

/**
 * 设置host默认信任
 * @param {...string} hosts host列表
 */
function trust(hosts) {

    writeTrustFile();
    copySettings("local");
    for (var index = 0, len = arguments.length; index < len; index++) {
        copySettings(arguments[index]);
    }
}
