/**
 * Created by linwang5 on 2014/11/27.
 */

//NC.namespace('NoticeManager');

var fs = require('fs');
var NoticeManager={
    that:this,
    noticeStart:function(){
        //绑定关闭或确定按钮
        $(document).on("click", ".noticeClose", function () {
            win.close();
        });
         NoticeManager.getLocalInfo(function(err,version,time){
             if(err){
                 console.log("Get local information of notice error!!");
                 win.close();
                 return ;
             }
             var updateUrl;
             if(!version||!time){
                  updateUrl=APP_CONFIG.NOTICE_UPDATE;
             }else{
                 updateUrl=APP_CONFIG.NOTICE_UPDATE+"&version="+version+"&time="+time;
             }

             $.ajax({//从服务拉取公告信息
                 url: updateUrl,
                 type: "POST",
                 timeout: 10000, //设置超时
                 dataType: "json",
                 success: function ($notice) {
                     if(!$notice.isShow){
                         win.close();
                         return;
                     }
                    //TODO:请求成功处理 显示并保存本地
                     NoticeManager.showNotice($notice.app_notice_info);
                     $("#updateNotice h2").html($notice.app_notice_title);
                     var oriNum = $('#updateNotice').css('height').replace('px','');
                     NoticeManager.saveLocalInfo($notice.version,$notice.time);
                     win.height = parseInt(oriNum);
                     win.show();
                     win.setAlwaysOnTop(true);

                 },
                 error: function (er) {
                     console.log("请求错误:"+er);
                     win.close();
                 }
             });

         });
    },
    getLocalInfo:function(callback){
        try {
            var updateLog = JSON.parse(fs.readFileSync(DAT_CONFIG.UPDATE_AD));
            if(updateLog){
                callback&&callback(null,updateLog.version,updateLog.time)
            }else{
                callback&&callback("fail",null,null);
            }
        } catch (e) {
            console.error(e.message);
            callback&&callback("fail",null,null);
        }
    },
    saveLocalInfo:function(vsersion,time){
         var updateLog={
             "version":vsersion,
             "time":time
         }
        fs.writeFileSync(DAT_CONFIG.UPDATE_AD, JSON.stringify(updateLog));
    },
    showNotice:function(noticeInfo){
         console.log(noticeInfo);
        $("#updateNotice").show();
        $("#updateNotice p").html(noticeInfo);
    }
};