/**
 * 目录处理调整逻辑
 */

define(function (require, exports) {

    var shellcmd = require("../common/shellcmd.js").shellcmd;
    var menuView = require("./menuview").MenuInstance;

    function Menu() {
        var _self = this,
            _baseJsonInfo = {
                IndexInfo: {
                    ID: "",
                    Code: "",
                    TchId: "",
                    Title: AppTips.DefaultBookName,
                    Subject: "17",
                    Grade: "13",
                    Volumn: "04",
                    Publisher: "25"
                },
                FilePath: "",
                DoubleLanguage: "false",
                PageImageSize: {
                    Width: "1110",
                    Height: "1570"
                },
                Menu: [
                    {
                        code: "01",
                        indexStart: 1,
                        name: AppTips.DefaultUnit1Name,
                        pageStart: "1",
                        pages: [
                        ]
                    }
                ],
                pages: [
                ]
            };

        _self.addPage = function (num) {
            console.log(num);
            var pageMenuItem = newPageMenuItemIfo(num, "", "", "", "", "丁香花", "", "", "");
            _baseJsonInfo.pages.push(pageMenuItem);
            //TODO: 这里要完善
            _baseJsonInfo.Menu[0].pages.push(newNativePages(num,num,num));
            menuView.showMenu(_baseJsonInfo.pages);
        }



        //加载已存在的目录
        _self.loadMenuInfo = function () {
            _self.setJsonInfo();
        }

        _self.setJsonInfo = function (obj) {
            _baseJsonInfo = obj;
        }

        //存储为json文件
        _self.saveMenu = function (jsonPath) {
            var str = JSON.stringify(_baseJsonInfo);
            console.log(jsonPath);
            shellcmd.writeFile(jsonPath, str);
        }

        _self.getAllPagesNum = function () {
            return _baseJsonInfo.pages.length;
        }

        function newPageMenuItemIfo(index, unit1, unit2, unit3, unit4, unit1Name, unit2Name, unit3Name, unit4Name) {
            return {
                pageCode: "", /*实体书页码*/
                pageIndex: index, /*电子书页码*/
                unit1: unit1, /*第一级目录code*/
                unit2: unit2, /*第二级目录code*/
                unit3: unit3, /*第三级目录code*/
                unit4: unit4, /*第四级目录code*/
                unit1Name: unit1Name,
                unit2Name: unit2Name,
                unit3Name: unit3Name,
                unit4Name: unit4Name
            }
        }

        function newNativePages(code,index,name){
            return  {
                code: code,
                index: index,
                name: name
            };
        }


    }

    exports.MenuInstance = new Menu();
});
