define(function (require, exports) {

    var shellcmd = require("../common/shellcmd.js").shellcmd,
        pageXmlParser = require('../common/pagexmlparser').Instance;
    var RecHots = require("./rechots.js").RecHots;

    function Page() {

        var _self = this;
        var _BGPath = "";
        var _hotsPath = "";
        var _Hots = {};

        _self.init = function (num, bookName) {
            var def = $.Deferred();
            _BGPath = Config.ebookBasePath + "/" + bookName + "/" + num + "/" + num + ".jpg";

            _hotsPath = Config.ebookBasePath + "/" + bookName + "/" + num + "/" + num + ".xaml";

            shellcmd.fileOrDirExist(_hotsPath).done(function (exist) {
                if (exist) {
                    _Hots = xaml2Hots(shellcmd.readFile(_hotsPath));
                }
                else {
                    _Hots = {
                        "xmlns:eb" : "EBookLib",
                        "absolutelayout": {

                        },
                        "background" : num + ".jpg",
                        "hotspot" : {
                            Rectangle : []
                        }
                    }
                    var xamlContext = hots2Xaml();

                    shellcmd.writeFile(_hotsPath, xamlContext);
                }
                def.resolve();
            });

            return def.promise();
        }

        _self.getBG = function () {
            return _BGPath;
        }

        _self.getHots = function () {
            return _Hots;
        }

        //保存页面热区信息
        _self.save = function(){
            var xamlContext = hots2Xaml();
            shellcmd.writeFile(_hotsPath, xamlContext);
        }

        _self.saveOneHots = function(x,y,w,h){
            var _hots = new RecHots(x,y,w,h);
            _Hots.hotspot.Rectangle.push(_hots);
        }

        //热区信息序列化
        function hots2Xaml() {
            var src = '<eb:page background="1.jpg"  xmlns:eb="EBookLib">\n<eb:hotspot>';
            var xamltpl = '<Rectangle Width="{{w}}" Height="{{h}}" Canvas.Left="{{l}}" Canvas.Top="{{t}}"' +
                ' eb:HotspotControl.Audio="{{a}}" Panel.ZIndex="0"></Rectangle>';
            var len, i,hotsitem;
            if (_Hots.hotspot.Rectangle.length>0) {

                for(i=0,len=_Hots.hotspot.Rectangle.length;i<len;i++){
                    hotsitem = _Hots.hotspot.Rectangle[i];
                    src += xamltpl.replace("{{w}}",hotsitem["Width"])
                        .replace("{{h}}",hotsitem["Height"])
                        .replace("{{l}}",hotsitem["Canvas.Left"])
                        .replace("{{t}}",hotsitem["Canvas.Top"])
                        .replace("{{a}}",hotsitem["eb:HotspotControl.Audio"]);
                }
            }
            src += '</eb:hotspot>\n<eb:absolutelayout>\n</eb:absolutelayout>\n</eb:page>';
            return src;
        }

        //TODO:从序列化信息生成热区信息
        function xaml2Hots(srcXaml) {
            if (isString(srcXaml)) {
                if (srcXaml.length > 0) {
                    var obj2 = pageXmlParser.ToJSON(srcXaml);
                    console.log(obj2);
                    return obj2;
                }
            }
            return srcXaml;
        }

    }

    exports.Page = Page;
});

