/**
 * 环境配置写在这里
 */
window.nodereq = window.require;

process.on('uncaughtException', function (err) {
    var fs = nodereq("fs");
    var path = nodereq('path');
    var filePath = path.resolve('../../').replace(/\\/g, '/');
    fs.appendFile(filePath + "/plugins/62/bin/bookmaker/logs/errorNative.txt", '\r\n ------err:' + err.stack, function () {
    });
});

window.addEventListener('error', function (errEvent) {
    var fs = nodereq("fs");
    var path = nodereq('path');
    var indexPaths = path.resolve('../../').replace(/\\/g, '/');
    fs.appendFile(indexPaths + "/plugins/62/bin/bookmaker/logs/error.txt", '\r\n ------' + errEvent.filename + ':' + errEvent.message + '\r\n' + errEvent.error.stack, function () {
    });
});

var gui = nodereq("nw.gui");
var fs = nodereq("fs");
var WIN = gui.Window.get();
var path = nodereq('path');

var Config = {};

var displayPath = process.env.APPDATA.replace(/\\/g,"/")+'/iflytek/solution.json';
var display = {};
try{
    display = JSON.parse(fs.readFileSync(displayPath,'utf-8'));
}catch (e){
    display = {};
}
Config.Width = display.width || window.screen.availWidth;
Config.Height = display.height || window.screen.availHeight;

WIN.moveTo(window.screen.availLeft,window.screen.availTop);
// WIN.resizeTo(Config.Width, Config.Height);

var nwexePath = process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/");
Config.nwexePath = nwexePath + '/';
Config.binPath = 'file:///'+ nwexePath + '/plugins/62/bin/bookmaker/';
Config.binPathNoFile = Config.binPath.substring(8);

Config.ebookBasePath = Config.binPathNoFile + "temp/";
Config.logsPath = Config.binPathNoFile + "logs/";

var jsonPath  = nwexePath + '/plugins/62/bin/bookmaker/package.json';
var json = nodereq(jsonPath);
json.debug && WIN.showDevTools();

// 页面加载之后再显示，避免出现打开后的白页
window.onload = function(){
    WIN.show();
}

//全局提示样式
function Alert(tips){
    window.alert(tips);
}

function isString(object) {
    if (!object)
        return false;
    return object.constructor === String;
}

//Js时间格式化
Date.prototype.Format = function (fmt) {
    var o = {
        "M+": this.getMonth() + 1,                 //月份
        "d+": this.getDate(),                    //日
        "h+": this.getHours(),                   //小时
        "m+": this.getMinutes(),                 //分
        "s+": this.getSeconds(),                 //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds()             //毫秒
    };
    if (/(y+)/.test(fmt))
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt))
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
}

