/**
 * 这里处理主要的交互操作。
 * 逻辑操作单独封装成模块处理。
 */
define(function (require, exports) {

    var newWork = require("works/newwork.js").NewWorkInstance,
        undoWork = require("./works/undowork.js").UndoWorkInstance,
        zoomWork = require("./works/zoom.js").ZoomInstance,
        saveWork = require("./works/savework.js").SaveWorkInstance,
        openWork = require("./works/openwork.js").OpenWorkInstance,
        releaseWork = require("./works/releasework.js").ReleaseWorkInstance,
        addPageWork = require("./works/addpage.js").AddPageInstance,
        changeCoverWork = require("./works/changecover.js").ChangeCoverInstance,
        gotoPageWork = require("./works/gotopage.js").GotoPageInstance,
        addOneHotsWork = require("./works/addonehots.js").AddOneHotsInstance,
        addHotsWork = require("./works/addhots.js").AddHotsInstance;
    var shellcmd = require("./common/shellcmd.js").shellcmd;

    $(function () {

        $("#newWork").click(function () {
            newWork.do();
        });

        $("#openWork").click(function () {
            openWork.do();
        });

        $("#saveWork").click(function () {
            saveWork.do();
        });

        $("#undoWork").click(function () {
            undoWork.undoWork();
        });

        $("#zoom").click(function () {
            zoomWork.do();
        });

        $("#addPage").click(function () {
            addPageWork.do();
        });

        $("#addHotpots").click(function () {
            addHotsWork.do();
        });

        $("#preView").click(function () {
            Alert("暂未实现！");
        })

        $("#Release").click(function () {
            releaseWork.do();
        })

        $("#Hints").click(function () {
            Alert("暂未实现!");
        });

        $("#addCover").click(function () {
            changeCoverWork.do();
        });

        $("#bookView").click(function(){
            addPageWork.do();
        });

        //TODO : 关闭处理 （关闭前保存）
        $("#Close").click(function(){
            Alert(AppTips.SureToLeave);
            shellcmd.closeApp();
        });

        $("#Min").click(function(){
            shellcmd.minApp();
        });

        //左侧目录操作
        $("#leftPart").mousedown(function (e) {
            var etarget = $(e.target);
            if (e.which == 1) {
                //单击在pageitem上，进行页面跳转
                if(etarget.attr("class") == "meitem"){
                    gotoPageWork.do(etarget.attr("pageindex"));
                }
            }
            else if (e.which == 2) {
             // TODO : 中键事件处理
            }
            else if (e.which == 3) {
             //右击弹出菜单
            }
        });

        //组合键（快捷操作）
        $("body").keydown(function (e) {
            if (e.ctrlKey) {
                switch (e.which) {
                    case 78:
                        //N
                        newWork.do();
                        break;
                    case 79:
                        openWork.do();
                        //O
                        break;
                    case 83:
                        //S
                        saveWork.do();
                        break;
                    case 90:
                        //Z
                        undoWork.undoWork();
                        break;
                    default:
                }
            }
        });

        //下面这一坨都是给绘制热区用的，后面考虑重构
        var _isPaint = false, _x,_y;
        var $paintCanvas = $("#paintCanvas");
        var paintCanvasCtx = $paintCanvas[0].getContext("2d");
        paintCanvasCtx.strokeStyle = "blue";
        paintCanvasCtx.lineWidth = 1;
        $paintCanvas
            .mousedown(function(e){
                _isPaint = true;
                _x = e.offsetX;
                _y = e.offsetY;
                paintCanvasCtx.lineJoin = "miter";
                paintCanvasCtx.beginPath();
            })
            .mousemove(function(e){
                if(_isPaint){
                    paintCanvasCtx.clearRect(0, 0, 1024, 600);
                    paintCanvasCtx.strokeRect(_x, _y, e.offsetX - _x, e.offsetY - _y);
                }
            })
            .mouseup(function(e){
               if(_isPaint){
                   addOneHotsWork.do(_x, _y, e.offsetX - _x, e.offsetY - _y);
               }
                _isPaint = false;
                $paintCanvas.hide();
            });



        newWork.createWork();
    });

});

