/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-1
 * Time: 上午9:42
 * To change this template use File | Settings | File Templates.
 */
/******************************************************************
 *
 * 2014-07-14 这个模块暂时废弃，请保留，以便后来参考
 *
 * Caution : mouseMove 的时候鼠标状态显示
 * 有些时候鼠标在按住左键不松的情况下移动，
 * 鼠标指针会莫名其妙消失不见。
 * 这个问题没有修复，因为它90%的情况下是正常的。
 * 不清楚具体原因。
 *
 * 这个模块主要处理黑板上的一些显示逻辑
 * 与显示无关的定义和数组请查看 blackboardhelper.js
 *                       ------- by  yczhu
 *
 * 补充：
 * 当canvas结构如下时：
 * <div>
 *     this is some test text.
 *     <canvas />
 * </div>
 * 会出现上述问题，原因是在于鼠标按下时，去试图选中“this is some test text”文本
 * 不过此时鼠标是变成“I”形状。
 * 解决方案可以是在css中指定禁止用户选中。
 *                             -------  by  yczhu  2014年11月25日09:40:45
 ***********************************************************************/
;
define(function (require, exports) {
    var shellcmd = require('../../common/shellcmd');
    var CardWrapper = require('../card/cardwrapper').Instance;
    var ebookContext = require('../ebookcontext').Instance;
    var pyUtil = require('pyutil').Instance;
    var blackboardHelper = require("./blackboardhelper.js").instance;

    function BlackBoard() {
        var _self = this;
        /*缓存DOM*/
        _self.DOM = null;

        /**
         * 缓存合成信息
         * 笔迹识别之后的字词缓存起来，之后的合成，评测都不再调用
         * TODO：优化：每次合成评测的结果也可以同样缓存起来，再次打开时都不再调用，在退出时清空
         */
        _self.conInfo = blackboardHelper.initConInfo();

        _self.curBlackNum = 1;

        var _isPainting = false;
        var _isEvalControlVisible = false;
        var _isStrokeOrderControlVisible = false;
        var _strokeOrderPageIndex = 0;
        var _strokeOrderPageNum = 0;
        var _curTextType = blackboardHelper.TextType.Chinese;
        var _lastSelected = null;

        /**
         * 设置画笔颜色
         */
        function _setColor(color) {
            if (_self.DOM.strokeContext) {
                _self.DOM.strokeContext.strokeStyle = color;
                _self.DOM.strokeContext.fillStyle = color;
                _lastSelected.penColorValue = color;
            }
        }

        /**
         * 设置画笔、板擦粗细
         * @param {String} tool 给哪个工具设置大小：pen/eraser
         * @param {Number} size 大小
         */
        function _setSize(tool, size) {
            if (_self.DOM.strokeContext) {
                _self.DOM.strokeContext.lineWidth = size;
                if (tool === blackboardHelper.ToolType.Pen) {
                    _lastSelected.penSizeValue = size;
                } else if (tool === blackboardHelper.ToolType.Eraser) {
                    _lastSelected.eraserTypeValue = size;
                }
            }
        }

        /**
         * 切换工具状态
         * 切换时还原之前的状态  * 颜色 粗细 类型 鼠标 * 粗细 类型 鼠标
         */
        function _changeToMode(toolType) {
            _self.DOM.toolBarChildren.children(".tool_current").attr("class", "tool_normal");
            _hideBlackBoardPopControls();
            _createCanvas();
            if (toolType === blackboardHelper.ToolType.Pen) {
                //先设置curtool，后面的bindCommands会用到
                _lastSelected.curToolType = blackboardHelper.ToolType.Pen;
                //设置工具栏画笔选中状态
                _self.DOM.toolBarChildren.children(".tool_current").attr("class", "tool_normal");
                _self.DOM.penCtrl.show();
                _self.DOM.eraserCtrl.hide();
                _self.DOM.penBtn.attr("class", "tool_current");
                _lastSelected.penColorEle.attr("class", "current");
                _lastSelected.penSizeEle.attr("class", "current");
                _setSize(blackboardHelper.ToolType.Pen, _lastSelected.penSizeValue);
                _setColor(_lastSelected.penColorValue);
                _setCursor(blackboardHelper.cursor.penCursor);
            } else if (toolType === blackboardHelper.ToolType.Eraser) {
                _lastSelected.curToolType = blackboardHelper.ToolType.Eraser;
                //设置工具栏板擦选中状态
                _self.DOM.toolBar.children().children(".tool_current").attr("class", "tool_normal");
                _self.DOM.penCtrl.hide();
                _self.DOM.eraserCtrl.show();
                _self.DOM.eraserBtn.attr("class", "tool_current");
                _setCursor(_lastSelected.eraserCursor);
                _setSize(blackboardHelper.ToolType.Eraser, _lastSelected.eraserTypeValue);
            }
            _bindCommands();
        }

        /**
         * 创建绘图canvas
         */
        function _createCanvas() {
            if (!_self.DOM.strokeCanvas) {
                _self.DOM.strokeCanvas = $("<canvas>").attr("id", 'board_canvas')
                    .css({
                        "position": "absolute",
                        "left": "11px",
                        "top": "11px"
                    });
                _self.DOM.canvasContainer.append(_self.DOM.strokeCanvas);
                _self.DOM.strokeCanvas.attr("width", _self.DOM.canvasContainer.width() + 8)
                    .attr("height", _self.DOM.canvasContainer.height() + 8);
                _self.DOM.strokeContext = _self.DOM.strokeCanvas[0].getContext("2d");
                _self.DOM.strokeContext.lineJoin = 'round';
                _self.DOM.strokeContext.lineCap = 'round';
            } else {
                _self.DOM.strokeCanvas.show();
            }
        }

        /**
         * 设置鼠标样式
         */
        function _setCursor(cursor) {
            _self.DOM.strokeCanvas && _self.DOM.strokeCanvas.css("cursor", cursor);
        }

        /**
         * 区域擦除时，显示上层的tempCanvas
         * 这个canvas是为了显示不停地擦除重绘的矩形擦除框
         */
        function _showTempCanvas() {
            if (!_self.DOM.tempCanvas) {
                _self.DOM.tempCanvas = $("<canvas>").attr("id", 'boardTemp_canvas')
                    .css({
                        "position": "absolute",
                        "left": "11px",
                        "top": "11px"
                    });
                _self.DOM.tempCanvas.attr("width", _self.DOM.canvasContainer.width() + 8)
                    .attr("height", _self.DOM.canvasContainer.height() + 8);
                _self.DOM.canvasContainer.append(_self.DOM.tempCanvas);
                _self.DOM.tempContext = _self.DOM.tempCanvas[0].getContext("2d");
            } else {
                _self.DOM.tempCanvas.show();
            }
            _self.DOM.tempCanvas.unbind().css("cursor", blackboardHelper.cursor.areaEraCursor);
            _self.DOM.tempContext.strokeStyle = "blue";
            _self.DOM.tempContext.lineWidth = 1;
            //绑定事件
            var startX, startY;
            var endX, endY;
            _self.DOM.tempCanvas.mousedown(function (evt) {
                _hideBlackBoardPopControls();
                startX = evt.offsetX;
                startY = evt.offsetY;
                _self.DOM.tempContext.beginPath();
                _isPainting = true;
            })
                .mousemove(function (evt) {
                    endX = evt.offsetX;
                    endY = evt.offsetY;
                    if (_isPainting) {
                        _self.DOM.tempContext.clearRect(0, 0, _self.DOM.tempCanvas.width(), _self.DOM.tempCanvas.height());
                        _self.DOM.tempContext.strokeRect(startX, startY, endX - startX, endY - startY);
                        _self.DOM.tempContext.stroke();
                        _self.DOM.tempContext.closePath();
                    }
                })
                .mouseup(function () {
                    if (_isPainting) {
                        var clearAreaWidth = endX - startX;
                        var clearAreaHeight = endY - startY;
                        _self.DOM.strokeContext.clearRect(startX, startY, clearAreaWidth, clearAreaHeight);
                        //清除匹配的点迹
                        _self.conInfo.clearAreaPoints = blackboardHelper.computeClearAreaPoints({x: startX, y: startY}, {width: clearAreaWidth, height: clearAreaHeight});
                        _self.conInfo.strokes = blackboardHelper.replaceClearedPoints( _self.conInfo.clearAreaPoints,_self.conInfo.strokes);
                        _self.conInfo.strokes = blackboardHelper.removeFirstJoint(_self.conInfo.strokes);
                        _self.conInfo.strokes = blackboardHelper.removeSerialJoints(_self.conInfo.strokes);
                        //清空擦除区域
                        _self.DOM.clearAreaPoints = [];
                        _self.DOM.tempContext.clearRect(0, 0, _self.DOM.tempCanvas.width(), _self.DOM.tempCanvas.height());
                    }
                    _isPainting = false;
                });
            _self.DOM.tempCanvas.mouseout(function () {
                _self.DOM.tempCanvas.mouseup();
            });
        }

        /**
         * 隐藏合成、评测、笔顺库弹出框
         */
        function _hideBlackBoardPopControls() {
            _self.DOM.strokeAndDic.hide();
            _isStrokeOrderControlVisible = false;
            _self.DOM.evalControl.hide();
            _isEvalControlVisible = false;
        }

        /**
         * 生成识别文字显示区域
         */
        function _createTextToScreenDiv() {
            if (!_self.DOM.textToScreenDiv) {
                _self.DOM.textToScreenDiv = $("<div class='text_box'>").attr("id", 'textToScreenDiv')
                    .css({
                        "position": "absolute",
                        "left": "11px",
                        "top": "11px",
                        "display": "none"
                    });
                _self.DOM.textToScreenDiv.css("width", _self.DOM.canvasContainer.width() + 8)
                    .css("height", _self.DOM.canvasContainer.height() + 8);
                _self.DOM.textToScreenArea = $("<div>");
                _self.DOM.textToScreenDiv.append(_self.DOM.textToScreenArea);
                _self.DOM.canvasContainer.append(_self.DOM.textToScreenDiv);
            }
        }

        /**
         * 给黑板文字显示区域添加文字/拼音/单词
         */
        function _insertContentToTextArea(language, textType) {
            var def = $.Deferred();
            var innerHeight = _self.DOM.canvasContainer.height() + 8;
            var innerWidth = _self.DOM.canvasContainer.width() + 8;
            var lineNum = 0;
            var speecher = "wangru";

            var pySize = 30;
            if (textType === blackboardHelper.TextType.English) {
                _strokesToWords(language).done(function (wordStr) {
                    if (!wordStr) {
                        def.resolve(false);
                        return def.promise();
                    }
                    lineNum = parseInt(_self.conInfo.toStrokeResultWords.length / (parseInt(innerWidth / 200))) + 1;
                    _self.DOM.textToScreenArea.empty().attr("class", "wzsp9")
                        .css('font-family', 'Arial,serif')
                        .css("paddingLeft", 0)
                        .append(_self.conInfo.toStrokeResultWordStr)
                        .css("paddingTop", (innerHeight - 100 * lineNum) / 2 > 0 ? (innerHeight - 100 * lineNum) / 2 : 10);
                    _self.DOM.textToScreenDiv.show();
                    def.resolve(true);
                    return def.promise();
                });
            }
            else if (textType === blackboardHelper.TextType.Chinese) {
                _strokesToWords(language).done(function (wordStr) {
                    if (!wordStr) {
                        def.resolve(false);
                        return def.promise();
                    }
                    lineNum = parseInt(_self.conInfo.toStrokeResultWords.length / (parseInt(innerWidth / 100))) + 1;
                    _self.DOM.textToScreenArea.empty().attr("class", "wz_box9").css('font-family', '"楷体","华文楷体"');
                    var innerUl = $("<ul></ul>");
                    for (var j = 0; j < _self.conInfo.toStrokeResultWords.length; j++) {
                        var py = "py";
                        var word = _self.conInfo.toStrokeResultWords[j];
                        var innerLi = $("<li></li>");
                        var pyStrPra = $("<p class='py' style='color: rgba(255,255,255,0);font-family:Arial;font-size:" + pySize + "px'>" + py + "</p>");
                        var wordStrPra = $("<p>" + word + "</p>");

                        innerLi.append(pyStrPra).append(wordStrPra);
                        innerUl.append(innerLi);
                    }
                    var paddingLeft = (innerWidth - 80 * _self.conInfo.toStrokeResultWords.length) / 2 > 0 ? (innerWidth - 80 * _self.conInfo.toStrokeResultWords.length) / 2 : 10;
                    var paddingTop = (innerHeight - (80 + pySize) * lineNum) / 2 - 20 > 0 ? (innerHeight - (80 + pySize) * lineNum) / 2 - 20 : 10;
                    _self.DOM.textToScreenArea.append(innerUl).css("paddingLeft", paddingLeft).css("paddingTop", paddingTop);
                    _self.DOM.textToScreenDiv.show();
                    def.resolve(true);
                });
            }
            else if (textType === blackboardHelper.TextType.PinYin) {
                lineNum = parseInt(_self.conInfo.toStrokeResultWords.length / (parseInt(innerWidth / 100))) + 1;
                shellcmd.initTTS().done(function (initResult) {
                    if (!initResult) {
                        blackboardHelper.showTips(AppBlackBoardTipsList.InitTTSFailed);
                        return;
                    }
                    //先整个句子都合成，得到每个字的拼音
                    blackboardHelper.textToSpeech([_self.conInfo.toStrokeResultWordStr], speecher).done(function (result) {
                        if (result) {
                            var everyPyArr = result.everyPyArr;
                            var lis = _self.DOM.textToScreenArea.children().children();
                            for (var j = 0; j < _self.conInfo.toStrokeResultWords.length; j++) {
                                var py = pyUtil.convertToPy(everyPyArr[j]);
                                var innerLi = lis[j];
                                var pyStrPra = $(innerLi).children(".py");
                                pyStrPra.empty().append(py).css("color", "rgba(255,255,255,1)");
                            }
                            var paddingLeft = (innerWidth - 80 * _self.conInfo.toStrokeResultWords.length) / 2 > 0 ? (innerWidth - 80 * _self.conInfo.toStrokeResultWords.length) / 2 : 10;
                            var paddingTop = (innerHeight - (80 + pySize) * lineNum) / 2 - 20 > 0 ? (innerHeight - (80 + pySize) * lineNum) / 2 - 20 : 10;

                            _self.DOM.textToScreenArea.css("paddingLeft", paddingLeft).css("paddingTop", paddingTop);
                        }
                        hideLoading();
                    });
                    _self.DOM.textToScreenDiv.show();
                    def.resolve(true);
                });
            }
            return def.promise();
        }

        function _strokesToWords(lan) {
            var def = $.Deferred();
            blackboardHelper.strokes2Words(lan, _self.conInfo.strokes).done(function (wordStr) {
                if (wordStr) {
                    //拆成单个字放在数组里,后面可以给笔顺库使用
                    _self.conInfo.toStrokeResultWords = [];
                    if (lan === blackboardHelper.LanguageType.Chinese) {
                        for (var i = 0; i < wordStr.length; i++) {
                            _self.conInfo.toStrokeResultWords.push(wordStr[i]);
                        }
                    }
                    else if (lan === blackboardHelper.LanguageType.English) {
                        wordStr = wordStr.replace(/\//g, "").replace(/\n/g, " ");
                        wordStr = wordStr.replace(/  /g, " ");
                        var tempStr = wordStr.replace(/\,/g, "")
                            .replace(/\./g, "")
                            .replace(/\?/g, "")
                            .replace(/\!/g, "")
                            .replace(/\:/g, "")
                            .replace(/\;/g, "")
                            .replace(/\-/g, "");
                        _self.conInfo.toStrokeResultWords = tempStr.split(" ");
                    }
                    //把识别出来的字符串保存下来，后面合成前不用再识别了
                    _self.conInfo.toStrokeResultWordStr = wordStr;
                }
                else {
                    blackboardHelper.showTips(AppBlackBoardTipsList.StrokeToWordsFailed);
                }
                def.resolve(wordStr);
            });
            return def.promise();
        }

        /**
         * 绑定绘制笔迹的事件
         */
        function _bindCommands() {
            //先给canvas解绑事件，避免重复绑定
            _self.DOM.strokeCanvas.unbind();

            var startPoint = {x: 0, y: 0};
            var endPoint = {x: 0, y: 0};
            _self.DOM.strokeCanvas.mousedown(function (evt) {
                _hideBlackBoardPopControls();
                var startX = evt.offsetX;
                var startY = evt.offsetY;
                _self.DOM.strokeContext.beginPath();
                if (_lastSelected.curToolType === blackboardHelper.ToolType.Pen) {
                    //在仅仅点击鼠标时，需要画出一个点，如果不加上这0.01个像素，则画不出来
                    startPoint.x = startX + 4;
                    startPoint.y = startY + 4;
                    endPoint.x = startX + 4 + 0.01;
                    endPoint.y = startY + 4 + 0.01;
                    _self.conInfo.strokes.push([startPoint.x, startPoint.y]);
                    _self.DOM.strokeContext.moveTo(startPoint.x, startPoint.y);
                    _self.DOM.strokeContext.lineTo(endPoint.x, endPoint.y);
                    _self.DOM.strokeContext.stroke();
                } else if (_lastSelected.curToolType === blackboardHelper.ToolType.Eraser) {
                    startPoint.x = startX;
                    startPoint.y = startY;
                    _self.DOM.strokeContext.clearRect(startPoint.x, startPoint.y, _lastSelected.eraserTypeValue, _lastSelected.eraserTypeValue);
                    _self.conInfo.clearAreaPoints = blackboardHelper.computeClearAreaPoints(startPoint, {width: _lastSelected.eraserTypeValue, height: _lastSelected.eraserTypeValue});
                    _self.conInfo.strokes = blackboardHelper.replaceClearedPoints( _self.conInfo.clearAreaPoints,_self.conInfo.strokes);
                }
                _isPainting = true;
            })
                .mousemove(function (evt) {
                    if (_isPainting) {
                        if (_lastSelected.curToolType === blackboardHelper.ToolType.Pen) {
                            endPoint.x = evt.offsetX + 4;
                            endPoint.y = evt.offsetY + 4;
                            _self.DOM.strokeContext.lineTo(endPoint.x, endPoint.y);
                            _self.DOM.strokeContext.stroke();
                            _self.conInfo.strokes.push([endPoint.x, endPoint.y]);
                        } else if (_lastSelected.curToolType === blackboardHelper.ToolType.Eraser) {
                            endPoint.x = evt.offsetX;
                            endPoint.y = evt.offsetY;
                            _self.DOM.strokeContext.clearRect(endPoint.x, endPoint.y, _lastSelected.eraserTypeValue, _lastSelected.eraserTypeValue);
                            _self.conInfo.clearAreaPoints = blackboardHelper.computeClearAreaPoints(endPoint, {width: _lastSelected.eraserTypeValue, height: _lastSelected.eraserTypeValue});
                            _self.conInfo.strokes = blackboardHelper.replaceClearedPoints( _self.conInfo.clearAreaPoints,_self.conInfo.strokes);
                            _self.conInfo.strokes = blackboardHelper.removeSerialJoints(blackboardHelper.removeFirstJoint(_self.conInfo.strokes));
                        }
                    }
                })
                .mouseup(function () {
                    _isPainting = false;
                    if (_lastSelected.curToolType === blackboardHelper.ToolType.Pen) {
                        _self.conInfo.strokes.push([-1, -1]);
                    }
                    if (_lastSelected.curToolType === blackboardHelper.ToolType.Eraser) {
                        _self.conInfo.clearAreaPoints = [];
                    }
                    _self.conInfo.strokes = blackboardHelper.removeSerialJoints(blackboardHelper.removeFirstJoint(_self.conInfo.strokes));
                });
            _self.DOM.strokeCanvas.mouseout(function () {
                _self.DOM.strokeCanvas.mouseup();
            });
        }

        /**
         * 黑板初始化
         */
        _self.init = function () {
			 _self.DOM = blackboardHelper.getDOM();
             _lastSelected = {
                 curToolType: blackboardHelper.ToolType.Pen,
                 penColorEle: $(_self.DOM.penColorEles[6]),
                 penColorValue: "white",
                 penSizeEle: $(_self.DOM.penSizeEles[1]),
                 penSizeValue: 4,
                 eraserTypeEle: $(_self.DOM.eraserTypeEles[1]),
                 eraserTypeValue: blackboardHelper.EraserSize.Normal,
                 eraserCursor: blackboardHelper.cursor.midEraCursor
             };
            _bindClickEventsToMainUI();
            var _w = $(window).width() - 30;
            $('#board_top').css("width", _w);
            $('#board_bot').css("width", _w);
            _self.DOM.canvasContainer.css("height", $(window).height() - 86).css("width", _w);
            _self.hideBlackBoard();
            _self.DOM.tempCanvas && _self.DOM.tempCanvas.hide();
            _changeToMode(blackboardHelper.ToolType.Pen);
        }

        /**
         * 给页面元素绑定点击事件
         */
        function _bindClickEventsToMainUI() {
            //画笔
            _self.DOM.penBtn.click(function () {
                _changeToMode(blackboardHelper.ToolType.Pen);
                _self.DOM.tempCanvas && _self.DOM.tempCanvas.hide();
            });

            //绑定画笔颜色点击事件
            _self.DOM.penColorEles.click(function () {
                _self.DOM.penColorEles.attr("class", "normal");
                var herethis = $(this);
                herethis.attr("class", "current");
                _setColor(herethis.attr('color'));
                _lastSelected.penColorEle = herethis;
                _lastSelected.penColorValue = herethis.attr('color');
            });

            //绑定画笔粗细
            _self.DOM.penSizeEles.click(function () {
                _self.DOM.penColorEles.attr("class", "normal");
                var herethis = $(this);
                herethis.attr("class", "current");
                _setSize(blackboardHelper.ToolType.Pen, herethis.attr("size"));
                _lastSelected.penSizeEle = herethis;
                _lastSelected.penSizeValue = herethis.attr("size");
            });

            //板擦
            _self.DOM.eraserBtn.click(function () {
                _changeToMode(blackboardHelper.ToolType.Eraser);
                _self.DOM.eraserCtrl.children().children(".party_current").attr("class", "party_normal");
                _lastSelected.eraserTypeEle.attr("class", "party_current");
                if (_lastSelected.eraserTypeEle.attr("id") === "btnBlackBoardAreaEraser") {
                    _self.DOM.tempCanvas.show();
                }
            });

            //小点擦除
            _self.DOM.minEraBtn.click(function () {
                eraserHelper(blackboardHelper.EraserSize.Small, $(this), blackboardHelper.cursor.minEraCursor);
            });

            //中点擦除
            _self.DOM.midEraBtn.click(function () {
                eraserHelper(blackboardHelper.EraserSize.Normal, $(this), blackboardHelper.cursor.midEraCursor);
            });

            //大点擦除
            _self.DOM.bigEraBtn.click(function () {
                eraserHelper(blackboardHelper.EraserSize.Big, $(this), blackboardHelper.cursor.bigEraCursor);
            });

            //清空笔迹
            _self.DOM.clearBtn.click(function () {
                _hideBlackBoardPopControls();
                _self.DOM.strokeContext.clearRect(0, 0, _self.DOM.strokeCanvas.width(), _self.DOM.strokeCanvas.height());
                _self.conInfo.strokes = [];
            });

            //区域擦除
            _self.DOM.areaEraBtn.click(function () {
                _hideBlackBoardPopControls();
                _self.DOM.eraserCtrl.children().children(".party_current").attr("class", "party_normal");
                var herethis = $(this);
                herethis.attr("class", "party_current");
                _lastSelected.eraserTypeEle = herethis;
                _lastSelected.eraserType = blackboardHelper.ToolType.AreaEraser;
                _showTempCanvas();
            });

            //返回课本
            _self.DOM.hideBtn.click(function () {
                _self.hideBlackBoard();
            });

            //中文识别
            _self.DOM.chineseBtn.click(function () {
                languageHelper(blackboardHelper.TextType.Chinese, blackboardHelper.LanguageType.Chinese);
            });

            //英文识别
            _self.DOM.englishBtn.click(function () {
                languageHelper(blackboardHelper.TextType.English, blackboardHelper.LanguageType.English);
            });

            //中文识别返回按钮
            _self.DOM.chineseExit.click(function () {
                languageExitHelper();
            });

            //英文识别返回按钮
            _self.DOM.englishExit.click(function () {
                languageExitHelper();
            });

            //小燕合成
            _self.DOM.xiaoyanBtn.click(function () {
                playSoundHelper(blackboardHelper.LanguageType.Chinese, "xiaoyan");
            });

            //小宇合成
            _self.DOM.xiaoyuBtn.click(function () {
                playSoundHelper(blackboardHelper.LanguageType.Chinese, "xiaoyu");
            });

            //Mary合成
            _self.DOM.maryBtn.click(function () {
                playSoundHelper(blackboardHelper.LanguageType.English, "mary");
            });

            //henry合成
            _self.DOM.herryBtn.click(function () {
                playSoundHelper(blackboardHelper.LanguageType.English, "henry");
            });

            //评测
            _self.DOM.evalBtn.click(function () {
                _self.DOM.strokeAndDic.hide();
                _isStrokeOrderControlVisible = false;
                if (_isEvalControlVisible) {
                    _self.DOM.evalControl.hide();
                    _isEvalControlVisible = false;
                } else {
                    _self.DOM.evalControl.show().css("marginLeft", $(this).offset().left - 22);
                    _isEvalControlVisible = true;
                }
            });

            //中文单字评测
            $("#btnBlackBoardSingleEval").click(function () {
                evalHelper(blackboardHelper.LanguageType.Chinese, "cn_word", "wangru");
            });

            //中文词语评测
            $("#btnBlackBoardWordsEval").click(function () {
                evalHelper(blackboardHelper.LanguageType.Chinese, "cn_word", "wangru");
            });

            //英文评测
            $("#btnBlackBoardEnEval").click(function () {
                evalHelper(blackboardHelper.LanguageType.English, "en_word", "mary");
            });

            //笔顺库
            _self.DOM.strokeBtn.click(function () {
                showStrokeOrDic(blackboardHelper.TextType.Chinese);
            });

            //词典
            _self.DOM.dicBtn.click(function () {
                showStrokeOrDic(blackboardHelper.TextType.English);
            });

            //拼音标注
            _self.DOM.pyBtn.click(function () {
                showLoading({tips: AppBlackBoardTipsList.CreatingPinYin});
                _createTextToScreenDiv();
                _insertContentToTextArea(blackboardHelper.LanguageType.Chinese, blackboardHelper.TextType.PinYin).done(function (isSuccess) {
                    if (isSuccess) {
                        _self.DOM.strokeAndDic.hide();
                        _isStrokeOrderControlVisible = false;
                        _self.DOM.evalControl.hide();
                        _isEvalControlVisible = false;
                    }
                });
            });

            $("#saveblackboard").click(function(){
                _self.save();
            });

            $("#nextbboard").click(function(){
                _self.save();
                _self.curBlackNum < 10 ? _self.curBlackNum++ : _self.curBlackNum = 10;
                _self.load();
            });

            $("#prebboard").click(function(){
                _self.save();
                _self.curBlackNum > 1 ? _self.curBlackNum-- : _self.curBlackNum = 1;
                _self.load();
            })
        }

        /**
         * 板擦擦除处理
         */
        function eraserHelper(_eraserSize, herethis, _curCursor) {
            _self.DOM.tempCanvas && _self.DOM.tempCanvas.hide();
            _hideBlackBoardPopControls();
            _lastSelected.eraserTypeValue = _eraserSize;
            _setCursor(_curCursor);
            _self.DOM.eraserCtrl.children().children(".party_current").attr("class", "party_normal");
            herethis.attr("class", "party_current");
            _lastSelected.eraserTypeEle = herethis;
        }

        /**
         * 中英文识别处理
         */
        function languageHelper(txtType, lanType) {
            showLoading({tips: AppBlackBoardTipsList.ConvertingStrokes});
            _curTextType === txtType;
            _createTextToScreenDiv();
            _insertContentToTextArea(lanType, txtType).done(function (isSuccess) {
                hideLoading();
                if (isSuccess) {
                    _self.DOM.toolBar.hide();
                    txtType === blackboardHelper.TextType.English ? ( _self.DOM.CNtoolBar.hide(), _self.DOM.ENtoolBar.show()) :
                        ( _self.DOM.ENtoolBar.hide(), _self.DOM.CNtoolBar.show());
                    _self.DOM.strokeCanvas.hide();
                    _self.DOM.tempCanvas && _self.DOM.tempCanvas.hide();
                }
            });
        }

        /**
         * 笔迹识别退出处理
         */
        function languageExitHelper() {
            _self.DOM.toolBar.show();
            _self.DOM.CNtoolBar.hide();
            _self.DOM.ENtoolBar.hide();
            _self.DOM.strokeAndDic.hide();
            _self.DOM.evalControl.hide();
            _isStrokeOrderControlVisible = false;
            _isEvalControlVisible = false;
            _self.DOM.textToScreenDiv.hide();
            _self.DOM.strokeCanvas.show();
            _lastSelected.eraserType === blackboardHelper.ToolType.AreaEraser &&
                _lastSelected.curToolType === blackboardHelper.ToolType.Eraser && _self.DOM.tempCanvas.show();
            //返回时，只有笔迹数组不清空
            _self.conInfo.clearAreaPoints = [];
            _self.conInfo.toStrokeResultWordStr = null;
            _self.conInfo.toStrokeResultWords = [];
            _self.conInfo.strokeOrderResultWordArr = [];
        }

        /**
         * 音频合成处理
         */
        function playSoundHelper(language, speecher) {
            showLoading({tips: AppBlackBoardTipsList.ConvertingTextToSpeech});
            shellcmd.initTTS().done(function (initResult) {
                if (!initResult) {
                    hideLoading();
                    blackboardHelper.showTips(AppBlackBoardTipsList.InitTTSFailed);
                    return;
                }
                if (language === blackboardHelper.LanguageType.English) {
                    _self.conInfo.toStrokeResultWordStr = _self.conInfo.toStrokeResultWordStr.replace(/\,/g, "").replace(/\./g, "").replace(/\?/g, "")
                        .replace(/\!/g, "").replace(/\:/g, "").replace(/\;/g, "").replace(/\-/g, "");
                }
                blackboardHelper.textToSpeech([_self.conInfo.toStrokeResultWordStr], speecher, false).done(function (result) {
                    hideLoading();
                    if (result) {
                        blackboardHelper.audioPlay(result.audioPaths[0], _self.DOM.player);
                    }
                });
            });
        }

        /**
         * 评测处理
         * speecher  wangru 中文单字  xiaoyan 中文词语 mary 英文评测
         */
        function evalHelper(language, cardTyp, speecher) {
            showLoading({tips: AppBlackBoardTipsList.CreatingCards});
            shellcmd.initTTS().done(function (initResult) {
                if (!initResult) {
                    hideLoading();
                    blackboardHelper.showTips(AppBlackBoardTipsList.InitTTSFailed);
                    return;
                }
                if (language === blackboardHelper.LanguageType.Chinese) {
                    if (speecher === "wangru") {
                        CNwordsEvaHelper(speecher, cardTyp);
                    }
                    else if (speecher === "xiaoyan") {
                        CNchEvaHelper("wangru", cardTyp);
                    }
                }
                else if (language === blackboardHelper.LanguageType.English) {
                    ENEvaHelper(speecher, cardTyp);
                }
            });
        }

        function CNwordsEvaHelper(speecher, cardType) {
            //先整个句子都合成，得到每个字的拼音
            blackboardHelper.textToSpeech(_self.conInfo.toStrokeResultWords, speecher).done(function (result) {
                if (result) {
                    var cssmlWords = [];
                    var everyPyArr = result.everyPyArr;
                    //需要把识别出来的字符串拆成单个字
                    for (var i = 0; i < _self.conInfo.toStrokeResultWords.length; i++) {
                        var wordCSSML = '<?xml version="1.0" encoding="gb2312"?><speak><phoneme py=' + everyPyArr[i] + '>' +
                            _self.conInfo.toStrokeResultWords[i] + '</phoneme>';
                        cssmlWords.push(wordCSSML);
                    }
                    var useCSSML = true;
                    blackboardHelper.textToSpeech(_self.conInfo.toStrokeResultWords, speecher, useCSSML, cssmlWords).done(function (newResult) {
                        hideLoading();
                        if (newResult) {
                            var card = blackboardHelper.createMeta(cardType, newResult);
                            _showCard(card);
                        }
                    });
                }
            });
        }

        function CNchEvaHelper(speecher, cardType) {
            blackboardHelper.textToSpeech([_self.conInfo.toStrokeResultWordStr], speecher).done(function (result) {
                if (result) {
                    var resultWords = result.resultWords;
                    blackboardHelper.textToSpeech(resultWords, speecher).done(function (newResult) {
                        if (newResult) {
                            if (newResult.resultWords.length == 0) {
                                hideLoading();
                                blackboardHelper.showTips(AppBlackBoardTipsList.InitTTSFailed);
                            }
                            else {
                                var card = blackboardHelper.createMeta(cardType, newResult);
                                hideLoading();
                                _showCard(card);
                            }
                        }
                    });
                }
            });
        }

        function ENEvaHelper(speecher, cardType) {
            blackboardHelper.textToSpeech(_self.conInfo.toStrokeResultWords, speecher).done(function (result) {
                hideLoading();
                if (result) {
                    var card = blackboardHelper.createMeta(cardType, result);
                    _showCard(card);
                }
            });
        }

        function showStrokeOrDic(_curTextType) {
            if (_isStrokeOrderControlVisible) {
                _self.DOM.strokeAndDic.hide();
                _isStrokeOrderControlVisible = false;
            } else {
                _self.DOM.evalControl.hide();
                _isEvalControlVisible = false;
                _self.conInfo.strokeOrderResultWordArr = [];
                var len = _self.conInfo.toStrokeResultWords.length;
                for (var i = 0; i < len; i += 10) {
                    _self.conInfo.strokeOrderResultWordArr.push({index: (i / 10 + 1), words: _self.conInfo.toStrokeResultWords.slice(i, i + 10)});
                }
                //设定翻页按钮初始状态
                _strokeOrderPageNum = Math.floor(_self.conInfo.toStrokeResultWords.length / 10);
                if (_self.conInfo.toStrokeResultWords.length % 10 == 0) {
                    _strokeOrderPageNum -= 1;
                }
                if (_strokeOrderPageNum == 0) {
                    _self.DOM.nextPageBtn.children().attr("class", "nextpage_disable");
                } else {
                    _self.DOM.nextPageBtn.children().attr("class", "nextpage");
                }
                _self.DOM.prePageBtn.children().attr("class", "prepage_disable");
                // 给笔顺库翻页按钮绑定点击事件
                _self.DOM.nextPageBtn.unbind().click(_strokeOrderPrePage);
                _self.DOM.prePageBtn.unbind().click(_strokeOrderNextPage);
                //每次打开笔顺库，都显示第一页
                _strokeOrderPageIndex = 0;
                _createStrokeOrder();
                var controlWidth = _self.DOM.strokeAndDic.width();
                _self.DOM.strokeAndDic.css("marginLeft", _self.DOM.strokeBtn.offset().left - controlWidth / 2 + 20).show();
                _isStrokeOrderControlVisible = true;
            }
        }

        /**
         * 翻页按钮显示处理
         */
        function turnPageHelper() {
            if (_strokeOrderPageIndex == 0 && _strokeOrderPageNum > 0) {
                _self.DOM.prePageBtn.children().attr("class", "prepage_disable");
                _self.DOM.nextPageBtn.children().attr("class", "nextpage");
            }
            if (_strokeOrderPageIndex > 0 && _strokeOrderPageIndex < _strokeOrderPageNum) {
                _self.DOM.prePageBtn.children().attr("class", "prepage");
                _self.DOM.nextPageBtn.children().attr("class", "nextpage");
            }
            if (_strokeOrderPageIndex == _strokeOrderPageNum && _strokeOrderPageNum > 0) {
                _self.DOM.prePageBtn.children().attr("class", "prepage");
                _self.DOM.nextPageBtn.children().attr("class", "nextpage_disable");
            }
        }

        /**
         * 笔顺库，翻到上一页
         */
        function _strokeOrderPrePage() {
            _strokeOrderPageIndex >= 1 && ( _strokeOrderPageIndex-- , _createStrokeOrder());
            turnPageHelper();
        }

        /**
         * 笔顺库，翻到下一页
         */
        function _strokeOrderNextPage() {
            _strokeOrderPageIndex < _strokeOrderPageNum && (_strokeOrderPageIndex++ , _createStrokeOrder());
            turnPageHelper();
        }

        /**
         * 生成笔顺卡片
         */
        function _createStrokeOrder() {
            var wordsArr = _self.conInfo.strokeOrderResultWordArr[_strokeOrderPageIndex].words;
            var controlWidth = 0;
            if (_curTextType === blackboardHelper.TextType.Chinese) {
                if (wordsArr.length <= 5) {
                    controlWidth = wordsArr.length * 60 + 100;
                    _self.DOM.strokeAndDic.css("marginTop", -95);
                } else {
                    controlWidth = 400;
                    _self.DOM.strokeAndDic.css("marginTop", -158);
                }
                _self.DOM.strokeAndDic.css("width", controlWidth);
                var marginLeft = $("#btnBlackBoardStrokeOrder").offset().left - controlWidth / 2 + 20;
                _self.DOM.strokeAndDic.css("marginLeft", marginLeft);
            }
            else if (_curTextType === blackboardHelper.TextType.English) {
                var firstLineWidth = 0;
                var secondLineWidth = 0;
                var wordWidth = 65;
                if (wordsArr.length <= 5) {
                    for (var i = 0; i < wordsArr.length; i++) {
                        //console.log(i,wordsArr[i].length);
                        if (wordsArr[i].length > 5) {
                            wordWidth = wordsArr[i].length * 10 + 15;
                        } else {
                            wordWidth = 65;
                        }
                        controlWidth += wordWidth;
                    }
                    controlWidth += 100;
                    _self.DOM.strokeAndDic.css("marginTop", -95);
                } else {
                    for (var i = 0; i < 5; i++) {
                        if (wordsArr[i].length > 5) {
                            wordWidth = wordsArr[i].length * 10;
                        } else {
                            wordWidth = 65;
                        }
                        firstLineWidth += wordWidth;
                    }
                    for (var j = 5; j < wordsArr.length; j++) {
                        if (wordsArr[j].length > 5) {
                            wordWidth = wordsArr[j].length * 10;
                        } else {
                            wordWidth = 65;
                        }
                        secondLineWidth += wordWidth;
                    }
                    if (firstLineWidth > secondLineWidth) {
                        controlWidth = firstLineWidth + 100;
                    } else {
                        controlWidth = secondLineWidth + 100;
                    }
                    _self.DOM.strokeAndDic.css("marginTop", -158);
                }

                _self.DOM.strokeAndDic.css("width", controlWidth);
                var marginLeft = $("#btnBlackBoardDictionary").offset().left - controlWidth / 2 + 20;
                _self.DOM.strokeAndDic.css("marginLeft", marginLeft);
            }

            _self.DOM.strokeAndDic.css("marginLeft", 40).css("marginRight", 40);
            var lis = $(_self.DOM.strokeAndDic.children()[0]).children("li");
            $(lis).remove();

            for (var i = 0; i < wordsArr.length; i++) {
                (function (i) {
                    var li = $("<li/>").click(function () {
                        var strokeUrl = "";
                        var source = "";
                        if (_curTextType === blackboardHelper.TextType.Chinese) {
                            strokeUrl = AppRemoteSvcCfg.BlackBoardStrokeOrderPageUrl;
                            source = "&type=0604&keyword=" + wordsArr[i];
                        }
                        if (_curTextType === blackboardHelper.TextType.English) {
                            strokeUrl = AppRemoteSvcCfg.BlackBoardDictionaryPageUrl;
                            source = wordsArr[i];
                        }
                        var src = strokeUrl + source;
                        var strokeIframe = $('<iframe frameborder="0" allowtransparency="true" scrolling="no" src="' + src + '"></iframe>').load(function () {
                        });
                        shellcmd.checkOnline().done(function (isNetWorking) {
                            if (!isNetWorking) {
                                if (!ebookContext.getUser().getIsOnline()) {
                                    blackboardHelper.showTips(AppTips.LocalLoignMsg);
                                } else {
                                    blackboardHelper.showTips(AppTips.NetWorkConnectFailed);
                                }
                            } else {
                                CardWrapper.show(strokeIframe[0]);
                            }
                        });
                    })
                    li.html(wordsArr[i]);
                    $("#divBlackBoardClear").before(li);
                })(i);
            }
            if (parseInt(_self.DOM.strokeAndDic.css("height")) > 80) {
                _self.DOM.strokeAndDic.css("marginTop", -158);
            }
            if (parseInt(_self.DOM.strokeAndDic.css("height")) > 140) {
                _self.DOM.strokeAndDic.css("marginTop", -210);
            }
        }

        /**
         * 传入卡片信息，展示卡片
         * @param {{cardInfo: Object, cardPath: String}}  card
         */
        function _showCard(card) {
            var speechuiIndex = AppRemoteSvcCfg.SpeechUIPageUrl;
            if (AppCfg.isDebug) {
                speechuiIndex += "?d=" + new Date().getTime();
            }
            shellcmd.checkUrlAccess(speechuiIndex).done(function (ret) {
                if (ret) {
                    var cardOptions = null;
                    try {
                        cardOptions = blackboardHelper.getCardOptions(card.cardInfo, card.cardPath);
                    } catch (ex) {
                        blackboardHelper.showTips(AppBlackBoardTipsList.ReadCardOptionsFailed);
                    }
                    if (cardOptions) {
                        var frameId = cardOptions.cardName + '_' + new Date().getTime();
                        var iframeWidth = Config.Width - 100, iframeHeight = Config.Height;
                        var cardIframe = $('<iframe frameborder="0" allowtransparency="true" scrolling="no" id="' + frameId + '" src="' + speechuiIndex + '"></iframe>').load(function () {
                            var _self = this;
                            var element = $(_self.contentWindow.document.body);
                            setTimeout(function () {
                                $(_self.contentWindow.document).ready(function () {
                                    var elementHeight = element.outerHeight();
                                    var scale = correctToBaseResolution(element, {max_width: iframeWidth, max_height: iframeHeight, width: element.outerWidth(), height: elementHeight});

                                    if (!(scale[0] == 1 && scale[3] == 1))
                                        element.css({
                                            '-webkit-transform': 'matrix(' + scale.join(',') + ')'
                                        });

                                    scale[0] = 1 / scale[0], scale[3] = 1 / scale[3];
                                    if (scale[0] > 1 || scale[3] > 1) {
                                        element.find("#recorder").css({
                                            'transform-origin': '-100% 100%',
                                            '-webkit-transform': 'matrix(' + scale.join(',') + ')'
                                        })
                                    }
                                    cardIframe.show();
                                })
                            }, 1000);
                            dispatchClientMsg({evt: 'loadCard', data: cardOptions});
                        });
                        registerIframe(frameId, '*');
                        cardIframe.hide();
                        CardWrapper.show(cardIframe[0]);
                    }
                }
                else {
                    blackboardHelper.showTips(AppTips.RequestServerPageFailed);
                }
            });
        }

        _self.showBlackBoard = function(){
            _self.DOM.blackboardContainer.show();
            _self.load();
        }

        _self.hideBlackBoard = function(){
            _self.DOM.blackboardContainer.hide();
        }
		
		/**
		 * 加载笔迹
		 */
		_self.load = function(){
            var strokeFilePath = ebookContext.getUser().getUserBasePath() + "/" + _self.curBlackNum + ".storke";
            shellcmd.isFileExist(strokeFilePath).done(function(ret){
                if (ret) {
                    var strokeBase64 = shellcmd.readFile(strokeFilePath);
                    var image = new Image();
                    image.src = strokeBase64;
                    image.onload = function () {
                        _self.DOM.strokeContext.clearRect(0, 0, 1440,1200);
                        _self.DOM.strokeContext.drawImage(image, 0, 0);
                    }
                }
                else{
                    //清屏
                    _self.DOM.clearBtn.click();
                }
            });
		}
		
		/**
		 * 保存笔迹
		 */
		_self.save = function(filepath){
            var strokeBase64 = _self.DOM.strokeCanvas[0].toDataURL();
            var savepath = ebookContext.getUser().getUserBasePath() + "/" + _self.curBlackNum + ".storke";
            console.log(savepath);
            shellcmd.saveFile(strokeBase64, savepath);
		}
    }

    exports.Instance = new BlackBoard();
});
