/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 下午4:10
 * To change this template use File | Settings | File Templates.
 */
;define(function(require,exports){

    var shellcmd = require('../../common/shellcmd');
    var path = require('../../common/path');

    /**
     * matrix形变数据定义，参考
     * https://developer.mozilla.org/en-US/docs/Web/CSS/transform-function
     * @param {string=} matrixDataStr 矩阵变换数据
     */
    function MatrixData(matrixDataStr) {
        var matrixDatas = matrixDataStr ? matrixDataStr.split(',') : ['1', '0', '0', '1', '0', '0'];
        this.a = parseFloat(matrixDatas[0]);
        this.b = parseFloat(matrixDatas[1]);
        this.c = parseFloat(matrixDatas[2]);
        this.d = parseFloat(matrixDatas[3]);
        this.tx = parseFloat(matrixDatas[4]);
        this.ty = parseFloat(matrixDatas[5]);
    }

    /**
     * 修正取值
     */
    MatrixData.prototype.correct = function () {
        // 避免出现tx或ty取值为指数形式时(如: 1.4210854715202004e-14) 造成CSS设置失败
        this.tx = parseFloat(this.tx.toFixed(5));
        this.ty = parseFloat(this.ty.toFixed(5));
    };

    /**
     * 克隆
     * @returns {MatrixData}
     */
    MatrixData.prototype.clone = function () {
        return new MatrixData(this.toString());
    };

    MatrixData.prototype.toString = function () {
        return [this.a, this.b, this.c, this.d , this.tx, this.ty].join(',');
    };

    /**
     * @param {BookViewBase=} pageView
     * @param {MatrixData=} transformData
     */
    function BookViewInfo(pageView, transformData) {
        this.pageView == pageView;
        this.transformData = transformData || new MatrixData();
    }

    function clearCurrentPageRes (currView) {
        currView.clearCurrentPageRes();
    }

    /**
     * 清空书本资源
     */
    function clearBookRes(pageProvider) {
        $.Zebra_Dialog(AppTips.ClearResTips, {
            'type': 'question',
            'title': AppTips.WarmTips,
            'buttons': [AppTips.CancelTips, AppTips.OkTips],
            'onClose': function (capition) {
                if (capition == AppTips.OkTips) {
                    _clearBookRes("",pageProvider);
                }
            }
        });
    }

    /**
     *清空书本资源
     * @param {Array=} files  要清空的书本的页数
     */
    var _clearBookRes = function (files,pageProvider) {
        var deferred = $.Deferred();
        var bookPath = path.trimPosix(pageProvider.getUserBookDir()).replace(/\//g, "\\");
        var args = {
            "filter": ".base64",
            "dirs": ""
        };

        if (!files) {
            $.each(pageProvider.pages, function (i, e) {
                e.clearCurrentPageRes(); //清空页面widgets
            });
            showLoading({tips: AppTips.ClearResLoadingTips});
            args.dirs = bookPath;
            shellcmd.clearDir(JSON.stringify(args)).done(function () {
                hideLoading();
                deferred.resolve();
            });
        }
        else {
            var clearFile = "";
            $.each(files, function (i, file) {
                $.each(pageProvider.pages, function (i, e) {
                    if (e.pageIndex == file)
                        e.clearCurrentPageRes(); //清空页面widgets
                });
                if (i) clearFile += "|";
                clearFile += bookPath + '\\' + file;
            });
            args.dirs = clearFile;
            shellcmd.clearDir(JSON.stringify(args)).done(function () {
                deferred.resolve();
            });
        }
        return deferred.promise();
    }

    exports._clearBookRes = _clearBookRes;
    exports.clearBookRes = clearBookRes;
    exports.clearCurrentPageRes = clearCurrentPageRes;
    exports.MatrixData = MatrixData;
    exports.BookViewInfo = BookViewInfo;

});
