/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 下午4:43
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var _pageProvider = require('../pageprovider').Instance;
    var ebookContext = require('../../ebookcontext').Instance;
    var _resTool = require('./../resbar/restool');
    var shellcmd = require('../../../common/shellcmd');
    var _taskQueue = require('../../../common/taskQueue').Instance;
    var _define = require('../../define');
    var path = require('../../../common/path');
    var commonfunc = require('../../../common/commonfunc');

//    var converter = nodereq("userBookConverter");
    var converter = require('./converter').Instance;
    var fs = nodereq("fs");

    var isMTBK = true;//是否导出成mtbk资源
    var isUnit = true;//是否按单元导出
    var isBook = false;//是否按书导出
    var folderType = {
        "defaultUser":{
            "yun_mtbk":""
        }
    }; //记录用户特定类型文件夹对应的id

    function ExportRes() {
        var _self = this;
        _self._container = null;
    }

    ExportRes.prototype.init = function (_container) {
        var _self = this;
        _self._container = _container;
    }

    ExportRes.prototype.getPageViewType = function () {
        return this._container.getPageViewType();
    };

    ExportRes.prototype.exportBookRes = function () {
        var _self = this;
        var exportBookResContent = _self._initExportBookScanPanel(_pageProvider.bookObj);
        var parmDom = {
            txtPathSelect: exportBookResContent.find("#posSelect"),
            txtTitleSelect: exportBookResContent.find("#titleSelect"),
            divSelectBox: exportBookResContent.find(".sel"),
            btnSelectDir: exportBookResContent.find("#btnSelectDir"),
            btnCancel: exportBookResContent.find("#btnCancel"),
            btnSubmit: exportBookResContent.find("#btnSubmit"),
            btnClose: exportBookResContent.find(".close_Export"),
            btnSelectAll: exportBookResContent.find("#selectAll"),
            chek_export: exportBookResContent.find("#chek_export"),
            chek_upload: exportBookResContent.find("#chek_upload"),
            chek_cloud_upload: exportBookResContent.find("#chek_cloud_upload"),
            mtbkRadio:exportBookResContent.find("#mtbkRadio"),
            tebkRadio:exportBookResContent.find("#tebkRadio"),
            unitRadio:exportBookResContent.find("#unitRadio"),
            bookRadio:exportBookResContent.find("#bookRadio"),
            errorTip:exportBookResContent.find(".errorTip"),
            chek_cloud_upload_item:exportBookResContent.find("#chek_cloud_upload_item"),
            content: exportBookResContent,
            mtbkName: exportBookResContent.find("#exportMtbkName")
        };
        // 默认选中单元
        parmDom.mtbkName.val(_self.getMtbkFileName('unit'));
        _self._bindExportBookResCommands(parmDom);
        parmDom.errorTip.hide();
        //先进行书本页面保存操作
        // $.each(_pageProvider.pages, function (i, e) {
        //     e.saveXaml();
        // });

        _self._showExportBookScanPanel(parmDom, _pageProvider.bookObj);
    }

    //设置默认名称
    ExportRes.prototype.getMtbkFileName = function (range){
        var _self = this;
        var bookContainer = getGlobalBookContainer();
        if(range === "unit"){
            //获取当前页的书本信息
            var pageIndex = bookContainer.getPageIndex();
            var obj = _pageProvider.getPageMetadata(pageIndex);
            //当前课的课名_书名
            var unitName = "";
            if (obj.unit1Name) {
                unitName = obj.unit1Name;
            }
            if (obj.unit2Name) {
                unitName = obj.unit2Name;
            }
            if (obj.unit3Name) {
                unitName = obj.unit3Name;
            }
            if (obj.unit4Name) {
                unitName = obj.unit4Name;
            }
            //设置默认导出授课包名称
            var bookTitle = _self.safeString(_pageProvider.bookObj.IndexInfo.Title);
            if(unitName){
                return unitName + '_' + bookTitle;
            }else {
                return bookTitle;
            }
        }else{
            return _self.safeString(_pageProvider.bookObj.IndexInfo.Title);
        }
    };

    ExportRes.prototype.safeString = function (str) {
        if(typeof str === "string"){
            return str.replace(/[\/\\\*\:\?\"\<\>\|]/g,"").replace(/(^\s*)|(\s*$)/g, "");
        }
        return "";
    };

    ExportRes.prototype._initExportBookScanPanel = function () {
        var exportBookResContent = $(document.getElementById('template_res_export_panel').innerHTML);

        LAN.translateObj(exportBookResContent);
        //语言翻译
        if (AppCfg.lang == "uyghur") {
            exportBookResContent.find(".pop_seltext").css("direction", "rtl");
            exportBookResContent.find(".pop_seltext font").css("padding", "0 10px 0 0");
            exportBookResContent.find(".pop_btn input").css("width", "100px");
        }
//        显示上传至教研平台  -----  已经废弃，不知道教研平台还存不存在  by yczhu
        if (!AppCfg.showJiaoYan) {
            exportBookResContent.find("#chek_upload").prop("checked", false);
            exportBookResContent.find("#chek_upload_item").hide();
        }
        //显示上传至教研云
        if (!AppCfg.showCloud) {
            exportBookResContent.find("#chek_cloud_upload").prop("checked", false);
            exportBookResContent.find("#chek_cloud_upload_item").hide();
        }
        if (!AppCfg.showCloud && !AppCfg.showJiaoYan) {
            exportBookResContent.find("#chek_export").prop("checked", true).attr("disabled", true);
            exportBookResContent.find("#export_upload_title").html(AppImportAndExportTips.ExportTitle);
            exportBookResContent.find("#export_upload_content_tips").html(AppImportAndExportTips.ExportContentTips);
            exportBookResContent.find("#export_upload_file_tips").html(AppImportAndExportTips.ExportFileTips);
        }
        if (ebookContext.getUser().getName() == AppCfg.defaultuser) {
            exportBookResContent.find("#chek_cloud_upload_item").css("color", "#999").find("#chek_cloud_upload").attr("disabled", "disabled");
        }

        var dir = structMenu(_pageProvider.bookMenu);
        var $directory = exportBookResContent.find(".sel");
        $directory.html(dir);

        $("body").append(exportBookResContent);
        var exportPanel = exportBookResContent.find("#exportPanel");
        exportPanel.css({  //设置位置
            position: 'absolute',
            left: ($(window).width() - exportPanel.outerWidth()) / 2+102,
            top: ($(window).height() - exportPanel.outerHeight()) / 2 + $(document).scrollTop()
        }).draggable({               //设置可拖动
            containment: $("#bookContainer"),
            handle: ".pop_top"
        });
        return exportBookResContent;
    }

    ExportRes.prototype._exportTebkFile = function (argsJson, defer) {
        var tips = tipsDialog({
            "id":"exporting" + new Date().getTime(),
            "content":"授课包导出中..."
        });
        var p ={
            dbfiles:argsJson.data,
            fileName:argsJson.name
        }
        _pageProvider.exportMtbk(p).done(function(ret){
            if(ret && ret.code == 1 && ret.data){
                shellcmd.copyFileByStream(ret.data,argsJson.exportpos + "/" + argsJson.name + '.mtbk').done(function(result){
                    // var tips = AppImportAndExportTips.ExportSuccess;
                    // addTipDialog(tips);
                    // hideLoading();
                    var tips = tipsDialog({
                        "id":"exporting" + new Date().getTime(),
                        "content": '<span class="success_box_right"></span>授课包导出成功'
                    });
                    defer.resolve();
                }).fail(function(e){
                    // addTipDialog(AppImportAndExportTips.ExportDirInvalid);
                    var tips = tipsDialog({
                        "id":"exporting" + new Date().getTime(),
                        "content":"授课包导出失败"
                    });
                    defer.resolve();
                });
            }else{
                var tips = tipsDialog({
                    "id":"exporting" + new Date().getTime(),
                    "content":"授课包导出失败"
                });
                // addTipDialog(AppImportAndExportTips.ExportDirInvalid);
                defer.resolve();
            }
        });
        // shellcmd.isDirExist(argsJson.rootdir).done(function (ret) {
        //     if (ret) {
        //         showLoading({tips: AppTips.HandlingTips});
        //         console.log("导出文件为：" + JSON.stringify(argsJson));
        //         shellcmd.resExport(JSON.stringify(argsJson)).done(function (ret) {
        //             var tips;
        //             if (ret == 'true')   tips = AppImportAndExportTips.ExportSuccess;
        //             else if (ret == 'empty') tips = AppImportAndExportTips.ExportChapterInvalid;
        //             else {
        //                 tips = AppImportAndExportTips.ExportFailed;
        //                 var filePath = argsJson.exportpos + '/' + argsJson.name + '.mtbk';
        //                 shellcmd.deleteFile(filePath);
        //             }
        //             addTipDialog(tips);
        //             hideLoading();
        //             defer.resolve();
        //         });
        //     }
        //     else {
        //         addTipDialog(AppImportAndExportTips.ExportDirInvalid);
        //         defer.resolve();
        //     }
        // });
    }

    /**
     * 与上述功能大致类似，导出bbt tebk文件
     * @param argsJson
     * @param defer
     * @private
     */
    ExportRes.prototype._exportBBTTebkFile = function (argsJson, defer) {
        shellcmd.isDirExist(argsJson.rootdir).done(function (ret) {
            if (ret) {
                showLoading({tips: AppTips.HandlingTips});
                console.log("导出文件为：" + JSON.stringify(argsJson));

                var zipDir = Config.nwexePath + 'plugins/62/bin/tebk';
                var targetZipPath = argsJson.exportpos +'/'+ argsJson.name +'.tebk';
                converter.convert2Tebk(argsJson).done(function(result){
                    var tips;
                    if(result == 201){
                        shellcmd.zip(zipDir,targetZipPath).done(function (success) {
                            if(success){
                                tips = AppImportAndExportTips.ExportSuccess;
                                //清空缓存文件夹
                               shellcmd.deleteDir(zipDir+'/'+argsJson.bookcode);


                            }
                            else{
                                tips = AppImportAndExportTips.ExportFailed;
                            }
                            addTipDialog(tips);
                        });

                    }else{
                        tips = AppImportAndExportTips.ExportFailed;
                        addTipDialog(tips);
                    }

                    hideLoading();
                    defer.resolve();
                });
            }
            else {
                addTipDialog(AppImportAndExportTips.ExportDirInvalid);
                defer.resolve();
            }
        });
    }

    /**
     * 该上传mtbk文件的方法废弃，已由edc网盘接口替换
     * -by xinfang3 20160927
     */
    ExportRes.prototype._uploadMTBKFile = function (argsJson) {
        shellcmd.resExport(JSON.stringify(argsJson)).done(function (ret) {
            console.log("resExport to tmp dir result: " + ret);
            if (ret == 'true') {
                //导出成功
                var param = {
                    filename: argsJson.filename,
                    bookcode: argsJson.bookcode,
                    unit: "",
                    course: ""
                };

                var uploadUrl = AppRemoteSvcCfg.uploadMTBK.
                format(ebookContext.getUser().getUid(), "yun_mtbk", param.filename, param.bookcode, param.unit, param.course);

                uploadUrl += "&access_token=" + ebookContext.getUser().getDynamicToken();
                var filePath = argsJson.exportpos + "/" + param.filename;
                shellcmd.uplaodByDll(filePath, encodeURI(uploadUrl));
            }
        });
    }

    /**
     * 获取随机唯一的id,用于socket请求时id唯一标记
     * @returns {string}
     */
    function makeId(){
        var words = 'abcdefghijklmnopqrstuvwxyz',
            key = +new Date() + '_';
        for(var i=0; i<18; i++) {
            key += words.charAt((Math.random()*25).toFixed());
        }
        return key;
    }

    /**
     * 获取edc网盘接口特定目录的dirId （该方法不使用了）
     * @param user
     * @param flag
     * @returns {*}
     */
    function getEdcSpecialDirId(user,flag){
        var def = jQuery.Deferred();
        var dirId = "";
        var _openId = user && user.id || "";
        flag = flag || "yun_mtbk";
        if(_openId == ""){
            def.reject(false);
        }
        //这里的缓存没有启用
        if(folderType && folderType[_openId] && folderType[_openId]['yun_mtbk'] != ""){
            def.resolve(folderType[_openId]['yun_mtbk']);
        }else {
            //获取mtbk yun_mtb类型的文件夹所在的dirId
            var param_pan_root_directly = {
                "openId": _openId,
                "coverDir": true,
                "coverFile": false,
                "order": "3", //1：修改时间，2：名称，3：创建时间
                "dirId": 0
            };
            edcService.Instance().pan_children_directly(param_pan_root_directly).done(function (ret) {
                if (ret.code == 0) {
                    var _root_folders = ret.data;
                    var folders = _root_folders.fileList || [];
                    if (_root_folders.total > 0) {
                        for (var i = 0, count = folders.length; i < count; i++) {
                            var item = folders[i];
                            if (item.folderType == flag) {
                                dirId = item.fid;
                                def.resolve(dirId);
                                break;
                            }
                        }
                        //没有匹配到flag
                        if(dirId == ""){
                            def.resolve(dirId);
                        }
                    } else {
                        def.reject(false);
                    }
                } else {
                    console.log(ret);
                }
            }).fail(function (e) {
                console.log(e);
            });
        }
        return def.promise();
    }
    /**
     * mtbk文件同步到网盘（edc接口）
     */
    ExportRes.prototype._uploadMTBKFileByEdc = function (argsJson,uploadInfo,isExportChecked) {
        if(isExportChecked){
            uploadmtbktoedc(argsJson);
        }else{
            var p ={
                dbfiles:argsJson.data,
                fileName:argsJson.name
            }
            _pageProvider.exportMtbk(p).done(function(ret){
                if(ret && ret.code == 1 && ret.data){
                    shellcmd.copyFileByStream(ret.data,argsJson.exportpos + "/" + argsJson.name + '.mtbk').done(function(result){
                        // var tips = AppImportAndExportTips.ExportSuccess;
                        // addTipDialog(tips);
                        // hideLoading();
                        // defer.resolve();
                        uploadmtbktoedc(argsJson);
                    }).fail(function(e){
                        var tips =  tipsDialog({
                            "id":"sharefail" + new Date().getTime(),
                            "content":"授课包上传失败"
                        });
                    });
                }else{
                    var tips =  tipsDialog({
                        "id":"sharefail" + new Date().getTime(),
                        "content":"授课包上传失败"
                    });
                    console.log("授课包打包失败");
                }
            }).fail(function(e){
                var tips =  tipsDialog({
                    "id":"sharefail" + new Date().getTime(),
                    "content":"授课包上传失败"
                });
            });  
        }
        // shellcmd.resExport(JSON.stringify(argsJson)).done(function (ret) {
        //     console.log("resUpload result: " + ret);
        //     if (ret == 'true') {
        //         var tips =  tipsDialog({
        //             "id":"shareing" + new Date().getTime(),
        //             "content":"授课包上传中..."
        //         });
        //         var user = ebookContext.getUser();
        //         var param_core_user = {
        //             'key':"id",
        //             'value':user._uid
        //         };
        //         edcService.Instance().core_user_get(param_core_user).done(function(ret) {
        //             if (ret.code == 0) {
        //                 var _user_info = ret.data || {};
        //                 var _openId = _user_info.id || "";

        //                 var fileFullPath = argsJson.exportpos + '/' + argsJson.filename;
        //                 var parseFileName = _resTool.parseFileName(fileFullPath);
        //                 var fileNameWidthExt = parseFileName.file;
        //                 var fileName = parseFileName.fileName;
        //                 var fileExt = parseFileName.fileExt;
        //                 var edc_file_prepare_request = {
        //                     openId : _openId, // 用户登录返回的openId
        //                     extension : fileExt // 文件的后缀名
        //                     // chunks : 1, // 分片上传分片数
        //                     // platForm : platForm, // 文件服务使用的appname
        //                     // callbackMethod : "", // 文件上传完回调方法
        //                     // callbackUrl : "", // 文件上传完回调地址
        //                     // callbackParams : "", // 文件上传完回调参数
        //                     // callbackProtocol : "" // 文件上传完回调方法
        //                 };
        //                 $.when(_resTool.calcMd5(fileFullPath), edcService.Instance().pan_file_resource_prepare(edc_file_prepare_request)).done(function(ret1,ret2,ret3){
        //                     if(!ret1) {
        //                         console.log("文件md5计算失败");
        //                         var tips =  tipsDialog({
        //                             "id":"sharefail" + new Date().getTime(),
        //                             "content":"授课包上传失败"
        //                         });
        //                         return 0;
        //                     }
        //                     if(!ret2 || ret2.code != 0) {
        //                         console.log("文件预上传失败");
        //                         var tips =  tipsDialog({
        //                             "id":"sharefail" + new Date().getTime(),
        //                             "content":"授课包上传失败"
        //                         });
        //                         return 0;
        //                     }

        //                     var pageIndex = app_global_bookContainer.getPageIndex();
        //                     var pageMeta = app_global_bookContainer.getPageMetadata(pageIndex) || {};
        //                     var bookMeta = app_global_bookContainer.bookMetaInfo || {};
        //                     var uploadChunks = ret2.data.prepareInfo.uploads;

        //                     //完成文件上传参数
        //                     var edc_file_upload_complete_request = {
        //                         platForm : uploadChunks[0].params.appKey, //prepare返回接口数据中的appKey
        //                         contextId: uploadChunks[0].params.contextId //prepare接口中返回的contextId
        //                     };

        //                     var fileMD5 = ret1;
        //                     var fileSize = fs.statSync(fileFullPath).size || "";
        //                     var contextId = uploadChunks[0].params.contextId;
        //                     var url = ret2.data.prepareInfo.url;

        //                     //文件上传请求接口(到云备课)
        //                     var edc_file_add_request = {
        //                         openId : _openId,
        //                         name : fileName,
        //                         url : url, //文件地址
        //                         md5 : fileMD5, // 文件md5值
        //                         length : fileSize, // 文件长度
        //                         status : "", // 文件上传状态
        //                         // token : "", // 结果签名（contextId、url、md5、length、status进行计算）
        //                         contextId : "", // 通过文件服务上传后文件服务返回id
        //                         description : "", // 文件描述
        //                         grade : bookMeta.grade || "", // 年级属性
        //                         subject : bookMeta.subject || "", // 学科属性
        //                         publisher : bookMeta.publisher || "", // 上下册
        //                         phase : "", // 版本属性
        //                         volumn : bookMeta.volumn || "", // Stage
        //                         edition : "", // 类型属性
        //                         stage : "", // Stage
        //                         type : "", // 书本属性
        //                         book : bookMeta.bookCode || "", // 书本属性
        //                         unit1 : uploadInfo.unit1 || "", // 课本一级目录
        //                         unit2 : uploadInfo.unit2 || "", // 课本二级目录
        //                         unit3 : uploadInfo.unit3 || "", // 课本三级目录
        //                         unit4 : uploadInfo.unit4 || "" // 课本四级目录
        //                     };

        //                     var id_key = makeId();

        //                     var upload_params = {
        //                         id:id_key,
        //                         url: uploadChunks[0].host,
        //                         file: fileFullPath,
        //                         key: 'file',
        //                         multi:1,
        //                         source : 'ifb_mtbk_upload',
        //                         evt: "ifb_mtbk_upload", //用户回调函数判断事件类型
        //                         extra: {
        //                             appKey: uploadChunks[0].params.appKey,
        //                             contextId: uploadChunks[0].params.contextId,
        //                             expires: uploadChunks[0].params.expires,
        //                             token: uploadChunks[0].params.token
        //                         },
        //                         raw_data:{
        //                             "index" : id_key,
        //                             "url": uploadChunks[0].host,
        //                             "appKey": uploadChunks[0].params.appKey,
        //                             "contextId": uploadChunks[0].params.contextId,
        //                             "expires": uploadChunks[0].params.expires,
        //                             "token": uploadChunks[0].params.token,
        //                             "edc_file_upload_complete_request": edc_file_upload_complete_request,
        //                             "edc_file_add_request": edc_file_add_request
        //                         }
        //                     };
        //                     socket.send({"type":"logic","action":"ta_upload","from":"ib","to":"ta_dum","data":upload_params});
        //                 }).fail(function(e){
        //                     var tips =  tipsDialog({
        //                         "id":"sharefail" + new Date().getTime(),
        //                         "content":"授课包上传失败"
        //                     });
        //                 });
        //             }else{
        //                 var tips =  tipsDialog({
        //                     "id":"sharefail" + new Date().getTime(),
        //                     "content":"授课包上传失败"
        //                 });
        //             }
        //         }).fail(function(e){
        //             console.log(e);
        //             var tips =  tipsDialog({
        //                 "id":"sharefail" + new Date().getTime(),
        //                 "content":"授课包上传失败"
        //             });
        //         });
        //     }else{
        //         var tips =  tipsDialog({
        //             "id":"sharefail" + new Date().getTime(),
        //             "content":"授课包打包失败"
        //         });
        //     }
        // });
        function uploadmtbktoedc(argsJson){
            var tips =  tipsDialog({
                "id":"shareing" + new Date().getTime(),
                "content":"授课包上传中..."
            });
            var user = ebookContext.getUser();
            var param_core_user = {
                'key':"id",
                'value':user._uid
            };
            edcService.Instance().core_user_get(param_core_user).done(function(ret) {
                if (ret.code == 0) {
                    var _user_info = ret.data || {};
                    var _openId = _user_info.id || "";

                    var fileFullPath = argsJson.exportpos + '/' + argsJson.filename;
                    var parseFileName = _resTool.parseFileName(fileFullPath);
                    var fileNameWidthExt = parseFileName.file;
                    var fileName = parseFileName.fileName;
                    var fileExt = parseFileName.fileExt;
                    var edc_file_prepare_request = {
                        openId : _openId, // 用户登录返回的openId
                        extension : fileExt // 文件的后缀名
                        // chunks : 1, // 分片上传分片数
                        // platForm : platForm, // 文件服务使用的appname
                        // callbackMethod : "", // 文件上传完回调方法
                        // callbackUrl : "", // 文件上传完回调地址
                        // callbackParams : "", // 文件上传完回调参数
                        // callbackProtocol : "" // 文件上传完回调方法
                    };
                    $.when(_resTool.calcMd5(fileFullPath), edcService.Instance().pan_file_resource_prepare(edc_file_prepare_request)).done(function(ret1,ret2,ret3){
                        if(!ret1) {
                            console.log("文件md5计算失败");
                            var tips =  tipsDialog({
                                "id":"sharefail" + new Date().getTime(),
                                "content":"授课包上传失败"
                            });
                            return 0;
                        }
                        if(!ret2 || ret2.code != 0) {
                            console.log("文件预上传失败");
                            var tips =  tipsDialog({
                                "id":"sharefail" + new Date().getTime(),
                                "content":"授课包上传失败"
                            });
                            return 0;
                        }

                        var pageIndex = app_global_bookContainer.getPageIndex();
                        var pageMeta = app_global_bookContainer.getPageMetadata(pageIndex) || {};
                        var bookMeta = app_global_bookContainer.bookMetaInfo || {};
                        var uploadChunks = ret2.data.prepareInfo.uploads;

                        //完成文件上传参数
                        var edc_file_upload_complete_request = {
                            platForm : uploadChunks[0].params.appKey, //prepare返回接口数据中的appKey
                            contextId: uploadChunks[0].params.contextId //prepare接口中返回的contextId
                        };

                        var fileMD5 = ret1;
                        var fileSize = fs.statSync(fileFullPath).size || "";
                        var contextId = uploadChunks[0].params.contextId;
                        var url = ret2.data.prepareInfo.url;

                        //文件上传请求接口(到云备课)
                        var edc_file_add_request = {
                            openId : _openId,
                            name : fileName,
                            url : url, //文件地址
                            md5 : fileMD5, // 文件md5值
                            length : fileSize, // 文件长度
                            status : "", // 文件上传状态
                            // token : "", // 结果签名（contextId、url、md5、length、status进行计算）
                            contextId : "", // 通过文件服务上传后文件服务返回id
                            description : "", // 文件描述
                            grade : bookMeta.grade || "", // 年级属性
                            subject : bookMeta.subject || "", // 学科属性
                            publisher : bookMeta.publisher || "", // 上下册
                            phase : "", // 版本属性
                            volumn : bookMeta.volumn || "", // Stage
                            edition : "", // 类型属性
                            stage : "", // Stage
                            type : "", // 书本属性
                            book : bookMeta.bookCode || "", // 书本属性
                            unit1 : uploadInfo.unit1 || "", // 课本一级目录
                            unit2 : uploadInfo.unit2 || "", // 课本二级目录
                            unit3 : uploadInfo.unit3 || "", // 课本三级目录
                            unit4 : uploadInfo.unit4 || "" // 课本四级目录
                        };

                        var id_key = makeId();

                        var upload_params = {
                            id:id_key,
                            url: uploadChunks[0].host,
                            file: fileFullPath,
                            key: 'file',
                            multi:1,
                            source : 'ifb_mtbk_upload',
                            evt: "ifb_mtbk_upload", //用户回调函数判断事件类型
                            extra: {
                                appKey: uploadChunks[0].params.appKey,
                                contextId: uploadChunks[0].params.contextId,
                                expires: uploadChunks[0].params.expires,
                                token: uploadChunks[0].params.token
                            },
                            raw_data:{
                                "index" : id_key,
                                "url": uploadChunks[0].host,
                                "appKey": uploadChunks[0].params.appKey,
                                "contextId": uploadChunks[0].params.contextId,
                                "expires": uploadChunks[0].params.expires,
                                "token": uploadChunks[0].params.token,
                                "edc_file_upload_complete_request": edc_file_upload_complete_request,
                                "edc_file_add_request": edc_file_add_request
                            }
                        };
                        socket.send({"type":"logic","action":"ta_upload","from":"ib","to":"ta_dum","data":upload_params});
                    }).fail(function(e){
                        var tips =  tipsDialog({
                            "id":"sharefail" + new Date().getTime(),
                            "content":"授课包上传失败"
                        });
                    });
                }else{
                    var tips =  tipsDialog({
                        "id":"sharefail" + new Date().getTime(),
                        "content":"授课包上传失败"
                    });
                }
            }).fail(function(e){
                console.log(e);
                var tips =  tipsDialog({
                    "id":"sharefail" + new Date().getTime(),
                    "content":"授课包上传失败"
                });
            });
        }
        //监管
        var action = LogManager.action.trigger;
        var params = {};
        params.module = '1130503';
        var user_id = ebookContext.getUser().getUid();
        if(user_id != '0' && user_id){
            params.user_id =user_id;
        }
        LogManager.statistics(action,params);
    }

    ExportRes.prototype._uploadTekbFile = function (argsJson, uploadUrls) {
        //保证每个上传进程间隔一定时间
        var doMtbkUpload = function (filePath, url, delay) {
            setTimeout(function () {
                shellcmd.uplaodByDll(filePath, encodeURI(url));
            }, delay);
        };
        var chapters = argsJson.chapters;
        console.log("上传文件为:", JSON.stringify(argsJson));
        shellcmd.chaptersExport(JSON.stringify(argsJson)).done(function (ret) {
            console.log("resUpload result: " + ret);
            if (ret == 'true') {
                for (var u in uploadUrls) {
                    //暂且将多平台去除，只支持一个平台
                    for (var i in chapters) {
                        var filePath = argsJson.exportpos + "/" + chapters[i].name + ".mtbk";
                        var param = {
                            filename: chapters[i].name + ".mtbk",
                            bookcode: argsJson.bookcode,
                            unit: chapters[i].unit,
                            course: chapters[i].course
                        };
                        var uploadUrl = AppRemoteSvcCfg.uploadMTBK.
                            format(ebookContext.getUser().getUid(), "yun_mtbk", param.filename, param.bookcode, param.unit, param.course);

                        uploadUrl += "&access_token=" + ebookContext.getUser().getDynamicToken();
                        var delay = (parseInt(i)) * (parseInt(u) + 1) * 3000;
                        doMtbkUpload(filePath, uploadUrl, delay);
                    }
                }
            } else if (ret == 'empty') {
                addTipDialog(AppImportAndExportTips.ExportChapterInvalid);
            }
        });
    }

    /**
     * tekb文件同步到网盘（edc接口）
     */
    ExportRes.prototype._uploadTekbFileByEdc = function(argsJson, uploadUrls){

    }

    ExportRes.prototype._bindExportBookResCommands = function (parmDom) {
        var _self = this;
        if (!parmDom) return;
        //取消按钮
        parmDom.btnCancel.click(function (event) {
            parmDom.content.remove();
            event.stopPropagation();
        });
        //关闭按钮
        parmDom.btnClose.click(function (event) {
            parmDom.content.remove();
            event.stopPropagation();
        });

        //全书 或 本单元选择
        parmDom.bookRadio.click(function(event){
            isBook = true;
            isUnit = false;
            parmDom.bookRadio.attr("checked",true);
            parmDom.unitRadio.attr("checked",false);
            // 显示全书名称
            parmDom.mtbkName.val(_self.getMtbkFileName('all'));
            event.stopPropagation();
        });

        parmDom.unitRadio.click(function(event){
            isBook = false;
            isUnit = true;
            parmDom.bookRadio.attr("checked",false);
            parmDom.unitRadio.attr("checked",true);
            // 显示单元名称
            parmDom.mtbkName.val(_self.getMtbkFileName('unit'));
            event.stopPropagation();
        });

        var $checkboxs = parmDom.divSelectBox.find(":checkbox");
        //全选按钮
        parmDom.btnSelectAll.click(function (event) {
            if ($(this).prop("checked")) {
                $checkboxs.prop("checked", true); // 不要用attr
                $checkboxs.parents("ul.course:first").css("opacity", 1);
                parmDom.divSelectBox.css("opacity", 0.7);
                $checkboxs.attr("disabled", true);
            }
            else {
                $checkboxs.attr("disabled", false);
                $checkboxs.prop("checked", false);
                parmDom.divSelectBox.css("opacity", 1);
                parmDom.divSelectBox.find(".course").css("opacity", 1);
            }
            event.stopPropagation();
        });

        parmDom.divSelectBox.on('click', function (e) {
            var target = e.target || e.srcElement;
            if (target.type === "checkbox") {
                target = $(target);
                //父级标签是包裹checkbox的div或li
                var parentEle = target.parent();
                //同级checkbox
                var siblingCheckboxs = parentEle.siblings().find("input:checkbox");
                //子级checkbox
                var childrenCheckboxs = target.siblings().find("input:checkbox");

                siblingCheckboxs = $.merge(siblingCheckboxs, target);
                if (target.prop("checked")) {
                    childrenCheckboxs.prop("checked", true);
                    childrenCheckboxs.attr("disabled", true);

                    //如果同级都选上了，触发父级checkbox的单击事件
                    //最终触发“全选”
                    if (!siblingCheckboxs.not(":checked").length) {
                        var prev = parentEle.parent();
                        if (prev.length && prev[0].tagName.toLocaleLowerCase() != "ul") {
                            prev.find(":checkbox:first").trigger('click');
                        }
                        else  parmDom.btnSelectAll.trigger('click');
                    }
                }
                else {
                    childrenCheckboxs.attr("disabled", false);
                    childrenCheckboxs.prop("checked", false);
                }
            }
            e.stopPropagation();
        });

        //兼容bbt mtbk需求
        parmDom.mtbkRadio.on('click',function(){
            isMTBK = true;
            parmDom.tebkRadio.attr("checked",false);
            parmDom.chek_cloud_upload_item.show();
        })

        parmDom.tebkRadio.on('click',function(){
            isMTBK = false;
            parmDom.mtbkRadio.attr("checked",false);
            parmDom.chek_cloud_upload_item.hide();
        })


        //改为到当前书本与到当前课，可以导出多课的先注释掉
        //打开导出面板时，预先选中当前页
        // var _pageViewType = _self.getPageViewType();
        // var isDoublePage = _pageViewType === _define.PageViewType.SimpleDoublePage || _pageViewType === _define.PageViewType.TurnJsDoublePage;
        // var singleHeight;
        // var prepareCheckbox, hasSelect = false;
        // $.each($checkboxs, function (i, e) {
        //     var element = $(e);
        //     var pageIndex = parseInt(element.attr("Start"));
        //     var pageIndexEnd = parseInt(element.attr("End"));

        //     var currPageIndex = parseInt(_self._container.getPageIndex());

        //     var pages = [pageIndex, pageIndexEnd];
        //     var isSelect = false;

        //     if (isDoublePage) {
        //         // *
        //         //  * 修改原因：修复当前页（电子书中左页）是英语，但是checkbox勾选却放在下一页的问题
                 
        //        // if ((currPageIndex >= pages[0] && currPageIndex <= pages[1]) || (currPageIndex + 1 >= pages[0] && currPageIndex + 1 <= pages[1])) {
        //        //     isSelect = true;
        //        // }
        //         if ((currPageIndex >= pages[0] && currPageIndex <= pages[1]) ) {
        //             isSelect = true;
        //         }
        //     } else if (currPageIndex >= pages[0] && currPageIndex <= pages[1]) {
        //         isSelect = true;
        //     }
        //     if (isSelect) {
        //         prepareCheckbox = element;
        //     }
        // });

        // if (!hasSelect && prepareCheckbox) {
        //     prepareCheckbox.trigger('click');
        // }
    }

    ExportRes.prototype._showExportBookScanPanel = function (parmDom, bookObj) {
        var _self = this;
        isMTBK = true;
        isUnit = true;
        isBook = false;
        if (!parmDom || !bookObj) return;

        parmDom.btnSubmit.click(function (event) {        //提交按钮
            //错误信息隐藏
            parmDom.errorTip.hide();
            if(json.TP.useDb){
                var argsJson = {
                    exportpos: null,
                    name: null,
                    rootdir: path.trimPosix(_pageProvider.getUserBookBaseDir()),
                    bookcode: bookObj.IndexInfo.Code,
                    folders: [],
                    data:[]
                };
                var isExportChecked = parmDom.chek_export.prop("checked");
                if(isExportChecked){
                    //temp eshop监管 linwang5@iflytek.com
                    var staticParams = {
                        uid:ebookContext._curUser._uid,
                        module:'02009',
                        type:'trigger'
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                }
                var isUploadChecked = parmDom.chek_upload.prop("checked");
                var isCloudUploadChecked = parmDom.chek_cloud_upload.prop("checked");
                if(isCloudUploadChecked){
                    //temp eshop监管 linwang5@iflytek.com
                    var staticParams = {
                        uid:ebookContext._curUser._uid,
                        module:'02010',
                        type:'trigger'
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                }
                //判断是否选中导出到本地或云端
                if (!isExportChecked && !isUploadChecked && !isCloudUploadChecked){
                    // addTipDialog(AppImportAndExportTips.ExportWaysFailed);
                    parmDom.errorTip.show();
                    parmDom.errorTip.text(AppImportAndExportTips.ExportWaysFailed);
                    return;
                } 
                //获取当前页的书本信息
                var pageIndex = app_global_bookContainer.getPageIndex();
                var obj = _pageProvider.getPageMetadata(pageIndex);
                var fileName;
                var uploadInfo = {};
                var exportMtbkName = (parmDom.mtbkName.val()).trim().replace(/[\/\\\*\:\?\"\<\>\|]/g,"");
                if (exportMtbkName) {
                    fileName = exportMtbkName;
                } else if(isUnit && !isBook){
                    //当前课的课名_书名
                    var unitName = "";
                    if(obj.unit1Name){unitName = obj.unit1Name}
                    if(obj.unit2Name){unitName = obj.unit2Name}
                    if(obj.unit3Name){unitName = obj.unit3Name}
                    if(obj.unit4Name){unitName = obj.unit4Name}
                    fileName = (unitName + "_" + bookObj.IndexInfo.Title).replace(/[\/\\\*\:\?\"\<\>\|]/g,"");
                    uploadInfo.unit1 = obj.unit1;  
                    uploadInfo.unit2 = obj.unit2;  
                    uploadInfo.unit3 = obj.unit3;  
                    uploadInfo.unit4 = obj.unit4;
                }else if(isBook && !isUnit){
                    fileName = (bookObj.IndexInfo.Title).replace(/[\/\\\*\:\?\"\<\>\|]/g,"");  
                }
                if(isUnit && !isBook){
                    var pages = bookObj.pages.filter(function(el){
                        return el.unit1==obj.unit1 && el.unit2==obj.unit2 && el.unit3==obj.unit3 && el.unit4==obj.unit4;
                    });
                    for(var i =0 ;i<pages.length;i++){
                        argsJson.folders.push(pages[i].pageIndex);
                    }
                     
                    _pageProvider.getTPUnit(obj).done(function(ret){
                        if(ret.length > 0){
                            argsJson.data = ret;
                            exportmtbk(argsJson,fileName);
                            // var resByPages = getResByPages(pages,ret);
                            // for(var i =0;i<resByPages.length;i++){
                            //     var pageIndex = resByPages[i][0] && resByPages[i][0].pageIndex;
                            //     var xaml = _pageProvider.toPageXml(resByPages[i],pageIndex);
                            //     var xmlpath = argsJson.rootdir+ "/" + bookObj.IndexInfo.Code +"/"+pageIndex+"/"+pageIndex+".xaml";
                            //     shellcmd.saveFile(xaml,xmlpath);
                            // }
                            // for(var j = 0;j<ret.length;j++){
                            //     (function(j){
                            //         $(document).queue("copyPagesFile",function(){
                            //             var dst = argsJson.rootdir + "/" + bookObj.IndexInfo.Code + "/" + ret[j].pageIndex + "/" + ret[j].fileName+"."+ret[j].extension;
                            //             var src = path.join(path.trimPosix(Config.nwexePath), 'user/' + ebookContext.getUser().getName() + '/books/' + ret[j].bookCode + '/' + ret[j].uuid + '/' + ret[j].fileName + '.' + ret[j].extension) || "";
                            //             shellcmd.copyFileByStream(src,dst).done(function(result){
                            //                 if($(document).queue("copyPagesFile").length == 0){
                            //                     exportmtbk(argsJson,fileName);
                            //                 }else{
                            //                     $(document).dequeue("copyPagesFile");
                            //                 }
                            //             });
                            //         });
                            //     })(j); 
                            // }
                            // $(document).dequeue("copyPagesFile");
                        }else{
                            parmDom.errorTip.show();
                            parmDom.errorTip.text(AppImportAndExportTips.ExportNoneRes);
                            return;
                        }
                    }).fail(function(e){
                        tips = AppImportAndExportTips.ExportFailed;
                        addTipDialog(tips);
                    });
                }
                if(!isUnit && isBook){
                    //TODO::获取当前书的所有资源信息
                    var pages = bookObj.pages;
                    for(var i =0 ;i<pages.length;i++){
                        argsJson.folders.push(pages[i].pageIndex);
                    }
                    _pageProvider.getTpBook().done(function(ret){
                        if(ret.length > 0){
                            argsJson.data = ret;
                            exportmtbk(argsJson,fileName);
                            // var resByPages = getResByPages(pages,ret);
                            // for(var i =0;i<resByPages.length;i++){
                            //     var pageIndex = resByPages[i][0] && resByPages[i][0].pageIndex;
                            //     var xaml = _pageProvider.toPageXml(resByPages[i],pageIndex);
                            //     var xmlpath = argsJson.rootdir+ "/" + bookObj.IndexInfo.Code +"/"+pageIndex+"/"+pageIndex+".xaml";
                            //     shellcmd.saveFile(xaml,xmlpath);
                            // }
                            // for(var j = 0;j<ret.length;j++){
                            //     (function(j){
                            //         $(document).queue("copyPagesFile",function(){
                            //             var dst = argsJson.rootdir + "/" + bookObj.IndexInfo.Code + "/" + ret[j].pageIndex + "/" + ret[j].fileName+"."+ret[j].extension;
                            //             var src = path.join(path.trimPosix(Config.nwexePath), 'user/' + ebookContext.getUser().getName() + '/books/' + ret[j].bookCode + '/' + ret[j].uuid + '/' + ret[j].fileName + '.' + ret[j].extension) || "";
                            //             shellcmd.copyFileByStream(src,dst).done(function(result){
                            //                 if($(document).queue("copyPagesFile").length == 0){
                            //                     exportmtbk(argsJson,fileName);
                            //                 }else{
                            //                     $(document).dequeue("copyPagesFile");
                            //                 }
                            //             });
                            //         });
                            //     })(j); 
                            // }
                            // $(document).dequeue("copyPagesFile");
                        }else{
                            // addTipDialog(AppImportAndExportTips.ExportNoneRes);
                            parmDom.errorTip.show();
                            parmDom.errorTip.text(AppImportAndExportTips.ExportNoneRes);
                            return;
                        }
                    }).fail(function(e){
                        addTipDialog(AppImportAndExportTips.ExportFailed);
                        return;
                    });
                }
                //导出或上传
                function exportmtbk(argsJson,fileName){
                    if (!ebookContext.getUser().getIsOnline() && (isUploadChecked || isCloudUploadChecked)) {
                        if (isExportChecked) {
                            $.Zebra_Dialog(AppTips.CanExportNotUploadMsg, {
                                'type': 'question',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.CancelTips, AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {
                                        if (isExportChecked) { //选择导出本地
                                            _self._showExportDialog(fileName, argsJson, parmDom);
                                        }
                                    }
                                }
                            });
                        }else {
                            $.Zebra_Dialog(AppTips.CanNotUploadMsg, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {

                                    }
                                }
                            });
                        }
                    } else {
                        //选择导出本地,同时导出和上传好像有点问题，所以如果两者同时选中，先导出到本地在上传
                        var defer = $.Deferred();
                        //上传至畅言云
                        //之前上传至区域平台
                        if (isCloudUploadChecked && isMTBK){
                            var uploadArgsJson = {
                                exportpos: ebookContext.getSysTmpPath(),
                                bookcode: bookObj.IndexInfo.Code,
                                rootdir: path.trimPosix(_pageProvider.getUserBookBaseDir()),
                                folders: argsJson.folders,
                                filename : fileName + ".mtbk",
                                name : fileName,
                                data:argsJson.data
                            };

                            //显示上传提示信息
                            _taskQueue.clearTask();
                            var uploadUrls = [];
                            if (isCloudUploadChecked) {
                                uploadUrls.push(AppRemoteSvcCfg.uploadMTBK);
                                _taskQueue.doTask({time: 3000, status: "start", msg: AppUploadTips.UploadToCloudMsg});
                            }

                            defer.done(function () {
                                //该接口换作edc网盘接口，原接口废弃
                                // _self._uploadMTBKFile(uploadArgsJson);
                                //如果是本地导出且上传的授课包则取本地导出后的文件夹及名称
                                if(isExportChecked){
                                    uploadArgsJson.exportpos = argsJson.exportpos;
                                    uploadArgsJson.name = argsJson.name;
                                    uploadArgsJson.filename = argsJson.name + ".mtbk";
                                }
                                _self._uploadMTBKFileByEdc(uploadArgsJson,uploadInfo,isExportChecked);
                            });

                            parmDom.btnCancel.trigger("click");
                        }
                        if (isExportChecked && isMTBK) {
                            _self._showExportDialog(fileName, argsJson, parmDom, defer);
                            var action = LogManager.action.trigger;
                            var params = {};
                            params.module = '1130502';
                            var user_id = ebookContext.getUser().getUid();
                            if(user_id != '0' && user_id){
                                params.user_id =user_id;
                            }
                            LogManager.statistics(action,params);
                        }else if(!isMTBK){
                            _self._showExportTebkDialog(fileName, argsJson, parmDom, defer);
                        }
                        else defer.resolve();
                    }
                }

            }else{
                var isSelectChapter = false;
                var argsJson = {
                    exportpos: null,
                    name: null,
                    rootdir: path.trimPosix(_pageProvider.getUserBookBaseDir()),
                    bookcode: bookObj.IndexInfo.Code,
                    folders: []
                };
                var nowDate = new Date();
                var dateStamp = "" + nowDate.getFullYear() + (nowDate.getMonth() + 1) + nowDate.getDate() + nowDate.getHours() + nowDate.getMinutes();

                var index = 0, num = 0, selectUnits = [];
                var $checkboxs = $.makeArray(parmDom.divSelectBox.find(":checkbox"));

                var hereObj = getSelectPages($checkboxs, index, num, argsJson,dateStamp);
                argsJson = hereObj.argsJson;
               // selectUnits = hereObj.selectUnits;
               isSelectChapter = !!(argsJson.folders.length > 0);

                var isExportChecked = parmDom.chek_export.prop("checked");
                if(isExportChecked){
                    //temp eshop监管 linwang5@iflytek.com
                    var staticParams = {
                        uid:ebookContext._curUser._uid,
                        module:'02009',
                        type:'trigger'
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                }
                var isUploadChecked = parmDom.chek_upload.prop("checked");
                var isCloudUploadChecked = parmDom.chek_cloud_upload.prop("checked");
                if(isCloudUploadChecked){
                    //temp eshop监管 linwang5@iflytek.com
                    var staticParams = {
                        uid:ebookContext._curUser._uid,
                        module:'02010',
                        type:'trigger'
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                }

                if (!isSelectChapter) addTipDialog(AppImportAndExportTips.ExportSelectChapter);
                else if (!isExportChecked && !isUploadChecked && !isCloudUploadChecked) addTipDialog(AppImportAndExportTips.ExportWaysFailed);
                else {
                    var fileName = "授课文件-" + bookObj.IndexInfo.Title + dateStamp;
                    if (!ebookContext.getUser().getIsOnline() && (isUploadChecked || isCloudUploadChecked)) {
                        if (isExportChecked) {
                            $.Zebra_Dialog(AppTips.CanExportNotUploadMsg, {
                                'type': 'question',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.CancelTips, AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {
                                        if (isExportChecked) { //选择导出本地
                                            _self._showExportDialog(fileName, argsJson, parmDom);
                                        }
                                    }
                                }
                            });
                        }
                        else {
                            $.Zebra_Dialog(AppTips.CanNotUploadMsg, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {

                                    }
                                }
                            });
                        }
                    } else {
                        //选择导出本地,同时导出和上传好像有点问题，所以如果两者同时选中，先导出到本地在上传
                        var defer = $.Deferred();

                        //上传至畅言云
                        //之前上传至区域平台
                        if (isCloudUploadChecked && isMTBK){
                            var uploadArgsJson = {
                                exportpos: ebookContext.getSysTmpPath(),
                                bookcode: bookObj.IndexInfo.Code,
                                rootdir: path.trimPosix(_pageProvider.getUserBookBaseDir()),
                                folders: argsJson.folders,
                                filename : bookObj.IndexInfo.Title + dateStamp + ".mtbk",
                                name : bookObj.IndexInfo.Title + dateStamp
                            };

                            //显示上传提示信息
                            _taskQueue.clearTask();
                            var uploadUrls = [];
                            if (isCloudUploadChecked) {
                                uploadUrls.push(AppRemoteSvcCfg.uploadMTBK);
                                _taskQueue.doTask({time: 3000, status: "start", msg: AppUploadTips.UploadToCloudMsg});
                            }

                            defer.done(function () {
                                //该接口换作edc网盘接口，原接口废弃
                                // _self._uploadMTBKFile(uploadArgsJson);
                                _self._uploadMTBKFileByEdc(uploadArgsJson);
                            });

                            parmDom.btnCancel.trigger("click");
                        }

                        //TODO:此处需要增加导出成班班通支持的tebk格式功能，由于此功能只是个过渡性功能，后期可能废除，所以此处不想把代码合并到一起


                        if (isExportChecked && isMTBK) {
                            _self._showExportDialog(fileName, argsJson, parmDom, defer);
                            var action = LogManager.action.trigger;
                            var params = {};
                             params.module = '1130502';
                            var user_id = ebookContext.getUser().getUid();
                            if(user_id != '0' && user_id){
                                params.user_id =user_id;
                            }
                            LogManager.statistics(action,params);
                        }else if(!isMTBK){
                            _self._showExportTebkDialog(fileName, argsJson, parmDom, defer);
                        }
                        else defer.resolve();

                       // //选择上传至区域平台
                       // if (isUploadChecked || isCloudUploadChecked) {
                       //     var uploadArgsJson = {
                       //         exportpos: ebookContext.getSysTmpPath(),//path.trimPosix(path.join(Config.binPath, "temp")),
                       //         bookcode: bookObj.IndexInfo.Code,
                       //         rootdir: path.trimPosix(_pageProvider.getUserBookBaseDir()),
                       //         chapters: []
                       //     };
                       //     var j = 0, lastStartCode = 0 , lastEndCode = 0;
                       //     for (var i = 0, len = selectUnits.length; i < len; ++i) {
                       //         //单元内课时与课时之前的页数放到下一个课时内进行打包
                       //         if (selectUnits[i].courseCode != "-1") {
                       //             if (i + 1 < len && selectUnits[i + 1].courseCode != "-1" && selectUnits[i].unitCode === selectUnits[i + 1].unitCode) {
                       //                 selectUnits[i].page[1] = selectUnits[i + 1].page[0] - 1;
                       //             } else if (lastEndCode) {
                       //                 selectUnits[i].page[1] = lastEndCode;
                       //                 lastEndCode = 0;
                       //             }
                       //         }
                       //         if (selectUnits[i].page[0] > selectUnits[i].page[1])
                       //             continue;
                       //         //打包成课时
                       //         if (selectUnits[i].courseCode != "-1") {
                       //             //修正该课时的起始页
                       //             if (lastStartCode) selectUnits[i].page[0] = lastStartCode;
                       //             lastStartCode = 0;
                       //         } else {  //打包成单元
                       //             //如果该单元包含课时，那么它会和第一个课时一起打包，先标记该单元的起始页
                       //             if (i + 1 < len && selectUnits[i + 1].courseCode != "-1" && selectUnits[i].unitCode === selectUnits[i + 1].unitCode) {
                       //                 lastStartCode = selectUnits[i].page[0];
                       //                 lastEndCode = selectUnits[i].page[1];
                       //                 continue;
                       //             }
                       //             else  lastStartCode = 0;
                       //         }
                       //         uploadArgsJson.chapters[j++] = {
                       //             //非法字符都替换成_
                       //             name: selectUnits[i].name,
                       //             page: (function (i) {
                       //                 var end = selectUnits[i].page.length > 1 ? selectUnits[i].page[1] : selectUnits[i].page[0];
                       //                 var start = selectUnits[i].page[0];
                       //                 var str = "";
                       //                 while (start <= end) {
                       //                     str += start++;
                       //                     if (start <= end) str += "|";
                       //                 }
                       //                 return str;
                       //             })(i),
                       //             unit: selectUnits[i].unitCode,
                       //             course: selectUnits[i].courseCode
                       //         };
                       //     }
                       //     //显示上传提示信息
                       //     _taskQueue.clearTask();

                       //     var uploadUrls = [];

                       //     if (isCloudUploadChecked) {
                       //         uploadUrls.push(AppRemoteSvcCfg.uploadMTBK);

                       //         _taskQueue.doTask({time: 3000, status: "start", msg: AppUploadTips.UploadToCloudMsg});
                       //     }

                       //     defer.done(function () {
                       //         _self._uploadTekbFile(uploadArgsJson, uploadUrls);
                       //     });

                       //     parmDom.btnCancel.trigger("click");
                       // }
                    }
                }
                event.stopPropagation();

               //  监管
               // var action = LogManager.action.trigger;
               // var params = {};
               // params.module = '1130502';
               // var user_id = ebookContext.getUser().getUid();
               // if(user_id != '0' && user_id){
               //     params.user_id =user_id;
               // }
               // LogManager.statistics(action,params);
            }
        });
    }
    //存至备课本 dom为重命名弹框
    ExportRes.prototype.saveTPToPre = function(fileName,dom){
        var _self = this;
        fileName = fileName.replace(/[\/\\\*\:\?\"\<\>\|]/g,"")
        var basePath = process.env.TEMP.replace(/\\/g, "/") + "/mtbk_" +Date.now();
        var bookObj = _pageProvider.bookObj;
        var argsJson = {
            exportpos: path.trimPosix(basePath),
            name: fileName,
            rootdir: path.trimPosix(basePath),
            bookcode: bookObj.IndexInfo.Code,
            folders: []
        };
        //当前页的信息
        var pageIndex = app_global_bookContainer.getPageIndex();
        var obj = _pageProvider.getPageMetadata(pageIndex);

        var pages = bookObj.pages.filter(function(el){
            return el.unit1==obj.unit1 && el.unit2==obj.unit2 && el.unit3==obj.unit3 && el.unit4==obj.unit4;
        });
        for(var i =0 ;i<pages.length;i++){
            argsJson.folders.push(pages[i].pageIndex);
        }
        _pageProvider.getTPUnit(obj).done(function(ret){
            if(ret.length > 0){
                dom.find("#resetname_yes").removeAttr("disabled");
                dom.hide();
                var tips = tipsDialog({
                    "id":"mtbksave" + new Date().getTime(),
                    "content":"授课包保存中..."
                });
                var p ={
                    dbfiles:ret,
                    fileName:argsJson.name
                }
                _pageProvider.exportMtbk(p).done(function(result){
                    var filePath = result.data;
                    //这里转义一下是为了hprose服务中拷贝成功 by njfu
                    filePath =  filePath.replace(/\\/g,"/");
                    var user = ebookContext.getUser();
                    var p = {
                        userName:user.getName() || "",
                        bookCode:bookObj.IndexInfo.Code || "",
                        path:filePath,
                        fileName:(argsJson.name + ".mtbk") || "未知文件",
                        unit1:obj.unit1 || "",
                        unit2:obj.unit2 || "",
                        unit3:obj.unit3 || "",
                        unit4:obj.unit4 || "",
                        uuid:"",
                        creator:user.getUserName() || "畅言教育",
                        uploader:user.getUserName() || "畅言教育",
                        widgetType:"mtbk",
                        title:argsJson.name || ""
                    }
                    _pageProvider.addMTBKFile(p).done(function(ret){
                        if(ret && ret.code == 1){
                            var tips = tipsDialog({
                                "id":"mtbksave" + new Date().getTime(),
                                "content":"<span class='success_box_right'></span>授课包保存成功"
                            });
                        }else{
                            var tips = tipsDialog({
                                "id":"mtbksave" + new Date().getTime(),
                                "content":"授课包保存失败"
                            });
                        }
                    }).fail(function(e){
                        var tips = tipsDialog({
                            "id":"mtbksave" + new Date().getTime(),
                            "content":"授课包保存失败"
                        });
                    });
                }).fail(function(e){
                    var tips = tipsDialog({
                        "id":"mtbksave" + new Date().getTime(),
                        "content":"授课包保存失败"
                    });
                    console.log("授课包打包失败");
                });
                // var resByPages = getResByPages(pages,ret);

                // for(var i =0;i<resByPages.length;i++){
                //     var pageIndex = resByPages[i][0] && resByPages[i][0].pageIndex;
                //     var xaml = _pageProvider.toPageXml(resByPages[i],pageIndex);
                //     var xmlpath = argsJson.rootdir+ "/" + bookObj.IndexInfo.Code +"/"+pageIndex+"/"+pageIndex+".xaml";
                //     shellcmd.saveFile(xaml,xmlpath);
                // }
                // for(var j = 0;j<ret.length;j++){
                //     (function(j){
                //         $(document).queue("copyPagesFile",function(){
                //             var user = ebookContext.getUser();
                //             var dst = argsJson.rootdir + "/" + bookObj.IndexInfo.Code + "/" + ret[j].pageIndex + "/" + ret[j].fileName+"."+ret[j].extension;
                //             var src = path.join(path.trimPosix(Config.nwexePath), 'user/' + user.getName() + '/books/' + ret[j].bookCode + '/' + ret[j].uuid + '/' + ret[j].fileName + '.' + ret[j].extension) || "";
                //             shellcmd.copyFileByStream(src,dst).done(function(result){
                //                 if($(document).queue("copyPagesFile").length == 0){
                //                     shellcmd.resExport(JSON.stringify(argsJson)).done(function (ret) {
                //                         if(ret){
                //                             var filePath = (argsJson.exportpos + '/' + argsJson.name + '.mtbk') || "";
                //                             var p = {
                //                                 userName:user.getName() || "",
                //                                 bookCode:bookObj.IndexInfo.Code || "",
                //                                 path:filePath,
                //                                 fileName:(argsJson.name + ".mtbk") || "未知文件",
                //                                 unit1:obj.unit1 || "",
                //                                 unit2:obj.unit2 || "",
                //                                 unit3:obj.unit3 || "",
                //                                 unit4:obj.unit4 || "",
                //                                 uuid:"",
                //                                 creator:user.getUserName() || "畅言教育",
                //                                 uploader:user.getUserName() || "畅言教育",
                //                                 widgetType:"mtbk",
                //                                 title:argsJson.name || ""
                //                             }
                //                             _pageProvider.addMTBKFile(p).done(function(ret){
                //                                 if(ret && ret.code == 1){
                //                                     var tips = tipsDialog({
                //                                         "id":"mtbksave" + new Date().getTime(),
                //                                         "content":"<span class='success_box_right'></span>授课包保存成功"
                //                                     });
                //                                 }else{
                //                                     var tips = tipsDialog({
                //                                         "id":"mtbksave" + new Date().getTime(),
                //                                         "content":"授课包保存失败"
                //                                     });
                //                                 }
                //                             }).fail(function(e){
                //                                 var tips = tipsDialog({
                //                                     "id":"mtbksave" + new Date().getTime(),
                //                                     "content":"授课包保存失败"
                //                                 });
                //                             });
                //                         }else{
                //                             var tips = tipsDialog({
                //                                 "id":"mtbksave" + new Date().getTime(),
                //                                 "content":"授课包保存失败"
                //                             });
                //                         }
                //                     });
                //                 }else{
                //                     $(document).dequeue("copyPagesFile");
                //                 }
                //             }).fail(function(e){
                //                 var tips = tipsDialog({
                //                     "id":"mtbksave" + new Date().getTime(),
                //                     "content":"授课包保存失败"
                //                 });
                //             });
                //         });
                //     })(j); 
                // }
                // $(document).dequeue("copyPagesFile");
            }else{
                dom.find("#resetname_yes").removeAttr("disabled");
                dom.find(".errorTip").show();
                dom.find(".errorTip").text(AppImportAndExportTips.ExportNoneRes);
                // addTipDialog(AppImportAndExportTips.ExportNoneRes);
                return;
            }
        }).fail(function(e){
            dom.find("#resetname_yes").removeAttr("disabled");
            dom.hide();
            var tips = tipsDialog({
                "id":"mtbksave" + new Date().getTime(),
                "content":"授课包保存失败"
            });
        });

    }

    ExportRes.prototype._showExportDialog = function (fileName, argsJson, parmDom, defer) {
        var _self = this;
        var _fileExt = path.extname(fileName);
        if (_fileExt != ".mtbk")
            fileName += ".mtbk";
        shellcmd.saveFileDialog(fileName, ".mtbk").done(function (ret) {
            var pathRes = "";
            if (ret && ret.length > 0) {
                pathRes = ret[0];
            }
            else return;
            pathRes = pathRes.replace(/\\/g, "\/");
            if (path.extname(pathRes) != ".mtbk") {
                pathRes += ".mtbk";
                shellcmd.isFileExist(pathRes).done(function (ret) {
                    if (ret) {
                        addTipDialog(AppImportAndExportTips.ExportPathRepeat, [AppTips.CancelTips, AppTips.OkTips], function (capition) {
                            if (capition == AppTips.OkTips) {
                                _self._showExportDialogHelper(pathRes,argsJson,parmDom,defer);
                            }
                        });
                    }
                    else {
                        _self._showExportDialogHelper(pathRes,argsJson,parmDom,defer);
                    }
                })
            }
            else {
                _self._showExportDialogHelper(pathRes,argsJson,parmDom,defer);
            }
        });
    }

    /**
     * 与上面函数功能大致相同，由于过渡性功能，暂时不想把代码写在一起
     * @param fileName
     * @param argsJson
     * @param parmDom
     * @param defer
     * @private
     */
    ExportRes.prototype._showExportTebkDialog = function (fileName, argsJson, parmDom, defer) {
        var _self = this;
        var _fileExt = path.extname(fileName);
        if (_fileExt != ".tebk")
            fileName += ".tebk";
        shellcmd.saveFileDialog(fileName, ".tebk").done(function (ret) {
            var pathRes = "";
            if (ret && ret.length > 0) {
                pathRes = ret[0];
            }
            else return;
            pathRes = pathRes.replace(/\\/g, "\/");
            if (path.extname(pathRes) != ".tebk") {
                pathRes += ".tebk";
                shellcmd.isFileExist(pathRes).done(function (ret) {
                    if (ret) {
                        addTipDialog(AppImportAndExportTips.ExportPathRepeat, [AppTips.CancelTips, AppTips.OkTips], function (capition) {
                            if (capition == AppTips.OkTips) {
                                _self._showExportTebkDialogHelper(pathRes,argsJson,parmDom,defer);
                            }
                        });
                    }
                    else {
                        _self._showExportTebkDialogHelper(pathRes,argsJson,parmDom,defer);
                    }
                })
            }
            else {
                _self._showExportTebkDialogHelper(pathRes,argsJson,parmDom,defer);
            }
        });
    }

    ExportRes.prototype._showExportDialogHelper = function(pathRes,argsJson,parmDom,defer){
        var _self = this;
        var index = pathRes.lastIndexOf('/');
        var title = pathRes.substring(index + 1, pathRes.lastIndexOf('.')).trim();
        var dir = pathRes.substring(0, index).trim();
        argsJson.exportpos = path.toPosix(dir);
        argsJson.name = title;
        _self._exportTebkFile(argsJson, defer);
        parmDom.btnCancel.trigger("click");
    }
    //数组资源按页分组
    function getResByPages(pages,list){
        var pagesResList = [];
        if(pages.length>0){
            for(var i =0;i<pages.length;i++){
                var reses = list.filter(function(el){
                    return el.pageIndex == pages[i].pageIndex;
                });
                if(reses.length>0){
                    pagesResList.push(reses);
                }  
            }
        }
        return pagesResList;
    }

    /**
     * 与上面函数功能大致相同，由于过渡性功能，暂时不想把代码写在一起
     * @param pathRes
     * @param argsJson
     * @param parmDom
     * @param defer
     * @private
     */
    ExportRes.prototype._showExportTebkDialogHelper = function(pathRes,argsJson,parmDom,defer){
        var _self = this;
        var index = pathRes.lastIndexOf('/');
        var title = pathRes.substring(index + 1, pathRes.lastIndexOf('.')).trim();
        var dir = pathRes.substring(0, index).trim();
        argsJson.exportpos = path.toPosix(dir);
        argsJson.name = title;
        _self._exportBBTTebkFile(argsJson, defer);
        parmDom.btnCancel.trigger("click");
    }

    function addTipDialog(tips, buttons, callback) {
        if (!tips) return;
        $.Zebra_Dialog(tips, {
            'type': 'information',
            'title': AppTips.WarmTips,
            'buttons': buttons == undefined ? [AppTips.OkTips] : buttons,
            'onClose': function (caption) {
                if (typeof callback === 'function') callback(caption);
            }
        });
    }

    function getSelectPages($checkboxs, index, num, argsJson,dateStamp) {
        var isSelectChapter, selectUnits = [];
        $.each($checkboxs, function (i, e) {
            var element = $(e);
            if (element.prop("checked")) {
                isSelectChapter = true;
                var pageIndex = parseInt(element.attr("Start"));
                var pageIndexEnd = parseInt(element.attr("End"));
                var pages = [pageIndex, pageIndexEnd];
//                var name = element.siblings(".text").text().replace(/[\/\\":<>\?\*]/g, "_").replace(/_+/g, '_');
                var name = element.parent().text().replace(/[\/\\":<>\?\*]/g, "_").replace(/_+/g, '_').trim();

                // TODO ： 这块没弄懂是要干啥
//                selectUnits[num++] = {
//                    unitCode: element.attr("data-unitcode"),
//                    courseCode: element.attr("data-coursecode"),
//                    name: name + "_" + dateStamp,
//                    page: pages
//                };

                //拼接导出或上传的页码范围
                var start = pages[0], end = pages[1];
                if (start && end) {
                    do {
                        argsJson.folders[index++] = "" + start;
                        ++start;
                    } while (end && start <= end)
                }
            }
        });
        return {
            argsJson : argsJson
//            selectUnits: selectUnits ,
//            isSelectChapter : isSelectChapter
        }
    }

    ExportRes.prototype.onMessageReceived = function (obj) {
        //mtbk文件上传
        if (obj.evt == "ifb_mtbk_upload") {
            var process = obj.process;
            var index = obj.raw_data.index;
            //结果处理
            if(100 - process > 0) {
                var tips = tipsDialog({
                    "id":"shareing" + new Date().getTime(),
                    "content":"授课包上传中..."
                });
            }
            if(100 - process > 100) {
                var tips =  tipsDialog({
                    "id":"sharefail" + new Date().getTime(),
                    "content":"授课包上传失败"
                });
                return 0;
            }
            if(100 - process == 0){
                var _edc_file_upload_complete_request = obj.raw_data.edc_file_upload_complete_request;
                var _edc_file_add_request = obj.raw_data.edc_file_add_request;
                edcService.Instance().pan_file_upload_complete(_edc_file_upload_complete_request).done(function (ret) {
                    if (ret && ret.code == 0) {
                        var complate_result = ret.data;
                        //传到云备课
                        _edc_file_add_request['contextId'] = complate_result.contextId;
                        _edc_file_add_request['url'] = complate_result.url;
                        _edc_file_add_request['status'] = complate_result.status;
                        edcService.Instance().beike_file_add(_edc_file_add_request,{type:"POST"}).done(function(ret){
                            if (ret && ret.code == 0) {
                                var fileId = ret.data.fileId;
                                if(fileId != "") {
                                    //上传网盘成功
                                    var tips = tipsDialog({
                                        "id": "sharesucess" + new Date().getTime(),
                                        "content": '<span class="success_box_right"></span>授课包上传成功'
                                    });
                                }
                            }else{
                                //上传网盘失败
                                console.log(ret);
                                var tips =  tipsDialog({
                                    "id":"sharefail" + new Date().getTime(),
                                    "content":"授课包上传失败"
                                });
                            }
                        }).fail(function(e){
                            var tips =  tipsDialog({
                                "id":"sharefail" + new Date().getTime(),
                                "content":"授课包上传失败"
                            });
                            console.log(e);
                        });
                    }else {
                        console.log(ret);
                        var tips =  tipsDialog({
                            "id":"sharefail" + new Date().getTime(),
                            "content":"授课包上传失败"
                        });
                    }
                }).fail(function (e) {
                    console.log(e);
                    var tips =  tipsDialog({
                        "id":"sharefail" + new Date().getTime(),
                        "content":"授课包上传失败"
                    });
                });
            }
        }
    }

    //构建4级目录
    function structMenu(bookMenu) {
        var MenuStr = '<ul>';
        var Unit1 = bookMenu;
        var i = 0, len1 = Unit1.length;
        for (i = 0; i < len1; i++) {
            MenuStr += structUnit1(Unit1[i]);
        }
        MenuStr += "</ul>";
        return MenuStr;
    }

    //构建第一级目录
    function structUnit1(Unit1Data) {
        var Unit1Tpl = '<li><input type="checkbox" Unit1="{{Unit1}}" Start="{{Start}}" End="{{End}}">&nbsp;{{Unit1Name}}<div style="float:right">{{pageCode}}</div>{{Unit2Str}}</li>';
        var Unit2Str = "";
        var i, len;
        if (Unit1Data.unit2) {
            for (i = 0, len = Unit1Data.unit2.length; i < len; i++) {
                Unit2Str += structUnit2(Unit1Data.unit2[i]);
            }
            Unit1Tpl = Unit1Tpl.replace("{{Start}}", "")
                .replace("{{End}}", "");
        }
        else {
            Unit1Tpl = Unit1Tpl.replace("{{Start}}", Unit1Data.pages[0].index)
                   .replace("{{End}}", Unit1Data.pages[Unit1Data.pages.length - 1].index);

        }
        return Unit1Tpl.replace("{{Unit1}}", Unit1Data.code)
            .replace("{{Unit1Name}}", Unit1Data.name)
            .replace("{{Unit2Str}}", Unit2Str)
            .replace("{{pageCode}}",Unit1Data.pageStart);
    }

    //构建第二级目录
    function structUnit2(Unit2Data) {
        var Unit2Tpl = '<div class="exmtbkdiv"><input type="checkbox" Unit2="{{Unit2}}" Start="{{Start}}" End="{{End}}">&nbsp;{{Unit2Name}}<div style="float:right">{{pageCode}}</div>{{Unit3Str}}</div>';
        var Unit3Str = "";
        var i, len;
        if (Unit2Data.unit3) {
            for (i = 0, len = Unit2Data.unit3.length; i < len; i++) {
                Unit3Str += structUnit3(Unit2Data.unit3[i]);
            }
            Unit2Tpl = Unit2Tpl.replace("{{Start}}", "")
                .replace("{{End}}", "");
        }
        else {
            Unit2Tpl = Unit2Tpl.replace("{{Start}}", Unit2Data.pages[0].index)
                .replace("{{End}}", Unit2Data.pages[Unit2Data.pages.length - 1].index);

        }
        return Unit2Tpl.replace("{{Unit2}}", Unit2Data.code)
            .replace("{{Unit2Name}}", Unit2Data.name)
            .replace("{{Unit3Str}}", Unit3Str)
            .replace("{{pageCode}}",Unit2Data.pageStart);
    }

    //构建第三级目录
    function structUnit3(Unit3Data) {
        var Unit3Tpl = '<div class="exmtbka"><input type="checkbox" Unit3="{{Unit3}}"  Start="{{Start}}" End="{{End}}">&nbsp;{{Unit3Name}}<div style="float:right">{{pageCode}}</div>{{Unit4Str}}</div>';
        var Unit4Str = "";
        var i, len;
        if (Unit3Data.unit4) {
            for (i = 0, len = Unit3Data.unit4.length; i < len; i++) {
                Unit4Str += structUnit4(Unit3Data.unit4[i]);
            }
            Unit3Tpl = Unit3Tpl.replace("{{Start}}", "")
                .replace("{{End}}", "");
        }
        else {
            Unit3Tpl = Unit3Tpl.replace("{{Start}}", Unit3Data.pages[0].index)
                .replace("{{End}}", Unit3Data.pages[Unit3Data.pages.length - 1].index);

        }
        return Unit3Tpl.replace("{{Unit3}}", Unit3Data.code)
            .replace("{{Unit3Name}}", Unit3Data.name)
            .replace("{{Unit4Str}}", Unit4Str)
            .replace("{{pageCode}}",Unit3Data.pageStart);
    }

    //构建第四级目录
    function structUnit4(Unit4Data) {
        var Unit4Tpl = '<div class="exmtbkc"><input type="checkbox" Unit4="{{Unit4}}"  Start="{{Start}}" End="{{End}}">&nbsp;{{Unit4Name}}<div style="float:right">{{pageCode}}</div></div>';
        return Unit4Tpl.replace("{{Unit4}}", Unit4Data.code)
            .replace("{{Unit4Name}}", Unit4Data.name)
            .replace("{{Start}}", Unit4Data.pages[0].index)
            .replace("{{End}}", Unit4Data.pages[Unit4Data.pages.length - 1].index)
            .replace("{{pageCode}}",Unit4Data.pageStart);
    }

    exports.Instance = new ExportRes();
});


//        var bookMenu = _pageProvider.bookMenu;
//        var dir = '<ul>';
//        var templateCheck = '<input style="margin: 0px 5px 0px 0px;float: left" type="checkbox" data-pageindex={0} data-pageindexend={1} data-unitcode={2} data-coursecode={3}>';
//        var templateTitle = '<div class="text" style="float:left">{0}</div>';
//        var templatePageCode = '<div class="page" style="float: right" data-pageindex={0} data-pageindexend={1} data-unitcode={2} data-coursecode={3}>{4}</div><div class="clear"></div>';
//        for (var i = 0; i < bookMenu.length; i++) {
//            var itemUnit = '<li class="unit" >';
//            if (bookMenu[i].pageIndex == '-1') {
//                itemUnit += templateCheck.format(bookMenu[i + 1].pageIndex, bookMenu[i + 1].pageIndex, bookMenu[i].unitCode, "-1");
//            } else {
//                itemUnit += templateCheck.format(bookMenu[i].pageIndex, bookMenu[i].pageIndexEnd, bookMenu[i].unitCode, "-1");
//            }
//            itemUnit += templateTitle.format(bookMenu[i].title);
//            if (bookMenu[i].pageIndex == '-1') {
//                itemUnit += templatePageCode.format(bookMenu[i + 1].pageIndex, bookMenu[i + 1].pageIndex, bookMenu[i].unitCode, "-1", bookMenu[i].pageCode);
//            } else {
//                itemUnit += templatePageCode.format(bookMenu[i].pageIndex, bookMenu[i].pageIndexEnd, bookMenu[i].unitCode, "-1", bookMenu[i].pageCode);
//            }
//            dir += itemUnit;
//            if (bookMenu[i].courses) {
//                var courses = $.makeArray(bookMenu[i].courses);
//                if (courses.length > 0) {
//                    dir += '<ul class="course">';
//                    for (var k = 0; k < courses.length; ++k) {
//                        var pageIndex = parseInt(courses[k].ImageIndex);
//                        var pageIndexEnd = parseInt(courses[k].PageCodeEnd) - parseInt(courses[k].PageCode) + pageIndex;
//                        var itemCourse = '<li class="unit">';
//                        itemCourse += templateCheck.format(pageIndex, pageIndexEnd, bookMenu[i].unitCode, courses[k].Code);
//                        itemCourse += templateTitle.format(courses[k].Name);
//                        itemCourse += templatePageCode.format(pageIndex, pageIndexEnd, bookMenu[i].unitCode, courses[k].Code, courses[k].PageCode);
//                        itemCourse += '</li>'
//                        dir += itemCourse;
//                    }
//                    dir += '</ul>';
//                }
//            }
//            dir += '</li>';
//        }
//        dir += '</ul>';
//        var $directory = exportBookResContent.find(".sel");
//        $directory.html(dir);
