/**
 * Created with JetBrains WebStorm.
 * User: kaiyi
 * Date: 16-10-20
 * Time: 下午4:06
 * this file is used for pdfbooks
 */
;
define(function (require, exports) {
    var ebookContext = require('../../ebookcontext').Instance;
    var path = require('../../../common/path');
    var _recommendRes = require('../resbar/recommendresource').Instance;
    var pageprovider=require('../pageprovider').Instance;
    var shellcmd = require('../../../common/shellcmd');


    function Pdfbook() {
        var _self=this;
        var _curpageIndex;//当前pageindex,pdf书中的index,认为是不正确的
        var _pageIndex;//查询接口，用户选择的pageIndex（认为是正确的pageIndex）
        var _pageCode;//查询接口，用户选择的pageCode（认为是正确的pageCode）
        var dirStr;//当前pdf所在文件夹
        _self.container=null;//container对象
        var similarPageItem='<li>'
           + '<div class="jxpop-comtit"><input type="radio" id="{pageId}" name="pageList" pageindex="{pageIndex}" pagecode="{pageCode}" bookname="{bookName}" bookcode="{pageBookCode}" ' +
            ' class="regular-radio" thumbnail="{thumbnail}" />'
           + '<label for="{pageId}"></label>{bookName}第{pageCode}页</div>'
           + '<div class="jxpop-comsim">图像相似度<span class="{color}">{score}%</span></div>'
           + '</li>'


        //“智能识别”按钮
        $("#pdfIdentbutton").on('click',function(){
            // _curpageIndex= _recommendRes.bookContainer.getPageIndex();
            // _curpageIndex= _self.container.getPageIndex()
            _curpageIndex = app_global_bookContainer.getPageIndex();
            _self.getBookList(_curpageIndex);
            $("#recognizingPDF").show();
        });

        //相似书页列表框：右上角的x
        $("#pdfIdentResult .jxpop-tab p a").bind('click',function(){
            $("#pdfIdentResult").hide();
        });

        //相似书页列表框： 取消按钮
        $("#pdfIdentResult .jxpop-btnbar .btn-gray").bind('click',function(){
            $("#pdfIdentResult").hide();
        });

        //相似书页列表框：确定按钮
        $("#pdfIdentResult .jxpop-btnbar .btn-blue").bind('click',function(){
            var length=$("#pdfIdentResult input:radio:checked").length;
            if(length==0){
                showAlertTips("请选择相似页面");
            }else{
                $("#pdfIdentResult").hide();
                _pageCode=$("#pdfIdentResult input:radio:checked")[0].getAttribute("pagecode");
                _pageIndex=$("#pdfIdentResult input:radio:checked")[0].getAttribute("pageindex");
                app_global_pdfInfo.similarBookCode= $("#pdfIdentResult input:radio:checked")[0].getAttribute("bookcode");
                app_global_pdfInfo.similarBookName=$("#pdfIdentResult input:radio:checked")[0].getAttribute("bookname");
                _self.rewriteBookMenu();
            }
        });

        //请求失败框：确认按钮
        $("#pdfNotfoundSimilarImg .jxpop-btnbar .btn-blue").bind("click",function(){
            $("#pdfNotfoundSimilarImg").hide();
        })
        //请求失败框：右上角x
        $("#pdfNotfoundSimilarImg .jxpop-tab a").bind("click",function(){
            $("#pdfNotfoundSimilarImg").hide();
        })

        //提示书本框，右上角的x
        $("#showSimilarBookName .jxpop-tab a").on("click",function(){
            $("#showSimilarBookName").hide();
        })

        //提示书本框，确认按钮
        $("#showSimilarBookName .jxpop-btnbar .btn-blue").on("click",function(){
            $("#showSimilarBookName").hide();
        });

        _self.init = function(container){
            _self.container=container;
        }

        //查询相似书页信息，回调
        _self.getBookList=function(pageIndex){
            //获取当前页图片地址
            //这里有个问题需要注意：app_global_bookContainer.bookCode中保存的是pdf_000001这个东西，这是pdf文件名称
            dirStr= path.join(ebookContext._binPath,"/users",ebookContext._curUser._name,"/ebook/",app_global_bookContainer.bookCode);
            var imgName=_self.getCurPageImgName(pageIndex);
            if(dirStr.indexOf("file:/")!=-1){
                // 截去"file:/"
                dirStr=dirStr.substring(6);
            }
            var imgStr=path.join(dirStr,imgName);
            _self.getSimilarPageList(imgStr,pageIndex).done(function(ret){
                $("#recognizingPDF").hide();
                if(ret&&ret.length>0){
                    //展示加载资源确认框并绑定全局变量
                    // pdfIdentResultConfirm显示并修改内容，绑定全局变量
                    _pageIndex=ret[0].bookInfo.pageIndex||3;//todo 记得！！！！这里设置默认值3是因为服务器中数据还没录入完整，记得删除！！！！
                    _pageCode=ret[0].bookInfo.pageCode||3;//todo 记得！！！！这里设置默认值3是因为服务器中数据还没录入完整，记得删除！！！！
                    var _bookInfo=ret[0].bookInfo;
                    var _score=ret[0].score.toFixed(0);
                    //todo
                    if(_bookInfo&&_pageIndex&&_score>0){
                        //展示提示语
                        $("#pdfIdentResult").show();
                        $("#pdfIdentResult .fl.tips-text span")[0].innerHTML=
                            "《"+ ret[0].bookInfo.bookName+"》第"+ _pageCode +"页，";
                        //展示缩略图
                        var _imagePath=ret[0].imagePath;
                        var _thumbnailPath=_imagePath.replace("image","thumb_image");
                        var thumbnailurl=TulinPDFSvc.TUNI_BASE_URL+_thumbnailPath;
                        $("#pdfIdentResult .fl.tips-img img").attr("src",thumbnailurl);
                        // 绑定相似书页列表
                        $("#pdfIdentResult .jxpop-main ul").children('li').remove();
                        for(var i=0;i<ret.length;i++){
                            var curbookInfo=ret[i].bookInfo;
                            var bookcode=curbookInfo.bookCode;
                            var pageIndex=curbookInfo.pageIndex?curbookInfo.pageIndex:"";
                            var pageCode=curbookInfo.pageCode?curbookInfo.pageCode:"3";//todo  记得！！！！这里设置默认值3是因为服务器中数据还没录入完整，记得删除！！！！
                            var bookName=curbookInfo.bookName;
                            var score=ret[i].score.toFixed(0);
                            var imagePath=ret[i].imagePath;
                            var thumbnailPath=imagePath.replace("image","thumb_image");
                            var thumbnail=TulinPDFSvc.TUNI_BASE_URL+thumbnailPath;
                            if(pageIndex&&pageCode){
                                var _similarPageItem=similarPageItem.replace("{pageId}",i)//pageId只是为了保证input框的id和label的for属性一致
                                    .replace("{pageBookCode}",bookcode)
                                    .replace("{pageId}",i)
                                    .replace("{bookName}",bookName)
                                    .replace("{bookName}",bookName)
                                    .replace("{pageCode}",pageCode)
                                    .replace("{pageIndex}",pageIndex)
                                    .replace("{pageCode}",pageCode)
                                    .replace("{thumbnail}",thumbnail)
                                    .replace("{score}",score);
                                //如果相似度在50以上，显示为蓝色，否则为红色
                                if(Number(score)>49){
                                    _similarPageItem=_similarPageItem.replace("{color}","blue");
                                }else{
                                    _similarPageItem=_similarPageItem.replace("{color}","red");
                                }
                                $("#pdfIdentResult .jxpop-main ul").append(_similarPageItem);
                            }else{
                                console.log("用户选择的图片绑定信息不正确");
                            }
                        }
                        $($("#pdfIdentResult input")[0]).prop("checked",true);
                        //绑定点击radio事件，动态加载缩略图和文字提示
                        $("#pdfIdentResult .jxpop-comtit input").on("click",function(){
                            var curthunmbnail=this.getAttribute("thumbnail");
                            var curbookname=this.getAttribute("bookname");
                            var curbookcode=this.getAttribute("pagecode");
                            $("#pdfIdentResult .fl.tips-img img").attr("src",curthunmbnail);
                            $("#pdfIdentResult .fl.tips-text span")[0].innerHTML=
                                "《"+ curbookname+"》第"+ curbookcode +"页，";
                        })
                    }else{
                        //图片库中没有相似图片
                        $("#pdfNotfoundSimilarImg").show();
                    }
                }else{
                    //请求不到数据，提示失败
                    $("#pdfNotfoundSimilarImg").show();
                }
            }).fail(function(){
                //请求接口失败，提示失败
                $("#pdfNotfoundSimilarImg").show();
                $("#recognizingPDF").hide();
                console.log("查询相似书本信息失败！")
            });
        };

        //调用接口查询相似书页列表,
        _self.getSimilarPageList = function (filePath) {
            var def = $.Deferred();
            var result={};
            var filePath=filePath;
            var service = tunicornService.Instance();
            //开始请求接口时的index
            service.getAccessToken().done(function(ret){
                service.searchSimilarImg(filePath,ret).done(function (retsult) {
                    if(retsult.flag){
                        result=retsult.result.results;
                        if(result.length>5){
                            result=result.slice(0,5);
                        }
                        def.resolve(result);
                    }
                });
            })
            return def.promise();
        };

        //获取当前页面对应的图片url
        _self.getCurPageImgName=function (pageIndex){
            //pdf图片的保存格式为“pdf-00000xx.jpg”,中间数字固定6位
            var ImgNum=pageIndex+"";
            var length=ImgNum.length;
            switch(length){
                default:
                    ImgNum="000001";//如果传入的pageIndex有误，至少保证能打开第一页图片
                case 1:
                    ImgNum="00000"+ImgNum;
                    break;
                case 2:
                    ImgNum="0000"+ImgNum;
                    break;
                case 3:
                    ImgNum="000"+ImgNum;
                    break;
                case 4:
                    ImgNum="00"+ImgNum;
                    break;
                case 5:
                    ImgNum="0"+ImgNum;
                    break;
                case 6:
                    ImgNum=ImgNum;
                    break;
            }
            var ImgName="pdf-"+ImgNum+".jpg";
            return ImgName;
        }

        //使用递归方法将menu对象下的所有index重新设置
        _self.setMenuIndex = function(obj,differNum){
            for(var item in obj){
                if(item.indexOf("index")!=-1){
                    obj[item]=Number(obj[item])+differNum;
                };
                //如果属性的值是个对象的话，递归请求
                if(typeof (obj[item][0])=="object"){
                    for(var i=0;i<obj[item].length;i++){
                        _self.setMenuIndex(obj[item][i],differNum);
                    }
                }
            }
        }

        //重写书本目录信息
        _self.rewriteBookMenu = function(){
            shellcmd.isFileExist(pageprovider.getBookDirectory()).done(function (ret) {
                if(ret){//如果存在，重写目录文件
                    fs.readFile(pageprovider.getBookDirectory(),"utf-8",function(err,data){
                        if(err){
                            console.log("pdf读取目录信息错误！");
                        };
                        if(data){
                            var jsondata=jQuery.parseJSON(data);
                            var curpage=jsondata.pages.filter(function(el){return el.pageCode==_pageCode})[0];//正确的当前页信息
                            var differNum=_curpageIndex-curpage.pageIndex;//当前页的index和正确的index的差
                            var downloadDate= new Date().toISOString();
                            jsondata.DownloadDate=downloadDate;
                            //和预处理的是同一本书，则只需要更改目录的坐标
                            if(jsondata.IndexInfo.Code==app_global_pdfInfo.similarBookCode){
                                //重新拼装pages,设置位移
                                var pages=jsondata.pages;
                                for(var i=0;i<pages.length;i++){
                                    pages[i].pageIndex=parseInt(pages[i].pageIndex)+differNum;
                                }
                                jsondata.pages=pages;
                                // var menu=jsondata.Menu;
                                for(var i=0;i<jsondata.Menu.length;i++){
                                    _self.setMenuIndex(jsondata.Menu[i],differNum);
                                }
                                //因为_self.setMenuIndex方法有可能未执行完，所以写个setTimeout
                                setTimeout(function(){
                                    fs.writeFile(pageprovider.getBookDirectory(),JSON.stringify(jsondata),"utf-8",function(err){
                                        if(err){
                                            console.log("pdf更新书本目录失败");
                                        }else{
                                            var bookObj={
                                                "IndexInfo":{
                                                    "Code": app_global_pdfInfo.similarBookCode,
                                                },
                                            }
                                            //刷新缓存并重新请求资源
                                            pageprovider._mergeBookDirction(bookObj).done(function(newBookObj){
                                                pageprovider.bookObj = newBookObj;
                                                pageprovider.bookPages = pageprovider.bookObj.pages;
                                                _recommendRes.getRecommend();//重新请求资源
                                            })
                                        }
                                    });
                                },200);
                            }else{
                                //选择值和预处理不是同一本书，则需要重写整个文件
                                var jsondir = pageprovider.getBookDirectory();//json文件路径，需删除
                                var flagdir = path.join(dirStr,"/pdf.flag");//flag文件路径，需改写
                                //重写pdf.flag文件，重写完成后重写json文件
                                _self.rewritePdfflag(flagdir).done(function(){
                                    console.log("改写pdf flag文件成功");
                                    //对json文件的操作。1、删除json文件，2、下载json文件，3，读取json文件，4、改写json文件，保证index对应
                                    shellcmd.deleteFile(jsondir).done(function () {
                                        var bookObj={
                                            "IndexInfo":{
                                                "Title":app_global_pdfInfo.bookName,
                                                "Code": app_global_pdfInfo.similarBookCode,
                                                "Subject":app_global_pdfInfo.subject,
                                                "Publisher":app_global_pdfInfo.publisher,
                                                "Grade":app_global_pdfInfo.grade,
                                                "Volumn":app_global_pdfInfo.volume
                                            },
                                            "PageImageSize":{
                                                "Width":"1240",
                                                "Height":"1754"
                                            },
                                        }
                                        pageprovider.bookObj.IndexInfo.Code=app_global_pdfInfo.similarBookCode;
                                        //刷新缓存并重新请求资源
                                        pageprovider._mergeBookDirction(bookObj).done(function(newBookObj){
                                            //写完json文件后再次调用rewriteBookMenu()方法，这时候相似书和json文件的书必定是同一本，重新定位index即可
                                            setTimeout(function(){//这里用setTimeout是因为_mergeBookDirction.done时只是开始写json文件，并没有写完
                                                _self.rewriteBookMenu();
                                            },800)
                                        })
                                    });
                                })
                            }
                        }
                    })
                }else{//正常都应该存在的，如果不存在，输出错误
                    console.log("pdf课本目录不存在，识别错误")
                }
            })
        }

        //重写pdf.flag文件
        _self.rewritePdfflag=function(path){
            var def = $.Deferred();
            var filepath=path;
            fs.readFile(filepath,"utf-8",function (err,data) {//读取flag文件
                if(err){
                    def.reject();
                    console.log("读取pdf  flag文件失败!");
                };
                if(data){//给原有flag文件的对象重新赋值
                    var jsondata=jQuery.parseJSON(data);
                    jsondata.BookCode=app_global_pdfInfo.similarBookCode;
                    jsondata.BookName=app_global_pdfInfo.similarBookName;
                    var param={
                        bookCode:app_global_pdfInfo.similarBookCode
                    }
                    //请求接口获得书本信息，subject，grade等
                    edcService.Instance().ersp_resource_metadata_book_get(param).done(function(ret){
                        if(ret.code=="0"){
                            var _bookInfo=ret.data.data;
                            //给jsondata赋值，赋值后写入pdf.flag文件
                            jsondata.Subject=_bookInfo.properties.subject[0]||"";
                            jsondata.Grade=_bookInfo.properties.grade[0]||"";
                            jsondata.Phase=_bookInfo.properties.phase[0]||"";
                            jsondata.Volume=_bookInfo.properties.volume[0]||"";
                            jsondata.Edition=_bookInfo.properties.edition[0]||"";
                            jsondata.Publisher=_bookInfo.properties.publisher[0]||"";
                            jsondata.Stage=_bookInfo.properties.stage[0]||"";
                            //给各种属性赋值
                            app_global_pdfInfo.subject=jsondata.Subject;
                            app_global_pdfInfo.grade=jsondata.Grade;
                            app_global_pdfInfo.volume=jsondata.Volume;
                            app_global_pdfInfo.publisher=jsondata.Publisher;
                            _self.container.bookMetaInfo.subject=jsondata.Subject;
                            _self.container.bookMetaInfo.publisher=jsondata.Publisher;
                            _self.container.bookMetaInfo.grade=jsondata.Grade;
                            _self.container.bookMetaInfo.volumn=jsondata.Volume;
                            fs.writeFileSync(filepath ,JSON.stringify(jsondata));
                            def.resolve();
                        }else{
                            def.reject();
                            console.log("重写pdf.flag文件失败");
                        }
                    }).fail(function(){
                        def.reject();
                        console.log("重写pdf.flag文件失败");
                    })
                }else{
                    def.reject();
                    console.log("重写pdf.flag文件失败");
                }
            })
            return def.promise();
        }
    };


    exports.Instance = new Pdfbook();
});
