/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-11-27
 * Time: 下午2:09
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {
//    var _isMainToolBarUp;
    var path = require('../../../common/path');
    var shellcmd = require('../../../common/shellcmd');
    var ebkContext = require('../../ebookcontext').Instance;
    var _pagePreViewIcon = require('./pagepreviewicon').Instance;
    var fs = nodereq('fs');
    var gm_ta = nodereq('gm_ta');
    var GMPath_E = process.execPath.replace(/\\/g, '/').replace('nw.exe', 'tools/GM-1.3.25/gm.exe');

    function PagePreView() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};
        //当前标红页号
        _self.nowPage = 1;
        //预览时显示的第一页值
        _self.firstPage = 1;
        //第一页的最大值
        _self.maxFirstPage = 200;
        //当前所使用书的总页数
        _self.count = 0;
        //当前所使用书的书本号(抽取缩略图用)
        _self.bookCode = "";

        //这也是个临时值
        _self._pageStr = "";

        //界面上绘制缩略图的canvas
        _self.canvas = [];
        //界面上标准页码的位置
        _self.span = [];
        //当前页的紫色遮罩层
        _self.maskDiv = [];
        //气泡的上箭头
        _self.topArrow = {};
        //气泡的下箭头
        _self.botArrow = {};
        //向前翻页
        _self.preViewBtn = {};
        //向后翻页
        _self.backViewBtn = {};

        //当前标红页码的页号（绕过闭包函数，留作值传递用）
        _self.i = 0;

        _self.token = "";
        //测试数据，运行时重置
        _self.zip = "E:/project/EPD_SmartBook3.0/Client/SmartBook/bin/users/iflybook11/ebook/05160110-001/05160110-001.book2";
        _self.lisence = "E:/project/EPD_SmartBook3.0/Client/SmartBook/bin/users/iflybook11/ebook/05160110-001/05160110-001.lic";
        var file = "";

        //隐藏的那一组canvas的ID
        _self.hideDtId = 1;
        //目前正在显示的那一组ID
        _self.nowDtId = 0;
        //是否在显示翻页动画(true则不响应再次请求翻页的操作)
        _self.isClick = false;
        //已加载完翻页动画标记(开始抽取缩略图之后1.5s检测此标记，true表示未加载完动画，放弃本次翻页预览操作)
        _self.hasAnimate = false;
        //鼠标按下标记
        _self.isMouseDown = false;
        //鼠标按下时的位置记录，留作滑动翻页用
        _self.mouseX = 0;

        _self.MDX = 0;
        _self.MDY = 0;

        _self.drawAllNum = 0;
        //加载缩略图计时器，如果在1.5s之内未加载出缩略图，放弃本次操作。
        _self.drawPageTimer = null;
        //连续翻页计时器，当鼠标按下，每隔1s自动翻页一次。
        _self.mouseDownAndUpTimer = null;


        /**
         * 加载DOM对象，绑定相应的事件
         * @param buttons
         * @param controls
         * @param _bookContainer
         * @param nowPage
         * @param bookCode
         */
        _self.init = function (buttons, controls, _bookContainer, nowPage, bookCode) {
            _self.buttons = buttons;
            _self.controls = controls;
            _self.container = _bookContainer;

            /**
             * 初始化的时候没有取得书本总页数，
             * 书本总页数在初始化pageProvider时传入
             */
            _self.nowPage = parseInt(nowPage);
            _self.bookCode = bookCode;

            //只是是否可以向前或向后翻页
            //cannotPreNum 只有 0 和 1 两个值
            _self.cannotPreNum = 0;
            //cannotNextNum 只有 0 和 2 两个值
            _self.cannotNextNum = 0;

            //初始化
            // _ii 只是临时计数变量
            for (var _ii = 0; _ii < 12; _ii++) {
                _self.canvas[_ii] = _self.controls.boxPageView.find("#canvas" + _ii);
                _self.span[_ii] = _self.controls.boxPageView.find("#span" + _ii);
            }

            _self.maskDiv[0] = _self.controls.boxPageView.find("#maskDiv0");
            _self.maskDiv[1] = _self.controls.boxPageView.find("#maskDiv1");
            _self.botArrow = _self.controls.boxPageView.find("#pageViewBotArrow");
            _self.topArrow = _self.controls.boxPageView.find("#pageViewTopArrow");
            _self.buttons.preViewBtn = _self.controls.boxPageView.find("#btnPreView");
            _self.buttons.backViewBtn = _self.controls.boxPageView.find("#btnBackView");
            _self.controls.divShowPages = _self.controls.boxPageView.find("#divShowPages");

            //单击canvas跳转页面
            for (var i = 0; i < 12; i++) {
                _self.canvas[i].attr("width", "90")
                    .attr("height", "126");
                _self.i = i;
                _self.canvas[i].click(function () {
                    var hereSelf = this;
                    var numStr = parseInt(hereSelf.id.slice(6));
                    var _numStr = (numStr > 6) ? (numStr - 6) : numStr;

                    //计算将要跳转的页数（首页+canvas编号）
                    var num = (_numStr == 0 ? 6 : _numStr) + _self.firstPage - 1;
                    _self.nowPage = num;

                    //缩略图不用重新抽取，但当前页样式需要修改
                    //遮罩层left值依次为2,102,202,302,402,502;
                    var leftCssNum = (numStr % 6 == 0) ? 502 : ((numStr % 6 - 1) * 100 + 2);
                    if (numStr > 5) {
                        for (var j = 6; j < 12; j++) {
                            _self.span[j].css("color", "black");
                        }
                        _self.maskDiv[1].css("left", leftCssNum).show();
                    }
                    else {
                        for (var j = 0; j < 6; j++) {
                            _self.span[j].css("color", "black");
                        }
                        _self.maskDiv[0].css("left", leftCssNum).show();
                    }
                    _self.span[numStr].css("color", "red");
                    _self.turnPage(num);
                });
            }

            //弹出页面预览界面
            _self.buttons.btnPageView.click(function () {
                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid: ebkContext._curUser._uid,
                    module: '03004',
                    type: 'trigger',
                    havingClass: _isHavingClass ? 1 : 0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);

                $(".user-popover").hide();//点击转页，其他弹框隐藏
                $("#smartbar_pop").remove();
                if (_self.count == 0) {
                    _self.ready();
                }
                _self.showPageViewOrHide();
                event.stopPropagation();
            });

            //向后翻页(-6)
            _self.buttons.preViewBtn
                .mousedown(function (e) {
                    if (e.which == 1) {
                        _self.minus6NewPages();
                        _self.MDX = e.clientX;
                        _self.MDY = e.clientY;
                        _self.mouseDownAndUpTimer = setInterval(function () {
                            _self.minus6NewPages();
                        }, 1000);
                    }
                    else {
                        clearTimeout(_self.mouseDownAndUpTimer);
                    }
                })
                .mousemove(function (e) {
                    var x = e.clientX - _self.MDX;
                    var y = e.clientY - _self.MDY;
                    if (x > 10 || x < -10 || y > 10 || y < -10) {
                        clearInterval(_self.mouseDownAndUpTimer);
                    }
                })
                .mouseup(function (e) {
                    if (e.which == 1) {
                        clearInterval(_self.mouseDownAndUpTimer);
                    }
                })
                .mouseout(function (e) {
                    if (e.which == 1) {
                        clearInterval(_self.mouseDownAndUpTimer);
                    }
                });

            //向前翻页(+6)
            _self.buttons.backViewBtn
                .mousedown(function (e) {
                    if (e.which == 1) {
                        _self.MDX = e.clientX;
                        _self.MDY = e.clientY;
                        _self.add6NewPage();
                        _self.mouseDownAndUpTimer = setInterval(function () {
                            _self.add6NewPage();
                        }, 1000);
                    }
                })
                .mousemove(function (e) {
                    var x = e.clientX - _self.MDX;
                    var y = e.clientY - _self.MDY;
                    if (x > 10 || x < -10 || y > 10 || y < -10) {
                        clearInterval(_self.mouseDownAndUpTimer);
                    }
                })
                .mouseup(function (e) {
                    if (e.which == 1) {
                        clearInterval(_self.mouseDownAndUpTimer);
                    }
                })
                .mouseout(function (e) {
                    if (e.which == 1) {
                        clearInterval(_self.mouseDownAndUpTimer);
                    }
                });

            _self.controls.boxPageView.mouseout(function () {
                clearInterval(_self.mouseDownAndUpTimer);
            });

            _self.controls.divShowPages
                .mousedown(function (e) {
                    _self.isMouseDown = true;
                    _self.mouseX = e.clientX;
                })
                .mouseup(function (e) {
                    if (_self.isMouseDown) {
                        var mouseLength = e.clientX - _self.mouseX;
                        if (mouseLength > 50) {
                            //page-6;
                            _self.minus6NewPages();
                        }
                        else if (mouseLength < -50) {
                            //page+6
                            _self.add6NewPage();
                        }
                        _self.isMouseDown = false;
                    }
                });

            /**
             * Caution : 这儿有一个问题
             * 假如按住shift不松，可以输入！@#￥%……&*（）等字符
             *
             *    -----------  by  yczhu
             */
            $("#curPageNum")
                .click(function () {
                    this.select();
                    _self._pageStr = this.value;
                    return false;
                })
                .keydown(function (e) {
                    if (e.which == 13) {
                        //13 是 Enter 键的键码
                        var _num = getPageNum(this.value);
                        if (_num) {
                            _self._pageStr = this.value;
                            _self.turnPage(_num);
                            _self.buttons.btnPageView.popover('hide');
                            return false;
                        }
                        else {
                            this.value = _self._pageStr;
                        }

                    }
                })
                .blur(function () {
                    var _num = getPageNum(this.value);
                    if (_num) {
                        _self._pageStr = this.value;
                        _self.turnPage(_num);
                        _self.buttons.btnPageView.popover('hide');
                        return false;
                    }
                    else {
                        this.value = _self._pageStr;
                    }
                }).on("input", function () {
                var _num = parseInt(this.value);
                if (_num - _pagePreViewIcon.bookPages.length > 0) {
                    this.value = _pagePreViewIcon.bookPages.length;
                }
            });
        }

        _self.add6NewPage = function () {
            if (_self.cannotNextNum != 2 && !_self.isClick && !_self.container.isPageLoading()) {
                _self.isClick = true;
                _self.buttons.backViewBtn.removeClass("party_normal").addClass("party_current");
                _self.buttons.preViewBtn.removeClass("party_current").addClass("party_normal");
                _self.firstPage += 6;
                _self.hasAnimate = true;

                _self.drawPageTimer = setTimeout(function () {
                    if (_self.hasAnimate) {
                        _self.isClick = false;
                        _self.firstPage -= 6;
                    }
                }, 1500);

                _self.drawPage(_self.hideDtId).done(function () {
                    _self.hasAnimate = false;
                    clearTimeout(_self.drawPageTimer);
                    $("#dt" + _self.hideDtId).css("left", "600px");
                    var task1 = $("#dt" + _self.nowDtId).animate({left: "-=600px"}, "slow");
                    var task2 = $("#dt" + _self.hideDtId).animate({left: "-=600px"}, "slow");
                    $.when(task1, task2).done(function () {
                        _self.animateDone();
                    });
                });
            }
        }

        _self.minus6NewPages = function () {
            if (_self.cannotPreNum != 1 && !_self.isClick && !_self.container.isPageLoading()) {
                _self.isClick = true;
                _self.buttons.preViewBtn.removeClass("party_normal").addClass("party_current");
                _self.buttons.backViewBtn.removeClass("party_current").addClass("party_normal");
                _self.firstPage -= 6;
                _self.hasAnimate = true;

                _self.drawPageTimer = setTimeout(function () {
                    if (_self.hasAnimate) {
                        _self.isClick = false;
                        _self.firstPage += 6;
                    }
                }, 1500);

                _self.drawPage(_self.hideDtId).done(function () {
                    _self.hasAnimate = false;
                    clearTimeout(_self.drawPageTimer);
                    $("#dt" + _self.hideDtId).css("left", "-600px");
                    var task1 = $("#dt" + _self.nowDtId).animate({left: "+=600px"}, "slow");
                    var task2 = $("#dt" + _self.hideDtId).animate({left: "+=600px"}, "slow");
                    $.when(task1, task2).done(function () {
                        _self.animateDone();
                    });
                });
            }
        }

        /**
         * 资源数据初始化
         */
        _self.ready = function () {
            _self.zip = _self.getStdEncryptBook();
            _self.lisence = _self.getStdBookLic();
            _self.setPageCount();
            _self.maxFirstPage = parseInt(_self.count / 6) * 6 + 1 + ((_self.count % 6) == 0 ? -6 : 0);
        }

        _self.getInitData = function () {
            _self.nowPage = parseInt(_pagePreViewIcon.getNowPage());
            //如果当前页页码刚好是6的倍数，那么往前移一整页
            _self.firstPage = parseInt(_self.nowPage / 6) * 6 + 1 + ((_self.nowPage % 6) == 0 ? -6 : 0);
        }

        _self.drawPage = function (j) {
            var def = $.Deferred();
            _self.isHideViewBtn();
            _self.maskDiv[j].hide();
            _self.drawAllNum = _self.count - _self.firstPage + 1;
            if (_self.drawAllNum > 6) {
                _self.drawAllNum = 6;
            }
            _self.getUserToken().done(function (token) {
                _self.token = token;
                for (var i = _self.firstPage; i < 6 + _self.firstPage; i++) {
                    _self.canvas[(i % 6) + j * 6].show();
                    _self.span[(i % 6) + j * 6].show();
                    //到了末尾隐藏
                    if (i > _self.count) {
                        _self.canvas[(i % 6) + j * 6].hide();
                        _self.span[(i % 6) + j * 6].hide();
                    }
                }

                _self.getRdmRes(_self.firstPage, j).done(function () {
                    def.resolve();
                });
            });
            return def.promise();
        }

        /**
         * 这一块是用异步的方式递归模拟同步抽取缩略图
         * @param i
         * @param j
         * @returns {*}
         */
        _self.getRdmRes = function (i, j) {
            var def = $.Deferred();
            file = i + "\\" + i + "_Thumbnail.jpg";
            //到了末尾隐藏
            if (i > _self.count) {
                def.resolve();
            }
            else {
                _self.retriveDrmRes(file, "", i, j).done(function (ret) {
                    _self.drawAllNum--;
                    if (_self.drawAllNum <= 0) {
                        def.resolve();
                    }
                    else {
                        //递归返回方式
                        _self.getRdmRes(i + 1, j).done(function () {
                            def.resolve();
                        });
                    }
                });
            }
            return def.promise();
        }

        /**
         * 禁用前后翻页按钮
         */
        _self.isHideViewBtn = function () {
            _self.cannotPreNum = _self.cannotNextNum = 0;
            _self.buttons.backViewBtn.css("visibility", "visible");
            _self.buttons.preViewBtn.css("visibility", "visible");
            //理论上应该是可以出现既不能前翻也不能后翻的书(只有6页);
            //恩，现在的确出现了小于6页的书（体验版) ---------  by yczhu
            (_self.firstPage == 1) && (_self.cannotPreNum = 1);
            (_self.firstPage == _self.maxFirstPage) && (_self.cannotNextNum = 2);

        }

        _self.retriveDrmRes = function (file, saveTo, i, j) {
            var def = $.Deferred();
            if (ebkContext.getUser().getName() == AppCfg.defaultuser) {
                _self.drawThumbnail(i, j, "false");
                def.resolve("默认用户显示缩略图");
            }
            if (!AppCfg.saveDRMImage) {
                shellcmd.readEncryptFile(_self.token, _self.zip, _self.lisence, file, saveTo).done(function (ret) {
                    var base64 = ret;
                    _self.drawThumbnail(i, j, base64);
                    def.resolve(ret);
                });
            }
            else {
                //不存在缓存去抽取
                shellcmd.readEncryptFile(_self.token, _self.zip, _self.lisence, file, saveTo).done(function (ret) {
                    var base64 = ret;
                    _self.drawThumbnail(i, j, base64);
                    def.resolve(ret);
                });


            }
            return def.promise();
        };

        //绘制那一页的缩略图作为预览
        _self.drawThumbnail = function (i, j, base64) {
            var i_6 = i % 6, j_6 = j * 6;
            var _pcode = _pagePreViewIcon.bookPages[i - 1].pageIndex;
            _self.span[i_6 + j_6].text(_pagePreViewIcon.bookPages[i - 1].pageCode);
            if (i == _self.nowPage) {
                _self.span[i_6 + j_6].css("color", "red");
                //遮罩层left值依次为2,102,202,302,402,502;
                var leftCssNum = (i_6 == 0) ? 502 : ((i_6 - 1) * 100 + 2);
                _self.maskDiv[j].css("left", leftCssNum).show();
            } else {
                _self.span[i_6 + j_6].css("color", "black");
            }
            var ctx = _self.canvas[i_6 + j_6].get(0).getContext('2d');
            var backgroundImg = new Image();
            if (_self.bookCode.indexOf('pdf_') == 0) {
                var name = '0000000' + i.toString();
                name = name.substr(-6);
                var orc = _self.getStdBookDir() + '/pdf-' + name + '.jpg';
                var dst = _self.getStdBookDir() + '/Thumb-pdf-' + name + '.jpg';
                gm_ta(orc.replace('file:/',''), GMPath_E).resize(150,204).write(dst.replace('file:/',''), function (err) {
                    backgroundImg.src = dst;
                    backgroundImg.onload = function () {
                        ctx.drawImage(backgroundImg, 0, 0, 90, 126);
                    }
                });

            } else {
                backgroundImg.src = (base64 == "false") ? path.trimPosix(path.join(_self.getStdBookDir(), _pcode + "/" + _pcode + "_Thumbnail.jpg")) : base64;
                backgroundImg.onload = function () {
                    ctx.drawImage(backgroundImg, 0, 0, 90, 126);
                }
            }

        }

        _self.turnPage = function (num, i) {
            _self.container.setPageIndex(num);
        }

        _self.setPageCount = function () {
            _self.count = _pagePreViewIcon.bookPages.length;
        }

        //动画结束，切换显示canvas和隐藏canvas的ID
        _self.animateDone = function () {
            if (_self.nowDtId == 0) {
                _self.nowDtId = 1;
                _self.hideDtId = 0;
            }
            else {
                _self.nowDtId = 0;
                _self.hideDtId = 1;
            }
            _self.isClick = false;
        }

        /**
         * 以下4个方法从pageprovider复制过来
         * 故意为之
         * 为解决XP系统下偶发出现pageProvider类不能单例实现的问题
         */
        _self.getUserToken = function () {
            return ebkContext.getMatchToken();
        }

        _self.getStdEncryptBook = function () {
            return path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".book2"));
        }

        _self.getStdBookDir = function () {
            return ebkContext.getStdBookPath();
        }

        _self.getStdBookLic = function () {
            var lic = path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".lic"));
            return lic;
        }

        _self.showPageViewOrHide = function () {
            if (!_self.buttons.btnPageView.popover('isShow')) {
                if (app_global_isMainToolBarUp) {
                    _self.botArrow.show();
                    _self.topArrow.hide();
                }
                else {
                    _self.botArrow.hide();
                    _self.topArrow.show();
                }
                _self.getInitData();
                _self.drawPage(_self.nowDtId).done(function () {
                    _self.buttons.btnPageView.popover("fadeOutAll", true);
                    _self.buttons.btnPageView.popover({
                        content: _self.controls.boxPageView,
                        userDefinePopover: true,
                        extraStyle: {
                            'z-index': 200
                        }
                    }).popover('show',
                        {position: app_global_isMainToolBarUp ? 'top' : 'bottom'});
                });
            }
            else {
                _self.buttons.btnPageView.popover('hide');
            }

            //屏幕分辩率800*600时，才放缩UI面板
            if (Config.Width < 1000) {
                _self.controls.boxPageView.css('-webkit-transform', 'scale(0.8)')
                    .css('margin-top', "-18px")
                    .css('margin-left', "-15px");
            }
        }

        function getPageNum(str) {
            if (_pagePreViewIcon.bookPages && _pagePreViewIcon.bookPages.length > 0) {
                for (var i = 0; i < _pagePreViewIcon.bookPages.length; i++) {
                    if (_pagePreViewIcon.bookPages[i].pageCode == str) {
                        return i + 1;
                    }
                }
                return "";
            }
            else {
                return parseInt(str);
            }
        }
    }

    exports.Instance = new PagePreView();
});
