/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-9-23
 * Time: 上午10:22
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {

    /*****************************************************************
     *
     *   Caution : 这个功能模块是为了做上课演示
     *   由于需求等各方面原因，已经废弃
     *   仅供维护者在添加这块功能时作为参考
     *   sorry，可能这里的“上课演示” 和 您所想要的“上课演示”不是同一个意思
     *   可以询问xhrong 获知详细
     *
     *   劝您最好放弃这里，不要抱有任何幻想。
     *
     *                 ------------- by yczhu
     *
     ****************************************************************/

    require('jquery');
    require('zebra_dialog');
    var _path = require('../../../common/path');
    var ebookContext = require('../../ebookcontext').Instance;
    var _shellcmd = require('../../../common/shellcmd');
    var _pageNavigatorHelper = require('../../../common/pagenavigatorhelper');

    function ClassPresentationManager() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};

        _self._downloadInfo = null;
        /**
         *
         * @param buttons   按钮
         * @param controls  非按钮类控件
         * @param bookContainer
         */
        this.init = function (buttons, controls, bookContainer) {
            _self.bookContainer = bookContainer;
            _self.buttons = buttons;
            _self.controls = controls;
            if(!AppCfg.showJiaoYan) {
                _self.buttons.btnPresentation.attr("menuStatus","")
                _self.buttons.btnPresentation.hide();
                return;
            }
            var _presentClick = false;

            _self.buttons.btnPresentation.click(function () {

                if (_presentClick) {
                    return;
                }
                _presentClick = true;
                if (!ebookContext.getUser().getIsOnline()) {
                    $.Zebra_Dialog(AppTips.LocalLoignMsg, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips],
                        'onClose': function (capition) {
                            if (capition == AppTips.OkTips) {

                            }
                            _presentClick = false;
                        }
                    });
                }
                else {

                    _self.getResourceDownloadInfo().done(function (downloadInfo) {
                        _self._downloadInfo = downloadInfo;
                        if (_self._downloadInfo && _self._downloadInfo.hasResource) {
                            $.Zebra_Dialog(AppImportAndExportTips.ImportTips, {
                                'type': 'question',
                                'title': AppTips.WarmTips,
                                'buttons': [ AppTips.CancelTips, AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {
                                        _self.downloadResource(_self._downloadInfo);
                                    }
                                    else if (capition == AppTips.CancelTips) {
                                    }
                                    _presentClick = false;
                                }
                            });
                        } else {
                            $.Zebra_Dialog(AppResTipList.NoFileTips, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {
                                    }
                                    _presentClick = false;
                                }
                            });
                        }
                    });
                }
            });

            _self.buttons.btnClsPresCancel.click(function () {
                _shellcmd.cancleDownload(_self._downloadInfo.id).done(function (ret) {
                    _self.hideTip();
                });
            });
        }

        /**
         * 处理由于外壳发来的消息
         * @param obj
         */
        this.onMessageReceived = function (obj) {
            if (obj.evt == 'file_download' && obj.data.sourcepage == 'classpresentation') {
                var progress = parseInt(obj.data.progress * 100);
                if (progress > 0) {
                    _self.setProgress(progress + '%');
                }
                //progress>1说明下载完成了
                if (obj.data.progress > 1) {
                    console.log("class presentation resource download success");
                    _self.hideTip();
                    //重新加载书从而将授课记录添加到书上
                    _self.bookContainer.refresh()
                }

            }
        }

        this.setProgress = function (progress) {
            _self.controls.progressTipSpan.text(progress);
            _self.controls.progressValueSpan.width(progress);
        }

        /**
         * 获取下载信息
         * @returns {{}}
         */
        this.getResourceDownloadInfo = function () {
            var def = $.Deferred();
            if (ebookContext.getUser().getIsOnline()) {
                var bookCode = _self.bookContainer.bookMetaInfo.bookCode;
                var unit = _self.bookContainer.getCurrUnit();
                var course = _self.bookContainer.getCurrCourse();
                var url = AppRemoteSvcCfg.GetTebkUrl;
                var msgJson = {
                    url: url,
                    bookCode: bookCode,
                    unit: unit,
                    course: course ? course : "-1",
                    account: AppCfg.tebkUser ? AppCfg.tebkUser : ebookContext.getUser().getName(),
                    ticket: ebookContext.getUser().getTicket()
                };
                _shellcmd.postHttpRequest(msgJson).done(function (ret) {
                    console.log("上课演示资源信息：" + ret);
                    var downloadInfo = {};
                    downloadInfo.hasResource = false;
                    downloadInfo.id = "";
                    downloadInfo.url = "";
                    downloadInfo.title = ""

                    var obj = null;
                    try {
                        obj = JSON.parse(ret);
                        if (obj.total >= 1 && obj.statuscode == "200") {
                            var rawInfo = obj.data[0];
                            var fileExt = _path.extname(rawInfo.downloadUrl)
                            if (rawInfo && rawInfo.downloadUrl && rawInfo.id && fileExt == ".mtbk") {
                                downloadInfo.hasResource = true;
                                downloadInfo.id = rawInfo.id.toString();
                                downloadInfo.url = rawInfo.downloadUrl;
                                downloadInfo.title = rawInfo.title;
                                def.resolve(downloadInfo);
                            } else {
                                def.resolve(downloadInfo);
                            }
                        } else {
                            def.resolve(downloadInfo);
                        }
                    }
                    catch (e) {
                        def.resolve(downloadInfo);
                    }
                });
            } else {
                def.resolve(null);
            }
            return def.promise();
        }

        /**
         * 下载
         * @param downloadInfo
         */
        this.downloadResource = function (downloadInfo) {
            resJson = {
                id: downloadInfo.id,
                title: downloadInfo.title,
                file: downloadInfo.url,
                thumbnail: '',
                bookCode: _self.bookContainer.bookMetaInfo.bookCode,
                sourcepage: "classpresentation",
                moreparam: "true",
                filesavename: _self.bookContainer.bookMetaInfo.bookCode + ".mtbk",
                thumbnailsavename: "",
                savepath: ebookContext.getUser().getUserBookRelativeBasePath() + '/' + _self.bookContainer.bookMetaInfo.bookCode,
                dbpath: ebookContext.getUser().getUserDbFullPath()
            };
            var downloadRawData = JSON.stringify(resJson);
            console.log(downloadRawData);
            _self.showTip(AppTips.clsPresDownloadingMsg);
            _shellcmd.fileDownload(downloadRawData);

        }

        this.showTip = function (msg) {
            //设置资源库面板的初始位置
            if (!_self.controls.clsPresOverlay.is(":visible")) {
                _self.controls.clsPresPanel.css({
                    position: 'absolute',
                    left: ($(window).width() - _self.controls.clsPresPanel.outerWidth()) / 2,
                    top: ($(window).height() - _self.controls.clsPresPanel.outerHeight()) / 2 + $(document).scrollTop(),
                });
                correctToBaseResolution(_self.controls.clsPresPanel);
            }
            _self.controls.clsPresTipMsg.html(msg);
            _self.controls.clsPresOverlay.show();
        }

        this.hideTip = function () {
            _self.controls.clsPresOverlay.hide();
            _self.setProgress('0%');
        }

    };
    exports.ClassPresentationManager = ClassPresentationManager;
})
;