/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-6-26
 * Time: 上午9:50
 * To change this template use File | Settings | File Templates.
 */

/*******************************************************************
 *
 * 2014/07/25    从今天起，这个模块正式废除。
 *               还有一些方法可以借鉴和参考，暂时不动
 *
 *      而且不清楚产品经理那充满幻想的大脑袋会不会在哪一天把这个模块再加回来
 *                  ------ by  yczhu
 *
 ******************************************************************/

define(function (require, exports, module) {
    require('jquery');
    var Messenger = require('../../../thirdparty/messenger');
    require('../../../common/selectbox');
    require('zebra_dialog');
    var ResourceManagerBase = require('./resourcemanagerbase').ResourceManagerBase;
    var resourceProvider = require('./resourceprovider');
    var path = require('../../../common/path');
    var _define = require('../../define');
    var ebookContext = require('../../ebookcontext').Instance;
    var LocalResourcesSatus = require('./resourceslocalstatus').Instance;
    var _shellcmd = require('../../../common/shellcmd');
    var _commonfunc = require('../../../common/commonfunc');
    var _userData = require('../../../common/userdata').Instance;

    function ResourceLibraryManager() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};
        _self._localResList = null;

        //  var devidePageBtnTemplate = '<input type="button" value="{{num}}" class="btn_flip"/>';
        _self.resBtnCount = 0;
        _self.category = AppResTipList.allCategory;
        _self.selectedMode = AppResTipList.byTitle;

        _self.url = "";//资源库iframe对应的url
        /**
         * @param buttons   按钮
         * @param controls  非按钮类控件
         * @param bookContainer
         */
        _self.init = function (buttons, controls, bookContainer) {
            _self.bookContainer = bookContainer;
            _self.buttons = buttons;
            _self.controls = controls;

            AppCfg.lang == "uyghur" && $(".repository_tab").css("background","url(./assert/images/wy_repository_tab.png) no-repeat")

            _self.buttons.resLibBtn.click(function () {
                _self.cloudResClick();
            });
            _self.buttons.cloudResBtn.click(function () {
                _self.cloudResClick();
            });
            _self.buttons.localResBtn.click(function () {
                _self.showResourceLibPanel(false, '');
            });
            _self.buttons.closeBtnResLibPanel.click(function () {
                _self.hideResourceLibPanel();
            });

            _self.messenger = Messenger.initInParent(_self.controls.resLibIfrm[0]);
            _self.messenger.onmessage = function (data) {
                _self._dataReceived = data;
                var receiveJson = JSON.parse(data);
                if (receiveJson.evt == "querypagemetadata") {
                    var sourcepage = (receiveJson.data && receiveJson.data.sourcepage) ? receiveJson.data.sourcepage : "reslib";
                    var respJsonStr = _self.prepareCurrentPageMetaData(sourcepage);
                    dispatchClientMsg(respJsonStr);
                } else if (receiveJson.evt == "queryreslibconfig") {
                    //将本地资源库配置信息发给服务器
                    var sourcepage = (receiveJson.data && receiveJson.data.sourcepage) ? receiveJson.data.sourcepage : "reslib";
                    var respJsonStr = _self.prepareConfigInfoForResLib(sourcepage);
                    dispatchClientMsg(respJsonStr);
                } else if (receiveJson.evt == "open_url") {//调用浏览器打开指定页面
                    _shellcmd.openPageOutside(receiveJson.data.url);
                } else if (receiveJson.evt == "add_tag") { //添加非下载类资源
                    var resJson = receiveJson.data;
                    if (resJson.source == "poem") {//添加诗词
                        var options = {};
                        options.title = resJson.title;
                        _self.bookContainer.insertSingleWidget("", _define.WidgetType.Evaluate, _define.EvalCardType.Poem, options);

                    } else if (resJson.source == "strokeorder") {//添加笔顺
                        console.log("strokeorder:" + data);
                        var options = {};
                        var file = resJson.file;
                        options.title = resJson.title;

                        _self.bookContainer.insertSingleWidget(file, _define.WidgetType.OnlineRes, _define.OnlineResType.StrokeOrder, options);

                    } else if (resJson.source == "simexpert") { //添加仿真实验
                        console.log("simexpert:" + data);
                        var options = {};
                        var file = resJson.file;
                        options.title = resJson.title;

                        _self.bookContainer.insertSingleWidget(file, _define.WidgetType.OnlineRes, _define.OnlineResType.VirtualExperiment, options);

                    }
                    var sourcepage = resJson.sourcepage ? resJson.sourcepage : "reslib";
                    var respJsonStr = _self.addTagResponseInfo(resJson.id, sourcepage);
                    dispatchClientMsg(respJsonStr);

                    var logObj = {
                        type: resJson.extension,
                        source: resJson.source,
                        bookcode: _self.bookContainer.bookCode,
                        url: ""
                    }
                    _userData.start("add", logObj);

                }
                else if (receiveJson.evt == "filedownload") { //添加下载资源
                    var resJson = receiveJson.data;
                    var logObj = {
                        type: resJson.extension,
                        source: resJson.source,
                        bookcode: _self.bookContainer.bookCode,
                        url: resJson.file
                    }
                    //先记录下载记录，再下载资源
                    _userData.start("add", logObj).done(function () {
                        var sourcepage = resJson.sourcepage ? resJson.sourcepage : "reslib";
                        if (resJson.extension == "mtbk") {
                            _self.downloadMtbk(resJson, sourcepage);
                        } else {
                            var resId = resJson.id;
                            resourceProvider.Instance.checkResourceExist(resId, ebookContext.getUser().getUserDbFullPath())
                                .done(function (isExist) {
                                    if (resJson.redownload && resJson.redownload == "1") {  //这个标记表示始终要重新下载
                                        isExist = false;
                                    }
                                    if (isExist) {//如果已经存在本地，则不再下载
                                        resourceProvider.Instance.getResourceById(resId, ebookContext.getUser().getUserDbFullPath())
                                            .done(function (resItem) {
                                                console.log(JSON.stringify(resItem));
                                                _self.addResToPage(resItem);
                                                //发送下载进度，默认下载完成
                                                var msg = '{"evt":"file_download","data":{"sourcepage":"' + sourcepage + '","id":"' + resId + '","progress":"2"}}';
                                                dispatchClientMsg(msg);
                                            });
                                    } else {
                                        //添加文件来源
                                        resJson["sourcepage"] = sourcepage;
                                        resJson["savepath"] = ebookContext.getUser().getUserResourceRelativeBasePath() + '/' + resJson.id;  //文件保存路径
                                        resJson["dbpath"] = ebookContext.getUser().getUserDbFullPath();
                                        var downloadRawData = JSON.stringify(resJson);
                                        _shellcmd.fileDownload(downloadRawData);
                                    }
                                });
                        }
                    });
                }
            };

            _self.controls.elemMaskPanel.hide();
            _self.buttons.localResManagerBtn.click(function () {
                _self.buttons.localResManagerBtn.css("display", "none");
                _self.buttons.multiSelectBtn.css("display", "none");

                _self.buttons.localResDeleteBtn.css("display", "inline");
                _self.buttons.localResOpenBtn.css("display", "none");
                _self.buttons.localResAllSelectBtn.css("display", "inline");
                _self.buttons.localResNoSelectBtn.css("display", "none");
                _self.buttons.localResResCancelBtn.css("display", "inline");

                LocalResourcesSatus.setSelectStatusOrClickOpenStatus(2);

            })

            _self.buttons.localResResCancelBtn.click(function () {
                _self.buttons.localResManagerBtn.css("display", "inline");
                _self.buttons.multiSelectBtn.css("display", "inline");

                _self.buttons.localResDeleteBtn.css("display", "none");
                _self.buttons.localResOpenBtn.css("display", "none");
                _self.buttons.localResAllSelectBtn.css("display", "none");
                _self.buttons.localResNoSelectBtn.css("display", "none");
                _self.buttons.localResResCancelBtn.css("display", "none");

                LocalResourcesSatus.setSelectStatusOrClickOpenStatus(1);
                //_self.changeAllResCss("current", "normal");
                //刷新页面
                _self.showResourceLibPanel(false, '');
            })

            _self.buttons.multiSelectBtn.click(function () {
                _self.buttons.localResManagerBtn.css("display", "none");
                _self.buttons.multiSelectBtn.css("display", "none");

                _self.buttons.localResDeleteBtn.css("display", "none");
                _self.buttons.localResOpenBtn.css("display", "inline");
                _self.buttons.localResAllSelectBtn.css("display", "inline");
                _self.buttons.localResNoSelectBtn.css("display", "none");
                _self.buttons.localResResCancelBtn.css("display", "inline");

                LocalResourcesSatus.setSelectStatusOrClickOpenStatus(2);

            });

            _self.buttons.localResAllSelectBtn.click(function () {
                _self.buttons.localResAllSelectBtn.css("display", "none");
                _self.buttons.localResNoSelectBtn.css("display", "inline");

                if (LocalResourcesSatus.getSelectStatusOrClickOpenStatus() == 2) {
                    _self.changeAllResCss("normal", "current");
                }
                else {
                    return;
                }
            });

            _self.buttons.localResNoSelectBtn.click(function () {
                _self.buttons.localResAllSelectBtn.css("display", "inline");
                _self.buttons.localResNoSelectBtn.css("display", "none");

                if (LocalResourcesSatus.getSelectStatusOrClickOpenStatus() == 2) {
                    _self.changeAllResCss("current", "normal");
                }
                else {
                    return;
                }
            })

            _self.buttons.localResOpenBtn.click(function () {
                if (LocalResourcesSatus.getSelectStatusOrClickOpenStatus() == 2) {
                    if (LocalResourcesSatus.getSelectStatusOrClickOpenStatus() == 2) {
                        _self.controls.resItems.find("li").each(function () {
                            var _hereSelf = $(this);
                            if (_hereSelf.hasClass("current")) {
                                //打开  (不知道可不可以)
                                var _findRes = _hereSelf.children(".img").children();
                                var url = _findRes.attr("file");
                                var id = _findRes.attr("id");
                                if (url == "" || id == "") {
                                    alert("not file found!");
                                    return false;
                                }
                                var files = new Array();
                                files[0] = url;
                                _self.bookContainer.insertWidget(files);
                            }
                        });
                        _self.buttons.localResResCancelBtn.trigger("click");
                    }
                }
                else {
                    return;
                }
            });

            _self.buttons.localResDeleteBtn.click(function () {
                var deleList = [];
                if (LocalResourcesSatus.getSelectStatusOrClickOpenStatus() == 2) {
                    _self.controls.resItems.find("li").each(function () {
                        var _hereSelf = $(this);
                        if (_hereSelf.hasClass("current")) {
                            //删除物理文件
                            var _findRes = _hereSelf.children(".img").children();
                            var url = _findRes.attr("file");
                            var id = _findRes.attr("id");
                            var obj = {
                                url:url,
                                id:id
                            }
                            deleList.push(obj);
                        }
                    });
                    console.log(deleList.length);
                    if(deleList.length>0){
                        showLoading({tips: AppBookShelfTipsList.DeletingTips});
                        var _dbPath = _self.user.getUserDbFullPath();
                        resourceProvider.Instance.deleteResALot(deleList, _dbPath).done(function(){
                            _self.buttons.localResResCancelBtn.trigger("click");
                            hideLoading();
                        });
                    }
                    else{
                        _self.buttons.localResResCancelBtn.trigger("click");
                    }
                }
                else {
                    _self.buttons.localResResCancelBtn.trigger("click");
                }
            });

            _self.buttons.GoBackToResIframeBtn.click(function () {
                if (!ebookContext.getUser().getIsOnline()) {
                    $.Zebra_Dialog(AppTips.LocalLoignMsg, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                    return;
                }
                _self.hideLocalResPanel();
                //设置网络连接异常DIV样式
                var panel = _self.controls.repositoryPanel;
                var iframe = _self.controls.resLibIfrm;
                var marginTop = (panel.height() - 30) / 2;
                var marginLeft = (panel.width() - 260) / 2;
                var tipsStyle = 'top:36px;position: absolute;margin-top:{0}px;margin-left:{1}px'.format(marginTop, marginLeft);
                _commonfunc.online(_self.url, iframe, tipsStyle, panel);
            });

            _self.buttons.SelectedModeValueInResBtn.dropdown({
                dataSource: item2,
                value: AppResTipList.allCategory,
                width: AppCfg.lang == "uyghur" ? 150:100,
                height: 250,
                space: 10,
                direction: 'up',
                style: 'green',
                change: function (key, value) {
                    _self.selectMode = value;
                    _self.selectLocalResByCategoryAndSelectMode(_self.category, _self.selectMode);
                }
            });

            _self.buttons.SelectedCategoryValueInResBtn.dropdown({
                dataSource: item1,
                value: AppResTipList.byTitle,
                width: AppCfg.lang == "uyghur" ? 150:100,
                height: 250,
                space: 10,
                direction: 'up',
                style: 'green',
                change: function (key, value) {
                    _self.category = value;
                    _self.selectLocalResByCategoryAndSelectMode(_self.category, _self.selectMode);
                }
            });

            LocalResourcesSatus.init();

            _self.controls.pageBtnPanel.find('input').click(function () {
                var pageBtnNum = $(this).attr("value");
                _self.changePageBtn(pageBtnNum);
                if (LocalResourcesSatus.getSelectStatusOrClickOpenStatus() == 2) {
                    _self.buttons.localResAllSelectBtn.css("display", "inline");
                    _self.buttons.localResNoSelectBtn.css("display", "none");
                }
                resourceProvider.Instance.devideResCategorySelectedMode(_self.category, _self.selectMode, _self.user.getUserDbFullPath(), pageBtnNum * 18 - 18).done(function (resList) {
                    _self._localResList = resList;
                    _self.controls.resItems.html('');
                    //渲染list
                    var lstlen = resList.length;
                    if (lstlen == 0) {
                        //无记录提示“没有资源”
                        _self.controls.noResTips.css("display", "block");
                        return;
                    }
                    _self.controls.noResTips.css("display", "none");
                    console.log(lstlen);
                    var basePath = path.trimPosix(Config.binPath);
                    for (var i = 0; i < lstlen; i++) {
                        var resItem = $("<li></li>");
                        resItem.addClass("normal");
                        var thumbnail = $("<div></div>");
                        thumbnail.addClass("img");
                        var link = $("<div></div>");
                        link.attr("id", _self._localResList[i].id);
                        //如果物理文件地址为空，删除时会出问题
                        link.attr("file", basePath + _self._localResList[i].file);
                        link.attr("title", _self._localResList[i].title);
                        link.click(function () {
                            if (LocalResourcesSatus.getSelectStatusOrClickOpenStatus() == 1) {
                                var url = $(this).attr("file");
                                var id = $(this).attr("id");
                                if (url == "" || id == "") {
                                    alert("not file found!");
                                    return false;
                                }
                                var files = new Array();
                                files[0] = url;
                                _self.bookContainer.insertWidget(files);
                                return false;
                            }
                            else if (LocalResourcesSatus.getSelectStatusOrClickOpenStatus() == 2) {
                                var _hereSelf = $(this).parent().parent();

                                if (_hereSelf.hasClass("normal")) {
                                    _hereSelf.removeClass("normal").addClass("current");
                                    //如果全部选中，“全选”改为“不选”
                                    var _all = true;
                                    _self.controls.resItems.find("li").each(function () {
                                        var _nowSelf = $(this);
                                        if (_nowSelf.hasClass("normal")) {
                                            _all = false;
                                        }
                                    });
                                    if (_all) {
                                        _self.buttons.localResAllSelectBtn.css("display", "none");
                                        _self.buttons.localResNoSelectBtn.css("display", "inline");
                                    }
                                }
                                else if (_hereSelf.hasClass("current")) {
                                    _hereSelf.removeClass("current").addClass("normal");
                                    //“不选”改为“全选”
                                    _self.buttons.localResAllSelectBtn.css("display", "inline");
                                    _self.buttons.localResNoSelectBtn.css("display", "none");
                                }
                            }
                        });
                        var img = $("<img/>");
                        if (_self._localResList[i].thumbnail == '') {
                            img.attr("src", _self.getDefaultThumbnail(_self._localResList[i].file));
                        }
                        else
                            img.attr("src", Config.binPath + _self._localResList[i].thumbnail);
                        link.append(img);
                        thumbnail.append(link);
                        var _text = _self._localResList[i].title;
                        //有后缀名
                        var dotPlace = _self._localResList[i].title.lastIndexOf(".");
                        if (dotPlace != -1 && dotPlace >= 8) {
                            _text = _self._localResList[i].title.substr(0, 8) + "..." + _self._localResList[i].title.substr(dotPlace);
                        }
                        //没有后缀名
                        if (dotPlace == -1) {
                            if (_self._localResList[i].title.length >= 12) {
                                _text = _self._localResList[i].title.substr(0, 8) + "..." + _self._localResList[i].title.substr(-3);
                            }
                        }

                        var title = $("<div></div>").text(_text);
                        title.addClass("text");
                        resItem.append(thumbnail);
                        resItem.append(title);
                        _self.controls.resItems.append(resItem);
                    }
                });
            });
        }

        /**
         * 改变当前资源面板中所有资源的样式
         * @param oldcss
         * @param newcss
         */
        _self.changeAllResCss = function (oldcss, newcss) {
            _self.controls.resItems.find("li").each(function () {
                var _hereSelf = $(this);
                if (_hereSelf.hasClass(oldcss)) {
                    _hereSelf.removeClass(oldcss).addClass(newcss);
                }
            })
        }

        /**
         * 隐藏本地资源库面板
         */
        _self.hideLocalResPanel = function () {
            _self.controls.localResLibPanel.css("display", "none");
            _self.controls.resLibIfrm.show();
        }

        _self.selectLocalResByCategoryAndSelectMode = function (category, selectMode) {
            resourceProvider.Instance.getCategorySelectedModeCount(category, _self.user.getUserDbFullPath()).done(function (num) {
                if (num == 0) {
                    _self.controls.resItems.html('');
                    _self.controls.pageBtnPanel.css("display", "none");
                    _self.controls.noResTips.css("display", "block");
                }
                else {
                    _self.resBtnCount = parseInt(num / 18) + (num % 18 == 0 ? 0 : 1);
                    //按钮重置
                    _self.controls.pageBtnPanel.show();
                    _self.controls.pageBtnPanel.find('input:eq(0)').attr("value", "1").trigger("click");
                }
            });
        }

        _self.cloudResClick = function () {
            var rawUrl = AppRemoteSvcCfg.ResPageUrl;
            var bookId = _self.bookContainer.bookMetaInfo.bookId;
            var subject = _self.bookContainer.bookMetaInfo.subject;
            var publisher = _self.bookContainer.bookMetaInfo.publisher;
            var grade = _self.bookContainer.bookMetaInfo.grade;
            var bookCode = _self.bookContainer.bookMetaInfo.bookCode;
            //xjzhou:目前，course编码无法获取，所以暂时只精确到单元
            var unit = _self.bookContainer.getCurrUnit();
            var course = _self.bookContainer.getCurrCourse();
            var volumn = _self.bookContainer.bookMetaInfo.volumn;
            var ticket = ebookContext.getUser().getTicket();

            var url = rawUrl + "&bookId=" + bookId + "&bookcode=" + bookCode + "&subject=" + subject
                + "&publisher=" + publisher + "&grade=" + grade + "&course=" + course
                + "&unit=" + unit + "&volumn=" + volumn + "&ticket=" + ticket;
            console.log(url);
            _self.url = url;//存储资源库iframe对应的url，支持本地资源视图中返回到联网资源视图。

            if (!ebookContext.getUser().getIsOnline()) {
                _self.buttons.localResBtn.trigger("click");
            } else {
                _self.showResourceLibPanel(true, url);
            }
        }

        /**
         *隐藏资源库面板
         */
        _self.hideResourceLibPanel = function () {
            _self.controls.resLibIfrm.attr("src", "");
            _self.controls.resLibPanel.hide();
            //清除网络连接提示信息DIV元素
            _self.controls.repositoryPanel.find(".tips_box").remove();
        }

        _self._offset = 0;
        /**
         * 记录主工具栏的位置和偏移量，为定位资源库面板的初始位置使用
         * @param isUp
         * @param offset
         */
        _self.setMainToolBarPosition = function (offset) {
            _self._offset = offset;
        }

        /**
         * 显示资源库面板
         * @param isNetwork 是否是网络资源库
         * @param url
         */
        _self.showResourceLibPanel = function (isNetwork, url, category) {
            //设置资源库面板的初始位置
            if (!_self.controls.resLibPanel.is(":visible")) {
                _self.controls.resLibPanel.css({
                    position: 'absolute',
                    left: ($(window).width() - _self.controls.resLibPanel.outerWidth()) / 2,
                    top: ($(window).height() - _self.controls.resLibPanel.outerHeight()) / 2 + $(document).scrollTop()
                });
                if (Config.Width < 1000) {
                    correctToBaseResolution(_self.controls.resLibPanel, {keepScale: true});
                }
            }
            if (isNetwork) {
                _self.controls.localResLibPanel.hide();
                _self.controls.resLibIfrm.show();
                _self.controls.resLibPanel.show();
                //设置网络连接异常DIV样式
                var panel = _self.controls.repositoryPanel;
                var iframe = _self.controls.resLibIfrm;
                var marginTop = (panel.height() - 30) / 2;
                var marginLeft = (panel.width() - 260) / 2;
                var tipsStyle = 'top:36px;position: absolute;margin-top:{0}px;margin-left:{1}px'.format(marginTop, marginLeft);
                _commonfunc.online(_self.url, iframe, tipsStyle, panel);
            }
            else {
                _self.controls.resItems.html('');
                _self.selectLocalResByCategoryAndSelectMode("", AppResTipList.byTitle);
                _self.controls.localResLibPanel.show();
                _self.controls.localResLibPanel.css("margin-left", "5");
                _self.controls.resLibIfrm.hide();
                //清除网络连接提示信息DIV元素
                _self.controls.repositoryPanel.find(".tips_box").remove();
            }
            _self.controls.resLibPanel.show();
            _self.controls.resLibPanelMask.hide();
            _self.controls.resLibPanel.draggable({
                handle: "#" + _self.controls.resLibPanelTop.attr("id"),
                containment: "window",
                start: function () {
                    _self.controls.resLibPanelMask.show();
                },
                stop: function () {
                    _self.controls.resLibPanelMask.hide();
                }
            });
        }

        _self.changePageBtn = function (num) {
            var _num = parseInt(num);
            //按钮总数为0时，点击无反应。
            if (_self.resBtnCount == 0) {
                return;
            }
            var btns = _self.controls.pageBtnPanel.find('input');
            btns.removeClass("btn_flip2").addClass("btn_flip");
            console.log("_self.resBtnCount--" + _self.resBtnCount);
            if (_num < 4) {
                $(btns[0]).attr("value", "1").show();
                $(btns[1]).attr("value", "2").show();
                $(btns[2]).attr("value", "3").show();
                $(btns[3]).attr("value", "4").show();
                $(btns[4]).attr("value", "5").show();
                $(btns[5]).attr("value", "6").show();
                $(btns[6]).attr("value", "7").show();
                switch (_num) {
                    case 1:
                        $(btns[0]).removeClass("btn_flip").addClass("btn_flip2");
                        break;
                    case 2:
                        $(btns[1]).removeClass("btn_flip").addClass("btn_flip2");
                        break;
                    case 3:
                        $(btns[2]).removeClass("btn_flip").addClass("btn_flip2");
                        break;
                    default :
                }
                switch (_self.resBtnCount) {
                    case 1:
                        $(btns[1]).hide();
                    case 2:
                        $(btns[2]).hide();
                    case 3:
                        $(btns[3]).hide();
                    case 4:
                        $(btns[4]).hide();
                    case 5:
                        $(btns[5]).hide();
                    case 6:
                        $(btns[6]).hide();
                    default :
                }
            }
            else {
                $(btns[0]).attr("value", _num - 3).show();
                $(btns[1]).attr("value", _num - 2).show();
                $(btns[2]).attr("value", _num - 1).show();
                $(btns[3]).attr("value", _num).show();
                $(btns[4]).attr("value", _num + 1).show();
                $(btns[5]).attr("value", _num + 2).show();
                $(btns[6]).attr("value", _num + 3).show();

                if (_num + 3 <= _self.resBtnCount) {
                    $(btns[3]).removeClass("btn_flip").addClass("btn_flip2");
                }
                else {
                    $(btns[0]).attr("value", _self.resBtnCount - 6).show();
                    $(btns[1]).attr("value", _self.resBtnCount - 5).show();
                    $(btns[2]).attr("value", _self.resBtnCount - 4).show();
                    $(btns[3]).attr("value", _self.resBtnCount - 3).show();
                    $(btns[4]).attr("value", _self.resBtnCount - 2).show();
                    $(btns[5]).attr("value", _self.resBtnCount - 1).show();
                    $(btns[6]).attr("value", _self.resBtnCount).show();

                    if (_num == _self.resBtnCount) {
                        $(btns[6]).removeClass("btn_flip").addClass("btn_flip2");
                    }
                    else if (_num + 1 == _self.resBtnCount) {
                        $(btns[5]).removeClass("btn_flip").addClass("btn_flip2");
                    }
                    else if (_num + 2 == _self.resBtnCount) {
                        $(btns[4]).removeClass("btn_flip").addClass("btn_flip2");
                    }
                    switch (_self.resBtnCount) {
                        case 4 :
                            $(btns[2]).hide();
                        case 5 :
                            $(btns[1]).hide();
                        case 6 :
                            $(btns[0]).hide();
                        default :
                    }
                    ;
                }
            }
        }

        _self.setIsEditing=function(value){
            !value&&_self.hideResourceLibPanel();
        }

        /**
         * 分类selectedbox插件初始数据
         * @type {Array}
         */
        var item1 = new Array();
        item1[AppResTipList.allCategory] = AppResTipList.allCategory;
        item1[AppResTipList.MaterialDocuments] = AppResTipList.MaterialDocuments;
        item1[AppResTipList.Courseware] = AppResTipList.Courseware;

        /**
         * 排序selectedbox插件初始数据
         * @type {Array}
         */
        var item2 = new Array();
        item2[AppResTipList.byTitle] = AppResTipList.byTitle;
        item2[AppResTipList.byTime] = AppResTipList.byTime;
        item2[AppResTipList.byFileSize] = AppResTipList.byFileSize;
        item2[AppResTipList.byCategory] = AppResTipList.byCategory;

    }

    ResourceLibraryManager.prototype = new ResourceManagerBase();
    ResourceLibraryManager.prototype.constructor = ResourceLibraryManager;

    exports.ResourceLibraryManager = ResourceLibraryManager;
});