/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-7-11
 * Time: 上午9:33
 * To change this template use File | Settings | File Templates.
 */


/*******************************************************************
 *
 * 2014/07/25    从今天起，这个模块正式废除。
 *               还有一些方法可以借鉴和参考，暂时不动
 *
 *  这个模块本身不存在继承关系，
 *  但在2013/07设计这个模块的时候，
 *  考虑到当时的资源库和当时的搜索面板有一些公用的方法，
 *  因此抽象出来做成基类用以继承
 *
 *                  ------ by  yczhu
 *
 ******************************************************************/

define(function (require, exports) {

    var ResourceItem = require('./resourceitem').Instance;
    var path = require('../../../common/path');
    require('../../user');
    require('zebra_dialog');
    var _shellcmd = require('../../../common/shellcmd');
    var resourceProvider = require('./resourceprovider');
    var ebookContext = require('../../ebookcontext').Instance;
    var _pageNavigatorHelper = require('../../../common/pagenavigatorhelper');

    /**
     * 书本视图基类
     * @constructor
     */
    function ResourceManagerBase() {
        var _self = this;
        /**
         * 书本容器
         * @type {null}
         */
        _self.bookContainer = null;

        /**
         * 当前用户
         * @type {null}
         */
        _self.user = null;

        /**
         * 设置用户
         * @param user
         */
        this.setUser = function (user) {
            _self.user = user;
        }

        /**
         * 解析资源下载信息
         * @param resJson
         * @returns {ResourceItem}
         */
        this.resolveResInfo = function (resJson) {
            var resItem = new ResourceItem();
            resItem.id = resJson.id;
            resItem.title = resJson.rawData.title;
            resItem.file = resJson.file;
            resItem.thumbnail = resJson.thumbnail;
            resItem.description = resJson.rawData.description;
            resItem.keywords = resJson.rawData.keywords;
            resItem.grade = resJson.rawData.grade;
            resItem.subject = resJson.rawData.subject;
            resItem.volumn = resJson.rawData.volumn;
            resItem.bookCode = resJson.rawData.bookCode;
            resItem.unit = resJson.rawData.unit;
            resItem.course = resJson.rawData.course;
            resItem.category = resJson.rawData.category;
            resItem.extension = resJson.rawData.extension;
            resItem.fileSize = resJson.rawData.fileSize;
            var now = new Date();
            resItem.downloadDate = now.getFullYear() + '-' + (now.getMonth() + 1) + '-' + now.getDate();    //获取当前时间
            resItem.reserve1 = '';
            resItem.reserve2 = '';
            return resItem;
        }

        /**
         * 将单个资源文件添加到页面上
         * @param resInfo
         */
        this.addResToPage = function (resItem) {
            var files = new Array();
            var basePath = path.trimPosix(Config.binPath);
            files[0] = basePath + resItem.file;
            this.bookContainer.insertWidget(files);
        }

        /**
         * 根据文件扩展名，获取相应的默认缩略图
         * @param fileName
         * @returns {string}
         * @private
         */
        this.getDefaultThumbnail = function (fileName) {
            var extensionArr = (/[.]/.exec(fileName)) ? /[^.]+$/.exec(fileName.toLowerCase()) : '';
            var ext = "";
            if (extensionArr.length > 0) {
                ext = extensionArr[0];
            }
            var arr = ["html", "htm", "mht",
                "bmp", "jpeg", "jpg", "gif", "png",
                "pdf", "rtf", "swf", "txt", "zip" , "chm",
                "mp3", "wav", "wma",
                "wmv", "rmvb", "mp4", "avi", "asf", "mpeg", "3gp", "flv", "mpg",
                "pps", "ppsx", "ppt", "pptx", "xls", "xlsx", "doc", "docx"];
            if (ext != "" && arr.indexOf(ext) > 0) {
                return "assert/images/thumbnail/" + ext + ".png";
            }
            return    "assert/images/thumbnail/unknow.png";
        }


        /**
         * 处理由于外壳发来的消息
         * @param obj
         */
        this.onMessageReceived = function (obj) {
            if (obj.evt == 'file_download') {
                //progress>1说明下载完成了
                if (obj.data.progress > 1) {
                    console.log(obj);
                    var resItem = this.resolveResInfo(obj.data);
                    if (path.extname(obj.data.file) == ".mtbk") {
                        //如果是当前课本的授课文件，则刷新以导入
                        if (obj.data.rawData.bookCode == "" ||
                            obj.data.rawData.bookCode == this.bookContainer.bookCode) {
                            this.bookContainer.refresh();
                        } else { //提示不是当前课本的授课文件
                            $.Zebra_Dialog(AppResTipList.MtbkNoMatchMsg, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.OkTips],
                                'onClose': function (capition) {
                                }
                            });
                        }
                    } else {
                        resourceProvider.Instance.addResource(resItem, _self.user.getUserDbFullPath());
                        this.addResToPage(resItem);
                    }
                }
            }
        }

        this.prepareCurrentPageMetaData = function (sourcepage) {
            var pageMetadataJson = {};
            pageMetadataJson.sourcepage = sourcepage;
            pageMetadataJson.metadata = "";//this.bookContainer.getCurrPageMetadata();
            var respJson = {};
            respJson.evt = "responsepagemetadata";
            respJson.data = pageMetadataJson;
            var respJsonStr = JSON.stringify(respJson);
            console.log(respJsonStr);
            return respJsonStr;
        }

        /**
         * 为资源库返回本地配置信息
         * @returns {*}
         * @protected
         */
        this.prepareConfigInfoForResLib = function (sourcepage) {
            var resLibConfigJson = {};
            resLibConfigJson.userspace = AppRemoteSvcCfg.UserSpaceServerUrl;
            resLibConfigJson.provinceserver = AppRemoteSvcCfg.ProvinceServerUrl;
            resLibConfigJson.cityserver = AppRemoteSvcCfg.CityServerUrl;
            resLibConfigJson.countyserver = AppRemoteSvcCfg.CountyServerUrl;
            resLibConfigJson.schoolserver = AppRemoteSvcCfg.SchoolServerUrl;
            resLibConfigJson.usernotebookserver = AppCfg.showJiaoYan ? AppRemoteSvcCfg.UserNoteBookUrl : "";
            resLibConfigJson.usercourseresourceserver = AppCfg.showJiaoYan ? AppRemoteSvcCfg.UserCourseResourceUrl : "";
            resLibConfigJson.cloudserver = AppRemoteSvcCfg.CloudServerUrl;
            resLibConfigJson.poemserver = AppRemoteSvcCfg.PoemServerUrl;
            resLibConfigJson.virtuallabserver = AppRemoteSvcCfg.VirtualLabServerUrl;
            resLibConfigJson.strokeorderserver = AppRemoteSvcCfg.StrokeOrderServerUrl;

            resLibConfigJson.sourcepage = sourcepage;
            var respJson = {};
            respJson.evt = "responsereslibcofig";
            respJson.data = resLibConfigJson;
            var respJsonStr = JSON.stringify(respJson);
            return respJsonStr;
        }

        /**
         * 添加非下载类资源时的返回数据
         * @param id
         * @returns {*}
         * @protected
         */
        this.addTagResponseInfo = function (id, sourcepage) {
            var addTagResp = {};
            addTagResp.id = id;
            addTagResp.status = "true";
            addTagResp.sourcepage = sourcepage;
            var respJson = {};
            respJson.evt = "add_tag_callback";
            respJson.data = addTagResp;
            var respJsonStr = JSON.stringify(respJson);
            return respJsonStr;
        }

        this.downloadMtbk = function (resJson, sourcepage) {
            console.log(resJson);
            var bookCode = resJson.bookCode ? resJson.bookCode : this.bookContainer.bookMetaInfo.bookCode;
            resJson["sourcepage"] = sourcepage;
            resJson["moreparam"] = "true";
            resJson["filesavename"] = resJson.id + ".mtbk";
            resJson["thumbnailsavename"] = "";
            resJson["savepath"] = ebookContext.getUser().getUserBookRelativeBasePath() + '/' + bookCode;  //文件保存路径
            resJson["dbpath"] = ebookContext.getUser().getUserDbFullPath();
            var downloadRawData = JSON.stringify(resJson);
            _shellcmd.fileDownload(downloadRawData);
        }
    }

    exports.ResourceManagerBase = ResourceManagerBase;
});