/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-6-19
 * Time: 下午7:59
 * To change this template use File | Settings | File Templates.
 */

/*******************************************************************
 *
 * 2014/07/25    从今天起，这个模块正式废除。
 *
 *  这个模块原本用以对本地资源管理（数据库操作接口）
 *                  ------ by  yczhu
 *
 ******************************************************************/

define(function (require, exports, module) {

    var ResourceItem = require('./resourceitem').Instance;
    var _shellcmd = require('../../../common/shellcmd');

    function ResourceProvider() {
        _self = this;
        _self.ResourceItems = new Array();
        _self.ResourcesObject = null;

        /**
         * 检查资源是否已经存在
         * @param resId
         * @returns {boolean}
         */
        _self.checkResourceExist = function (resId, dbPath) {
            var def = $.Deferred();
            var sqlQuery = 'select count(*) from Resources where id="' + resId + '"';
            _shellcmd.getFirstItemAsyn(dbPath, sqlQuery).done(function (count) {
                def.resolve(count > 0);
            });
            return def.promise();
        }

        /**
         * 按ID查询资源
         */
        _self.getResourceById = function (id, dbPath) {
            var def = $.Deferred();
            var querySql = "select * from Resources where id='" + id + "'";
            _shellcmd.retriveDbAsyn(dbPath, querySql).done(function (resStr) {
                var resList = _self._convertDbItemsToResItems(resStr);
                if (resList.length > 0) {
                    def.resolve(resList[0]);
                } else
                    def.resolve(null);
            });
            return def.promise();
        }

        _self.getCategorySelectedModeCount = function (category, dbPath) {
            var def = $.Deferred();
            category = _self.changeCategory(category);
            var sqlQuery = "select count(*) as num from Resources";
            if (category != "") {
                sqlQuery += " where category = '" + category + "'";
            }
            _shellcmd.retriveDbAsyn(dbPath, sqlQuery).done(function (res) {
                console.log(res);
                var numJson = JSON.parse(res);
                def.resolve(numJson.data[0].num);
            });
            return def.promise();
        }

        _self.devideResCategorySelectedMode = function (category, selectMode, dbPath, offsetnum) {
            var def = $.Deferred();
            category = _self.changeCategory(category);
            selectMode = _self.changeSelectMode(selectMode);
            var sqlQuery = "select * from Resources";
            if (category != "") {
                sqlQuery += " where category = '" + category + "'";
            }
            if (selectMode != "") {
                sqlQuery += " order by " + selectMode + " asc";
            }
            sqlQuery += ' limit 18 offset ' + offsetnum;
            _shellcmd.retriveDbAsyn(dbPath, sqlQuery).done(function (resStr) {
                var resList = _self._convertDbItemsToResItems(resStr);
                console.log(resList);
                def.resolve(resList);
            });
            return def.promise();
        }

        _self.changeCategory = function (category) {
            switch (category) {
                case  AppResTipList.MaterialDocuments:
                    break;
                case AppResTipList.Courseware:
                    break;
                default :
                    category = ""
                    break;
            }
            return category;
        }

        _self.changeSelectMode = function (selectMode) {
            switch (selectMode) {
                case AppResTipList.byFileSize:
                    selectMode = "fileSize";
                    break;
                case AppResTipList.byTitle:
                    selectMode = "title";
                    break;
                case AppResTipList.byTime:
                    selectMode = "downloadDate";
                    break;
                case AppResTipList.byCategory:
                    selectMode = "category";
                    break;
                default :
                    selectMode = "title";
                    break;
            }
            return selectMode;
        }

        _self.getCountTxtCategory = function (searchTxt, category, dbPath) {
            var def = $.Deferred();
            var querySql = "";
            category = _self.changeCategory(category);
            if (!searchTxt) {
                def.resolve(0);
            } else if (category == "" || category == AppResTipList.allCategory) {
                querySql = "select count(*) as num from Resources where title like '%" + searchTxt + "%'";
            }
            else {
                querySql = "select count(*) as num from Resources where category='" + category + "' and title like '%" + searchTxt + "%'";
            }
            _shellcmd.retriveDbAsyn(dbPath, querySql).done(function (res) {
                console.log(res);
                var numJson = JSON.parse(res);
                def.resolve(numJson.data[0].num);
            });
            return def.promise();
        }

        _self.devideResTxtCategory = function (searchTxt, category, dbPath, offsetnum) {
            var def = $.Deferred();
            var querySql = "";
            category = _self.changeCategory(category);
            if (!searchTxt) {
                def.resolve(null);
            } else if (!category || category == AppResTipList.allCategory) {
                querySql = "select * from Resources where title like '%" + searchTxt + "%' limit 10 offset " + offsetnum;
            } else {
                querySql = "select * from Resources where category='" + category + "' and title like '%" + searchTxt + "%' limit 10 offset " + offsetnum;
            }
            _shellcmd.retriveDbAsyn(dbPath, querySql).done(function (resStr) {
                var resList = _self._convertDbItemsToResItems(resStr);
                def.resolve(resList);
            })
            return def.promise();
        }

        /**
         * 删除已下载资源
         * @param resId
         * @param filePath
         * @returns {boolean}
         */
        _self.deleteResource = function (resId, filePath, dbPath) {
            var def = $.Deferred();
            var sqlStr = 'delete from Resources where id="' + resId + '"';
            _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
                if (ret) {
                    //拼接文件夹路径
                    var filePathStr = filePath.split("/");
                    var file = "";
                    for (var i = 0; i < filePathStr.length - 2; i++) {
                        file += filePathStr[i] + "\\";
                    }
                    file += filePathStr[filePathStr.length - 2];
                    _shellcmd.deleteDir(file).done(function (ret1) {
                        def.resolve(ret1);
                    })
                } else {
                    def.resolve(ret);
                }
            });
            return def.promise();
        }

        /**
         * 已下载资源批量删除
         * @param resInfoList 由资源id和filePath组成的对象数组
         * @param dbPath
         */
        _self.deleteResALot = function (resInfoList, dbPath) {
            var def = $.Deferred();
            var sqlStr = 'delete from Resources where id in ("' + resInfoList[0].id;
            var i = 0, len = resInfoList.length;
            var filePath = "";
            for (i = 1; i < len; i++) {
                sqlStr += '","' + resInfoList[i].id;
            }
            sqlStr += '")';
            _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
                var fileString = "";
                var file = [], j = -1;
                for (i = 0; i < len; i++) {
                    file[++j] = "";
                    filePath = resInfoList[i].url;
                    //拼接文件夹路径，把“/”转义成“\\”,删除文件夹
                    var filePathStr = filePath.split("/");
                    for (var k = 0; k < filePathStr.length - 2; k++) {
                        file[j] += filePathStr[k] + "\\";
                    }
                    file[j] += filePathStr[filePathStr.length - 2];
                }
                fileString = file.join('|');
                _shellcmd.deleteDir(fileString).done(function () {
                    def.resolve();
                });
            });
            return def.promise();
        }

        /**
         * 将资源信息写到本地数据库
         * @param resJson
         * 这个函数应该是不会运行到了，插入数据库的操作已放至delphi层，下载完成后自动调用
         */
        _self.addResource = function (resItem, dbPath) {
            var def = $.Deferred();
            _self.checkResourceExist(resItem.id, dbPath).done(function (isResExist) {
                var sqlStr = "";
                if (isResExist) {
                    /**
                     * 其实可以不用这么做，sqlite有个命令是replace
                     */
                    sqlStr = 'update Resources set '
                        + 'title="' + resItem.title + '",'
                        + 'file="' + resItem.file + '",'
                        + 'thumbnail="' + resItem.thumbnail + '",'
                        + 'grade="' + resItem.grade + '",'
                        + 'subject="' + resItem.subject + '",'
                        + 'volumn="' + resItem.volumn + '",'
                        + 'unit="' + resItem.unit + '",'
                        + 'course="' + resItem.course + '",'
                        + 'description="' + resItem.description + '",'
                        + 'bookCode="' + resItem.bookCode + '",'
                        + 'category="' + resItem.category + '",'
                        + 'extension="' + resItem.extension + '",'
                        + 'fileSize="' + resItem.fileSize + '",'
                        + 'downloadDate="' + resItem.downloadDate + '",'
                        + 'reserve1="' + resItem.reserve1 + '",'
                        + 'reserve2="' + resItem.reserve2 + '"'
                        + ' where id="' + resItem.id + '"';
                } else {
                    // 写入本地数据库
                    sqlStr = 'insert into Resources(id,title,file,thumbnail,grade,' +
                        'subject,volumn,unit,course,description,bookCode,category,' +
                        'extension,fileSize,downloadDate,reserve1,reserve2) values("'
                        + resItem.id + '","'
                        + resItem.title + '","'
                        + resItem.file + '","'
                        + resItem.thumbnail + '","'
                        + resItem.grade + '","'
                        + resItem.subject + '","'
                        + resItem.volumn + '","'
                        + resItem.unit + '","'
                        + resItem.course + '","'
                        + resItem.description + '","'
                        + resItem.bookCode + '","'
                        + resItem.category + '","'
                        + resItem.extension + '","'
                        + resItem.fileSize + '","'
                        + resItem.downloadDate + '","'
                        + resItem.reserve1 + '","'
                        + resItem.reserve2 + '")';
                }
                _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
                    def.resolve(ret);
                });
                return def.promise();
            });
        }

        /**
         * 将数据库数据转换为资源数据结构
         * @param queryResultStr
         * @returns {Array}
         * @private
         */
        _self._convertDbItemsToResItems = function (queryResultStr) {
            var resList = new Array();
            if (queryResultStr == "") {
                return resList;
            }
            var resJson = null;
            try {
                resJson = JSON.parse(queryResultStr);
            }
            catch (e) {
                return resList;
            }
            var data = resJson.data;
            for (var item in data) {
                var resItem = new ResourceItem();
                resItem.id = data[item].id;
                resItem.title = data[item].title;
                resItem.file = data[item].file;
                resItem.thumbnail = data[item].thumbnail;
                resList.push(resItem);
            }
            return resList;
        }
    }

    exports.Instance = new ResourceProvider();
})
;