/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-7-10
 * Time: 下午5:58
 * To change this template use File | Settings | File Templates.
 */
/****************************************************************
 *
 * 如果你在2014-07-25以后看到这里，估计你跟踪代码跟踪错了位置
 * 这里的代码用以实现是iflybook1.0版的搜索面板
 * 估计现在已经没啥用了。
 * 出于对xhrong大神的尊敬，我决定不删除这一模块。
 * 至于其他，你自己看着办。
 *
 *         ---------  by yczhu
 *
 **************************************************************/

define(function (require, exports, module) {

    require('jquery');
    var path = require('../../../common/path');
    var Messenger = require('../../../thirdparty/messenger');
    require('../../../common/selectbox.js');
    require('zebra_dialog');
    var _define = require('../../define');
    var _shellcmd = require('../../../common/shellcmd');
    var ResourceManagerBase = require('./resourcemanagerbase').ResourceManagerBase;
    var resourceProvider = require('./resourceprovider');
    var ebookContext = require('../../ebookcontext').Instance;
    var _commonfunc = require('../../../common/commonfunc');
    var _userData = require('../../../common/userdata').Instance;

    function SearchManager() {

        var _self = this;
        _self.buttons = {};
        _self.controls = {};

        //搜索模式，本地搜索或联网搜索
        _self.currentSearchMode = _define.SearchMode.CloudSearch;
        _self._localSearchList = null;

        _self.pageBtnCount = 6;
        _self.category = AppResTipList.allCategory;
        _self.searchText = "";

        _self.searchWay = "";

        /**
         *
         * @param buttons   按钮
         * @param controls  非按钮类控件
         * @param bookContainer
         */
        _self.init = function (buttons, controls, bookContainer) {
            _self.bookContainer = bookContainer;
            _self.buttons = buttons;
            _self.controls = controls;

            if(AppCfg.lang == "uyghur"){
                $(".hcss_tab").css("width","220px");
                $("#innerSearchText").css("width","112px");
                $("#innerhcsssearch").css("width","240px");
                $(".hcss_cuttab li ").css("font-size","14px");
            }

            if (!ebookContext.getUser().getIsOnline()) {
                _self.setSearchMode(_define.SearchMode.LocalSearch);
            }
            else {
                _self.setSearchMode(_define.SearchMode.CloudSearch);
            }

            _self.controls.outerSearchText[0].onfocus = function(){
                if(this.value == AppResTipList.inputKey){
                    this.value='';
                    this.style.color='#000';
                }
            }

            _self.buttons.btnOuterSearch.click(function () {
                var searchText = _self.controls.outerSearchText.val();
                if (_self.controls.outerSearchText.css("color") != "rgb(153, 153, 153)") {
                    _self.controls.innerSearchText.val(searchText);
                    _self.searchText = searchText;
                }
                _self.search(_self.currentSearchMode, _self.searchText, null, true);
            });
            _self.buttons.btnInnerSearch.click(function () {
                _self.searchText = _self.controls.innerSearchText.val();
                _self.search(_self.currentSearchMode, _self.searchText, _self.category);
            });
            _self.buttons.btnInnerCloudSearch.click(function () {
                _self.searchText = _self.controls.innerSearchText.val();
                _self.IsCanCloudeSearch(ebookContext.getUser().getIsOnline());
                _self.search(_self.currentSearchMode, _self.searchText);
            });
            _self.buttons.btnInnerWebSearch.click(function () {
                _self.searchText = _self.controls.innerSearchText.val();
                _self.setSearchMode(_define.SearchMode.WebSearch);
                _self.search(_self.currentSearchMode, _self.searchText);
            });
            _self.buttons.btnInnerLocalSearch.click(function () {
                _self.searchText = _self.controls.innerSearchText.val();
                _self.setSearchMode(_define.SearchMode.LocalSearch);
                _self.search(_self.currentSearchMode, _self.searchText, _self.category);
            });
            _self.buttons.btnCloseSearchPanel.click(function () {
                _self.hideSearchPanel();
            });

            _self.buttons.btnInnerSearchWriteIme.click(function () {
                //单例调用输入法程序 PC_Win32_iFlyInk
                _shellcmd.callSingleton('iFlyInk.exe', "write", _self.controls.innerSearchText);

            });
            _self.buttons.btnInnerSearchVoiceIme.click(function () {
                _shellcmd.killProcess('PC_Win32_iFlyInk').done(function () {
                    //单例调用输入法程序
                    _shellcmd.callSingleton('iFlyVoice.exe', "voice", _self.controls.innerSearchText);
                });
            });
            _self.buttons.btnInnerSearchKeyboardIme.click(function () {
                _shellcmd.callIme("keyboard", _self.controls.innerSearchText);
            });

            _self.buttons.btnOuterSearchWriteIme.click(function () {
                //单例调用输入法程序
                _shellcmd.callSingleton('iFlyInk.exe', "write", _self.controls.outerSearchText).done(function () {
                    _self.controls.outerSearchText.focus();
                });
            });
            _self.buttons.btnOuterSearchVoiceIme.click(function () {
                //callClient('syscmd', 'killprocess', 'iFlyInk.exe', 0, function () {});
                _shellcmd.killProcess('iFlyInk.exe').done(function () {
                    //单例调用输入法程序
                    _shellcmd.callSingleton('iFlyVoice.exe', "voice", _self.controls.outerSearchText);
                });
            });
            _self.buttons.btnOuterSearchKeyboardIme.click(function () {
                _shellcmd.callIme("keyboard", _self.controls.outerSearchText);
            });

            _self.controls.innerSearchText.keypress(function (e) {
                var key = e.which; //e.which是按键的值
                if (key == 13) {
                    //13 是 Enter 键的键码
                    _self.buttons.btnInnerSearch.trigger("click");
                }
            });

            _self.controls.outerSearchText.keypress(function (e) {
                var key = e.which; //e.which是按键的值
                if (key == 13) {
                    //13 是 Enter 键的键码
                    _self.buttons.btnOuterSearch.trigger("click");
                }
            });

            _self.buttons.btnInnerSearchAll.click(function () {
                _self.buttons.btnInnerSearchAll.removeClass("btn_gray").addClass("btn_green");
                _self.buttons.btnInnerSearchClass.removeClass("btn_green").addClass("btn_gray");
                _self.buttons.btnInnerSearchFile.removeClass("btn_green").addClass("btn_gray");
                _self.category = AppResTipList.allCategory;
                _self.setSearchMode(_define.SearchMode.LocalSearch);
                _self.search(_self.currentSearchMode, _self.searchText, _self.category);
            });

            _self.buttons.btnInnerSearchClass.click(function () {
                _self.buttons.btnInnerSearchClass.removeClass("btn_gray").addClass("btn_green");
                _self.buttons.btnInnerSearchAll.removeClass("btn_green").addClass("btn_gray");
                _self.buttons.btnInnerSearchFile.removeClass("btn_green").addClass("btn_gray");
                _self.category = AppResTipList.Courseware;
                _self.setSearchMode(_define.SearchMode.LocalSearch);
                _self.search(_self.currentSearchMode, _self.searchText, _self.category);
            });

            _self.buttons.btnInnerSearchFile.click(function () {
                _self.buttons.btnInnerSearchFile.removeClass("btn_gray").addClass("btn_green");
                _self.buttons.btnInnerSearchClass.removeClass("btn_green").addClass("btn_gray");
                _self.buttons.btnInnerSearchAll.removeClass("btn_green").addClass("btn_gray");
                _self.category = AppResTipList.MaterialDocuments;
                _self.setSearchMode(_define.SearchMode.LocalSearch);
                _self.search(_self.currentSearchMode, _self.searchText, _self.category);
            });

            _self.messenger = Messenger.initInParent(_self.controls.searchIfrm[0]);
            _self.messenger.onmessage = function (data) {
                _self._dataReceived = data;
                var receiveJson = JSON.parse(data);
                if (receiveJson.evt == "querypagemetadata") {
                    var sourcepage = (receiveJson.data && receiveJson.data.sourcepage) ? receiveJson.data.sourcepage : "reslib";
                    var respJsonStr = _self.prepareCurrentPageMetaData(sourcepage);
                    dispatchClientMsg(respJsonStr);
                } else if (receiveJson.evt == "queryreslibconfig") {
                    //将本地资源库配置信息发给服务器
                    var sourcepage = (receiveJson.data && receiveJson.data.sourcepage) ? receiveJson.data.sourcepage : "searchresult";
                    var respJsonStr = _self.prepareConfigInfoForResLib(sourcepage);
                    dispatchClientMsg(respJsonStr);
                }
                else if (receiveJson.evt == "add_tag") { //添加非下载类资源
                    var resJson = receiveJson.data;
                    if (resJson.source == "poem") {//添加诗词
                        var options = {};
                        options.title = resJson.title;
                        _self.bookContainer.insertSingleWidget("", _define.WidgetType.Evaluate, _define.EvalCardType.Poem, options);

                    } else if (resJson.source == "dictionary") {//添加字典
                        console.log("dictionary:" + data);
                        var options = {};
                        var file = resJson.file;
                        options.title = resJson.title;
                        _self.bookContainer.insertSingleWidget(file, _define.WidgetType.OnlineRes, _define.OnlineResType.Dictionary, options);

                    } else if (resJson.source == "strokeorder") {//添加笔顺
                        console.log("strokeorder:" + data);
                        var options = {};
                        var file = resJson.file;
                        options.title = resJson.title;

                        _self.bookContainer.insertSingleWidget(file, _define.WidgetType.OnlineRes, _define.OnlineResType.StrokeOrder, options);

                    } else if (resJson.source == "simexpert") { //添加仿真实验
                        console.log("simexpert:" + data);
                        var options = {};
                        var file = resJson.file;
                        options.title = resJson.title;
                        _self.bookContainer.insertSingleWidget(file, _define.WidgetType.OnlineRes, _define.OnlineResType.VirtualExperiment, options);

                    }
                    var sourcepage = resJson.sourcepage ? resJson.sourcepage : "searchresult";
                    var respJsonStr = _self.addTagResponseInfo(resJson.id, sourcepage);
                    dispatchClientMsg(respJsonStr);

                    var logObj = {
                        type: resJson.extension,
                        source: resJson.source,
                        bookcode: _self.bookContainer.bookCode,
                        url: ""
                    }
                    _userData.start("add", logObj);
                }
                else if (receiveJson.evt == "filedownload") { //添加下载资源
                    var resJson = receiveJson.data;
                    //先写log，再添加资源
                    var logObj = {
                        type: resJson.extension,
                        source: resJson.source,
                        bookcode: _self.bookContainer.bookCode,
                        url: resJson.file
                    }
                    _userData.start("add", logObj).done(function () {
                        var sourcepage = resJson.sourcepage ? resJson.sourcepage : "searchresult";
                        if (resJson.extension == "mtbk") {
                            _self.downloadMtbk(resJson, sourcepage);
                        } else {
                            var resId = resJson.id;
                            resourceProvider.Instance.checkResourceExist(resId, ebookContext.getUser().getUserDbFullPath())
                                .done(function (isExist) {
                                    if (isExist) {//如果已经存在本地，则不再下载
                                        resourceProvider.Instance.getResourceById(resId, ebookContext.getUser().getUserDbFullPath())
                                            .done(function (resItem) {
                                                console.log(JSON.stringify(resItem));
                                                _self.addResToPage(resItem);
                                                //发送下载进度，默认下载完成
                                                var msg = '{"evt":"file_download","data":{"sourcepage":"' + sourcepage + '","id":"' + resId + '","progress":"2"}}';
                                                dispatchClientMsg(msg);
                                            });
                                    } else {
                                        //添加文件来源
                                        resJson["sourcepage"] = sourcepage;
                                        resJson["savepath"] = ebookContext.getUser().getUserResourceRelativeBasePath() + '/' + resJson.id;  //文件保存路径
                                        resJson["dbpath"] = ebookContext.getUser().getUserDbFullPath();
                                        var downloadRawData = JSON.stringify(resJson);
                                        _shellcmd.fileDownload(downloadRawData);
                                    }
                                });
                        }
                    });
                }
            };

            _self.controls.SearchPageBtnPanel.find('input').click(function () {
                var pageBtnNum = $(this).attr("value");
                _self.changePageBtn(pageBtnNum);
                var txtStr = _self.searchText.replace("'", "''");
                resourceProvider.Instance.devideResTxtCategory(txtStr, _self.category, _self.user.getUserDbFullPath(), pageBtnNum * 10 - 10).done(function (resList) {
                    _self._localSearchList = resList;
                    _self.controls.searchItems.html('');
                    //渲染list
                    var lstlen = resList.length;
                    if (lstlen == 0) {
                        //无记录提示“没有资源”
                        _self.controls.noSearchResTips.css("display", "block");
                        return;
                    }
                    _self.controls.noSearchResTips.css("display", "none");
                    var basePath = path.trimPosix(Config.binPath);
                    for (var i = 0; i < lstlen; i++) {
                        var resItem = $("<li></li>");
                        resItem.addClass("normal");
                        var thumbnail = $("<div></div>");
                        thumbnail.addClass("img");
                        var link = $("<div></div>");
                        link.attr("id", _self._localSearchList[i].id);
                        //如果物理文件地址为空，删除时会出问题
                        link.attr("file", basePath + _self._localSearchList[i].file);
                        link.attr("title", _self._localSearchList[i].title);
                        link.click(function () {
                            var url = $(this).attr("file");
                            var id = $(this).attr("id");
                            if (url == "" || id == "") {
                                return false;
                            }
                            var files = new Array();
                            files[0] = url;
                            _self.bookContainer.insertWidget(files);
                            return false;
                        });
                        var img = $("<img/>");
                        if (_self._localSearchList[i].thumbnail == '') {
                            img.attr("src", _self.getDefaultThumbnail(_self._localSearchList[i].file));
                        }
                        else
                            img.attr("src", Config.binPath + _self._localSearchList[i].thumbnail);
                        link.append(img);
                        thumbnail.append(link);
                        var _text = _self._localSearchList[i].title;
                        //有后缀名
                        var dotPlace = _self._localSearchList[i].title.lastIndexOf(".");
                        if (dotPlace != -1 && dotPlace >= 8) {
                            _text = _self._localSearchList[i].title.substr(0, 8) + "..." + _self._localSearchList[i].title.substr(dotPlace);
                        }
                        //没有后缀名
                        if (dotPlace == -1) {
                            if (_self._localSearchList[i].title.length >= 12) {
                                _text = _self._localSearchList[i].title.substr(0, 8) + "..." + _self._localSearchList[i].title.substr(-3);
                            }
                        }

                        var title = $("<div></div>").text(_text);
                        title.addClass("text");
                        resItem.append(thumbnail);
                        resItem.append(title);
                        _self.controls.searchItems.append(resItem);
                    }
                });
            });
        }

        _self.IsCanCloudeSearch = function (canFlag) {
            if (!canFlag) {
                $.Zebra_Dialog(AppTips.LocalLoignMsg, {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [ AppTips.OkTips]
                });
                _self.setSearchMode(_define.SearchMode.LocalSearch);
                return;
            }
            _self.setSearchMode(_define.SearchMode.CloudSearch);
        }

        _self.setSearchMode = function (searchMode) {
            _self.currentSearchMode = searchMode;
            //设置选中状态
            if (_self.currentSearchMode == _define.SearchMode.CloudSearch) {
                _self.buttons.btnInnerCloudSearch.addClass("current");
                _self.buttons.btnInnerLocalSearch.removeClass("current");
                _self.buttons.btnInnerWebSearch.removeClass("current");
            }
            else if (_self.currentSearchMode == _define.SearchMode.LocalSearch) {
                _self.buttons.btnInnerLocalSearch.addClass("current");
                _self.buttons.btnInnerCloudSearch.removeClass("current");
                _self.buttons.btnInnerWebSearch.removeClass("current");
            }
            else if (_self.currentSearchMode == _define.SearchMode.WebSearch) {
                _self.buttons.btnInnerWebSearch.addClass("current");
                _self.buttons.btnInnerCloudSearch.removeClass("current");
                _self.buttons.btnInnerLocalSearch.removeClass("current");
            }
        }

        _self.search = function (searchMode, searchText, category, isOuter) {
            if (searchMode == _define.SearchMode.CloudSearch || searchMode == _define.SearchMode.WebSearch) {
                rawUrl = AppRemoteSvcCfg.SearchPageUrl;
                //把双引号转义,在ajax传json时会被截断
                searchText = searchText.replace('"', '\\\"');
                //如果是在面板内部进行云资源搜索，并且当前面板是云资源面板，则不用全部刷新
                if (!isOuter && _self.controls.searchIfrm.is(":visible") && searchMode == _define.SearchMode.CloudSearch &&
                    _self.searchWay == "Cloud") {
                    var msg = '{"evt":"search","data":{"sourcepage":"searchresult","keyword":"' + searchText + '"}}';
                    dispatchClientMsg(msg);
                } else if (!isOuter && _self.controls.searchIfrm.is(":visible") && searchMode == _define.SearchMode.WebSearch &&
                    _self.searchWay == "Web") {
                    var msg = '{"evt":"search","data":{"sourcepage":"searchresult","keyword":"' + searchText + '"}}';
                    dispatchClientMsg(msg);
                }
                else {
                    var userName = ebookContext.getUser().getName();
                    var bookCode = _self.bookContainer.bookMetaInfo.bookCode;
                    var unit = _self.bookContainer.getCurrUnit();
                    var course = _self.bookContainer.getCurrCourse();
                    var subject = _self.bookContainer.bookMetaInfo.subject;
                    var ticket = ebookContext.getUser().getTicket();
                    if (searchMode == _define.SearchMode.CloudSearch) {
                        var url = rawUrl + "&uid=" + userName + "&bookCode=" + bookCode + "&course=" + course
                            + "&unit=" + unit + "&subject=" + subject
                            + "&keyword=" + searchText + "&ticket=" + ticket + "&way=smart";
                        _self.searchWay = "Cloud";
                    }
                    else if (searchMode == _define.SearchMode.WebSearch) {
                        var url = rawUrl + "&uid=" + userName + "&bookCode=" + bookCode + "&course=" + course
                            + "&unit=" + unit + "&subject=" + subject
                            + "&keyword=" + searchText + "&ticket=" + ticket + "&way=web";
                        _self.searchWay = "Web";
                    }
                    console.log("search url:" + url);
                    _self.showSearchPanel(searchMode, url, '');
                }
            }
            else {
                //把单引号转义,在delphi中单引号本身是转义字符
                searchText = searchText.replace("'", "''");
                _self.showSearchPanel(searchMode, '', searchText, category);
            }
        }

        /**
         *隐藏搜索面板
         */
        _self.hideSearchPanel = function () {
            _self.controls.searchIfrm.attr("src", "");
            _self.buttons.btnSelectedCategory.val(AppResTipList.allCategory);
            _self.controls.searchPanel.hide();
            //清除网络连接提示信息DIV元素
            _self.controls.searchContentPanel.find(".tips_box").remove();
            //隐藏语音输入法的听写面板
            window.iatinput.closeIat();
        }

        /**
         * 显示搜索面板
         * @param isNetwork 是否是网络资源库
         * @param url
         */
        _self.showSearchPanel = function (searchMode, url, searchText, category) {

            //让搜索框释放焦点，否则后面在显示板擦图标时会有影响
            _self.controls.outerSearchText.blur();

            if (!_self.controls.searchPanel.is(":visible")) {
                var offsetX = (screen.width - 800) + "px";
                var offsetY = "120px";
                _self.controls.searchPanel.css({"top": offsetY, "left": offsetX });
                if (Config.Width < 1000) {
                    correctToBaseResolution(_self.controls.searchPanel, {keepScale: true});
                }
            }
            if (searchMode == _define.SearchMode.CloudSearch || searchMode == _define.SearchMode.WebSearch) {
                _self.controls.localSearchPanel.hide();
                _self.controls.searchPanel.show();
                _self.controls.searchIfrm.show();
                //设置网络连接异常DIV样式
                var panel = _self.controls.searchContentPanel;
                var top = _self.controls.searchContentTop;
                var iframe = _self.controls.searchIfrm;
                var marginTop = (panel.height() - top.height() - 30) / 2;
                var marginLeft = (panel.width() - 260) / 2;
                var tipsStyle = 'top:40px;position: absolute;margin-top:{0}px;margin-left:{1}px'.format(marginTop, marginLeft);
                _commonfunc.online(url, iframe, tipsStyle, panel);
            }
            else {
                _self.controls.searchItems.html('');
                _self.loadSearchView(searchText, category);
                _self.controls.localSearchPanel.show();
                _self.controls.searchIfrm.hide();
                //清除网络连接提示信息DIV元素
                _self.controls.searchContentPanel.find(".tips_box").remove();
            }
            _self.controls.searchPanel.show();
            _self.controls.searchPanelMask.hide();
            _self.controls.searchPanel.draggable({
                handle: "#" + _self.controls.searchPanelTop.attr("id"),
                containment: "window",
                start: function () {
                    _self.controls.searchPanelMask.show();
                },
                stop: function () {
                    _self.controls.searchPanelMask.hide();
                }
            });
        }

        /**
         * 加载本地资源
         * @param queryParam 查询条件
         */
        _self.loadSearchView = function (searchText, category) {
            if (searchText == null || searchText == undefined || searchText == "") {
                _self.noResToShow();
            } else {
                resourceProvider.Instance.getCountTxtCategory(searchText, category, _self.user.getUserDbFullPath()).done(function (num) {

                    if (num == 0) {
                        _self.noResToShow();
                    }
                    else {
                        _self.resBtnCount = parseInt(num / 10) + (num % 10 == 0 ? 0 : 1);
                        _self.controls.SearchPageBtnPanel.show();
                        _self.controls.ResCountValue.text(num);
                      //  $("#ResCountDiv").text(AppResTipList.hasGet + num + AppResTipList.resNum);

                        _self.controls.SearchPageBtnPanel.find('input:eq(0)').attr("value", "1").trigger("click");
                    }
                });
            }
        }

        //没有资源显示时的提示
        _self.noResToShow = function () {
            _self.controls.searchItems.html('');
            _self.controls.SearchPageBtnPanel.hide();

            _self.controls.ResCountValue.text(0);
            _self.controls.noSearchResTips.css("display", "block");
        }

        _self.changePageBtn = function (num) {
            var _num = parseInt(num);
            if (_self.resBtnCount == 0) {
                return;
            }
            var btns = _self.controls.SearchPageBtnPanel.find('input');
            btns.removeClass("btn_flip2").addClass("btn_flip");
            console.log("_self.resBtnCount--" + _self.resBtnCount);
            if (_num < 4) {
                $(btns[0]).attr("value", "1").show();
                $(btns[1]).attr("value", "2").show();
                $(btns[2]).attr("value", "3").show();
                $(btns[3]).attr("value", "4").show();
                $(btns[4]).attr("value", "5").show();
                $(btns[5]).attr("value", "6").show();
                $(btns[6]).attr("value", "7").show();
                switch (_num) {
                    case 1:
                        $(btns[0]).removeClass("btn_flip").addClass("btn_flip2");
                        break;
                    case 2:
                        $(btns[1]).removeClass("btn_flip").addClass("btn_flip2");
                        break;
                    case 3:
                        $(btns[2]).removeClass("btn_flip").addClass("btn_flip2");
                        break;
                    default :
                }
                //故意没写break；
                switch (_self.resBtnCount) {
                    case 1:
                        $(btns[1]).hide();
                    case 2:
                        $(btns[2]).hide();
                    case 3:
                        $(btns[3]).hide();
                    case 4:
                        $(btns[4]).hide();
                    case 5:
                        $(btns[5]).hide();
                    case 6:
                        $(btns[6]).hide();
                    default :
                }
            }
            else {
                $(btns[0]).attr("value", _num - 3).show();
                $(btns[1]).attr("value", _num - 2).show();
                $(btns[2]).attr("value", _num - 1).show();
                $(btns[3]).attr("value", _num).show();
                $(btns[4]).attr("value", _num + 1).show();
                $(btns[5]).attr("value", _num + 2).show();
                $(btns[6]).attr("value", _num + 3).show();

                if (_num + 3 <= _self.resBtnCount) {
                    $(btns[3]).removeClass("btn_flip").addClass("btn_flip2");
                }
                else {
                    $(btns[0]).attr("value", _self.resBtnCount - 6).show();
                    $(btns[1]).attr("value", _self.resBtnCount - 5).show();
                    $(btns[2]).attr("value", _self.resBtnCount - 4).show();
                    $(btns[3]).attr("value", _self.resBtnCount - 3).show();
                    $(btns[4]).attr("value", _self.resBtnCount - 2).show();
                    $(btns[5]).attr("value", _self.resBtnCount - 1).show();
                    $(btns[6]).attr("value", _self.resBtnCount).show();

                    if (_num == _self.resBtnCount) {
                        $(btns[6]).removeClass("btn_flip").addClass("btn_flip2");
                    }
                    else if (_num + 1 == _self.resBtnCount) {
                        $(btns[5]).removeClass("btn_flip").addClass("btn_flip2");
                    }
                    else if (_num + 2 == _self.resBtnCount) {
                        $(btns[4]).removeClass("btn_flip").addClass("btn_flip2");
                    }
                    switch (_self.resBtnCount) {
                        case 4 :
                            $(btns[2]).hide();
                        case 5 :
                            $(btns[1]).hide();
                        case 6 :
                            $(btns[0]).hide();
                        default :
                    }
                    ;
                }
            }
        }

        _self.setIsEditing=function(value){
            !value&&_self.hideSearchPanel();
        }
    }

    SearchManager.prototype = new ResourceManagerBase();
    SearchManager.prototype.constructor = SearchManager;

    exports.SearchManager = SearchManager;
});