define(function(require, exports, module){
    require('jquery');
    var _shellcmd = require('../../../common/shellcmd'),
        _ebookContext = require('../../ebookcontext').Instance;

    function ResAccessor(){
        var _self = this;
        _self.bookContainer = bookContainer;
        _self._dynamicToken = {
            access_token : "",
            token_type : "",
            expires_in : 0,
            scope : ""
        };

    //文件后缀分类转换
    _self.extensionToImg = function(str,prefix,suffix){
            if(typeof(prefix) == "undefined") {
                prefix = "";
            }
            if(typeof(suffix) == "undefined") {
                prefix = "";
            }
            var icon = '';
            switch(str) {
                case "ppt":case "pptx":case "pps":case "ppsx":
                icon = 'ppt';
                break;
                case "doc":case "docx":case "txt":case "rtf":
                icon = 'word';
                break;
                case "jpg":case "jpeg":case "bmp":case "png":case "gif":case "psd":case "gsp":case "gss":
                icon = 'pic';
                break;
                case "mp3":case "wma":case "wav":case "ogg":case "ape":case "mid":case "midi":case "tch":
                icon = 'music';
                break;
                case "rmvb":case "mp4":case "avi":case "wmv":case "asf":case "3gp":case "flv":case "mpg":case "mpeg":case "mpeg4":case "rm":case "mpeg4":case "mov":case "vob":case "mkv":case "m2ts":
                icon = 'video';
                break;
                case "swf":case "flash":case "flc":case "fla":
                icon = 'flash';
                break;
                case "icw":
                    icon = 'icw';
                    break;
                case "pdf":
                    icon = 'pdf';
                    break;
                default:
                    icon = 'null';
            }
            return prefix + icon + suffix;
        };

    //备课本（本地）数据格式化输出，和云端新接口返回数据字段一致
    _self.parseLocalLessonPrepares = function(localLessonPrepares){
        //处理结果
        var localDbRes = [],
            i = 0,
            length = localLessonPrepares.length;
        for (;i < length; i++) {
            var item = localLessonPrepares[i];
            var data = {
                //处理字段
                "checked": false,
                "hasdownLoad": true,
                "hasUpload": "unknow", //读取本地资源，后续和云端集成判断时可以改变这个属性
                "from": "local",
                "extension": item.type,
                //返回字段
                "bookcode": item.bookcode,
                "length": typeof (item.size) == "undefined" ? '' : item.size,//大小
                "fromapp": typeof (item.creator) == "undefined" ? _ebookContext.getUser().getUserName() : item.creator, //来源
                "fid": item.fileid,
                "filepath": item.filepath,
                "localpath": _ebookContext.getUser().getUserPpticwsBasePath() + '/'+ item.timestamp + '/' + item.filepath,
                "name": item.filename,
                "aliasname": item.filename,
                "modifytime": item.lasttime,
                "timestamp": item.timestamp,
                "unit1": item.unit1,
                "unit2": item.unit2,
                "unit3": item.unit3,
                "unit4": item.unit4,
                "usedtime": item.usedtime,
                "userName":item.creator
            };
            localDbRes.push(data);
        }
        return localDbRes;
    };

        //备课本（本地）resource.db数据格式化输出，和云端新接口返回数据字段一致
        _self.parseLocalLessonPrepares_ext = function(localLessonPrepares){
            //处理结果
            var localDbRes = [],
                i = 0,
                length = localLessonPrepares.length;
            for (;i < length; i++) {
                var item = localLessonPrepares[i];
                var data = {
                    //处理字段
                    "checked": false,
                    "hasdownLoad": true,
                    "hasUpload": "unknow", //读取本地资源，后续和云端集成判断时可以改变这个属性
                    "from": item.type,
                    "extension": item.mime,
                    //返回字段
                    "bookcode": typeof (item.bookCode) == "undefined" ? '' : item.bookCode,
                    "length": typeof (item.size) == "undefined" ? '' : item.size,//大小
                    "fromapp": typeof (item.source) == "undefined" ? _ebookContext.getUser().getUserName() : item.source, //来源
                    "fid": item.resId,
                    "filepath": item.fileName + '.' + item.mime,
                    "localpath": path.join(_ebookContext.getUser().getUserBookResourceBasePath(item.bookCode),item.uuid + '/' + item.fileName + '.' + item.mime),
                    "name": item.fileName,
                    "aliasname": item.fileName,
                    "modifytime": item.modifyTime,
                    "timestamp": item.createTime,
                    "unit1": item.unit1,
                    "unit2": item.unit2,
                    "unit3": item.unit3,
                    "unit4": item.unit4,
                    "usedtime": item.modifyTime,
                    "userName":item.source,
                    "uuid": typeof (item.uuid) == "undefined" ? '' : item.uuid,
                    "isDir": typeof (item.isDir) == "undefined" ? '' : item.isDir,
                    "parentDir": typeof (item.parentDir) == "undefined" ? '' : item.parentDir,
                    "parentName": typeof (item.parentName) == "undefined" ? '' : item.parentName,
                    "md5": typeof (item.md5) == "undefined" ? '' : item.md5,
                    "size": typeof (item.size) == "undefined" ? '' : item.size
                };
                localDbRes.push(data);
            }
            return localDbRes;
        };

    //备课本（云端）数据格式化输出
    _self.parseCloudLessonPrepares = function(cloudLessonPrepares){
            try{
                length = cloudLessonPrepares.length;
            }catch(e) {
                var cloudRes=[];
                return cloudRes;
            }
            //处理结果
            var cloudRes = [],
                i = 0,
                length = cloudLessonPrepares.length;
            for (; i < length; i++){
                var item = cloudLessonPrepares[i];
                var hasdownLoad = "unknow";
                var data = {
                    //处理字段
                    "hasdownLoad" : hasdownLoad,
                    "checked": false,
                    "from": "cloud",
                    "extension" : item.fileInfo.extension,
                    //返回字段
                    "fid" : item.fileInfo.fid,
                    "name" : item.fileInfo.name,
                    "aliasname" : item.fileInfo.aliasname,
                    "createtime" : item.fileInfo.createtime,
                    "customProperties" : item.fileInfo.customProperties,
                    "description" : item.fileInfo.description,
                    "downloadpath" : item.fileInfo.downloadpath,
                    "filecounts" : item.fileInfo.filecounts,
                    "foldertype" : item.fileInfo.foldertype,
                    "fromapp" : item.fileInfo.fromapp,
                    "fromtype" : item.fileInfo.fromtype,
                    "iscomplete" : item.fileInfo.iscomplete,
                    "isdir" : item.fileInfo.isdir,
                    "ishidden" : item.fileInfo.ishidden,
                    "isopen" : item.fileInfo.isopen,
                    "isreadonly" : item.fileInfo.isreadonly,
                    "length" : item.fileInfo.length,
                    "md5" : item.fileInfo.md5,
                    "modifytime" : item.fileInfo.modifytime,
                    "parentfolder" : item.fileInfo.parentfolder,
                    "previewpath" : item.fileInfo.previewpath,
                    "property" : item.fileInfo.property,
                    "security" : item.fileInfo.security,
                    "thumbpath" : item.fileInfo.thumbpath,
                    "total" : item.fileInfo.total,
                    "uid" : item.fileInfo.uid,
                    "version" : item.fileInfo.version,
                    "share" : item.share,
                    "platForm" : "xf"
                };
                cloudRes.push(data);
            }
            return cloudRes;
        };

    //根据bookcode判断云端备课本Id是否存在
    _self.isExistCloudBeikeId = function(bookcode,beikeList){
        var map_bookbeike = [],
            beikeId = '';
        for (var i = 0,length = beikeList.length; i < length; i++){
            if(!map_bookbeike[beikeList[i].bookcode]){
                map_bookbeike[beikeList[i].bookcode] = beikeList[i].fid;
            }
        }
        if(typeof(map_bookbeike[bookcode]) != "undefined") {
            beikeId = map_bookbeike[bookcode];
            return beikeId;
        }
        return false;
    };

    //资源数据格式转换
    _self.resDataFilterByResType = function(data,type,sort,filters){
        var def = $.Deferred();
        var _resType = type,
            _resTypeArr = sort,
            _filters = filters || {},
            i = 0,
            count = 0,
            total = data.length,
            result = {}; //结果
        if(total <= 0){
            result["total"] = 0;
            result["data"] = [];
            result["origin"] = [];
            def.resolve(result);
            return def.promise();
        }
        //组装数据
        result["data"] = [];
        result["origin"] = [];

        for(;i < total; i++) {
            var item = data[i];
            //取第一个type值(老接口也是这样处理的)
            var item_type = item.type.split(",")[0];
            var pos = $.inArray(item_type, _resTypeArr);
            if(pos != -1) {
                if (typeof (result["data"][pos]) == "undefined") {
                    result["data"][pos] = {};
                }
                if (typeof (result["data"][pos]["data"]) == "undefined") {
                    result["data"][pos]["data"] = [];
                }
                if (typeof (result["data"][pos]["total"]) == "undefined") {
                    result["data"][pos]["total"] = 0;
                }
                if (typeof (result["data"][pos]["type"]) == "undefined") {
                    result["data"][pos]["type"] = item_type;
                }
                if (typeof (result["data"][pos]["typename"]) == "undefined") {
                    result["data"][pos]["typename"] = _resType[item_type];
                }
                var _school = item.school;
                if(jQuery.isEmptyObject(_filters)){
                    result["data"][pos]["data"].push(_self.resFormatOld(item));
                    result["origin"].push(_self.resFormatOld(item));
                    result["data"][pos]["total"]++;
                    count++;
                }else{
                    //因为school 需要筛选，造成其他模块数据和畅言云不一致，这里做特殊处理了 -不需要筛选了，因为加了topic=08的条件，和畅言云保持一致
                    if(('school' in _filters) && (_filters.school == _school)){
                        result["data"][pos]["data"].push(_self.resFormatOld(item));
                        result["origin"].push(_self.resFormatOld(item));
                        result["data"][pos]["total"]++;
                        count++;
                    }
                }
            }
        }
        //空白项处理
        for(var j = 0,length = _resTypeArr.length; j < length; j++) {
            var pos = j;
            if(typeof (result["data"][pos]) == "undefined") {
                result["data"][pos] = {};
                result["data"][pos]["data"] = [];
                result["data"][pos]["total"] = 0;
                result["data"][pos]["type"] = _resTypeArr[pos];
                result["data"][pos]["typename"] = _resType[_resTypeArr[pos]];
            }
        }
        result["total"] = count;
        def.resolve(result);
        return def.promise();
    };

    //资源信息转换
    _self.resFormatOld = function(item) {
        if(typeof (item) != "object") {
            return item;
        }
        return result = {
            "id":item.id,
            //该部分为新接口返回数据新增部分start
            "payModel":typeof(item.payModel) == "undefined" ? null : item.payModel,
            "lecturer":typeof(item.lecturer) == "undefined" ? null : item.lecturer,
            "rank":typeof(item.rank) == "undefined" ? null : item.rank,
            "year":typeof(item.year) == "undefined" ? null : item.year,
            "pageCount":typeof(item.pageCount) == "undefined" ? null : item.pageCount,
            "index":typeof(item.index) == "undefined" ? null : item.index,
            "keywords":typeof(item.keywords) == "undefined" ? null : item.keywords,
            "price":typeof(item.price) == "undefined" ? null : item.price,
            //有时previewForMobile的值是相对路径
            "previewForMobile":typeof(item.previewForMobile) == "undefined" || !item.previewForMobile ? null : (-1 == item.previewForMobile.indexOf("http://") && -1 == item.previewForMobile.indexOf("https://") ? "http://test.download.cycore.cn/" + item.previewForMobile : item.previewForMobile),
            "testType":typeof(item.testType) == "undefined" ? null : item.testType,
            "lifeStatus":typeof(item.lifeStatus) == "undefined" ? null : item.lifeStatus,
            "hasAnswer":typeof(item.hasAnswer) == "undefined" ? null : item.hasAnswer,
            "expertCount":typeof(item.expertCount) == "undefined" ? null : item.expertCount,
            "exchangeCredit":typeof(item.exchangeCredit) == "undefined" ? null : item.exchangeCredit,
            "hasAnalysis":typeof(item.hasAnalysis) == "undefined" ? null : item.hasAnalysis,
            //该部分为新接口返回数据新增部分end
            "title":typeof(item.title) == "undefined" ? null : item.title,
            "description":typeof(item.description) == "undefined" ? null : item.description,
            "creator":typeof(item.creator) == "undefined" ? null : item.creator,
            "uploader":typeof(item.uploader) == "undefined" ? null : item.uploader,
            "source":typeof(item.source) == "undefined" ? null : item.source,
            "length":typeof(item.length) == "undefined" ? null : item.length,
            "fileurl":typeof(item.origin) == "undefined" ? null : item.origin,
            "thumburl":typeof(item.thumbnail) == "undefined" ? null : item.thumbnail,
            "previewurl":typeof(item.preview) == "undefined" ? null : item.preview,
            "quality":typeof(item.quality) == "undefined" ? null : item.quality,
            "lastmodify":typeof(item.modifyTime) == "undefined" ? null : item.modifyTime,
            "uploadtime":typeof(item.uploadTime) == "undefined" ? null : item.uploadTime,
            "createtime":typeof(item.createTime) == "undefined" ? null : item.createTime,
            "extension":typeof(item.extension) == "undefined" ? null : item.extension,
            "properties":{
                "topic":[
                    typeof(item.topic) == "undefined" ? null : item.topic
                ],
                "edition":[
                    typeof(item.edition) == "undefined" ? null : item.edition
                ],
                "volumn":[
                    typeof(item.volume) == "undefined" ? null : item.volume
                ],
                "knowledge":[
                    typeof(item.knowledge) == "undefined" ? null : item.knowledge
                ],
                "rrtlevel1":[

                ],
                "tag":[
                    typeof(item.tag) == "undefined" ? null : item.tag
                ],
                "subject":[
                    typeof(item.subject) == "undefined" ? null : item.subject
                ],
                "unit1":[
                    typeof(item.unit1) == "undefined" ? null : item.unit1
                ],
                "unit3":[
                    typeof(item.unit3) == "undefined" ? null : item.unit3
                ],
                "unit2":[
                    typeof(item.unit2) == "undefined" ? null : item.unit2
                ],
                "type":typeof(item.type) == "undefined" || !item.type ? null : item.type.split(","),
                "stage":[
                    typeof(item.stage) == "undefined" ? null : item.stage
                ],
                "lang":[

                ],
                "publisher":[
                    typeof(item.publisher) == "undefined" ? null : item.publisher
                ],
                "city":[
                    typeof(item.city) == "undefined" ? null : item.city
                ],
                "unit":(typeof(item.unit) == "undefined" || !item.unit) ? null : item.unit.split(","),
                "school":[
                    typeof(item.school) == "undefined" ? null : item.school
                ],
                "area":[
                    typeof(item.area) == "undefined" ? null : item.area
                ],
                "source":[
                    typeof(item.source) == "undefined" ? null : item.source
                ],
                "unit4":[
                    typeof(item.unit4) == "undefined" ? null : item.unit4
                ],
                "book":[
                    typeof(item.book) == "undefined" ? null : item.book
                ],
                "province":[
                    typeof(item.province) == "undefined" ? null : item.province
                ],
                "grade":[
                    typeof(item.grade) == "undefined" ? null : item.grade
                ],
                "district":[
                    typeof(item.district) == "undefined" ? null : item.district
                ],
                "phase":[
                    typeof(item.phase) == "undefined" ? null : item.phase
                ]
            },
            "statistics":{
                "downloadcount":typeof(item.downloadCount) == "undefined" ? null : item.downloadCount,
                "commentcount":typeof(item.commentCount) == "undefined" ? null : item.commentCount,
                "documentScore":typeof(item.documentScore) == "undefined" ? null : item.documentScore,
                "score":typeof(item.score) == "undefined" ? null : item.score,
                "scorecount":typeof(item.scoreCount) == "undefined" ? null : item.scoreCount,
                "viewcount":typeof(item.viewCount) == "undefined" ? null : item.viewCount,
                "down":typeof(item.down) == "undefined" ? null : item.down,
                "favtimes":typeof(item.favtimes) == "undefined" ? null : item.favtimes,
                "up":typeof(item.up) == "undefined" ? null : item.up
            },
            "lifecycle":{
                "lifecycle.auditstatus":typeof(item.auditStatus) == "undefined" ? null : item.auditStatus
            },
            "resources":null,
            "tags":[
                typeof(item.tag) == "undefined" ? null : item.tag
            ],
            "segment":{
                "content":"",
                "segments":[
                    typeof(item.segments) == "undefined" ? null : item.segments
                ],
                "senword":[
                    typeof(item.sensitiveWords) == "undefined" ? null : item.sensitiveWords
                ],
                "catalog":typeof(item.catalog) == "undefined" ? null : item.catalog,
                "contenturl":null
            },
            "screenshots":{
            },
            "platForm":typeof(item.platform) == "undefined" ? null : item.platform,
            "productId":typeof(item.productId) == "undefined" ? null : item.productId
        }
    };

    //获取资源列表信息（该edc接口废弃，请使用edcService.js中集成的接口）
    _self.api_ersp_resource_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取单个资源详情（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        id:'',
        autov: true //查看时预览量+1
    };*/
    _self.api_ersp_resource_get = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.get",
            version: "1.0",
            format: "json",
            ct: "3",
            cver: "4.0.3",
            thumbSize: "185_185"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //判断用户是否扣除积分（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param ={
        userId:uid
        resId:resourceid
    };*/
    _self.api_ersp_user_credit_resourcePoint = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.user.credit.resourcePoint",
            version: "1.0",
            format: "json",
            ct:"3",
            cver:"4.0"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取用户积分（如下载资源场景）（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param ={
     userId:uid
     };*/
    _self.api_ersp_user_credit_get = function(param) {
        var def = $.Deferred();
        var s = {
            //method: "ersp.user.credit.get",
            method: "ersp.resource.user.credit.get",
            version: "1.0",
            format: "json",
            ct:"3",
            cver:"4.0"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };


        //判断用户是否进行了某项操作（该edc接口废弃，请使用edcService.js中集成的接口）
        /*http://192.168.59.211:7150/api?method=ersp.user.credit.action&ct=3&cver=4.0.3&version=1.0&format=json&userId=&resId=&action=
         */
        //var params={
        //    action:"score",//根据需要确定，如"download","score"等
        //    userId:"",//用户id
        //    resId:"",//资源id
        //};
    _self.api_ersp_user_credit_action = function(param) {
        var def = $.Deferred();
        var s = {
            method:"ersp.resource.user.credit.action",
            version: "1.0",
            format: "json",
            ct:"3",
            cver:"4.0.3"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

        //增加/扣除用户积分(记录用户行为，大家印象、评价、评论、下载)（该edc接口废弃，请使用edcService.js中集成的接口）
        /*param ={
         userId:'',
         action:"download",
         score:"", //"+5,-5"
         resId:"",
         data:""//title
         };*/
    _self.api_ersp_user_credit_update = function(param) {
            var def = $.Deferred();
            var s = {
                method: "ersp.resource.user.credit.update",
                version: "1.0",
                format: "json",
                ct:"3",
                cver:"4.0"
            };
            AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };

    //新增资源评分（该edc接口废弃，请使用edcService.js中集成的接口）
    /*var param = {
        "id" : "", //resId
        "score" : "" //满分100
    };*/
    _self.api_ersp_resource_score_add = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.score.add",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //新增资源评论（该edc接口废弃，请使用edcService.js中集成的接口）
        /*param = {
         "resourceId" : "", //资源Id
         "uid" : "", //用户Id
         "content" : "", // 评论内容
         "toCommentId" : "", //被评论的评论Id
         "toUid" : "" //被评论的用户
         };*/
        _self.api_ersp_resource_comment_add = function(param) {
            var def = $.Deferred();
            var s = {
                method: "ersp.resource.comment.add",
                version: "1.0",
                format: "json"
            };
            AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };

    //获取资源评论接口（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        "resourceId" : "",
        "page" : "",
        "limit" : ""
    };*/
    _self.api_ersp_resource_comment_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.comment.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //判断用户是否添加了印象（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        "userId" : "",
        "resId" : "",
        "labelId" :""
    };*/
    _self.api_ersp_resource_impression_user_exist = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.impression.user.exist",
            version: "1.0",
            format: "json",
            ct:"3",
            cver:"4.0.3"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

        //判断用户是否添加了印象-edc（该edc接口废弃，请使用edcService.js中集成的接口）
        /*param = {
         "userId" : "",
         "resId" : "",
         "labelId" :""
         };*/
        _self.api_ersp_resource_label_user_exist = function(param) {
            var def = $.Deferred();
            var s = {
                method: "ersp.resource.label.user.exist",
                version: "1.0",
                format: "json",
                ct:"3",
                cver:"4.0.3"
            };
            AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };

    //新增资源标签（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        "id" : "",//资源id
        "userId" : "",
        "labelId" : ""
    };*/
    _self.api_ersp_resource_label_add = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.label.add",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //备课本资源分享到班级
    /*param = {
        uid:""
    }*/
    _self.api_core_class_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "core.class.list",
            limit : "1000"
        };
        var url = AppSvcHelper.CYSVC + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取用户基础信息
    /*param = {
        "key" : "uid",
        "value" : ""//用户uid
    };*/
    _self.api_core_user_get = function(param) {
        var def = $.Deferred();
        var s = {
            method: "core.user.get"
        };
        var url = AppSvcHelper.CYSVC + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //根据资源id获取资源标签（课件印象）（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        resId:""
    };*/
    _self.api_ersp_resource_label_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.label.list",
            version: "1.0",
            format: "json",
            ct:"3",
            cver:"4.0.3"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取资源相关推荐（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        subject:"",
        grade:"",
        phase:"",
        type:"download",
        restype:"ZYLB001", //同步资源代码
        limit:""//20
    };*/
    _self.api_ersp_resource_topn_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.topn.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取用户所有的备课本
    _self.api_pan_beike_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "pan.beike.list",
            version: "1.0",
            format: "json"
            //uid:uid
        };
        var url = AppSvcHelper.CYSVC + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取备课资源
    _self.api_pan_beike_file_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "pan.beike.file.list",
            version:"1.0",
            ct:"5",
            format:"json"
        };
        // var param = {
        //     uid: uid,
        //     beikeId: beikeId,
        //     unit: unit1,
        //     course: unit2,
        //     page: "1",
        //     limit: "999999"
        //     // type:"ppt,pptx,icw"
        // };
        var url = AppSvcHelper.CYSVC + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };


    //更新资源下载量（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        resId : ""
    }*/
    _self.api_ersp_resource_download_inc = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.download.inc",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取年级,学科,版本列表（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        key : "" //学科-subject,版本-publisher,年级-grade
     }*/
    _self.api_ersp_resource_category_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.category.list",
            version: "1.0",
            format: "json",
            ct: "3",
            cver: "4.0.3"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取教材列表（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        subject : ""
        publisher : ""
        grade : ""
     }*/
    _self.api_ersp_resource_book_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.book.list",
            version: "1.0",
            format: "json",
            ct: "3",
            cver: "4.0.3"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //获取书本目录信息（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        bookCode : ""
    }*/
    _self.api_ersp_resource_book_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.book.unit.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //我的备课本-批量删除云资源（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param ={
        uid:"",
        fileIds:""// 示例:1,2,3
    }*/
    _self.api_pan_files_delete = function(param) {
        var def = $.Deferred();
        var s = {
            method: "pan.files.delete",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.resPrepare = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        var url = AppRemoteSvcCfg.resPrepare + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    // 获取文件下载地址（该edc接口废弃，请使用edcService.js中集成的接口）
        /*param = {
         userId:"",
         id:""
         }*/
        _self.api_edc_ersp_resource_download_url = function(param) {
            var def = $.Deferred();
            var s = {
                method: "ersp.resource.download.url",
                version: "1.0",
                format: "json"
            };
            AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
            var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };


        //获取资源列表信息（该edc接口废弃，请使用edcService.js中集成的接口）
    _self.api_edc_ersp_resource_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "ersp.resource.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EdcOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };



    // 云备课（EDC），备课资源分类列表（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        isAll : "",
        bookCode : "",
        unit1 : "",
        unit2 : "",
        unit3 : "",
        unit4 : "",
        subject : "",
        grade : ""
    }*/
    _self.api_edc_beike_type_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.type.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    // 云备课（EDC），获取备课本书本列表（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        isAll : "",
        page : "",
        limit : "",
        grade : "",
        subject : "",
        publisher : "",
        phase : "",
        volumn : "",
        edition : "",
        stage : ""
    }*/
    _self.api_edc_beike_book_list = function(param) {
            var def = $.Deferred();
            var s = {
                method: "beike.book.list",
                version: "1.0",
                format: "json"
            };
            AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
            var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };
    // 云备课（EDC），获取书本单元列表（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        bookCode : ""
    }*/
    _self.api_edc_beike_book_info = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.book.info",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    // 云备课（EDC），备课资源文件列表（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        page : "",
        limit : "",
        order : "", //排序方法（1: 修改时间，2:名称(utf8字符顺序) 3:创建时间）
        type : "",
        book : "",
        unit1 : "",
        unit2 : "",
        unit3 : "",
        unit4 : "",
        name : "",
        year : "",
        month : "",
    }*/
    _self.api_edc_beike_file_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.file.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.Easy_OauthTokenServer = Edc_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.Easy_OauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    // 云备课（EDC），获取备课资源时间周年份列表（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        type : "",
        book : "",
        unit1 : "",
        unit2 : "",
        unit3 : "",
        unit4 : "",
        name : "",
        grade : "",
        subject : ""
    }*/
    _self.api_edc_beike_timeline_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.timeline.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    // 云备课（EDC），新增备课文件（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        name : "",
        url : "",
        md5 : "",
        length : "",
        status : "",
        token : "",
        contextId : "",
        description : "",
        grade : "",
        subject : "",
        publisher : "",
        phase : "",
        volumn : "",
        edition : "",
        stage : "",
        type : "",
        book : "",
        unit1 : "",
        unit2 : "",
        unit3 : "",
        unit4 : ""
    }*/
    _self.api_edc_beike_file_add = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.file.add",
            version: "1.0",
            format: "json",
            platForm: "rrt_xj"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    // 云备课（EDC），备课文件删除（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        fileId : ""
    }*/
    _self.api_edc_beike_file_delete = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.file.delete",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    // 云备课（EDC），更新备课属性（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        name : "",
        fileId : "",
        description : "",
        grade : "",
        subject : "",
        publisher : "",
        phase : "",
        volumn : "",
        edition : "",
        stage : "",
        book : "",
        unit1 : "",
        unit2 : "",
        unit3 : "",
        unit4 : ""
    }*/
    _self.api_edc_beike_file_update = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.file.update",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    // 云备课（EDC），获取文件上传来源列表（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        key : "",
        grade : "",
        subject : "",
        publisher : "",
        phase : "",
        volumn : "",
        edition : "",
        stage : "",
        book : "",
        unit1 : "",
        unit2 : "",
        unit3 : "",
        unit4 : ""
    }*/
    _self.api_edc_beike_source_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.source.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    // 云备课（EDC），获取各种分类列表（该edc接口废弃，请使用edcService.js中集成的接口）
        _self.api_edc_beike_category_list = function(param) {
            var def = $.Deferred();
            var s = {
                method: "beike.category.list",
                version: "1.0",
                format: "json"
            };
            AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
            var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };
    // 云备课（EDC），获取用户grade、subject list（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : "",
        key : ""
    }*/
    _self.api_edc_beike_user_category_list = function(param) {
        var def = $.Deferred();
        var s = {
            method: "beike.user.category.list",
            version: "1.0",
            format: "json"
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    // 云备课（EDC），资源预上传（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        openId : '', // 用户登录返回的openId
        extension : '', // 文件的后缀名
        chunks : '', // 分片上传分片数，设置1
        platForm : '', // 文件服务使用的appname,默认rrt_ewp
        callbackMethod : '', // 文件上传完回调方法
        callbackUrl : '', // 文件上传完回调地址
        callbackParams : '', // 文件上传完回调参数
        callbackProtocol : '' // 文件上传完回调方法
    }*/
    _self.api_edc_pan_file_resource_prepare = function(param) {
        var def = $.Deferred();
        var s = {
            method: "pan.file.resource.prepare",
            version: "2.0",
            format: "json",
            platForm : Easy_Cfg.PLATFORM
        };
        AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
        // AppRemoteSvcCfg.cloudBeike = "http://192.168.63.60:50201/" + 'api?appkey=' + Easy_Cfg.APPKEY;
        AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
        _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
            def.resolve(retData);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    // 云备课（EDC），完成文件上传接口（该edc接口废弃，请使用edcService.js中集成的接口）
    /*param = {
        platForm : "", //prepare返回接口数据中的appKey
        contextId: "" //prepare接口中返回的contextId
    }*/
    _self.api_edc_pan_file_upload_complete = function(param) {
            var def = $.Deferred();
            var s = {
                method: "pan.file.upload.complete",
                version: "2.0",
                format: "json"
            };
            AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY + '&platForm=' + Easy_Cfg.PLATFORM;
            AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
            var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };

        // 云备课（EDC），获取网盘文件下载地址（该edc接口废弃，请使用edcService.js中集成的接口）
        /*param = {
         openId : '', // 用户登录返回的openId
         fileIds : '', // 文件列表
         expires : '', // 过期时间，默认八小时
         platForm : '' // 文件服务使用的appname,默认rrt_ewp
         }*/
        _self.api_edc_pan_files_download_get = function(param) {
            var def = $.Deferred();
            var s = {
                method: "pan.files.download.get",
                version: "2.0",
                format: "json"
            };
            AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
            var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };
        //更新资源下载量（该edc接口废弃，请使用edcService.js中集成的接口）
        /*param = {
            id : ""
        }*/
        _self.api_edc_ersp_resource_download_inc = function(param) {
            var def = $.Deferred();
            var s = {
                method: "ersp.resource.download.inc",
                version: "1.0",
                format: "json"
            };
            AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
            var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };

        // 中心云，获取用户基本信息（该edc接口废弃，请使用edcService.js中集成的接口）
        /*param = {
            key : "", //loginName、loginEmail、loginMobile、openId
            value : ""
         }*/
        _self.api_edc_core_user_get = function(param) {
            var def = $.Deferred();
            var s = {
                method: "core.user.get",
                version: "2.0",
                format: "json"
            };
            AppRemoteSvcCfg.cloudBeike = AppRemoteSvcCfgBase.EASYSVC + 'api?appkey=' + Easy_Cfg.APPKEY;
            AppRemoteSvcCfg.EasyOauthTokenServer = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
            var url = AppRemoteSvcCfg.cloudBeike + "&" + $.param(s) + "&" + $.param(param);
            _self.getDataByAccessToken(url,'',AppRemoteSvcCfg.EasyOauthTokenServer).done(function(retData){
                def.resolve(retData);
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
            return def.promise();
        };

        /**
     * 反转dataModel数据，为了从后往前展示数据
     * @param dataModel
     * @returns {*}
     */
    _self.reverseData = function(dataModel) {
        var def = $.Deferred();
        if (! (dataModel instanceof Array)){
            return null;
        }
        for (var i = 0 ,j = dataModel.length - 1 ;i < j ; ++i , --j){
            var tmp = dataModel[i];
            dataModel[i] = dataModel[j];
            dataModel[j] = tmp;
        }
        def.resolve(dataModel);
        return def.promise();
    };

    //请求接口，get/post方式（带接口认证）
    _self.getDataByAccessToken = function(url,setting,oauthUrl) {
        var def = $.Deferred();
        var httpurl = "";
        var _obj = {};
        var request_type = "GET";
        if(typeof(setting) == "undefined" || typeof(setting.timeout) == "undefined"){
            _obj.timeout = 30000;
        }
        if(typeof(setting) == "undefined" || typeof(setting.dataType) == "undefined"){
            _obj.dataType = "json";
        }
        if(typeof (oauthUrl) == "undefined" || oauthUrl == "") {
            oauthUrl = "";
        }
        if(typeof (setting) == "object" && setting.type == "POST") {
            request_type = "POST";
        }
        if(url.toLowerCase().indexOf(AppSvcHelper.CYSVC.toLowerCase()) != -1) {
            _self.getAccessToken(oauthUrl).done(function(){
                if(request_type == "POST") {
                    // TODO(xinfang3): 2016-07-23 20:08:05,access_token待处理.
                    _shellcmd.postHttpRequest(setting.data).done(function (ret) {
                        def.resolve(ret);
                    }).fail(function(e){
                        console.log(e);
                        def.reject();
                    });
                } else {
                    httpurl = url + "&access_token=" + Base_Cfg.ACCESS_TOKEN;
                    _shellcmd.getHttpRequest(httpurl,_obj).done(function (ret) {
                        def.resolve(ret);
                    }).fail(function(e){
                        console.log(e);
                        def.reject();
                    });
                }
            });
        } else {
            _self.getAccessToken(oauthUrl).done(function(){
                if(request_type == "POST") {
                    // TODO(xinfang3): 2016-07-23 20:08:05,access_token待处理.
                    _shellcmd.postHttpRequest(setting.data).done(function (ret) {
                        def.resolve(ret);
                    }).fail(function(e){
                        console.log(e);
                        def.reject();
                    });
                } else {
                    httpurl = url + "&access_token=" + _self._dynamicToken.access_token;
                    _shellcmd.getHttpRequest(httpurl,_obj).done(function (ret) {
                        def.resolve(ret);
                    }).fail(function(e){
                        console.log(e);
                        def.reject();
                    });
                }
            }).fail(function(e){
                console.log(e);
                def.reject();
            });
        }

        return def.promise();
    };

    //请求接口，get方式（不带动态access_token接口认证）
    _self.getDataByUrl = function(url,setting) {
        var def = $.Deferred();
        var httpurl = url;
        var _obj = {};
        if(typeof(setting) == "undefined" || typeof(setting.timeout) == "undefined"){
            _obj.timeout = 4000;
        }
        if(typeof(setting) == "undefined" || typeof(setting.dataType) == "undefined"){
            _obj.dataType = "json";
        }
        _shellcmd.getHttpRequest(httpurl,_obj).done(function (retData1) {
            def.resolve(retData1);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };

    //接口获取access_token
    _self.getAccessToken = function(oauthUrl) {
        var def = $.Deferred();
        if(typeof (oauthUrl) == "undefined" || oauthUrl == "") {
            var httpurl = Easy_Cfg.OAUTH_TOKEN_SERVER + 'client_id=' + Easy_Cfg.APPKEY + '&client_secret=' + Easy_Cfg.SECRET + '&grant_type=client_credentials';
        }else{
            var httpurl = oauthUrl;
        }
        _shellcmd.getHttpRequestJSON(httpurl).done(function (retData) {
            _self._dynamicToken.access_token = retData.access_token;
            def.resolve(retData.access_token);
        }).fail(function(e){
            console.log(e);
            def.reject();
        });
        return def.promise();
    };
    }

    exports.Instance = new ResAccessor();
});