define(function(require, exports, module){
    require('jquery');
    var _shellcmd = require('../../../common/shellcmd'),
        md5 = require("../../../common/md5helper"),
        fs = nodereq("fs"),
        crypto = nodereq("crypto");

    function ResTool(){
        var _self = this;
    };

    function parseFileName(filePath) {
        var _fileExt = "";
        var _fileName = "";
        //取文件名
        var f = filePath.substr(filePath.lastIndexOf('/')+1);
        //解析文件名称
        var file = filePath.replace(/.*(\/|\\)/, "");
        var fileParse=(/[.]/.exec(file)) ? /[^.]+$/.exec(file.toLowerCase()) : {};
        var _fileName = file.substr(0,file.lastIndexOf('.')) || "";

        if(null != fileParse){
            _fileExt = fileParse[0] || "";
        }
        if(_fileName == ""){
            _fileName = file;
        }
        //某些标题带.号时去除中文后缀名，重置文件名
        if(_fileExt.replace(/[^\a-\z\A-\Z0-9]/g,'') != _fileExt){
            _fileName = file;
            _fileExt = "";
        }
        return {
            "origin": filePath,
            'file':file, //文件名+文件后缀
            "fileName": _fileName, //文件名
            "fileExt" : _fileExt //文件后缀,在某些标题带.号时去除
        }
    }

    /**
     * 该方法有缺陷，某些文件会计算失败
     * @param fileFullPath
     * @param fileName
     * @returns {*}
     */
    function parseFileMD5(fileFullPath,fileName) {
        var def = $.Deferred();
        var fileToMD5 = new File(fileFullPath,fileName);
        _shellcmd.fileOrDirExist(fileFullPath).done(function(ret){
            if(ret){
                var reader = new FileReader();
                //将文件以二进制形式读入页面
                reader.readAsBinaryString(fileToMD5);
                reader.onload=function(){
                    def.resolve(md5.hex_md5(this.result))
                }
            } else {
                def.resolve(false);
            }
        });
        return def.promise();
    }

    /**
     * 计算文件md5
     * @param filePullPath
     * @returns {*}
     */
    function calcMd5(fileFullPath){
        var def = $.Deferred();
        _shellcmd.fileOrDirExist(fileFullPath).done(function(ret){
            var content = fs.readFileSync(fileFullPath);
            var md5Sum = crypto.createHash('md5');
            var md5 =  md5Sum.update(content).digest('hex');
            def.resolve(md5);
        }).fail(function(e){
            def.resolve(false);
        });
        return def.promise();
    }

    /**
     * 生成随机长度的字符串
     * @param len 生成的长度 可选 未传则生成32的
     * @private
     */
    function getRandomString(len){
        var len = len||32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    }

    exports.Instance = new ResTool();
    exports.parseFileName = parseFileName;
    exports.parseFileMD5 = parseFileMD5;
    exports.calcMd5 = calcMd5;
    exports.getRandomString = getRandomString;
});