/**
 * Created by pengfu on 14-8-19.
 */

;
define(function (require, exports) {

    var shellcmd = require('../../../common/shellcmd'),
        CloudresourceBase = require('./cloudresourcebase'),
        _ebookContext = require('../../ebookcontext').Instance,
        _cloudUrl = AppSvcHelper.CYSVC + "&",
        _editionRqstUrl = AppSvcHelper.CYSVC + '&';

    //为联调接口临时添加
//    _cloudUrl = 'http://172.16.79.22:10080/api' + "?version=1.0&format=json&appkey=C6SakiHO"+ "&";
//    _editionRqstUrl = 'http://172.16.79.22:10080/api' + "?version=1.0&format=json&appkey=C6SakiHO"+ "&";

    var _resourceContentPage = require('./resourcecontent').Instance;

    var categoryType = {
        phase: 0,
        subject: 1,
        edition: 2,
        stage: 3,
        type: 4
    };

    function CloudList() {
        this.cloudListDom = $("#cloudResourceListPanel");
        this.content = this.cloudListDom.find('.has_checked_cont');
        this.searchMoreDom = this.cloudListDom.find('.more_btn');

        this.notFoundDom = $("#resource_list_not_found");

        this.phaseADom = $("#phaseA");
        this.subADom = $("#subA");
        this.editionADom = $("#editionA");
        this.stageADom = $("#stageA");

        this.phaseDiv = $("#phaselistDiv");
        this.subDiv = $("#sublistDiv");
        this.editionDiv= $("#editionlistDiv");
        this.stageDiv = $("#stagelistDiv");

        this.phaseUl = $("#phaseUl");
        this.subUl = $("#subUl");
        this.editionUl= $("#editionUl");
        this.stageUl = $("#stageUl");

        this.typeUl = $("#typeUl");

        this.bookContainer = null;
        this.hasInit = false;
        this.cataPhaseRet = null;
        this.cataSubRet = null;
        this.cataEditionRet = null;
        this.cataStageRet = null;

        this.resListMore = false;

        this.resListNotFind = true;

        this.listLastPage = false;

        //增加order字段，指定排序方式，这样不会出现调用增加了下载数而使得排序变化的问题。
        this.request = {
            method: 'res.resource.list',
//            method: 'res.resource.center.list',
//            filters: '!general.extension:book2 AND !general.extension:book',
            order:'date.createtime',
            thumbsize: '180_255',
            page: 1,
            limit: 10,
            book :'',
            phase: '',
            subject: '',
            edition: '',
            stage: '',
            type: ''
        };

        //修改成中心地址
        this.request.method = "res.center.list";

        this.typelist = null;

        //根据bookCode去查该本书的版本，为什么从bookContainer中得不到该书的版本？原因可咨询。
        this.editionRqst = {
            method: 'res.book.list',
            book: ''
        };

        this.requestParam = {
            phase:'',
            subject: '',
            edition: '',
            stage: '',
            type: '0100,0600,0300,1901,0400,0500'//这里的全部并不是真正包含所有资源的全部，而只是包含列出来的部分类型资源的全部。全部资源可能有几十种
        };

        this.resListReslt = {
            data  : [],
            total : 0
        };

        //4个下拉列表都不为空，根据下拉列表值查询bookCode，然后根据bookCode去查询资源
        this.bookCodeRqst = {
            method: 'res.book.list',
            phase: '',
            subject: '',
            edition: '',
            stage : ''
        }

        this._eachResourceTpl = '<li id="{fid}">' +
            '<div class="has_checked_cont_mid_ifo_top clearfix">' +
            '<a style="cursor:pointer;" title="" class="has_checked_cont_link">' +
            '<img src="{thumbpath}">' +
            '</a>' +
            '<div class="has_checked_cont_mid_ifo">' +
            '<h6>{namePlusExt}</h6>' +
            '<p>{description}</p>' +
            '</div>' +
            '</div>' +
            '<p class="has_checked_cont_info clearfix">' +
            '<span class="color_989797">{modifytime}</span>' +
            '<span class="color_989797">大小：{size}M</span>' +
            '<span class="color_989797">格式：{type}</span>' +
            '<span class="color_989797">下载数：{downloadCount}</span>'+

            '</p>' +
            '<div class="smartbar_btn_box ">' +
            '<a style="cursor:pointer;width:50px;"  preViewUrl="{preViewUrl}" extension="{type}" class="smartbar_btn" title="资源详情">资源详情</a>' +
            '<a style="cursor:pointer;width:50px;"  fileUrl="{fileUrl}" thumbnail="{thumbpath}" class="smartbar_btn" title="加入课本">加入课本</a>' +
            ' </div>' +
            '</li>';

        this.resourceTypeJson = {"total":6,"data":[{"code":"0100","name":"教案"},{"code":"0600","name":"课件"},{"code":"0300","name":"素材"},{"code":"1901","name":"微课"},{"code":"0400","name":"习题"},{"code":"0500","name":"试卷"}]};
        this.contextBookCode = '';
    }

    CloudList.prototype = new CloudresourceBase();
    CloudList.prototype.constructor = CloudList;

    CloudList.prototype.init = function (bookContainer) {
        var _this = this;
        //初始化时获取不到bookContainer里具体的bookCode等信息,必须初始化后才能获得
        _this.bookContainer = bookContainer;
        //初始化时获取学段、学科、版本、年级册别列表
        var phase_req = {
            method: 'res.category.list',
            key: 'phase'
            },
        sub_req = {
            method: 'res.category.list',
            key: 'subject'
        },
        edition_req = {
            method: 'res.category.list',
            key: 'edition'
        },
        stage_req = {
            method: 'res.category.list',
            key: 'stage'
        };

        //以下代码渲染出类型
        _this.typelist = _this.resourceTypeJson.data;
        var strtpl = '<li code="{code}"><a style="cursor:pointer;"  >{name}</a></li>';
        var str = '<li>类型：</li><li code="0100,0600,0300,1901,0400,0500"><a style="cursor:pointer;"  class="htactive">全部</a></li>';
        for(var i=0;i<_this.typelist.length;i++){
            str += strtpl.replace("{code}",_this.typelist[i].code)
                .replace("{name}",_this.typelist[i].name);
        }
        var strDom = $(str);
        var _allLi = strDom.find("a");
        strDom.filter("li").click(function(){
//            alert($(this).index())
            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130622';
            var user_id = _ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);

            if($(this).index() == 0){
                return;
            }
            _allLi.removeClass("htactive");
            $(this).find("a").addClass("htactive");
            _this.requestParam.type=$(this).attr("code");
            _this.request.phase = _this.requestParam.phase;
            _this.request.subject = _this.requestParam.subject;
            _this.request.edition = _this.requestParam.edition;
            _this.request.stage = _this.requestParam.stage;
            _this.request.type = _this.requestParam.type;

            if(_this.requestParam.phase && _this.requestParam.subject
                && _this.requestParam.edition && _this.requestParam.stage){

                //不用查bookCode，前面已经查过，直接从内存中读取
                if(_this.contextBookCode){
                    _this.request.book = _this.contextBookCode;
                    _this.request.phase = '';
                    _this.request.subject = '';
                    _this.request.edition = '';
                    _this.request.stage = '';
                    _this.search(true);
                }
            }else{
                //如果有一个下拉列表没有具体的值（选在全部上），这时根据下拉列表确定不了bookCode，将bookCode设置为''
                _this.request.book = '';
                _this.contextBookCode = '';//缓存bookCode
                _this.request.phase = _this.requestParam.phase;
                _this.request.subject = _this.requestParam.subject;
                _this.request.edition = _this.requestParam.edition;
                _this.request.stage = _this.requestParam.stage;
                _this.search(true);
            }
        });
        _this.typeUl.append($(strDom));


        var phase_url = _cloudUrl + $.param(phase_req),
            sub_url = _cloudUrl + $.param(sub_req),
            edit_url = _cloudUrl + $.param(edition_req),
            stage_url = _cloudUrl + $.param(stage_req);
        _ebookContext.getUser().getDataByUserToken(phase_url).done(function (ret) {
            _this.cataPhaseRet = ret;
        });
        _ebookContext.getUser().getDataByUserToken(sub_url).done(function (ret) {
            _this.cataSubRet = ret;
        });
        _ebookContext.getUser().getDataByUserToken(edit_url).done(function (ret) {
            _this.cataEditionRet = ret;
        });
        _ebookContext.getUser().getDataByUserToken(stage_url).done(function (ret) {
            _this.cataStageRet = ret;
        });

        this.addEvnt();
        this.hasInit = true;

        //资源详情页初始化
        _resourceContentPage.init(bookContainer);
    }

    /**
     * 绑定下拉框事件
     */
    CloudList.prototype.addEvnt = function(){
        var _this = this;

        //绑定下拉框事件
        _this.phaseADom.click(function(){
            _this.showCatagoryList(_this.phaseUl,"phase",_this.phaseDiv,_this.phaseADom);
        });

        _this.subADom.click(function(){
            _this.showCatagoryList(_this.subUl,"subject",_this.subDiv,_this.subADom);
        });

        _this.editionADom.click(function(){
            _this.showCatagoryList(_this.editionUl,"edition",_this.editionDiv,_this.editionADom);
        });

        _this.stageADom.click(function(){
            _this.showCatagoryList(_this.stageUl,"stage",_this.stageDiv,_this.stageADom);
        });

        //绑定 点击查看更多 事件
        _this.searchMoreDom.click(function(){
            _this.request.page++;
            _this.search(false);
        });

    }

    /**
     * 显示下拉框列表的内容
     * @param ulDom
     * @param option
     * @param listDiv
     * @param ADom
     */
    CloudList.prototype.showCatagoryList = function(ulDom,option,listDiv,ADom){
        var _this = this;
        var liTpl = '<li code="{optionCode}" name="{optionsult}"><a style="cursor:pointer;"  >{optionsult}</a></li>';
        _this.catagoryRequest = $.extend({},_this.requestParam);
        _this.catagoryRequest.key = option;
        _this.catagoryRequest.method = 'res.category.list';
        _this.catagoryRequest[option] = "";
       var url =  _cloudUrl + $.param(_this.catagoryRequest);
        var str = "";
        (option == "phase") && (str = "学段");
        (option == "subject") && (str = "学科");
        (option == "edition") && (str = "版本");
        (option == "stage") && (str = "年级册别");

        var liStr = '<li code="" name="全部'+str+'"><a style="cursor:pointer;"  >全部'+str+'</a></li>';
        _ebookContext.getUser().getDataByUserToken(url).done(function(result){
      //  shellcmd.getHttpRequest(url).done(function(result){
            for(var i=0;i<result.data.length;i++){
                liStr += liTpl.replace("{optionsult}",result.data[i].name)
                    .replace("{optionCode}",result.data[i].code)
                    .replace("{optionsult}",result.data[i].name)
            }
            var liDom = $(liStr);
            _this.addListEvent(liDom,option,listDiv,ADom);
            ulDom.empty().append(liDom);
            listDiv.show();
        });
    }


    /**
     * 注册下拉框内容事件
     * @param liDom
     * @param option
     * @param listDiv
     * @param ADom
     */
    CloudList.prototype.addListEvent = function(liDom,option,listDiv,ADom){
        var _this = this;
        liDom.filter("li").click(function(){

            ADom.html($(this).attr("name"));
            _this.requestParam[option] = $(this).attr("code");
            listDiv.hide();

            //4个下拉列表都有值，根据这个值查询bookCode，然后根据bookCode去查询资源
            if(_this.requestParam.phase && _this.requestParam.subject
                && _this.requestParam.edition && _this.requestParam.stage){
                //查bookCode

                var url = _cloudUrl + $.param($.extend(_this.bookCodeRqst,_this.requestParam));
                _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
           //     shellcmd.getHttpRequest(url).done(function(ret){
                    if(ret && ret.data ){
                      _this.request.book = ret.data[0].bookcode;
                      _this.contextBookCode = ret.data[0].bookcode;
                      _this.request.phase = '';
                      _this.request.subject = '';
                      _this.request.edition = '';
                      _this.request.stage = '';
                    }
                    _this.search(true);

                })
            }else{
                //如果有一个下拉列表没有具体的值（选在全部上），（不是全部都没有值的情形）这时根据下拉列表确定不了bookCode，将bookCode设置为''
                _this.request.book = '';
                _this.contextBookCode = '';
                _this.request.phase = _this.requestParam.phase;
                _this.request.subject = _this.requestParam.subject;
                _this.request.edition = _this.requestParam.edition;
                _this.request.stage = _this.requestParam.stage;
                _this.request.type = _this.requestParam.type;
                _this.search(true);
            }


        });
        listDiv.mouseleave(function(){
            $(this).hide();
        });

    }

    /**
     * 显示云资源列表内容
     */
    CloudList.prototype.show = function () {
        var _this = this;

        var listDoms = this.cloudListDom.find('.select_tit');

        //根据bookContainer获取本地课本信息
        if (_this.bookContainer.bookMetaInfo) {
            //TODO:判断bookContainer有没有学段
            _this.request.subject = _this.bookContainer.bookMetaInfo.subject;
            _this.request.stage = _this.bookContainer.bookMetaInfo.grade + "00" + _this.bookContainer.bookMetaInfo.volumn;
//            _this.request.book = _this.bookContainer.bookMetaInfo.bookCode;
            //很挫，publisher不是edition，还要根据bookCode去查edition
            _this.editionRqst.book = _this.bookContainer.bookMetaInfo.bookCode;
            var editionUrl = _editionRqstUrl + $.param(_this.editionRqst);
            _ebookContext.getUser().getDataByUserToken(editionUrl).done(function (ret) {
       //     shellcmd.getHttpRequest(editionUrl).done(function (ret) {
                console.log(ret);
                if (ret && ret.data[0] && ret.data[0].properties ) {
                    _this.request.edition = ret.data[0].properties.edition[0];
                    _this.request.phase = ret.data[0].properties.phase[0];
                } else {
                    _this.request.edition = '';
                    _this.request.phase = '';
                }

                _this.requestParam.phase = _this.request.phase;
                _this.requestParam.subject = _this.request.subject;
                _this.requestParam.stage = _this.request.stage;
                _this.requestParam.edition = _this.request.edition;
                listDoms.eq(0).get(0).innerHTML = _this._getName(categoryType.phase, _this.cataPhaseRet, _this.request.phase, "全部学段");
                listDoms.eq(1).get(0).innerHTML = _this._getName(categoryType.subject, _this.cataSubRet, _this.request.subject, "全部学科");
                listDoms.eq(2).get(0).innerHTML = _this._getName(categoryType.edition, _this.cataEditionRet, _this.request.edition, "全部版本");
                listDoms.eq(3).get(0).innerHTML = _this._getName(categoryType.stage, _this.cataStageRet, _this.request.stage, "全部年级册别");

                //在这执行根据当前学科、年级册别、版本 进行一次查询操作，
                //如果下拉框四个值都确定，则根据bookCode查资源（为什么这样做，为与云端web保持查询结果一致!产品设计就不一样，却要一样的搜索结果，真是shit）
                _this.request.book = _this.bookContainer.bookMetaInfo.bookCode;
                _this.contextBookCode = _this.bookContainer.bookMetaInfo.bookCode;

                if(_this.bookContainer.bookMetaInfo.bookCode == AppCfg.testBook || _this.bookContainer.bookMetaInfo.bookCode == AppCfg.testBook2){
                    //对于全学科演示教材，不根据bookcode查资源
                    _this.request.book = '';
                    _this.contextBookCode = '';
                }
                _this.request.phase = '';
                _this.request.subject = '';
                _this.request.edition = '';
                _this.request.stage = '';
                _this.request.type = _this.requestParam.type;
                _this.search(true);
                _this.cloudListDom.show();
            })
        }
        else {
            _this.contextBookCode = '';
            _this.request.subject = _this.request.stage = _this.request.edition = "";
            _this.requestParam.subject = "";
            _this.requestParam.stage = "";
            _this.requestParam.edition = "";
            listDoms.eq(0).get(0).innerHTML = _this._getName(categoryType.phase, _this.cataPhaseRet, _this.request.phase, "全部学段");
            listDoms.eq(1).get(0).innerHTML = _this._getName(categoryType.subject, _this.cataSubRet, _this.request.subject, "全部学科");
            listDoms.eq(2).get(0).innerHTML = _this._getName(categoryType.edition, _this.cataEditionRet, _this.request.edition, "全部版本");
            listDoms.eq(3).get(0).innerHTML = _this._getName(categoryType.stage, _this.cataStageRet, _this.request.stage, "全部年级册别");
            _this.request.type = _this.requestParam.type;
            //在这执行根据当前学科、年级册别、版本 进行一次查询操作，
            _this.search(true);
            _this.cloudListDom.show();
        }

    }

    CloudList.prototype._getName = function (type, ret, code, defaultName) {
        var _this = this;
        for (var i = 0, max = ret.data.length; i < max; i++) {
            if (code == ret.data[i].code) {
                return ret.data[i].name;
            }
        }
        //代码跑到这里，有种可能，从bookContainer里取的书本信息与通过请求所得书本信息里没有匹配，
        switch (type) {
            case categoryType.phase:
                _this.requestParam.phase = '';
                _this.request.phase = '';
                break;
            case categoryType.subject:
                _this.requestParam.subject = '';
                _this.request.subject = '';
                break;
            case categoryType.stage:
                _this.requestParam.stage = '';
                _this.request.stage = '';
                break;
            case categoryType.edition:
                _this.requestParam.edition = '';
                _this.request.edition = '';
                break;
        }
        return defaultName;
    }

    /**
     * 执行对资源的搜索
     * @param reload true:重新搜索，刷新操作 false：将搜索结果附加在前次基础上
     */
    CloudList.prototype.search = function (reload) {
        var _this = this;
        reload && (_this.request.page = 1);
//        //如果下拉列表都有值，则根据这个下拉列表的选项查询一个bookcode值
//        if(!_this.requestParam.phase && !_this.requestParam.subject
//            && !_this.requestParam.edition && _this.requestParam.stage){
//
//        }
//        _this.request.phase = _this.requestParam.phase;
//        _this.request.subject = _this.requestParam.subject;
//        _this.request.edition = _this.requestParam.edition;
//        _this.request.stage = _this.requestParam.stage;
//        _this.request.type = _this.requestParam.type;

          // 注释，使用中心化接口
//        var url = _cloudUrl + $.param(_this.request);
        var url = AppCenterSvcHelper.CYSVC + "&" + $.param(_this.request);
        if(Base_Cfg.APPNAME){
            url = url + "&platForm=" + Base_Cfg.APPNAME;
        }

        _ebookContext.getUser().getDataByUserToken(url).done(function (result) {
            //TODO:对json结果的一些处理在这做
            console.log("资源列表返回json结果:");
            console.log(result);
            for (var i = 0; i < result.data.length; i++) {
//                if(result.data[i].extension == 'book2'){
//                    continue;
//                }
                if (!result.data[i].title) {
                    result.data[i].title = "未命名文件";
                }
//                else {
//                    var index = result.data[i].title.lastIndexOf(".");
//                    if (index > 0) {
//                        result.data[i].title = result.data[i].title.substring(0, index);
//                    }
//                }
            }

            _this.render(result, reload);
        });
    };

    /**
     * 渲染资源
     * @param result
     * @param reload
     */
    CloudList.prototype.render = function (result, reload) {
        var _this = this;
        console.log(result);

        if(reload){
            if((typeof result == 'string' || result.total == 0 )){
                //处理没搜到结果时页面上的显示
                _this.searchMoreDom.css('display', 'none');
                //TODO:在这个逻辑里应该显示“没有找到资源”
                _this.notFoundDom.css('display', 'block');

                //查看更多标志是否显示，false表示不显示
                _this.resListMore = false;
                _this.searchMoreDom.hide();
                //没搜到结果，显示内容区域清空
                _this.content.empty();

                this.resListReslt = result;

                return;
            }
            _this.content.empty();
            this.resListReslt = result;
            if(result.data.length >= result.total){
                //第一次搜出来就是最后一页了
                _this.searchMoreDom.css("display","none");
                _this.resListMore = false;
//                _this.listLastPage = true;
            }else{
                _this.searchMoreDom.css("display","block");
//                _this.listLastPage = false;
                _this.resListMore = true;
            }

        }else{
            $.merge(this.resListReslt.data, result.data);
            if(this.resListReslt.data.length >= result.total){
                _this.searchMoreDom.css("display","none");
                _this.resListMore = false;
//                _this.listLastPage = true;
            }
            else{
                _this.searchMoreDom.css("display","block");
//                _this.listLastPage = false;
                _this.resListMore = true;
            }
        }


        //将请求获取的结果渲染到界面上
        var eachResourceStr = "";
        for(var i= 0,iMax = result.data.length;i < iMax ;i++){
            //过滤一些资源--是否需要在这过滤还是让在接口中过滤？
            var thumburl = '';
//            if(result.data[i].extension == 'book2' || result.data[i].extension == 'book' ){
//                continue;
//            }

            thumburl = result.data[i].thumburl;
            if(!thumburl){
                thumburl = _this.setDefaultPic(result.data[i].extension);
            }
            eachResourceStr += _this._eachResourceTpl.
                replace("{fid}",result.data[i].id)
                .replace("{thumbpath}",thumburl)
                .replace("{namePlusExt}",result.data[i].title)//title字段即是“XXX.doc”的格式
                .replace("{description}",result.data[i].description)
                .replace("{modifytime}",result.data[i].lastmodify)
                .replace("{size}",(result.data[i].length/(1000000)).toFixed(2))
                .replace("{type}",result.data[i].extension)
                .replace("{fileUrl}",result.data[i].fileurl)
                .replace("{preViewUrl}",result.data[i].previewurl)
                .replace("{thumbpath}",result.data[i].thumburl)
                .replace("{type}",result.data[i].extension)
                .replace("{downloadCount}",result.data[i].statistics.downloadcount);
        }
        var eachResourceDom = $(eachResourceStr);
        _this.bindEvntToResult(eachResourceDom);
        eachResourceDom.appendTo(_this.content);

        //能够走到这里表示“没有找到资源”不应该显示了
        //TODO:隐藏没有找到资源
        _this.notFoundDom.hide();

        //根据标志位决定是否显示查看更多
        if(_this.resListMore){
            _this.searchMoreDom.show();
        }else{
            _this.searchMoreDom.hide();
        }

    }

    /**
     * 绑定资源事件
     * @param DOM
     */
    CloudList.prototype.bindEvntToResult = function(DOM) {
        var _this = this;
        //TODO : 为熏染出的DOM加事件
        DOM.find('img').click(function(){
            var i = $(this).parent().parent().parent().index();
            var datas = _this.resListReslt.data;
            datas[i].resFrom = 'yun_store';

            _this.previewRes(datas[i].extension,datas[i].previewurl,datas[i]);
        })

        //查看
        DOM.find('a[title="资源详情"]').click(function(){
            //调用基类方法中的预览方法
            var i = $(this).parent().parent().index();
            var datas = _this.resListReslt.data;
            datas[i].resFrom = 'yun_store';

            //获取资源详情
//            var url = AppRemoteSvcCfg.resDetail +  datas[i].id;
            var url = getPlatFormCfg(datas[i].platForm) + "&method=res.resource.get&resourceid=" + datas[i].id;
            _ebookContext.getUser().getDataByUserToken(url).done(function(result){
                datas[i].statistics = result.statistics;
                if(!datas[i].thumburl){
                    datas[i].thumburl = result.statistics;
                }
                _resourceContentPage.showResContentPanel(datas[i]);
            });
        //    _this.previewRes($(this).attr("extension"),$(this).attr("preViewUrl"),datas[i]);
        })
        //加入课本
        DOM.find('a[title="加入课本"]').click(function(){

            var i = $(this).parent().parent().index();
            var datas = _this.resListReslt.data;
            datas[i].resFrom = 'yun_store';
            newWidgetPos=null;
            _this.downLoadFile(datas[i]);

        });

        //拖拽下载
        DOM.on('dragend',function(e){
//            alert($(this).index())
            var i = $(this).index();
            newWidgetPos = {
                left : e.originalEvent.clientX,
                top : e.originalEvent.clientY
            }
            var datas = _this.resListReslt.data;
            datas[i].resFrom = 'yun_store';
            _this.downLoadFile(datas[i]);
        })
    }


    exports.Instance = new CloudList();
});
