/**
 * Created by pengfu on 14-7-21.
 */
;
define(function(require,exports){

    var NetDiskResBase = require('./netdiskbase').NetDiskResBase;
    var shellcmd = require('../../../../common/shellcmd');
    var ebookContext = require('../../../ebookcontext').Instance;
    var _path = require('../../../../common/path');
    var netDiskURL = AppSvcHelper.CYSVC + "&" ;
    var recommendResUrl = AppSvcHelper.CYSVC + "&";
    require('jquery');

    function PrepareLessonTxt(){

        var _this = this;

        this.bookContainer = null;
        this.currentUnitCode;
        this.currentCourseCode;
        this.preparePanel = $("#prepareLessonTxtPanel");
        this.allResourceRegion = this.preparePanel.find('.smartbar_tab_cont_bot_l');
        this.thumbNailDom = $("#thumbNailImg");
        this.tableDom = $("#resCountTable");
        this.resourceCountDivDom = $("#resourceCountDiv");

        var userID = ebookContext.getUser().getUid();
        this.firstRqst = {
            method      : 'pan.beike.list',
            uid         :  userID
        }

        this.resCountRqst = {
            method      : 'pan.beike.file.count',
            uid         :  userID,
            beikeId     : ''
        }

        this.resInfoRqst = {
//            method      : 'pan.beike.file.list',
            method      : 'pan.beike.allfile.list',
            uid         :  userID,
            beikeId     : '',
            unit        : '',
            course      : '',
            type        : '',
            page        : 1,
            limit       : 12
        };

        //查询具体某种资源
        //type:教案 0100,素材：0300,习题：0400,课件：0600，其他0000
        this.kejianResInfoRqst = {
            method      : 'pan.beike.file.list',
            uid         :  userID,
            beikeId     : '',
            unit        : '',
            course      : '',
            type        : '0600',
            page        : 1,
            limit       : 12
        }
        this.jiaoanResInfoRqst = {
            method      : 'pan.beike.file.list',
            uid         :  userID,
            beikeId     : '',
            unit        : '',
            course      : '',
            type        : '',
            page        : 1,
            limit       : 12
        }
        this.sucaiResInfoRqst = {
            method      : 'pan.beike.file.list',
            uid         :  userID,
            beikeId     : '',
            unit        : '',
            course      : '',
            type        : '0300',
            page        : 1,
            limit       : 12
        }
        this.xitiResInfoRqst = {
            method      : 'pan.beike.file.list',
            uid         :  userID,
            beikeId     : '',
            unit        : '',
            course      : '',
            type        : '0400',
            page        : 1,
            limit       : 12
        }
        this.otherResInfoRqst = {
            method      : 'pan.beike.file.list',
            uid         :  userID,
            beikeId     : '',
            unit        : '',
            course      : '',
            type        : '0000',
            page        : 1,
            limit       : 12
        }

        //获取资源的详细信息，含下载、预览、缩略图
        this.resSpecificRqst = {
            method      : 'pan.file.get',
            uid         :  userID,
            fileId      : '',
            thumbWidth  :   64,
            thumbHeight :   64
        }

        //创建备课本
        this.createbeikeRqst = {
            method      : 'pan.beike.add',
            appName     : 'ib',
            uid         :  userID,
            bookCode    :  ''
        }

        //推荐资源
        this.recommendrqst = {
            method  :       "res.resource.batch.list",
            subject: "",            //学科
            grade: "",              //年级
            publisher: "",          //出版社
            edition: "",            //教材版本
            phase: "",              //学段
            stage: "",              //年级册别
            book: "",               //书本
            unit: "",               //单元
            course: "",             //课时
            thumbsize: "185_185",    //图片大小
            order: "",              //排序
            type: "",               //资源类型
            q: "",                  //关键词
            page: 1,
            limit: 20
        }

        //一维
        this.recommendRlt = {
            data: [],
            total: 0
        }

        //二维
        this.originRecmdRlt = {};

        this.bookTitleDom = $("#currentbooktitle");

        this._imgStr = '<img src="{imgPath}" />';

        this._eachUnitTpl = '<div class="sm_book_ifo_th_name" style="border-top: 1px solid #d5d5d5;overflow: hidden;text-overflow: ellipsis;white-space: nowrap;">{unitName}</div>';

        this._unitCourseTpl = '<table></table>';

        this._eachTabTpl =   '<tr class="{className}" class1="resourceCountClass1" unitCode="{unitcode}" courseCode="{coursecode}">'+
                                '<td class1="countClass"><a  style="width: 170px;cursor:pointer;"><div style="padding-left: 10px;overflow: hidden;text-overflow: ellipsis;white-space: nowrap;">{courseName}</div></a></td>'+
                                '<td class1="countClass"><a  style="width: 62px;cursor:pointer;">{kejianCount}</a></td>'+
                                '<td class1="countClass"><a  style="width: 62px;cursor:pointer;">{jiaoanCount}</a></td>'+
                                '<td class1="countClass"><a  style="width: 62px;cursor:pointer;">{sucaiCount}</a></td>'+
                                '<td class1="countClass"><a  style="width: 62px;cursor:pointer;">{xitiCount}</a></td>'+
                                '<td class1="countClass"><a  style="width: 62px;cursor:pointer;">{otherCount}</a></td>'+
                              '</tr>';

        this.allResourceDom = $("#netdisklessonResList");

        this.kejianDom = $("#kejianList");

        this.jiaoanDom = $("#jiaoanList");
        this.sucaiDom = $("#sucaiList");
        this.xitiDom = $("#xitiList");
        this.otherDom = $("#otherList");

        this.kejianDiv = $("#kejianDiv");
        this.jiaoanDiv = $("#jiaoanDiv");
        this.sucaiDiv = $("#sucaiDiv");
        this.xitiDiv = $("#xitiDiv");
        this.otherDiv = $("#otherDiv");

        this.kejianMore = $("#kejianMore");
        this.jiaoanMore = $("#jiaoanMore");
        this.sucaiMore = $("#sucaiMore");
        this.xitiMore = $("#xitiMore");
        this.otherMore = $("#otherMore");

        this.recmdDom = $("#lessonRecmdList");

        this.kejianRet ;
        this.jiaoanRet ;
        this.sucaiRet;
        this.xitiRet;
        this.otherRet;

        this.kejianStateArr = [];
        this.jiaoanStateArr = [];
        this.sucaiStateArr = [];
        this.xitiStateArr = [];
        this.otherStateArr = [];

        this.contextBeikeId ='';
        this.contextUnit = '';
        this.contextCourse = '';

        this._eachResStr = '<li class1="allTypeResourceList" id="{fid}" xIndex={xindex} yIndex={yindex} style="position: relative">'+
                                '<a style="cursor:pointer;">'+
                                    '<span class="sm_gs_img"><img src="{imgsrc}" alt=""></span>'+
                                    '<div class1="wenzi" class="sm_gs_text" style="overflow: hidden;text-overflow: ellipsis;white-space: nowrap;display: inline-block;width: 72px;text-align: center;">{resourceName}</div>'+
                                '</a>'+
                                '</li>';
//        this._eachResStr = '<li class1="allTypeResourceList" xIndex={xindex} yIndex={yindex} style="position: relative">'+
//            '<a href="#">'+
//            '<span class="sm_gs_img"><img src="{imgsrc}" alt=""></span>'+
//            '<span class="sm_gs_text" >{resourceName}</span>'+
//            '</a>'+
//            '</li>';

        //推荐资源模板
//        this._eachRecmdStr = '<li class1="recmdResourceList" xIndex={xindex} yIndex={yindex} style="position: relative">'+
//                                '<a href="#">'+
//                                    '<span class="fr_gs_img"><img src="{recimgsrc}" alt=""></span>'+
//                                    '<div ><span class="fr_gs_text">{recresName}</span></div>'+
//                                '</a>'+
//                               '</li>';
        this._eachRecmdStr = '<li class1="recmdResourceList" id="{fid}" xIndex={xindex} yIndex={yindex} style="position: relative">'+
            '<a style="cursor:pointer;">'+
            '<span class="fr_gs_img"><img src="{recimgsrc}" alt=""></span>'+
            '<div class1="wenzi" style="overflow: hidden;text-overflow: ellipsis;white-space: nowrap;display: inline-block;width: 60px;text-align: center;float: left;" class="fr_gs_text">{recresName}</div>'+
            '</a>'+
            '</li>';

        this._noResStr = '<p style="text-align: center;margin-top: 20px">暂无资源</p>';

        this._findMoreStr = '<p style="text-align: right">查看更多</p>'

        this._allResArr = [];

        this._allResClickState = [];
        this._recCmdResClickState = [];

        //一个资源也没有
        this._noOneResStr = '<p class="no_res01" name="record_nores">' +
        '<img src="assert/images/no_res01.png"><br>' +
        '<span>您的备课本暂无资源</span></p>';

        //标志是否有这些类型资源,初始化为
        this._haskejianRes = true;
        this._hasjiaoanRes = true;
        this._hassucaiRes = true;
        this._hasxitiRes = true;
        this._hasotherRes = true;
    }

    PrepareLessonTxt.prototype = new NetDiskResBase();
    PrepareLessonTxt.prototype.constructor = PrepareLessonTxt;

    PrepareLessonTxt.prototype.init = function(bookContainer){
        var _this = this;
        _this.bookContainer = bookContainer;
        //在初始化中对课件，教案，素材，习题，其他 中的 点击查看更多 进行事件绑定
        _this.kejianMore.find('a').on('click',function(e){
            _this.kejianResInfoRqst.beikeId = _this.contextBeikeId;
            _this.kejianResInfoRqst.unit = _this.contextUnit;
            _this.kejianResInfoRqst.course = _this.contextCourse;
            _this.kejianResInfoRqst.type = '0600';
            _this.kejianResInfoRqst.page ++;
            var url = netDiskURL + $.param(_this.kejianResInfoRqst);
            ebookContext.getUser().getDataByUserToken(url).done(function(result){
                console.log(result);
                //将结果合并
                _this.kejianRet = _this.kejianRet.concat(result.data);
                _this._allResArr[0] = _this.kejianRet ;
                //将新搜索的结果append到Dom上
                _this._renderkejianResAndRegEvt(result);

            })
            e.stopPropagation();
        })

        _this.jiaoanMore.find('a').on('click',function(e){
            _this.jiaoanResInfoRqst.beikeId = _this.contextBeikeId;
            _this.jiaoanResInfoRqst.unit = _this.contextUnit;
            _this.jiaoanResInfoRqst.course = _this.contextCourse;
            _this.jiaoanResInfoRqst.type = '0100';
            _this.jiaoanResInfoRqst.page ++;
            var url = netDiskURL + $.param(_this.jiaoanResInfoRqst);
            ebookContext.getUser().getDataByUserToken(url).done(function(result){
                console.log(result);
                //将结果合并
                _this.jiaoanRet = _this.jiaoanRet.concat(result.data);
                _this._allResArr[1] = _this.jiaoanRet ;
                //将新搜索的结果append到Dom上
                _this._renderjiaoanResAndRegEvt(result);

            })
            e.stopPropagation();
        })

        _this.sucaiMore.find('a').on('click',function(e){
            _this.sucaiResInfoRqst.beikeId = _this.contextBeikeId;
            _this.sucaiResInfoRqst.unit = _this.contextUnit;
            _this.sucaiResInfoRqst.course = _this.contextCourse;
            _this.sucaiResInfoRqst.page ++;
            var url = netDiskURL + $.param(_this.sucaiResInfoRqst);
            ebookContext.getUser().getDataByUserToken(url).done(function(result){
                console.log(result);
                //将结果合并
                _this.sucaiRet = _this.sucaiRet.concat(result.data);
                _this._allResArr[2] = _this.sucaiRet ;
                //将新搜索的结果append到Dom上
                _this._rendersucaiResAndRegEvt(result);

            })
            e.stopPropagation();
        })

        _this.xitiMore.find('a').on('click',function(e){
            _this.xitiResInfoRqst.beikeId = _this.contextBeikeId;
            _this.xitiResInfoRqst.unit = _this.contextUnit;
            _this.xitiResInfoRqst.course = _this.contextCourse;
            _this.xitiResInfoRqst.page ++;
            var url = netDiskURL + $.param(_this.xitiResInfoRqst);
            ebookContext.getUser().getDataByUserToken(url).done(function(result){
                console.log(result);
                //将结果合并
                _this.xitiRet = _this.xitiRet.concat(result.data);
                _this._allResArr[3] = _this.xitiRet ;
                //将新搜索的结果append到Dom上
                _this._renderxitiResAndRegEvt(result);

            })
            e.stopPropagation();
        })

        _this.otherMore.find('a').on('click',function(e){
            _this.otherResInfoRqst.beikeId = _this.contextBeikeId;
            _this.otherResInfoRqst.unit = _this.contextUnit;
            _this.otherResInfoRqst.course = _this.contextCourse;
            _this.otherResInfoRqst.page ++;
            var url = netDiskURL + $.param(_this.otherResInfoRqst);
            ebookContext.getUser().getDataByUserToken(url).done(function(result){
                console.log(result);
                //将结果合并
                _this.otherRet = _this.otherRet.concat(result.data);
                _this._allResArr[4] = _this.otherRet ;
                //将新搜索的结果append到Dom上
                _this._renderotherResAndRegEvt(result);

            })
            e.stopPropagation();
        })
    }


    /*
     * 展示备课本内容
     */
    PrepareLessonTxt.prototype.show = function(){
        var _this = this;
        _this.clear();
        _this.preparePanel.show();
        var allResDom = _this.allResourceDom;
        _this.preparePanel.append(allResDom);
        var url = netDiskURL + $.param(_this.firstRqst);
        var bookCode = _this.bookContainer.bookMetaInfo.bookCode ||'';
        var unitCode = _this.bookContainer.getCurrUnit()||'';
        var courseCode = _this.bookContainer.getCurrCourse()||'';
        _this.currentUnitCode = unitCode;
        _this.currentCourseCode = courseCode;
        _this.contextUnit = unitCode;
        _this.contextCourse = courseCode;
        var bookTitle = _this.bookContainer.bookMetaInfo.title;
        _this.bookTitleDom.get(0).innerHTML = bookTitle;

        //获取当前书本的封面路径
        var path = ebookContext.getUser().getStdBookBasePath();
        var imgPath = path +'/'+ bookCode +'/'+bookCode+'_Thumbnail.png';
        //每个用户有本默认的书，这本书的封面图路径在bin目录users文件夹下对应的testcode 文件夹下
        if(bookCode == AppCfg.testBook || bookCode == AppCfg.testBook2){
            imgPath = _path.trimPosix(Config.binPath + 'users/' +  bookCode +'/' + bookCode+'_Thumbnail.png');
        }

        var imgDivStr = _this._imgStr;
        _this.thumbNailDom.append(imgDivStr.replace("{imgPath}",imgPath));

        //发送请求，判段当前书本有没有备课本信息
        ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            var fid = 0,hasBeike = false;
            //遍历结果，判断当前bookCode的书本有没有对应的备课本
            for(var i = 0,len = ret.length; i < len ; i++){
                if(ret[i].bookcode == bookCode){
                    fid = ret[i].fid;
                    hasBeike = true;
                    break;
                }
            }
            //如果发现没有备课本，则应该创建
            if(!hasBeike){
                _this.createbeikeRqst.bookCode = bookCode;
                var createUrl = netDiskURL + $.param(_this.createbeikeRqst);
                ebookContext.getUser().getDataByUserToken(createUrl).done(function(beikeId){
                    _this.resCountRqst.beikeId = beikeId;
                    _this.contextBeikeId = beikeId;
                    //根据fid和uid查询课本中具体到单元具体到课的全部资源类型的数目
                    var resRqUrl = netDiskURL + $.param(_this.resCountRqst);
                    ebookContext.getUser().getDataByUserToken(resRqUrl).done(function(ret){
                        _this._renderTable(ret);
                        _this._registerTableEvent(_this.resourceCountDivDom);
                    });
                    //查询所以类型资源
                    _this.resInfoRqst.beikeId = beikeId;
                    _this.resInfoRqst.unit = unitCode;
                    _this.resInfoRqst.course = courseCode;
                    _this.resInfoRqst.page = 1;
                    var resInfoUrl = netDiskURL + $.param(_this.resInfoRqst);
                    ebookContext.getUser().getDataByUserToken(resInfoUrl).done(function(ret){
                        _this._renderAllResAndRegEvt(ret);
                    });

                    //智能推荐
                    _this.recommendrqst.book = bookCode;
                    _this.recommendrqst.unit = unitCode;
                    _this.recommendrqst.course = courseCode;
                    var recommUrl = recommendResUrl + $.param(_this.recommendrqst);
                    ebookContext.getUser().getDataByUserToken(recommUrl).done(function(ret){

                        _this._renderRecmdRes(ret);
                        _this._registerRecmdResEvt();
                    })
                })
            }

            //根据hasBeike状态，决定如何处理及显示
            if(hasBeike){
                //根据fid和uid查询课本中具体到单元具体到课的全部资源类型的数目
                _this.resCountRqst.beikeId = fid;
                _this.contextBeikeId = fid;
                var resRqUrl = netDiskURL + $.param(_this.resCountRqst);
                ebookContext.getUser().getDataByUserToken(resRqUrl).done(function(ret){
//                    ret = {"id":114,"fid":"fdecdd01-9b99-4409-9b72-589b2b77d0f4","uid":"2134000017000003188","bookcode":"02010107-001","createtime":1407741467,"info":"{\"covers\":{},\"name\":\"语文北师大二年级上册\",\"year\":\"2014-2015下学期\",\"property\":{\"edition\":[\"19\"],\"volumn\":[\"01\"],\"subject\":[\"01\"],\"book\":[\"02010107-001\"],\"grade\":[\"02\"],\"type\":[\"1100\",\"1102\"],\"phase\":[\"03\"],\"stage\":[\"020001\"],\"publisher\":[\"07\"]}}","isdel":0,"countInfo":[{"courses":[{"countInfo":[],"courseCode":"","courseName":"目录"}],"unitName":"目录","unitCode":"01"},{"courses":[{"countInfo":[{"id":9,"uid":"2134000017000003188","fid":"fdecdd01-9b99-4409-9b72-589b2b77d0f4","unitcode":"02","coursecode":"001","type":"0000","count":1},{"id":4,"uid":"2134000017000003188","fid":"fdecdd01-9b99-4409-9b72-589b2b77d0f4","unitcode":"02","coursecode":"001","type":"0100","count":4},{"id":5,"uid":"2134000017000003188","fid":"fdecdd01-9b99-4409-9b72-589b2b77d0f4","unitcode":"02","coursecode":"001","type":"0300","count":1},{"id":6,"uid":"2134000017000003188","fid":"fdecdd01-9b99-4409-9b72-589b2b77d0f4","unitcode":"02","coursecode":"001","type":"0400","count":1},{"id":8,"uid":"2134000017000003188","fid":"fdecdd01-9b99-4409-9b72-589b2b77d0f4","unitcode":"02","coursecode":"001","type":"0600","count":1}],"courseCode":"001","courseName":"秋天到"},{"countInfo":[{"id":7,"uid":"2134000017000003188","fid":"fdecdd01-9b99-4409-9b72-589b2b77d0f4","unitcode":"02","coursecode":"002","type":"0100","count":1}],"courseCode":"002","courseName":"火红的枫叶"},{"countInfo":[{"id":10,"uid":"2134000017000003188","fid":"fdecdd01-9b99-4409-9b72-589b2b77d0f4","unitcode":"02","coursecode":"003","type":"0100","count":1}],"courseCode":"003","courseName":"语文天地"}],"unitName":"1 秋天","unitCode":"02"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"妈妈，不要送伞来"},{"countInfo":[],"courseCode":"002","courseName":"小狮子"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"2 自立","unitCode":"03"},{"courses":[{"countInfo":[],"courseCode":"","courseName":"3 丁丁冬冬学识字（一）"}],"unitName":"3 丁丁冬冬学识字（一）","unitCode":"04"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"流动的画"},{"countInfo":[],"courseCode":"002","courseName":"祖国在我心间"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"4 祖国","unitCode":"05"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"苹果落地"},{"countInfo":[],"courseCode":"002","courseName":"我的影子"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"5 好奇","unitCode":"06"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"手捧空花盆的孩子"},{"countInfo":[],"courseCode":"002","courseName":"可爱的娃娃"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"6 诚实","unitCode":"07"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"我有一盒彩笔"},{"countInfo":[],"courseCode":"002","courseName":"王冕学画"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"7 画","unitCode":"08"},{"courses":[{"countInfo":[],"courseCode":"","courseName":"8 书的世界"}],"unitName":"8 书的世界","unitCode":"09"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"比本领"},{"countInfo":[],"courseCode":"002","courseName":"天鹅、大虾和梭鱼"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"9 合作","unitCode":"10"},{"courses":[{"countInfo":[],"courseCode":"","courseName":"10 丁丁冬冬学识字（二）"}],"unitName":"10 丁丁冬冬学识字（二）","unitCode":"11"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"上天的蚂蚁"},{"countInfo":[],"courseCode":"002","courseName":"第三个小板凳"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"11 努力","unitCode":"12"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"特殊的考试"},{"countInfo":[],"courseCode":"002","courseName":"小马过河"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"12 考验","unitCode":"13"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"风"},{"countInfo":[],"courseCode":"002","courseName":"我是什么"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"13 风和水","unitCode":"14"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"绒毛小熊"},{"countInfo":[],"courseCode":"002","courseName":"我们的玩具和游戏"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"14 玩具和游戏","unitCode":"15"},{"courses":[{"countInfo":[],"courseCode":"001","courseName":"贺年片"},{"countInfo":[],"courseCode":"002","courseName":"松鼠日记"},{"countInfo":[],"courseCode":"003","courseName":"语文天地"}],"unitName":"15 岁月","unitCode":"16"},{"courses":[{"countInfo":[],"courseCode":"","courseName":"认字表"}],"unitName":"认字表","unitCode":"17"},{"courses":[{"countInfo":[],"courseCode":"","courseName":"写字表"}],"unitName":"写字表","unitCode":"18"},{"courses":[{"countInfo":[],"courseCode":"","courseName":"查字表"}],"unitName":"查字表","unitCode":"19"},{"courses":[{"countInfo":[],"courseCode":"","courseName":"常用部首表"}],"unitName":"常用部首表","unitCode":"20"}]};

                    _this._renderTable(ret);
                    _this._registerTableEvent(_this.resourceCountDivDom);

                });

                //查询所有类型资源
                _this.resInfoRqst.beikeId = fid;
                _this.resInfoRqst.unit = unitCode;
                _this.resInfoRqst.course = courseCode;
                _this.resInfoRqst.page = 1;
                var resInfoUrl = netDiskURL + $.param(_this.resInfoRqst);

                ebookContext.getUser().getDataByUserToken(resInfoUrl).done(function(ret){

                    _this.kejianDom.empty();

                    _this.jiaoanDom.empty();
                    _this.sucaiDom.empty();
                    _this.xitiDom.empty();
                    _this.otherDom.empty();
                    _this._renderAllResAndRegEvt(ret);
                });

                //智能推荐
                _this.recommendrqst.book = bookCode;
                _this.recommendrqst.unit = unitCode;
                _this.recommendrqst.course = courseCode;
                var recommUrl = recommendResUrl + $.param(_this.recommendrqst);
                ebookContext.getUser().getDataByUserToken(recommUrl).done(function(ret){

                    //将结果保存成不区分类型的格式
                    _this._renderRecmdRes(ret);
                    _this._registerRecmdResEvt();
                })
            }
        })

    }


    PrepareLessonTxt.prototype.hide = function(){
        var _this = this;
        _this.preparePanel.hide();
    }


    /**
     * 渲染目录表格
     * @param ret
     * @private
     */
    PrepareLessonTxt.prototype._renderTable = function(ret){
        var _this = this;
        var scrolltotop = 0;//滚动条的位置
        var lineCounts = 0;
        var flag = 0;
        //遍历json中的每一个单元、每一课
        for(var i = 0,unitCount = ret.countInfo.length; i < unitCount; i++){
            var unitCode = ret.countInfo[i].unitCode;
            var unitName = ret.countInfo[i].unitName;
            var eachUnitTpl = _this._eachUnitTpl;
            eachUnitTpl = eachUnitTpl.replace("{unitName}",unitName);
            _this.resourceCountDivDom.append(eachUnitTpl);//append 上标题
            var tableDomInUnit = $(_this._unitCourseTpl);

            for(var j = 0, courseCount = ret.countInfo[i].courses.length; j < courseCount; j++){
                var cntInfo = ret.countInfo[i].courses[j].countInfo;
                var courseName = ret.countInfo[i].courses[j].courseName;
                var courseCode = ret.countInfo[i].courses[j].courseCode;
                var kejianCount = 0, jiaoanCount = 0, sucaiCount = 0, xitiCount = 0, otherCount = 0;
                flag+=1;
                if(cntInfo.length > 0){
                    for(var k = 0;k < cntInfo.length;k++){
                        var typeCode = cntInfo[k].type,resCnt = cntInfo[k].count;
                        switch (typeCode){
                            case '0100'://教案
                                jiaoanCount = resCnt;break;
                            case '0300'://素材
                                sucaiCount = resCnt;break;
                            case '0400'://习题
                                xitiCount = resCnt;break;
                            case '0600'://课件
                                kejianCount = resCnt;break;
                            case '0000' ://0000 其他
                                otherCount = resCnt;break;
                        }

                    }
                }
                var tmpEachTpl = _this._eachTabTpl;

                tmpEachTpl = tmpEachTpl.replace("{unitcode}",unitCode)
                    .replace("{coursecode}",courseCode)
                    .replace("{courseName}",courseName)
                    .replace("{kejianCount}",kejianCount)
                    .replace("{jiaoanCount}",jiaoanCount)
                    .replace("{sucaiCount}",sucaiCount)
                    .replace("{xitiCount}",xitiCount)
                    .replace("{otherCount}",otherCount);
                if(courseCode == _this.currentCourseCode && unitCode == _this.currentUnitCode){
                    tmpEachTpl = tmpEachTpl.replace("{className}",'sm_book_ifo_tab_tr2')
                    lineCounts = flag + i  ;
                }else{
                    tmpEachTpl = tmpEachTpl.replace("{className}",'');
                }

                tableDomInUnit.append(tmpEachTpl);

            }
            _this.resourceCountDivDom.append(tableDomInUnit);
            $("#resourceCountDiv").scrollTop(lineCounts*30);
        }
    }

    /**
     * 注册表格事件
     * @param tableDom
     * @private
     */
    PrepareLessonTxt.prototype._registerTableEvent = function(tableDom){
        var _this = this;
        tableDom.find("td[class1=countClass]")
            .on('click',function(){
                var unitcode = $(this).parent().attr("unitCode");
                var coursecode =  $(this).parent().attr("courseCode");
//                alert($(this).index());
                var position = $(this).index();
                var reurl;
//                if( unitcode == _this.currentUnitCode && coursecode == _this.currentCourseCode){
//                    //点击的是当前行
////                    alert("current");
//                    _this._clearAllTypeRes();
//                    _this.resInfoRqst.unit = unitcode;
//                    _this.resInfoRqst.course = coursecode;
//                    reurl = netDiskURL + $.param(_this.resInfoRqst);
//
//                    shellcmd.getHttpRequest(reurl).done(function(ret){
//                        _this._renderAllResAndRegEvt(ret);
//                    });
//
//                }else{
//                    //切换课，需要重新请求获取所有类型的资源
//                    //请求前，先empty该区域
//                    _this._clearAllTypeRes();
//                    _this.resInfoRqst.unit = unitcode;
//                    _this.resInfoRqst.course = coursecode;
//                    reurl = netDiskURL + $.param(_this.resInfoRqst);
//                    shellcmd.getHttpRequest(reurl).done(function(ret){
//                        _this._renderAllResAndRegEvt(ret);
//                    });
//                }
                //切换课，需要重新请求获取所有类型的资源
                //请求前，先empty该区域
//                _this._clearAllTypeRes();
                _this.contextUnit = unitcode;
                _this.contextCourse = coursecode;
                _this.resInfoRqst.unit = unitcode;
                _this.resInfoRqst.course = coursecode;
                _this.resInfoRqst.page = 1;

                reurl = netDiskURL + $.param(_this.resInfoRqst);

                ebookContext.getUser().getDataByUserToken(reurl).done(function(ret){
                    _this._clearAllTypeRes();
                    //这个地方reset下相关数据
                    _this._reset();
                    _this._renderAllResAndRegEvt(ret);
                    //position:1,2,3,4,5 分别为课件，教案，素材，习题，其他
                    switch (position){
                        case 1:
                            _this.kejianDiv.get(0).scrollIntoView();
                            break;
                        case 2:
                            _this.jiaoanDiv.get(0).scrollIntoView();
                            break;
                        case 3:
                            _this.sucaiDiv.get(0).scrollIntoView();
                            break;
                        case 4:
                            _this.xitiDiv.get(0).scrollIntoView();
                            break;
                        case 5:
                            _this.otherDiv.get(0).scrollIntoView();
                            break;

                    }
                    $("#smartbar")[0].scrollIntoView(false);
                });


            })

    }


    /**
     * 复位初始化状态
     * @private
     */
    PrepareLessonTxt.prototype._reset = function(){
        var _this = this;
        _this.kejianResInfoRqst.page = 1;
        _this.jiaoanResInfoRqst.page = 1;
        _this.sucaiResInfoRqst.page = 1;
        _this.xitiResInfoRqst.page = 1;
        _this.otherResInfoRqst.page = 1;
    }

    /**
     * 渲染备课本中所有类型（课件、教案、素材、习题、其他）资源，并注册事件
     * @param ret
     * @private
     */
    PrepareLessonTxt.prototype._renderAllResAndRegEvt = function(ret){
        var _this = this;

        //根据json来展示到页面上
        //遍历json结构，区分出各种类型，分别渲染到页面上
        for(var i = 0,len = ret.length; i < len ; i++){
            switch (ret[i].code){
                case '0600'://课件
                    _this.kejianRet = ret[i].data;
                    _this._allResArr[0] = _this.kejianRet;
                    _this._renderkejianResAndRegEvt(ret[i]);
                    break;
                case '0100'://教案
                    _this.jiaoanRet = ret[i].data;
                    _this._allResArr[1] = _this.jiaoanRet ;
                    _this._renderjiaoanResAndRegEvt(ret[i]);
                    break;
                case '0300'://素材
                    _this.sucaiRet = ret[i].data;
                    _this._allResArr[2] = _this.sucaiRet;
                    _this._rendersucaiResAndRegEvt(ret[i]);
                    break;
                case '0400'://习题
                    _this.xitiRet = ret[i].data;
                    _this._allResArr[3] = _this.xitiRet;
                    _this._renderxitiResAndRegEvt(ret[i]);
                    break;
                case '0000'://其他
                    _this.otherRet = ret[i].data;
                    _this._allResArr[4] = _this.otherRet;
//                    _this._renderotherResAndRegEvt(ret[i].data);
                    _this._renderotherResAndRegEvt(ret[i]);
                    break;
            }
        }

        //所有类型都没有资源则显示一个“您当前的备课本中暂无资源”的界面
        if(!_this._haskejianRes && !_this._hasjiaoanRes
            && !_this._hassucaiRes && !_this._hasxitiRes && !_this._hasotherRes){
//            _this.preparePanel.find('.smartbar_tab_cont_bot_l').find("div[class1=resourceType]").hide();
            _this.preparePanel.find('.smartbar_tab_cont_bot_l').find('.no_res01').remove();
            _this.preparePanel.find('.smartbar_tab_cont_bot_l').append(_this._noOneResStr);
        }
    }

    /**
     * 渲染课件资源，并注册事件
     * @param datas
     * @private
     */
    PrepareLessonTxt.prototype._renderkejianResAndRegEvt = function(datas){
        var _this = this;
        var eachResStr;
//        var stateArr = [];
        if(datas.total == 0){
//            _this.kejianDom.append(_this._noResStr);
            _this.kejianDom.parent().hide();
            _this._haskejianRes = false;
            return;
        }
        if( _this.kejianRet.length < datas.total ){
            _this.kejianMore.css('display','block');
        }else {
            _this.kejianMore.css('display','none');
        }
        _this.preparePanel.find('.smartbar_tab_cont_bot_l').find('.no_res01').remove();
        _this.kejianDom.parent().show();
        _this._haskejianRes = true;

        for(var j =0; j<datas.data.length ;j++){
            var resourceName = datas.data[j].fileInfo.aliasname? datas.data[j].fileInfo.aliasname: datas.data[j].fileInfo.name;
            eachResStr = _this._eachResStr;
            eachResStr = eachResStr
                .replace("{fid}",datas.data[j].fileInfo.fid)
                .replace("{xindex}",0)
                .replace("{yindex}",j)
                .replace("{imgsrc}",_this.setDefaultPic(datas.data[j].fileInfo.extension))
                .replace("{resourceName}",resourceName);
            _this.kejianDom.append(eachResStr);
            _this.kejianStateArr.push(false);
        }
        _this.registerAllTypeResourceEvt ();
        _this._allResClickState[0] = _this.kejianStateArr;
    }

    /**
     * 渲染教案资源，并注册事件
     * @param datas
     * @private
     */
    PrepareLessonTxt.prototype._renderjiaoanResAndRegEvt = function(datas){
        var _this = this;
        var eachResStr;
//        var stateArr = [];
        if(datas.total == 0){//没有资源
            _this.jiaoanDom.parent().hide();
            _this._hasjiaoanRes = false;
            return;
        }
        //判断什么时候显示查看更多，什么时候隐藏查看更多
        if( _this.jiaoanRet.length < datas.total ){
            _this.jiaoanMore.css('display','block');
        }else {
            _this.jiaoanMore.css('display','none');
        }

        _this._hasjiaoanRes = true;
        _this.preparePanel.find('.smartbar_tab_cont_bot_l').find('.no_res01').remove();
        _this.jiaoanDom.parent().show();
        for(var j =0; j<datas.data.length ;j++){
            var resourceName = datas.data[j].fileInfo.aliasname? datas.data[j].fileInfo.aliasname: datas.data[j].fileInfo.name;
            eachResStr = _this._eachResStr;
            eachResStr = eachResStr
                .replace("{fid}",datas.data[j].fileInfo.fid)
                .replace("{xindex}",1)
                .replace("{yindex}",j)//注意：因为分页需求，点击查看更多的需求原因，不再用该属性取得索引。
                .replace("{imgsrc}",_this.setDefaultPic(datas.data[j].fileInfo.extension))
                .replace("{resourceName}",resourceName);
            _this.jiaoanDom.append(eachResStr);
            _this.jiaoanStateArr.push(false);
        }
        _this.registerAllTypeResourceEvt ();
        _this._allResClickState[1] = _this.jiaoanStateArr;

    }

    /**
     * 渲染素材资源并注册事件
     * @param datas
     * @private
     */
    PrepareLessonTxt.prototype._rendersucaiResAndRegEvt = function(datas){
        var _this = this;
        var eachResStr;
//        var stateArr = [];
        if(datas.total == 0){
            _this.sucaiDom.parent().hide();
            _this._hassucaiRes = false;
            return;
        }
        if( _this.sucaiRet.length < datas.total ){
            _this.sucaiMore.css('display','block');
        }else {
            _this.sucaiMore.css('display','none');
        }

        _this.preparePanel.find('.smartbar_tab_cont_bot_l').find('.no_res01').remove();
        _this.sucaiDom.parent().show();

        _this._hassucaiRes = true;
        for(var j =0; j<datas.data.length ;j++){
            var resourceName = datas.data[j].fileInfo.aliasname? datas.data[j].fileInfo.aliasname: datas.data[j].fileInfo.name;
            eachResStr = _this._eachResStr;
            eachResStr = eachResStr
                .replace("{fid}",datas.data[j].fileInfo.fid)
                .replace("{xindex}",2)
                .replace("{yindex}",j)
                .replace("{imgsrc}",_this.setDefaultPic(datas.data[j].fileInfo.extension))
                .replace("{resourceName}",resourceName);
            _this.sucaiDom.append(eachResStr);
            _this.sucaiStateArr.push(false);
        }
        _this._allResClickState[2] = _this.sucaiStateArr;
        _this.registerAllTypeResourceEvt ();
    }

    /**
     * 渲染习题资源并注册事件
     * @param datas
     * @param reload
     * @private
     */
    PrepareLessonTxt.prototype._renderxitiResAndRegEvt = function(datas,reload){
        var _this = this;
        var eachResStr;
//        var stateArr = [];
        if(datas.total == 0){
//            _this.xitiDom.append(_this._noResStr);
            _this.xitiDom.parent().hide();
            _this._hasxitiRes = false;
            return;
        }
        if( _this.xitiRet.length < datas.total ){
            _this.xitiMore.css('display','block');
        }else {
            _this.xitiMore.css('display','none');
        }

        _this.preparePanel.find('.smartbar_tab_cont_bot_l').find('.no_res01').remove();
        _this.xitiDom.parent().show();
        _this._hasxitiRes = true;
        for(var j =0; j<datas.data.length ;j++){
            var resourceName = datas.data[j].fileInfo.aliasname? datas.data[j].fileInfo.aliasname: datas.data[j].fileInfo.name;
            eachResStr = _this._eachResStr;
            eachResStr = eachResStr
                .replace("{fid}",datas.data[j].fileInfo.fid)
                .replace("{xindex}",3)
                .replace("{yindex}",j)
                .replace("{imgsrc}",_this.setDefaultPic(datas.data[j].fileInfo.extension))
                .replace("{resourceName}",resourceName);
            _this.xitiDom.append(eachResStr);
            _this.xitiStateArr.push(false);
        }
        _this._allResClickState[3] = _this.xitiStateArr;
        _this.registerAllTypeResourceEvt ();
    }

    /**
     * 渲染其他资源并注册事件
     * @param datas
     * @private
     */
    PrepareLessonTxt.prototype._renderotherResAndRegEvt = function(datas){
        var _this = this;
        var eachResStr;
//        var stateArr = [];
        if(datas.total == 0){
            _this.otherDom.parent().hide();
            _this._hasotherRes = false;
            return;
        }
        if( _this.otherRet.length < datas.total ){
            _this.otherMore.css('display','block');
        }else {
            _this.otherMore.css('display','none');
        }
        _this.preparePanel.find('.smartbar_tab_cont_bot_l').find('.no_res01').remove();
        _this.otherDom.parent().show();
        _this._hasotherRes = true;
        for(var j =0; j<datas.data.length ;j++){
            var resourceName = datas.data[j].fileInfo.aliasname? datas.data[j].fileInfo.aliasname: datas.data[j].fileInfo.name;
            eachResStr = _this._eachResStr;
            eachResStr = eachResStr
                .replace("{fid}",datas.data[j].fileInfo.fid)
                .replace("{xindex}",4)
                .replace("{yindex}",j)
                .replace("{imgsrc}",_this.setDefaultPic(datas.data[j].fileInfo.extension))
                .replace("{resourceName}",resourceName);
            _this.otherDom.append(eachResStr);
            _this.otherStateArr.push(false);

        }
        _this._allResClickState[4] =  _this.otherStateArr;
        _this.registerAllTypeResourceEvt ();
    }

    /**
     * 渲染推荐资源
     * @param ret
     * @private
     */
    PrepareLessonTxt.prototype._renderRecmdRes = function(ret){
        var _this = this;
        var eachRecStr ;
        _this.originRecmdRlt = ret;
        var count = 0;
        if(ret.total == 0){
//            _this.recmdDom.append(_this._noResStr);
            _this.recmdDom.parent().hide();
            return;
        }
        _this.recmdDom.empty();//智能推荐
        _this.recmdDom.parent().show();

//        for(var i = 0,iMax = ret.data.length; i < iMax; i++){
//            var recmdRes = [];
//            for(var j = 0,jMax = ret.data[i].data.length; j < jMax; j++){
//                recmdRes.push(false);
//                if(count == 4){//只显示4个
//                    break;
//                }
//                eachRecStr = _this._eachRecmdStr;
//                eachRecStr = eachRecStr.replace("{recimgsrc}",_this.setDefaultPic(ret.data[i].data[j].extension))
//                    .replace("{recresName}",ret.data[i].data[j].title)
//                    .replace("{xindex}",i).replace("{yindex}",j);
//                _this.recmdDom.append(eachRecStr);
//                count +=1;
//            }
//            _this._recCmdResClickState[i] = recmdRes;
//        }
        for(var i = 0,iMax = ret.data.length; i < iMax; i++){
            var recmdRes = [];
            if(ret.data[i].total <= 0){
                continue;
            }
            for(var j = 0; j < 1; j++){//每种推荐资源类型取一个资源，共4个资源
                recmdRes.push(false);
                if(count == 4){//只显示4个
                    break;
                }
                eachRecStr = _this._eachRecmdStr;
                eachRecStr = eachRecStr.replace("{fid}",ret.data[i].data[j].id)
                    .replace("{recimgsrc}",_this.setDefaultPic(ret.data[i].data[j].extension))
                    .replace("{recresName}",ret.data[i].data[j].title)
                    .replace("{xindex}",i).replace("{yindex}",j);
                _this.recmdDom.append(eachRecStr);
                count +=1;
            }
            _this._recCmdResClickState[i] = recmdRes;
        }

    }

    /**
     * 对所有资源进行事件绑定
     */
    PrepareLessonTxt.prototype.registerAllTypeResourceEvt = function(){
        var _this = this;
        _this.preparePanel.find("li[class1=allTypeResourceList]").unbind('click')
            .click(function(){
                var x = parseInt($(this).attr('xIndex'));
//                var y = parseInt($(this).attr('yIndex'));
                var y = parseInt($(this).index());
                _this.preparePanel.find('.re_group_block_warp').remove();

//                var preparePop = ('<div class="re_group_block_warp" id="prepareLessonPop" style="z-index: 10003;margin-left:-50px;">'+
//                    '<div class="re_group_block_con">'+
//                    '<dl>'+
//                    '<dd class="re_gr_img"><img id="lessonPreImg" src="" alt=""></dd>'+
//                    '<dd class="re_gr_btn clearfix">'+
//                    '<span id="lessonPreviewRes" xindex={xIndex} yindex={yIndex}>预览</span>'+
//                    '<span id="lessonAddResToBook" xindex={xIndex1} yindex={yIndex1}>加入课本</span>'+
//                    '</dd>'+
//                    '<dd class="re_gr_text">可直接拖动加入课本</dd>'+
//                    '</dl>'+
//                    '</div>'+
//                    '</div>');
                var preparePop = ('<div class="re_group_block_warp re_group_block_warp_top" id="netdisklesson_pop" style="z-index: 1003;">'+
                    '<div class="re_group_block_con re_group_block_warp_top_con">'+
                    '<dl>'+
                    '<dd class="re_gr_img"><img id="lessonPreImg" style="width: 132px;height: 132px;" src="assert/images/re_gr_img01.png" alt=""></dd>'+
                    '<dd class="re_gr_btn clearfix">'+
                    '<span id="lessonPreviewRes" xindex={xIndex} yindex={yIndex}>预览</span>'+
                    '<span id="lessonAddResToBook" xindex={xIndex1} yindex={yIndex1}>加入课本</span>'+
                    '</dd>'+
                    '</dl>'+
                    '</div>'+
                    '</div>');

                preparePop = preparePop.replace("{xIndex}",x).replace("{yIndex}",y)
                    .replace("{xIndex1}",x).replace("{yIndex1}",y);
                $(this).append((preparePop));

                if(parseInt(y)%6==0) $("#netdisklesson_pop").addClass("re_g_b_w_t_left");
                if(parseInt(y)%6==5) $("#netdisklesson_pop").addClass("re_g_b_w_t_right");
                //为预览与加入课本绑定事件
                $("#lessonPreviewRes").on('click',function(){
                    var type = _this._allResArr[x][y].fileInfo.extension;
                    var previewpath = _this._allResArr[x][y].fileInfo.previewpath;

                    //预览资源时传入下载参数，以便在预览时进行下载
                    var resultData = {};
                    var tp = _this._allResArr[x][y].fileInfo.thumbpath;
                    resultData.id = _this._allResArr[x][y].fileInfo.fid;
                    resultData.fileurl = _this._allResArr[x][y].fileInfo.downloadpath;
                    resultData.title = _this._allResArr[x][y].fileInfo.name;
                    resultData.lastmodify = _this._allResArr[x][y].fileInfo.modifytime;
                    tp ? (resultData.thumburl = tp) : resultData.thumburl = "";
                    resultData.creator = "";
                    resultData.resFrom = 'netdisklesson';
                    newWidgetPos = null;

                    _this.previewRes(type,previewpath,resultData);
                })
                $("#lessonAddResToBook").on('click',function(){
                    var resultData = {};
                    var tp = _this._allResArr[x][y].fileInfo.thumbpath;
                    resultData.id = _this._allResArr[x][y].fileInfo.fid;
                    resultData.fileurl = _this._allResArr[x][y].fileInfo.downloadpath;
                    resultData.title = _this._allResArr[x][y].fileInfo.name;
                    resultData.lastmodify = _this._allResArr[x][y].fileInfo.modifytime;
                    tp ? (resultData.thumburl = tp) : resultData.thumburl = "";
                    resultData.creator = "";
                    newWidgetPos = null;
                    resultData.resFrom = 'netdisklesson';
                    _this.downLoadFile(resultData);
                })
                _this.resSpecificRqst.fileId = _this._allResArr[x][y].fileInfo.fid;
                var reqUrl = netDiskURL + $.param(_this.resSpecificRqst);
                ebookContext.getUser().getDataByUserToken(reqUrl).done(function(ret){
                    var thumbpath = ret.thumbpath;
                    _this._allResArr[x][y].fileInfo.previewpath = ret.previewpath;
                    _this._allResArr[x][y].fileInfo.downloadpath = ret.downloadpath;
                    $("#lessonPreImg").attr('src',thumbpath);
                    if(!_this._allResClickState[x][y]){
                        _this.preparePanel.find('.re_group_block_warp').show();
                        _this._allResClickState[x][y] = true;
                    }else{
                        _this.preparePanel.find('.re_group_block_warp').hide();
                        _this._allResClickState[x][y] = false;
                    }
                })

                $(this).get(0).scrollIntoView();
                $("#smartbar")[0].scrollIntoView(false);
            })

        _this.preparePanel.find('li[class1=allTypeResourceList]').on('dragend',function(e){
            var x = parseInt($(this).attr('xIndex'));
            var y = parseInt($(this).attr('yIndex'));

            newWidgetPos = {
                left : e.originalEvent.clientX,
                top : e.originalEvent.clientY
            }

            //发另一个请求获取downloadPath，prewURl，thumbURL
            _this.resSpecificRqst.fileId = _this._allResArr[x][y].fileInfo.fid;
            var reqUrl = netDiskURL + $.param(_this.resSpecificRqst);
            ebookContext.getUser().getDataByUserToken(reqUrl).done(function(ret){

                _this._allResArr[x][y].fileInfo.thumbpath = ret.thumbpath;
                _this._allResArr[x][y].fileInfo.previewpath = ret.previewpath;
                _this._allResArr[x][y].fileInfo.downloadpath = ret.downloadpath;

                var resultData = {};
                var tp = _this._allResArr[x][y].fileInfo.thumbpath;
                resultData.id = _this._allResArr[x][y].fileInfo.fid;
                resultData.fileurl = _this._allResArr[x][y].fileInfo.downloadpath;
                resultData.title = _this._allResArr[x][y].fileInfo.name;
                resultData.lastmodify = _this._allResArr[x][y].fileInfo.modifytime;
                tp ? (resultData.thumburl = tp) : resultData.thumburl = "";
                resultData.creator = "";
                resultData.resFrom = 'netdisklesson';
                _this.downLoadFile(resultData);
            })
        })

    }

    /**
     * 注册推荐资源事件
     * @private
     */
    PrepareLessonTxt.prototype._registerRecmdResEvt = function(){
        var _this = this;
        _this.preparePanel.find("li[class1=recmdResourceList]").unbind('click')
            .click(function(){
                var x = parseInt($(this).attr('xIndex'));
                var y = parseInt($(this).attr('yIndex'));
                _this.preparePanel.find('.re_group_block_warp').remove();

                var preparePop = ('<div class="re_group_block_warp" id="recmdPop" style="z-index: 10003;margin-left:-50px;">'+
                    '<div class="re_group_block_con re_group_block_con_bar">'+
                    '<dl>'+
                    '<dd class="re_gr_img"><img id="rcmdPreImg" src="assert/images/re_gr_img01.png" alt=""></dd>'+
                    '<dd class="re_gr_btn clearfix">'+
                    '<span id="recmdPreviewRes" xindex={xIndex} yindex={yIndex}>预览</span>'+
                    '<span id="recmdAddResToBook" xindex={xIndex1} yindex={yIndex1}>加入课本</span>'+
                    '</dd>'+
                    '<dd class="re_gr_text">可直接拖动加入课本</dd>'+
                    '</dl>'+
                    '</div>'+
                    '</div>');

                preparePop = preparePop.replace("{xIndex}",x).replace("{yIndex}",y)
                    .replace("{xIndex1}",x).replace("{yIndex1}",y);
                $(this).append(preparePop);

                var thumbUrl = _this.originRecmdRlt.data[x].data[y].thumburl;
                thumbUrl = thumbUrl?thumbUrl:_this.setDefaultPic(_this.originRecmdRlt.data[x].data[y].extension);
                $("#rcmdPreImg").attr('src',thumbUrl);
                //为预览与加入课本绑定事件
                $("#recmdPreviewRes").on('click',function(){
                    var type = _this.originRecmdRlt.data[x].data[y].extension;
                    var previewpath = _this.originRecmdRlt.data[x].data[y].previewurl;
                    //预览资源时传入下载参数，以便在预览时进行下载
                    var resultData = {};
                    resultData.id = _this.originRecmdRlt.data[x].data[y].id;
                    resultData.fileurl = _this.originRecmdRlt.data[x].data[y].fileurl;
                    resultData.title = _this.originRecmdRlt.data[x].data[y].title;
                    resultData.lastmodify = _this.originRecmdRlt.data[x].data[y].modifytime;
                    resultData.creator = _this.originRecmdRlt.data[x].data[y].creator;
                    resultData.statistics = {};
                    resultData.statistics.score = _this.originRecmdRlt.data[x].data[y].score;
                    resultData.thumbpath?(resultData.thumburl = resultData.thumbpath):(resultData.thumburl = "");

                    newWidgetPos = null;
                    _this.previewRes(type,previewpath,resultData);
                })
                $("#recmdAddResToBook").on('click',function(){
                    var resultData = {};
                    resultData.id = _this.originRecmdRlt.data[x].data[y].id;
                    resultData.fileurl = _this.originRecmdRlt.data[x].data[y].fileurl;
                    resultData.title = _this.originRecmdRlt.data[x].data[y].title;
                    resultData.lastmodify = _this.originRecmdRlt.data[x].data[y].modifytime;
                    resultData.creator = _this.originRecmdRlt.data[x].data[y].creator;
                    resultData.statistics = {};
                    resultData.statistics.score = _this.originRecmdRlt.data[x].data[y].score;
                    resultData.thumbpath?(resultData.thumburl = resultData.thumbpath):(resultData.thumburl = "");
                    resultData.resFrom = 'netdisklessonRecmd';
                    newWidgetPos = null;
                    _this.downLoadFile(resultData);
                })

                if(!_this._recCmdResClickState[x][y]){
                    _this.preparePanel.find('.re_group_block_warp').show();
                    _this._recCmdResClickState[x][y] = true;
                }else{
                    _this.preparePanel.find('.re_group_block_warp').hide();
                    _this._recCmdResClickState[x][y] = false;
                }

            })

        _this.preparePanel.find("li[class1=recmdResourceList]").on('dragend',function(e){
            var x = parseInt($(this).attr('xIndex'));
            var y = parseInt($(this).attr('yIndex'));

            var resultData = {};
            resultData.id = _this.originRecmdRlt.data[x].data[y].id;
            resultData.fileurl = _this.originRecmdRlt.data[x].data[y].fileurl;
            resultData.title = _this.originRecmdRlt.data[x].data[y].title;
            resultData.lastmodify = _this.originRecmdRlt.data[x].data[y].modifytime;
            resultData.creator = _this.originRecmdRlt.data[x].data[y].creator;
            resultData.statistics = {};
            resultData.statistics.score = _this.originRecmdRlt.data[x].data[y].score;
            resultData.thumbpath?(resultData.thumburl = resultData.thumbpath):(resultData.thumburl = "");
            resultData.resFrom = 'netdisklessonRecmd';
            newWidgetPos = {
                left : e.originalEvent.clientX,
                top : e.originalEvent.clientY
            }

            _this.downLoadFile(resultData);
        })

    }


    /**
     * 清除相关dom结构，恢复初始状态
     */
    PrepareLessonTxt.prototype.clear = function(){
        var _this = this;
        _this.resourceCountDivDom.empty();
        _this.thumbNailDom.empty();
        _this.tableDom.find("tr[class1=resourceCountClass1]").remove();
        _this.recmdDom.empty();//智能推荐
        _this._clearAllTypeRes();

    }

    /**
     * 清除所有类型资源dom结构
     * @private
     */
    PrepareLessonTxt.prototype._clearAllTypeRes = function(){
        var _this = this;
        _this.kejianDom.empty();
        _this.jiaoanDom.empty();
        _this.sucaiDom.empty();
        _this.xitiDom.empty();
        _this.otherDom.empty();

    }

    exports.Instance = new PrepareLessonTxt();
})