/**
 * Created by linwang5@iflytek.com on 2016/9/20.
 */
;
define(function (require, exports, module) {
    require('jquery');
    var shellcmd = require('../../../common/shellcmd');
    var _Des = require('../../../common/des');
    var fs = nodereq('fs');
    var sqlite3 = nodereq('sqlite3').verbose();
    var gm_ta = nodereq('gm_ta');
    var commFunc = require('../../../common/commonfunc');
    var userInfo = null;
    var ktslDbPath = process.execPath.replace(/\\/g, '/').replace('nw.exe', 'DAT/ktsl.db');
    var ifbDbPath = process.execPath.replace(/\\/g, '/').replace('nw.exe', 'plugins/62/bin/users/ktsl.db');
    var ktslDir = process.execPath.replace(/\\/g, '/').replace('nw.exe', 'plugins/62/bin/users/ktslDir/').replace('file:///', '');
    var uliDat = process.execPath.replace('nw.exe', 'uli.dat');
    var GMPath_E = process.execPath.replace(/\\/g, '/').replace('nw.exe', 'tools/GM-1.3.25/gm.exe');
    var _btn = {
        afterClass: $('#J_after_class')
    };
    var snapAfter = null;
    var snapshoting = false;//是否正在进行快照
    var _endStyle = 'endStyle';
    var _domRecord = $('#lessonRecord'); //有班级的整体弹出框
    var _close = $('#ktsl_close'); //关闭弹出框
    var _createClass = $('#ktsl_createClass');//创建班级
    var _classInfo = $('#ktsk_classList'); //班级列表
    var _refresh_class = $('#refresh_ktslClass'); //刷新班级列表
    var _class_ok = $('#lessonRecord_ok');
    var _class_no = $('#lessonRecord_no');
    var _classInfo_no = $('#ktsk_noClass');
    var _name = $('#lessonRecord_name');
    var _relation = $('#lessonRecord_relation');
    var _personal = $('#lessonRecord_personal');
    var _toRelation = $('#ktsl_toRelation');
    var _toPersonal = $('#ktsl_toPersonal');
    var phaseToGrade = [
        {
            "phase": "01",
            "grade": [
                {
                    "code": "14",
                    "name": "幼儿园小班"
                },
                {
                    "code": "15",
                    "name": "幼儿园中班"
                },
                {
                    "code": "16",
                    "name": "幼儿园大班"
                },
            ]
        },
        {
            "phase": "02",
            "grade": [
                {
                    "code": "17",
                    "name": "学前班"
                }
            ]
        },
        {
            "phase": "03",
            "grade": [
                {
                    "code": "01",
                    "name": "一年级"
                },
                {
                    "code": "02",
                    "name": "二年级"
                },
                {
                    "code": "03",
                    "name": "三年级"
                },
                {
                    "code": "04",
                    "name": "四年级"
                },
                {
                    "code": "05",
                    "name": "五年级"
                },
                {
                    "code": "06",
                    "name": "六年级"
                },
            ]
        },
        {
            "phase": "04",
            "grade": [
                {
                    "code": "07",
                    "name": "七年级"
                },
                {
                    "code": "08",
                    "name": "八年级"
                },
                {
                    "code": "09",
                    "name": "九年级"
                },
            ]
        },
        {
            "phase": "05",
            "grade": [
                {
                    "code": "10",
                    "name": "高一"
                },
                {
                    "code": "11",
                    "name": "高二"
                },
                {
                    "code": "12",
                    "name": "高三"
                },
            ]
        },
    ];
    _classInfo.unbind('change').on('change',function () {
        var $this = $(this).find('option:selected');
        $(this).attr('title',$this.attr('grade')+$this.attr('attrName'));
    });
    _toRelation.unbind('click').on('click', function () {
        var obj = {
            type: 'logic',
            action: 'TA_ktsl', //固定类型
            from: 'ib',//消息来源 ifb iflyslide dtb 等等
            to: 'main',//表示消息发送给TA
            id: _getRandomString(),//自己定义，无要求，不重复即可
            data: {
                class: 'goPage',//表示单点登录到网页
                toWhere: 'relation'
            }
        };
        socket.send(obj);

    });
    _toPersonal.unbind('click').on('click', function () {
        var obj = {
            type: 'logic',
            action: 'TA_ktsl', //固定类型
            from: 'ib',//消息来源 ifb iflyslide dtb 等等
            to: 'main',//表示消息发送给TA
            id: _getRandomString(),//自己定义，无要求，不重复即可
            data: {
                class: 'goPage',//表示单点登录到网页
                toWhere: 'personal'
            }
        };
        socket.send(obj);
    });
    _class_ok.unbind('click').on('click', function () {
        if (!_checkBlankTextTip([_name], 2)) return;
        updateIfbStatus(0);
        chkRecord();
    });
    _class_no.unbind('click').on('click', function () {
        _domRecord.hide();
        updateIfbStatus(0, function () {
            var attrDom = _classInfo.find('option:selected');
            var obj = {
                type: 'logic',
                action: 'TA_ktsl', //固定类型
                from: 'ib', //消息来源 ifb iflyslide dtb 等等
                to: 'main', //表示消息发送给TA
                id: _getRandomString(),//自己定义，无要求，不重复即可
                data: {
                    class: 'over', //表示为课堂实录结束的分类
                    src: '',//物理文件地址
                    isDelete: 2, // 是否可以删除，1 是 2 否
                    grade: '', //选择的年级名称，自由班级时为入学年份，可为空字符串
                    className: '', //选择的班级名称，无班级时可为空字符串
                    classId: '', //选择的班级id，无班级时可为空字符串
                    existZip: 2,//是否存在zip包  1 是 2 否
                    name: '',
                    toWhere: attrDom.length ? 'relation' : 'personal',
                    lessSaveFlag:0,
                    microCourseCount:0
                }
            };
            socket.send(obj);
            backToExit(_domRecord.attr(_endStyle));
        });

    });

    _close.unbind('click').on('click', function () {
        _domRecord.hide();
    });

    _refresh_class.unbind('click').on('click', function () {
        getLessonInfo();
    });

    _createClass.unbind('click').on('click', function () {
        // shellcmd.openPageOutside(Base_Cfg.YUN_CREATE_CLASS);
        //des单点登录跳转地址
        // loginUrl(Base_Cfg.YUN_CREATE_CLASS_BASE);
        //sso单点登录跳转地址
        commFunc.openWebPage(Base_Cfg.YUN_CREATE_CLASS_BASE + '&' + 'from=ew&appId=web');
    });

    function loginUrl(url) {
        getUserInfo(function (userInfo) {
            // DES.init("wyc4yrmK", userInfo._sso_loginName + "=" + userInfo.password);
            // var token = DES.Encrypt();
            // url = url + "&token=" + token;
            // shellcmd.openPageOutside(url);

            commFunc.openWebPage(url,{type: 'des'});
        });

    }

    function cancelKtsl() {
        var obj = {
            type: 'logic',
            action: 'TA_ktsl', //固定类型
            from: 'ib',//消息来源 ifb iflyslide dtb 等等
            to: 'main',//表示消息发送给TA
            id: _getRandomString(),//自己定义，无要求，不重复即可
            data: {
                class: 'cancel'//表示为取消课堂实录

            }
        };
        socket.send(obj);

    }

    function chkRecord() {

        getUserInfo(function (userInfo) {
            var attrDom = _classInfo.find('option:selected');
            var classId = attrDom.attr('classId') || "";
            var className = attrDom.attr('attrName') || "";
            var grade = attrDom.attr('grade') || "";
            var openId = userInfo._sso_openId;
            var isFree = attrDom.attr('isFree') == 'true' ? 1 : 0;
            var name = _name.val();
            if (attrDom.length) {
                rememberClass(classId, className, grade, openId, isFree);
            }
            getCurrent(function (err, row) {
                ktslZip(row[0].id).done(function (exist, src) {
                    _domRecord.hide();
                    var obj = {
                        type: 'logic',
                        action: 'TA_ktsl', //固定类型
                        from: 'ib', //消息来源 ifb iflyslide dtb 等等
                        to: 'main', //表示消息发送给TA
                        id: _getRandomString(),//自己定义，无要求，不重复即可
                        data: {
                            class: 'over', //表示为课堂实录结束的分类
                            src: src,//物理文件地址
                            isDelete: 1, // 是否可以删除，1 是 2 否
                            grade: grade, //选择的年级名称，自由班级时为入学年份，可为空字符串
                            className: className, //选择的班级名称，无班级时可为空字符串
                            classId: classId, //选择的班级id，无班级时可为空字符串
                            existZip: exist ? 1 : 2,//是否存在zip包  1 是 2 否
                            name: name,
                            toWhere: attrDom.length ? 'relation' : 'personal',
                            lessSaveFlag:1,
                            microCourseCount:0
                        }
                    };
                    socket.send(obj);
                    backToExit(_domRecord.attr(_endStyle));
                });
            });


        });
    }

    function getCurrent(callback) {
        var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
        var sql = "select * from current ";
        db.all(sql, function (err, row) {
            db.close();
            callback && callback(err, row);
        })
    }

    function rememberClass(classId, className, grade, openId, isFree) {
        var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
        var sql = "select * from class where openId='" + openId + "'";
        db.all(sql, function (err, rows) {
            if (err || rows.length < 1) {
                sql = "insert into class values('" +
                    classId + "','" + className + "','" + grade + "','" + isFree + "','" +
                    openId + "')";
            } else {
                sql = "update class set classId='" + classId + "', className='" + className
                    + "', grade='" + grade + "', isFree='" + isFree
                    + "' where openId='" + openId + "'";
            }
            db.exec(sql, function (err, row) {
                db.close();
            })
        });
    }

    function getHistoryClass(openId, callback) {
        var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
        var sql = "select * from class where openId='" + openId + "'";
        db.all(sql, function (err, rows) {
            db.close();
            if (!err && rows.length != 0) {
                _classInfo.find("option[classId='" + rows[0].classId + "']").attr("selected", true);
                var firstOption = _classInfo.find('option:selected');
                _classInfo.attr('title',firstOption.attr('grade')+firstOption.attr('attrName'));
            }
        })
    }

    function chkStatus(callback) {
        var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
        var sql = "select * from current ";
        _btn.afterClass.attr('time', _formatTimeStamp(Date.parse(new Date)));
        db.all(sql, function (err, row) {
            db.close();
            if (!err) {
                if (row.length == 0) {
                    createKtsl();

                } else {
                    updateIfbStatus(1);
                }


            } else {
                console.log("数据库查询失败");
            }
        });


    }


    /**
     * IFB 创建课堂实录
     */
    function createKtsl() {
        getUserInfo(function (userInfo) {
            var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
            var id = _getRandomString(32);
            var time = _formatTimeStamp(Date.parse(new Date()));
            var sql = "insert into current values('" +
                id + "','" + userInfo._sso_openId + "','1'," + null + ",'" + time + "')";
            console.log(sql);
            db.exec(sql, function (err) {
                db.close();
            });
        });


    }

    function updateIfbStatus(status, callback) {
        getUserInfo(function (userInfo) {
            var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
            var sql = "update current set ifbStatus=" + status + " where openId='" + userInfo._sso_openId + "'";
            console.log(sql);
            db.exec(sql, function (err) {
                db.close();
                callback && callback();
            });
        });
    }


    function FormatClassInfo(_userInfo, data) {
        var orgClass = [], freeClass = [];
        var classList = data.extInfo.orgClass || [], freeClassList = data.extInfo.freeClass || [];
        for (var i = 0, count = classList.length; i < count; i++) {
            var item = classList[i];
            var rs = {
                "classCode": item.classShortId || "",
                "classShortId": item && item.classShortId || "",
                "classId": item.id || "",
                "className": item.className || "",
                "shortName": item.shortName || "",
                "eduSystem": item.eduSystem || "",
                "classLabel": item.classLabel || "",
                "classOrder": item.classOrder || "",
                "passed": item.passed || "",
                "createTime": "undefined",
                "phase": item.phase || "",
                "schoolId": item.schoolId || "",
                "schoolName": "undefined",
                "studentCount": "undefined",
                "subject": "undefined",
                "subjectName": "undefined",
                "year": item.year || "",
                "extInfo": item.extInfo || ""
            };
            orgClass.push(rs);
        }
        //这里对自由班级做格式化处理，是为了在后期班级合并展示时避免兼容性问题
        for (var i = 0, count = freeClassList.length; i < count; i++) {
            var item = freeClassList[i];
            var rs = {
                "classCode": item.classShortId || "undefined",
                "classShortId": item.classShortId || "",
                "classId": item.id || "",
                "className": item.className || "",
                "shortName": "undefined",
                "eduSystem": "undefined",
                "classLabel": "undefined",
                "classOrder": "undefined",
                "passed": "undefined",
                "createTime": "undefined",
                "grade": item.grade || "",
                "phase": item.phase || "",
                "schoolId": item.schoolId || "",
                "schoolName": "undefined",
                "studentCount": "undefined",
                "subject": "undefined",
                "subjectName": "undefined",
                "year": item.year || "",
                "extInfo": item.extInfo || ""
            };
            freeClass.push(rs);
        }
        _userInfo.classInfo = orgClass;
        _userInfo.freeClass = freeClass;
        userInfo = _userInfo;
        return userInfo;

    }

    function getClassInfo(callback) {
        getUserInfo(function (userInfo) {
            var p = {
                userId: userInfo._user_openId,
                openId: userInfo._sso_openId
            };
            edcService.Instance().core_user_org_detail(p).done(function (ret) {
                if (ret && ret.code == 0) {
                    callback && callback(FormatClassInfo(userInfo, ret.data));
                } else {
                    callback && callback(userInfo);
                }

            }).fail(function () {
                callback && callback(userInfo);
            });
        });
    }

    /**
     * 获取用户信息
     * @param callback 回调
     */
    function getUserInfo(callback) {
        if (userInfo) callback(userInfo);
        else {
            shellcmd.readFileAsync(uliDat).done(function (ret) {
                userInfo = JSON.parse(ret);
                callback(userInfo);
            })
        }
    }

    /**
     * 生成随机长度的字符串
     * @param len 生成的长度 可选 未传则生成32的
     * @private
     */
    function _getRandomString(len) {
        var len = len || 32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    }


    function onReceiveMessage() {

    }

    /**
     * 开始创建课堂实录的节点
     * @param _data
     */
    function createElementFile(_data) {
        var filePath = _data.filePath.replace(/\\/g, '/');
        console.log('%c收到快照的消息，其地址为：' + filePath, 'color:blue');

        var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
        var sql = "select * from current ";
        db.all(sql, function (err, row) {
            db.close();
            if (row.length) {
                var time = _formatTimeStamp(Date.parse(new Date()));
                var id = _getRandomString();
                db = new sqlite3.Database(ifbDbPath.replace('file:///', ''));
                var dstpath = ktslDir + row[0].id + "/" + filePath.substr(filePath.lastIndexOf('/') + 1).replace('快照','snapshot');
                var dstDir = ktslDir + row[0].id;
                fs.exists(dstDir, function (exist) {
                    if (!exist) {
                        fs.mkdirSync(dstDir);
                    }
                    sql = "insert into files values('" + id + "','" + row[0].id + "','" + dstpath + "','" + time + "')";
                    // shellcmd.copyFile(filePath, dstpath).done(function () {
                    //     db.exec(sql, function (err) {
                    //         db.close();
                    //         toggleSnapshot(false);
                    //         checkSnapshot();
                    //     });
                    // });
                    gm_ta(filePath,GMPath_E).write(dstpath,function (err) {
                            db.exec(sql, function (err) {
                                db.close();
                                toggleSnapshot(false);
                                checkSnapshot();
                            });
                    });
                });


            }else {
                toggleSnapshot(false);
            }
        });

    }


    function choiceClassShow(existClass) {

        var time = (new Date()).Format("yyyy-MM-dd hh:mm");
        var name = '课堂实录 ' + time;
        _name.val(name);
        _domRecord.show();
    }

    function checkZips(ktId,callback) {
        var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
        var sql = "select * from zips where ktId='"+ktId +"'";
        db.all(sql,function (err,rows) {
            db.close();
            if(err||rows.length<1){
                var db2 = new sqlite3.Database(ifbDbPath.replace('file:///', ''));
                var sql2 = "select * from files  where ktId='" + ktId + "' order by time asc";
                db2.all(sql2,function (err,rows) {
                    db2.close();
                    if(err||rows.length<1){
                        callback&&callback(false);
                    }else {
                        callback&&callback(true);
                    }
                });

            }else {
                callback&&callback(true);
            }
        })
    }

    function toggleSnapshot(o) {
        snapshoting = o;
    }

    function checkSnapshot() {
        snapAfter&&afterOrLeave(snapAfter);
    }

    function afterOrLeaveHanle(leave) {
        leave&&leave();
        // if(!snapshoting){
        //     afterOrLeave(leave);
        // }else {
        //     snapAfter = leave;
        // }
    }
    /**
     * 下课或离开上课的时的处理与检测
     * @param callback
     */
    function afterOrLeave(leave) {
        snapAfter = null;
        var db = new sqlite3.Database(ktslDbPath.replace('file:///', ''));
        var sql = "select * from current ";
        db.all(sql, function (err, row) {
            db.close();
            if (!err && row.length != 0 && row[0].ifbStatus == 1) {
                if (row[0].ifsStatus != 1) {
                    checkZips(row[0].id,function (exist) {
                        if(exist){

                            getLessonInfo(choiceClassShow);
                        }else {
                            updateIfbStatus(0,function () {
                                cancelKtsl();
                                leave&&leave();
                            });
                        }
                    });
                } else {
                    updateIfbStatus(0);
                    ktslZip(row[0].id).done(function (exist, src) {
                        if (exist) {
                            var obj = {
                                type: 'logic',
                                action: 'TA_ktsl',
                                from: 'ib',
                                to: 'main',
                                id: _getRandomString(),
                                data: {
                                    class: 'zip',
                                    src: src,
                                    isDelete: 1
                                }
                            };
                            socket.send(obj);
                        }

                        leave && leave();
                    });
                }


            } else {

                leave && leave();
            }
        });

    }

    function ktslZip(ktId) {
        var def = $.Deferred();
        var db = new sqlite3.Database(ifbDbPath.replace('file:///', ''));
        var sql = "select * from files  where ktId='" + ktId + "' order by time asc";
        var info = [];

        db.all(sql, function (err, row) {
            if (err || row.length == 0) {
                db.close();
                def.resolve(false, null);
            } else {
                // 形成locus.dat
                var startTime = _btn.afterClass.attr('time');
                info.push({tp: "iflybook_start_lesson", ct: startTime, t: 0});
                for (var i = 0, l = row.length; i < l; i++) {
                    info.push({
                        tp: "iflybook_book_analysis",//iflybook_book_analysis iflybook_snapshot
                        ct: row[i].time,
                        src: row[i].filepath.substr(row[i].filepath.lastIndexOf('/') + 1),
                        t: Date.parse(row[i].time) - Date.parse(startTime)
                    })
                }
                var endTime = Date.parse(new Date());
                info.push({
                    tp: "iflybook_stop_lesson",
                    ct: _formatTimeStamp(endTime),
                    t: endTime - Date.parse(startTime)
                });
                fs.writeFileSync(ktslDir + ktId + '/locus.dat', JSON.stringify(info));
                //删除数据库的值
                sql = "delete from files where ktId='" + ktId + "'";
                db.exec(sql, function (err) {
                    db.close();
                });

                shellcmd.zip(ktslDir + ktId, ktslDir + ktId + ".zip").done(function (success) {
                    shellcmd._rmdirASync(ktslDir + ktId);
                    if (success) {
                        def.resolve(true, ktslDir + ktId + ".zip");
                    } else {
                        def.resolve(false, null);
                    }
                });

            }

        });
        return def.promise();
    }

    function formatClassShow(str) {
        return str.length>16?str.substr(0,15)+'...':str;
    }

    /**
     * 请求班级接口，将结果显示在课堂实录弹框中
     * @param callback
     */

    function getLessonInfo(callback) {
        getClassInfo(function (userInfo) {
            var optionTemplate = '<option grade = "{{attrGrade}}" attrName="{{attrClassName}}" isFree="{{Free}}" classId="{{classId}}">{{className}}</option>';
            var optionStr = '';
            var orgClass = null, freeClass = null, curPhase;
            var className, startYear, curDate;
            var phaseIndex = 0;
            curDate = new Date();
            var curYear, curMonth, curDay;

            curYear = curDate.getFullYear();//当前年
            curMonth = curDate.getMonth() + 1;//当前月
            curDay = curDate.getDate();//当前天
            orgClass = userInfo.classInfo;//获取行政班级信息
            freeClass = userInfo.freeClass;//获取自由班级信息
            var classInfoTemp = orgClass, classInfo = [];

            // var classInfoTemp = $.merge(orgClass, freeClass), classInfo = [];
            if (classInfoTemp.length) {
                classInfo[0] = classInfoTemp[0];
                classInfo[0].isFree = false;
            } //班级列表有可能为空
            for (var k = 1, l = classInfoTemp.length; k < l; k++) {
                //--------去除自由班级--------------
                classInfo[k] = classInfoTemp[k];
                classInfo[k].isFree = false;
                //--------------------------------
                // var flag = true;
                // for (var j = 0, ll = classInfo.length; j < ll; j++)
                //     if (classInfo[j].classId == classInfoTemp[k].classId) {
                //         flag = false;
                //         break;
                //     }
                // if (flag) {
                //     if (classInfoTemp[k].phase == "") {
                //         classInfoTemp[k].isFree = true;
                //     } else {
                //         classInfoTemp[k].isFree = false;
                //     }
                //     classInfo[classInfo.length] = classInfoTemp[k];
                // }

            }
            for (var i = 0; i < classInfo.length; i++) {
                var attrGrade = "", attrClassName = "";
                curPhase = classInfo[i].phase;//当前学段
                startYear = classInfo[i].year;
                if (curPhase == "" || curPhase == null || curPhase == undefined) {
                    attrGrade = startYear + "级";
                } else {
                    var gradeIdx = curYear - startYear;
                    switch (curPhase) {//找到当前学段号对应的学段
                        case '01':
                            phaseIndex = 0;
                            break;
                        case '02':
                            phaseIndex = 1;
                            break;
                        case '03':
                            phaseIndex = 2;
                            break;
                        case '04':
                            phaseIndex = 3;
                            break;
                        case '05':
                            phaseIndex = 4;
                            break;
                    }

                    if ((curMonth > 8 && curDay >= 15) || curMonth > 9) {
                        if (gradeIdx >= 1) {
                            if (gradeIdx < phaseToGrade[phaseIndex].grade.length) {
                                gradeIdx++;//超过九月中旬的了  加一年级

                            } else if (gradeIdx == phaseToGrade[phaseIndex].grade.length) {
                                gradeIdx = 1;
                                phaseIndex++;
                            } else {
                                gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                                phaseIndex++;
                            }
                            attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                        } else {
                            attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                        }
                    } else {
                        if (gradeIdx >= 1) {
                            if (gradeIdx > phaseToGrade[phaseIndex].grade.length) {
                                gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                                phaseIndex++;
                            }
                            attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                        } else {
                            attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                        }

                    }

                }


                attrClassName = classInfo[i].className;
                className = attrGrade + attrClassName;
                var tpmStr = optionTemplate.replace('{{className}}', formatClassShow(className)).replace('{{attrClassName}}', attrClassName)
                    .replace('{{attrGrade}}', attrGrade).replace('{{Free}}', classInfo[i].isFree).replace('{{classId}}', classInfo[i].classId);
                optionStr += tpmStr;
            }
            _classInfo.find('option').remove();
            _classInfo.append(optionStr);
            var firstOption = _classInfo.find('option:first');
            _classInfo.attr('title',firstOption.attr('grade')+firstOption.attr('attrName'));
            getHistoryClass(userInfo._sso_openId);
            if (optionStr == "") {
                _classInfo_no.show();
                _classInfo.hide();
                _relation.hide();
                _personal.show();
                callback && callback(false);
            } else {
                _classInfo_no.hide();
                _classInfo.show();
                _relation.hide();
                _personal.show();
                callback && callback(true);
            }


        });


    }


    /**
     * 检测所传对象的是否存在空值得情况
     * @returns {boolean}
     * @private
     */
    function _checkBlankTextTip(arr, count) {
        var pass = true;
        arr.forEach(function (item) {
            var v = $.trim(item.val());
            if (v == '' || v == null) {
                pass = false;
                loop(item, count);

            }
        });

        function loop(item, c) {

            if (c > 0) {
                var _that = arguments.callee;
                setTimeout(function () {
                    item.css('border-color', 'deeppink');
                    setTimeout(function () {
                        item.css('border-color', '');
                        _that(item, --c)
                    }, 400);
                }, 400);
            }
        }

        return pass;
    }


    /**
     * 格式化时间戳
     * @param timestamp
     * @private
     */
    function _formatTimeStamp(timestamp) {
        if (typeof timestamp == "string") timestamp = parseInt(timestamp);
        return (new Date(timestamp)).Format("yyyy-MM-dd hh:mm:ss");

    }

    /**
     * 保存或者取消后回复原有的状态
     */
    function backToExit(endStyle) {
        switch (endStyle) {
            case '1':
                //返回书架
                // returnBookShelf();
                $('#btnBookShelf').trigger("click");
                break;
            case '2':
            //退出IFB
            case '3':
                $('#btnExitApp').trigger("click");
                break;
            case '4':
                _btn.afterClass.trigger('click');
                break;
        }
    }

    exports.createKtsl = createKtsl;
    exports.chkStatus = chkStatus;
    exports.createElementFile = createElementFile;
    exports.afterOrLeave = afterOrLeaveHanle;
    exports.onReceiveMessage = onReceiveMessage;
    exports.toggleSnapshot = toggleSnapshot;
});

