/**
 * User: yuwang@iflytek.com
 * Date: 13-7-20 下午4:50
 * Version: 1.0
 */

define(function (require, exports) {
    require('jquery');
    var _define = require('../../define');
    var shellcmd = require('../../../common/shellcmd');
    var ibWSLogic = require("../../../ibWSLogic");
    var canvasMgr = require("../../paint/canvasmgr").Instance;
    var ebookContext = require('../../ebookcontext').Instance;
    var pluginsMgr = require('../../plugins/pluginsmgr').Instance;
    /**
     * @type {BookContainer}
     */
    var _bookContainer, toolBoxMgr, cardTemplateManager, resLibManager, searchManager;
    var _btns;
    var pagePreView = require('../preview/pagepreview').Instance;
    var pagePreViewIcon = require('../preview/pagepreviewicon').Instance;
    var WBpreView = require('../preview/whiteboardpreview').Instance;
    var importRes = require("../importexport/importmtbk").Instance;
    var webMtbkRes = require('../importexport/webMtbkImport');
    var _ktsl = require('../toolbar/ktsl');
    var _pptIcwsAccessor = require('../resbar/ppticwsaccessor').Instance;
    //   var plugin_window = require("./plugin_window").Instance;

    /**
     * Caution : 这个 require 放在click函数里面和c这里，作用还不一样。
     * 表现 : exportRes 这个对象里面的pageProVider会变，导致bookMenu取不到
     *              -------   by yczhu
     */
    var exportRes = require("../importexport/exportmtbk").Instance;

    var openaction = true;
    var _isEditing = true;
    /**
     * 为了能够在全局使用在这个参数，已经放在了browserContext.js中，
     * changed by linwang5@iflytek.com 2016-09-20 13:56
     * @type {boolean}
     */
    // var _isHavingClass = false;
    var isTeachingPackage = false;
    var classInfo = [];
    var timeStampArr = [];
    //便签num
    var notenum = 0;


    app_global_isMainToolBarUp = ((!sessionStorage['isMainToolBarUp']) || sessionStorage['isMainToolBarUp'] == 'undefined' || sessionStorage['isMainToolBarUp'] !== 'false') ? true : false;

    //编辑和备课状态下工具栏的宽度
    var constrants = {
        EDIT_WIDTH: 0,
        NO_EDIT_WIDTH: 0
    };
    var mainToolbarScale; //主工具栏放缩比

    /**
     * @param btns {{
     *     btnToggleHotspot: jQuery
     *     btnTogglePlay: jQuery
     * }}
     * @param bookContainer {BookContainer}
     */
    function init(btns, bookContainer, pageIndex, bookCode) {
        _bookContainer = bookContainer;
        _btns = btns;
        _bindCommands();
        !app_global_isMainToolBarUp && setMainToolBarPosition(app_global_isMainToolBarUp);

        //初始化工具箱
        initToolBox(_bookContainer);
        //初始化模板
        initTemplate(_bookContainer);
        //初始化幕布
        initCurtain(_bookContainer);
        //初始化页面预览
        /**
         * 如果为pdf，则第一次打开的时候获取不到pageIndex 无法初始化按钮的点击事件，此时默认是1
         * added by linwang5@iflytek.com 2016-12-28
         */
        // if(bookCode.indexOf('pdf_')==0&&!pageIndex) pageIndex = 1;
        (pageIndex || (bookCode.indexOf('pdf_') == 0 && !pageIndex)) && bookCode && initPagePreView(_bookContainer, pageIndex, bookCode);
        initWBView(_bookContainer);
        initPagePreViewIcon();
        setIsEditing(false);
    }

    function _bindCommands() {
        var toggleHotspotImg = _btns.btnToggleHotspot.find('img');
        var isShowAllHotspots = false;
        _btns.btnToggleHotspot.click(function (e, isShow) {

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130212';
            var user_id = ebookContext.getUser().getUid();
            if (user_id != '0' && user_id) {
                params.user_id = user_id;
            }
            LogManager.statistics(action, params);

            if (isShow != undefined) isShowAllHotspots = isShow;
            if (isShowAllHotspots) {
                isShowAllHotspots = false;
                toggleHotspotImg.attr('src', 'assert/images/tool_xsrq.png');
                _bookContainer.hideAllHotspots();
            } else {
                isShowAllHotspots = true;
                toggleHotspotImg.attr('src', 'assert/images/tool_qxrq.png');
                _bookContainer.showAllHotspots();
            }
            e.stopPropagation();
        });

        _btns.btnTogglePlay.click(function (event) {
            var state = _btns.btnTogglePlay.attr('state');
            if (state === 'playing') {
                app_global_playerMgr.pause();
            } else if (state === 'stop') {
                if (AppCfg.isBBT && app_global_playerMgr._currPlayer.PlayerType == _define.PlayerType.HotspotPlayer) {
                    ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.MAINTOOLBAR);
                    var json = {
                        to: "tray",
                        action: "watchdog_exist"
                    };
                    socket.send(json);
                } else {
                    app_global_playerMgr.resume();
                }
            }
            event.stopPropagation();
        });

        _btns.btnMoveMenuBar.click(function () {
            setMainToolBarPosition(!app_global_isMainToolBarUp);
            $("#pluginpanel").hide();
            $("#blackBoardEvalControl").hide();
            $("#blackBoardStrokeAndDicControl").hide();
            event.stopPropagation();

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130616';
            var user_id = ebookContext.getUser().getUid();
            if (user_id != '0' && user_id) {
                params.user_id = user_id;
            }
            LogManager.statistics(action, params);
        });
        _btns.btnHavingClass.click(function () {
            changeClassStatus(true);
            //_ktsl.chkStatus();
            //大数据监管
            var obj = {
                type: 'logic',
                action: 'statistics',
                to: 'tray',
                data: {
                    userId: ebookContext.getUser().getUid(),
                    event: '16011006',
                    objectId: '',
                    objectType: '',
                    moduleId: '16011003',
                    extensions: '',
                    inputData: ''
                }
            };
            socket && socket.send(obj);
            /* $(".user-popover").hide();
             $(".jxbubble-box").hide();//上课状态的资源弹框隐藏
             _bookContainer.setIsEditing(false);
             canvasMgr.setIsEditing(false);
             setIsHavingClass(true);
             setIsEditingNew(false);
             setIsTeachingPackage(false);
             // ebookContext.setIsPenUse(false);//刚上课时画笔设置为未使用
             $(document).trigger("classMode",{"classMode":"havingClass"});
             $("#btnMouse").trigger("click");*/

            //上课时发消息给iflyslide
            /*  var json = {
                  type: "logic",
                  action: "lesson",
                  from: "ib",
                  to: "all",
                  data: {
                      motion: "start"
                  }
              };
              socket.send(json);*/
        });

        _btns.btnAfterClass.click(function () {
            $('#lessonRecord').attr('endStyle', 4);
            _ktsl.afterOrLeave(function (need) {
                changeClassStatus(false);
                app_global_playerMgr && app_global_playerMgr.pause(); //暂停音频资源播放
            });
            //大数据监管
            var obj = {
                type: 'logic',
                action: 'statistics',
                to: 'tray',
                data: {
                    userId: ebookContext.getUser().getUid(),
                    event: '16011011',
                    objectId: '',
                    objectType: '',
                    moduleId: '16011002',
                    extensions: '',
                    inputData: ''
                }
            };
            socket && socket.send(obj);

            // 清除选中的热区显示
            _bookContainer.renderSelectedHotspot();
            /*getLessonInfo();
            ebookContext.EndClassStyle = 4;*/
            /* $(".user-popover").hide();
             $(".jxbubble-box").hide();//上课状态的资源弹框隐藏
             _bookContainer.setIsEditing(true); //2016.09.01，下面两个isEditing方法是把resbar文件里的上课点击事件迁过来
             canvasMgr.setIsEditing(true);
             setIsEditingNew(true);
             setIsTeachingPackage(false);
             setIsHavingClass(false);
             $(document).trigger("classMode",{"classMode":"afterClass"});
             $("#btnMouse").trigger("click");*/

            /*
             下面这段代码用于课堂实录，现在回滚，以后可能用到
             var usePen = ebookContext.getIsPenUse();
             if (usePen == true) {//如果有笔迹，则后台调用快照截图
             pluginsMgr.openSnapshot(true);
             }
             ebookContext.setIsPenUse(false);//下课时画笔设置为未使用
            setTimeout(function(){//快照截屏结束后才显示下课课堂实录
                var panel = $(document).find("#lessonRecord");
                var xpos = ($(window).width() - panel.outerWidth()) / 2;
                panel.css({  //设置位置
                    position: 'absolute',
                    left: xpos,
                    top: 150,
                }).draggable({               //设置可拖动
                    containment: $("#bookcontainer"),
                    handle: ".jxpop-tab"
                });
                $(panel).show();//显示保存课堂实录提示
            },50)*/


        });

        var phaseToGrade = [{
                "phase": "01",
                "grade": [{
                        "code": "14",
                        "name": "幼儿园小班"
                    },
                    {
                        "code": "15",
                        "name": "幼儿园中班"
                    },
                    {
                        "code": "16",
                        "name": "幼儿园大班"
                    },
                ]
            },
            {
                "phase": "02",
                "grade": [{
                    "code": "17",
                    "name": "学前班"
                }]
            },
            {
                "phase": "03",
                "grade": [{
                        "code": "01",
                        "name": "一年级"
                    },
                    {
                        "code": "02",
                        "name": "二年级"
                    },
                    {
                        "code": "03",
                        "name": "三年级"
                    },
                    {
                        "code": "04",
                        "name": "四年级"
                    },
                    {
                        "code": "05",
                        "name": "五年级"
                    },
                    {
                        "code": "06",
                        "name": "六年级"
                    },
                ]
            },
            {
                "phase": "04",
                "grade": [{
                        "code": "07",
                        "name": "七年级"
                    },
                    {
                        "code": "08",
                        "name": "八年级"
                    },
                    {
                        "code": "09",
                        "name": "九年级"
                    },
                ]
            },
            {
                "phase": "05",
                "grade": [{
                        "code": "10",
                        "name": "高一"
                    },
                    {
                        "code": "11",
                        "name": "高二"
                    },
                    {
                        "code": "12",
                        "name": "高三"
                    },
                ]
            },
        ];

        //获取班级信息
        function getLessonInfo() {
            //请求班级接口，将结果显示在课堂实录弹框中
            var param_core_user_get = {
                "key": "id",
                "value": ebookContext.getUser().getUid()
            }
            var optionTemplate = '<option>{{className}}</option>';
            var optionStr = '';
            //获取用户openId
            edcService.Instance().core_user_get(param_core_user_get).done(function (ret) {
                console.log(ret);
                if (ret.code == 0) {
                    var openId = ret.data.id;
                    var param_core_user_detail = {
                        "userId": openId, //ebookContext.getUser().getUid(),
                        "openId": openId
                    }
                    //获取用户班级信息
                    edcService.Instance().core_user_org_detail(param_core_user_detail).done(function (ret1) {
                        console.log(ret1); //
                        //获取学段
                        var orgClass, freeClass, curPhase;
                        var className, startYear, curDate;
                        var phaseIndex = 0;
                        var curDate = new Date();
                        var curYear, curMonth, curDay;

                        curYear = curDate.getFullYear(); //当前年
                        curMonth = curDate.getMonth() + 1; //当前月
                        curDay = curDate.getDate(); //当前天

                        if (ret1.code == 0) {
                            orgClass = ret1.data.extInfo.orgClass; //获取行政班级信息
                            freeClass = ret1.data.extInfo.freeClass; //获取自由班级信息
                            classInfo = $.merge(orgClass, freeClass);
                            for (var i = 0; i < classInfo.length; i++) {
                                curPhase = classInfo[i].phase; //当前学段
                                startYear = classInfo[i].year;
                                var gradeIdx = curYear - startYear;
                                switch (curPhase) { //找到当前学段号对应的学段
                                    case '01':
                                        phaseIndex = 0;
                                        break;
                                    case '02':
                                        phaseIndex = 1;
                                        break;
                                    case '03':
                                        phaseIndex = 2;
                                        break;
                                    case '04':
                                        phaseIndex = 3;
                                        break;
                                    case '05':
                                        phaseIndex = 4;
                                        break;
                                }
                                if (gradeIdx >= 1 && curMonth > 8 && curDay >= 15) {
                                    if (gradeIdx < phaseToGrade[phaseIndex].grade.length) {
                                        gradeIdx++;
                                    } else {}
                                }
                                className = phaseToGrade[phaseIndex].grade[gradeIdx].name + classInfo[i].className;
                                var tpmStr = optionTemplate.replace('{{className}}', className);


                                /*var param = {
                                    eduSystem: classInfo[i].phase
                                }
                                edcService.Instance().core.common.dic.get().done(function (ret) {
                                    className = classInfo[i].className + ret.data;
                                    startDate = classInfo[i].year;
                                    var tpmStr = optionTemplate.replace('{{className}}', className);
                                }).fail(function () {
                                    console.log("学段信息获取失败");
                                })*/

                                optionStr += tpmStr;
                            }
                            $("#classId").append(optionStr);
                        }
                    }).fail(function (e) {

                    })
                }

            }).fail(function (e) {
                console.log(e);
            });
        }

        function isSaveClassRecord(state) {

            var lessonName = $("#recordName").val(); //课堂实录名称
            var classId = "";
            if (lessonName == "") {
                $("#errorMsg").show();
                alert("请输入名称");
            } else {
                $("#lessonRecord").hide();

                var className = $("#classId").val();
                var classNames = $("#classId option");
                for (var i = 0; i < classNames.length; i++) {
                    if ($(classNames[i]).text() == className)
                        classId = classInfo[i].id;
                    break;
                }
                var description = $("#description").val() || "";
                $("#errorMsg").hide();
                var json = {
                    type: "logic",
                    action: "lesson",
                    from: "ib",
                    to: "all",
                    data: {
                        motion: "stop",
                        message: {
                            is_save: state,
                            name: lessonName,
                            class_id: classId,
                            desc: description
                        }
                    }
                };
                socket.send(json);
                $("#classId").children("option").remove();


                /*var usePen = ebookContext.getIsPenUse();
                if (usePen == true) {//如果有笔迹，则后台调用快照截图
                    pluginsMgr.openSnapshot(true);
                }
                ebookContext.setIsPenUse(false);//下课时画笔设置为未使用*/
                changeClassStatus(false); //确定保存课堂实录后才show下课界面
                var endStyle = ebookContext.EndClassStyle;
                switch (endStyle) {
                    case 1:
                        //返回书架
                        // returnBookShelf();
                        $(document).trigger("gotoBookshelf");
                        break;
                    case 2:
                        //退出IFB
                        $(document).trigger("ExitBook");
                        break;
                    case 3:
                        $(document).trigger("ExitBook");
                        break;
                    case 4:
                        //点击下课按钮
                        break;
                }
            }

        }


        //进入授课包
        _btns.btnTeachingPackage.click(function (event) {
            setIsEditingNew(true);
            setIsTeachingPackage(true);
            _btns.btnTeachingPackage.hide();
            _btns.btnResCenter.show();
            $(".J_resource_center_bar").hide();
            $(".J_teaching_package_bar").show();
            event.stopPropagation();
            //大数据监管
            if (!app_global_statics) { //如果是界面初始化时候的trigger则不处理，连接socket以后再发送
                var obj = {
                    type: 'logic',
                    action: 'statistics',
                    to: 'tray',
                    data: {
                        userId: ebookContext._curUser._uid,
                        event: '16011005',
                        objectId: '',
                        objectType: '',
                        moduleId: '16011002',
                        extensions: '',
                        inputData: ''
                    }
                };
                socket && socket.send(obj);
            }

        });
        //进入资源中心，编辑状态
        _btns.btnResCenter.click(function () {
            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            _btns.btnResCenter.hide();
            setIsEditingNew(true);
            setIsTeachingPackage(false);
            //更新授课包展示数目
            $(document).trigger("refreshTeachingPackageNum");
            _btns.btnTeachingPackage.show();
            $(".J_teaching_package_bar").hide();
            $(".J_resource_center_bar").show();
            event.stopPropagation();
            //大数据监管
            var obj = {
                type: 'logic',
                action: 'statistics',
                to: 'tray',
                data: {
                    userId: ebookContext._curUser._uid,
                    event: '16011004',
                    objectId: '',
                    objectType: '',
                    moduleId: '16011002',
                    extensions: '',
                    inputData: ''
                }
            };
            socket && socket.send(obj);
        });

        _btns.mainToolBar.find("button").on("mousedown", function () {
            $(this).addClass("tool_current");
        });

        _btns.mainToolBar.find("button").on("mouseup", function () {
            $(this).removeClass("tool_current");
        });

        /**
         * 清空资源
         */
        var btnClearResContent = _getClearResContent();

        //翻译
        LAN.translateObj(btnClearResContent);

        _btns.btnClearRes.click(function () {
            var $this = $(this);
            if (!$this.popover('isShow', 'title'))
                $this.popover({
                    content: btnClearResContent,
                    userDefinePopover: true,
                    popoverId: 'title'
                }).popover('show', 'title', {
                    position: app_global_isMainToolBarUp ? 'bottom' : 'top'
                }); // userDefinePopover 自定义字段
            else $this.popover('hide', 'title');

            btnClearResContent.find(app_global_isMainToolBarUp ? ".bot_arrow" : ".top_arrow").hide().siblings().show();
            var scale = correctToBaseResolution(btnClearResContent, {
                scaleFromCenter: false
            });
            if (mainToolbarScale) //修正
            {
                scale[4] += (1 - mainToolbarScale[0]) * $(this).outerWidth();
                scale[5] = app_global_isMainToolBarUp ? scale[5] - (1 - mainToolbarScale[3]) * $(this).outerHeight() : scale[5] + (1 - mainToolbarScale[3]) * $(this).outerHeight();
                btnClearResContent.css('-webkit-transform', 'matrix(' + scale.join(',') + ')');
            }
            event.stopPropagation();
        });

        app_global_playerMgr.on('play', function (event, playerType) {
            if (playerType === _define.PlayerType.HotspotPlayer || playerType === _define.PlayerType.AudioPlayer)
                _changeStateToPlay(true);
        });

        app_global_playerMgr.on('pause', function (event, playerType) {
            if (playerType === _define.PlayerType.HotspotPlayer || playerType === _define.PlayerType.AudioPlayer)
                _changeStateToPlay(false);
        });

        app_global_playerMgr.on('ended', function (event, playerType) {
            if (playerType === _define.PlayerType.HotspotPlayer || playerType === _define.PlayerType.AudioPlayer)
                _changeStateToPlay(false);
        });

        //$("#btnNote, #smartbar_btnNote").click(function () {
        $(document).on('click', '#btnNote, #smartbar_btnNote', function () {
            //获取便签名称  以前的命名规则是，每次新打开书本都会从1开始加，便签1,2,3,4，这样会有重名问题，新逻辑是：原有便签1,2,4，新建便签叫做
            // 便签3 ，再新建便签名称是 便签5 这样避免了重名问题.---by kaiyi 2017-3-20
            var getNoteName = function () {
                var deff = $.Deferred();
                //查询该课所有便签名称
                _bookContainer.getCurrentLessonRes().done(function (widgetList) {
                    var existNoteNameList = []; //已有的便签名称
                    for (var i = 0; i < widgetList.length; i++) {
                        if (widgetList[i].WidgetType == 'note') {
                            existNoteNameList.push(widgetList[i].File)
                        }
                    }
                    //递归方法获取便签名称
                    var getNewNoteNamePostfix = function (NoteName, existNoteName, currentNum, callback) {
                        var _NoteName = NoteName;
                        if ($.inArray(_NoteName, existNoteName) != -1) { //存在文件
                            currentNum++;
                            _NoteName = AppNoteTips.note + (currentNum) + ".note"
                            getNewNoteNamePostfix(_NoteName, existNoteName, currentNum, callback)
                        } else {
                            callback && callback(_NoteName)
                        }
                    }
                    getNewNoteNamePostfix(AppNoteTips.note + "1.note", existNoteNameList, 1, function (ret) {
                        deff.resolve(ret);
                    });
                }).fail(function (err) { //一般不会走到这里，如果走到这里，好歹给人家一个名字，哪怕是重名的
                    deff.resolve(AppNoteTips.note + (++notenum) + ".note")
                })
                return deff.promise();
            };

            var uuid = _pptIcwsAccessor.createUuid();
            var timestamp = new Date().valueOf();
            //获取便签名称，然后创建便签
            getNoteName().done(function (fileName) {
                //由于资源存储方式变更，修改为先创建note by njfu
                // var fileName = AppNoteTips.note + (++notenum) + ".note";
                var file = process.env.TEMP.replace(/\\/g, "/") + "/" + fileName;
                shellcmd.saveFile("", file);
                var fileInfo = {
                    fileName: fileName,
                    fileSize: "",
                    lasttime: new Date().Format("yyyy-MM-dd hh:mm:ss"),
                    timestamp: timestamp,
                    fileid: uuid,
                    fileExt: "note"
                }
                _bookContainer.insertSingleWidget(file, _define.WidgetType.Note, "", {
                    resourceId: uuid,
                    timestamp: timestamp,
                    insertToTA: true,
                    fileInfo: fileInfo,
                    userName: ebookContext.getUser()._userName
                });

                if (this.id != 'smartbar_btnNote') {
                    event.stopPropagation();
                } else {
                    //temp eshop监管 linwang5@iflytek.com
                    var staticParams = {
                        uid: ebookContext._curUser._uid,
                        module: '02001',
                        type: 'trigger',
                        cardId: this.id
                    };
                    edcService.Instance().api_eshop_baseStatics(staticParams);
                };
                //关闭添加资源弹窗
                $("#closeAddSource").trigger("click");
            })

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130311';
            var user_id = ebookContext.getUser().getUid();
            if (user_id != '0' && user_id) {
                params.user_id = user_id;
            }
            LogManager.statistics(action, params);
        });

        var getCatalogInfo = function (pageMeta) {
            var unitname = pageMeta.unit4Name ? pageMeta.unit4Name :
                pageMeta.unit3Name ? pageMeta.unit3Name :
                pageMeta.unit2Name ? pageMeta.unit2Name :
                pageMeta.unit1Name ? pageMeta.unit1Name : "";
            var unit = pageMeta.unit4 ? pageMeta.unit4 :
                pageMeta.unit3 ? pageMeta.unit3 :
                pageMeta.unit2 ? pageMeta.unit2 :
                pageMeta.unit1 ? pageMeta.unit1 : "";
            return {
                "code": unit,
                "name": unitname
            };
        }
        //请求接口获取学科
        var getSubjectName = function (access_token, subjectCode) {
            var deffer = $.Deferred();
            if (!subjectCode) { //如果没有subject
                deffer.reject();
            } else {
                if (app_global_subjectList.length > 0) {
                    deffer.resolve(app_global_subjectList.filter(
                        function (el) {
                            return el.code == subjectCode;
                        })[0].name);
                } else {
                    var url = Easy_Cfg.EASYSVC + "api?method=ersp.resource.metadata.subject.list&appkey=" + Easy_Cfg.APPKEY +
                        "&format=json&version=1.0&access_token=" + access_token;
                    $.ajax(url).done(function (data) {
                        if (data && data.data && data.data.data instanceof Array) {
                            app_global_subjectList = data.data.data;
                            deffer.resolve(app_global_subjectList.filter(function (el) {
                                return el.code == subjectCode
                            })[0].name);
                        } else {
                            deffer.resolve("");
                        }

                    }).fail(function (err) {
                        console.log(err);
                        deffer.resolve("");
                    })
                }
            }
            return deffer.promise();
        }

        //请求接口获得出版社
        var getVersionName = function (access_token, versionCode) {
            var deffer = $.Deferred();
            if (!versionCode) {
                deffer.reject()
            } else {
                if (app_global_versionList.length > 0) {
                    deffer.resolve(app_global_versionList.filter(function (el) {
                        return el.code == versionCode
                    })[0].name);
                } else {
                    var url = Easy_Cfg.EASYSVC + "api?method=ersp.resource.metadata.publisher.list&appkey=" + Easy_Cfg.APPKEY +
                        "&format=json&version=1.0&access_token=" + access_token;
                    $.ajax(url).done(function (data) {
                        if (data && data.data && data.data.data instanceof Array) {
                            app_global_versionList = data.data.data;
                            deffer.resolve(app_global_versionList.filter(function (el) {
                                return el.code == versionCode
                            })[0].name);
                        } else {
                            deffer.resolve("")
                        }
                    }).fail(function (err) {
                        console.log(err);
                        deffer.resolve("")
                    })
                }
            }
            return deffer.promise();
        }

        //请求接口获得年级
        var getGradeName = function (access_token, gradeCode) {
            var deffer = $.Deferred();
            if (!gradeCode) {
                deffer.reject();
            } else {
                if (app_global_gradeList.length > 0) {
                    deffer.resolve(app_global_gradeList.filter(function (el) {
                        return el.code == gradeCode
                    })[0].name);
                } else {
                    var url = Easy_Cfg.EASYSVC + "api?method=ersp.resource.metadata.grade.list&appkey=" + Easy_Cfg.APPKEY +
                        "&format=json&version=1.0&access_token=" + access_token;
                    $.ajax(url).done(function (data) {
                        if (data && data.data && data.data.data instanceof Array) {
                            app_global_gradeList = data.data.data;
                            deffer.resolve(app_global_gradeList.filter(function (el) {
                                return el.code == gradeCode
                            })[0].name);
                        } else {
                            deffer.resolve("")
                        }
                    }).fail(function (err) {
                        console.log(err);
                        deffer.resolve("")
                    })
                }
            }
            return deffer.promise();
        }

        //请求接口获取用户学校信息
        var getUserSchoolInfo = function (access_token, userLoginName) {
            var deffer = $.Deferred();
            //获取用户信息
            var url = Easy_Cfg.EASYSVC + "api?appkey=" + Easy_Cfg.APPKEY + "&method=core.user.get&version=2.0&" +
                "format=json&key=loginName&timeout=10000&dataType=json&client_version=4.0.2&product=std" +
                "&value=" + userLoginName + "&access_token=" + access_token;
            $.ajax(url).done(function (data) {
                if (data && data.code == 0 && data.data && data.data.id) {
                    var userId = data.data.id;
                    //根据用户信息的codeid，请求该用户的学校信息
                    var url = Easy_Cfg.EASYSVC + "api?appkey=" + Easy_Cfg.APPKEY + "&method=core.school.list.user&version=2.0" +
                        "&format=json&userId=" + userId + "&dataType=json&access_token=" + access_token;
                    $.ajax(url).done(function (data) {
                        var userSchoolInfo = data && data.data instanceof Array && data.data[0] || '';
                        if (userSchoolInfo) {
                            app_global_userSchoolInfo = userSchoolInfo;
                            deffer.resolve(userSchoolInfo)
                        } else {
                            deffer.resolve("")
                        }
                    }).fail(function (err) {
                        console.log(err);
                        deffer.resolve("");
                    })

                } else {
                    deffer.resolve("");
                }
            }).fail(function (err) {
                console.log(err);
                deffer.resolve("");
            })
            return deffer;
        }
        //将互动卡片名称转换为对应中文名称
        var switchTypeNameToChinese = function (type) {
            var typeName = "";
            switch (type) {
                default:
                    typeName = "互动卡片";
                case "gallery":
                    typeName = "画廊";
                    break;
                case "cneval":
                    typeName = "中文评测";
                    break;
                case "eneval":
                    typeName = "英文评测";
                    break;
                case "exercise":
                    typeName = "测验";
                    break;
                case "situdlg":
                    typeName = "情景对话";
                    break;
                case "flipcard":
                    typeName = "翻翻卡";
                    break;
                case "history":
                    typeName = "时间轴";
                    break;
                case "matchcard":
                    typeName = "连线题";
                    break;
                case "mathequation":
                    typeName = "理科公式";
                    break;
                case "pickcard":
                    typeName = "分类题";
                    break;
                case "onlineexam":
                    typeName = "题库出题";
                    break;
                case "mindmap":
                    typeName = "思维导图";
                    break;
                case "onlinesupple":
                    typeName = "教辅出题";
                    break;

            }
            return typeName;
        }
        //启动子进程，启动互动卡片
        var loadInterActiveCard = function (type, jsonObject) {
            $("#closeAddSource").trigger("click");
            var fs = nodereq("fs");
            var exec = nodereq('child_process').exec;
            var tempjson = path.join(process.env.TEMP, "./" + Date.now() + ".json");
            fs.writeFileSync(tempjson, JSON.stringify(jsonObject));
            var myDate = new Date();
            var myDateString = myDate.Format("yyyyMMddhhmmss");
            var lasttime = myDate.Format("yyyy-MM-dd hh:mm:ss");
            var typeName = switchTypeNameToChinese(type);
            var tempsave = path.join(process.env.TEMP, "./" + typeName + "" + myDateString + ".sco");
            var cartToolExePath = path.join(Config.binPath, "../../../tools/card_tool/nw.exe").replace('file:/', '');
            var childProcess = exec('"' + cartToolExePath + '" --action=edit --cardType=' + type + ' --propdata="' + tempjson + '" --path="' + tempsave + '"');
            //写入TA时需保存完整的unit信息，从全局变量中获取当前书本的unit;
            var unit = app_global_bookContainer.getCurrPageMetadata();
            var uuid = _pptIcwsAccessor.createUuid();
            // var timestamp=Date.parse(new Date());
            var timestamp = (new Date()).valueOf();
            //写TA数据库需要的参数
            var condition = {
                "filename": typeName + "" + myDateString,
                "unit1": unit.unit1 || "",
                "unit2": unit.unit2 || "",
                "unit3": unit.unit3 || "",
                "unit4": unit.unit4 || "",
                "timestamp": timestamp,
                "fileid": uuid,
                "type": "sco",
                "bookcode": ebookContext.curBookCode,
                "filepath": typeName + "" + myDateString + ".sco",
                "filesavepath": "",
                "lasttime": lasttime,
                "creator": jsonObject.author,
                "size": "",
                "secondType": type

            };
            //写IFB数据库需要的参数
            var paramToIfbDb = {
                title: typeName + myDateString,
                id: uuid,
                source: "local",
                grade: jsonObject.book.grade.code,
                subject: jsonObject.book.subject.code,
                volumn: "",
                unit: jsonObject.book.catalog.code,
                course: "",
                bookCode: jsonObject.book.code,
                category: "",
                extension: ".sco",
                file: "users/" + ebookContext._curUser._name + "/localresource/" + type + myDateString + "/" + typeName + myDateString + ".sco",
                downloadDate: lasttime,
                fileSize: ""
            };
            //保存卡片成功后回调
            childProcess.on('exit', function (code) {
                if (code == 0) {
                    console.log("edit success");
                    _bookContainer.insertWidget([tempsave], {
                        file: tempsave,
                        type: type,
                        userName: ebookContext.getUser().getUserName(),
                        timestamp: timestamp,
                        resourceId: uuid,
                        fileInfo: condition
                    });
                    //文件生成后获取文件长度
                    var size = fs.statSync(tempsave).size;
                    if (size) {
                        condition.size = size;
                        paramToIfbDb.fileSize = size;
                    };
                    //写入TA数据库并复制文件到TA
                    _pptIcwsAccessor.addInfoWithCopyFile(condition, tempsave).done(function (ret) {
                        console.log("success");
                    }).fail(function (e) {
                        console.log("写TA数据库失败");
                    });
                    //写入ifb数据库
                    var ifbDbpath = Config.binPath + "users/" + ebookContext._curUser._name + "/userdb.db"
                    // var ifbDbpath="D:/workspace/EPD_TA5.0(GIT)/TA/plugins/62/bin/users/User1471614971096/userdb.db";
                    if (ifbDbpath.indexOf("file:///") != -1) {
                        ifbDbpath = ifbDbpath.substring(8);
                    };
                    var sqlite3 = nodereq('sqlite3').verbose();
                    var db = new sqlite3.Database(ifbDbpath);
                    var sql = 'insert into Resources(title,id,file,source,grade,' +
                        'subject,unit,bookCode,' +
                        'extension,downloadDate,fileSize) values("' +
                        paramToIfbDb.title + '","' +
                        paramToIfbDb.id + '","' +
                        paramToIfbDb.file + '","' +
                        paramToIfbDb.source + '","' +
                        paramToIfbDb.grade + '","' +
                        paramToIfbDb.subject + '","' +
                        paramToIfbDb.unit + '","' +
                        paramToIfbDb.bookCode + '","' +
                        paramToIfbDb.extension + '","' +
                        paramToIfbDb.downloadDate + '","' +
                        paramToIfbDb.fileSize + '")';
                    db.exec(sql, function (err, rows) {
                        if (err) {
                            console.log("写IFB数据库失败");
                        } else {
                            console.log("写IFB数据库成功");
                        };
                        db.close();
                    });
                };
                //每次卡片保存完成之后再次绑定事件
                //$(".btn_cart_group").unbind("mouseup").one("mouseup",insertInterActiveCard);
                $(document).unbind("mouseup", insertInterActiveCard).one("mouseup", ".btn_cart_group", insertInterActiveCard);
            });
        }
        //互动卡片按钮，包括“中文评测”、“英文评测”、“测验”、“翻翻卡”、“画廊”、“时间轴”、“连线题”、“理科公式”、“分类题目”、“情景对话”十种
        var insertInterActiveCard = function (e) {
            console.log(e.target);
            var type = $(this).attr("id");
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid: ebookContext._curUser._uid,
                module: '02001',
                type: 'trigger',
                cardId: type
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            /*写书本目录信息到json保存到tempdir Date.now()
             * */
            var pageIndex = _bookContainer.getPageIndex();
            var pageMeta = _bookContainer.getPageMetadata(pageIndex);
            var catalog = getCatalogInfo(pageMeta);
            var subjectCode = _bookContainer.bookMetaInfo.subject;
            var versionCode = _bookContainer.bookMetaInfo.publisher;
            var gradeCode = _bookContainer.bookMetaInfo.grade;
            var userloginName = ebookContext.getUser()._name; //这个是登陆名,如：User1466331273081
            var userName = ebookContext.getUser().getUserName();
            var access_token = ebookContext.getUser().getDynamicToken();
            //获取学科、出版社、年级接口所需要的access_token
            var url = Easy_Cfg.OAUTH_TOKEN_SERVER + "client_id=" + Easy_Cfg.APPKEY + "&client_secret=" + Easy_Cfg.SECRET +
                "&grant_type=client_credentials&client_version=4.0.2&product=std";
            $.ajax(url).done(function (data) {
                access_token = data.access_token;
                //获取学科、出版社、年级名称、获取用户学校信息
                $.when(getSubjectName(access_token, subjectCode), getVersionName(access_token, versionCode), getGradeName(access_token, gradeCode), getUserSchoolInfo(access_token, userloginName))
                    .done(function (subjectName, versionName, gradeName, userSchoolInfo) {
                        var jsonObject = {
                            "book": {
                                "name": _bookContainer.bookMetaInfo.title,
                                "code": _bookContainer.bookMetaInfo.bookCode,
                                "contents": {},
                                "subject": {
                                    "name": subjectName, //""
                                    "code": subjectCode
                                },
                                "version": {
                                    "name": versionName, //""
                                    "code": versionCode
                                },
                                "grade": {
                                    "name": gradeName, //""
                                    "code": gradeCode
                                },
                                "catalog": {
                                    "name": catalog.name,
                                    "code": catalog.code
                                }
                            },
                            "section": "环节名称",
                            "activity": "活动名称",
                            "author": ebookContext.getUser().getUserName(),
                            "school": {
                                "province": userSchoolInfo.provinceName ? userSchoolInfo.provinceName : "", //""
                                "city": userSchoolInfo.cityName ? userSchoolInfo.cityName : "", //""
                                "region": userSchoolInfo.districtName ? userSchoolInfo.districtName : "", //""
                                "name": userSchoolInfo.schoolName ? userSchoolInfo.schoolName : "" //""
                            }
                        };
                        // var jsonObject={"book":{"name":"数学北师大一年级上册（2013年新编）","code":"01020107-001","contents":{},"subject":{"name":"","code":"02"},"version":{"name":"","code":"07"},"grade":{"name":"","code":"01"},"catalog":{"name":"可爱的校园","code":"02"}},"section":"问答","activity":"情境导入","author":"","school":{"province":"","city":"","region":"","name":""}};
                        loadInterActiveCard(type, jsonObject);
                    })
                    .fail(function (err) {
                        console.log(err);
                        showAlertTips('无法打开卡片互动，请重试');
                        //每次卡片保存完成之后再次绑定事件
                        //$(".btn_cart_group").unbind("mouseup").one("mouseup",insertInterActiveCard);
                        $(document).unbind("mouseup", insertInterActiveCard).one("mouseup", ".btn_cart_group", insertInterActiveCard);
                    })
                // }
            }).fail(function (err) {
                console.log(err);
                showAlertTips('无法打开卡片互动，请重试');
                //每次卡片保存完成之后再次绑定事件
                //$(".btn_cart_group").unbind("mouseup").one("mouseup",insertInterActiveCard);
                $(document).unbind("mouseup", insertInterActiveCard).one("mouseup", ".btn_cart_group", insertInterActiveCard);
            })
        }

        //todo 绑定互动卡片的方法，这个todo只是为了表明这是入口，并没有什么未完成的
        // $(".btn_cart_group").unbind("mouseup").one("mouseup",insertInterActiveCard);
        $(document).unbind("mouseup", insertInterActiveCard).one("mouseup", ".btn_cart_group", insertInterActiveCard);

        $("#btnImport").click(function () {
            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            //显示选择本地导入还是网盘导入
            $("#addSourceContainer").css("display", "none");
            //王哒哒修改
            $("#btnImport_local").trigger("click")
            // var panel = $('#btnImportChoicePanel');
            // var xpos=($("#bookContainer").width()-panel.width())/2+204;
            // var ypos=($("#bookContainer").height()-panel.height())/2;
            // // var xpos=$("#btnImport").offset().left-56+44;
            // // var ypos= $("#btnImport").offset().top + $("#btnImport").height() +5  ;
            // var panel = $(document).find("#btnImportChoicePanel");
            // panel.css({  //设置位置
            //     position: 'absolute',
            //     left:  xpos,
            //     top:   ypos,
            // }).draggable({               //设置可拖动
            //     containment: "body",
            //     handle: ".pop_top"
            // });

            // if(app_global_isMainToolBarUp){
            //     panel.css('margin-top','20px');
            //     panel.find('img').attr('src','assert/images/bubble_arrow.png');
            //     panel.find('.top_arrow').css('top','-12px');
            // }else{
            //     panel.css('margin-top','-132px');
            //     panel.find('img').attr('src','assert/images/bubble_arrow2.png');
            //     panel.find('.top_arrow').css('top','56px');
            // }
            // panel.show();
            // event.stopPropagation();
        });

        //隐藏导入授课包弹框
        $("#closeImport").click(function () {
            $('#btnImportChoicePanel').hide();
        })

        $('#btnImport_local').click(function () {

            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid: ebookContext._curUser._uid,
                module: '02007',
                type: 'trigger'
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            $('#btnImportChoicePanel').hide();
            importRes.importBookRes();
            event.stopPropagation();
        });

        $('#btnImport_wp').click(function () {
            //add online check
            //temp eshop监管 linwang5@iflytek.com
            var staticParams = {
                uid: ebookContext._curUser._uid,
                module: '02008',
                type: 'trigger'
            };
            edcService.Instance().api_eshop_baseStatics(staticParams);

            $('#btnImportChoicePanel').hide();
            webMtbkRes.init({
                _bookContainer: _bookContainer
            });
            event.stopPropagation();
        });

        $("#btnExport").click(function () {
            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            //导出授课包
            $("#addSourceContainer").css("display", "none");
            setGlobalMtbkExport(exportRes);
            exportRes.init(_bookContainer);
            exportRes.exportBookRes();
            event.stopPropagation();
            //监管
            //            var action = LogManager.action.trigger;
            //            var params = {};
            //            params.module = '1130502';
            //            var user_id = ebookContext.getUser().getUid();
            //            if(user_id != '0' && user_id){
            //                params.user_id =user_id;
            //            }
            //            LogManager.statistics(action,params);

        });
        $("#btnSaveToPre").click(function () {
            $(".user-popover").hide();
            $("#smartbar_pop").remove();
            $("#resetName").find(".errorTip").hide();
            $("#resetName").show();
            var dom_resetName = $("#resetName").find(".jxpop-box");
            dom_resetName.css({ //设置位置
                position: 'absolute',
                left: ($(window).width() - dom_resetName.outerWidth()) / 2 + 102,
                top: ($("#bookContainer").height() - dom_resetName.outerHeight()) / 2 + $(document).scrollTop()
            }).draggable({ //设置可拖动
                containment: $("#bookContainer")
            });
            var bookName = _bookContainer.bookMetaInfo.title;
            var obj = _bookContainer.getCurrPageMetadata();
            var unitName = "";
            if (obj.unit1Name) {
                unitName = obj.unit1Name
            };
            if (obj.unit2Name) {
                unitName = obj.unit2Name
            };
            if (obj.unit3Name) {
                unitName = obj.unit3Name
            };
            if (obj.unit4Name) {
                unitName = obj.unit4Name
            };
            var fileName = unitName + "_" + bookName;
            $("#resetName").find("input[name=defaultname]").focus();
            $("#resetName").find("input[name=defaultname]").val(fileName);
        });
        $(document).on("click", "#resetname_close,#resetname_no", function () {
            $("#resetName").hide();
        });
        $(document).on("click", "#resetname_yes", function () {
            // $("#resetName").hide();
            var fileName = $("#resetName").find("input[name=defaultname]").val();
            var dom = $("#resetName");
            exportRes.saveTPToPre(fileName, dom);
        });

        var camera = require('../../card/template/camera').Instance;

        //$('#btnCap,#smartbar_btnCap').click(function () {
        $(document).on('click', '#btnCap,#smartbar_btnCap', function () {
            //temp eshop监管 linwang5@iflytek.com
            var staticParams;
            var thidDomId = $(this).attr('id');
            if (thidDomId == 'btnCap') {
                staticParams = {
                    uid: ebookContext._curUser._uid,
                    module: '03013',
                    type: 'trigger',
                    havingClass: _isHavingClass ? 1 : 0
                };
            } else {
                staticParams = {
                    uid: ebookContext._curUser._uid,
                    module: '02001',
                    type: 'trigger',
                    cardId: $(this).attr('id')
                };
            }

            var fs = nodereq("fs");
            edcService.Instance().api_eshop_baseStatics(staticParams);
            var userName = ebookContext.getUser().getName();
            var appManagePath = Config.nwexePath + 'user/' + userName + '/' + 'appmanage.dat';
            var str = fs.readFileSync(appManagePath, encoding = 'utf8');
            var jsonInfo = $.parseJSON(str);
            var con = jsonInfo && jsonInfo['91'];
            if (con) { //安装了实物展台工具
                if (!AppCfg.useH5Camera) {
                    var exArray = [];
                    //判断是否有摄像头，没有摄像头给出提示
                    MediaStreamTrack.getSources(function (devs) { //devs是设备列表
                        for (var i = 0; i < devs.length; i++) {
                            if (devs[i].kind == "video" && devs[i].label != "screen-capture-recorder") {
                                exArray.push(devs[i]);
                            }
                        };
                        if (exArray.length == 0) {
                            // alert("没有连接摄像头设备，实物展台不可用！");
                            $("#noCameraReminder,#cameraMask").show();
                            var panel = $(document).find("#noCameraReminder");
                            var xpos = ($(window).width() - panel.width()) / 2;
                            var ypos = ($("#bookContainer").height() - panel.height()) / 2;
                            panel.css({ //设置位置
                                position: 'absolute',
                                left: xpos,
                                top: ypos,
                            }).draggable({ //设置可拖动
                                containment: "body",
                                handle: ".pop_top"
                            });

                        } else { //有摄像头，启动实物展台
                            var nodepath = nodereq("path");
                            var exec = nodereq("child_process").exec;
                            var videocapexe = '"' + process.execPath + '" "' + nodepath.resolve(process.execPath, "../plugins/91" + '" "');
                            //在IFB中启动实物展台，带入参数表明从IFB启动实物展台
                            var childProcess = exec(videocapexe + '--fromapp=iflybook"');
                            //temppng是实物展台保存的临时文件地址，此地址为固定地址
                            var temppng = nodepath.resolve(process.execPath, "../plugins/91/temppng.png");
                            //先将temppng拷贝至tempsave，然后将tempsave文件插入到书本中。这么做因为temppng是固定文件名固定路径，无法正常插入课本
                            var tempsave = "";
                            //关闭回调
                            childProcess.on("exit", function (code, param) {
                                //返回值为3表明是插入课本，将图片插入课本
                                if (code == '3') {
                                    var uuid = _pptIcwsAccessor.createUuid();
                                    // var timestamp=Date.parse(new Date());
                                    var timestamp = (new Date()).valueOf()
                                    var myDate = new Date();
                                    var lasttime = myDate.Format("yyyy-MM-dd hh:mm:ss");
                                    var fileName = "实物展台" + myDate.format("yyyyMMddhhmmss");
                                    tempsave = path.join(process.env.TEMP, "./" + fileName + ".png");

                                    var pageIndex = _bookContainer.getPageIndex();
                                    var pageMeta = _bookContainer.getPageMetadata(pageIndex);
                                    var catalog = getCatalogInfo(pageMeta);
                                    var unit = catalog.code;
                                    unit = unit.split("-");
                                    //文件生成后获取文件长度
                                    var size = fs.statSync(temppng).size;
                                    var fileInfo = {
                                        "filename": fileName,
                                        "unit1": unit[0] || "",
                                        "unit2": unit[1] ? unit[0] + "-" + unit[1] : "",
                                        "unit3": unit[2] ? unit[0] + "-" + unit[1] + "-" + unit[2] : "",
                                        "unit4": unit[3] ? unit[0] + "-" + unit[1] + "-" + unit[2] + "-" + unit[3] : "",
                                        "timestamp": timestamp,
                                        "fileid": uuid,
                                        "fileExt": "png",
                                        "bookcode": ebookContext.curBookCode,
                                        "filepath": fileName + ".png",
                                        "filesavepath": "",
                                        "lasttime": lasttime,
                                        "creator": ebookContext.getUser().getUserName(),
                                        "size": size,
                                    };
                                    //拷贝文件
                                    shellcmd.copyDir_ext(temppng, tempsave).done(function () {
                                        console.log("复制文件temppng成功！");
                                        _bookContainer.insertWidget([tempsave], {
                                            file: tempsave,
                                            userName: ebookContext.getUser().getUserName(),
                                            timestamp: timestamp,
                                            resourceId: uuid,
                                            fileInfo: fileInfo,
                                            insertToTA: true
                                        });
                                    });
                                }
                            })
                        }
                    });
                } else {
                    camera.init();
                };
                //关闭添加资源弹窗
                $("#closeAddSource").trigger("click");
            } else {
                $.Zebra_Dialog("您尚未安装“实物展台”应用", {
                    'type': 'question',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.CancelTips, AppTips.Goinstall],
                    'onClose': function (a) {
                        if (a == AppTips.Goinstall) {
                            var tamainOpen = ibWSLogic.getTamainStatus();
                            if (tamainOpen) {
                                var json = {
                                    to: "main",
                                    action: "ifbPlugins",
                                    data: {
                                        id: 91

                                    }
                                };
                                socket.send(json);
                            } else {
                                global_tamain_icw = true;
                                var tpPath = path.join(Config.binPath, "../../../nw.exe");
                                var workPath = '\"' + path.trimPosix(path.join(Config.binPath, "../../../main")) + '\"';
                                shellcmd.shellexecutewithargs(tpPath, workPath);
                            }
                        }
                    }
                });
            }

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130214';
            var user_id = ebookContext.getUser().getUid();
            if (user_id != '0' && user_id) {
                params.user_id = user_id;
            }
            LogManager.statistics(action, params);


        });
        $(document).on("click", "#btn_noCameraSure,#closeReminder", function () {
            $("#noCameraReminder,#cameraMask").hide();
        })
        /*$("#btn_noCameraSure,#closeReminder").click(function () {
            $("#noCameraReminder,#cameraMask").hide();
        });*/

        /*$('#smartbar_btnCap').click(function(){
            var nodepath = nodereq("path");
            var exec = nodereq("child_process").exec;

            if(!AppCfg.useH5Camera){
                // var videocapexe = Config.binPath + 'tools/iflybookVideoCap.exe';
                videocapexe = '"'+process.execPath+'" "' + nodepath.resolve(process.execPath,"../plugins/91");
                exec(videocapexe);

            }
            else{
                camera.init();
            }

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130308';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);

        })*/

        $(_bookContainer).bind('pageChanged', function () {
            var isTeachingPackage = getIsTeachingPackage();
            setIsTeachingPackage(isTeachingPackage);
        });
    }

    //切换上下课状态
    function changeClassStatus(status) {
        if (status) {
            socket.send({
                action: "cur_ibstatus",
                data: {
                    status: 1 // (ifb置前 且 上课状态) 1：是，2：否
                },
                from: "ib",
                id: "",
                to: "iflyslide",
                type: "logic"
            });
            //发送当前书本缩放级别
            socket.send({
                action: "zoom_level",
                data: {
                    level: _bookContainer.getCurrentZoomRate() || 1 // 1.0 代表不缩放，其余表示缩放级别
                },
                from: "ib",
                id: "",
                to: "iflyslide",
                type: "logic"
            });
            // //上课模式下改变全屏 -by njfu
            Config.Width = window.screen.width;
            Config.Height = window.screen.height;
        } else {
            socket.send({
                action: "cur_ibstatus",
                data: {
                    status: 2 // (ifb置前 且 上课状态) 1：是，2：否
                },
                from: "ib",
                id: "",
                to: "iflyslide",
                type: "logic"
            });
            //下课模式下重置窗口大小-by njfu
            Config.Width = display.width || window.screen.availWidth;
            Config.Height = display.height || window.screen.availHeight;
        }
        //上课模式下全屏，备课模式下非全屏  -by njfu
        WIN.setResizable(false);
        WIN.moveTo(0, 0);
        WIN.setMaximumSize(Config.Width, Config.Height);
        WIN.setMinimumSize(Config.Width, Config.Height);
        WIN.resizeTo(Config.Width, Config.Height);

        var value = !status;
        $(".user-popover").hide();
        $("#smartbar_pop").remove();
        $(".jxbubble-box").hide(); //上课状态的资源弹框隐藏
        //新加的，不知道会不会报错
        _bookContainer.setIsEditing(value);
        canvasMgr.setIsEditing(value);
        setIsEditingNew(value);
        setIsTeachingPackage(false); //不论是上课状态还是下课状态，授课包都设置为不可见
        if (value == false) { //这个状态设置有点坑，因为editing和havingclass是对立的，value表示的是editing状态
            setIsHavingClass(true);
            $(document).trigger("classMode", {
                "classMode": "havingClass"
            });
            $("#pdfIdentbutton").hide();
        } else {
            setIsHavingClass(false);
            $(document).trigger("classMode", {
                "classMode": "afterClass"
            });
            app_global_playerMgr && app_global_playerMgr.pause(); //暂停音频资源播放
            if (app_global_pdfInfo.isExistSimilarbooks) { //如果是pdf并且有相似书
                $("#pdfIdentbutton").show(); //显示“智能识别”按钮
            }

        }
        $("#btnMouse").trigger("click");
        //为了兼容部分win10全屏时任务栏遮挡做的异常处理 -by njfu
        setTimeout(function () {
            WIN.resizeTo(Config.Width, Config.Height);
            // WIN.enterFullscreen();
            WIN.toggleFullscreen();
        }, 0);
    }

    /**
     * 改变 btns.btnTogglePlay的状态
     * @param {boolean=} index
     * @private
     */
    function _changeStateToPlay(index) {
        var togglePlayText = _btns.btnTogglePlay.find('p')[1];
        var togglePlayImg = _btns.btnTogglePlay.find('img');
        if (index) {
            togglePlayImg.attr('src', 'assert/images/tool_pause.png');
            _btns.btnTogglePlay.attr('state', 'playing');
            $('.btn-waitplay').each(function () {
                if (!$(this).is(":hidden")) {
                    $(this).attr('state', 'playing');
                }
            });
            if (AppCfg.lang == "uyghur") {
                $(togglePlayText).html("");
            } else {
                $(togglePlayText).html("暂停");
            }
        } else {
            togglePlayImg.attr('src', 'assert/images/tool_play.png');
            _btns.btnTogglePlay.attr('state', 'stop');
            $('.btn-waitplay').each(function () {
                $(this).attr('state', 'stop');
            });
            if (AppCfg.lang == "uyghur") {
                $(togglePlayText).html("");
            } else {
                $(togglePlayText).html("播放");
            }

        }
    }

    /**
     * 动态计算主工具栏宽度
     * @param mainToolBar
     * @private
     */
    function _getMainToolBarWidth(mainToolBar) {
        if (!mainToolBar) return;
        var width = 0; //动态计算工具栏宽度
        $.each(mainToolBar.children(), function (i, e) {
            if (e.style.display !== 'none') {
                width += e.offsetWidth + (parseInt($(e).css("marginLeft"), 10) || 0) + 5;
            }
        });
        mainToolBar.css("width", width);
        correctToBaseResolution(mainToolBar, {
            width: 1024,
            height: Config.Height
        });
    }


    /**
     * 清空图标内容
     * @returns {*|jQuery|HTMLElement}
     * @private
     */
    function _getClearResContent() {
        var content = $(document.getElementById('template_clear_res').innerHTML);

        content.find("#clearCurrentPageRes").click(function () {
            _bookContainer.clearCurrentPageRes();
            _btns.btnClearRes.popover("hide");
            event.stopPropagation();
        })
        content.find("#clearBookRes").click(function () {
            _bookContainer.clearBookRes();
            _btns.btnClearRes.popover("hide");
            event.stopPropagation();
        });
        return content;
    }

    /**
     * 设置主工具栏位置
     * @param {boolean} status
     */
    function setMainToolBarPosition(status) {
        sessionStorage['isMainToolBarUp'] = app_global_isMainToolBarUp = status;

        if (!app_global_isMainToolBarUp) {
            $("#main").after($("#mainToolBar").css("margin-top", '9px').detach()).css("margin-top", 24);
            $("#blackBoardContainer").css("top", 26);
            $("#blackBoardOverlay").css("top", -80);
            //$("#mainToolBar li").css("margin-top",'-20px');
            // $("#eBookToolBar").css("position", 'absolute');
            $("#eBookToolBar").css("margin", '0 auto');
            _btns.btnMoveMenuBar.attr("src", "assert/images/toolup.png");
        } else {
            $("#main").css("margin-top", 0).before($("#mainToolBar").css("margin-top", 24).detach());
            $("#blackBoardContainer").css("top", 76);
            $("#blackBoardOverlay").css("top", 80);
            $("#mainToolBar li").css("margin-top", 0);
            _btns.btnMoveMenuBar.attr("src", "assert/images/tooldown.png");
        }
    }

    /**
     *
     * @param {boolean} isEditing
     */
    function setIsEditing(isEditing) {
        var $btnEdit = $('#btnEditing');
        var $ul = _btns.mainToolBar.find(">ul:first");
        if (isEditing) {
            $ul.find("li[menuStatus=edit],li[menuStatus=all]").css("display", "inline");
            $ul.find("li[menuStatus=done]").css("display", "none");
            //板擦要额外处理
            $("#eraserControl").css("display", "none");
            if (AppCfg.lang == "uyghur") {
                $btnEdit.children().removeClass().addClass("cb_complete2");
            } else {
                $btnEdit.children().removeClass().addClass("cb_complete");
            }
            if (!constrants.EDIT_WIDTH) {
                constrants.EDIT_WIDTH = _getMainToolBarWidth($ul);
            }
            $ul.css("width", constrants.EDIT_WIDTH);
        } else {
            $ul.find("li[menuStatus=edit]").css("display", "none");
            $ul.find("li[menuStatus=done],li[menuStatus=all]").css("display", "inline");
            if (AppCfg.lang == "uyghur") {
                $btnEdit.children().removeClass().addClass("cb_nature2");
            } else {
                $btnEdit.children().removeClass().addClass("cb_nature");
            }
            if (!constrants.NO_EDIT_WIDTH) {
                constrants.NO_EDIT_WIDTH = _getMainToolBarWidth($ul);
            }
            $ul.css("width", constrants.NO_EDIT_WIDTH);
        }

        toolBoxMgr.setIsEditing(isEditing);
        cardTemplateManager.setIsEditing(isEditing);
        //    searchManager && searchManager.setIsEditing(isEditing);
        //    resLibManager && resLibManager.setIsEditing(isEditing);
    }

    function changeWBEB(isWB) {
        // if(_isEditing) return;

        var $ul = _btns.mainToolBar.find(">ul:first");

        isWB ? $ul.find("li[menuStatus=WB]").css("display", "inline") : $ul.find("li[menuStatus=WB]").css("display", "none");
        isWB ? $ul.find("li[menuStatus=EB]").css("display", "none") : $ul.find("li[menuStatus=EB]").css("display", "inline");
        isWB ? _btns.btnAfterClass.hide() : _btns.btnAfterClass.show();

        //电子书页面预览需要单独处理
        isWB ? $("#btnPageView").hide() : $("#btnPageView").show();

        //书本截屏单独处理
        if (isWB) {
            $("#toICW").css('display', 'none');
        } else if (localStorage.getItem('btn_cut_pf_icon') == 'true') {
            $("#toICW").css('display', 'inline');
        } else {
            $("#toICW").css('display', 'none');
        }

        if (!constrants.NO_EDIT_WIDTH) {
            constrants.NO_EDIT_WIDTH = _getMainToolBarWidth($ul);
        }
        $ul.css("width", constrants.NO_EDIT_WIDTH);
    }

    //工具箱
    function initToolBox(bookContainer) {
        var _toolBoxMgr = require('../toolbox/toolboxmgr');
        toolBoxMgr = new _toolBoxMgr.ToolboxManager();

        var toolBoxPanel = $($("#tool_box_template").html());

        var buttons = {
            btnToolBox: $("#btnToolBox"),
            btnToolBoxEdit: toolBoxPanel.find("#btnToolBoxEdit"),
            btnCloseToolBox: toolBoxPanel.find("#btnCloseToolBox")
        };
        var controls = {
            toolListPanel: toolBoxPanel.find("#toolListPanel"),
            toolBoxPanel: toolBoxPanel,
            Pagination: toolBoxPanel.find("#toolPagination"),
            toolBoxTopBar: toolBoxPanel.find("#toolBoxTopBar")
        };
        toolBoxMgr.init(buttons, controls, bookContainer);
    }

    function initTemplate(bookContainer) {
        var _cardTemplateManager = require('../../card/template/cardtemplatemanager');
        cardTemplateManager = new _cardTemplateManager.CardTemplateManager();
        cardTemplateManager.init(bookContainer);
    }

    //幕布
    function initCurtain(bookContainer) {
        var _curtainMgr = require('../curtainmgr').Instance;
        var buttons = {
            btnCurtain: $("#btnCurtain"),
            smartBarCurtain: $("#smartbar_btnCurtain")
        };
        var controls = {
            templateCurtain: $(document.getElementById('curtain_template').innerHTML)
        }
        _curtainMgr.init(buttons, controls, bookContainer);
    }

    function initPagePreView(_bookContainer, pageIndex, bookCode) {
        var buttons = {
            btnPageView: $("#btnPageView")
        }
        var controls = {
            boxPageView: $(document.getElementById('templatePageView').innerHTML)
        }
        pagePreView.init(buttons, controls, _bookContainer, pageIndex, bookCode);
    }

    function initPagePreViewIcon() {
        var buttons = {}
        var controls = {
            pageNum: $("#pageNum"),
            curPageNum: $("#curPageNum")
        }
        pagePreViewIcon.init(controls);
    }

    function initResLib(bookContainer, user) {
        var _resLibManager = require('../resLib/resourcelibrarymgr');
        resLibManager = new _resLibManager.ResourceLibraryManager();
        var buttons = {
            resLibBtn: $("#resLibBtn"),
            cloudResBtn: $("#cloudResBtn"),
            localResBtn: $("#localResBtn"),
            localResManagerBtn: $("#btnLocalResManager"),
            multiSelectBtn: $("#btnMultiSelect"),
            localResDeleteBtn: $("#btnLocalResDelete"),
            localResAllSelectBtn: $("#btnLocalResAllSelect"),
            localResNoSelectBtn: $("#btnLocalResNoSelect"),
            localResResCancelBtn: $("#btnLocalResCancel"),
            localResOpenBtn: $("#btnLocalResOpen"),

            SelectedCategoryValueInResBtn: $("#btnSelectedCategoryValueInRes"),
            SelectedModeValueInResBtn: $("#btnSelectedModeValueInRes"),
            GoBackToResIframeBtn: $("#btnGoBackToResIframe"),
            closeBtnResLibPanel: $("#closeBtn_resLibPanel")
        };
        var controls = {
            resLibIfrm: $("#resLibIfrm"),
            resLibPanel: $("#resLibPanel"),
            resLibPanelTop: $("#resLibPanelTop"),
            resLibPanelMask: $("#resLibPanelMask"),
            resItems: $("#resItems"),
            Pagination: $("#Pagination"),
            localResLibPanel: $("#localResLibPanel"),
            pageBtnPanel: $("#pageBtnPanel"),
            elemMaskPanel: $("#elemMaskPanel"),
            noResTips: $("#noResTips"),
            repositoryPanel: $("#repositoryPanel")
        };

        resLibManager.init(buttons, controls, bookContainer);
        resLibManager.setUser(user);
        setGlobalContextResLibMgr(resLibManager);

        // var offset = $("#mainToolBar").height() + $("#header").height() - 20;
        //新需求取消了工具栏上下位置，这里直接设置false,即在下方。
        var offset = false;
        resLibManager.setMainToolBarPosition(offset);

        registerIframe("resLibIfrm", "*");
        return resLibManager;
    }

    function initSearch(bookContainer, user) {
        var _searchManager = require('../resLib/searchmanager');
        searchManager = new _searchManager.SearchManager();
        var buttons = {
            btnInnerSearch: $("#btnInnerSearch"),
            btnOuterSearch: $("#btnOuterSearch"),
            btnInnerLocalSearch: $("#btnInnerLocalSearch"),
            btnInnerCloudSearch: $("#btnInnerCloudSearch"),
            btnInnerWebSearch: $("#btnInnerWebSearch"),
            btnCloseSearchPanel: $("#btnCloseSearchPanel"),
            btnInnerSearchVoiceIme: $("#btnInnerSearchVoiceIme"),
            btnInnerSearchWriteIme: $("#btnInnerSearchWriteIme"),
            btnInnerSearchKeyboardIme: $("#btnInnerSearchKeyboardIme"),
            btnOuterSearchVoiceIme: $("#btnOuterSearchVoiceIme"),
            btnOuterSearchWriteIme: $("#btnOuterSearchWriteIme"),
            btnOuterSearchKeyboardIme: $("#btnOuterSearchKeyboardIme"),
            btnSelectedCategory: $("#btnSelectedCategoryValue"),
            btnInnerSearchAll: $("#btnInnerSearchAll"),
            btnInnerSearchClass: $("#btnInnerSearchClass"),
            btnInnerSearchFile: $("#btnInnerSearchFile")
        };
        var controls = {
            searchIfrm: $("#searchIfrm"),
            searchPanel: $("#searchPanel"),
            searchPanelTop: $("#searchPanelTop"),
            searchPanelMask: $("#searchPanelMask"),
            searchItems: $("#searchItems"),
            searchPagination: $("#searchPagination"),
            localSearchPanel: $("#localSearchPanel"),
            outerSearchText: $("#outerSearchText"),
            innerSearchText: $("#innerSearchText"),
            ResCountValue: $("#ResCount"),
            SearchPageBtnPanel: $("#searchPageBtnPanel"),
            noSearchResTips: $("#noSearchResTips"),
            searchContentPanel: $("#searchContentPanel"),
            searchContentTop: $("#searchContentTop")
        };

        searchManager.init(buttons, controls, bookContainer);
        searchManager.setUser(user);
        setGlobalContextSearchMgr(searchManager);
        //   registerIframe("searchIfrm", "*");
    }

    function initWBView(container) {
        WBpreView.init(container);
    }

    function setIsEditingNew(value) {
        if (value == _isEditing) return;
        _isEditing = value;
    }

    //动态生成底部菜单栏
    function generateNav(isHavingClass) {
        var ishavingClass = isHavingClass == true ? true : false;
        var havingClassNavTpl = $('<button type="button" class="tool_normal J_having_class" id="btnRightMouse"><p><i class="icon iconfont">&#xe612;</i></p><p>鼠标</p></button>' +
            '<div class="btnnav-group btnnav-groupbg">' +
            '<button type="button" class="tool_normal tool_current" id="btnRightPen"><p><i class="icon iconfont">&#xe618;</i></p><p>画笔</p></button>' +
            '<button type="button" class="tool_arrow" onClick=""><i class="icon iconfont">&#xe627;</i></button>' +
            '</div>' +
            '<div class="btnnav-group">' +
            '<button type="button" class="tool_normal" id="btnRightEraser"><p><i class="icon iconfont">&#xe616;</i></p><p>板擦</p></button>' +
            '<button type="button" class="tool_arrow" onClick=""><i class="icon iconfont">&#xe627;</i></button>' +
            '</div>' +
            '<p class="nav-line"></p>' +
            '<button type="button" class="tool_normal J_having_class" id="btnFocus"><p><i class="icon iconfont">&#xe623;</i></p><p>聚焦</p></button>' +
            '<button type="button" class="tool_normal J_having_class" id="btnCap"><p><i class="icon iconfont">&#xe613;</i></p><p>投影</p></button>' +
            '<button type="button" class="tool_normal J_having_class" onClick=""><p><i class="icon iconfont">&#xe614;</i></p><p>出题</p></button>' +
            '<button type="button" class="tool_normal J_having_class" id="toICW"><p><i class="icon iconfont">&#xe609;</i></p><p>快照</p></button>' +
            '<button type="button" class="tool_normal J_having_class" onClick=""><p><i class="icon iconfont">&#xe619;</i></p><p>录课</p></button>' +
            '<button type="button" class="tool_normal J_having_class" id="showPluginBtn"><p><i class="icon iconfont">&#xe617;</i></p><p>辅助工具</p></button>' +
            '<p class="nav-line"></p>' +
            '<button type="button" class="tool_normal J_having_class" id="contentLeft"><p><i class="icon iconfont">&#xe620;</i></p><p>目录</p></button>' +
            '<button type="button" class="tool_normal J_having_class"><p><i class="icon iconfont">&#xe615;</i></p><p>转页</p></button>' +
            '<button type="button" class="tool_normal J_having_class" id="btnZoomIn"><p><i class="icon iconfont">&#xe606;</i></p><p>放大</p></button>' +
            '<button type="button" class="tool_normal J_having_class" id="btnZoomOut"><p><i class="icon iconfont">&#xe607;</i></p><p>缩小</p></button>' +
            '<button type="button" class="tool_normal J_having_class" id="btnLeftPageView"><p><i class="icon iconfont">&#xe621;</i></p><p>单页</p></button>' +
            '<button type="button" class="tool_normal J_having_class"><p><i class="icon iconfont">&#xe622;</i></p><p>双页</p></button>' +
            '<p class="nav-line"></p>' +
            '<button type="button" class="tool_normal J_having_class" id="WBL"><p><i class="icon iconfont">&#xe608;</i></p><p>黑板</p></button>' +
            '<button type="button" class="tool_normal J_having_class"><p><i class="icon iconfont">&#xe611;</i></p><p>书架</p></button>' +
            '<button type="button" class="tool_normal J_having_class" id="J_after_class"><p><i class="icon iconfont">&#xe610;</i></p><p>下课</p></button>');

        var afterClassNavTpl = $('<button type="button" class="tool_normal btn-info J_after_class" id="J_teaching_package"><p><i class="icon iconfont"></i></p><p>授课包</p><p class="btn-infotip"></p></button>' +
            '<button type="button" class="tool_normal btn-info J_after_class" id="J_res_center" style="display:none;"><p><i class="icon iconfont"></i></p><p>资源中心</p></button>' +
            '<p class="nav-line nav-infoline"></p>' +
            '<button type="button" class="tool_normal tool_current J_after_class" id="contentLeft"><p><i class="icon iconfont"></i></p><p>目录</p></button>' +
            '<button type="button" class="tool_normal J_after_class"><p><i class="icon iconfont"></i></p><p>转页</p></button>' +
            '<button type="button" class="tool_normal J_after_class" id="btnZoomIn"><p><i class="icon iconfont"></i></p><p>放大</p></button>' +
            '<button type="button" class="tool_normal J_after_class" id="btnZoomOut"><p><i class="icon iconfont"></i></p><p>缩小</p></button>' +
            '<button type="button" class="tool_normal J_after_class" id="btnLeftPageView"><p><i class="icon iconfont"></i></p><p>单页</p></button>' +
            '<p class="nav-line"></p>' +
            '<button type="button" class="tool_normal J_after_class"><p><i class="icon iconfont"></i></p><p>书架</p></button>' +
            '<button type="button" class="tool_normal J_after_class" id="J_having_class"><p><i class="icon iconfont"></i></p><p>开始上课</p></button>');
        //上课/下课模式底部工具栏
        $(".J_nav").html();
        if (ishavingClass) {
            //上课模式
            $(".J_nav").removeClass("J_having_class J_after_class").addClass("J_having_class").html("");
            $(".J_nav").append(havingClassNavTpl).show();
        } else {
            $(".J_nav").removeClass("J_having_class J_after_class").addClass("J_after_class").html("");
            $(".J_nav").append(afterClassNavTpl).show();
        }


        // _btns.btnHavingClass.unbind().on("click",function(){
        //     setIsHavingClass(true);
        // });

        // _btns.btnAfterClass.unbind().on("click",function(){
        //     setIsHavingClass(false);
        // });
    }

    //设置上课/下课模式UI
    function setIsHavingClass(value) {
        _isHavingClass = value;
        $(document).data("isHavingClass", value);
        $(".J_nav").hide();
        if (_isHavingClass) {
            // if($("#after_class").is(':visible') == true)
            $(".J_after_class").hide();
            $(".J_having_class").show();
        } else {
            $(".J_having_class").hide();
            $(".J_after_class").show();
            $(".J_teaching_package_bar").hide();
            $("#J_res_center").hide();
        }
        $(".J_nav").show();
        //如果是pdf，隐藏目录按钮
        if (app_global_pdfInfo.isExistSimilarbooks) {
            $("#contentLeft").hide();
        }
    }

    //设置授课包状态
    function setIsTeachingPackage(value) {
        $(document).data("isTeachingPackage", value);
        if (value == isTeachingPackage) return;
        else
            isTeachingPackage = value;

    }


    /*  //设置画笔状态
    function setIsPenUse(value){
        $(document).data("isPenUse",value);
        if(value==isPenUse) return ;
        else
            isPenUse=value;

    }

    //获取当前画笔状态
    function getIsPenUse(){
        // return _isHavingClass == true ? true : false;
        return $(document).data("isPenUse") ? true : false;
    }
*/
    //获取当前上课模式，true-上课 false-下课
    function getIsHavingClass() {
        // return _isHavingClass == true ? true : false;
        return $(document).data("isHavingClass");
    }

    //获取当前授课包状态
    function getIsTeachingPackage() {
        // return _isHavingClass == true ? true : false;
        return $(document).data("isTeachingPackage") ? true : false;
    }
    //



    //显示和隐藏弹框里的删除按钮
    function showHideDeletefileBtn() {
        if (isTeachingPackage == true) { //授课包状态为true，显示删除按钮，否则隐藏
            $("#book").find(".jxpop-btnbar button[name=deletefile]").show();
        } else if (isTeachingPackage == false) {
            $("#book").find(".jxpop-btnbar button[name=deletefile]").hide();
        }

    }

    exports.init = init;
    exports.setIsEditing = setIsEditing;
    exports.setIsHavingClass = setIsHavingClass;
    exports.getIsHavingClass = getIsHavingClass;
    exports.setIsTeachingPackage = setIsTeachingPackage;
    exports.getIsTeachingPackage = getIsTeachingPackage;
    exports.changeClassStatus = changeClassStatus;
    exports.showHideDeletefileBtn = showHideDeletefileBtn;
    exports.changeWBEB = changeWBEB;
    exports.initResLib = initResLib;
    exports.initSearch = initSearch;

    exports.setIsEditingNew = setIsEditingNew;
});