/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-11-21
 * Time: 上午8:55
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {

        var ToolItem = require('./toolitem').ToolItem;
        var _shellcmd = require('../../../common/shellcmd');
        var _path = require('../../../common/path');
        var toolProvider = require('./toolprovider').Instance;

        function ToolboxManager() {
            var _self = this;
            _self.bookContainer = null;
            _self.buttons = {};
            _self.controls = {};
            _self._toolList = null;
            _self.mode = "complete";
//            _self._isMainToolBarUp = true;
            /**
             * @param buttons   按钮
             * @param controls  非按钮类控件
             * @param bookContainer
             */
            this.init = function (buttons, controls, bookContainer) {
                _self.bookContainer = bookContainer;
                _self.buttons = buttons;
                _self.controls = controls;
                //翻译
                LAN.translateObj( _self.controls.toolBoxPanel);

                _self.buttons.btnToolBox.click(function (e) {
                    _self.buttons.btnToolBoxEdit.val(AppToolBox.edit);
                    //$(this).popover("fadeOutAll");
                    if ($(this).popover("isShow")) {
                        _self.hideToolBox();
                    } else {
                        $(this).popover({
                            position: 'top',
                            content: _self.controls.toolBoxPanel,
                            userDefinePopover: true,
                            hideOnHTMLClick: false}).popover("show", {position: app_global_isMainToolBarUp ? 'bottom' : 'top'});
                        _self.showToolBox();
                        _self.controls.toolBoxPanel.css("z-index",500);
                        if(AppCfg.lang == "uyghur"){
                            $("#btnToolBoxEdit").css("width","60px");
                        }

                    }
                    event.stopPropagation();
                });

                _self.buttons.btnToolBoxEdit.click(function () {
                    if (_self.buttons.btnToolBox.popover("isShow") && _self.mode == "complete") {
                        _self.mode = "edit";
                        _self.showDelBtn();
                        _self.buttons.btnToolBoxEdit.val(AppToolBox.complete);
                    } else {
                        _self.mode = "complete";
                        _self.showToolBox();
                        _self.buttons.btnToolBoxEdit.val(AppToolBox.edit);
                    }
                });
                _self.buttons.btnCloseToolBox.click(function () {
                    _self.hideToolBox();
                });
            }

            /**
             * 设置是否是编辑状态，切换时需要隐藏面板
             * @param isEditing
             */
            this.setIsEditing = function (isEditing) {
                if (isEditing) {
                    _self.hideToolBox();
                }
            }

            /**
             * 显示删除按钮
             */
            this.showDelBtn = function () {
                _self.controls.toolBoxPanel.find(".normal .software_delete").show();
                _self.controls.toolBoxPanel.find(".normal .img").unbind("click");
                _self.controls.toolBoxPanel.find(".normal").addClass("current");
            }

            /**
             * 显示面板
             * @param currPageIndex 当前页面
             */
            this.showToolBox = function (currPageIndex) {
                _self.buttons.btnToolBox.attr('isshow','1');
                toolProvider.readAll().done(function (ret) {
                    _self._toolList = ret;
                    var currPage = currPageIndex ? currPageIndex : 0;
                    _self.controls.Pagination.pagination(_self._toolList.length + 1, {
                        items_per_page: 8,
                        num_edge_entries: 1,
                        num_display_entries: 4,
                        current_page: currPage,
                        prev_text: "",
                        next_text: "",
                        callback: _self._pageSelectCallback
                    });
                    _self.controls.toolBoxPanel.draggable({
                        handle:_self.controls.toolBoxTopBar,
                        containment:'document'
                    });

                });
            }

            /**
             * 隐藏面板
             */
            this.hideToolBox = function () {
                _self.mode = "complete";
                _self.buttons.btnToolBox.popover("hide");
                _self.buttons.btnToolBox.attr('isshow','0');
                //清除拖动痕迹，使其下次在默认位置出现
                _self.controls.toolBoxPanel.removeAttr("style");
                _self.controls.toolBoxPanel.css("z-index",11);
                _self.controls.toolBoxPanel.css("position","relative");
            }


            /**
             * 在内存中分页
             * @param pageIndex 当前页面
             * @param jq
             * @returns {boolean}
             * @private
             */
            this._pageSelectCallback = function (pageIndex, jq) {
                var items_per_page = 8;
                var elemLength = _self._toolList ? _self._toolList.length + 1 : 1//加上一个添加按钮
                var max_elem = Math.min((pageIndex + 1) * items_per_page, elemLength);
                _self.controls.toolListPanel.html('');
                for (var i = pageIndex * items_per_page; i < max_elem; i++) {
                    if (i == _self._toolList.length) {
                        _self.appendAddButton(pageIndex);
                        return;
                    }
                    var item = $("<li></li>");
                    var divImg = $("<div></div>");
                    var img = $("<img>");
                    img.attr("src", _self._toolList[i].thumbnail);
                    img.error(function () {
                        this.src = 'assert/images/software_img.png';
                    });
                    divImg.append(img);
                    divImg.attr("data-toolexepath", _self._toolList[i].exepath);
                    var divDel = $("<div><img src='assert/images/failure.png'></div>");
                    divDel.attr("data-toolid", JSON.stringify(_self._toolList[i])); //携带数据
                    var divTitle = $("<div></div>");
                    divImg.addClass("img");
                    divDel.addClass("software_delete");
                    divDel.click(function () {
                        var delToolItem = $(this).data("toolid");
                        _self._removeTool(delToolItem).done(function (ret) {
                            if (ret) {
                                _self.showToolBox(pageIndex);
                            }
                        });
                    });
                    if (_self.mode == "complete") {
                        item.addClass("normal");
                        divDel.hide();
                        divImg.click(function () {
                            _self._openTool($(this).attr("data-toolexepath"));
                        });
                    } else {
                        item.addClass("current");
                        divDel.show();
                        divImg.click(function () {
                            $(this).parent().addClass("current");
                        });
                    }
                    divTitle.addClass("text");
                    var title = _self._toolList[i].title;
                    if (_self.getLength(title) > 10) {
                        title = title.split(" ")[0].split(".")[0].split("_")[0].split("-")[0];
                    }
                    if (_self.getLength(title) > 10) {
                        title = title.substring(0, 4) + "...";
                    }
                    divTitle.text(title);
                    item.append(divImg);
                    item.append(divDel);
                    item.append(divTitle);
                    _self.controls.toolListPanel.append(item);
                }
                return false;
            }


            this.checkToolExist = function (exePath) {
                for (var i in _self._toolList) {
                    if (exePath == _self._toolList[i].exepath) {
                        return true;
                    }
                }
                return false;
            }

            /**
             * 添加增加工具按钮
             */
            this.appendAddButton = function (pageIndex) {
                var item = $("<li></li>");
                var divImg = $("<div><img src='assert/images/software_add.png'></div>");
                divImg.addClass("img");
                var divTitle = $("<div>"+AppToolBox.add+"</div>");
                divTitle.addClass("text");
                item.append(divImg);
                item.append(divTitle);
                item.click(function () {
                    ret = { "multi": false, "ext": [".exe"]};
                    _shellcmd.openFileDialog(ret).done(
                        function (result) {
                            console.log(result);
                            if (result.length>0) {
                                for (var i in result) {
                                    if (_self.checkToolExist(result[i])) {
                                        //禁用自动隐藏
                                        _self.buttons.btnToolBox.popover("setOption", {hideOnHTMLClick: false}).popover("show");
                                        $.Zebra_Dialog(AppTips.ToolExistedMsg, {
                                            'type': 'information',
                                            'title': AppTips.WarmTips,
                                            'buttons': [AppTips.OkTips],
                                            'onClose': function (capition) {
                                                //恢复自动隐藏
                                                _self.buttons.btnToolBox.popover("setOption", {hideOnHTMLClick: true})
                                                    .popover("show");
                                            }
                                        });
                                        continue;
                                    }
                                    var icoSavePath = "webapp\\assert\\images\\icons\\";
                                    _shellcmd.getExeInfo(result[i], icoSavePath).done(function (ret) {
                                        if(!ret){
                                            ret=" | ";
                                        }
                                        var title, thumbnail = '';
                                        var res = ret.split('|');
                                        exePath = res[0];
                                        if (res[1].trim()) {
                                            title = res[1];
                                        } else {
                                            title = exePath.replace(/^.+?\\([^\\]+?)(\.[^\.\\]*?)?$/gi, "$1");
                                        }
                                        if (res[2]) {
                                            thumbnail = "assert\\images\\icons\\" + res[2]
                                        } else {
                                            thumbnail = "assert\\images\\software_img.png";
                                        }
                                        var toolItem = new ToolItem();
                                        toolItem.exepath = exePath;
                                        toolItem.thumbnail = thumbnail;
                                        toolItem.title = title;
                                        _self._addTool(toolItem).done(function (addRet) {
                                            if (addRet) {
                                                _self.showToolBox(pageIndex);
                                            }
                                        });
                                    });

                                }
                            }
                        });
                });
                _self.controls.toolListPanel.append(item);
            }

            /**
             * 计算字符串长度，中文算2个
             * @param str
             * @returns {number}
             */
            this.getLength = function (str) {
                var cArr = str.match(/[^\x00-\xff]/ig);
                return str.length + (cArr == null ? 0 : cArr.length);
            }

            this._removeTool = function (toolItem) {
                console.log(toolItem.id);

                var def = $.Deferred();
                if (!toolItem) {
                    def.resolve(false);
                }
                toolProvider.remove(toolItem).done(function (removeResult) {
                    if (removeResult) {
                        def.resolve(true);
                    } else {
                        def.resolve(false);
                    }
                });
                return def.promise();
            }

            this._addTool = function (toolItem) {
                var def = $.Deferred();
                toolProvider.add(toolItem).done(function (addResult) {
                    if (addResult) {
                        def.resolve(true);
                    } else {
                        def.resolve(false);
                    }
                });
                return def.promise();
            }

            /**
             * 调用工具exe
             * @param toolExePath
             * @private
             */
            this._openTool = function (toolExePath) {
                _shellcmd.shellExecute('"' + toolExePath + '"');
            }
        }

        exports.ToolboxManager = ToolboxManager;
    }
);
