/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-11-26
 * Time: 下午4:37
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports, module) {

    var ToolItem = require('./toolitem').ToolItem;
    var _shellcmd = require('../../../common/shellcmd');
    var _path = require('../../../common/path');
    var dbPath = _path.trimPosix(Config.binPath) + "iflybook.db";

    function ToolProvider() {
        _self = this;

        _self.readAll = function () {
            var def = $.Deferred();
            var querySql = "select * from tools order by id asc";
            _shellcmd.retriveDbAsyn(dbPath, querySql).done(function (resStr) {
                if (resStr == "") {
                    def.resolve(new Array());
                }
                try {
                    var toolList = new Array();
                    var resJson = JSON.parse(resStr);
                    var data = resJson.data;
                    for (var item in data) {
                        var toolItem = new ToolItem();
                        toolItem.id = data[item].id;
                        toolItem.title = data[item].title;
                        toolItem.exepath = data[item].exepath;
                        toolItem.thumbnail = data[item].thumbnail;
                        toolList.push(toolItem);
                    }
                    def.resolve(toolList);
                }
                catch (e) {
                    def.resolve(new Array());
                }
            });
            return def.promise();
        }

        _self.remove = function (toolItem) {
            var def = $.Deferred();
            var sqlStr = 'delete from tools where id="' + toolItem.id + '"';
            _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
                if (ret) {
                    var thumbnail = _path.trimPosix(Config.binPath + "webapp\\" + toolItem.thumbnail);
                    _shellcmd.deleteFile(thumbnail).done(function (delRet) {
                    });
                }
                def.resolve(ret);
            });
            return def.promise();
        }


        /**
         * 将资源信息写到本地数据库
         * @param resJson
         */
        _self.add = function (toolItem) {
            var def = $.Deferred();
            // 写入本地数据库
            sqlStr = 'insert into tools(title,exepath,thumbnail) values("'
                + toolItem.title + '","'
                + toolItem.exepath + '","'
                + toolItem.thumbnail + '")';
            console.log(sqlStr);
            _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
                def.resolve(ret);
            });
            return def.promise();

        }

        this.convert2ToolItems = function (queryResultStr) {
            var toolList = new Array();
            if (queryResultStr == "") {
                return toolList;
            }
            var resJson = null;
            try {
                resJson = JSON.parse(queryResultStr);
            }
            catch (e) {
                return toolList;
            }
            var data = resJson.data;
            for (var item in data) {
                var toolItem = new ToolItem();
                toolItem.id = data[item].id;
                toolItem.title = data[item].title;
                toolItem.exepath = data[item].exepath;
                toolItem.thumbnail = data[item].thumbnail;
                toolList.push(toolItem);
            }
            return toolList;
        }


    }

    exports.Instance = new ToolProvider();
})
;