/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-4
 * Time: 上午9:39
 * To change this template use File | Settings | File Templates.
 */
;define(function(require,exports){
    var WidgetBase = require("./widgetbase").WidgetBase;
    var WidgetImg =  require("./widgetimg").WidgetImg;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var playerMgr=require('../hotspot/playerMgr').Instance;
    require('popover');

    function WidgetAudio() {
    }

    WidgetAudio.prototype = new WidgetBase();
    WidgetAudio.prototype.constructor = WidgetAudio;

    function WidgetAudio(widgetType, obj) {
        var _this = this;
        this.player = obj.player;

        this.Title = obj.audio.title;
        this.WidgetType = widgetType;
        this.parse(obj);

        if (obj.audio["src"] != undefined) {
            _this.File = obj.audio["src"];
        }
        _this.showTitleFlag = !!(obj.audio["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.audio["showIconFlag"] == "true");
        _this.description = obj.audio["description"]||"";
        _this.userName = obj.audio["userName"]||"";
        _this.uploadTime = obj.audio["uploadTime"]||"";
        _this.score = obj.audio["score"]|| 0 ;
        _this.userAddressInfo = obj.audio["userAddressInfo"]||"";
        _this.resourceId = obj.audio["resourceId"]||"";
        _this.timestamp=obj.audio["timestamp"] || "";
        var icon = 'assert/static/common/images/icon_24X24/sound.png';
        var playingIcon = 'assert/static/common/images/icon_24X24/sound.png';
        if(json.TP.useDb){
            var src = obj.audio["realPath"];
            var md5 = obj.audio["md5"];
        }else{
            var src = path.join(obj.XamlPath, '../' + _this.File);
        }

        var isPlay = this.player.isPlay(_this.Id);

        this.Content = this.getContent(isPlay ? playingIcon : icon,[this.Left,this.Top,this.Width,this.Height]).attr("state", isPlay ? "playing" : "stop");
        this.Content.click(function (event) {
            // 定位到列表位置
            _this.scrollToPosition(_this);

            if (!_this.getIsEditing()) {
                _this.showIntro(_this);
                // _this.showBubble(this,_this);
                // var extName = path.extname(_this.src);
                // if (extName == '.wma'||_this.PlayAreaWidth<0) {
                //     shellcmd.simpleShellExecute(_this.src);
                // }
                // else {
                //     if (_this.Content.attr('state') == 'playing') {
                //         _this.player.stop();
                //         trace.log('ebook'   , actionType.CloseWidget, {cardId: _this.Id});
                //     } else {
                //         _this.player.play(_this.Id,path.trimPosix(_this.encodeSrc));
                //         trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
                //     }
                // }
            }
            else  {
                _this.showEdit(this,_this);
            }
            event.stopPropagation();
        });

        var audioPlayShowF = function(){
            setTimeout(function(){
                var time= _this.player.getDuration();
                time = Math.floor(time);
                var mi= Math.floor(time/60);
                var se= time%60;
                var timeStr = mi+"'"+se+"'";
                if(isNaN(mi) || isNaN(se)){
                    timeStr = '';
                }
                $(_this.Content.find(".audio_time")[0]).html(timeStr);
                $(_this.Content.find(".audioPro")[0]).attr('max',time);
            },20);
            
            if(_this.Content.find(".rotleft").length > 0){
                $(_this.Content.find(".rotleft")[0]) .css({"-webkit-transform":"translateX(-162px) rotateY(180deg)"});
            }
            $(_this.Content.find(".volet_clos")[0]) .css({"width":"200px"});
            $(_this.Content.find(".volet_clos .wrap")[0]) .css({"width":"200px"});


            $(_this.Content.find(".fermer")[0]).css({"z-index":-1,"background":"#fff"});
            $(_this.Content.find(".ouvrir")[0]).css({"z-index":1001});
            $(_this.Content.find(".volet")[0]) .css({"left":"-18px"});
        };
        var TimeupdateShowF = function(audio_time){
            audio_time = Math.floor(audio_time)
            $(_this.Content.find(".audioPro")[0]).val(audio_time);
        };

        var audioStopShowF = function(){
            $(_this.Content.find(".fermer")[0]).css({"z-index":1001,"background-image":"-webkit-linear-gradient( 90deg, rgb(209,209,209) 0%, rgb(255,255,255) 100%)"});
            $(_this.Content.find(".ouvrir")[0]).css({"z-index":-1});
            $(_this.Content.find(".volet")[0]) .css({"left":"-165px"});

            setTimeout(function(){
                if (_this.Content.attr('state') != 'playing') {
                    if(_this.Content.find(".rotleft").length > 0){
                        $(_this.Content.find(".rotleft")[0]) .css({"-webkit-transform":"translateX(-2px) rotateY(180deg)"});
                    }
                    $(_this.Content.find(".volet_clos")[0]) .css({"width":"40px"});
                    $(_this.Content.find(".volet_clos .wrap")[0]) .css({"width":"40px"});
                }
            },500);
            
            _this.Content.attr('state', 'stop');
            _this.Content.find('img:first').attr('src', _this.icon);
        };

        $(this.Content.find(".fermer")[0]).click(function (event) {
                    if (!_this.getIsEditing()) {
                        var extName = path.extname(_this.src);
                        if (extName == '.wma'||_this.PlayAreaWidth<0) {
                            shellcmd.simpleShellExecute(_this.src);
                        }
                        else {
                            if (_this.Content.attr('state') == 'playing') {
                                // _this.player.pause();
                                // trace.log('ebook'   , actionType.CloseWidget, {cardId: _this.Id});
                            } else {
                                _this.player.play(_this.Id,path.trimPosix(_this.encodeSrc),audioPlayShowF,null,audioStopShowF,TimeupdateShowF);
                                trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
                            }
                        }
                    }
                    
                    else  {
                        if($(_this.Content.find(".user-popover")[1]).css("display")=="block")
                            $(_this.Content.find(".user-popover")[1]).hide();
                        else{
                            $("#bookContainer").find(".user-popover").hide();
                            _this.Content.popover("show", "toolbar");

                        }
                    }
                    event.stopPropagation();
                });



        $(this.Content.find(".ouvrir")[0]).click(function (event) {

                    if (!_this.getIsEditing()) {
                        var extName = path.extname(_this.src);
                        if (extName == '.wma'||_this.PlayAreaWidth<0) {
                            shellcmd.simpleShellExecute(_this.src);
                        }
                        else {
                            if (_this.Content.attr('state') == 'playing') {
                                _this.player.pause();
                                trace.log('ebook'   , actionType.CloseWidget, {cardId: _this.Id});
                            } else {
                                // _this.player.play(_this.Id,path.trimPosix(_this.encodeSrc),audioPlayShowF,null,audioStopShowF,TimeupdateShowF);
                                // trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
                            }
                        }
                    }
                    event.stopPropagation();
                });

        $(this.Content.find(".audioPro")[0]).change(function (event) {
             if (!_this.getIsEditing()) {
                var extName = path.extname(_this.src);
                if (extName == '.wma'||_this.PlayAreaWidth<0) {
                }
                else {
                    _this.player.SetCurrentTime(event.currentTarget.value);
                }
            }

        });

        this.Content.attr('id', _this.Id);
        this.Content.attr('data-uuid', _this.uuid);
        this.attachOnDragEvent();
        if(json.TP.useDb){
            this.encodeSrc= src && src.substring(0, src.lastIndexOf('/')) + '/' + encodeURIComponent(_this.File);
        }else{
            this.encodeSrc= path.join(obj.XamlPath, '../' + encodeURIComponent(_this.File));
        }
        this.src = src;
        this.setTitle();
        this.setPopover();
        this._bindCommands();
    }

    /**
     * @param icon 资源图标
     * @param bound 定位
     * @returns {*|jQuery}
     */
    WidgetAudio.prototype.getContent = function (icon, bound) {
        if (!icon || !bound) return;
        var Obj = this.getUnTransForm();
        var Obj1 = this.getUnTransFormBuble();
        var audioHtmlStr =  '<div class="volet_clos">'+
                                '<a class="ouvrir" aria-hidden="true"></a>'+
                                '<a class="fermer" aria-hidden="true"></a>'+
                                '<div class="wrap">'+
                                    '<div class="volet">'+
                                        '<input type="range" class="audioPro" step="1" value="0" max="100" min="0"> <span class="audio_time">1.30</span>'+
                                    '</div>'+
                               ' </div>'+
                            '</div>';

        var content =
            $("<div class='jxbubble-positioning widget widgeticon ' style='position: absolute;-webkit-transform:matrix("+ Obj.wZoom + ",0,0," + Obj.hZoom+",0,0)'/>")
                .append('<div class="format-bignumber format-number" draggable="true"></div>');
                // .append("<div class='user-popover jxbubble-box jxbubble-left w160' style='display: none;cursor: pointer;-webkit-transform:matrix("+ Obj1.wZoom + ",0,0," + Obj1.hZoom+",0,0);' >" +
                //     "<div class='jxbubble-graphic'>"+
                //     " <em><img id='normal' src='assert/static/common/images/icon_24X24/sound.png'></em><p>{title}</p></div></div>"

        //
        // $("<div class='widgeticon' style='position: absolute;-webkit-transform:matrix(" +
        //     Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)'/>")
        //     .append('<div class="format-bignumber format-number" draggable="true"></div>')
        //     .append("<div class='jxbubble-box jxbubble-left w150' style='display: none' >" +
        //         "<div class='jxbubble-graphic'>"+
        //         " <img id='normal' src='assert/static/common/images/icon_16X16/img_sound.png'><span>{title}</span></div></div>"
        //         // "<img  id='normal' src='" + icon + "' width='" + bound[2] + "' height='" + bound[3] + "'>" +
                // "<img  id='tiny'  src='assert/images/bookicon/ic_black.png'>"
                // "<a id='resourceDelete' ></a></div>"
            // );
            // .css({
            //     'top': bound[0] + 'px',
            //     'left': bound[1] + 'px',
            //     //'width': '40px',// bound[2] + 'px',
            //     //'height': '50px', // bound[3] + 'px'
            // });
            // .append("<div class='fs_closed'  >" + audioHtmlStr +
            //     "<a id='resourceDelete' style='left:35px;'></a></div>");

        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();

        return content;
    }


    WidgetAudio.prototype._bindCommands=function(){
        var _self=this;
        this.player.on(this.Content,'play',function(){
            _self.Content.attr('state', 'playing');
            _self.Content.find('img:first').attr('src', _self.icon);
        });

        this.player.on(this.Content,'pause',function(){
            _self.Content.attr('state', 'stop');
            _self.Content.find('img:first').attr('src', _self.icon);
        });

        this.player.on(this.Content,'ended',function(){
            _self.Content.attr('state', 'stop');
            _self.Content.find('img:first').attr('src', _self.icon);
        });

        this.player.one(this.Content,'play_error',function(event,continuePlay){
            continuePlay&&shellcmd.simpleShellExecute(_self.src);
            _self.PlayAreaWidth=_self.PlayAreaHeight=-1;
        });

    }

    /**
     * 资源查看
     */
    WidgetAudio.prototype.resourcePreview = function(event){
        var _this = this;
        var extName = path.extname(_this.src);
        if (extName == '.wma'||_this.PlayAreaWidth<0) {
            shellcmd.simpleShellExecute(_this.src);
        }
        else {
            shellcmd.simpleShellExecute(_this.src);
            //mini播放器暂时不启用
            // if (_this.Content.attr('state') == 'playing') {
            //     _this.player.stop();
            //     trace.log('ebook', actionType.CloseWidget, {cardId: _this.Id});
            // } else {
            //     _this.player.play(_this.Id,path.trimPosix(_this.encodeSrc));
            //      trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
            // }
        }
//        event.stopPropagation();
    };

    /**
     * 资源编辑
     */
    WidgetAudio.prototype.resourceEditor = function(event){
        alert("当前资源不可编辑")
    };

    WidgetAudio.prototype.getToolBarContent = function () {
        var $content = WidgetImg.prototype.getToolBarContent.call(this);
        var _this = this;

        $content.find("#btnFullScreen").unbind().click(function (event) {
            var extName = path.extname(_this.src);
            if (extName == '.wma'||_this.PlayAreaWidth<0) {
                shellcmd.simpleShellExecute(_this.src);
            }
            else {
                var content = $('<audio id="audioRes" style="width:400px; height:40px;"  controls="controls"/>');
                _this.player.setTempNewPlayer(content);
                _this.showResScanPanel(content);
                _this.player.play(content.attr('id'),"file:///" + _this.encodeSrc);
            }
            event.stopPropagation();
        });
        return $content;
    }

    WidgetAudio.prototype.destroy=function(isDeleteSrc){
        if(this.Content){
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content=this.player=null;
        }
    }


    WidgetAudio.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<audio src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}" title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,
                this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId,this.timestamp);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left=parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,left , top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);

        return xmlResult;
    }

    exports.WidgetAudio = WidgetAudio;
});
