/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:22
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var commonfunc = require('../../../common/commonfunc');
    var model = require('../../model');
    var trace = require('../../trace').Instance;
    var playerMgr = require('../hotspot/playerMgr').Instance;
    var ebookContext = require('../../../app/ebookcontext').Instance;
    var _resTool = require('./../resbar/restool');
    var InfoWidget = require('./infowidget').InfoWidget;
    var classSelector = require('../../../classSelector');
    require('popover');

    function WidgetBase() {
        this.WidgetType = '';
        this.secondWidgetType='';
        this.Id = '';
        this.Width = 0;
        this.Height = 0;
        this.Left = 0;
        this.Top = 0;
        this.File = '';
        this.Title = '';
        this.layout = null;
        this.Content = null;
        this.IsEditing = false;
        this.showTitleFlag = true;
        this.showIconFlag = true;
        this.description = '';
        this.userName = '';
        this.style = {};
        this.src = '';
        this.bookContainer = "";
        this.fileSize = "";
        this.uploadTime = "";
        this.userPhoto = "";
        this.score = "";
        this.thumbnail = "";
        this.infoWidget = null;
        this.userAddressInfo = "";
        this.resourceId = "";
        this.timestamp="";
        //标记位：标记该条数据是经过封装的widget对象
        this._packedFlag = 1;
        this.uuid = "";
        this.unit1 = "";
        this.unit2 = "";
        this.unit3 = "";
        this.unit4 = "";
        this.pageIndex = "";
        this.sort = "";
        this.md5 = "";
    }


    /**
     * 设置编辑状态
     * @param value type bool
     */
    WidgetBase.prototype.setIsEditing = function (value) {
        this.IsEditing = value;
        !this.IsEditing ? this.Content.find("#resourceDelete").hide() : this.Content.find("#resourceDelete").show();
        this.showTitleSet();
        this.resourceIconHide();

        if(this.Content.find(".volet_clos").length > 0){
            var _this = this;
            if(this.IsEditing){
                setTimeout(function(){
                    if(_this.Content.find(".rotleft").length > 0){
                        $(_this.Content.find(".rotleft")[0]) .css({"-webkit-transform":"translateX(-162px) rotateY(180deg)"});
                    }
                    $(_this.Content.find(".volet_clos")[0]) .css({"width":"200px"});
                    $(_this.Content.find(".volet_clos .wrap")[0]) .css({"width":"200px"});
                },550);
            }
            else{
                if(_this.Content.find(".rotleft").length > 0){
                    $(_this.Content.find(".rotleft")[0]) .css({"-webkit-transform":"translateX(-2px) rotateY(180deg)"});
                }
                $(_this.Content.find(".volet_clos")[0]) .css({"width":"40px"});
                $(_this.Content.find(".volet_clos .wrap")[0]) .css({"width":"40px"});
            }

        }

    }

    WidgetBase.prototype.getIsEditing = function () {
        /**
         * 这里判断是否在上下课状态的判断有些问题--在切换页面的时候，现在改用全局变量来判断，todo:wangrui 记得回溯这个方法
         *  modified by linwang5@iflytek.com 2016年12月12日
         */
        return (_isHavingClass != true)?true:false;
        // return this.IsEditing;
    }

    WidgetBase.prototype.trigger = function (evt) {
        (this.Content) && (this.Content.triggerHandler(evt, Array.prototype.slice.call(arguments, 1)));
    }

    WidgetBase.prototype.parse = function (ctrl) {
        var bounds = [0, 0, 0, 0];
        this.Id = ctrl.id;
        if(json.TP.useDb) {
            this._packedFlag = 1;
            this.uuid = ctrl.uuid;
            this.unit1 = ctrl.unit1 || "";
            this.unit2 = ctrl.unit2 || "";
            this.unit3 = ctrl.unit3 || "";
            this.unit4 = ctrl.unit4 || "";
            this.sort = ctrl.sort || "";
            this.pageIndex = ctrl.pageIndex || "";
            this.realPath = ctrl.realPath;
            this.md5 = ctrl.md5 || "";
        }
        if (ctrl.bound != undefined) bounds = ctrl.bound.split(';');
        this.Left = parseFloat(bounds[0]);
        this.Top = parseFloat(bounds[1]);
        this.layout = ctrl.layout;
        //58,60是默认图标的大小,暂时用magic code
        this.Width = 58;
        this.Height = 60;
        this.PlayAreaWidth = parseFloat(bounds[2]);
        this.PlayAreaHeight = parseFloat(bounds[3]);

        this.style = (function () {
            var temp = {};
            if (ctrl.style) {
                var arr = ctrl.style.split(';');
                for (var i = 0, len = arr.length; i < len; ++i) {
                    var val = arr[i].split(':');
                    val && (temp[val[0]] = val[1]);
                }
            }
            else temp.tiny = 'false';
            return temp;
        })();

        this.style.toString = function () {
            var str = [];
            for (var key in this) {
                if (key !== 'toString' && this.hasOwnProperty(key))
                    str.push(key + ":" + this[key]);
            }
            return str.join(';');
        };
    }
// 删除资源
    WidgetBase.prototype.deleteWidget=function(){
        var _self = this;
        this.Content.find("#deleteWidgetBtn").on("click", function (e) {
            var _self=$("#deleteWidgetBtn").parent("widgetIcon");
            var pageItem = _self.Content.data("pagedata");
            if(json.TP.useDb){
                pageItem && pageItem.trigger("widgetDeleted", [_self.uuid]);
            }else{
                pageItem && pageItem.trigger("widgetDeleted", [_self.Id]);
            }
            e.stopPropagation();
        });
    }

    WidgetBase.prototype.bindEvent = function () {
        var _self = this;
        this.Content.find("#resourceDelete").on("click", function (e) {
            $.Zebra_Dialog("您确认要删除该资源吗？", {
                'type': 'question',
                'title': "提示",
                'buttons': ["取消","确定"],
                'onClose': function (a){
                    if(a == "确定"){
                        var pageItem = _self.Content.data("pagedata");
                        if(json.TP.useDb){
                            pageItem && pageItem.trigger("widgetDeleted", [_self.uuid]);
                        }else{
                            pageItem && pageItem.trigger("widgetDeleted", [_self.Id]);
                        }
                        e.stopPropagation();
                    }
                }
            });
            //var pageItem = _self.Content.data("pagedata");
            //pageItem && pageItem.trigger("widgetDeleted", [_self.Id]);
            //e.stopPropagation();
            return false;
        });

        this.Content.find("#resRDEdit").on("click", function (e) {
           //Caution : 此处第二个参数是为ppt专用，对其他调用应该木有影响
            _self.resourceEditor(e,'edit');

            e.stopPropagation();
            return false;
        });

        _self.showTitleSet();
    }


    WidgetBase.prototype.attachOnDragEvent = function () {
        var _self = this;
        var startPoint, initPoint, cloneContent;
        var bookContainer;
        // if( _self.Content.find('img').length > 0){
        //     _self.Content.find('img').attr('draggable', true);
        // }
        //以前通过资源图片控制拖动，已改为气泡
        if( _self.Content.find('.format-number').length > 0){
            _self.Content.find('.format-number').attr('draggable', true);
            _self.Content.find('.format-number').draggable({               //设置可拖动
                containment: $("#bookContainer"),
                handle: ".format-number"
            });
        }
        // else if( _self.Content.find('.fermer').length > 0){
        //     _self.Content.find('.fermer').attr('draggable', true);
        // }
            //这个fermer不知道是什么鬼，先改着，有问题再说吧
        else if( _self.Content.find('.format-number').length > 0){
            _self.Content.find('.format-number').attr('draggable', true);
        }

        _self.Content.on('dragstart', function (event) {
            event = event.originalEvent;
            if ($(_self.Content.find(".user-popover")[1]).css("display") == "block" && _self.Content.find("#normal")[0] == event.target)
                $(_self.Content.find(".user-popover")[1]).hide();
            bookContainer = null;
            if (_self.getIsEditing()) {
                _self.Content.trigger("unSwipable").trigger("unDraggable"); //禁止滑动防止拖动过快引起翻页
                bookContainer = $('#bookContainer');
                var bookContainerOffset = bookContainer.offset(),
                    contentOffset = _self.Content.offset();
                //修正页面widget xaml中bound为负值或者0时，页面显示位置与实际位置不符 - start
                var fixContent = $(_self.Content).position();
                if(fixContent.left < 0){
                    contentOffset.left = contentOffset.left - fixContent.left;
                }
                if(fixContent.top < 0){
                    contentOffset.top = contentOffset.top - fixContent.top;
                }
                //修正页面widget xaml中bound为负值或者0时，页面显示位置与实际位置不符 - end
                startPoint = new model.Point(event.pageX, event.pageY);
                initPoint = new model.Point(contentOffset.left - bookContainerOffset.left, contentOffset.top - bookContainerOffset.top);
               //这个是打错了？？？ renderWidgetsIcon
            }
            else event.dataTransfer.effectAllowed = 'none';

            //由于drag时会有一个阴影，暂时把它们都设为一个很小的图片，相当于没有阴影
            var dragIcon = document.createElement('img');
            dragIcon.src = 'assert/images/book_bot.png';
            event.dataTransfer.setDragImage(dragIcon, 0, 0);

            event.stopPropagation();
        });

        this.Content.on('drag', function () {
            $(".user-popover").hide();
            if (!bookContainer) return;
            var isDoublePage = bookContainer.find('.viewdom').find('.pageItem').length === 2;
            var srcPageIndex, content = _self.Content;
            if (!cloneContent) {
                cloneContent = _self.Content.clone().removeAttr('id');
                var parentScale = _self.getTransformMatrix(_self.Content.parent());
                var viewDomScale = _self.getTransformMatrix($('.viewdom'));
                var contentScale = _self.getTransformMatrix(_self.Content);
                var maxLeft = bookContainer.width() / 2;

                parentScale[0] *= viewDomScale[0], parentScale[3] *= viewDomScale[3];
                contentScale[0] *= parentScale[0], contentScale[3] *= parentScale[3];
                contentScale[4] = contentScale[5] = 0;
                cloneContent.css({
                    '-webkit-transform': 'matrix(' + contentScale.join(',') + ')',
                    'transform-origin': '0% 0%',
                    opacity: 0.7
                });
                cloneContent.on('dragover', function () {
                    event.preventDefault();
                });
                cloneContent.on('drop', function () {
                    if (_self.Content) {
                        var pageItem = content.data('pagedata');
                        var endPoint = new model.Point(event.pageX, event.pageY);
                        //需要判断是否跨页
                        if (isDoublePage) {
                            var pageOffset = 0, width = content.width() * parentScale[0];
                            var curLeft = event.pageX - startPoint.x + initPoint.x;

                            //判断widget初始在哪个页面
                            if (initPoint.x < maxLeft) srcPageIndex = 1;
                            else srcPageIndex = 2;

                            //判断当前widget在哪一个页面
                            if (srcPageIndex === 1 && curLeft >= maxLeft) {
                                pageOffset = 1;
                                startPoint.x += maxLeft * viewDomScale[0];
                            }
                            else if (srcPageIndex === 2 && curLeft + width <= maxLeft) {
                                pageOffset = -1;
                                endPoint.x += maxLeft * viewDomScale[0];
                            }
                            else pageOffset = 0;
                            if (pageOffset) {
                                cloneContent && cloneContent.remove();
                                cloneContent = null;
                                _self.Content.trigger("swipable").trigger("draggable"); //重新设置滑动防止拖动过快引起翻页
                            }
                        }
                        var srcPos = [_self.Content[0].offsetLeft, _self.Content[0].offsetTop];
                        var left = (endPoint.x - startPoint.x) / parentScale[0] + srcPos[0],
                            top = (endPoint.y - startPoint.y) / parentScale[3] + srcPos[1];
                        if (left < 30) left = 30;//设置距离左边的最小距离，防止距离太小
                        var curPos = [left, top];
                        if (json.TP.useDb) {
                            pageItem.trigger('insertWidget', [pageOffset, _self.uuid, srcPos, curPos]);
                        } else {
                            pageItem.trigger('insertWidget', [pageOffset, _self.Id, srcPos, curPos]);
                        }
                    } else {
                        cloneContent && cloneContent.remove();
                        cloneContent = null;
                    }
                });
                cloneContent.appendTo(bookContainer);
            }

            //设置拖动时的阴影
            var left = event.pageX - startPoint.x + initPoint.x, top = event.pageY - startPoint.y + initPoint.y;
            cloneContent && cloneContent.css({
                left: left,
                top: top
            });
        });

        this.Content.on('dragend', function () {
            if (!bookContainer) return;
            cloneContent && cloneContent.remove();
            cloneContent = null;
            _self.Content.trigger("draggable").trigger("swipable"); //重新设置滑动防止拖动过快引起翻页
        });

        this.Content.on('reposition', function (event, pos) {
            if (pos) _self.isModify = true;
        });

        //阻止事件冒泡,防止拖动
        this.Content.on('mousedown', function (event) {
            event.stopPropagation();
        });
    }

    /**
     *  完成状态下查看资源
     * @param content  资源内容
     */
    WidgetBase.prototype.showResScanPanel = function (content) {
        if (!content) return;

        var resDialog = $.Zebra_Dialog(content, {
            'type': false,
            'title': this.Title,
            'buttons': false
        });

        correctToBaseResolution(resDialog.dialog, {width: 1366, height: 768, keepScale: true});
        resDialog.dialog.draggable({
            containment: $("#bookContainer"),
            handle: ".ZebraDialog_Title"
        });

        return resDialog.dialog;
    }

    /**
     * 设置widget上工具栏的内容
     * @returns {*|jQuery|HTMLElement}
     */
    WidgetBase.prototype.getToolBarContent = function () {
        var _self = this;
        <!--/资源属性框-->
        (!_self.infoWidget) && (_self.infoWidget = new InfoWidget(),
            _self.infoWidget.init(null, null, null, _self));

        return _self.infoWidget.getDom();
    }

    /**
     * 修改标题
     */
    WidgetBase.prototype.reSetTitle = function (title) {
        this.Content.find(".widgetTitle").html(title);
    };

    /**
     * 资源查看
     */
    WidgetBase.prototype.resourcePreview = function (event) {
//        alert(32)
    };
    /**
     * 资源编辑
     */
    WidgetBase.prototype.resourceEditor = function (event, mode) {

    };

    /**
     * 资源标题设置
     */
    WidgetBase.prototype.showTitleSet = function () {
        this.Content.popover((this.showTitleFlag == "false" || !this.showTitleFlag) ? 'hide' : 'show', 'title');
        $(this.Content.find("a[name='resourceItem']")[2]).attr("title", this.showTitleFlag ? "名称隐藏" : "名称显示");
        $(this.Content.find("a[name='resourceItem']")[2]).html(this.showTitleFlag ? "名称隐藏" : "名称显示");
    };

    /**
     * 图标隐藏
     */
    WidgetBase.prototype.resourceIconHide = function () {
        var _self = this;
        _self.style.tiny = this.showIconFlag ? 'false' : 'true';
        //当前图标显示
        if (_self.style.tiny === 'true') {
            _self.Content.find("#normal").css('opacity', '1');
            _self.Content.find("#tiny").hide();
            _self.Content.find("#normal").show();
            _self.style.tiny = 'false';
        }
        //当前图标隐藏
        else if (_self.style.tiny === 'false') {
            //完成状态下虚化
            if (!this.IsEditing) {
                _self.Content.find("#tiny").show();
                _self.Content.find("#normal").hide();
                _self.style.tiny = 'true';
            }
            //编辑状态下变成一条线
            else {
                _self.Content.find("#normal").css('opacity', '0.3');
                _self.Content.find("#tiny").hide();
                _self.Content.find("#normal").show();
                _self.style.tiny = 'false';
            }
        }
        _self.isModify = true;

        this.Content && $(this.Content.find("a[name='resourceItem']")[3]).attr("title", this.showIconFlag ? "图标显示" : "图标隐藏");
        this.Content && $(this.Content.find("a[name='resourceItem']")[3]).text(this.showIconFlag ? "图标显示" : "图标隐藏");
    };

    /**
     * 设置widget的标题
     */
    WidgetBase.prototype.getTitleContent = function (title) {
        if (!title) title = this.Title;
        if (title.length > 8) title = title.substr(0, 5) + "..." + title.substr(title.length - 3, 3);
        return $('<div><p class="widgetTitle" style="display:none;font-size: 18px;text-align: center;width: 150px;font-weight: bold">' + title + '</p></div>');
    }

    WidgetBase.prototype.getIntroContent = function () {
        var _self = this;
        var fileName;
        var fileExt;
        if(_self.File){
            var parsedFile = _self.parseFileName(_self.File);
            var fileName = parsedFile.fileName;
            var fileExt = parsedFile.fileExt;
        }
        if(!fileName){
            fileName = _self.File;
            fileExt = path.extname(_self.File).toLowerCase() || '';
        }
        var resourceProprety = '';
        var icon = 'assert/static/common/images/icon_24X24/default.png';
        try {
            if (_self.WidgetType) {
                switch (_self.WidgetType) {
                    case define.WidgetType.Img:
                        resourceProprety = 'img';
                        icon = 'assert/static/common/images/icon_24X24/image.png';
                        break;
                    case define.WidgetType.Video:
                        resourceProprety = 'video';
                        icon = 'assert/static/common/images/icon_24X24/movie.png';
                        break;
                    case define.WidgetType.Flash:
                        resourceProprety = 'flash';
                        icon = 'assert/images/bookicon/p_ic.png';
                        break;
                    case define.WidgetType.Gallery:
                        resourceProprety = 'file';
                    case define.WidgetType.Evaluate:
                        resourceProprety = 'file';
                    case define.WidgetType.Choice:
                        resourceProprety = 'file';
                    case define.WidgetType.OnlineRes:
                        resourceProprety = 'file';
                    case define.WidgetType.Proc3rd:
                        resourceProprety = 'file';
                        var iconDict = {
                            "ppt": ["ppt", "pptx", "pps", "ppsx"],
                            "word": ["doc", "docx"],
                            "excel": ["xls", "xlsx"],
                            "txt": ["txt"],
                            "pdf": ["pdf"]
                        };
                        for (var key in iconDict) {
                            if(-1 != $.inArray(fileExt,iconDict[key])){
                                icon = "assert/static/common/images/icon_24X24/" + key + ".png";
                                break;
                            }
                        }
                        break;
                    case define.WidgetType.Audio:
                        resourceProprety = 'audio';
                        if (_self.player && _self.player.isPlay(_self.Id)) {
                            icon = 'assert/static/common/images/icon_24X24/sound.png';
                        } else {
                            icon = 'assert/static/common/images/icon_24X24/sound.png';
                        }
                        break;
                    case define.WidgetType.Note:
                        resourceProprety = 'note';
                        icon = 'assert/static/common/images/icon_24X24/default.png';
                        break;
                    case define.WidgetType.FadeCurtain:
                        resourceProprety = 'fadeCurtain';
                        break;
                    case define.WidgetType.Icw :
                        resourceProprety = 'icw';
                        icon = 'assert/static/common/images/icon_24X24/default.png';
                        break;
                    case define.WidgetType.ImgPaint :
                        resourceProprety = 'imgPaint';
                        break;
                    case define.WidgetType.Vote:
                        resourceProprety = 'vote';
                        break;
                    case define.WidgetType.InteractiveCard:
                        resourceProprety = 'file';
                        var typeUrl;
                        var type = _self.obj && _self.obj.type || '';
                        switch (type) {
                            case "galary":
                                typeUrl = "gallery";
                                break;
                            case "cneval":
                                typeUrl = "cneval";
                                break;
                            case "eneval":
                                typeUrl = "eneval";
                                break;
                            case "exercise":
                                typeUrl = "exercise";
                                break;
                            case "situdlg":
                                typeUrl = "situdlg";
                                break;
                            case "flipcard":
                                typeUrl = "flipcard";
                                break;
                            case "history":
                                typeUrl = "history";
                                break;
                            case "matchcard":
                                typeUrl = "matchcard";
                                break;
                            case "mathequation":
                                typeUrl = "mathequation";
                                break;
                            case "pickcard":
                                typeUrl = "pickcard";
                                break;
                            case "onlineexam":
                                typeUrl = "onlineexam";
                                break;
                            case "mindmap":
                                typeUrl = "mindmap";
                                break;
                            case "onlinesupple":
                                typeUrl = "onlinesupple";
                                break;
                            default:
                                typeUrl = "gallery";
                                break;
                        }
                        icon = "assert/static/common/images/interactivecard/" + typeUrl + ".png";
                        break;
                    default:
                        resourceProprety = widget.widgetType;
                        break;
                }
            }
        }catch(e){
            console.error(e);
        }

        var dom = $('<div class="jxbubble-box w160" style="cursor: pointer;">' +
            '<div class="jxbubble-graphic">' +
            '<em><img id="normal" src="' + icon +
            '"></em><p>' + fileName +
            '</p>' +
            '</div>' +
            '</div>');
        dom.on('click',function(){
            switch (_self.WidgetType){
                case "audio":
                    shellcmd.simpleShellExecute(_self.src);
                    break;
                default:
                    _self.resourcePreview();
                    break;
            }
        });
        return dom;
    }

    /**
     *设置widget工具栏
     */
    WidgetBase.prototype.setPopover = function () {
        var _self = this;
        _self.bindEvent();
        var element = this.Content;
        var toolBarContent = _self.getToolBarContent();
        var titleContent = _self.getTitleContent();
        titleContent && element.popover({position: 'bottom', content: titleContent, wrapper: element, popoverId: "title", zIndexOwner: 2,hideOnHTMLClick: false});

        var introContent = _self.getIntroContent();
        if(introContent){
            element.css('z-index',1);
            element.popover({position: 'bottom', content: introContent, wrapper: element, popoverId: "intro", hideOnHTMLClick: false});
            element.popover('setOption', 'intro', {
                beforeShow: function (popover) {
                    if (!popover) return;
                    //恢复原widget大小
                    var default_obj = _self.getUnTransForm();
                    element.css("-webkit-transform", "matrix(" + default_obj.wZoom + ", 0, 0, " + default_obj.hZoom + ", 0, 0)");

                    //设置全局widget之前，将之前设置的widget z-index恢复默认值
                    if(app_global_curWidget && app_global_curWidget.Content) {
                        app_global_curWidget.Content.css('z-index', 0);
                    }
                    setGlobalCurWidget(_self);
                    var pageTrans = _self.getTransformMatrix();
                    var widgetTrans = _self.getTransformMatrix(element);

                    var Obj = {
                        wZoom: 1 / (pageTrans[0] * widgetTrans[0]),
                        hZoom: 1 / (pageTrans[3] * widgetTrans[3])
                    }
                    introContent.css("-webkit-transform", "matrix(" + Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)");
                    element.popover('setOption', 'intro', {position: 'right'});
                    introContent.show();

                    var _type = app_global_bookContainer.getPageViewType();

                    //对1024*768分辨率做特殊处理
                    var res_1024 = (Config.Width >1000 && Config.Width < 1050 && Config.Height > 700 && Config.Height < 780);
                    if(res_1024){
                        toolBarContent.css("-webkit-transform", "matrix(" + 0.9 + ",0,0," + 0.9 + ",0,0)");
                    }
                    var resEditBox =  _self.Content.find('.jxbubble-box');
                    var resEditBoxHeight = 369;
                    var Xflag = parseInt($("#bookContainer").css("width"))/2 -
                        ( parseInt(element.css('left'))/Obj.wZoom/widgetTrans[0] + parseInt(resEditBox.width()) + parseInt(element.css('width')));
                    if(res_1024){
                        var iconLeft = parseInt(element.css('left'))/Obj.wZoom/widgetTrans[0];
                        if(iconLeft > 160 ){
                            resEditBox.css({'marginLeft':-160 + "px"});
                            resEditBox.removeClass("jxbubble-left").removeClass('jxbubble-right').addClass('jxbubble-right');
                            element.popover('setOption', 'intro', {position: 'left'});
                        }else{
                            resEditBox.css({'marginLeft': 30 + "px"});
                            element.popover('setOption', 'intro', {position: 'right'});
                            resEditBox.removeClass("jxbubble-left").removeClass('jxbubble-right').addClass('jxbubble-left');
                        }
                    }else{
                        if (Xflag < 0) {
                            resEditBox.css({'marginLeft':-160 + "px"});
                            element.popover('setOption', 'intro', {position: 'left'});
                            resEditBox.removeClass("jxbubble-left").removeClass('jxbubble-right').addClass('jxbubble-right');
                        } else {
                            resEditBox.css({'marginLeft': 30 + "px"});
                            element.popover('setOption', 'intro', {position: 'right'});
                            resEditBox.removeClass("jxbubble-left").removeClass('jxbubble-right').addClass('jxbubble-left');
                        }
                    }
                }
            });
        }
        if (toolBarContent) {
            element.css('z-index',1);
            element.popover({position: 'left', content: toolBarContent, wrapper: element, popoverId: "toolbar", zIndexOwner: 2, hideOnHTMLClick: false});

            element.popover('setOption', 'toolbar', {
                beforeShow: function (popover) {
                    if (!popover) return;
                    //恢复原widget大小
                    var default_obj = _self.getUnTransForm();
                    element.css("-webkit-transform", "matrix(" + default_obj.wZoom + ", 0, 0, " + default_obj.hZoom + ", 0, 0)");
                    //设置全局widget之前，将之前设置的widget z-index恢复默认值
                    if(app_global_curWidget && app_global_curWidget.Content) {
                        app_global_curWidget.Content.css('z-index', 0);

                        var curDom = $(app_global_curWidget.Content);
                        var saveinfo = curDom.find("button[name='saveinfo']");
                        if($(saveinfo.parent()).css("display") == "block"){
                            var title = app_global_curWidget.Title || '';
                            var _showTitle = title.length > 10 ? title.substr(0, 10) + "···" : title;
                            var _description = (app_global_curWidget.description == "") ? '暂无资源描述' : app_global_curWidget.description;
                            // 恢复原样
                            var editinfo = curDom.find("button[name='editinfo']");
                            var atitle = curDom.find("p[name='restile']");
                            var inputtitle = curDom.find("input[name='restile']");
                            var adescription = curDom.find("span[name='adescription']");
                            var inputdescription = curDom.find("p[name='inputdescription']");

                            saveinfo.parent().hide();
                            editinfo.parent().show();
                            var _showTitle = title.length > 10 ? title.substr(0, 10) + "···" : title;
                            atitle.text(_showTitle);
                            atitle.attr("title", title);
                            atitle.show();
                            inputtitle.val(title).hide;
                            inputtitle.parent().hide();

                            adescription.text(_description);
                            adescription.attr("title", _description);
                            adescription.parent().show();
                            inputdescription.find("input").val(_description).hide();
                            inputdescription.hide();
                        }
                    }
                    setGlobalCurWidget(_self);
                    var pageTrans = _self.getTransformMatrix();
                    var widgetTrans = _self.getTransformMatrix(element);

                    _self.infoWidget && _self.infoWidget.showTabContainer();

                    var Obj = {
                        wZoom: 1 / (pageTrans[0] * widgetTrans[0]),
                        hZoom: 1 / (pageTrans[3] * widgetTrans[3])
                    };
                    toolBarContent.css("-webkit-transform", "matrix(" + Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)");

                    var _type = app_global_bookContainer.getPageViewType();

                    //对1024*768分辨率做特殊处理
                    var res_1024 = (Config.Width >1000 && Config.Width < 1050 && Config.Height > 700 && Config.Height < 780);
                    if(res_1024){
                        toolBarContent.css("-webkit-transform", "matrix(" + 0.9 + ",0,0," + 0.9 + ",0,0)");
                    }
                    var resEditBox =  _self.Content.find('.J_res_editor_box');
                    var resEditBoxHeight = 369;
                    var Xflag = parseInt($("#bookContainer").css("width"))/2 -
                        ( parseInt(element.css('left'))/Obj.wZoom/widgetTrans[0] + parseInt(resEditBox.width()) + parseInt(element.css('width')));//parseInt(popover.width())/2 * widgetTrans[3]) * pageTrans[3];
                    var Yflag = parseInt($("#bookContainer").css("height")) -
                        ( parseInt(element.css('top'))/Obj.hZoom/widgetTrans[3] + parseInt(element.height())/Obj.hZoom/2 + resEditBoxHeight/2);
                    var YYflag = parseInt(element.css('top'))/Obj.hZoom/widgetTrans[3] - resEditBoxHeight/2 - parseInt(element.height())/Obj.hZoom/2;
                   /*if (_type == 4) {
                     //   Yflag = parseInt($("#bookContainer").css("height")) - parseInt(element.css('top')) - parseInt(popover.height()) * Obj.wZoom;
                    }*/
                    if(res_1024){
                        var iconLeft = parseInt(element.css('left'))/Obj.wZoom/widgetTrans[0];
                        if(iconLeft > 164 ){
                            resEditBox.css({'marginLeft':-186 + "px"});

                            //  resEditBox.find("i[name='arrow']").removeClass("ic_arrowleft").addClass("ic_arrowright");
                            element.popover('setOption', 'toolbar', {position: 'left'});
                            element.find(".newpop").css("-webkit-animation", "popbottom 0.5s");
                            element.find(".newpop").css("marginTop", "80px");
                        }else{
                            resEditBox.css({'marginLeft': -25 + "px"});
                            //   resEditBox.find("i[name='arrow']").addClass("ic_arrowleft").removeClass("ic_arrowright")
                            element.popover('setOption', 'toolbar', {position: 'right'});
                            element.find(".newpop").css("-webkit-animation", "poptop 0.5s");
                        }
                    }else{
                        if (Xflag < -10) {
                            // resEditBox.css({'marginLeft':-275 + "px"});
                            resEditBox.css({'marginLeft':-311 + "px"});

                            //  resEditBox.find("i[name='arrow']").removeClass("ic_arrowleft").addClass("ic_arrowright");
                            element.popover('setOption', 'toolbar', {position: 'left'});
                            element.find(".newpop").css("-webkit-animation", "popbottom 0.5s");
                            element.find(".newpop").css("marginTop", "80px");
                        }
                        else {
                            resEditBox.css({'marginLeft': 55 + "px"});
                            //   resEditBox.find("i[name='arrow']").addClass("ic_arrowleft").removeClass("ic_arrowright")
                            element.popover('setOption', 'toolbar', {position: 'right'});
                            element.find(".newpop").css("-webkit-animation", "poptop 0.5s");
                        }
                    }


                 //   return;

                    // resEditBox.find("i[name='arrow']").css("marginTop","-8px");
                    if( Yflag< 0){
                     //   var _marginTop = parseInt(resEditBox.find("i[name='arrow']").css("marginTop"));
                     //    resEditBox.css({"marginTop": -160+ "px"});
                        resEditBox.css({ "marginTop":  -160 + Yflag - 55 + "px"});
                      //  resEditBox.find("i[name='arrow']").css("marginTop", _marginTop - Yflag - 40 +"px");
                    }else{
                        if(  YYflag< 0){
                    //        var _marginTop = parseInt(resEditBox.find("i[name='arrow']").css("marginTop"));
                            resEditBox.css({"marginTop": (-160 - YYflag+ 20) *Obj.hZoom + 5  +"px"});
                  //          resEditBox.find("i[name='arrow']").css("marginTop",_marginTop + YYflag + 20 +"px");
                        }else{
                            resEditBox.css({"marginTop": -160+ "px"});
                        }
                    }
                 //   resEditBox.css({"marginTop": -160+ "px"});
                    if(_type==3) {
                        resEditBox.css({"marginTop": -160+ "px"});
                        //resEditBox.find("i[name='arrow']").css("marginTop","-8px");
                    }

                }
            });
        }
        this.Content.find("#btnTiny").prop('checked', (this.style && this.style.tiny !== 'true' ) ? false : true);
    }

    /**
     * 增加title为了在widget下显示
     * @param {string=} src
     */
    WidgetBase.prototype.setTitle = function (src) {
        if (src == undefined) src = this.src;
        if (!this.Title && src){
           this.Title = path.filename(src);
           var extName = path.extname(this.Title);
           this.Title = this.Title.replace(extName, "");
        } 
        
        /*var replaceStr = "";
        if (extName && (!/.*[\u4e00-\u9fa5]+.*$/.test(extName))) {
            try {
                replaceStr = new RegExp(extName, "g");
            }
            catch (e) {
                replaceStr = extName;
            }
            finally {
                this.Title = this.Title.replace(replaceStr.source, "");
            }
        }*/
        
    }

    /**
     * 获得放缩矩阵
     * @param {object=} page
     * @return {Array}
     */
    WidgetBase.prototype.getTransformMatrix = function (page) {
        return ebookContext.getTransformMatrix(page);
    };

    WidgetBase.prototype.widgetExecute = function (executePath) {
        if (!executePath) return;
        shellcmd[(this.WidgetType === define.WidgetType.Video || this.WidgetType === define.WidgetType.Audio) ? 'simpleShellExecute' : 'shellExecute'](executePath)
            .done(function (ret) {
                if (parseInt(ret) < 1) {
                    $.Zebra_Dialog(AppTips.ShellExecuteFailed, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                }
            });
    }

    /**
     * @param icon 资源图标
     * @param bound 定位
     * @returns {*|jQuery}
     */
    WidgetBase.prototype.getContent = function (icon, bound) {
        if (!icon || !bound) return;
        var Obj = this.getUnTransForm();
        var Obj1 = this.getUnTransFormBuble();
        var content = $('<div class="jxbubble-positioning widgeticon" style="position: absolute;-webkit-transform:matrix('+ Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0"+ ');"></div>')
            .append('<div class="format-bignumber format-number" draggable="true"></div>')
            .css({
                'top': bound[0] + 'px',
                'left': bound[1] + 'px'
                // 'width': bound[2] + 'px',
                // 'height': bound[3] + 'px'
            });


        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();

        return content;
    }

    //截取字符串
    WidgetBase.prototype.getnameStr=function(fileName){
        var nameString="";
        var str=fileName.split(" ");
        if(str.length>0){
            for(var i=0;i<str.length;i++){
                nameString=nameString+str[i];
            }
        }
        return nameString;

    }

    //完成状态
    // 该方法废弃 -by xinfang3
    WidgetBase.prototype.showBubble=function(thisWidget,widgetType){
        var _this=this;
        var showBubble= $(thisWidget).find(".jxbubble-box").is(":visible");
        if(showBubble){
            widgetType.resourcePreview();
            $(".jxbubble-box").hide();
        }
        else{
            $(".jxbubble-box").hide();
            $(thisWidget).find(".jxbubble-graphic p").text(widgetType.Title);
             $(thisWidget).append("<span id='testLength' style='font-size: 14px;display: none'></span>");
          var nameString= _this.getnameStr(widgetType.Title);
            $("#testLength").text(nameString);
           var bubbleWidth= $("#testLength").width();
            $("#testLength").remove();

            var dubblePage=$(".leftPageWrapper");
            var  x=$(thisWidget).position().left;
            var showDirection = "L";
            if(dubblePage){
                if(x>307){//当前气泡在右边
                    showDirection = "R";
                    var bubbleLeft= -238;
                    $(thisWidget).find(".jxbubble-box").removeClass("jxbubble-left").addClass("jxbubble-right").css("left",bubbleLeft);
                }else{//当前气泡显示在左边
                    showDirection = "L";
                    $(thisWidget).find(".jxbubble-box").removeClass("jxbubble-right").addClass("jxbubble-left").css("left",bubbleLeft);
                    $(thisWidget).find(".jxbubble-box").css("left",34);
                }
            }else {
                if(x>613){
                    showDirection = "R";
                    var bubbleLeft= -251;
                    $(thisWidget).find(".jxbubble-box").removeClass("jxbubble-left").addClass("jxbubble-right").css("left",bubbleLeft);
                }else{//当前气泡显示在左边
                    showDirection = "L";
                    $(thisWidget).find(".jxbubble-box").removeClass("jxbubble-right").addClass("jxbubble-left").css("left",bubbleLeft);
                    $(thisWidget).find(".jxbubble-box").css("left",34);
                }

            }
            $(thisWidget).find(".jxbubble-box").show();//完成状态下点击资源图标出现小弹框
            var bubbleWidth = $(thisWidget).find(".jxbubble-graphic p").width();
            if (bubbleWidth < 115) {
                $(thisWidget).find(".jxbubble-box").css("width", 160 - 115 + bubbleWidth + "px");
            }
            if(showDirection == "L") {
                /*$(thisWidget).find(".jxbubble-box").css("width")*/
            }
            else{
                $(thisWidget).find(".jxbubble-box").css("left",-238+115-bubbleWidth+"px");
            }




        }
    }

    //编辑状态
    WidgetBase.prototype.showEdit=function(thisWidget,widget){
        if(widget && widget.Content){
            // 关闭全局widget弹窗
            if(app_global_curWidget && app_global_curWidget.Content && app_global_curWidget.uuid != widget.uuid){
                app_global_curWidget.Content.popover('hide','toolbar');
            }

            if(widget.Content.popover('isShow','toolbar')){
                widget.Content.popover("hide", "toolbar");
            }else{
                // 获取删除按钮实时状态
                if($(document).data("isTeachingPackage")){
                    widget.Content.find("button[name=deletefile]").show();
                }else{
                    widget.Content.find("button[name=deletefile]").hide();
                }
                widget.Content.popover("show", "toolbar");
            }
        }
    }

    WidgetBase.prototype.showIntro=function(widget){
        if(widget && widget.Content){
            // 关闭全局widget弹窗
            if(app_global_curWidget && app_global_curWidget.Content && app_global_curWidget.uuid != widget.uuid){
                app_global_curWidget.Content.popover('hide','intro');
            }

            if(widget.Content.popover('isShow','intro')){
                widget.Content.popover("hide", "intro");
            }else{
                //获取实时文件名称
                var title = widget.Title; //title为不包含后缀名的数据
                //title解析
                var parseTitle = _resTool.parseFileName(title);
                if(parseTitle.fileName && parseTitle.fileName != ""){
                    title = parseTitle.fileName;
                }else{
                    var fileNameParse = _resTool.parseFileName(widget.File);
                    //如果title为空，则将fileName赋值给title
                    title = fileNameParse.fileName;
                }
                widget.Content.find(".jxbubble-graphic p").text(title);
                widget.Content.popover("show", "intro");
            }
        }
    }



//获取当前资源坐标
    WidgetBase.prototype.getPosition=function(e){
        var widgetPos={
            left : 1110-e.originalEvent.clientX,
            top : e.originalEvent.clientY
        }


    }

    //上传至网盘
    WidgetBase.prototype.upload = function () {
        var _this = this;
        if (ebookContext.getUser().getName() != AppCfg.defaultuser) {
            var bookCode = app_global_bookContainer.bookCode;
            var unitCode = app_global_bookContainer.getCurrUnit();
            var courseCode = app_global_bookContainer.getCurrCourse();
            var thumbnailWidth = "185";
            var thumbnailHeight = "185";
            var aliasName = _this.Title;
            var obj = {
                localPath: path.trimPosix(this.src),
                webPath: (AppRemoteSvcCfg.uploadWebPath + "&access_token=" + ebookContext.getUser().getDynamicToken() )
                    .format(ebookContext.getUser().getUid(), "yun_beike",
                        encodeURI(_this.Title), bookCode, unitCode, courseCode, thumbnailWidth, thumbnailHeight, encodeURI(aliasName))
            };
            if (path.extname(obj.localPath) == ''){
                obj.localPath += '.icw';
            }
            shellcmd.uplaodByDll(obj.localPath, obj.webPath);
        }
        else {
            app_global_loginMgr.show();
        }
    }

    /**
     * 通过edc接口将文件上传到网盘 - 云备课目录下（原上传方法upload()废弃）
     * by xinfang
     */
    WidgetBase.prototype.uploadByEdc = function () {
        var _this = this;
        var fileFullPath = path.trimPosix(this.src);
        if (ebookContext.getUser().getName() != AppCfg.defaultuser) {
            var user = ebookContext.getUser();
            var param_core_user = {
                'key':"id",
                'value':user._uid
            };
            edcService.Instance().core_user_get(param_core_user).done(function(ret) {
                if (ret.code == 0) {
                    var _user_info = ret.data || {};
                    var _openId = _user_info.id || "";

                    var parseFileName = _resTool.parseFileName(fileFullPath);
                    var fileNameWidthExt = parseFileName.file;
                    var fileName = parseFileName.fileName;
                    var fileExt = parseFileName.fileExt;
                    var edc_file_prepare_request = {
                        openId : _openId, // 用户登录返回的openId
                        extension : fileExt // 文件的后缀名
                        // chunks : 1, // 分片上传分片数
                        // platForm : platForm, // 文件服务使用的appname
                        // callbackMethod : "", // 文件上传完回调方法
                        // callbackUrl : "", // 文件上传完回调地址
                        // callbackParams : "", // 文件上传完回调参数
                        // callbackProtocol : "" // 文件上传完回调方法
                    };
                    $.when(_resTool.calcMd5(fileFullPath), edcService.Instance().pan_file_resource_prepare(edc_file_prepare_request)).done(function(ret1,ret2){
                        if(!ret1) {
                            console.log("文件md5计算失败");
                            var tips = tipsDialog({
                                "id": "uploadToBeike" + new Date().getTime(),
                                "content": "error-md5"
                            });
                            return 0;
                        }
                        if(!ret2 || ret2.code != 0) {
                            console.log("文件预上传失败");
                            var tips = tipsDialog({
                                "id": "uploadToBeike" + new Date().getTime(),
                                "content": "error-prepare"
                            });
                            return 0;
                        }
                        var pageIndex = app_global_bookContainer.getPageIndex();
                        var pageMeta = app_global_bookContainer.getPageMetadata(pageIndex) || {};
                        var bookMeta = app_global_bookContainer.bookMetaInfo || {};
                        var uploadChunks = ret2.data.prepareInfo.uploads;

                        //完成文件上传参数
                        var edc_file_upload_complete_request = {
                            platForm : uploadChunks[0].params.appKey, //prepare返回接口数据中的appKey
                            contextId: uploadChunks[0].params.contextId //prepare接口中返回的contextId
                        };

                        var fileMD5 = ret1;
                        var fileSize = fs.statSync(fileFullPath).size || "";
                        var contextId = uploadChunks[0].params.contextId;
                        var url = ret2.data.prepareInfo.url;

                        //文件上传请求接口(到云备课)
                        var edc_file_add_request = {
                            openId : _openId,
                            name : fileNameWidthExt,
                            url : url, //文件地址
                            md5 : fileMD5, // 文件md5值
                            length : fileSize, // 文件长度
                            status : "", // 文件上传状态
                            // token : "", // 结果签名（contextId、url、md5、length、status进行计算）
                            contextId : "", // 通过文件服务上传后文件服务返回id
                            description : "", // 文件描述
                            grade : bookMeta.grade || "", // 年级属性
                            subject : bookMeta.subject || "", // 学科属性
                            publisher : bookMeta.publisher || "", // 上下册
                            phase : "", // 版本属性
                            volumn : bookMeta.volumn || "", // Stage
                            edition : "", // 类型属性
                            stage : "", // Stage
                            type : "", // 书本属性
                            book : bookMeta.bookCode || "", // 书本属性
                            unit1 : pageMeta.unit1 || app_global_bookContainer.getCurrUnit(), // 课本一级目录
                            unit2 : pageMeta.unit2 || "", // 课本二级目录
                            unit3 : pageMeta.unit3 || "", // 课本三级目录
                            unit4 : pageMeta.unit4 || "" // 课本四级目录
                        };

                        var id_key = _this.makeId();

                        var upload_params = {
                            id:id_key,
                            url: uploadChunks[0].host,
                            file: fileFullPath,
                            key: 'file',
                            multi:1,
                            source : 'ifb_widget_upload',
                            evt: "ifb_widget_upload", //用户回调函数判断事件类型
                            extra: {
                                appKey: uploadChunks[0].params.appKey,
                                contextId: uploadChunks[0].params.contextId,
                                expires: uploadChunks[0].params.expires,
                                token: uploadChunks[0].params.token
                            },
                            raw_data:{
                                "index" : id_key,
                                "url": uploadChunks[0].host,
                                "appKey": uploadChunks[0].params.appKey,
                                "contextId": uploadChunks[0].params.contextId,
                                "expires": uploadChunks[0].params.expires,
                                "token": uploadChunks[0].params.token,
                                "edc_file_upload_complete_request": edc_file_upload_complete_request,
                                "edc_file_add_request": edc_file_add_request
                            }
                        };
                        socket.send({"type":"logic","action":"ta_upload","from":"ib","to":"ta_dum","data":upload_params});
                    }).fail(function(e){
                        console.log(e);
                        var tips =  tipsDialog({
                            "id":"sharefail" + new Date().getTime(),
                            "content":"文件上传失败"
                        });
                    });
                }
            }).fail(function(e){
                console.log(e);
                var tips =  tipsDialog({
                    "id":"sharefail" + new Date().getTime(),
                    "content":"文件上传失败"
                });
            });
        }
        else {
            app_global_loginMgr.show();
        }
    }

    WidgetBase.prototype.makeId = function(){
        var words = 'abcdefghijklmnopqrstuvwxyz',
            key = +new Date() + '_';
        for(var i=0; i<18; i++) {
            key += words.charAt((Math.random()*25).toFixed());
        }
        return key;
    }

    /**
     * 获取edc网盘接口特定目录的dirId
     * @param user
     * @param flag
     * @returns {*}
     */
    WidgetBase.prototype.getEdcSpecialDirId = function(user,flag){
        var def = jQuery.Deferred();
        var dirId = "";
        var _openId = user && user.id || "";
        flag = flag || "yun_mtbk";
        if(_openId == ""){
            def.reject(false);
        }
        //这里的缓存没有启用
        if(folderType && folderType[_openId] && folderType[_openId]['yun_mtbk'] != ""){
            def.resolve(folderType[_openId]['yun_mtbk']);
        }else {
            //获取mtbk yun_mtb类型的文件夹所在的dirId
            var param_pan_root_directly = {
                "openId": _openId,
                "coverDir": true,
                "coverFile": false,
                "order": "3", //1：修改时间，2：名称，3：创建时间
                "dirId": 0
            };
            edcService.Instance().pan_children_directly(param_pan_root_directly).done(function (ret) {
                if (ret.code == 0) {
                    var _root_folders = ret.data;
                    var folders = _root_folders.fileList || [];
                    if (_root_folders.total > 0) {
                        for (var i = 0, count = folders.length; i < count; i++) {
                            var item = folders[i];
                            if (item.folderType == flag) {
                                dirId = item.fid;
                                def.resolve(dirId);
                                break;
                            }
                        }
                    } else {
                        def.reject(false);
                    }
                } else {
                    console.log(ret);
                }
            }).fail(function (e) {
                console.log(e);
            });
        }
        return def.promise();
    }

    //分享到班级圈的一条动态
    WidgetBase.prototype.share = function(attachType){
        var _this = this;
        if (ebookContext.getUser().getName() != AppCfg.defaultuser) {
           //TODO:分享
            var ownerId = ebookContext.getUser().getUid();

            var isSendToClass = false;
            shellcmd.checkOnline().done(function(online) {
                if (online) {
                    classSelector.getClassInfo(function(userInfo){
                        if(userInfo && jQuery.isArray(userInfo.classInfo) && userInfo.classInfo.length > 0){
                            isSendToClass = true;
                        }
                        if(isSendToClass){
                            var url = '';
                            var file = path.trimPosix(app_global_curWidget.src);
                            if (path.extname(file) == ''){
                                file += '.icw';
                            }
                            var thumbnail = "";
                            if (app_global_curWidget.WidgetType == 'img') {
                                thumbnail = file;
                            }else{
                                var wid = app_global_curWidget;
                                thumbnail = wid.src.substring(0,wid.src.lastIndexOf('/'))+'/'+wid.resourceId+'.jpg';
                            }
                            shellcmd.isFileExist(thumbnail).done(function (rt) {
                                if (!rt) {
                                    thumbnail = 'assert/images/default_01.jpg';
                                }
                                classSelector.render(file,{
                                    labelName: '课堂同步资源',
                                    showLableName: '课堂实录',
                                    showPic: thumbnail,
                                    attachType: attachType,
                                    duration: 0
                                });
                            });
                    }else{
                            // $.Zebra_Dialog('您还没有班级，请去云平台创建班级',{
                            //     'type': 'information',
                            //     'title': AppTips.WarmTips,
                            //     'zIndex': 1000,
                            //     'buttons': ["去创建"],
                            //     'onClose': function (caption) {
                            //         if(caption == "去创建"){
                            //             // var url = Base_Cfg.YUN_CREATE_CLASS;
                            //             // ebookContext.getUser().getPassword().done(function(pwd){
                            //             //     DES.init("wyc4yrmK",ebookContext.getUser().getName() + "=" + pwd);
                            //             //     var token = DES.Encrypt();
                            //             //     url = url + "&token=" + token;
                            //             //     shellcmd.openPageOutside(url);
                            //             // })

                            //             var url = Base_Cfg.YUN_CREATE_CLASS_BASE + '&' + 'from=ew&appId=web';
                            //             commonfunc.openWebPage(url);
                            //         }
                            //     }
                            // })
                            return;
                        }
                    });
                }else{
                    tipsDialog({
                        "id":"snapshotFail" + new Date().getTime(),
                        "content":"您当前处于离线状态，请检查网络连接"
                    });
                }
            });


            // var classIds = ebookContext.getUserClassId();
            // if(!classIds || classIds == 'null'){
            //     //showAlertTips('您还没有班级，请去云平台创建班级');
            //     $.Zebra_Dialog('您还没有班级，请去云平台创建班级',{
            //         'type': 'information',
            //         'title': AppTips.WarmTips,
            //         'zIndex': 1000,
            //         'buttons': ["去创建"],
            //         'onClose': function (caption) {
            //             if(caption == "去创建"){
            //                 // var url = Base_Cfg.YUN_CREATE_CLASS;
            //                 // ebookContext.getUser().getPassword().done(function(pwd){
            //                 //     DES.init("wyc4yrmK",ebookContext.getUser().getName() + "=" + pwd);
            //                 //     var token = DES.Encrypt();
            //                 //     url = url + "&token=" + token;
            //                 //     shellcmd.openPageOutside(url);
            //                 // })
            //
            //                 var url = Base_Cfg.YUN_CREATE_CLASS_BASE + '&' + 'from=ew&appId=web';
            //                 commonfunc.openWebPage(url);
            //             }
            //         }
            //     })
            //     return;
            // }
            //
            // var url = '';
            // var file = path.trimPosix(app_global_curWidget.src);
            // if (path.extname(file) == ''){
            //    file += '.icw';
            // }
            //
            // shellcmd.checkOnline().done(function(ret){
            //     if(ret){
            //         var thumbnail = "";
            //         if (app_global_curWidget.WidgetType == 'img') {
            //             thumbnail = file;
            //         }else{
            //             var wid = app_global_curWidget;
            //             thumbnail = wid.src.substring(0,wid.src.lastIndexOf('/'))+'/'+wid.resourceId+'.jpg';
            //         }
            //         shellcmd.isFileExist(thumbnail).done(function (rt) {
            //             if (!rt) {
            //                 thumbnail = 'assert/images/default_01.jpg';
            //             }
            //             classSelector.render(file,{
            //                 labelName: '课堂同步资源',
            //                 showLableName: '课堂实录',
            //                 showPic: thumbnail,
            //                 attachType: attachType,
            //                 duration: 0
            //             });
            //             // classSelector.show(thumbnail,{title:"课堂同步资源"},function(isconfirm,classIds){
            //             //     if(isconfirm){
            //             //         var obj = app_global_bookContainer.getCurrPageMetadata();
            //             //         var content = obj.unit4Name || obj.unit3Name || obj.unit2Name || obj.unit1Name || '';
            //             //         content = encodeURI(content);
            //             //         var attachInfo = '[{"attachType":'+attachType+',"duration":0}]';
            //             //
            //             //         var labelIdUrl = AppCenterSvcHelper.CYSVC +"&method=jx.label.extend.list&labelType=3";
            //             //         var labelId = '';
            //             //         ebookContext.getUser().getDataByUserToken(labelIdUrl).done(function(labelRet){
            //             //             $.each(labelRet,function(){
            //             //                 if(this.labelName == '课堂同步资源'){
            //             //                     labelId = this.labelId;
            //             //                 }
            //             //             })
            //             //
            //             //             shellcmd.getHttpRequestJSON(AppRemoteSvcCfg.ClientToken).done(function(ret){
            //             //                 if(ret){
            //             //                     app_ClientToken = ret.access_token;
            //             //                     url = AppCenterSvcHelper.CYSVC +"&method=jx.feed.add&ownerId=" + ownerId +'&classIds='+classIds+ '&access_token='+app_ClientToken+'&content='+content+'&attachInfo='+attachInfo+'&labelIds='+labelId+'&fromApp=3';
            //             //                     var obj = {"type":"logic",
            //             //                         "action":"ta_upload",
            //             //                         "from":"ib",
            //             //                         "to":"ta_dum",
            //             //                         "id":0,
            //             //                         "data":{"id":"abc","key":"attachments","url":url,"file":file}
            //             //                     };
            //             //                     socket.send(obj);
            //             //                 }else{
            //             //                     console.error('access_token get error')
            //             //                 }
            //             //
            //             //             })
            //             //         })
            //             //     }
            //             // });
            //         });
            //     }else{
            //         tipsDialog({
            //             "id":"shareingFail" + new Date().getTime(),
            //             "content":"您当前处于离线状态，请检查网络连接"
            //         });
            //     }
            // })

        }
        else {
            app_global_loginMgr.show();
        }

        //监管
        var action = LogManager.action.trigger;
        var params = {};
        params.module = '1130605';
        var user_id = ebookContext.getUser().getUid();
        if(user_id != '0' && user_id){
            params.user_id =user_id;
        }
        LogManager.statistics(action,params);

    }




    WidgetBase.prototype.onMessageReceived = function (obj) {
        //ifb 页面 widget 文件上传
        if (obj.evt == "ifb_widget_upload") {
            var process = obj.process;
            var index = obj.raw_data.index;
            //结果处理
            if(100 - process > 100) {
                var tips =  tipsDialog({
                    "id":"sharefail" + new Date().getTime(),
                    "content":"文件上传失败"
                });
            }
            if(100 - process > 0) {
                var tips = tipsDialog({
                    "id":"shareing" + new Date().getTime(),
                    "content":"文件上传中..."
                });
            }
            if(100 - process == 0){
                var _edc_file_upload_complete_request = obj.raw_data.edc_file_upload_complete_request;
                var _edc_file_add_request = obj.raw_data.edc_file_add_request;
                edcService.Instance().pan_file_upload_complete(_edc_file_upload_complete_request).done(function (ret) {
                    if (ret && ret.code == 0) {
                        var complate_result = ret.data;
                        _edc_file_add_request['contextId'] = complate_result.contextId;
                        _edc_file_add_request['url'] = complate_result.url;
                        _edc_file_add_request['status'] = complate_result.status;
                        edcService.Instance().beike_file_add(_edc_file_add_request,{type:"POST"}).done(function(ret){
                            if (ret && ret.code == 0) {
                                var fileId = ret.data.fileId;
                                if(fileId != "") {
                                    //上传网盘成功
                                    var tips = tipsDialog({
                                        "id": "sharesucess" + new Date().getTime(),
                                        "content": '<span class="success_box_right"></span>文件上传成功'
                                    });
                                }
                            }else{
                                //上传网盘失败
                                console.log(ret);
                                var tips =  tipsDialog({
                                    "id":"sharefail" + new Date().getTime(),
                                    "content":"文件上传失败"
                                });
                            }
                        }).fail(function(e){
                            var tips =  tipsDialog({
                                "id":"sharefail" + new Date().getTime(),
                                "content":"文件上传失败"
                            });
                            console.log(e);
                        });
                    }else {
                        console.log(ret);
                        var tips =  tipsDialog({
                            "id":"sharefail" + new Date().getTime(),
                            "content":"文件上传失败"
                        });
                    }
                }).fail(function (e) {
                    console.log(e);
                    var tips =  tipsDialog({
                        "id":"sharefail" + new Date().getTime(),
                        "content":"文件上传失败"
                    });
                });
            }
        }

    }

    WidgetBase.prototype.getUnTransForm = function () {
        var obj = ebookContext.getUnTransForm()
        {
            return {
                wZoom: obj.wZoom * 0.7,
                hZoom: obj.hZoom * 0.7
            };

        }
    }

    WidgetBase.prototype.getUnTransFormBuble = function () {
        var obj = ebookContext.getUnTransForm();
        if(obj.wZoom == 1)
        {
            return {
                wZoom: obj.wZoom / 0.7,
                hZoom: obj.hZoom /0.7
            };

        }
        else{
            return {
                wZoom: 1/0.7,
                hZoom: 1/0.7
            };
        }
    }

    /**
     * 关联到授课包列表位置
     * sn : 课本上资源的序号
     * index : 通过fileid和file共同确定的文件位置
     */
    WidgetBase.prototype.scrollToPosition = function(obj){
        if(typeof obj == 'object' && obj.Content){
            var data = obj;
            var sn = parseInt($(data.Content.find(".format-bignumber")).text()) || 1;

            if(json.TP.useDb){
                // 授课包使用db模式的唯一标识
                var uuid = obj.uuid;
            }else{
                //解析文件 默认后缀名取 data.File
                var fileNameParse = _resTool.parseFileName(data.File);
                //兼容某些File数据不带文件后缀名 解析 data.Title
                if(fileNameParse.fileExt == ""){
                    fileNameParse = _resTool.parseFileName(data.Title);
                }
                var fileid = data.Id,
                    file = fileNameParse.fileName + '.' + fileNameParse.fileExt; //file为包含后缀名的数据
            }
        }else{
            var sn = obj || 1;
            obj = undefined;
        }

        var isHavingClass = $(document).data("isHavingClass");
        var isTeachingPackage = $(document).data("isTeachingPackage");
        var teachingPackageList1 = $(".J_teaching_package_content");
        var teachingPackageList2 = $(".J_teacking_package_left_content");
        var teachingPackageList3 = $(".J_teacking_package_right_content");

        var index = 1, //索引
            position = 0; //位置

        index = sn;

        if(isHavingClass){
            //上课模式
            if(json.TP.useDb){
                if(typeof uuid != 'undefined'){
                    //按资源信息检索
                    var _index = 0;
                    for(var i = 0,count = teachingPackageList2.find("li").length;i < count;i++){
                        var _item = teachingPackageList2.find("li:nth-child(" + (i + 1) + ")");
                        _index ++;
                        if($(_item).data('uuid') == uuid){
                            break;
                        }
                    }
                    //当按序和过滤两种方法结果不同时，按资源信息优先（考虑到序号重复问题）
                    if(_index != sn){
                        index = _index;
                    }
                }
            }else{
                if(typeof fileid != 'undefined' && typeof file != 'undefined'){
                    //按资源信息检索
                    var _index = 0;
                    for(var i = 0,count = teachingPackageList2.find("li").length;i < count;i++){
                        var _item = teachingPackageList2.find("li:nth-child(" + (i + 1) + ")");
                        _index ++;
                        if($(_item).data('fileid') == fileid && $(_item).data('file') == file){
                            break;
                        }
                    }
                    //当按序和过滤两种方法结果不同时，按资源信息优先（考虑到序号重复问题）
                    if(_index != sn){
                        index = _index;
                    }
                }
            }

            position = 70 * (index - 1);
            setTimeout(function(){
                teachingPackageList2.animate({'scrollTop':position},"fast");
                teachingPackageList3.animate({'scrollTop':position},"fast");
            });
        }else{
            //下课模式
            // 授课包列表页面
            if(isTeachingPackage){
                if(json.TP.useDb){
                    if(typeof uuid != 'undefined'){
                        //按资源信息检索
                        var _index = 0;
                        for(var i = 0,count = teachingPackageList1.find("li").length;i < count;i++){
                            var _item = teachingPackageList1.find("li:nth-child(" + (i + 1) + ")");
                            _index ++;
                            if($(_item).data('uuid') == uuid){
                                break;
                            }
                        }
                        //当按序和过滤两种方法结果不同时，按资源信息优先（考虑到序号重复问题）
                        if(_index != sn){
                            index = _index;
                        }
                    }
                }else{
                    if(typeof fileid != 'undefined' && typeof file != 'undefined'){
                        //按资源信息检索
                        var _index = 0;
                        for(var i = 0,count = teachingPackageList1.find("li").length;i < count;i++){
                            var _item = teachingPackageList1.find("li:nth-child(" + (i + 1) + ")");
                            _index ++;
                            if($(_item).data('fileid') == fileid && $(_item).data('file') == file){
                                break;
                            }
                        }
                        //当按序和过滤两种方法结果不同时，按资源信息优先（考虑到序号重复问题）
                        if(_index != sn){
                            index = _index;
                        }
                    }
                }
                position = 52 * (index - 1);
                setTimeout(function(){
                    teachingPackageList1.animate({'scrollTop':position},"fast");
                });
            }
        }
    }

    WidgetBase.prototype.parseFileName = function(filePath) {
        var _fileExt = "";
        var _fileName = "";
        //取文件名
        var f = filePath.substr(filePath.lastIndexOf('/')+1);
        //解析文件名称
        var file = filePath.replace(/.*(\/|\\)/, "");
        var fileParse=(/[.]/.exec(file)) ? /[^.]+$/.exec(file.toLowerCase()) : {};
        var _fileName = file.substr(0,file.lastIndexOf('.')) || "";

        if(null != fileParse){
            _fileExt = fileParse[0] || "";
        }
        if(_fileName == ""){
            _fileName = file;
        }
        //某些标题带.号时去除中文后缀名，重置文件名
        if(_fileExt.replace(/[^\a-\z\A-\Z0-9]/g,'') != _fileExt){
            _fileName = file;
            _fileExt = "";
        }
        return {
            "origin": filePath,
            'file':file, //文件名+文件后缀
            "fileName": _fileName, //文件名
            "fileExt" : _fileExt //文件后缀,在某些标题带.号时去除
        }
    }

    exports.WidgetBase = WidgetBase;
});
