/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:39
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var WidgetBase = require("./widgetbase").WidgetBase;
    require('browserContext');
    var define = require('../../define');
    var speechuiDefine = require('../../../speechui/code/define');
    var path = require('../../../common/path');
    require('jqjson');
    var CardWrapper = require('../../../app/card/cardwrapper').Instance;
    var cardResMgr = require('../../card/cardresourcemgr');
    var shellcmd = require('../../../common/shellcmd');
    var speechUI = require('../../../speechui/speechui');
    var trace = require('../../trace').Instance;
    var playerMgr = require('../hotspot/playerMgr').Instance;
    require('popover');
    var galleryCardTpl = require('../../../app/card/template/gallerycardtemplate').Instance;


    function WidgetGallery() {
    }

    WidgetGallery.prototype = new WidgetBase();
    WidgetGallery.prototype.constructor = WidgetGallery;

    function WidgetGallery(widgetType, obj) {
        var _self = this;
        _self.WidgetType = widgetType;
        _self.parse(obj);
        _self.obj = obj;
        if (obj.file["src"] != undefined) {
            _self.File = obj.file["src"];
        }
        _self.Title = obj.file["title"];
        _self.showTitleFlag = !!(obj.file["showTitleFlag"] == "true");
        _self.showIconFlag = !!(obj.file["showIconFlag"] == "true");
        _self.description = obj.file["description"]||"";
        _self.userName = obj.file["userName"]||"";
        _self.uploadTime = obj.file["uploadTime"]||"";
        _self.score = obj.file["score"]|| 0;
        _self.userAddressInfo = obj.file["userAddressInfo"]||"";
        _self.resourceId = obj.file["resourceId"]||"";
        _self.timestamp=obj.file["timestamp"] || "";
        var icon = 'assert/images/bookicon/ic_card.png';
        if(json.TP.useDb){
            var xmlPath = obj.file['realPath'];
            var md5 = obj.file['md5'];
        }else{
            var xmlPath = path.join(obj.XamlPath, '../' + _self.File);
        }

        this.Content = this.getContent(icon, [this.Left, this.Top, this.Width, this.Height]);
        this.Content.click(function (event) {
            var def = $.Deferred();
            // 定位到列表位置
            _self.scrollToPosition(_self);

            if (!_self.getIsEditing()) {
                _self.showIntro(_self);
                // _self.showBubble(this,_self);
            }
            else  {
                _self.showEdit(this,_self);
            }
            def.resolve();
            event.stopPropagation();
            return def.promise();
        });

        this.Content.attr('id', _self.Id);
        this.Content.attr('data-uuid', _self.uuid);
        this.src = xmlPath;
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();
    }

    /**
     * 资源查看
     */
    WidgetGallery.prototype.resourcePreview = function(event){
        var _self = this;
        var obj = this.obj;
        if(json.TP.useDb){
            var xmlPath = _self.src;
        }else{
            var xmlPath = path.join(obj.XamlPath, '../' + _self.File);
        }
        var def = $.Deferred();
            cardResMgr.getGalleryCardOptions(xmlPath).done(function (cardOptions) {
                speechUI.init([speechuiDefine.CardName.Gallery]);
                var galleryCard = speechUI.loadCard(speechuiDefine.CardName.Gallery, cardOptions);
                CardWrapper.show(galleryCard.getContent()[0], _self.Id);
            });
        def.resolve();
//        event && event.stopPropagation();
        return def.promise();
    };
    /**
     * 资源编辑
     */
    WidgetGallery.prototype.resourceEditor = function(event){

        var _self = this;
        //获得当前widget所属的pageItem
        var pageItem = _self.Content.data('pagedata');
        var pageIndex = pageItem.pageIndex ||1;

        var xmlPath = path.join(_self.obj.XamlPath, '../' + _self.File);
        console.log(xmlPath);
        var filePath = xmlPath + '/meta.json';
        shellcmd.readFileAsync(filePath).done(function(result){
            console.log(result);
            var galleryJson = JSON.parse(result);
            //遍历json，将json中图片地址具体化到绝对路径
            for(var i= 0, count = galleryJson.images.length;i < count; i++){
                galleryJson.images[i].src = xmlPath + '/' + galleryJson.images[i].src;
            }
            galleryCardTpl.showEditGalleryTplPanel(galleryJson,true,_self.File,pageIndex);
        });

    };

    WidgetGallery.prototype.upload = function(){
        alert("当前资源不可上传")
    };

    WidgetGallery.prototype.destroy = function (isDeleteSrc) {
        if (this.Content) {
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteDir(dst);
            }
            this.Content.remove();
            this.Content = null;
        }
    }

    WidgetGallery.prototype.toXml = function () {
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<file src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}"  title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,
                this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId,this.timestamp);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left = parseFloat(this.Content.css('left')), top = parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id, left, top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing, this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);

        return xmlResult;
    }

    WidgetGallery.prototype.setIsEditing = function (value) {
        this.IsEditing = value;
        !this.IsEditing ? this.Content.find("#resourceDelete").hide() : this.Content.find("#resourceDelete").show();
        !this.IsEditing ? this.Content.find("#resRDEdit").hide() : this.Content.find("#resRDEdit").show();

        this.showTitleSet();
        this.resourceIconHide();
    }

    /**
     * @param icon 资源图标
     * @param bound 定位
     * @returns {*|jQuery}
     */
    WidgetGallery.prototype.getContent = function (icon, bound) {
        if (!icon || !bound) return;
        var Obj = this.getUnTransForm();
        var Obj1 = this.getUnTransFormBuble();
        var content = $("<div class='jxbubble-positioning widgeticon' style='position: absolute;-webkit-transform:matrix(" + Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)'/>")
            .append('<div class="format-bignumber format-number" draggable="true"></div>')
            .css({
                'top': bound[0] + 'px',
                'left': bound[1] + 'px'
                // 'width': bound[2] + 'px',
                // 'height': bound[3] + 'px'
            });
            // .append("<div class='fs_closed'  >" +
            //     "<img  id='normal' src='" + icon + "' width='" + bound[2] + "' height='" + bound[3] + "'>" +
            //     "<img  id='tiny'  src='assert/images/bookicon/ic_black.png'>" +
            //     "<a id='resourceDelete' ></a>" +
            //     "<div class='iconedit'><a id='resRDEdit' ></a></div></div>");

        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();

        return content;
    }


    exports.WidgetGallery = WidgetGallery;
});
