/**
 *
 * User: chengyang@iflytek.com
 * Date: 15-2-28 上午10:26
 * Version: 1.0
 */

define(function(require,exports){
    var WidgetBase  =  require("./widgetbase").WidgetBase,
        path        =  require('../../../common/path'),
        shellcmd    = require('../../../common/shellcmd'),
        ibWSLogic = require("../../../ibWSLogic"),
        ebookContext = require('../../../app/ebookcontext').Instance,
        childProcess = nodereq('child_process'),
        fs = nodereq('fs');

    function WidgetVote(widgetType, obj){
        this.WidgetType = widgetType;
        this.obj = obj;
        this.parse(obj);
        (obj.vote["src"]) && (this.File = obj.vote["src"]);

        this.setXamlParam();
        if(json.TP.useDb){
            this.src = obj.vote['realPath'];
            this.md5 = obj.vote['md5'];
        }else{
            this.src = path.join(obj.XamlPath, '../' + this.File);
        }
        this.Content = this.getContent('assert/static/common/images/icon_24X24/default.png',[this.Left,this.Top,this.Width,this.Height]);

        var _this = this;
        /**
         * 完成状态下打开
         */
        this.Content.click(function (e) {
            // 定位到列表位置
            _this.scrollToPosition(_this);

            if (!_this.getIsEditing()) {
                _this.showIntro(_this);
                // _this.showBubble(this,_this);
            }
            else  {
                if($(_this.Content.find(".user-popover")[1]).css("display")=="block")
                    $(_this.Content.find(".user-popover")[1]).hide();
                else{
                    $(".user-popover").hide();
                    _this.Content.popover("show", "toolbar");
                    x=$(".leftPageWrapper").width()-$(this).position().left;
                    if(x<307){
                        _this.Content.find("div[name=infoWideget_pop]").parent(".user-popover").css("left",-78);
                    }
                    var isTeachingPackage=$(document).data("isTeachingPackage");
                    if(isTeachingPackage){
                        $(".editor_ic a[name=deletefile]").show();
                    }
                }
            }
            e.stopPropagation();
        });
        this.Content.attr('id', _this.Id);
        this.Content.attr('data-uuid', _this.uuid);
        if(json.TP.useDb){
            this.encodeSrc= src && src.substring(0, this.src.lastIndexOf('/')) + '/' + encodeURIComponent(_this.File);
        }else{
            this.encodeSrc= path.join(obj.XamlPath, '../' + encodeURIComponent(_this.File));
        }
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();

//        this.paperPath = "\"" + this.encodeSrc + "\"";
        this.paperPath = "\"" + this.src + "\"";
        //this.nwCmd = "\"" + Config.nwexePath + "nw.exe\" " + "\"" + path.trimPosix(Config.binPath) + "Voter/client/displayer\" " + this.paperPath;

        this.nwCmd = "\"" + Config.nwexePath + "nw.exe\" " + "\"" + path.trimPosix(Config.nwexePath) + "plugins/15\" " + path.trimPosix(this.paperPath);
    }

    WidgetVote.prototype = new WidgetBase();
    WidgetVote.prototype.constructor = WidgetVote;

    WidgetVote.prototype.setXamlParam = function(){
        var obj = this.obj;

        this.Title = obj.vote["title"];
        this.showTitleFlag = !!(obj.vote["showTitleFlag"] == "true");
        this.showIconFlag = !!(obj.vote["showIconFlag"] == "true");
        this.description = obj.vote["description"]||"";
        this.userName = obj.vote["userName"]||"";
        this.uploadTime = obj.vote["uploadTime"]||"";
        this.score = obj.vote["score"]|| 0 ;
        this.userAddressInfo = obj.vote["userAddressInfo"]||"";
        this.resourceId = obj.vote["resourceId"]||"";
        this.timestamp=obj.vote["timestamp"] || "";
    };

    WidgetVote.prototype.destroy = function(isDeleteSrc){
        if(this.Content){
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content=null;
        }
    };

    WidgetVote.prototype.resourcePreview = function(){
        var _this = this;
        var voteOpen = ibWSLogic.getVoteStatus();
        if(voteOpen){
            var length = this.paperPath.length;
            var paths = this.paperPath.slice(1,length-1);
            paths = path.trimPosix(paths);
            var json = {
                to : "all",
                action : "showQuestion",
                data : {target:"question",path:paths}
            };
            socket.send(json);
        }else{
            shellcmd.checkOnline().done(function(ret){
                if(ret){
                    //有网
                    var userName = ebookContext.getUser().getName();
                    if(userName == AppCfg.defaultuser){
//                        showAlertTips('请登录后使用答题宝');
                        app_global_loginMgr.show();
                    }else{
                        appManagePath = Config.nwexePath  + 'user/'+userName +'/' +'appmanage.dat';
                        var str = fs.readFileSync(appManagePath, encoding = 'utf8');
                        var jsonInfo = JSON.parse(str);


                        if(jsonInfo && jsonInfo['15']){
                            //认为安装了答题宝

                            var exec = nodereq('child_process').exec;
                            var nwexePath = path.join(Config.binPath ,"../../..").replace('file:/','');
                            var votedetectdir = '"'+nwexePath + '/tools/TAVoteDetect.exe'+'"';
                            var cwdPath = nwexePath +'/tools/';
                            var options = {

                                cwd: cwdPath
                            };
                            var child = exec(votedetectdir,options,
                                function (error, stdout, stderr) {
                                    console.log('stdout: ' + stdout);
                                    console.log('stderr: ' + stderr);
                                    if (error !== null) {
                                        console.log('exec error: ' + error);
                                    }
                                });
                            child.on('exit', function (code) {
                                console.log('Child process exited with exit code '+code);
                                if (code != 0) {
                                    console.log('no device install');
                                    showAlertTips('很抱歉，未检测到互动所需的答题宝硬件设备');
                                } else {
                                    childProcess.exec(_this.nwCmd);
                                }
                            });





                        }else{
                            $.Zebra_Dialog("您尚未安装“答题宝”应用", {
                                'type': 'question',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.CancelTips, AppTips.Goinstall],
                                'onClose': function (a){
                                    if(a ==AppTips.Goinstall){
                                        var taMainOpen = ibWSLogic.getTamainStatus();
                                        if(taMainOpen){
                                            var json = {
                                                to : "main",
                                                action : "ifbPlugins",
                                                data : {
                                                    id:15

                                                }
                                            };
                                            socket.send(json);
                                        }else{
                                            global_tamain = true;
                                            var tpPath = path.join(Config.binPath ,"../../../nw.exe");
                                            var workPath = '\"'+ path.trimPosix(path.join(Config.binPath ,"../../../main"))+'\"';
                                            shellcmd.shellexecutewithargs(tpPath,workPath);
                                        }


                                    }
                                }
                            });
                        }
//                        childProcess.exec(_this.nwCmd);
                    }

                }else{
                    showAlertTips('请检查网络连接');
                }
            })




        }
    };


    WidgetBase.prototype.checkDTBCondition = function (){
        var exec = nodereq('child_process').exec;
        var path = nodereq('path');
//                    var votedetectdir = "\"" + path.resolve("..\\..\\")+"\\tools\\TAVoteDetect.exe" + "\"";
        var nwexePath = process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/");
        var votedetectdir = '"'+nwexePath + '/tools/TAVoteDetect.exe'+'"';
        var cwdPath = nwexePath +'/tools/';
        var options = {

            cwd: cwdPath
        };
        var child = exec(votedetectdir,options,
            function (error, stdout, stderr) {
                console.log('stdout: ' + stdout);
                console.log('stderr: ' + stderr);
                if (error !== null) {
                    console.log('exec error: ' + error);
                }
            });
        child.on('exit', function (code) {
            console.log('Child process exited with exit code '+code);
            if (code != 0) {
                console.log('no device install');
                dtbCheckDialog();
            } else {
                var plugins = APP_CONFIG.BASE_PATH + "/plugins/";
                var spawn = nodereq('child_process').spawn;
                if (TA.Stage.stages['app_15']){
//                                    spawn(nw, [plugins + '15'], {detached: true});
                    shellcmd.appSetAlwaysTop(null,TA.Stage.stages['app_15'].pid,'答题宝');
                    return;
                }
                TA.Stage.stages['app_15']  = spawn(nw, [plugins + '15'], {detached: true}).on("exit", function () {
                    //关闭时置空信息
                    TA.Stage.stages['app_15'] = null;
                });
            }
        });
    }

    WidgetVote.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent = '\n<vote src= "{0}" uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" timestamp="{12}" title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId,this.timestamp);

        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left=parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id, left,top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;
    };
    exports.WidgetVote = WidgetVote;
});