/**
 * Created with JetBrains WebStorm.
 * User: jhwang
 * Date: 13-6-25
 * Time: 上午11:39
 * To change this template use File | Settings | File Templates.
 */
/**
 * Tips : 这个模块是书本中各种各样的小icon的工厂方法
 * 可以往代码里面继续添加icon类型以完成新的任务要求
 *
 * 尽量不要添加/删除函数，如果必须如此，请注上您的大名
 *
 *                    --------- by yczhu
 */
define(function (require, exports) {
    var model = require('../model');
    var widgetModel = {
        WidgetBase: require('./widget/widgetbase').WidgetBase,
        WidgetImg: require('./widget/widgetimg').WidgetImg,
        WidgetVideo: require('./widget/widgetvideo').WidgetVideo,
        WidgetFlash: require('./widget/widgetflash').WidgetFlash,
        WidgetEvalCard: require('./widget/widgetevalcard').WidgetEvalCard,
        WidgetOnlineResCard: require('./widget/widgetonlinerescard').WidgetOnlineResCard,
        WidgetProc3d: require('./widget/widgetproc3d').WidgetProc3d,
        WidgetChoiceCard: require('./widget/widgetchoicecard').WidgetChoiceCard,
        WidgetGallery: require('./widget/widgetgallery').WidgetGallery,
        WidgetAudio: require('./widget/widgetaudio').WidgetAudio,
        WidgetNote: require('./widget/widgetnote').WidgetNote,
        WidgetFadeCurtain: require('./widget/widgetfadecurtain').WidgetFadeCurtain,
        WidgetICW : require('./widget/widgeticw').WidgetICW,
        WidgetImgPaint : require('./widget/widgetimgpaint').WidgetImgPaint,
	    WidgetVote :  require('./widget/widgetvote').WidgetVote,
        WidgetInteractiveCard : require('./widget/widgetinteractivecard').WidgetInteractiveCard
    }

    var define = require('../define');
    var path = require('../../common/path');
    var shellcmd = require('../../common/shellcmd');

    function WidgetFactory() {
        var _self = this;

        _self.init = function (container, userPage, xamlPath, player) {
            _self.container = container;
            _self.userPage = userPage;
            _self.xamlPath = xamlPath;
            _self.player = player;

        }

        _self.createWidget = function (widgetType, node, options) {
            var widget = null;
            options = options || {};
            switch (widgetType) {
                case define.WidgetType.Img:
                    if (!node) node = this._createWidgetNode(widgetType, model.createImgNode(), 'img', options);
                    if (!node.img) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetImg(define.WidgetType.Img, node);
                    break;
                case define.WidgetType.Video:
                    if (!node) node = this._createWidgetNode(widgetType, model.createVideoNode(), 'video', options);
                    if (!node.video) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetVideo(define.WidgetType.Video, node);
                    break;
                case define.WidgetType.Flash:
                    if (!node) node = this._createWidgetNode(widgetType, model.createFlashNode(), 'flash', options);
                    if (!node.flash) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = widget = new widgetModel.WidgetFlash(define.WidgetType.Flash, node);
                    break;
                case define.WidgetType.Gallery:
                    if (!node) node = this._createWidgetNode(widgetType, model.createGalleryNode(), 'file', options);
                    if (!node.file) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetGallery(define.WidgetType.Gallery, node);
                    break;
                case define.WidgetType.Evaluate:
                    if (!node) node = this._createWidgetNode(widgetType, model.createEvalNode(), 'file', options);
                    if (!node.file) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetEvalCard(define.WidgetType.Evaluate, node);
                    break;
                case define.WidgetType.Choice:
                    if (!node) node = this._createWidgetNode(widgetType, model.createChoiceNode(), 'file', options);
                    if (!node.file) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetChoiceCard(define.WidgetType.Choice, node);
                    break;
                case define.WidgetType.OnlineRes:
                    if (!node) node = this._createWidgetNode(widgetType, model.createOnlineResNode(), 'file', options);
                    if (!node.file) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetOnlineResCard(define.WidgetType.OnlineRes, node);
                    break;
                case define.WidgetType.Proc3rd:
                    if (!node) {
                        node = this._createWidgetNode(widgetType, model.createProc3rdNode(), 'file', options);
                        if (options.insertFromOuter) node.realPath = options.file;
                        else node.realPath = options.realPath;
                    }
                    if (!node.file) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetProc3d(define.WidgetType.Proc3rd, node);
                    break;
                case define.WidgetType.Audio:
                    if (!node) node = this._createWidgetNode(widgetType, model.createAudioNode(), 'audio', options);
                    if (!node.audio) return null;
                    node.player = _self.player;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetAudio(define.WidgetType.Audio, node);
                    break;
                case define.WidgetType.Note:
                    if (!node) node = this._createWidgetNode(widgetType, model.createNoteNode(), 'note', options);
                    if (!node.note) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetNote(define.WidgetType.Note, node);
                    break;
                case define.WidgetType.FadeCurtain:
                    if (!node) node = this._createWidgetNode(widgetType, model.createFadeCurtainNode(), 'fadeCurtain', options);
                    if (!node.fadeCurtain) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetFadeCurtain(define.WidgetType.FadeCurtain, node);
                    break;
                case define.WidgetType.Icw :
                    if (!node) node = this._createWidgetNode(widgetType, model.createICWNode(), 'icw', options);
                    if (!node.icw) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetICW(define.WidgetType.Icw, node);
                    break;
                case define.WidgetType.ImgPaint :
                    if (!node) node = this._createWidgetNode(widgetType, model.createImgPaintNode(), 'imgPaint', options);
                    if (!node.imgPaint) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetImgPaint(define.WidgetType.ImgPaint, node);
                    break;
		        case define.WidgetType.Vote:
                    if(!node) node = this._createWidgetNode(widgetType, model.createVoteNode(), 'vote', options);
                    if(!node.vote) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetVote(define.WidgetType.Vote, node);
                    break;
                case define.WidgetType.InteractiveCard:
                    if(!node) node = this._createWidgetNode(widgetType, model.createInteractiveNode(), 'file', options);
                    //if(!node.vote) return null;
                    node.XamlPath = _self.xamlPath;
                    widget = new widgetModel.WidgetInteractiveCard(define.WidgetType.InteractiveCard, node);
                    break;
            }
            if (widget && (!options.noNewIcon))  _self.container.append(widget.Content);
            return widget;
        };

        _self._createWidgetNode = function (widgetType, node, firstNode, options) {
            node[firstNode].src = _self._copyResToUserBook(options.file, widgetType, options);
            console.log("optionFile:"+options.file);
            if(json.TP.useDb){
                node[firstNode].uuid = options.uuid;
                node[firstNode].sort = options.sort;
                node[firstNode].pageIndex = options.pageIndex;
                node[firstNode].unit1 = options.unit1;
                node[firstNode].unit2 = options.unit2;
                node[firstNode].unit3 = options.unit3;
                node[firstNode].unit4 = options.unit4;
                node[firstNode].realPath = options.realPath;
                node[firstNode].md5 = options.md5;

                //将属性赋值到对象外层，方便后续统一取值
                node.uuid = options.uuid;
                node.sort = options.sort;
                node.pageIndex = options.pageIndex;
                node.unit1 = options.unit1;
                node.unit2 = options.unit2;
                node.unit3 = options.unit3;
                node.unit4 = options.unit4;
                node.realPath = options.realPath;
                node.md5 = options.md5;
            }

            node[firstNode].title = options.title;
            if(!options.left ) options.left = 0;
            if(!options.top) options.top = 120;
            node.bound = (new model.Bound(options.left, options.top, options.width, options.height)).serialize();
            node.type = options.type;
            node.style = options.style;
            node.insertFromOuter = options.insertFromOuter;
            options.userName && (node[firstNode].userName = options.userName);
            options.score && (node[firstNode].score = options.score);
            options.uploadTime && (node[firstNode].uploadTime = options.uploadTime);
            options.description && (node[firstNode].description = options.description);
            options.resourceId && (node[firstNode].resourceId = options.resourceId);
            options.timestamp && (node[firstNode].timestamp = options.timestamp);
            //这两个标签必须传"true""false"字符串
            options.showTitleFlag && (node[firstNode].showTitleFlag = options.showTitleFlag.toString());
            options.showIconFlag && (node[firstNode].showIconFlag = options.showIconFlag.toString());
            //   options.userName && (node[firstNode].userName = options.userName);
            return node;
        }

        //拷贝外部资源源文件到书本目录
        _self._copyResToUserBook = function (file, widgetType, options) {
            var _this  = this;

            if (!file) return;

            if(widgetType === define.WidgetType.OnlineRes ) {
                return file;
            };

            if(widgetType === define.WidgetType.ImgPaint ) {
                return options.imgPaintSrc;
            };

            var filename = path.filename(file);
            var dst = path.join(this.userPage, filename);
            dst = path.trimPosix(dst);
            var args = {"files": []};
            var isCard = (widgetType === define.WidgetType.Gallery || widgetType === define.WidgetType.Evaluate
                ||widgetType === define.WidgetType.Choice);
            //options.notCopySrc为在线资源卡片设置，iflyBook2.1貌似没有这类资源了
            if (!options.notCopySrc) {
                //在一次性打开多个资源时批量复制
                if (options.multiFiles instanceof Array && !isCard) {
                    for (var i = 0; i < options.multiFiles.length; ++i) {
                        var newFile = path.toPosix(options.multiFiles[i]);
                        args.files[i] = {
                            "oriname": newFile,
                            "newname": path.trimPosix(path.join(this.userPage, path.filename(newFile)))
                        }
                    }
                    shellcmd.multiCopyFile(JSON.stringify(args)).done(function(){
                        if (widgetType === define.WidgetType.Icw){
                            for(var i= 0 ; i < args.files.length ;i++){
                                var _file = args.files[i].newname;
                                var _fileName = path.filename(_file);
                                shellcmd.FileUnzip(path.trimPosix(_file),path.trimPosix(_this.userPage+"/"+ path.basename(_fileName,".icw") ));

                            }
                        }else if(!options.insertFromOuter){
                            for (var j = 0; j < options.multiFiles.length; ++j) {
                                shellcmd.deleteFile(path.toPosix(options.multiFiles[j]));
                            }
                        }
                    });
                }
                else {
                    //复制目录
//                    if (widgetType === define.WidgetType.Gallery || widgetType === define.WidgetType.Evaluate
//                        ||widgetType === define.WidgetType.Choice) {
//                        var timeId;
//                        shellcmd.copyDir(file, dst).done(function () {
//                            clearTimeout(timeId);
//                            hideLoading();
//                            //不是从外面插入则删除物理文件
//                            if (!options.insertFromOuter) shellcmd.deleteDir(file);
//                        });
//                        timeId = setTimeout(function () {
//                            showLoading({tips: AppTips.OpenResLoadingTips});
//                        }, 1000);
//                    }
//                    else {
//                        args.files[0] = {
//                            "oriname": file,
//                            "newname": dst
//                        }
//                        shellcmd.multiCopyFile(JSON.stringify(args)).done(function () {
//                            (!options.insertFromOuter) && shellcmd.deleteFile(file);
//                        });
//                    }
                    if(isCard){
                        var timeId;
                        shellcmd.copyDir(file, dst).done(function () {
                            clearTimeout(timeId);
                            hideLoading();
                            //不是从外面插入则删除物理文件
                            if (!options.insertFromOuter) shellcmd.deleteDir(file);
                        });
                        timeId = setTimeout(function () {
                            showLoading({tips: AppTips.OpenResLoadingTips});
                        }, 1000);
                    }else{
                        args.files[0] = {
                            "oriname": file,
                            "newname": dst
                        }
                        shellcmd.multiCopyFile(JSON.stringify(args)).done(function () {
                            (!options.insertFromOuter) && shellcmd.deleteFile(file);
                        });
                    }


                }
            }
            else{
                //在一次性打开多个资源时批量复制
                if (options.multiFiles instanceof Array) {
                    for (var i = 0; i < options.multiFiles.length; ++i) {
                        var newFile = path.toPosix(options.multiFiles[i]);
                        args.files[i] = {
                            "oriname": newFile,
                            "newname": path.trimPosix(path.join(this.userPage, path.filename(newFile)))
                        }
                    }
                    shellcmd.multiCopyFile(JSON.stringify(args)).done(function(){
                        if (widgetType === define.WidgetType.Icw){
                            for(var i= 0 ; i < args.files.length ;i++){
                                var _file = args.files[i].newname;
                                var _fileName = path.filename(_file);
                                shellcmd.FileUnzip(path.trimPosix(_file),path.trimPosix(_this.userPage+"/"+ path.basename(_fileName,".icw") ));
                                var strHere = args.files[i].oriname;
                                shellcmd.deleteFile(strHere);
                                var _str = strHere.substr(0,strHere.lastIndexOf("."));
                                shellcmd.deleteDir(_str);
                            }
                        }
                    });
                }
            }
            return filename;
        };
    }

    exports.WidgetFactory = WidgetFactory;
});