/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-8-1
 * Time: 下午4:12
 * To change this template use File | Settings | File Templates.
 */

/**
 * 文件解压
 * @param zipPath
 * @param savePath
 * @returns {boolean}
 */

define(function (require, exports, module) {

    require('jquery');
    require('zebra_dialog');
    var BookItem = require('../bookitem').BookItem;
    var bookAccessor = require('../bookaccessor').Instance;
    var _path = require('../../../common/path');
    var Messenger = require('../../../thirdparty/messenger');
    var ebookContext = require('../../ebookcontext').Instance;
    var _shellcmd = require('../../../common/shellcmd');
    var _userData = require('../../../common/userdata').Instance;
    var _bookLicHelper = require('../booklichelper');
    var _bookLoader = require('../bookloader').Instance;
    var _pageNavigatorHelper = require('../../../common/pagenavigatorhelper');
    var _bookDownloadHelper = require('../bookdownloadhelper');
    var SimpleActive = require("../../login/activeaccount").Instance;
    var eventLogic = require('../eventlogic').Instance;
    var remotebookDirAccess = require('../../../common/remotebookdiraccess');

    var _yjBookLibMgr = require('./yjbooklibmgr').Instance;



    function BookLibraryManager() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};
        _self._dataReceived = '';
        _self.userLogin = null;

        /**
         * @param buttons   按钮
         * @param controls  非按钮类控件
         */
        _self.init = function (buttons, controls,userLogin) {

            _self.buttons = buttons;
            _self.controls = controls;
            _self.userLogin = userLogin;
            _self.messenger = Messenger.initInParent(_self.controls.bookLibIfrm[0]);
            _self.messenger.onmessage = function (data) {
                _self._dataReceived = data;
                var receiveJson = JSON.parse(data);
                if (receiveJson.evt == "get_booklist_downloaded") {
                    _bookDownloadHelper.prepareLocalBooksInfoForBookLib(ebookContext.getUser()).done(function (respJsonStr) {
                        dispatchClientMsg(respJsonStr);
                    });
                }
                else if (receiveJson.evt == "get_useraccount") {
                    var respJsonStr = _self._prepareUserAccountForBookLib();
                    dispatchClientMsg(respJsonStr);
                } else if (receiveJson.evt == "open_url") {//调用浏览器打开指定页面
                    //
                    ebookContext.getUser().getPassword().done(function(pwd){
                        DES.init("wyc4yrmK",ebookContext.getUser().getName() + "=" + pwd);
                        var token = DES.Encrypt();
                        var htmlUrl = AppRemoteSvcCfg.BuyPointUrl  + "token=" + token + "&" + (ebookContext.getUser().getSSOTicket()||"" );
                        _shellcmd.openPageOutside(htmlUrl);
                    })

                } else if (receiveJson.evt == "closebookstore") {
                    _self.hideBookLibPanel();
                }
                else if (receiveJson.evt == "openbook") {
                    var obj = bookAccessor.getBookInfoById(receiveJson.data.resid, ebookContext.getUser());
                    if (obj) {
                        _bookLoader.goToIndex(obj.bookCode,obj.lastPage,obj.isU);
                    }
                }
                else if (receiveJson.evt == "downloadbook") {
                    var bookJson = receiveJson.data;
                    if(bookJson.bookCode && bookJson.file) {
                        var savePath = _path.trimPosix(ebookContext.getUser().getStdBookBasePath()) + '/' + bookJson.bookCode;
                        console.log(bookJson);
                        var logObj = {
                            type: "book2",
                            source: "bookStack",
                            bookcode: bookJson.bookCode,
                            url: bookJson.file
                        };
                        _shellcmd.checkOnline().done(function (online) {
                            console.log('在线状态：%s', online + '');
                            if (online) {
                                //先写记录，再下载
                                _userData.start("add", logObj).done(function () {
                                    _shellcmd.isDirExist(savePath).done(function (isDirExist) {
                                        var remoteAccess = new remotebookDirAccess.RemoteBookDirectoryAccess();
                                        if (!isDirExist) {
                                            _shellcmd.createDir(savePath).done(function (ret) {
                                                remoteAccess.getBookDirFromWeb("", bookJson.bookCode, ebookContext.getUser()).done(function (content) {
                                                    if (content && content.data && content.data.length) {
                                                        _shellcmd.saveFile(JSON.stringify(content), savePath + "/" + bookJson.bookCode + ".menu");
                                                        _bookDownloadHelper.downloadBook(bookJson, ebookContext.getUser());
                                                    } else {
                                                        var respJsonStr = '{"evt":"cancelDownload2","data":{"bookid":"' + receiveJson.data.id + '"}}';
                                                        dispatchClientMsg(respJsonStr);
                                                        showAlertTips(AppBookShelfTipsList.MenuError);
                                                    }
                                                })
                                            });
                                        } else {
                                            remoteAccess.getBookDirFromWeb("", bookJson.bookCode, ebookContext.getUser()).done(function (content) {
                                                if (content && content.data && content.data.length) {
                                                    _shellcmd.saveFile(JSON.stringify(content), savePath + "/" + bookJson.bookCode + ".menu");
                                                    _bookDownloadHelper.downloadBook(bookJson, ebookContext.getUser());
                                                } else {
                                                    var respJsonStr = '{"evt":"cancelDownload2","data":{"bookid":"' + receiveJson.data.id + '"}}';
                                                    dispatchClientMsg(respJsonStr);
                                                    showAlertTips(AppBookShelfTipsList.MenuError);
                                                }
                                            })
                                        }
                                    });
                                });
                            } else {
                                var respJsonStr = '{"evt":"cancelDownload2","data":{"bookid":"' + receiveJson.data.id + '"}}';
                                dispatchClientMsg(respJsonStr);
                                showAlertTips(AppTips.NetWorkUnstable);
                            }
                        });
                    }else{
                        //返回数据异常时
                        var respJsonStr = '{"evt":"cancelDownload2","data":{"bookid":"' + receiveJson.data.id + '"}}';
                        dispatchClientMsg(respJsonStr);
                        showAlertTips(AppTips.NetWorkUnstable);
                    }
                }
                else if (receiveJson.evt == "downloadbookres") {
                    var bookResJson = receiveJson.data;
                    if(bookResJson.bookCode && bookResJson.file) {
                        var logObj = {
                            type: "mtbk",
                            source: "bookStack",
                            bookcode: bookResJson.bookCode,
                            url: bookResJson.file
                        };
                        _shellcmd.checkOnline().done(function (online) {
                            console.log('在线状态：%s', online + '');
                            if (online) {
                                _userData.start("add", logObj).done(function () {
                                    bookResJson["sourcepage"] = "booklibres";
                                    bookResJson["moreparam"] = "true";
                                    var bookResExtension = ".mtbk";
                                    bookResJson["filesavename"] = bookResJson.bookCode + bookResExtension;
                                    bookResJson["thumbnailsavename"] = "";
                                    bookResJson["savepath"] = ebookContext.getUser().getUserBookRelativeBasePath() + '/' + bookResJson.bookCode;  //文件保存路径
                                    bookResJson["dbpath"] = ebookContext.getUser().getUserDbFullPath();
                                    var downloadRawData = JSON.stringify(bookResJson);
                                    _shellcmd.fileDownload(downloadRawData);
                                });
                            } else {
                                var respJsonStr = '{"evt":"cancelDownload2","data":{"bookid":"' + receiveJson.data.id + '"}}';
                                dispatchClientMsg(respJsonStr);
                                showAlertTips(AppTips.NetWorkUnstable);
                            }
                        });
                    }else{
                        //返回数据异常
                        var respJsonStr = '{"evt":"cancelDownload2","data":{"bookid":"' + receiveJson.data.id + '"}}';
                        dispatchClientMsg(respJsonStr);
                        showAlertTips(AppTips.NetWorkUnstable);
                    }
                } else if (receiveJson.evt == "cancelDownload") {//取消下载
                    var resid = receiveJson.data.resid;
                    // _shellcmd.cancleDownload(resid).done(function (ret) {
                    //     var responseJson = receiveJson;
                    //     responseJson.data["status"] = ret ? 'true' : 'false';
                    //     //console.log(JSON.stringify(responseJson));
                    //     dispatchClientMsg(JSON.stringify(responseJson));
                    // });
                    var param = {
                        method: "stopEasyCurlDownload",
                        data: {
                            _from: CONST_hproseClientName,
                            action: "stopEasyCurlDownload",
                            raw_data: receiveJson,
                            downloadId: resid
                        }
                    };
                    // 发送取消下载消息
                    hproseClient.hproseNoti(param);
                    app_DownloadQueue.dele(resid);
                }
                else if(receiveJson.evt == "login"){
                    _self.userLogin.show();
                }
                else if(receiveJson.evt == "active"){
                    SimpleActive.show();
                    //1.隐藏原来书库页面
                    _self.hideBookLibPanel();
                }
            };
        }

        _self.onMessageReceived = function (obj) {
            if (obj.evt == 'file_download') {
                //progress>1说明下载完成了
                if (obj.data.sourcepage == 'booklib') {
                    if (obj.data.progress > 1) {
                        var bookItem = this.resolveBookInfo(obj.data);
                        //console.log(JSON.stringify(bookItem));

                        this.refreshBookOnShelf();

                        //书本下载完成后，刷新TA首页
                        var json = {
                            type   : "logic",
                            action : "refreash_ta_book",
                            from   : "ib",
                            to : "main"
                        };
                        socket.send(json);

                        //写入ta备课数据库
                        this.refreshTaDB(obj.data.rawData);

                        var licFullName = _path.trimPosix(ebookContext.getUser().getStdBookBasePath())
                            + '/' + bookItem.bookCode + '/' + bookItem.bookCode + '.lic';
                        _shellcmd.isFileExist(licFullName).done(function (isLicExist) {
                            if (!isLicExist) {
                                var hdInfoTask = _shellcmd.getHardwareInfo(ebookContext.getUser().getName());
                                var hdTypeTask = _shellcmd.getHardwareType();
                                $.when(hdInfoTask, hdTypeTask).done(function (hdInfo, hdType) {
                                    _bookLicHelper.callGetBookLicense(bookItem.id,
                                        bookItem.bookCode, ebookContext.getUser(),
                                        hdInfo,
                                        hdType).done(function (bookLicResult) {
                                        if (!bookLicResult) {
                                            console.log("下载书本授权文件失败");
                                        }
                                    });
                                });
                            }
                        });
                    }
                }
                else if (obj.data.sourcepage == 'booklibres') {
                    //console.log(obj.data.progress);
                    if (obj.data.progress > 1) {//解压处理
                    }
                }
            }
            if (obj.evt == 'file_download_fail') {

            }
            if (obj.evt == 'file_download_success') {
                if (obj.data.sourcepage == "booklibres") {

                } else if (obj.data.sourcepage == "booklib") {
                    this.refreshBookOnShelf();
                }
            }
        }

        _self.showBookLibPanel = function () {

//            if (!ebookContext.getUser().getIsOnline()) {
//                $.Zebra_Dialog(AppTips.LocalLoignMsg, {
//                    'type': 'information',
//                    'title': AppTips.WarmTips,
//                    'buttons': [AppTips.OkTips]
//                });
//            } else {
            _shellcmd.checkUrlAccess(AppRemoteSvcCfg.BookLibPageUrl).done(function (canAccess) {
                ebookContext.getUser().showIsOnline(canAccess);
                if (!canAccess) {
                    $.Zebra_Dialog(AppTips.NetWorkUnstable, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                } else {
                    var url = AppRemoteSvcCfg.BookLibPageUrl + "&account=" + ebookContext.getUser().getName() +
                        "&province=" + ebookContext.getUser().getProvince()
                    _self.controls.bookLibPanel.show();
                    //每次都更新
                    _self.controls.bookLibIfrm.attr("src", url);

                    _bookDownloadHelper.prepareLocalBooksInfoForBookLib(ebookContext.getUser()).done(function (respJsonStr) {
                        dispatchClientMsg(respJsonStr);
                    });
                    _self.controls.bookLibIfrm.load(function () {
                        _self.setCloseBtnPos();
                        //设置“下载人教课本”按钮position
                        _self.setRenjiaoBtnPos();
                    });
                }
            });
//            }
            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130104';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);

        }

        _self.hideBookLibPanel = function () {
            _self.refreshBookOnShelf();
            _self.controls.bookLibPanel.hide();
        }



        _self.setCloseBtnPos = function () {
            var ifr = _self.controls.bookLibIfrm[0];
            var closeBtn = ifr.contentDocument.getElementById("btn_close_booklib");
            if (closeBtn != undefined && closeBtn != null) {
                _self.buttons.btnCloseBookLib.css({top: $(closeBtn).offset().top + 2, left: $(closeBtn).offset().left});
            } else {
                var _winWidth = $(window).width();
                var _winHeight = $(window).height();
                var blockRight = (_winWidth % 331) / 2;
                _self.buttons.btnCloseBookLib.css({top: 37, right: blockRight});
            }
            _self.buttons.btnCloseBookLib.show();
            _self.buttons.btnCloseBookLib.click(function () {
                _self.hideBookLibPanel();
//                //给TA发送消息，刷新书本
//                var json = {
//                    type   : "logic",
//                    action : "refreash_ta_book",
//                    from   : "ib",
//                    to : "main"
//                };
//                socket.send(json);
            })
        }

        _self.setRenjiaoBtnPos = function(){
            //TODO:
            var ifr = _self.controls.bookLibIfrm[0];
            var closeBtn = ifr.contentDocument.getElementById("btn_close_booklib");
            if (closeBtn != undefined && closeBtn != null) {
                if($(window).width() <= 810){
                    _self.buttons.downLoadRenJiaoBook.find('input').val('下载人...');
                    _self.buttons.downLoadRenJiaoBook.css({top: 117, left: $(closeBtn).offset().left - 67});
                }else{
                    _self.buttons.downLoadRenJiaoBook.css({top: 117, left: $(closeBtn).offset().left - 100});
                }

            }
//            _self.buttons.downLoadRenJiaoBook.css('display','block');
            _self.buttons.downLoadRenJiaoBook.click(function(){
                //TODO:获取人教课本
                //1.隐藏原来书库页面
                _self.hideBookLibPanel();

                _yjBookLibMgr.showYueJiaoBookLibPanel();


            })
        }



        /**
         * 为书库返回用户信息
         * @private
         */
        _self._prepareUserAccountForBookLib = function () {
            var respJson = {};
            respJson.evt = "session_useraccount";
            //这儿有点坑，激活传0，未激活传1
            respJson.data ={
                account : ebookContext.getUser().getName(),
                isActive : ebookContext.getUser().getIsActive() ? 0 : 1 ,
                province  : ebookContext.getUser().getProvince()
            } ;
            var respJsonStr = JSON.stringify(respJson);
            return respJsonStr;
        }

        /**
         * 解析由外壳传出来的书本信息
         * @param bookJson
         * @returns {BookItem}
         */
        _self.resolveBookInfo = function (bookJson) {
            var bookItem = new BookItem();
            bookItem.id = bookJson.id;
            bookItem.title = bookJson.rawData.title;
            bookItem.file = bookJson.file;
            bookItem.thumbnail = bookJson.thumbnail;
            bookItem.bookCode = bookJson.rawData.bookCode;
            bookItem.license = bookJson.rawData.license;
            bookItem.userId = ebookContext.getUser().getName();
            bookItem.publisher = bookJson.rawData.publisher;
            bookItem.grade = bookJson.rawData.grade;
            bookItem.subject = bookJson.rawData.subject;
            bookItem.volumn = bookJson.rawData.volumn;
            bookItem.fileSize = bookJson.rawData.fileSize;

            var now = new Date();

            bookItem.downloadDate = now.getFullYear() + '-' + (now.getMonth() + 1) + '-' + now.getDate();    //获取当前时间
            console.log(bookItem);
            return bookItem;
        }

        /**
         * 刷新书架上的书，以显示修改结果
         * @param resInfo
         */
        _self.refreshBookOnShelf = function () {
            //更新余额
            ebookContext.getUser().getPointsThenSet();
            eventLogic.initAllBookList().done(function () {
                eventLogic.reNewBookSelf();
            });
        }
        /**
         * 是否写TA备课，存在就不再重复写
         * @param taDBPath
         * @param bookInfo
         * @param callback
         */
        _self.existTaDB = function(taDBPath,bookCode,callback){
            var sqlRead = 'select * from books where bookCode=\"'+bookCode+'\"';
            _shellcmd.retriveDbAsyn(taDBPath,sqlRead).done(function(ret){
                var recordArr = [];
                try{
                    recordArr = JSON.parse(ret).data;
                }catch (e){
                    console.error(e);
                }

                if(recordArr.length<1){
                    callback&&callback(recordArr);
                }else{
                    callback&&callback(recordArr);
                }
            });
        }
        /**
         * 刷新TA课本
         * @param bookInfo
         */
        _self.refreshTaDB = function(bookInfo){
            var bookCode = bookInfo.bookCode;



            //演示书不写入备课
            if(bookCode == AppCfg.testBook2){
                return;
            }

            var user = ebookContext.getUser();

            var ifbBookPath =  Config.binPath + "users/" + user.getName() + "/ebook/" + bookCode + "/";

            var taUserPath = Config.nwexePath + "ppticws/" + user.getUid() + "/";
            var taDBPath = taUserPath + "book.db";
            var taBookPath = taUserPath + "book/" + bookCode;

            var taBookMenu = taBookPath + "/" + bookCode + ".menu";
            var ifbBookMenu = ifbBookPath + bookCode + ".menu";

            var taBookPic = taBookPath + "/" + bookCode + "_Thumbnail.png";
            var ifbBookPic = ifbBookPath + bookCode + "_Thumbnail.png";

            var sqlStr = 'insert into books(id,bookCode,publisher,grade,subject,volumn,title) values("'
                + bookInfo.id + '","'
                + bookInfo.bookCode + '","'
                + bookInfo.publisher + '","'
                + bookInfo.grade + '","'
                + bookInfo.subject + '","'
                + bookInfo.volumn + '","'
                + bookInfo.title + '")';

            _self.existTaDB(taDBPath,bookInfo.bookCode,function(recordArr){
                if(recordArr.length < 1){
                    // 不存在数据库记录
                    _shellcmd.executeDbAsyn(taDBPath, sqlStr).done(function(ret){
                        if(ret){
                            _shellcmd.createDir(taBookPath).done(function(ret){
                                if(ret){
                                    _shellcmd.copyFile(ifbBookMenu, taBookMenu).done(function(){
                                        _shellcmd.copyFile(ifbBookPic, taBookPic)
                                    });
                                }
                            })
                        }
                    });
                }else{
                    //存在记录 ,这里都重新拷贝目录文件和缩略图(优化) --xinfang3
                    _shellcmd.fileOrDirExist(taBookMenu).done(function(exist){
                        if(!exist){
                            _shellcmd.copyFile(ifbBookMenu, taBookMenu);
                        }
                    });
                    _shellcmd.fileOrDirExist(taBookPic).done(function(exist){
                        if(!exist){
                            _shellcmd.copyFile(ifbBookPic, taBookPic);
                        }
                    });
                }
            });
            var  notiAddMenu = {
                method:'addMenu',
                data:{
                    userName:user._name,
                    bookName:bookInfo.title,
                    bookCode:bookCode,
                    update:true,
                    path:ifbBookMenu.replace('file:///','')
                }
            };
            hproseClient.hproseNoti(notiAddMenu);
        }
    }

    exports.BookLibraryManager = BookLibraryManager;
});