/**
 * Created by pengfu on 14-11-13.
 */
;
define(function(require,exports,module){
    function YJBookLibMgr(){
        var _self = this;
        _self.bookLibMgr = null;
        var _shellcmd = require('../../../common/shellcmd');
        var ebookContext = require('../../ebookcontext').Instance;
        var YJPageControl = require('./yjpagecontrol').YJpagerControls;
        var pageControl;
        var _bookLoader = require('../bookloader');
        var _helper = require('./yuejiaohelper');
        var _metaMap = require('../../../common/metadatamapping').Instance;

        //粤教云相关接口
//        var _baseUrl = AppSvcHelper.YJLIBSVC + "&";//在这取不到
        var _baseUrl = '';
        var _bookParam = {
            //method=ebook.list&userid=2000000017000005538&format=json&appkey=stQoOy1C&version=1.0.0&grant_type=client_credentials&access_token=a87d20eb-8072-4819-832d-9961bfea117d
            method:     'ebook.list',
            userid:     '',
            grant_type: 'client_credentials',
            grade:      '',
            subject:    '',
            page:       '',
            limit:      12

        }

        //'http://testapi.changyan.com/api?method=ebook.download&bookid=2&userid=2000000017000005538&format=json&appkey=KtSNKxk3&version=1.0.0&access_token=db199e9f-6d0b-418f-b7ba-7f4ea5cf964c',
        //书本下载参数
        var _fileDownloadParm = {
            method :  'ebook.download',
            bookid : '',
            userid : ''

        }
        //version=1.0.0&format=json&method=ebook.downLoad.info&username=yuwang@iflytek.com&bookId=2&cpuIdStr=BFEBFBFF000306A9&deviceName=test3&md5=45e99a82c9f3ac84ce10c46840d39ed6&grant_type=client_credentials&appkey=KtSNKxk3&access_token=wdfw';
        //下载配置文件参数
        var _downloadParam = {
            method:    'ebook.downLoad.info',
            username:   'yuwang@iflytek.com',
            bookId  :   '',
            cpuIdStr : 'BFEBFBFF000306A9',
            deviceName: 'test3',
            md5: '45e99a82c9f3ac84ce10c46840d39ed6',
            grant_type: 'client_credentials'
        }

        var _cataType = {
            Subject: 1,
            Grade: 2
        }

        var _catagoryParam = {
            //http://testapi.changyan.com/api?method=ebook.grade.list&format=json&appkey=stQoOy1C&version=1.0.0&grant_type=client_credentials&access_token=a5c5f676-34d0-45b7-8040-3046c2ce3a1a
            method:     '',
            grant_type: 'client_credentials'
        }

        var _currCataParm = {
            Grade: '',
            Subject : ''
        }

        var _currPage = 1;

        //当前数据库中存在的RJ课本
        var _currBookObj;

        //当前服务返回的书本列表对象
        var _currSerBook;

        var _bookTpl =  '<li class="clearfix" id="{bookCode}" bookId="{bookId}">'+
            '<div class="s_book"><img src="{imgSrcUrl}"><div class="book_progressbar" style="display: none"><p class="book_progress" style="width:0%;"></p></div></div>'+
            '<dl class="book_info">'+
            '<dt>{bookName}<p>下载数：{downloadCount}</p></dt>'+
            '<dd><p><input type="button" value="人教课本下载" class="btn_download" onMouseDown="this.className=\'btn_download2\'"onmouseout="this.className=\'btn_download\'"/></p></dd>'+
            '<dd><p><input type="button" value="取消下载" style="display: none;border:1px solid #6A9836;border-radius:3px;background:#9ac769;color:#fff;" class="btn_canceldownload" /></p></dd>'+
            '<dd><p><input type="button" value="打开课本" class="btn_open" onMouseDown="this.className=\'btn_open2\'"onmouseout="this.className=\'btn_open\'"/></p></dd>'+
            '</dl>'+
            '</li>';

        var _catagoryTpl = '<li searchPara="{catagoryName1}">{catagoryName2}</li>';

        _self.controls = {
            yuejiaoBookLibPanel:$("#yuejiaoBookLibPanel"),
            YJgradeList:$("#YJgradeList"),
            YJsubjectList:$("#YJsubjectList"),
            YJbookContainer:$("#YJbookContainer"),
            gradeListInput:$("#gradeListInput"),
            subjectListInput:$("#subjectListInput"),
            gradeListUl:$("#gradeListUl"),
            subjectListUl:$("#subjectListUl"),
            noneBooksTip:$("#noneBooksTip"),
            wrapBookContainer:$("#wrapBookContainer")
        };

        _self.buttons = {
            btnCloseYJBookLib:$("#btnCloseYJBookLib"),
            btnBack2MainBookLib:$("#btnBack2MainBookLib"),
            resetSelConBtn:$("#resetSelConBtn"),
            closeYJBookLibBtn:$("#closeYJBookLibBtn")
        };

        _self.init = function(bookLibManager){
            _baseUrl = AppSvcHelper.YJLIBSVC + "&";
            _self.bookLibMgr = bookLibManager;
            //绑定pageControl控件事件
            pageControl = new YJPageControl('yjpageControls','startBookId','endBookId','totalBookId');
            pageControl.onclick = function(index){
                _currPage = index;
                _self._getBooks(false).done(function(ret){
                    if(!_self._netIsOK(ret)){
                        return;
                    }
                    _self._appendBooks(ret);
                    pageControl.init(_currPage, _bookParam.limit, JSON.parse(ret).total);
                    pageControl.render();
                    var flag = _self._showNoBooksTipOrNot(ret);
                    if(flag){
                        return;
                    }
                    _self._bindYueJiaoBookLibEvt();
                })
            }

            //绑定关闭事件
            _self.buttons.btnCloseYJBookLib.click(function(){
                _self.hideYueJiaoBookLibPanel();
            })

            //绑定页面下面关闭事件
            _self.buttons.closeYJBookLibBtn.click(function(){
                _self.hideYueJiaoBookLibPanel();
            })
            //绑定“返回主书库”按钮事件
            _self.buttons.btnBack2MainBookLib.click(function(){
                _self.hideYueJiaoBookLibPanel();
                //先隐藏，等iframe加载完毕后一道显示
//                $("#downLoadRenJiaoBook").css('display','none');
                bookLibManager.showBookLibPanel();
            })

            //绑定“年级”下拉框事件
            _self.controls.YJgradeList.on('click',function(){
                _self.getCataList(_cataType.Grade).done(function(ret){
                    var JsonRlt = JSON.parse(ret);
                    console.log(JsonRlt);
                    //将年级列表进行排序
                    JsonRlt.sort(_helper.sortByAttr('code'));
                    _self.appendCataList(_cataType.Grade,JsonRlt);
                    _self.showCatagorys(_cataType.Grade);
                });
            })

            //绑定“学科”下拉框事件
            _self.controls.YJsubjectList.on('click',function(){
                _self.getCataList(_cataType.Subject).done(function(ret){
                    var JsonRlt = JSON.parse(ret);
                    console.log(JsonRlt);
                    _self.appendCataList(_cataType.Subject,JsonRlt);
                    _self.showCatagorys(_cataType.Subject);
                });

            })

            //绑定“重置筛选”按钮事件
            _self.buttons.resetSelConBtn.on('click',function(){
                _self.controls.gradeListInput.val("全部");
                _self.controls.subjectListInput.val("全部");
                _bookParam.grade = _currCataParm.Grade = '';
                _bookParam.subject = _currCataParm.Subject = '';
                _self._getBooks(false).done(function(ret){
                    if(!_self._netIsOK(ret)){
                        return;
                    }
                    _self._appendBooks(ret);
                    pageControl.init(_currPage, _bookParam.limit, JSON.parse(ret).total);
                    pageControl.render();
                    var flag = _self._showNoBooksTipOrNot(ret);
                    if(flag) return;
                    _self._bindYueJiaoBookLibEvt();
                })

            })

            //将获取到的结果append到Dom结构上
            _self.appendCataList = function(type,json){
                var cataTpl = _catagoryTpl;
                var cataStr = '<li searchPara="">全部</li>';

                var count = json.length;
                if(type === _cataType.Subject){
                    _self.controls.subjectListUl.empty();
                    for(var i= 0;i < count; i++){
                        cataStr += cataTpl.replace("{catagoryName1}",json[i].name).replace("{catagoryName2}",json[i].name);

                    }
                    _self.controls.subjectListUl.append(cataStr);
                }else if(type === _cataType.Grade){
                    _self.controls.gradeListUl.empty();
                    for(var j= 0; j< count; j++){
                        cataStr += cataTpl.replace("{catagoryName1}",json[j].name).replace("{catagoryName2}",json[j].name);
                    }
                    _self.controls.gradeListUl.append(cataStr);
                }
            }

            //显示种类列表
            _self.showCatagorys = function(type){
                //显示
                if(type === _cataType.Subject){
                    _self.controls.subjectListUl.show();

                }else if(type === _cataType.Grade){
                    _self.controls.gradeListUl.show();
                }
                //绑定事件
                _self.bindCataEvt(type);
            }

            //绑定下拉列表里面的相关事件
            _self.bindCataEvt = function(type){
                if(type === _cataType.Grade){
                    _self.controls.gradeListUl.find('li').mouseover(function(){
                        $(this).addClass('pick');
                    });
                    _self.controls.gradeListUl.find('li').mouseout(function(){
                        $(this).removeClass();
                    });
                    _self.controls.gradeListUl.mouseleave(function(){
                        $(this).hide();
                    });
                    _self.controls.gradeListUl.find('li').unbind('click').click(function(){
                        _self.controls.gradeListUl.hide();
                        var text = $(this)[0].innerHTML;
                        _self.controls.gradeListInput.val(text);
                        _currCataParm.Grade = $(this).attr('searchPara');
                        _bookParam.grade = _currCataParm.Grade;

                        //在这执行一次查询
                        _self._getBooks(true).done(function(ret){
                            if(!_self._netIsOK(ret)){
                                return;
                            }
                            _self._appendBooks(ret);
                            pageControl.init(1, _bookParam.limit, JSON.parse(ret).total);
                            pageControl.render();
                            var flag = _self._showNoBooksTipOrNot(ret);
                            if(flag) return;
                            _self._bindYueJiaoBookLibEvt();
                        })

                    })
                }else if(type === _cataType.Subject){
                    _self.controls.subjectListUl.find('li').mouseover(function(){
                        $(this).addClass('pick');
                    });
                    _self.controls.subjectListUl.find('li').mouseout(function(){
                        $(this).removeClass();
                    });
                    _self.controls.subjectListUl.mouseleave(function(){
                        $(this).hide();
                    });
                    _self.controls.subjectListUl.find('li').unbind('click').click(function(){
                        _self.controls.subjectListUl.hide();
                        var text = $(this)[0].innerHTML;
                        _self.controls.subjectListInput.val(text);
                        _currCataParm.Subject = $(this).attr('searchPara');
                        _bookParam.subject = _currCataParm.Subject;

                        //在这执行一次查询
                        _self._getBooks(true).done(function(ret){
                            if(!_self._netIsOK()){
                                return;
                            }
                            _self._appendBooks(ret);

                            pageControl.init(1, _bookParam.limit, JSON.parse(ret).total);
                            pageControl.render();
                            var flag = _self._showNoBooksTipOrNot(ret);
                            if(flag){
                                return;
                            }
                            _self._bindYueJiaoBookLibEvt();
                        })

                    })
                }
            }

            _self._netIsOK = function(ret){
                return ret !== '';
            }

            _self._showNoBooksTipOrNot = function(ret){
                var json = JSON.parse(ret);
                if(json.total === 0){
                    _self.controls.noneBooksTip.show();
                    _self.controls.YJbookContainer.hide();
                    return true;
                }else{
                    _self.controls.noneBooksTip.hide();
                    _self.controls.YJbookContainer.show();
                    return false;
                }

            }

            //获取种类列表
            _self.getCataList = function(catagory){
                //http://testapi.changyan.com/api?method=ebook.grade.list&format=json&appkey=stQoOy1C&version=1.0.0&grant_type=client_credentials&access_token=a5c5f676-34d0-45b7-8040-3046c2ce3a1a
                var defer = $.Deferred();

                if(catagory === _cataType.Subject){
                    _catagoryParam.method = 'ebook.subject.list';
                }else if(catagory === _cataType.Grade){
                    _catagoryParam.method = 'ebook.grade.list';
                }
                var catagoryUrl = _baseUrl + $.param(_catagoryParam);
                var baseTokeUrl = AppSvcHelper.CYToken +"&";
                _helper.getHttpRequestByToken(baseTokeUrl,catagoryUrl).done(function(rlt){
                    if(rlt === ''){
                        _self._handleBadNetWork();
                    }
                    defer.resolve(rlt);
                })


                return defer.promise();
            }

        }

        //显示粤教版书库界面
        _self.showYueJiaoBookLibPanel = function(){

            if (!ebookContext.getUser().getIsOnline()) {
                $.Zebra_Dialog(AppTips.LocalLoignMsg, {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                return;
            }

            _shellcmd.checkOnline().done(function(ret){
                if(!ret){
                    $.Zebra_Dialog(AppTips.NetWorkUnstable, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                }else{
                    _self.controls.yuejiaoBookLibPanel.show();
                    //打开书库执行一次查询
                    _self._getBooks(true).done(function(ret){
                        if(!_self._netIsOK(ret)){
                            return;
                        }

                        //获取数据库中的粤教课本
                        _self._getLocalDBbooks().done(function(bookObj){
                            _currBookObj = bookObj;
                            _self._appendBooks(ret);
                            pageControl.init(1, _bookParam.limit, JSON.parse(ret).total);
                            pageControl.render();
                            var flag = _self._showNoBooksTipOrNot(ret);
                            if(flag){
                                return;
                            }
                            _self._bindYueJiaoBookLibEvt();
                        })

                    })
                }
            })



        }

        //获取书本
        _self._getBooks = function(flag){
            var defer = $.Deferred();

            var userId = ebookContext.getUser().getUid();
            console.log(userId);
            //TODO:用真实的userId
                _bookParam.userid = userId;
//            _bookParam.userid = '2000000017000005538';
            if(flag){
                //显示第一页
                _bookParam.page = 1;
            }else{
                _bookParam.page = _currPage;
            }
            //根据分辨率做一些适应
            var widowWidth = $(window).width();
            var windowHeight = $(window).height();
            var browserWidth = _self.controls.wrapBookContainer[0].offsetWidth;
            var bookRowNum;
            var bookColNum = Math.floor(browserWidth / 330);
            if(widowWidth == 1024){
                bookColNum = 3;
            }
            $(".stack_box").css("width", bookColNum * 331 + "px");
            if (windowHeight < 710) {
                $(".stack_box").css("height", "510px");
                bookRowNum = 2;
            } else {
                $(".stack_box").css("height", "683px");
                bookRowNum = 3;
            }
            if(widowWidth == 800){
                _self.buttons.closeYJBookLibBtn.hide();
                $("#YJYBookId").hide();
            }
            $(".stack_box").css("margin", "0 auto");
            $(".stack_box").css("margin-top", "35px");
            _bookParam.limit = bookColNum * bookRowNum;

            var bookListUrl = _baseUrl + $.param(_bookParam);
            var baseTokeUrl = AppSvcHelper.CYToken +"&";
            _helper.getHttpRequestByToken(baseTokeUrl,bookListUrl).done(function(bookRet){
                console.log(bookRet);
                if(bookRet !== ''){
                    _currSerBook = JSON.parse(bookRet);
                }else{
                    _self._handleBadNetWork();
                }
                defer.resolve(bookRet);
            })


            return defer.promise();
        }

        //从本地数据库中获取书本列表（已经下载的书本会写记录到该数据库中）
        _self._getLocalDBbooks = function(){
            var defer = $.Deferred();
            var dbpath = ebookContext.getUser().getUserDbFullPath();
            //TODO:sql语句
            var sqlquery = "select bookCode from Books where mtbkId = 'RJ'";
//            var sqlquery = "select bookCode from Books where isNew = '1'";

            _shellcmd.retriveDbAsyn(dbpath,sqlquery).done(function(ret){
                var bookObj = JSON.parse(ret);
                defer.resolve(bookObj);
            })
            return defer.promise();
        }

        //判断某本书是否在本地已经存在
        _self._isBookExsist = function(bookCode,bookObj){
            for(var i= 0,count = bookObj.data.length; i < count; i++){
                if(bookCode == bookObj.data[i].bookcode){
                    return true;
                }
            }
            return false;
        }

        //将获取的书本结果append到dom结构中
        _self._appendBooks = function(result){
            var rltJson = {};
            if(result === '' ){
                return;
            }else {
                rltJson = JSON.parse(result);
                if(rltJson.total === 0){
                    //没有资源
                    return;
                }
            }
            //先将dom结构empty
            _self.controls.YJbookContainer.empty();

            for(var i= 0, count = rltJson.data.length; i < count ;i++){
                var booktpl = _bookTpl;
                //TODO：没有上下册？
//                var bookname = rltJson.data[i].subject + '人教'+rltJson.data[i].grade;
                 var bookname = rltJson.data[i].name;
                if(bookname.length > 25){
                    bookname = bookname.substr(0,25)+'...';
                }
                var imgsrc = rltJson.data[i].thumUrl?rltJson.data[i].thumUrl:'./assert/images/book_touming.png';
                var bookCode = rltJson.data[i].bookCode;
                var bookId = rltJson.data[i].bookId;
                booktpl = booktpl.replace("{bookName}",bookname)
                    .replace("{downloadCount}",rltJson.data[i].downloadCount)
                    .replace("{imgSrcUrl}",imgsrc)
                    .replace("{bookId}",bookId)
                    .replace("{bookCode}",bookCode);
                var tplDom = $(booktpl);

                var isExsist = _self._isBookExsist(bookCode,_currBookObj);
                if(isExsist){
                    tplDom.find('.btn_download').css('display','none');
                }else{
                    tplDom.find('.btn_open').css('display','none');
                }
//                tplDom.find('.btn_openbook').css('display','none');
//                tplDom.find('.btn_download').css('display','none');
                _self.controls.YJbookContainer.append(tplDom);
//                _self.controls.YJbookContainer.append(booktpl);
            }

        }

        //绑定粤教书库事件
        _self._bindYueJiaoBookLibEvt = function(){

           //绑定下载课本
           _self.controls.YJbookContainer.find('.btn_download')
               .on('click',function(){
                   //点击了下载课本按钮，隐藏自身，同时显示取消下载按钮
                   $(this).hide();
                   $(this).parent().parent().parent().find('.btn_canceldownload').show();
                   var i = $(this).parents('li').index();
                   var bookCode = _currSerBook.data[i].bookCode,
                       bookId = _currSerBook.data[i].bookId,
                       thumUrl = _currSerBook.data[i].thumUrl,
                       title = '人教'+_currSerBook.data[i].subject + _currSerBook.data[i].grade;

                   var gradeCode = _metaMap.gradeParse(_currSerBook.data[i].grade);
                   var volumCode = _metaMap.gradeParse(_currSerBook.data[i].grade);

                   var bookJson = {
                       'bookCode' : bookCode,
                       'dbpath' :  ebookContext.getUser().getUserDbFullPath(),
//                       'file' : 'http://testapi.changyan.com/api?method=ebook.download&bookid=2&userid=2000000017000005538&format=json&appkey=KtSNKxk3&version=1.0.0&access_token=db199e9f-6d0b-418f-b7ba-7f4ea5cf964c',
                       'file':'',
                       'filesavename' : bookCode + '.book2',
                       'id': bookCode,
                       'moreparam' :'true',
                       'savepath': 'Bkplayer/books/'+bookCode,
                       'sourcepage' : 'yjbooklib',
                       'thumbnail':thumUrl,
                       'title' :title,
                       'thumbnailsavename' : bookCode + '.jpg',
                       'publisher' : '',
                       'grade': gradeCode,
                       'subject':'',
                       'volumn' : '',
                       'license':'',
                       'userId' : '',
                       'fileSize' : ''
                   };
                   _fileDownloadParm.bookid = bookId;
                   _fileDownloadParm.userid = ebookContext.getUser().getUid();
                   //TODO:userid写死
//                   _fileDownloadParm.userid = '2000000017000005538';
                   var downloadBookParam = _baseUrl + $.param(_fileDownloadParm);
                   var baseTokeUrl = AppSvcHelper.CYToken +"&";
                   _helper.getAccTok(baseTokeUrl).done(function(ret){
                       if(ret){
                           downloadBookParam = downloadBookParam +'&access_token='+ret;
                           bookJson.file = downloadBookParam;

                           $("#"+bookCode).find('.book_progressbar').css('display','block');

                           _shellcmd.fileDownload(JSON.stringify(bookJson));
                       }else{
                           //网络问题
                           _self._handleBadNetWork();
                       }
                   })



               });

            //绑定取消下载课本事件
            _self.controls.YJbookContainer.find('.btn_canceldownload')
                .on('click',function(){
                    var liDom = $(this).parents('li');
                    var i = liDom.index();
                    var id = _currSerBook.data[i].bookCode;
                    _shellcmd.cancleDownload(id).done(function(){
                        liDom.find('.btn_canceldownload').hide();
                        liDom.find('.btn_download').show();
                        liDom.find('.book_progressbar').hide();
                        liDom.find('.book_progress').css('width','0%');

                    })

                })

            //绑定打开课本事件
            _self.controls.YJbookContainer.find('.btn_open')
                .on('click',function(){
                    var i =$(this).parents('li').index();
                    //TODO:
                    var username = ebookContext.getUser().getName();
                    var bookCode = _currSerBook.data[i].bookCode;
                    _bookLoader.openYJReader(username,bookCode);
                })

        }

        //隐藏粤教书库界面
        _self.hideYueJiaoBookLibPanel = function(){
            _self.controls.yuejiaoBookLibPanel.hide();
//            _self.bookLibMgr.refreshBookOnShelf();
        }

        _self.onMessageReceived = function(obj){
            if (obj.evt == 'file_download') {
                if (obj.data.sourcepage == 'yjbooklib') {

                    if(obj.data.progress <= 1){
                       var pro = Number(obj.data.progress) * 100 + "%";
                        console.log(pro);
                       $("#"+obj.data.id).find('.book_progress').css('width',pro);
                    }
                    //下载完成
                    if(obj.data.progress >= 2){
                       $("#"+obj.data.id).find('.book_progressbar').css('display','none');
                        //下载完成后将下载课本按钮、取消下载按钮隐藏，将打开课本按钮显示
                       $("#"+obj.data.id).find('.btn_download').hide();
                        $("#"+obj.data.id).find('.btn_canceldownload').hide();
                        //$("#"+obj.data.id).find('.btn_open').show();
//                       var sqlQuery = 'update Books set mtbkId = "RJ" where bookCode = "1111"';
                        var sqlQuery = 'update Books set mtbkId = "RJ" where bookCode = '+ '"'+obj.data.id+'"';
                       var dbPath = ebookContext.getUser().getUserDbFullPath();
                       _shellcmd.executeDbAsyn(dbPath,sqlQuery);
                        // 下载后解压书本至unzip目录下
                       var sourceFilePath = obj.data.file;
                       var desFilePath = obj.data.rawData.savepath + '/unzip';
                       _shellcmd.FileUnzip(sourceFilePath , desFilePath).done(function(ret){
                           if (ret != 0 ){
                               var sqlQuery = 'delete from Books where bookCode = '+ '"'+obj.data.id+'"';
                               var dbPath = ebookContext.getUser().getUserDbFullPath();
                               _shellcmd.executeDbAsyn(dbPath,sqlQuery);
                               console.log("unzip failed, maybe there is no any resources");
                               _self._handleResources();
                               $("#"+obj.data.id).find('.btn_download').show();
                               //$("#"+obj.data.id).find('.btn_canceldownload').show();
                               $("#"+obj.data.id).find('.btn_open').hide();

                           }else{
                               $("#"+obj.data.id).find('.btn_open').show();
                               console.log($("#"+obj.data.id).attr("bookId"));
                               var bookId = $("#"+obj.data.id).attr("bookId");
                               _downloadParam.bookId = bookId;
                               //getCpuId
                               var workPath = Config.binPath + 'Bkplayer/win/';
                               var command = 'cpuid.exe';
                               _shellcmd.getCpuId(command , workPath).done(function(ret){
                                   ret = ret.replace('\n','')  ;//delphi 处理时多一个换行，交给JS处理
                                   ret = ret.trim();
                                   if(ret != ''){
                                       _downloadParam.cpuIdStr = ret;
                                       // 获取base64的config文件串;
                                       _downloadParam.username = ebookContext.getUser().getName();
                                       var encodeStrUrl = _baseUrl + $.param(_downloadParam);
                                       var encodeStr = '';
                                       var baseTokeUrl = AppSvcHelper.CYToken +"&";
                                       _helper.getHttpRequestByToken(baseTokeUrl,encodeStrUrl).done(function(data){
                                           if(data){
                                               data = JSON.parse(data);
                                               encodeStr = data.ecodeStr;
                                               //  encodeStr = '8x2rVhEFaFBHPtjNgUKcjIBBzi8AYLtQ9ViIUKwKN4Seq3iiFS50JABw000WsSEEGZjO4c3EiPzaELdZxHnSvbkGkfTu/01HcVPgzeWOaSi2rB8Kq4mPj25kn/64u1GtKwgukB0B7Bv2lNsErBHNvy/BUcLNC/kjISKAXHOE1vI=';
                                               var configSavePath = obj.data.rawData.savepath + '/config.config';
                                               var commandArgs = encodeStr + ' ' + configSavePath;
                                               //转成二进制文件串
                                               var decodeToolPath ='Bkplayer/PEPConfig.exe';
                                               _shellcmd.shellexecutewithargs(decodeToolPath , commandArgs);
                                               var sqlQuery =  'update Books set isNew = "0" where bookCode = '+ '"'+obj.data.id+'"';
                                               var dbPath = ebookContext.getUser().getUserDbFullPath();
                                               _shellcmd.executeDbAsyn(dbPath,sqlQuery);
                                               _self.bookLibMgr.refreshBookOnShelf();
                                           }else{//config 串获取失败时的异常处理，初步定为网络错误；
                                               _self._handleBadNetWork();
                                               var sqlQuery = 'delete from Books where bookCode = '+ '"'+obj.data.id+'"';
                                               var dbPath = ebookContext.getUser().getUserDbFullPath();
                                               _shellcmd.executeDbAsyn(dbPath,sqlQuery);

                                           }
                                       })
                                   }else{
                                       // cpuId获取失败时的异常处理
                                       var sqlQuery = 'delete from Books where bookCode = '+ '"'+obj.data.id+'"';
                                       var dbPath = ebookContext.getUser().getUserDbFullPath();
                                       _shellcmd.executeDbAsyn(dbPath,sqlQuery);
                                   }
                               });

                           }
                        });

                    }
                }
            }
        }

        _self._handleBadNetWork = function(){
            $.Zebra_Dialog(AppTips.NetWorkUnstable, {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [ AppTips.OkTips],
                'zIndex': 1000
            });
        }

        _self._handleResources = function(){
            $.Zebra_Dialog("资源下载失败，请重试", {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [ AppTips.OkTips],
                'zIndex': 1000
            });
        }

    }
    exports.Instance = new YJBookLibMgr();
})